(ns mascip.debug
  (:require [clojure.string :as s]
            [puget.printer  :refer :all]
            [robert.hooke   :refer :all]
  ))

"Acknowledgement:
 - The (c) function is inspired by Micheal Feather's c function for Ruby, in his article \"Literate Chains for Functional Programming\"
 - (dbg) was written by John Lawrence Aspden and I found it on Stackoverflow: http://stackoverflow.com/questions/2352020/debugging-in-clojure"

(defmacro dbg
  "Try this:
  (println (+ (* 2 3) (dbg (* 8 9))))
  => dbg: (* 8 9) = 72
  "
  [x]
  `(let [x# ~x] (println "dbg:" '~x "=" x#) x#))

(defn c [data s]
  "A comment that helps you debug your -> thread chains! Is takes data in and passes the same data out. For example:
  (-> [1 2] (c \"The vector\") reverse (c \"Reversed\"))
  => [2 1]
  It's just like a comment... but you can turn it into (cs) so it will print the comment followed by the data sctructure passed in. You can also use (show) to 'switch on' all the (c) functions in a given scope"
  data)

(defn cs [data s]
  "A debugging tool for ->> thread chains. Takes data in, returns the same data out, and prints your comment followed by the data. Can be switched off by turning it into (c)"
  (println s) (cprint data)
  data)

(defn c-print [f data s]
  ; FIXME: update doc
  "Add it as a hook on the (c) function, to 'switch it on' and make it behave like (cs) as long as the hook is added.
  For this, you have to wrap the code where you want to 'switch on' (c) into
  (with-scope (add-hook #'c #'c-print) ...your code here... ).
  For this you need to declare [robert.hook :refer :all] as a dependency...but I will soon create a macro so the syntax is simpler and you don't need to declare anything extra."
  (println s) (cprint data)
  data
  ; (f s data) ; FIXME should be just data?
)
(defn cc [s data]
  "A comment that helps you debug your ->> thread chains! Is takes data in and passes the same data out. For example:
  (->> [1 2] (cc \"The vector\") reverse (cc \"Reversed\"))
  => [2 1]
  It's just like a comment... but you can turn it into (ccs) so it will print the comment followed by the data sctructure passed in. You can also use (show) to 'switch on' all the (cc) functions in a given scope"
  data)

(defn ccs [s data]
  "A debugging tool for ->> thread chains. Takes data in, returns the same data out, and prints your comment followed by the data. Can be switched off by turning it into (cc)"
  (println s) (cprint data)
  data)

(defn cc-print [f s data]
  ; FIXME: update doc
  "Add it as a hook on the (c) function, to 'switch it on' and make it print the chained data in a given scope.
  For this, you have to wrap the code where you want to 'switch on' (c) into
  (with-scope (add-hook #'c #'c-print) ...your code here... ).
  For this you need to declare [robert.hook :refer :all] as a dependency...but I will soon create a macro so the syntax is simpler and you don't need to declare anything extra."
  (println s) (cprint data)
  ; data
  (f s data) ; FIXME should be just data?
)

(defmacro show [& forms]
  "Hooks (c-print) to (c), so that it now behaves like (cs). Same with (cc)"
   (use 'robert.hooke)
  `(robert.hooke/with-scope (robert.hooke/add-hook #'c #'c-print) (robert.hooke/add-hook #'cc #'cc-print)
     ~@forms ; Just the same forms as they were
   )
)

(defmacro ident [& forms]
  (apply identity forms))

