(ns mascip.debug
  (:require [clojure.string :as s]
            [clojure.data :as d]
            [robert/hooke :refer :all]
            ))

(defmacro dbg
  "Try this:
  (println (+ (* 2 3) (dbg (* 8 9))))
  => dbg: (* 8 9) = 72
  Found here: http://stackoverflow.com/questions/2352020/debugging-in-clojure
  "
  [x]
  `(let [x# ~x] (println "dbg:" '~x "=" x#) x#))

(defn c-print [f s data]
  "Use it as a hook to the (c) function, to make it switch it on in a given scope"
  (println s) (prn data))

(defn c [s data]
  "(c) and (cc) are great for debugging in a ->> thread macro.
  (c) takes the data it receives, and just passes it down.
  (cc) does the same, but prints the given String and the Data.
  You can easily turn (c) into (cc) in your code, in order to get some debug info.
  If you want to \"switch on\" all (c) functions so they all print data, you can just uncomment that one line in the (c) function source code. In the near future this will be implemented with a hook, and so that you can switch it on in a given scope without needing to touch its source code.
  PS: I (mascip) would be very happy for someone to show me a better way to do this, perhaps throught the REPL?
  PPS: The name (c) stands for \"comment\", because it looks like a comment in the code. But a useful one for debugging.
  Inspired from Micheal Feather's c function for ruby, in his article Literate Chains for Functional Programming"
  ; (println s) (prn data) ; ***UNCOMMENT*** this line to get debugging (will be replaced by an eternal hook, but I can't use a hook in exercism.io)
  data)

(defn cc [s data]
  "(c) and (cc) are great for debugging in a ->> thread macro.
  (c) takes the data it receives, and just passes it down.
  (cc) does the same, but prints the given String and the Data.
  You can easily turn (c) into (cc) in your code, in order to get some debug info.
  If you want to \"switch on\" all (c) functions so they all print data, you can just uncomment that one line in the (c) function source code. In the near future this will be implemented with a hook, and so that you can switch it on in a given scope without needing to touch its source code.
  PS: I (mascip) would be very happy for someone to show me a better way to do this, perhaps throught the REPL?
  PPS: The name (c) stands for \"comment\", because it looks like a comment in the code. But a useful one for debugging.
  Inspired from Micheal Feather's c function for ruby, in his article Literate Chains for Functional Programming  "
  (println s) (prn data)
  data)

(defn diff [s1 s2]
  "To find where is the difference between two strings:
  (diff \"fabler\" \"cable\") => \"f    r"\"
  (->> [s1 s2]
       (map (partial into []))  ; str->chars
       (apply d/diff)           ; diff
       (first)                  ; only keep diff on first string
       (map #(if (= % nil) " " %))(s/join))) ; chars->str. nil elements are replaced by a space
