/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.AWSSessionCredentials;

public class MyRestS3Service
extends RestS3Service {
    public AWSCredentials credentials = null;

    public MyRestS3Service(AWSCredentials awsCredentials) throws S3ServiceException {
        this(awsCredentials, null, null);
    }

    public MyRestS3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider) throws S3ServiceException {
        this(awsCredentials, invokingApplicationDescription, credentialsProvider, Jets3tProperties.getInstance((String)Constants.JETS3T_PROPERTIES_FILENAME));
    }

    public MyRestS3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) throws S3ServiceException {
        this(awsCredentials, invokingApplicationDescription, credentialsProvider, jets3tProperties, new HostConfiguration());
    }

    public MyRestS3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties, HostConfiguration hostConfig) throws S3ServiceException {
        super(awsCredentials, invokingApplicationDescription, credentialsProvider, jets3tProperties, hostConfig);
        this.credentials = awsCredentials;
    }

    protected HttpMethodBase setupConnection(String method, String bucketName, String objectKey, Map requestParameters) throws S3ServiceException {
        HttpMethodBase httpMethod = super.setupConnection(method, bucketName, objectKey, requestParameters);
        if (this.credentials instanceof AWSSessionCredentials) {
            String sessionToken = ((AWSSessionCredentials)this.credentials).getSessionToken();
            httpMethod.setRequestHeader("x-amz-security-token", sessionToken);
        }
        return httpMethod;
    }
}

