## What is ClojureScript? ##

ClojureScript is a new compiler for [Clojure](http://clojure.org) that targets JavaScript. It is designed to emit JavaScript code which is compatible with the advanced compilation mode of the [Google Closure](http://code.google.com/closure/) optimizing compiler.

## Releases and dependency information ##

Latest stable release: 1.7.28

* [All released versions](http://search.maven.org/#search%7Cgav%7C1%7Cg%3A%22org.clojure%22%20AND%20a%3A%22clojurescript%22)

[Leiningen](http://github.com/technomancy/leiningen/) dependency information:

```
[org.clojure/clojurescript "1.7.28"]
```

[Maven](http://maven.apache.org) dependency information:

```
<dependency>
  <groupId>org.clojure</groupId>
  <artifactId>clojurescript</artifactId>
  <version>1.7.28</version>
</dependency>
```

## Getting Started ##

* [Compare with JavaScript](http://himera.herokuapp.com/synonym.html)
* [Try it online](http://himera.herokuapp.com/index.html)
* Read the [Quick Start](https://github.com/clojure/clojurescript/wiki/Quick-Start) guide.
* Read the [Documentation](https://github.com/clojure/clojurescript/wiki).
* Try a [tutorial](https://github.com/clojure/clojurescript/wiki).
* [Companies using ClojureScript](https://github.com/clojure/clojurescript/wiki/Companies-Using-ClojureScript)

## Questions, Feedback? ##

Please point all of your questions and feedback to the
[Clojure mailing list](http://groups.google.com/group/clojure). There
is a community run
[ClojureScript user mailing list](http://groups.google.com/group/clojurescript) and
the IRC channel, `#clojurescript` on [freenode.net](https://freenode.net/), is quite active. 
There is also a community run [Slack channel](http://clojurians.slack.com). The
Jira bug/feature tracking application is located at
<http://dev.clojure.org/jira/browse/CLJS>. Before submitting issues
please read the
[Reporting Issues](https://github.com/clojure/clojurescript/wiki/Reporting-Issues)
page first.

## Developers Welcome ##

ClojureScript operates under the same license as Clojure. All
contributors must have a signed CA (Contributor's Agreement) and
submit their patch via the appropriate channels. If you're interested
in contributing to the project, please see the
[contributing](http://clojure.org/contributing) page on
[clojure.org](http://clojure.org). For more information about working
on the compiler and testing check the
[Developer section of the wiki](http://github.com/clojure/clojurescript/wiki/Developers).

YourKit
----

<img src="http://www.yourkit.com/images/yklogo.png"></img>

YourKit has given an open source license for their profiler, greatly simplifying the profiling of ClojureScript performance.

YourKit supports open source projects with its full-featured Java Profiler.
YourKit, LLC is the creator of <a href="http://www.yourkit.com/java/profiler/index.jsp">YourKit Java Profiler</a>
and <a href="http://www.yourkit.com/.net/profiler/index.jsp">YourKit .NET Profiler</a>,
innovative and intelligent tools for profiling Java and .NET applications.

## License ##

    Copyright (c) Rich Hickey. All rights reserved. The use and
    distribution terms for this software are covered by the Eclipse
    Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
    which can be found in the file epl-v10.html at the root of this
    distribution. By using this software in any fashion, you are
    agreeing to be bound by the terms of this license. You must
    not remove this notice, or any other, from this software.
