(ns ^{:doc "Custom implementation of RemoteWebDriver, adding support for screenshots."}
  clj-webdriver.ext.remote.RemoteWebDriverExt
  (:import [org.openqa.selenium.remote DriverCommand RemoteWebDriver])
  (:require [clojure.tools.logging :as lg])
  (:gen-class
   :main false
   :extends org.openqa.selenium.remote.RemoteWebDriver
   :implements [org.openqa.selenium.TakesScreenshot]
   :exposes-methods {init superInit
                     startSession superStartSession
                     execute superExecute}))

(defn -init [this desired-caps required-caps]
  (lg/info "initting" desired-caps required-caps)
  (let [re (.superInit this desired-caps required-caps)]
    (lg/info "finished init")
    re))

(defn -startSession [this desired-caps & [required-caps]]
  (lg/info "starting session" desired-caps required-caps)
  (let [re (.superStartSession this desired-caps required-caps)]
    (lg/info "started session")
    re))

(defn -execute [this cmd & [options]]
  (if options
    (do (lg/info "running execute" cmd options)
        (let [re (.superExecute this cmd options)]
          (lg/info "ran execute" re)
          re))
    (.superExecute this cmd)))

(defn -log [this session-id command-name to-log when-log]
  (when (or true (-> (System/getenv "RFZ_QA_SERVER") (= "rfz-selenium")))
    (lg/info "SELENIUM!!!" session-id command-name to-log when-log)))

(defn -getScreenshotAs
  [this target]
  (let [base64 (->> DriverCommand/SCREENSHOT
                    (.execute this)
                    .getValue
                    str)]
    (.convertFromBase64Png target base64)))








