(ns net.markokrstic.lib.validator)

(defn- validate-field
  [data field schema attr check]
  (if (contains? schema attr)
    (check data field schema attr)
    #{}))

(defn- validate-fields
  [data field schema]
  (set (concat
         (validate-field data field schema :type #(if ((%4 %3) (get %1 %2)) [] [(str (name field) " is a wrong type")]))
         (validate-field data field schema :min-length #(if (>= (count (get %1 %2)) (%4 %3)) [] [(str "minimal length for " (name field) " is " (%4 %3))]))
         (validate-field data field schema :max-length #(if (<= (count (get %1 %2)) (%4 %3)) [] [(str "maximal length for " (name field) " is " (%4 %3))])))))

(defn validate
  "Checks if data is a valid schema.
  Schema example: {:age {:required false :type number?} :text {:required true :type string? :max-length 20}}
  Data example: {:age 12 :text \"Hoo\"}
  Mandatory validator: :required [true false]
  Optional validators:
    :type [string? number? ...]
    :min-length [number]
    :max-length [number]"
  [data schema]
  (reduce (fn [m [k v]]
            (if (true? (:required v))
              (let [errors (set (concat
                                  (if (contains? data k) [] [(str (name k) " is required")])
                                  (validate-fields data k v)))]
                {:valid? (= (+ (count errors) (:error-num m)) 0) :error-num (+ (count errors) (:error-num m)) :errors (set (concat errors (:errors m)))})
              (if (contains? data k)
                (let [errors (validate-fields data k v)]
                  {:valid? (= (+ (count errors) (:error-num m)) 0) :error-num (+ (count errors) (:error-num m)) :errors (set (concat errors (:errors m)))})
                m)))
          {:valid? true :error-num 0 :errors #{}} schema))