(ns net.markokrstic.lib.framework.config
  (:require [environ.core :refer [env]]))

(defn- evaluate-env-variable
  ([variable]
   (evaluate-env-variable variable ""))
  ([variable default]
   (if (env variable) (env variable) default)))

(defn- evaluate-map
  [m]
  (reduce (fn [new-map [k v]]
            (cond
              (vector? v) (assoc new-map k (evaluate-env-variable (first v)))
              (map? v) (assoc new-map k (evaluate-map v))
              :default (assoc new-map k v)))
          {} m))

(defn- load-config
  []
  (evaluate-map (clojure.edn/read-string (slurp (str "config/" (evaluate-env-variable :active-env "dev") ".edn")))))

(def config (load-config))