(ns net.markokrstic.lib.error)

(defn error?
  [error]
  (and (map? error) (contains? error :content) (contains? error :type) (contains? error :stack) (contains? error :built-in) (= (:built-in error) :mk-error)))

(defn new-error
  ([content]
   (new-error content :general))
  ([content type]
   {:content content :type type :stack {} :built-in :mk-error}))

(defn wrap-if-error
  [content error]
  (if (error? error)
    {:content content :type :wrap :stack {:error error} :built-in :mk-error}
    error))

(defn cause
  [error]
  (if (empty? (:stack error))
    error
    (cause (:error (:stack error)))))