// Compiled by ClojureScript 1.10.773 {}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer.call(null,writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count.call(null,self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item = cljs.core.first.call(null,cljs.core.val.call(null,f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key.call(null,f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item_set = cljs.core.val.call(null,f);
var item = cljs.core.first.call(null,item_set);
var priority_key = cljs.core.key.call(null,f);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__23579(s__23580){
return (new cljs.core.LazySeq(null,(function (){
var s__23580__$1 = s__23580;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__23580__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__23585 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__23585,(0),null);
var item_set = cljs.core.nth.call(null,vec__23585,(1),null);
var iterys__4525__auto__ = ((function (s__23580__$1,vec__23585,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__23579_$_iter__23581(s__23582){
return (new cljs.core.LazySeq(null,((function (s__23580__$1,vec__23585,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function (){
var s__23582__$1 = s__23582;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__23582__$1);
if(temp__5735__auto____$1){
var s__23582__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23582__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__23582__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__23584 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__23583 = (0);
while(true){
if((i__23583 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__23583);
cljs.core.chunk_append.call(null,b__23584,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__23633 = (i__23583 + (1));
i__23583 = G__23633;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23584),tailrecursion$priority_map$iter__23579_$_iter__23581.call(null,cljs.core.chunk_rest.call(null,s__23582__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23584),null);
}
} else {
var item = cljs.core.first.call(null,s__23582__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__23579_$_iter__23581.call(null,cljs.core.rest.call(null,s__23582__$2)));
}
} else {
return null;
}
break;
}
});})(s__23580__$1,vec__23585,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
,null,null));
});})(s__23580__$1,vec__23585,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__23579.call(null,cljs.core.rest.call(null,s__23580__$1)));
} else {
var G__23634 = cljs.core.rest.call(null,s__23580__$1);
s__23580__$1 = G__23634;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__23588(s__23589){
return (new cljs.core.LazySeq(null,(function (){
var s__23589__$1 = s__23589;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__23589__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__23594 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__23594,(0),null);
var item_set = cljs.core.nth.call(null,vec__23594,(1),null);
var iterys__4525__auto__ = ((function (s__23589__$1,vec__23594,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__23588_$_iter__23590(s__23591){
return (new cljs.core.LazySeq(null,((function (s__23589__$1,vec__23594,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function (){
var s__23591__$1 = s__23591;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__23591__$1);
if(temp__5735__auto____$1){
var s__23591__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23591__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__23591__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__23593 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__23592 = (0);
while(true){
if((i__23592 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__23592);
cljs.core.chunk_append.call(null,b__23593,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__23635 = (i__23592 + (1));
i__23592 = G__23635;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23593),tailrecursion$priority_map$iter__23588_$_iter__23590.call(null,cljs.core.chunk_rest.call(null,s__23591__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23593),null);
}
} else {
var item = cljs.core.first.call(null,s__23591__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__23588_$_iter__23590.call(null,cljs.core.rest.call(null,s__23591__$2)));
}
} else {
return null;
}
break;
}
});})(s__23589__$1,vec__23594,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
,null,null));
});})(s__23589__$1,vec__23594,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__23588.call(null,cljs.core.rest.call(null,s__23589__$1)));
} else {
var G__23636 = cljs.core.rest.call(null,s__23589__$1);
s__23589__$1 = G__23636;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = cljs.core.hash_unordered_coll.call(null,this$__$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv.call(null,self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = self__.item__GT_priority.call(null,item,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517));
if(cljs.core._EQ_.call(null,priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var item_set = self__.priority__GT_set_of_items.call(null,priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5733__auto__ = cljs.core.get.call(null,self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5733__auto__)){
var current_priority = temp__5733__auto__;
if(cljs.core._EQ_.call(null,current_priority,priority)){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var current_priority_key = self__.keyfn.call(null,current_priority);
var item_set = cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key),item),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = self__.keyfn.call(null,priority);
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__23597(s__23598){
return (new cljs.core.LazySeq(null,(function (){
var s__23598__$1 = s__23598;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__23598__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__23603 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__23603,(0),null);
var item_set = cljs.core.nth.call(null,vec__23603,(1),null);
var iterys__4525__auto__ = ((function (s__23598__$1,vec__23603,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__23597_$_iter__23599(s__23600){
return (new cljs.core.LazySeq(null,((function (s__23598__$1,vec__23603,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function (){
var s__23600__$1 = s__23600;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__23600__$1);
if(temp__5735__auto____$1){
var s__23600__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23600__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__23600__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__23602 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__23601 = (0);
while(true){
if((i__23601 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__23601);
cljs.core.chunk_append.call(null,b__23602,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__23637 = (i__23601 + (1));
i__23601 = G__23637;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23602),tailrecursion$priority_map$iter__23597_$_iter__23599.call(null,cljs.core.chunk_rest.call(null,s__23600__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23602),null);
}
} else {
var item = cljs.core.first.call(null,s__23600__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__23597_$_iter__23599.call(null,cljs.core.rest.call(null,s__23600__$2)));
}
} else {
return null;
}
break;
}
});})(s__23598__$1,vec__23603,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
,null,null));
});})(s__23598__$1,vec__23603,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__23597.call(null,cljs.core.rest.call(null,s__23598__$1)));
} else {
var G__23638 = cljs.core.rest.call(null,s__23598__$1);
s__23598__$1 = G__23638;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__23606(s__23607){
return (new cljs.core.LazySeq(null,(function (){
var s__23607__$1 = s__23607;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__23607__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__23612 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__23612,(0),null);
var item_set = cljs.core.nth.call(null,vec__23612,(1),null);
var iterys__4525__auto__ = ((function (s__23607__$1,vec__23612,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__23606_$_iter__23608(s__23609){
return (new cljs.core.LazySeq(null,((function (s__23607__$1,vec__23612,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function (){
var s__23609__$1 = s__23609;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__23609__$1);
if(temp__5735__auto____$1){
var s__23609__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23609__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__23609__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__23611 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__23610 = (0);
while(true){
if((i__23610 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__23610);
cljs.core.chunk_append.call(null,b__23611,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__23639 = (i__23610 + (1));
i__23610 = G__23639;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23611),tailrecursion$priority_map$iter__23606_$_iter__23608.call(null,cljs.core.chunk_rest.call(null,s__23609__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23611),null);
}
} else {
var item = cljs.core.first.call(null,s__23609__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__23606_$_iter__23608.call(null,cljs.core.rest.call(null,s__23609__$2)));
}
} else {
return null;
}
break;
}
});})(s__23607__$1,vec__23612,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
,null,null));
});})(s__23607__$1,vec__23612,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__23606.call(null,cljs.core.rest.call(null,s__23607__$1)));
} else {
var G__23640 = cljs.core.rest.call(null,s__23607__$1);
s__23607__$1 = G__23640;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,this$__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__23641 = null;
var G__23641__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item);
});
var G__23641__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item,not_found);
});
G__23641 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__23641__2.call(this,self__,item);
case 3:
return G__23641__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__23641.cljs$core$IFn$_invoke$arity$2 = G__23641__2;
G__23641.cljs$core$IFn$_invoke$arity$3 = G__23641__3;
return G__23641;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args23578){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args23578)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
return (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq).call(null,this$__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.call(null,self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.call(null,self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__23615(s__23616){
return (new cljs.core.LazySeq(null,(function (){
var s__23616__$1 = s__23616;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__23616__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__23621 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__23621,(0),null);
var item_set = cljs.core.nth.call(null,vec__23621,(1),null);
var iterys__4525__auto__ = ((function (s__23616__$1,vec__23621,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__23615_$_iter__23617(s__23618){
return (new cljs.core.LazySeq(null,((function (s__23616__$1,vec__23621,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function (){
var s__23618__$1 = s__23618;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__23618__$1);
if(temp__5735__auto____$1){
var s__23618__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23618__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__23618__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__23620 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__23619 = (0);
while(true){
if((i__23619 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__23619);
cljs.core.chunk_append.call(null,b__23620,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__23642 = (i__23619 + (1));
i__23619 = G__23642;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23620),tailrecursion$priority_map$iter__23615_$_iter__23617.call(null,cljs.core.chunk_rest.call(null,s__23618__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23620),null);
}
} else {
var item = cljs.core.first.call(null,s__23618__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__23615_$_iter__23617.call(null,cljs.core.rest.call(null,s__23618__$2)));
}
} else {
return null;
}
break;
}
});})(s__23616__$1,vec__23621,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
,null,null));
});})(s__23616__$1,vec__23621,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__23615.call(null,cljs.core.rest.call(null,s__23616__$1)));
} else {
var G__23643 = cljs.core.rest.call(null,s__23616__$1);
s__23616__$1 = G__23643;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,sets);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__23624(s__23625){
return (new cljs.core.LazySeq(null,(function (){
var s__23625__$1 = s__23625;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__23625__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__23630 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__23630,(0),null);
var item_set = cljs.core.nth.call(null,vec__23630,(1),null);
var iterys__4525__auto__ = ((function (s__23625__$1,vec__23630,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__23624_$_iter__23626(s__23627){
return (new cljs.core.LazySeq(null,((function (s__23625__$1,vec__23630,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function (){
var s__23627__$1 = s__23627;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__23627__$1);
if(temp__5735__auto____$1){
var s__23627__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__23627__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__23627__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__23629 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__23628 = (0);
while(true){
if((i__23628 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__23628);
cljs.core.chunk_append.call(null,b__23629,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__23644 = (i__23628 + (1));
i__23628 = G__23644;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23629),tailrecursion$priority_map$iter__23624_$_iter__23626.call(null,cljs.core.chunk_rest.call(null,s__23627__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__23629),null);
}
} else {
var item = cljs.core.first.call(null,s__23627__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__23624_$_iter__23626.call(null,cljs.core.rest.call(null,s__23627__$2)));
}
} else {
return null;
}
break;
}
});})(s__23625__$1,vec__23630,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
,null,null));
});})(s__23625__$1,vec__23630,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__23624.call(null,cljs.core.rest.call(null,s__23625__$1)));
} else {
var G__23645 = cljs.core.rest.call(null,s__23625__$1);
s__23625__$1 = G__23645;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
return self__.keyfn.call(null,cljs.core.val.call(null,entry));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__23647 = arguments.length;
switch (G__23647) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_.call(null,elems)){
return cljs.core.into.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_.call(null,"tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4742__auto__ = [];
var len__4736__auto___23650 = arguments.length;
var i__4737__auto___23651 = (0);
while(true){
if((i__4737__auto___23651 < len__4736__auto___23650)){
args__4742__auto__.push((arguments[i__4737__auto___23651]));

var G__23652 = (i__4737__auto___23651 + (1));
i__4737__auto___23651 = G__23652;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__23653 = cljs.core.nnext.call(null,in$);
var G__23654 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__23653;
out = G__23654;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq23649){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq23649));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4742__auto__ = [];
var len__4736__auto___23657 = arguments.length;
var i__4737__auto___23658 = (0);
while(true){
if((i__4737__auto___23658 < len__4736__auto___23657)){
args__4742__auto__.push((arguments[i__4737__auto___23658]));

var G__23659 = (i__4737__auto___23658 + (1));
i__4737__auto___23658 = G__23659;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_by.call(null,comparator);
while(true){
if(in$){
var G__23660 = cljs.core.nnext.call(null,in$);
var G__23661 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__23660;
out = G__23661;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq23655){
var G__23656 = cljs.core.first.call(null,seq23655);
var seq23655__$1 = cljs.core.next.call(null,seq23655);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__23656,seq23655__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4742__auto__ = [];
var len__4736__auto___23664 = arguments.length;
var i__4737__auto___23665 = (0);
while(true){
if((i__4737__auto___23665 < len__4736__auto___23664)){
args__4742__auto__.push((arguments[i__4737__auto___23665]));

var G__23666 = (i__4737__auto___23665 + (1));
i__4737__auto___23665 = G__23666;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn);
while(true){
if(in$){
var G__23667 = cljs.core.nnext.call(null,in$);
var G__23668 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__23667;
out = G__23668;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq23662){
var G__23663 = cljs.core.first.call(null,seq23662);
var seq23662__$1 = cljs.core.next.call(null,seq23662);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__23663,seq23662__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4742__auto__ = [];
var len__4736__auto___23672 = arguments.length;
var i__4737__auto___23673 = (0);
while(true){
if((i__4737__auto___23673 < len__4736__auto___23672)){
args__4742__auto__.push((arguments[i__4737__auto___23673]));

var G__23674 = (i__4737__auto___23673 + (1));
i__4737__auto___23673 = G__23674;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn,comparator);
while(true){
if(in$){
var G__23675 = cljs.core.nnext.call(null,in$);
var G__23676 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__23675;
out = G__23676;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq23669){
var G__23670 = cljs.core.first.call(null,seq23669);
var seq23669__$1 = cljs.core.next.call(null,seq23669);
var G__23671 = cljs.core.first.call(null,seq23669__$1);
var seq23669__$2 = cljs.core.next.call(null,seq23669__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__23670,G__23671,seq23669__$2);
}));


//# sourceMappingURL=priority_map.js.map?rel=1594010326032
