// Compiled by ClojureScript 1.10.773 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined')){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.debug_loader_QMARK_ = (function figwheel$client$file_reloading$debug_loader_QMARK_(){
return (!((goog.debugLoader_ == null)));
});
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__4126__auto__ = ((cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && ((((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string'))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372))));
if(or__4126__auto__){
return or__4126__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = ((figwheel.client.file_reloading.debug_loader_QMARK_.call(null))?(function (ns){

return goog.debugLoader_.getPathFromDeps_(ns);
}):(function (ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
}));
figwheel.client.file_reloading.provided_QMARK_ = ((figwheel.client.file_reloading.debug_loader_QMARK_.call(null))?(function (ns){
return goog.getObjectByName(ns);
}):(function (ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
}));
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(ns){
return ((cljs.core._EQ_.call(null,"goog",ns)) || (cljs.core._EQ_.call(null,"cljs.core",ns)) || (cljs.core._EQ_.call(null,"cljs.nodejs",ns)) || (goog.string.startsWith(ns,"clojure.")) || (goog.string.startsWith(ns,"goog.")));
});
figwheel.client.file_reloading.base_requires_for_ns_path = ((figwheel.client.file_reloading.debug_loader_QMARK_.call(null))?(function (path){
var G__33855 = goog.object.get(goog.debugLoader_.dependencies_,path);
if((G__33855 == null)){
return null;
} else {
return goog.object.get(G__33855,"requires");
}
}):(function (path){
var G__33856 = goog.object.get(goog.dependencies_.requires,path);
if((G__33856 == null)){
return null;
} else {
return goog.object.getKeys(G__33856);
}
}));
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__33857_SHARP_){
return (!(figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__33857_SHARP_)));
}),figwheel.client.file_reloading.base_requires_for_ns_path.call(null,figwheel.client.file_reloading.name__GT_path.call(null,ns))));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependency_data !== 'undefined')){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = ((figwheel.client.file_reloading.debug_loader_QMARK_.call(null))?(function (_,___$1){
return null;
}):(function (path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
}));
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = ((figwheel.client.file_reloading.debug_loader_QMARK_.call(null))?(function (){
return null;
}):(function (){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,(function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
}));
}));
figwheel.client.file_reloading.path__GT_name = ((figwheel.client.file_reloading.debug_loader_QMARK_.call(null))?(function (path){
var G__33858 = goog.object.get(goog.debugLoader_.dependencies_,path);
var G__33858__$1 = (((G__33858 == null))?null:goog.object.get(G__33858,"provides"));
if((G__33858__$1 == null)){
return null;
} else {
return cljs.core.set.call(null,G__33858__$1);
}
}):(function (path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
}));
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),parent_ns);
});
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = ((figwheel.client.file_reloading.debug_loader_QMARK_.call(null))?(function (){
return goog.object.forEach(goog.object.filter(goog.debugLoader_.dependencies_,(function (dep,path,_){
return cljs.core.not.call(null,cljs.core.some.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_,goog.object.get(dep,"provides")));
})),(function (dep,path,_){
var provides = goog.object.get(dep,"provides");
var requires = goog.object.get(dep,"requires");
var seq__33859 = cljs.core.seq.call(null,provides);
var chunk__33860 = null;
var count__33861 = (0);
var i__33862 = (0);
while(true){
if((i__33862 < count__33861)){
var prov = cljs.core._nth.call(null,chunk__33860,i__33862);
var seq__33871_33883 = cljs.core.seq.call(null,requires);
var chunk__33872_33884 = null;
var count__33873_33885 = (0);
var i__33874_33886 = (0);
while(true){
if((i__33874_33886 < count__33873_33885)){
var req_33887 = cljs.core._nth.call(null,chunk__33872_33884,i__33874_33886);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33887,prov);


var G__33888 = seq__33871_33883;
var G__33889 = chunk__33872_33884;
var G__33890 = count__33873_33885;
var G__33891 = (i__33874_33886 + (1));
seq__33871_33883 = G__33888;
chunk__33872_33884 = G__33889;
count__33873_33885 = G__33890;
i__33874_33886 = G__33891;
continue;
} else {
var temp__5735__auto___33892 = cljs.core.seq.call(null,seq__33871_33883);
if(temp__5735__auto___33892){
var seq__33871_33893__$1 = temp__5735__auto___33892;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33871_33893__$1)){
var c__4556__auto___33894 = cljs.core.chunk_first.call(null,seq__33871_33893__$1);
var G__33895 = cljs.core.chunk_rest.call(null,seq__33871_33893__$1);
var G__33896 = c__4556__auto___33894;
var G__33897 = cljs.core.count.call(null,c__4556__auto___33894);
var G__33898 = (0);
seq__33871_33883 = G__33895;
chunk__33872_33884 = G__33896;
count__33873_33885 = G__33897;
i__33874_33886 = G__33898;
continue;
} else {
var req_33899 = cljs.core.first.call(null,seq__33871_33893__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33899,prov);


var G__33900 = cljs.core.next.call(null,seq__33871_33893__$1);
var G__33901 = null;
var G__33902 = (0);
var G__33903 = (0);
seq__33871_33883 = G__33900;
chunk__33872_33884 = G__33901;
count__33873_33885 = G__33902;
i__33874_33886 = G__33903;
continue;
}
} else {
}
}
break;
}


var G__33904 = seq__33859;
var G__33905 = chunk__33860;
var G__33906 = count__33861;
var G__33907 = (i__33862 + (1));
seq__33859 = G__33904;
chunk__33860 = G__33905;
count__33861 = G__33906;
i__33862 = G__33907;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__33859);
if(temp__5735__auto__){
var seq__33859__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33859__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__33859__$1);
var G__33908 = cljs.core.chunk_rest.call(null,seq__33859__$1);
var G__33909 = c__4556__auto__;
var G__33910 = cljs.core.count.call(null,c__4556__auto__);
var G__33911 = (0);
seq__33859 = G__33908;
chunk__33860 = G__33909;
count__33861 = G__33910;
i__33862 = G__33911;
continue;
} else {
var prov = cljs.core.first.call(null,seq__33859__$1);
var seq__33875_33912 = cljs.core.seq.call(null,requires);
var chunk__33876_33913 = null;
var count__33877_33914 = (0);
var i__33878_33915 = (0);
while(true){
if((i__33878_33915 < count__33877_33914)){
var req_33916 = cljs.core._nth.call(null,chunk__33876_33913,i__33878_33915);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33916,prov);


var G__33917 = seq__33875_33912;
var G__33918 = chunk__33876_33913;
var G__33919 = count__33877_33914;
var G__33920 = (i__33878_33915 + (1));
seq__33875_33912 = G__33917;
chunk__33876_33913 = G__33918;
count__33877_33914 = G__33919;
i__33878_33915 = G__33920;
continue;
} else {
var temp__5735__auto___33921__$1 = cljs.core.seq.call(null,seq__33875_33912);
if(temp__5735__auto___33921__$1){
var seq__33875_33922__$1 = temp__5735__auto___33921__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33875_33922__$1)){
var c__4556__auto___33923 = cljs.core.chunk_first.call(null,seq__33875_33922__$1);
var G__33924 = cljs.core.chunk_rest.call(null,seq__33875_33922__$1);
var G__33925 = c__4556__auto___33923;
var G__33926 = cljs.core.count.call(null,c__4556__auto___33923);
var G__33927 = (0);
seq__33875_33912 = G__33924;
chunk__33876_33913 = G__33925;
count__33877_33914 = G__33926;
i__33878_33915 = G__33927;
continue;
} else {
var req_33928 = cljs.core.first.call(null,seq__33875_33922__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_33928,prov);


var G__33929 = cljs.core.next.call(null,seq__33875_33922__$1);
var G__33930 = null;
var G__33931 = (0);
var G__33932 = (0);
seq__33875_33912 = G__33929;
chunk__33876_33913 = G__33930;
count__33877_33914 = G__33931;
i__33878_33915 = G__33932;
continue;
}
} else {
}
}
break;
}


var G__33933 = cljs.core.next.call(null,seq__33859__$1);
var G__33934 = null;
var G__33935 = (0);
var G__33936 = (0);
seq__33859 = G__33933;
chunk__33860 = G__33934;
count__33861 = G__33935;
i__33862 = G__33936;
continue;
}
} else {
return null;
}
}
break;
}
}));
}):(function (){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,(function (deps,path,_){
var seq__33879 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,path));
var chunk__33880 = null;
var count__33881 = (0);
var i__33882 = (0);
while(true){
if((i__33882 < count__33881)){
var prov = cljs.core._nth.call(null,chunk__33880,i__33882);
goog.object.forEach(deps,((function (seq__33879,chunk__33880,count__33881,i__33882,prov,requires){
return (function (___$1,req,___$2){
return figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req,prov);
});})(seq__33879,chunk__33880,count__33881,i__33882,prov,requires))
);


var G__33937 = seq__33879;
var G__33938 = chunk__33880;
var G__33939 = count__33881;
var G__33940 = (i__33882 + (1));
seq__33879 = G__33937;
chunk__33880 = G__33938;
count__33881 = G__33939;
i__33882 = G__33940;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__33879);
if(temp__5735__auto__){
var seq__33879__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33879__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__33879__$1);
var G__33941 = cljs.core.chunk_rest.call(null,seq__33879__$1);
var G__33942 = c__4556__auto__;
var G__33943 = cljs.core.count.call(null,c__4556__auto__);
var G__33944 = (0);
seq__33879 = G__33941;
chunk__33880 = G__33942;
count__33881 = G__33943;
i__33882 = G__33944;
continue;
} else {
var prov = cljs.core.first.call(null,seq__33879__$1);
goog.object.forEach(deps,((function (seq__33879,chunk__33880,count__33881,i__33882,prov,seq__33879__$1,temp__5735__auto__,requires){
return (function (___$1,req,___$2){
return figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req,prov);
});})(seq__33879,chunk__33880,count__33881,i__33882,prov,seq__33879__$1,temp__5735__auto__,requires))
);


var G__33945 = cljs.core.next.call(null,seq__33879__$1);
var G__33946 = null;
var G__33947 = (0);
var G__33948 = (0);
seq__33879 = G__33945;
chunk__33880 = G__33946;
count__33881 = G__33947;
i__33882 = G__33948;
continue;
}
} else {
return null;
}
}
break;
}
}));
}));
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__33949){
var vec__33950 = p__33949;
var _ = cljs.core.nth.call(null,vec__33950,(0),null);
var v = cljs.core.nth.call(null,vec__33950,(1),null);
var and__4115__auto__ = v;
if(cljs.core.truth_(and__4115__auto__)){
return v.call(null,dep);
} else {
return and__4115__auto__;
}
}),cljs.core.filter.call(null,(function (p__33953){
var vec__33954 = p__33953;
var k = cljs.core.nth.call(null,vec__33954,(0),null);
var v = cljs.core.nth.call(null,vec__33954,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});
var topo_sort_STAR_ = (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__33966_33974 = cljs.core.seq.call(null,deps);
var chunk__33967_33975 = null;
var count__33968_33976 = (0);
var i__33969_33977 = (0);
while(true){
if((i__33969_33977 < count__33968_33976)){
var dep_33978 = cljs.core._nth.call(null,chunk__33967_33975,i__33969_33977);
if(cljs.core.truth_((function (){var and__4115__auto__ = dep_33978;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_33978));
} else {
return and__4115__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_33978,(depth + (1)),state);
} else {
}


var G__33979 = seq__33966_33974;
var G__33980 = chunk__33967_33975;
var G__33981 = count__33968_33976;
var G__33982 = (i__33969_33977 + (1));
seq__33966_33974 = G__33979;
chunk__33967_33975 = G__33980;
count__33968_33976 = G__33981;
i__33969_33977 = G__33982;
continue;
} else {
var temp__5735__auto___33983 = cljs.core.seq.call(null,seq__33966_33974);
if(temp__5735__auto___33983){
var seq__33966_33984__$1 = temp__5735__auto___33983;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33966_33984__$1)){
var c__4556__auto___33985 = cljs.core.chunk_first.call(null,seq__33966_33984__$1);
var G__33986 = cljs.core.chunk_rest.call(null,seq__33966_33984__$1);
var G__33987 = c__4556__auto___33985;
var G__33988 = cljs.core.count.call(null,c__4556__auto___33985);
var G__33989 = (0);
seq__33966_33974 = G__33986;
chunk__33967_33975 = G__33987;
count__33968_33976 = G__33988;
i__33969_33977 = G__33989;
continue;
} else {
var dep_33990 = cljs.core.first.call(null,seq__33966_33984__$1);
if(cljs.core.truth_((function (){var and__4115__auto__ = dep_33990;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_33990));
} else {
return and__4115__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_33990,(depth + (1)),state);
} else {
}


var G__33991 = cljs.core.next.call(null,seq__33966_33984__$1);
var G__33992 = null;
var G__33993 = (0);
var G__33994 = (0);
seq__33966_33974 = G__33991;
chunk__33967_33975 = G__33992;
count__33968_33976 = G__33993;
i__33969_33977 = G__33994;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;
var elim_dups_STAR_ = (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__33970){
var vec__33971 = p__33970;
var seq__33972 = cljs.core.seq.call(null,vec__33971);
var first__33973 = cljs.core.first.call(null,seq__33972);
var seq__33972__$1 = cljs.core.next.call(null,seq__33972);
var x = first__33973;
var xs = seq__33972__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,(function (p1__33957_SHARP_){
return clojure.set.difference.call(null,p1__33957_SHARP_,x);
}),xs)));
}
});
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = ((figwheel.client.file_reloading.debug_loader_QMARK_.call(null))?(function (ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.debugLoader_.written_,path);

return goog.object.remove(goog.debugLoader_.written_,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
}):(function (ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
}));
figwheel.client.file_reloading.resolve_ns = ((figwheel.client.file_reloading.debug_loader_QMARK_.call(null))?figwheel.client.file_reloading.name__GT_path:(function (p1__33995_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,p1__33995_SHARP_))].join('');
}));
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__33996 = cljs.core.seq.call(null,provides);
var chunk__33997 = null;
var count__33998 = (0);
var i__33999 = (0);
while(true){
if((i__33999 < count__33998)){
var prov = cljs.core._nth.call(null,chunk__33997,i__33999);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__34008_34016 = cljs.core.seq.call(null,requires);
var chunk__34009_34017 = null;
var count__34010_34018 = (0);
var i__34011_34019 = (0);
while(true){
if((i__34011_34019 < count__34010_34018)){
var req_34020 = cljs.core._nth.call(null,chunk__34009_34017,i__34011_34019);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34020,prov);


var G__34021 = seq__34008_34016;
var G__34022 = chunk__34009_34017;
var G__34023 = count__34010_34018;
var G__34024 = (i__34011_34019 + (1));
seq__34008_34016 = G__34021;
chunk__34009_34017 = G__34022;
count__34010_34018 = G__34023;
i__34011_34019 = G__34024;
continue;
} else {
var temp__5735__auto___34025 = cljs.core.seq.call(null,seq__34008_34016);
if(temp__5735__auto___34025){
var seq__34008_34026__$1 = temp__5735__auto___34025;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34008_34026__$1)){
var c__4556__auto___34027 = cljs.core.chunk_first.call(null,seq__34008_34026__$1);
var G__34028 = cljs.core.chunk_rest.call(null,seq__34008_34026__$1);
var G__34029 = c__4556__auto___34027;
var G__34030 = cljs.core.count.call(null,c__4556__auto___34027);
var G__34031 = (0);
seq__34008_34016 = G__34028;
chunk__34009_34017 = G__34029;
count__34010_34018 = G__34030;
i__34011_34019 = G__34031;
continue;
} else {
var req_34032 = cljs.core.first.call(null,seq__34008_34026__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34032,prov);


var G__34033 = cljs.core.next.call(null,seq__34008_34026__$1);
var G__34034 = null;
var G__34035 = (0);
var G__34036 = (0);
seq__34008_34016 = G__34033;
chunk__34009_34017 = G__34034;
count__34010_34018 = G__34035;
i__34011_34019 = G__34036;
continue;
}
} else {
}
}
break;
}


var G__34037 = seq__33996;
var G__34038 = chunk__33997;
var G__34039 = count__33998;
var G__34040 = (i__33999 + (1));
seq__33996 = G__34037;
chunk__33997 = G__34038;
count__33998 = G__34039;
i__33999 = G__34040;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__33996);
if(temp__5735__auto__){
var seq__33996__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33996__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__33996__$1);
var G__34041 = cljs.core.chunk_rest.call(null,seq__33996__$1);
var G__34042 = c__4556__auto__;
var G__34043 = cljs.core.count.call(null,c__4556__auto__);
var G__34044 = (0);
seq__33996 = G__34041;
chunk__33997 = G__34042;
count__33998 = G__34043;
i__33999 = G__34044;
continue;
} else {
var prov = cljs.core.first.call(null,seq__33996__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__34012_34045 = cljs.core.seq.call(null,requires);
var chunk__34013_34046 = null;
var count__34014_34047 = (0);
var i__34015_34048 = (0);
while(true){
if((i__34015_34048 < count__34014_34047)){
var req_34049 = cljs.core._nth.call(null,chunk__34013_34046,i__34015_34048);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34049,prov);


var G__34050 = seq__34012_34045;
var G__34051 = chunk__34013_34046;
var G__34052 = count__34014_34047;
var G__34053 = (i__34015_34048 + (1));
seq__34012_34045 = G__34050;
chunk__34013_34046 = G__34051;
count__34014_34047 = G__34052;
i__34015_34048 = G__34053;
continue;
} else {
var temp__5735__auto___34054__$1 = cljs.core.seq.call(null,seq__34012_34045);
if(temp__5735__auto___34054__$1){
var seq__34012_34055__$1 = temp__5735__auto___34054__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34012_34055__$1)){
var c__4556__auto___34056 = cljs.core.chunk_first.call(null,seq__34012_34055__$1);
var G__34057 = cljs.core.chunk_rest.call(null,seq__34012_34055__$1);
var G__34058 = c__4556__auto___34056;
var G__34059 = cljs.core.count.call(null,c__4556__auto___34056);
var G__34060 = (0);
seq__34012_34045 = G__34057;
chunk__34013_34046 = G__34058;
count__34014_34047 = G__34059;
i__34015_34048 = G__34060;
continue;
} else {
var req_34061 = cljs.core.first.call(null,seq__34012_34055__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34061,prov);


var G__34062 = cljs.core.next.call(null,seq__34012_34055__$1);
var G__34063 = null;
var G__34064 = (0);
var G__34065 = (0);
seq__34012_34045 = G__34062;
chunk__34013_34046 = G__34063;
count__34014_34047 = G__34064;
i__34015_34048 = G__34065;
continue;
}
} else {
}
}
break;
}


var G__34066 = cljs.core.next.call(null,seq__33996__$1);
var G__34067 = null;
var G__34068 = (0);
var G__34069 = (0);
seq__33996 = G__34066;
chunk__33997 = G__34067;
count__33998 = G__34068;
i__33999 = G__34069;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
(goog.require = figwheel.client.file_reloading.figwheel_require);

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__34070_34074 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__34071_34075 = null;
var count__34072_34076 = (0);
var i__34073_34077 = (0);
while(true){
if((i__34073_34077 < count__34072_34076)){
var ns_34078 = cljs.core._nth.call(null,chunk__34071_34075,i__34073_34077);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_34078);


var G__34079 = seq__34070_34074;
var G__34080 = chunk__34071_34075;
var G__34081 = count__34072_34076;
var G__34082 = (i__34073_34077 + (1));
seq__34070_34074 = G__34079;
chunk__34071_34075 = G__34080;
count__34072_34076 = G__34081;
i__34073_34077 = G__34082;
continue;
} else {
var temp__5735__auto___34083 = cljs.core.seq.call(null,seq__34070_34074);
if(temp__5735__auto___34083){
var seq__34070_34084__$1 = temp__5735__auto___34083;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34070_34084__$1)){
var c__4556__auto___34085 = cljs.core.chunk_first.call(null,seq__34070_34084__$1);
var G__34086 = cljs.core.chunk_rest.call(null,seq__34070_34084__$1);
var G__34087 = c__4556__auto___34085;
var G__34088 = cljs.core.count.call(null,c__4556__auto___34085);
var G__34089 = (0);
seq__34070_34074 = G__34086;
chunk__34071_34075 = G__34087;
count__34072_34076 = G__34088;
i__34073_34077 = G__34089;
continue;
} else {
var ns_34090 = cljs.core.first.call(null,seq__34070_34084__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_34090);


var G__34091 = cljs.core.next.call(null,seq__34070_34084__$1);
var G__34092 = null;
var G__34093 = (0);
var G__34094 = (0);
seq__34070_34074 = G__34091;
chunk__34071_34075 = G__34092;
count__34072_34076 = G__34093;
i__34073_34077 = G__34094;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
(goog.require_figwheel_backup_ = (function (){var or__4126__auto__ = goog.require__;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.require;
}
})());

(goog.isProvided_ = (function (name){
return false;
}));

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

(goog.addDependency_figwheel_backup_ = goog.addDependency);

(goog.addDependency = (function() { 
var G__34095__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__34095 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34096__i = 0, G__34096__a = new Array(arguments.length -  0);
while (G__34096__i < G__34096__a.length) {G__34096__a[G__34096__i] = arguments[G__34096__i + 0]; ++G__34096__i;}
  args = new cljs.core.IndexedSeq(G__34096__a,0,null);
} 
return G__34095__delegate.call(this,args);};
G__34095.cljs$lang$maxFixedArity = 0;
G__34095.cljs$lang$applyTo = (function (arglist__34097){
var args = cljs.core.seq(arglist__34097);
return G__34095__delegate(args);
});
G__34095.cljs$core$IFn$_invoke$arity$variadic = G__34095__delegate;
return G__34095;
})()
);

goog.constructNamespace_("cljs.user");

(goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload);

return (goog.require = figwheel.client.file_reloading.figwheel_require);
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined')){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = (((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.safeLoad !== 'undefined'))?(function (p1__34098_SHARP_,p2__34099_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34098_SHARP_)),p2__34099_SHARP_);
}):(((typeof goog !== 'undefined') && (typeof goog.net !== 'undefined') && (typeof goog.net.jsloader !== 'undefined') && (typeof goog.net.jsloader.load !== 'undefined'))?(function (p1__34100_SHARP_,p2__34101_SHARP_){
return goog.net.jsloader.load(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34100_SHARP_),p2__34101_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__34102 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__34102.addCallback((function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
}));

G__34102.addErrback((function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
}));

return G__34102;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e34103){if((e34103 instanceof Error)){
var e = e34103;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e34103;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,(function (v,k,o){
return goog.string.endsWith(k,util_pattern);
}));
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e34104){if((e34104 instanceof Error)){
var e = e34104;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e34104;

}
}})());
});
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__34105 = cljs.core._EQ_;
var expr__34106 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__34105.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__34106))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__34105.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__34106))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__34105.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__34106))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return (function (a,b){
throw "Reload not defined for this platform";
});
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__34108,callback){
var map__34109 = p__34108;
var map__34109__$1 = (((((!((map__34109 == null))))?(((((map__34109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34109.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34109):map__34109);
var file_msg = map__34109__$1;
var request_url = cljs.core.get.call(null,map__34109__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__4126__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,(function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
}));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_chan !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined')){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined')){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),(function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
}));

return out;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reloader_loop !== 'undefined')){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__28703__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_34147){
var state_val_34148 = (state_34147[(1)]);
if((state_val_34148 === (7))){
var inst_34143 = (state_34147[(2)]);
var state_34147__$1 = state_34147;
var statearr_34149_34175 = state_34147__$1;
(statearr_34149_34175[(2)] = inst_34143);

(statearr_34149_34175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (1))){
var state_34147__$1 = state_34147;
var statearr_34150_34176 = state_34147__$1;
(statearr_34150_34176[(2)] = null);

(statearr_34150_34176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (4))){
var inst_34113 = (state_34147[(7)]);
var inst_34113__$1 = (state_34147[(2)]);
var state_34147__$1 = (function (){var statearr_34151 = state_34147;
(statearr_34151[(7)] = inst_34113__$1);

return statearr_34151;
})();
if(cljs.core.truth_(inst_34113__$1)){
var statearr_34152_34177 = state_34147__$1;
(statearr_34152_34177[(1)] = (5));

} else {
var statearr_34153_34178 = state_34147__$1;
(statearr_34153_34178[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (15))){
var inst_34126 = (state_34147[(8)]);
var inst_34128 = (state_34147[(9)]);
var inst_34130 = inst_34128.call(null,inst_34126);
var state_34147__$1 = state_34147;
var statearr_34154_34179 = state_34147__$1;
(statearr_34154_34179[(2)] = inst_34130);

(statearr_34154_34179[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (13))){
var inst_34137 = (state_34147[(2)]);
var state_34147__$1 = state_34147;
var statearr_34155_34180 = state_34147__$1;
(statearr_34155_34180[(2)] = inst_34137);

(statearr_34155_34180[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (6))){
var state_34147__$1 = state_34147;
var statearr_34156_34181 = state_34147__$1;
(statearr_34156_34181[(2)] = null);

(statearr_34156_34181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (17))){
var inst_34134 = (state_34147[(2)]);
var state_34147__$1 = state_34147;
var statearr_34157_34182 = state_34147__$1;
(statearr_34157_34182[(2)] = inst_34134);

(statearr_34157_34182[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (3))){
var inst_34145 = (state_34147[(2)]);
var state_34147__$1 = state_34147;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34147__$1,inst_34145);
} else {
if((state_val_34148 === (12))){
var state_34147__$1 = state_34147;
var statearr_34158_34183 = state_34147__$1;
(statearr_34158_34183[(2)] = null);

(statearr_34158_34183[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (2))){
var state_34147__$1 = state_34147;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34147__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_34148 === (11))){
var inst_34118 = (state_34147[(10)]);
var inst_34124 = figwheel.client.file_reloading.blocking_load.call(null,inst_34118);
var state_34147__$1 = state_34147;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34147__$1,(14),inst_34124);
} else {
if((state_val_34148 === (9))){
var inst_34118 = (state_34147[(10)]);
var state_34147__$1 = state_34147;
if(cljs.core.truth_(inst_34118)){
var statearr_34159_34184 = state_34147__$1;
(statearr_34159_34184[(1)] = (11));

} else {
var statearr_34160_34185 = state_34147__$1;
(statearr_34160_34185[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (5))){
var inst_34113 = (state_34147[(7)]);
var inst_34119 = (state_34147[(11)]);
var inst_34118 = cljs.core.nth.call(null,inst_34113,(0),null);
var inst_34119__$1 = cljs.core.nth.call(null,inst_34113,(1),null);
var state_34147__$1 = (function (){var statearr_34161 = state_34147;
(statearr_34161[(10)] = inst_34118);

(statearr_34161[(11)] = inst_34119__$1);

return statearr_34161;
})();
if(cljs.core.truth_(inst_34119__$1)){
var statearr_34162_34186 = state_34147__$1;
(statearr_34162_34186[(1)] = (8));

} else {
var statearr_34163_34187 = state_34147__$1;
(statearr_34163_34187[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (14))){
var inst_34118 = (state_34147[(10)]);
var inst_34128 = (state_34147[(9)]);
var inst_34126 = (state_34147[(2)]);
var inst_34127 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_34128__$1 = cljs.core.get.call(null,inst_34127,inst_34118);
var state_34147__$1 = (function (){var statearr_34164 = state_34147;
(statearr_34164[(8)] = inst_34126);

(statearr_34164[(9)] = inst_34128__$1);

return statearr_34164;
})();
if(cljs.core.truth_(inst_34128__$1)){
var statearr_34165_34188 = state_34147__$1;
(statearr_34165_34188[(1)] = (15));

} else {
var statearr_34166_34189 = state_34147__$1;
(statearr_34166_34189[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (16))){
var inst_34126 = (state_34147[(8)]);
var inst_34132 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_34126);
var state_34147__$1 = state_34147;
var statearr_34167_34190 = state_34147__$1;
(statearr_34167_34190[(2)] = inst_34132);

(statearr_34167_34190[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (10))){
var inst_34139 = (state_34147[(2)]);
var state_34147__$1 = (function (){var statearr_34168 = state_34147;
(statearr_34168[(12)] = inst_34139);

return statearr_34168;
})();
var statearr_34169_34191 = state_34147__$1;
(statearr_34169_34191[(2)] = null);

(statearr_34169_34191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34148 === (8))){
var inst_34119 = (state_34147[(11)]);
var inst_34121 = eval(inst_34119);
var state_34147__$1 = state_34147;
var statearr_34170_34192 = state_34147__$1;
(statearr_34170_34192[(2)] = inst_34121);

(statearr_34170_34192[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var figwheel$client$file_reloading$state_machine__28609__auto__ = null;
var figwheel$client$file_reloading$state_machine__28609__auto____0 = (function (){
var statearr_34171 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34171[(0)] = figwheel$client$file_reloading$state_machine__28609__auto__);

(statearr_34171[(1)] = (1));

return statearr_34171;
});
var figwheel$client$file_reloading$state_machine__28609__auto____1 = (function (state_34147){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_34147);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e34172){if((e34172 instanceof Object)){
var ex__28612__auto__ = e34172;
var statearr_34173_34193 = state_34147;
(statearr_34173_34193[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34147);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34172;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34194 = state_34147;
state_34147 = G__34194;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__28609__auto__ = function(state_34147){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__28609__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__28609__auto____1.call(this,state_34147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__28609__auto____0;
figwheel$client$file_reloading$state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__28609__auto____1;
return figwheel$client$file_reloading$state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_34174 = f__28704__auto__.call(null);
(statearr_34174[(6)] = c__28703__auto__);

return statearr_34174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));

return c__28703__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__34196 = arguments.length;
switch (G__34196) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
}));

(figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
}));

(figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2);

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__34198,callback){
var map__34199 = p__34198;
var map__34199__$1 = (((((!((map__34199 == null))))?(((((map__34199.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34199.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34199):map__34199);
var file_msg = map__34199__$1;
var namespace = cljs.core.get.call(null,map__34199__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,(function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
}));

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__34201){
var map__34202 = p__34201;
var map__34202__$1 = (((((!((map__34202 == null))))?(((((map__34202.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34202.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34202):map__34202);
var file_msg = map__34202__$1;
var namespace = cljs.core.get.call(null,map__34202__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.ns_exists_QMARK_ = (function figwheel$client$file_reloading$ns_exists_QMARK_(namespace){
return (!((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,namespace),".")) == null)));
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__34204){
var map__34205 = p__34204;
var map__34205__$1 = (((((!((map__34205 == null))))?(((((map__34205.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34205.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34205):map__34205);
var file_msg = map__34205__$1;
var namespace = cljs.core.get.call(null,map__34205__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if(cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg))){
var or__4126__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return figwheel.client.file_reloading.ns_exists_QMARK_.call(null,namespace);
}
}
}
} else {
return false;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__34207,callback){
var map__34208 = p__34207;
var map__34208__$1 = (((((!((map__34208 == null))))?(((((map__34208.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34208.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34208):map__34208);
var file_msg = map__34208__$1;
var request_url = cljs.core.get.call(null,map__34208__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__34208__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,(function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
}));

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__28703__auto___34258 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_34243){
var state_val_34244 = (state_34243[(1)]);
if((state_val_34244 === (1))){
var inst_34217 = cljs.core.seq.call(null,files);
var inst_34218 = cljs.core.first.call(null,inst_34217);
var inst_34219 = cljs.core.next.call(null,inst_34217);
var inst_34220 = files;
var state_34243__$1 = (function (){var statearr_34245 = state_34243;
(statearr_34245[(7)] = inst_34218);

(statearr_34245[(8)] = inst_34220);

(statearr_34245[(9)] = inst_34219);

return statearr_34245;
})();
var statearr_34246_34259 = state_34243__$1;
(statearr_34246_34259[(2)] = null);

(statearr_34246_34259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (2))){
var inst_34220 = (state_34243[(8)]);
var inst_34226 = (state_34243[(10)]);
var inst_34225 = cljs.core.seq.call(null,inst_34220);
var inst_34226__$1 = cljs.core.first.call(null,inst_34225);
var inst_34227 = cljs.core.next.call(null,inst_34225);
var inst_34228 = (inst_34226__$1 == null);
var inst_34229 = cljs.core.not.call(null,inst_34228);
var state_34243__$1 = (function (){var statearr_34247 = state_34243;
(statearr_34247[(11)] = inst_34227);

(statearr_34247[(10)] = inst_34226__$1);

return statearr_34247;
})();
if(inst_34229){
var statearr_34248_34260 = state_34243__$1;
(statearr_34248_34260[(1)] = (4));

} else {
var statearr_34249_34261 = state_34243__$1;
(statearr_34249_34261[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (3))){
var inst_34241 = (state_34243[(2)]);
var state_34243__$1 = state_34243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34243__$1,inst_34241);
} else {
if((state_val_34244 === (4))){
var inst_34226 = (state_34243[(10)]);
var inst_34231 = figwheel.client.file_reloading.reload_js_file.call(null,inst_34226);
var state_34243__$1 = state_34243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34243__$1,(7),inst_34231);
} else {
if((state_val_34244 === (5))){
var inst_34237 = cljs.core.async.close_BANG_.call(null,out);
var state_34243__$1 = state_34243;
var statearr_34250_34262 = state_34243__$1;
(statearr_34250_34262[(2)] = inst_34237);

(statearr_34250_34262[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (6))){
var inst_34239 = (state_34243[(2)]);
var state_34243__$1 = state_34243;
var statearr_34251_34263 = state_34243__$1;
(statearr_34251_34263[(2)] = inst_34239);

(statearr_34251_34263[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34244 === (7))){
var inst_34227 = (state_34243[(11)]);
var inst_34233 = (state_34243[(2)]);
var inst_34234 = cljs.core.async.put_BANG_.call(null,out,inst_34233);
var inst_34220 = inst_34227;
var state_34243__$1 = (function (){var statearr_34252 = state_34243;
(statearr_34252[(12)] = inst_34234);

(statearr_34252[(8)] = inst_34220);

return statearr_34252;
})();
var statearr_34253_34264 = state_34243__$1;
(statearr_34253_34264[(2)] = null);

(statearr_34253_34264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto____0 = (function (){
var statearr_34254 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34254[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto__);

(statearr_34254[(1)] = (1));

return statearr_34254;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto____1 = (function (state_34243){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_34243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e34255){if((e34255 instanceof Object)){
var ex__28612__auto__ = e34255;
var statearr_34256_34265 = state_34243;
(statearr_34256_34265[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34255;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34266 = state_34243;
state_34243 = G__34266;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto__ = function(state_34243){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto____1.call(this,state_34243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_34257 = f__28704__auto__.call(null);
(statearr_34257[(6)] = c__28703__auto___34258);

return statearr_34257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__34267,opts){
var map__34268 = p__34267;
var map__34268__$1 = (((((!((map__34268 == null))))?(((((map__34268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34268.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34268):map__34268);
var eval_body = cljs.core.get.call(null,map__34268__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__34268__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__4115__auto__ = eval_body;
if(cljs.core.truth_(and__4115__auto__)){
return typeof eval_body === 'string';
} else {
return and__4115__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e34270){var e = e34270;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,(function (n){
var temp__5733__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,(function (p1__34271_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__34271_SHARP_),n);
}),files));
if(cljs.core.truth_(temp__5733__auto__)){
var file_msg = temp__5733__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
}),deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__34272){
var vec__34273 = p__34272;
var k = cljs.core.nth.call(null,vec__34273,(0),null);
var v = cljs.core.nth.call(null,vec__34273,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__34276){
var vec__34277 = p__34276;
var k = cljs.core.nth.call(null,vec__34277,(0),null);
var v = cljs.core.nth.call(null,vec__34277,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__34283,p__34284){
var map__34285 = p__34283;
var map__34285__$1 = (((((!((map__34285 == null))))?(((((map__34285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34285.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34285):map__34285);
var opts = map__34285__$1;
var before_jsload = cljs.core.get.call(null,map__34285__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__34285__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__34285__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__34286 = p__34284;
var map__34286__$1 = (((((!((map__34286 == null))))?(((((map__34286.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34286.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34286):map__34286);
var msg = map__34286__$1;
var files = cljs.core.get.call(null,map__34286__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__34286__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__34286__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__28703__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__28704__auto__ = (function (){var switch__28608__auto__ = (function (state_34440){
var state_val_34441 = (state_34440[(1)]);
if((state_val_34441 === (7))){
var inst_34301 = (state_34440[(7)]);
var inst_34302 = (state_34440[(8)]);
var inst_34303 = (state_34440[(9)]);
var inst_34300 = (state_34440[(10)]);
var inst_34308 = cljs.core._nth.call(null,inst_34301,inst_34303);
var inst_34309 = figwheel.client.file_reloading.eval_body.call(null,inst_34308,opts);
var inst_34310 = (inst_34303 + (1));
var tmp34442 = inst_34301;
var tmp34443 = inst_34302;
var tmp34444 = inst_34300;
var inst_34300__$1 = tmp34444;
var inst_34301__$1 = tmp34442;
var inst_34302__$1 = tmp34443;
var inst_34303__$1 = inst_34310;
var state_34440__$1 = (function (){var statearr_34445 = state_34440;
(statearr_34445[(7)] = inst_34301__$1);

(statearr_34445[(8)] = inst_34302__$1);

(statearr_34445[(9)] = inst_34303__$1);

(statearr_34445[(10)] = inst_34300__$1);

(statearr_34445[(11)] = inst_34309);

return statearr_34445;
})();
var statearr_34446_34529 = state_34440__$1;
(statearr_34446_34529[(2)] = null);

(statearr_34446_34529[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (20))){
var inst_34343 = (state_34440[(12)]);
var inst_34351 = figwheel.client.file_reloading.sort_files.call(null,inst_34343);
var state_34440__$1 = state_34440;
var statearr_34447_34530 = state_34440__$1;
(statearr_34447_34530[(2)] = inst_34351);

(statearr_34447_34530[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (27))){
var state_34440__$1 = state_34440;
var statearr_34448_34531 = state_34440__$1;
(statearr_34448_34531[(2)] = null);

(statearr_34448_34531[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (1))){
var inst_34292 = (state_34440[(13)]);
var inst_34289 = before_jsload.call(null,files);
var inst_34290 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_34291 = (function (){return (function (p1__34280_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34280_SHARP_);
});
})();
var inst_34292__$1 = cljs.core.filter.call(null,inst_34291,files);
var inst_34293 = cljs.core.not_empty.call(null,inst_34292__$1);
var state_34440__$1 = (function (){var statearr_34449 = state_34440;
(statearr_34449[(13)] = inst_34292__$1);

(statearr_34449[(14)] = inst_34290);

(statearr_34449[(15)] = inst_34289);

return statearr_34449;
})();
if(cljs.core.truth_(inst_34293)){
var statearr_34450_34532 = state_34440__$1;
(statearr_34450_34532[(1)] = (2));

} else {
var statearr_34451_34533 = state_34440__$1;
(statearr_34451_34533[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (24))){
var state_34440__$1 = state_34440;
var statearr_34452_34534 = state_34440__$1;
(statearr_34452_34534[(2)] = null);

(statearr_34452_34534[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (39))){
var inst_34393 = (state_34440[(16)]);
var state_34440__$1 = state_34440;
var statearr_34453_34535 = state_34440__$1;
(statearr_34453_34535[(2)] = inst_34393);

(statearr_34453_34535[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (46))){
var inst_34435 = (state_34440[(2)]);
var state_34440__$1 = state_34440;
var statearr_34454_34536 = state_34440__$1;
(statearr_34454_34536[(2)] = inst_34435);

(statearr_34454_34536[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (4))){
var inst_34337 = (state_34440[(2)]);
var inst_34338 = cljs.core.List.EMPTY;
var inst_34339 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_34338);
var inst_34340 = (function (){return (function (p1__34281_SHARP_){
var and__4115__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__34281_SHARP_);
if(cljs.core.truth_(and__4115__auto__)){
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34281_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__34281_SHARP_))));
} else {
return and__4115__auto__;
}
});
})();
var inst_34341 = cljs.core.filter.call(null,inst_34340,files);
var inst_34342 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_34343 = cljs.core.concat.call(null,inst_34341,inst_34342);
var state_34440__$1 = (function (){var statearr_34455 = state_34440;
(statearr_34455[(17)] = inst_34337);

(statearr_34455[(18)] = inst_34339);

(statearr_34455[(12)] = inst_34343);

return statearr_34455;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_34456_34537 = state_34440__$1;
(statearr_34456_34537[(1)] = (16));

} else {
var statearr_34457_34538 = state_34440__$1;
(statearr_34457_34538[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (15))){
var inst_34327 = (state_34440[(2)]);
var state_34440__$1 = state_34440;
var statearr_34458_34539 = state_34440__$1;
(statearr_34458_34539[(2)] = inst_34327);

(statearr_34458_34539[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (21))){
var inst_34353 = (state_34440[(19)]);
var inst_34353__$1 = (state_34440[(2)]);
var inst_34354 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_34353__$1);
var state_34440__$1 = (function (){var statearr_34459 = state_34440;
(statearr_34459[(19)] = inst_34353__$1);

return statearr_34459;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34440__$1,(22),inst_34354);
} else {
if((state_val_34441 === (31))){
var inst_34438 = (state_34440[(2)]);
var state_34440__$1 = state_34440;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34440__$1,inst_34438);
} else {
if((state_val_34441 === (32))){
var inst_34393 = (state_34440[(16)]);
var inst_34398 = inst_34393.cljs$lang$protocol_mask$partition0$;
var inst_34399 = (inst_34398 & (64));
var inst_34400 = inst_34393.cljs$core$ISeq$;
var inst_34401 = (cljs.core.PROTOCOL_SENTINEL === inst_34400);
var inst_34402 = ((inst_34399) || (inst_34401));
var state_34440__$1 = state_34440;
if(cljs.core.truth_(inst_34402)){
var statearr_34460_34540 = state_34440__$1;
(statearr_34460_34540[(1)] = (35));

} else {
var statearr_34461_34541 = state_34440__$1;
(statearr_34461_34541[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (40))){
var inst_34415 = (state_34440[(20)]);
var inst_34414 = (state_34440[(2)]);
var inst_34415__$1 = cljs.core.get.call(null,inst_34414,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_34416 = cljs.core.get.call(null,inst_34414,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_34417 = cljs.core.not_empty.call(null,inst_34415__$1);
var state_34440__$1 = (function (){var statearr_34462 = state_34440;
(statearr_34462[(21)] = inst_34416);

(statearr_34462[(20)] = inst_34415__$1);

return statearr_34462;
})();
if(cljs.core.truth_(inst_34417)){
var statearr_34463_34542 = state_34440__$1;
(statearr_34463_34542[(1)] = (41));

} else {
var statearr_34464_34543 = state_34440__$1;
(statearr_34464_34543[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (33))){
var state_34440__$1 = state_34440;
var statearr_34465_34544 = state_34440__$1;
(statearr_34465_34544[(2)] = false);

(statearr_34465_34544[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (13))){
var inst_34313 = (state_34440[(22)]);
var inst_34317 = cljs.core.chunk_first.call(null,inst_34313);
var inst_34318 = cljs.core.chunk_rest.call(null,inst_34313);
var inst_34319 = cljs.core.count.call(null,inst_34317);
var inst_34300 = inst_34318;
var inst_34301 = inst_34317;
var inst_34302 = inst_34319;
var inst_34303 = (0);
var state_34440__$1 = (function (){var statearr_34466 = state_34440;
(statearr_34466[(7)] = inst_34301);

(statearr_34466[(8)] = inst_34302);

(statearr_34466[(9)] = inst_34303);

(statearr_34466[(10)] = inst_34300);

return statearr_34466;
})();
var statearr_34467_34545 = state_34440__$1;
(statearr_34467_34545[(2)] = null);

(statearr_34467_34545[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (22))){
var inst_34356 = (state_34440[(23)]);
var inst_34353 = (state_34440[(19)]);
var inst_34361 = (state_34440[(24)]);
var inst_34357 = (state_34440[(25)]);
var inst_34356__$1 = (state_34440[(2)]);
var inst_34357__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34356__$1);
var inst_34358 = (function (){var all_files = inst_34353;
var res_SINGLEQUOTE_ = inst_34356__$1;
var res = inst_34357__$1;
return (function (p1__34282_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__34282_SHARP_));
});
})();
var inst_34359 = cljs.core.filter.call(null,inst_34358,inst_34356__$1);
var inst_34360 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_34361__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34360);
var inst_34362 = cljs.core.not_empty.call(null,inst_34361__$1);
var state_34440__$1 = (function (){var statearr_34468 = state_34440;
(statearr_34468[(23)] = inst_34356__$1);

(statearr_34468[(26)] = inst_34359);

(statearr_34468[(24)] = inst_34361__$1);

(statearr_34468[(25)] = inst_34357__$1);

return statearr_34468;
})();
if(cljs.core.truth_(inst_34362)){
var statearr_34469_34546 = state_34440__$1;
(statearr_34469_34546[(1)] = (23));

} else {
var statearr_34470_34547 = state_34440__$1;
(statearr_34470_34547[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (36))){
var state_34440__$1 = state_34440;
var statearr_34471_34548 = state_34440__$1;
(statearr_34471_34548[(2)] = false);

(statearr_34471_34548[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (41))){
var inst_34415 = (state_34440[(20)]);
var inst_34419 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_34420 = cljs.core.map.call(null,inst_34419,inst_34415);
var inst_34421 = cljs.core.pr_str.call(null,inst_34420);
var inst_34422 = ["figwheel-no-load meta-data: ",inst_34421].join('');
var inst_34423 = figwheel.client.utils.log.call(null,inst_34422);
var state_34440__$1 = state_34440;
var statearr_34472_34549 = state_34440__$1;
(statearr_34472_34549[(2)] = inst_34423);

(statearr_34472_34549[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (43))){
var inst_34416 = (state_34440[(21)]);
var inst_34426 = (state_34440[(2)]);
var inst_34427 = cljs.core.not_empty.call(null,inst_34416);
var state_34440__$1 = (function (){var statearr_34473 = state_34440;
(statearr_34473[(27)] = inst_34426);

return statearr_34473;
})();
if(cljs.core.truth_(inst_34427)){
var statearr_34474_34550 = state_34440__$1;
(statearr_34474_34550[(1)] = (44));

} else {
var statearr_34475_34551 = state_34440__$1;
(statearr_34475_34551[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (29))){
var inst_34356 = (state_34440[(23)]);
var inst_34393 = (state_34440[(16)]);
var inst_34359 = (state_34440[(26)]);
var inst_34353 = (state_34440[(19)]);
var inst_34361 = (state_34440[(24)]);
var inst_34357 = (state_34440[(25)]);
var inst_34389 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_34392 = (function (){var all_files = inst_34353;
var res_SINGLEQUOTE_ = inst_34356;
var res = inst_34357;
var files_not_loaded = inst_34359;
var dependencies_that_loaded = inst_34361;
return (function (p__34391){
var map__34476 = p__34391;
var map__34476__$1 = (((((!((map__34476 == null))))?(((((map__34476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34476.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34476):map__34476);
var namespace = cljs.core.get.call(null,map__34476__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
})();
var inst_34393__$1 = cljs.core.group_by.call(null,inst_34392,inst_34359);
var inst_34395 = (inst_34393__$1 == null);
var inst_34396 = cljs.core.not.call(null,inst_34395);
var state_34440__$1 = (function (){var statearr_34478 = state_34440;
(statearr_34478[(16)] = inst_34393__$1);

(statearr_34478[(28)] = inst_34389);

return statearr_34478;
})();
if(inst_34396){
var statearr_34479_34552 = state_34440__$1;
(statearr_34479_34552[(1)] = (32));

} else {
var statearr_34480_34553 = state_34440__$1;
(statearr_34480_34553[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (44))){
var inst_34416 = (state_34440[(21)]);
var inst_34429 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34416);
var inst_34430 = cljs.core.pr_str.call(null,inst_34429);
var inst_34431 = ["not required: ",inst_34430].join('');
var inst_34432 = figwheel.client.utils.log.call(null,inst_34431);
var state_34440__$1 = state_34440;
var statearr_34481_34554 = state_34440__$1;
(statearr_34481_34554[(2)] = inst_34432);

(statearr_34481_34554[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (6))){
var inst_34334 = (state_34440[(2)]);
var state_34440__$1 = state_34440;
var statearr_34482_34555 = state_34440__$1;
(statearr_34482_34555[(2)] = inst_34334);

(statearr_34482_34555[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (28))){
var inst_34359 = (state_34440[(26)]);
var inst_34386 = (state_34440[(2)]);
var inst_34387 = cljs.core.not_empty.call(null,inst_34359);
var state_34440__$1 = (function (){var statearr_34483 = state_34440;
(statearr_34483[(29)] = inst_34386);

return statearr_34483;
})();
if(cljs.core.truth_(inst_34387)){
var statearr_34484_34556 = state_34440__$1;
(statearr_34484_34556[(1)] = (29));

} else {
var statearr_34485_34557 = state_34440__$1;
(statearr_34485_34557[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (25))){
var inst_34357 = (state_34440[(25)]);
var inst_34373 = (state_34440[(2)]);
var inst_34374 = cljs.core.not_empty.call(null,inst_34357);
var state_34440__$1 = (function (){var statearr_34486 = state_34440;
(statearr_34486[(30)] = inst_34373);

return statearr_34486;
})();
if(cljs.core.truth_(inst_34374)){
var statearr_34487_34558 = state_34440__$1;
(statearr_34487_34558[(1)] = (26));

} else {
var statearr_34488_34559 = state_34440__$1;
(statearr_34488_34559[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (34))){
var inst_34409 = (state_34440[(2)]);
var state_34440__$1 = state_34440;
if(cljs.core.truth_(inst_34409)){
var statearr_34489_34560 = state_34440__$1;
(statearr_34489_34560[(1)] = (38));

} else {
var statearr_34490_34561 = state_34440__$1;
(statearr_34490_34561[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (17))){
var state_34440__$1 = state_34440;
var statearr_34491_34562 = state_34440__$1;
(statearr_34491_34562[(2)] = recompile_dependents);

(statearr_34491_34562[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (3))){
var state_34440__$1 = state_34440;
var statearr_34492_34563 = state_34440__$1;
(statearr_34492_34563[(2)] = null);

(statearr_34492_34563[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (12))){
var inst_34330 = (state_34440[(2)]);
var state_34440__$1 = state_34440;
var statearr_34493_34564 = state_34440__$1;
(statearr_34493_34564[(2)] = inst_34330);

(statearr_34493_34564[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (2))){
var inst_34292 = (state_34440[(13)]);
var inst_34299 = cljs.core.seq.call(null,inst_34292);
var inst_34300 = inst_34299;
var inst_34301 = null;
var inst_34302 = (0);
var inst_34303 = (0);
var state_34440__$1 = (function (){var statearr_34494 = state_34440;
(statearr_34494[(7)] = inst_34301);

(statearr_34494[(8)] = inst_34302);

(statearr_34494[(9)] = inst_34303);

(statearr_34494[(10)] = inst_34300);

return statearr_34494;
})();
var statearr_34495_34565 = state_34440__$1;
(statearr_34495_34565[(2)] = null);

(statearr_34495_34565[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (23))){
var inst_34356 = (state_34440[(23)]);
var inst_34359 = (state_34440[(26)]);
var inst_34353 = (state_34440[(19)]);
var inst_34361 = (state_34440[(24)]);
var inst_34357 = (state_34440[(25)]);
var inst_34364 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_34366 = (function (){var all_files = inst_34353;
var res_SINGLEQUOTE_ = inst_34356;
var res = inst_34357;
var files_not_loaded = inst_34359;
var dependencies_that_loaded = inst_34361;
return (function (p__34365){
var map__34496 = p__34365;
var map__34496__$1 = (((((!((map__34496 == null))))?(((((map__34496.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34496.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34496):map__34496);
var request_url = cljs.core.get.call(null,map__34496__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
})();
var inst_34367 = cljs.core.reverse.call(null,inst_34361);
var inst_34368 = cljs.core.map.call(null,inst_34366,inst_34367);
var inst_34369 = cljs.core.pr_str.call(null,inst_34368);
var inst_34370 = figwheel.client.utils.log.call(null,inst_34369);
var state_34440__$1 = (function (){var statearr_34498 = state_34440;
(statearr_34498[(31)] = inst_34364);

return statearr_34498;
})();
var statearr_34499_34566 = state_34440__$1;
(statearr_34499_34566[(2)] = inst_34370);

(statearr_34499_34566[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (35))){
var state_34440__$1 = state_34440;
var statearr_34500_34567 = state_34440__$1;
(statearr_34500_34567[(2)] = true);

(statearr_34500_34567[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (19))){
var inst_34343 = (state_34440[(12)]);
var inst_34349 = figwheel.client.file_reloading.expand_files.call(null,inst_34343);
var state_34440__$1 = state_34440;
var statearr_34501_34568 = state_34440__$1;
(statearr_34501_34568[(2)] = inst_34349);

(statearr_34501_34568[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (11))){
var state_34440__$1 = state_34440;
var statearr_34502_34569 = state_34440__$1;
(statearr_34502_34569[(2)] = null);

(statearr_34502_34569[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (9))){
var inst_34332 = (state_34440[(2)]);
var state_34440__$1 = state_34440;
var statearr_34503_34570 = state_34440__$1;
(statearr_34503_34570[(2)] = inst_34332);

(statearr_34503_34570[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (5))){
var inst_34302 = (state_34440[(8)]);
var inst_34303 = (state_34440[(9)]);
var inst_34305 = (inst_34303 < inst_34302);
var inst_34306 = inst_34305;
var state_34440__$1 = state_34440;
if(cljs.core.truth_(inst_34306)){
var statearr_34504_34571 = state_34440__$1;
(statearr_34504_34571[(1)] = (7));

} else {
var statearr_34505_34572 = state_34440__$1;
(statearr_34505_34572[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (14))){
var inst_34313 = (state_34440[(22)]);
var inst_34322 = cljs.core.first.call(null,inst_34313);
var inst_34323 = figwheel.client.file_reloading.eval_body.call(null,inst_34322,opts);
var inst_34324 = cljs.core.next.call(null,inst_34313);
var inst_34300 = inst_34324;
var inst_34301 = null;
var inst_34302 = (0);
var inst_34303 = (0);
var state_34440__$1 = (function (){var statearr_34506 = state_34440;
(statearr_34506[(7)] = inst_34301);

(statearr_34506[(8)] = inst_34302);

(statearr_34506[(32)] = inst_34323);

(statearr_34506[(9)] = inst_34303);

(statearr_34506[(10)] = inst_34300);

return statearr_34506;
})();
var statearr_34507_34573 = state_34440__$1;
(statearr_34507_34573[(2)] = null);

(statearr_34507_34573[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (45))){
var state_34440__$1 = state_34440;
var statearr_34508_34574 = state_34440__$1;
(statearr_34508_34574[(2)] = null);

(statearr_34508_34574[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (26))){
var inst_34356 = (state_34440[(23)]);
var inst_34359 = (state_34440[(26)]);
var inst_34353 = (state_34440[(19)]);
var inst_34361 = (state_34440[(24)]);
var inst_34357 = (state_34440[(25)]);
var inst_34376 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_34378 = (function (){var all_files = inst_34353;
var res_SINGLEQUOTE_ = inst_34356;
var res = inst_34357;
var files_not_loaded = inst_34359;
var dependencies_that_loaded = inst_34361;
return (function (p__34377){
var map__34509 = p__34377;
var map__34509__$1 = (((((!((map__34509 == null))))?(((((map__34509.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34509.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34509):map__34509);
var namespace = cljs.core.get.call(null,map__34509__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__34509__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
})();
var inst_34379 = cljs.core.map.call(null,inst_34378,inst_34357);
var inst_34380 = cljs.core.pr_str.call(null,inst_34379);
var inst_34381 = figwheel.client.utils.log.call(null,inst_34380);
var inst_34382 = (function (){var all_files = inst_34353;
var res_SINGLEQUOTE_ = inst_34356;
var res = inst_34357;
var files_not_loaded = inst_34359;
var dependencies_that_loaded = inst_34361;
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
})();
var inst_34383 = setTimeout(inst_34382,(10));
var state_34440__$1 = (function (){var statearr_34511 = state_34440;
(statearr_34511[(33)] = inst_34376);

(statearr_34511[(34)] = inst_34381);

return statearr_34511;
})();
var statearr_34512_34575 = state_34440__$1;
(statearr_34512_34575[(2)] = inst_34383);

(statearr_34512_34575[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (16))){
var state_34440__$1 = state_34440;
var statearr_34513_34576 = state_34440__$1;
(statearr_34513_34576[(2)] = reload_dependents);

(statearr_34513_34576[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (38))){
var inst_34393 = (state_34440[(16)]);
var inst_34411 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34393);
var state_34440__$1 = state_34440;
var statearr_34514_34577 = state_34440__$1;
(statearr_34514_34577[(2)] = inst_34411);

(statearr_34514_34577[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (30))){
var state_34440__$1 = state_34440;
var statearr_34515_34578 = state_34440__$1;
(statearr_34515_34578[(2)] = null);

(statearr_34515_34578[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (10))){
var inst_34313 = (state_34440[(22)]);
var inst_34315 = cljs.core.chunked_seq_QMARK_.call(null,inst_34313);
var state_34440__$1 = state_34440;
if(inst_34315){
var statearr_34516_34579 = state_34440__$1;
(statearr_34516_34579[(1)] = (13));

} else {
var statearr_34517_34580 = state_34440__$1;
(statearr_34517_34580[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (18))){
var inst_34347 = (state_34440[(2)]);
var state_34440__$1 = state_34440;
if(cljs.core.truth_(inst_34347)){
var statearr_34518_34581 = state_34440__$1;
(statearr_34518_34581[(1)] = (19));

} else {
var statearr_34519_34582 = state_34440__$1;
(statearr_34519_34582[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (42))){
var state_34440__$1 = state_34440;
var statearr_34520_34583 = state_34440__$1;
(statearr_34520_34583[(2)] = null);

(statearr_34520_34583[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (37))){
var inst_34406 = (state_34440[(2)]);
var state_34440__$1 = state_34440;
var statearr_34521_34584 = state_34440__$1;
(statearr_34521_34584[(2)] = inst_34406);

(statearr_34521_34584[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34441 === (8))){
var inst_34313 = (state_34440[(22)]);
var inst_34300 = (state_34440[(10)]);
var inst_34313__$1 = cljs.core.seq.call(null,inst_34300);
var state_34440__$1 = (function (){var statearr_34522 = state_34440;
(statearr_34522[(22)] = inst_34313__$1);

return statearr_34522;
})();
if(inst_34313__$1){
var statearr_34523_34585 = state_34440__$1;
(statearr_34523_34585[(1)] = (10));

} else {
var statearr_34524_34586 = state_34440__$1;
(statearr_34524_34586[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto____0 = (function (){
var statearr_34525 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34525[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto__);

(statearr_34525[(1)] = (1));

return statearr_34525;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto____1 = (function (state_34440){
while(true){
var ret_value__28610__auto__ = (function (){try{while(true){
var result__28611__auto__ = switch__28608__auto__.call(null,state_34440);
if(cljs.core.keyword_identical_QMARK_.call(null,result__28611__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28611__auto__;
}
break;
}
}catch (e34526){if((e34526 instanceof Object)){
var ex__28612__auto__ = e34526;
var statearr_34527_34587 = state_34440;
(statearr_34527_34587[(5)] = ex__28612__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34440);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34526;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__28610__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34588 = state_34440;
state_34440 = G__34588;
continue;
} else {
return ret_value__28610__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto__ = function(state_34440){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto____1.call(this,state_34440);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__28609__auto__;
})()
})();
var state__28705__auto__ = (function (){var statearr_34528 = f__28704__auto__.call(null);
(statearr_34528[(6)] = c__28703__auto__);

return statearr_34528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__28705__auto__);
}));

return c__28703__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__34591,link){
var map__34592 = p__34591;
var map__34592__$1 = (((((!((map__34592 == null))))?(((((map__34592.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34592.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34592):map__34592);
var file = cljs.core.get.call(null,map__34592__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__5735__auto__ = link.href;
if(cljs.core.truth_(temp__5735__auto__)){
var link_href = temp__5735__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,(function (p1__34589_SHARP_,p2__34590_SHARP_){
if(cljs.core._EQ_.call(null,p1__34589_SHARP_,p2__34590_SHARP_)){
return p1__34589_SHARP_;
} else {
return false;
}
}),cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = ((match).length);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),((figwheel.client.file_reloading.truncate_url.call(null,link_href)).length)], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5735__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__34595){
var map__34596 = p__34595;
var map__34596__$1 = (((((!((map__34596 == null))))?(((((map__34596.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34596.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34596):map__34596);
var match_length = cljs.core.get.call(null,map__34596__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__34596__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__34594_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__34594_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5735__auto__)){
var res = temp__5735__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
(clone.rel = "stylesheet");

(clone.media = link.media);

(clone.disabled = link.disabled);

(clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url));

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
(link.rel = "stylesheet");

(link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url));

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__34598_SHARP_,p2__34599_SHARP_){
return cljs.core.assoc.call(null,p1__34598_SHARP_,cljs.core.get.call(null,p2__34599_SHARP_,key),p2__34599_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout((function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
}),(300));
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.file_reloading !== 'undefined') && (typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined')){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5733__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5733__auto__)){
var link = temp__5733__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),(function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
}));
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_34600 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_34600);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_34600);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__34601,p__34602){
var map__34603 = p__34601;
var map__34603__$1 = (((((!((map__34603 == null))))?(((((map__34603.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34603.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34603):map__34603);
var on_cssload = cljs.core.get.call(null,map__34603__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__34604 = p__34602;
var map__34604__$1 = (((((!((map__34604 == null))))?(((((map__34604.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34604.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34604):map__34604);
var files_msg = map__34604__$1;
var files = cljs.core.get.call(null,map__34604__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(figwheel.client.utils.html_env_QMARK_.call(null)){
var temp__5735__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__5735__auto__)){
var f_datas = temp__5735__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1594010340154
