(defproject magnet/migrations.stork "0.3.0"
  :description "Library that provide Integrant keys for performing migrations with Stork."
  :url "https://github.com/magnetcoop/migrations.stork"
  :license {:name "Mozilla Public License"
            :url "http://mozilla.org/MPL/2.0/"}
  :dependencies [[duct/core "0.7.0"]
                 [duct/logger "0.3.0"]
                 [integrant "0.7.0"]
                 [magnetcoop/stork "0.1.5"]
                 [org.clojure/clojure "1.9.0"]]
  :deploy-repositories [["snapshots" {:url "https://clojars.org/repo"
                                      :username :env/clojars_username
                                      :password :env/clojars_password
                                      :sign-releases false}]
                        ["releases"  {:url "https://clojars.org/repo"
                                      :username :env/clojars_username
                                      :password :env/clojars_password
                                      :sign-releases false}]]
  :profiles
  {:dev {:plugins [[jonase/eastwood "0.3.4"]
                   [lein-cljfmt "0.6.2"]]
         :dependencies [[com.datomic/datomic-free "0.9.5697"]
                        [duct/logger.timbre "0.4.1"]]}
   :repl {:repl-options {:host "0.0.0.0"
                         :port 4001}
          :plugins [[cider/cider-nrepl "0.18.0"]]}})
