[![Build Status](https://travis-ci.org/magnetcoop/migrations.stork.svg?branch=master)](https://travis-ci.org/magnetcoop/migrations.stork)
# Duct Stork

A [Duct](https://github.com/duct-framework/duct) library that provides [Integrant](https://github.com/weavejester/integrant) keys for using [Stork](https://github.com/magnetcoop/stork) Datomic migrations library.

## Installation

[![Clojars Project](https://clojars.org/magnet/migrations.stork/latest-version.svg)](https://clojars.org/magnet/migrations.stork)

## Usage

This library provides a single Integrant key, `:magnet.duct/stork`, that expects the following configuration keys:

* `:db-conn`: a Datomic database connection instance
* `:logger`: an instance of the `duct.logger/Logger` protocol implementation, such as `:duct/logger`
* `:migration-files`: a vector with the paths to the migration `edn` files. Migrations are installed in the order they are specified in the vector. The paths should exist somewhere in the classpath.

Example usage:

``` edn
 :magnet.duct/stork {:db-conn #ig/ref :magnet.datomic/conn
                     :logger #ig/ref :duct/logger
                     :migration-files ["hydrogen/migrations/001-schema.edn"
                                       "hydrogen/migrations/002-add-base-artifacts.edn"]}
```

When the Integrant key is initialized it will ensure that the provided migrations are installed, as long as they are valid. Invalid migrations are logged to the passed in `:logger` instance, with details on why they are invalid.

Key initialization returns a map of migrations' installation status, where the keys are migration `id`s and the values are booleans (`true` if installed, `false` otherwise).

## License

Copyright (c) Magnet S Coop 2018.

The source code for the library is subject to the terms of the Mozilla Public License, v. 2.0. If a copy of the MPL was not distributed with this file, You can obtain one at https://mozilla.org/MPL/2.0/.
