// Compiled by ClojureScript 1.9.946 {}
goog.provide('lemonade.renderers.canvas');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('lemonade.core');
goog.require('lemonade.geometry');
lemonade.renderers.canvas.noop = cljs.core.constantly.call(null,null);
if(typeof lemonade.renderers.canvas.render_fn !== 'undefined'){
} else {
lemonade.renderers.canvas.render_fn = (function (){var method_table__48130__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__48131__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__48132__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__48133__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__48134__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"lemonade.renderers.canvas","render-fn"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__48134__auto__,method_table__48130__auto__,prefer_table__48131__auto__,method_cache__48132__auto__,cached_hierarchy__48133__auto__));
})();
}
cljs.core._add_method.call(null,lemonade.renderers.canvas.render_fn,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
if(cljs.core.sequential_QMARK_.call(null,x)){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,lemonade.renderers.canvas.render_fn,x));
} else {
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,cljs.core.methods$.call(null,lemonade.core.template_expand))),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(x))){
return lemonade.renderers.canvas.render_fn.call(null,lemonade.core.template_expand.call(null,x));
} else {
cljs.core.println.call(null,["I don't know how to render a ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(x))].join(''));

return lemonade.renderers.canvas.noop;

}
}
}));
/**
 * Returns a render function which when passed a context, renders the given
 *   shape.
 */
lemonade.renderers.canvas.renderer = (function lemonade$renderers$canvas$renderer(shape){
var cont = lemonade.renderers.canvas.render_fn.call(null,shape);
return ((function (cont){
return (function (ctx){
var G__53747 = ctx;
G__53747.save();

G__53747.setTransform((1),(0),(0),(1),(0),(0));

cont.call(null,G__53747);

G__53747.restore();

G__53747.beginPath();

return G__53747;
});
;})(cont))
});
/**
 * Current style at this point in the render process. Initialised to default
 *   style.
 */
lemonade.renderers.canvas._STAR_style_STAR_ = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"stroke","stroke",1741823555),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"width","width",-384071477),(0),new cljs.core.Keyword(null,"colour","colour",2137094554),new cljs.core.Keyword(null,"black","black",1294279647),new cljs.core.Keyword(null,"dashed","dashed",-1449249319),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"corners","corners",-137817903),new cljs.core.Keyword(null,"mitre","mitre",-2131215553)], null),new cljs.core.Keyword(null,"fill","fill",883462889),new cljs.core.Keyword(null,"none","none",1333468478),new cljs.core.Keyword(null,"opacity","opacity",397153780),(1),new cljs.core.Keyword(null,"font","font",-1506159249),"sans serif 10px"], null);
lemonade.renderers.canvas.set_style_BANG_ = (function lemonade$renderers$canvas$set_style_BANG_(s){
return null;
});
lemonade.renderers.canvas.unset_style_BANG_ = (function lemonade$renderers$canvas$unset_style_BANG_(s){
return null;
});
/**
 * Merge two styles. Second wins.
 */
lemonade.renderers.canvas.merge_style = (function lemonade$renderers$canvas$merge_style(s1,s2){
return cljs.core.assoc.call(null,cljs.core.merge.call(null,s1,s2),new cljs.core.Keyword(null,"stroke","stroke",1741823555),cljs.core.merge.call(null,new cljs.core.Keyword(null,"stroke","stroke",1741823555).cljs$core$IFn$_invoke$arity$1(s1),new cljs.core.Keyword(null,"stroke","stroke",1741823555).cljs$core$IFn$_invoke$arity$1(s2)));
});
lemonade.renderers.canvas._STAR_in_path_QMARK__STAR_ = false;
lemonade.renderers.canvas.apply_atx = (function lemonade$renderers$canvas$apply_atx(p__53748){
var map__53749 = p__53748;
var map__53749__$1 = ((((!((map__53749 == null)))?((((map__53749.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53749.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53749):map__53749);
var vec__53750 = cljs.core.get.call(null,map__53749__$1,new cljs.core.Keyword(null,"matrix","matrix",803137200));
var a = cljs.core.nth.call(null,vec__53750,(0),null);
var b = cljs.core.nth.call(null,vec__53750,(1),null);
var c = cljs.core.nth.call(null,vec__53750,(2),null);
var d = cljs.core.nth.call(null,vec__53750,(3),null);
var vec__53753 = cljs.core.get.call(null,map__53749__$1,new cljs.core.Keyword(null,"translation","translation",-701621547));
var e = cljs.core.nth.call(null,vec__53753,(0),null);
var f = cljs.core.nth.call(null,vec__53753,(1),null);
return ((function (map__53749,map__53749__$1,vec__53750,a,b,c,d,vec__53753,e,f){
return (function (ctx){
return ctx.transform(a,c,b,d,e,f);
});
;})(map__53749,map__53749__$1,vec__53750,a,b,c,d,vec__53753,e,f))
});
cljs.core._add_method.call(null,lemonade.renderers.canvas.render_fn,new cljs.core.Keyword("lemonade.core","atx","lemonade.core/atx",2089934527),(function (p__53757){
var map__53758 = p__53757;
var map__53758__$1 = ((((!((map__53758 == null)))?((((map__53758.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53758.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53758):map__53758);
var base_shape = cljs.core.get.call(null,map__53758__$1,new cljs.core.Keyword(null,"base-shape","base-shape",1242460301));
var atx = cljs.core.get.call(null,map__53758__$1,new cljs.core.Keyword(null,"atx","atx",6306393));
var tx = lemonade.renderers.canvas.apply_atx.call(null,atx);
var itx = lemonade.renderers.canvas.apply_atx.call(null,lemonade.geometry.invert_atx.call(null,atx));
var cont = lemonade.renderers.canvas.render_fn.call(null,base_shape);
return ((function (tx,itx,cont,map__53758,map__53758__$1,base_shape,atx){
return (function (ctx){
var G__53760 = ctx;
tx.call(null,G__53760);

cont.call(null,G__53760);

itx.call(null,G__53760);

return G__53760;
});
;})(tx,itx,cont,map__53758,map__53758__$1,base_shape,atx))
}));
cljs.core._add_method.call(null,lemonade.renderers.canvas.render_fn,new cljs.core.Keyword("lemonade.core","path","lemonade.core/path",-2005021990),(function (p__53761){
var map__53762 = p__53761;
var map__53762__$1 = ((((!((map__53762 == null)))?((((map__53762.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53762.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53762):map__53762);
var closed_QMARK_ = cljs.core.get.call(null,map__53762__$1,new cljs.core.Keyword(null,"closed?","closed?",-1408769040));
var contents = cljs.core.get.call(null,map__53762__$1,new cljs.core.Keyword(null,"contents","contents",-1567174023));
var style = cljs.core.get.call(null,map__53762__$1,new cljs.core.Keyword(null,"style","style",-496642736));
if(cljs.core.empty_QMARK_.call(null,contents)){
return lemonade.renderers.canvas.noop;
} else {
var cont = cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,lemonade.renderers.canvas.render_fn,contents));
return ((function (cont,map__53762,map__53762__$1,closed_QMARK_,contents,style){
return (function (ctx){
lemonade.renderers.canvas.set_style_BANG_.call(null,style);

ctx.beginPath();

var _STAR_in_path_QMARK__STAR_53764_53766 = lemonade.renderers.canvas._STAR_in_path_QMARK__STAR_;
var _STAR_style_STAR_53765_53767 = lemonade.renderers.canvas._STAR_style_STAR_;
lemonade.renderers.canvas._STAR_in_path_QMARK__STAR_ = true;

lemonade.renderers.canvas._STAR_style_STAR_ = lemonade.renderers.canvas.push_style.call(null,style);

try{cont.call(null,ctx);
}finally {lemonade.renderers.canvas._STAR_style_STAR_ = _STAR_style_STAR_53765_53767;

lemonade.renderers.canvas._STAR_in_path_QMARK__STAR_ = _STAR_in_path_QMARK__STAR_53764_53766;
}
if(cljs.core.truth_(closed_QMARK_)){
ctx.closePath();

if(cljs.core.truth_(new cljs.core.Keyword(null,"fill","fill",883462889).cljs$core$IFn$_invoke$arity$1(style))){
ctx.fill();
} else {
}
} else {
}

ctx.stroke();

return lemonade.renderers.canvas.unset_style_BANG_.call(null,style);
});
;})(cont,map__53762,map__53762__$1,closed_QMARK_,contents,style))
}
}));
cljs.core._add_method.call(null,lemonade.renderers.canvas.render_fn,new cljs.core.Keyword("lemonade.core","composite","lemonade.core/composite",-1929458844),(function (p__53768){
var map__53769 = p__53768;
var map__53769__$1 = ((((!((map__53769 == null)))?((((map__53769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53769.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53769):map__53769);
var style = cljs.core.get.call(null,map__53769__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var contents = cljs.core.get.call(null,map__53769__$1,new cljs.core.Keyword(null,"contents","contents",-1567174023));
var cont = cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,lemonade.renderers.canvas.render_fn,contents));
return ((function (cont,map__53769,map__53769__$1,style,contents){
return (function (ctx){
lemonade.renderers.canvas.set_style_BANG_.call(null,style);

var _STAR_style_STAR_53771_53772 = lemonade.renderers.canvas._STAR_style_STAR_;
lemonade.renderers.canvas._STAR_style_STAR_ = lemonade.renderers.canvas.push_style.call(null,style);

try{cont.call(null,ctx);
}finally {lemonade.renderers.canvas._STAR_style_STAR_ = _STAR_style_STAR_53771_53772;
}
return lemonade.renderers.canvas.unset_style_BANG_.call(null,style);
});
;})(cont,map__53769,map__53769__$1,style,contents))
}));
cljs.core._add_method.call(null,lemonade.renderers.canvas.render_fn,new cljs.core.Keyword("lemonade.core","arc","lemonade.core/arc",1918704395),(function (p__53773){
var map__53774 = p__53773;
var map__53774__$1 = ((((!((map__53774 == null)))?((((map__53774.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53774.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53774):map__53774);
var vec__53775 = cljs.core.get.call(null,map__53774__$1,new cljs.core.Keyword(null,"centre","centre",-948091970));
var x = cljs.core.nth.call(null,vec__53775,(0),null);
var y = cljs.core.nth.call(null,vec__53775,(1),null);
var r = cljs.core.get.call(null,map__53774__$1,new cljs.core.Keyword(null,"radius","radius",-2073122258));
var from = cljs.core.get.call(null,map__53774__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var to = cljs.core.get.call(null,map__53774__$1,new cljs.core.Keyword(null,"to","to",192099007));
var style = cljs.core.get.call(null,map__53774__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var clockwise_QMARK_ = cljs.core.get.call(null,map__53774__$1,new cljs.core.Keyword(null,"clockwise?","clockwise?",282638765));
return ((function (map__53774,map__53774__$1,vec__53775,x,y,r,from,to,style,clockwise_QMARK_){
return (function (ctx){
ctx.moveTo((x + r),y);

ctx.arc(x,y,r,from,to,cljs.core.boolean$.call(null,clockwise_QMARK_));

if(lemonade.renderers.canvas._STAR_in_path_QMARK__STAR_){
return null;
} else {
return ctx.stroke();
}
});
;})(map__53774,map__53774__$1,vec__53775,x,y,r,from,to,style,clockwise_QMARK_))
}));
cljs.core._add_method.call(null,lemonade.renderers.canvas.render_fn,new cljs.core.Keyword("lemonade.core","line","lemonade.core/line",-1874428367),(function (p__53779){
var map__53780 = p__53779;
var map__53780__$1 = ((((!((map__53780 == null)))?((((map__53780.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53780.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53780):map__53780);
var o = map__53780__$1;
var from = cljs.core.get.call(null,map__53780__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var to = cljs.core.get.call(null,map__53780__$1,new cljs.core.Keyword(null,"to","to",192099007));
var style = cljs.core.get.call(null,map__53780__$1,new cljs.core.Keyword(null,"style","style",-496642736));
return ((function (map__53780,map__53780__$1,o,from,to,style){
return (function (ctx){
if(lemonade.renderers.canvas._STAR_in_path_QMARK__STAR_){
} else {
ctx.beginPath();
}

ctx.moveTo(cljs.core.first.call(null,from),cljs.core.second.call(null,from));

ctx.lineTo(cljs.core.first.call(null,to),cljs.core.second.call(null,to));

if(lemonade.renderers.canvas._STAR_in_path_QMARK__STAR_){
return null;
} else {
return ctx.stroke();
}
});
;})(map__53780,map__53780__$1,o,from,to,style))
}));
cljs.core._add_method.call(null,lemonade.renderers.canvas.render_fn,new cljs.core.Keyword("lemonade.core","bezier","lemonade.core/bezier",-2092021081),(function (p__53782){
var map__53783 = p__53782;
var map__53783__$1 = ((((!((map__53783 == null)))?((((map__53783.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53783.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__53783):map__53783);
var vec__53784 = cljs.core.get.call(null,map__53783__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var x1 = cljs.core.nth.call(null,vec__53784,(0),null);
var y1 = cljs.core.nth.call(null,vec__53784,(1),null);
var vec__53787 = cljs.core.get.call(null,map__53783__$1,new cljs.core.Keyword(null,"to","to",192099007));
var x2 = cljs.core.nth.call(null,vec__53787,(0),null);
var y2 = cljs.core.nth.call(null,vec__53787,(1),null);
var vec__53790 = cljs.core.get.call(null,map__53783__$1,new cljs.core.Keyword(null,"c1","c1",1132530803));
var cx1 = cljs.core.nth.call(null,vec__53790,(0),null);
var cy1 = cljs.core.nth.call(null,vec__53790,(1),null);
var vec__53793 = cljs.core.get.call(null,map__53783__$1,new cljs.core.Keyword(null,"c2","c2",-1561880371));
var cx2 = cljs.core.nth.call(null,vec__53793,(0),null);
var cy2 = cljs.core.nth.call(null,vec__53793,(1),null);
return ((function (map__53783,map__53783__$1,vec__53784,x1,y1,vec__53787,x2,y2,vec__53790,cx1,cy1,vec__53793,cx2,cy2){
return (function (ctx){
ctx.moveTo(x1,y1);

ctx.bezierCurveTo(cx1,cy1,cx2,cy2,x2,y2);

if(lemonade.renderers.canvas._STAR_in_path_QMARK__STAR_){
return null;
} else {
return ctx.stroke();
}
});
;})(map__53783,map__53783__$1,vec__53784,x1,y1,vec__53787,x2,y2,vec__53790,cx1,cy1,vec__53793,cx2,cy2))
}));

//# sourceMappingURL=canvas.js.map?rel=1509401073672
