// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__47075__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__47075__auto__){
return or__47075__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__47075__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
var or__47075__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__47075__auto____$1)){
return or__47075__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__56506_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__56506_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__56518 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__56519 = null;
var count__56520 = (0);
var i__56521 = (0);
while(true){
if((i__56521 < count__56520)){
var n = cljs.core._nth.call(null,chunk__56519,i__56521);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__56525 = seq__56518;
var G__56526 = chunk__56519;
var G__56527 = count__56520;
var G__56528 = (i__56521 + (1));
seq__56518 = G__56525;
chunk__56519 = G__56526;
count__56520 = G__56527;
i__56521 = G__56528;
continue;
} else {
var temp__5459__auto__ = cljs.core.seq.call(null,seq__56518);
if(temp__5459__auto__){
var seq__56518__$1 = temp__5459__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56518__$1)){
var c__48006__auto__ = cljs.core.chunk_first.call(null,seq__56518__$1);
var G__56539 = cljs.core.chunk_rest.call(null,seq__56518__$1);
var G__56540 = c__48006__auto__;
var G__56541 = cljs.core.count.call(null,c__48006__auto__);
var G__56542 = (0);
seq__56518 = G__56539;
chunk__56519 = G__56540;
count__56520 = G__56541;
i__56521 = G__56542;
continue;
} else {
var n = cljs.core.first.call(null,seq__56518__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__56550 = cljs.core.next.call(null,seq__56518__$1);
var G__56551 = null;
var G__56552 = (0);
var G__56553 = (0);
seq__56518 = G__56550;
chunk__56519 = G__56551;
count__56520 = G__56552;
i__56521 = G__56553;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__56569_56579 = cljs.core.seq.call(null,deps);
var chunk__56570_56580 = null;
var count__56571_56581 = (0);
var i__56572_56582 = (0);
while(true){
if((i__56572_56582 < count__56571_56581)){
var dep_56585 = cljs.core._nth.call(null,chunk__56570_56580,i__56572_56582);
topo_sort_helper_STAR_.call(null,dep_56585,(depth + (1)),state);

var G__56586 = seq__56569_56579;
var G__56587 = chunk__56570_56580;
var G__56588 = count__56571_56581;
var G__56589 = (i__56572_56582 + (1));
seq__56569_56579 = G__56586;
chunk__56570_56580 = G__56587;
count__56571_56581 = G__56588;
i__56572_56582 = G__56589;
continue;
} else {
var temp__5459__auto___56590 = cljs.core.seq.call(null,seq__56569_56579);
if(temp__5459__auto___56590){
var seq__56569_56591__$1 = temp__5459__auto___56590;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56569_56591__$1)){
var c__48006__auto___56592 = cljs.core.chunk_first.call(null,seq__56569_56591__$1);
var G__56593 = cljs.core.chunk_rest.call(null,seq__56569_56591__$1);
var G__56594 = c__48006__auto___56592;
var G__56595 = cljs.core.count.call(null,c__48006__auto___56592);
var G__56596 = (0);
seq__56569_56579 = G__56593;
chunk__56570_56580 = G__56594;
count__56571_56581 = G__56595;
i__56572_56582 = G__56596;
continue;
} else {
var dep_56598 = cljs.core.first.call(null,seq__56569_56591__$1);
topo_sort_helper_STAR_.call(null,dep_56598,(depth + (1)),state);

var G__56599 = cljs.core.next.call(null,seq__56569_56591__$1);
var G__56600 = null;
var G__56601 = (0);
var G__56602 = (0);
seq__56569_56579 = G__56599;
chunk__56570_56580 = G__56600;
count__56571_56581 = G__56601;
i__56572_56582 = G__56602;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__56573){
var vec__56574 = p__56573;
var seq__56575 = cljs.core.seq.call(null,vec__56574);
var first__56576 = cljs.core.first.call(null,seq__56575);
var seq__56575__$1 = cljs.core.next.call(null,seq__56575);
var x = first__56576;
var xs = seq__56575__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__56574,seq__56575,first__56576,seq__56575__$1,x,xs,get_deps__$1){
return (function (p1__56557_SHARP_){
return clojure.set.difference.call(null,p1__56557_SHARP_,x);
});})(vec__56574,seq__56575,first__56576,seq__56575__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__56606 = cljs.core.seq.call(null,provides);
var chunk__56607 = null;
var count__56608 = (0);
var i__56609 = (0);
while(true){
if((i__56609 < count__56608)){
var prov = cljs.core._nth.call(null,chunk__56607,i__56609);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__56610_56626 = cljs.core.seq.call(null,requires);
var chunk__56611_56627 = null;
var count__56612_56628 = (0);
var i__56613_56629 = (0);
while(true){
if((i__56613_56629 < count__56612_56628)){
var req_56630 = cljs.core._nth.call(null,chunk__56611_56627,i__56613_56629);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_56630,prov);

var G__56631 = seq__56610_56626;
var G__56632 = chunk__56611_56627;
var G__56633 = count__56612_56628;
var G__56634 = (i__56613_56629 + (1));
seq__56610_56626 = G__56631;
chunk__56611_56627 = G__56632;
count__56612_56628 = G__56633;
i__56613_56629 = G__56634;
continue;
} else {
var temp__5459__auto___56635 = cljs.core.seq.call(null,seq__56610_56626);
if(temp__5459__auto___56635){
var seq__56610_56636__$1 = temp__5459__auto___56635;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56610_56636__$1)){
var c__48006__auto___56637 = cljs.core.chunk_first.call(null,seq__56610_56636__$1);
var G__56638 = cljs.core.chunk_rest.call(null,seq__56610_56636__$1);
var G__56639 = c__48006__auto___56637;
var G__56640 = cljs.core.count.call(null,c__48006__auto___56637);
var G__56641 = (0);
seq__56610_56626 = G__56638;
chunk__56611_56627 = G__56639;
count__56612_56628 = G__56640;
i__56613_56629 = G__56641;
continue;
} else {
var req_56643 = cljs.core.first.call(null,seq__56610_56636__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_56643,prov);

var G__56644 = cljs.core.next.call(null,seq__56610_56636__$1);
var G__56645 = null;
var G__56646 = (0);
var G__56647 = (0);
seq__56610_56626 = G__56644;
chunk__56611_56627 = G__56645;
count__56612_56628 = G__56646;
i__56613_56629 = G__56647;
continue;
}
} else {
}
}
break;
}

var G__56648 = seq__56606;
var G__56649 = chunk__56607;
var G__56650 = count__56608;
var G__56651 = (i__56609 + (1));
seq__56606 = G__56648;
chunk__56607 = G__56649;
count__56608 = G__56650;
i__56609 = G__56651;
continue;
} else {
var temp__5459__auto__ = cljs.core.seq.call(null,seq__56606);
if(temp__5459__auto__){
var seq__56606__$1 = temp__5459__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56606__$1)){
var c__48006__auto__ = cljs.core.chunk_first.call(null,seq__56606__$1);
var G__56657 = cljs.core.chunk_rest.call(null,seq__56606__$1);
var G__56658 = c__48006__auto__;
var G__56659 = cljs.core.count.call(null,c__48006__auto__);
var G__56660 = (0);
seq__56606 = G__56657;
chunk__56607 = G__56658;
count__56608 = G__56659;
i__56609 = G__56660;
continue;
} else {
var prov = cljs.core.first.call(null,seq__56606__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__56621_56661 = cljs.core.seq.call(null,requires);
var chunk__56622_56662 = null;
var count__56623_56663 = (0);
var i__56624_56664 = (0);
while(true){
if((i__56624_56664 < count__56623_56663)){
var req_56665 = cljs.core._nth.call(null,chunk__56622_56662,i__56624_56664);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_56665,prov);

var G__56666 = seq__56621_56661;
var G__56667 = chunk__56622_56662;
var G__56668 = count__56623_56663;
var G__56669 = (i__56624_56664 + (1));
seq__56621_56661 = G__56666;
chunk__56622_56662 = G__56667;
count__56623_56663 = G__56668;
i__56624_56664 = G__56669;
continue;
} else {
var temp__5459__auto___56670__$1 = cljs.core.seq.call(null,seq__56621_56661);
if(temp__5459__auto___56670__$1){
var seq__56621_56671__$1 = temp__5459__auto___56670__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56621_56671__$1)){
var c__48006__auto___56672 = cljs.core.chunk_first.call(null,seq__56621_56671__$1);
var G__56673 = cljs.core.chunk_rest.call(null,seq__56621_56671__$1);
var G__56674 = c__48006__auto___56672;
var G__56675 = cljs.core.count.call(null,c__48006__auto___56672);
var G__56676 = (0);
seq__56621_56661 = G__56673;
chunk__56622_56662 = G__56674;
count__56623_56663 = G__56675;
i__56624_56664 = G__56676;
continue;
} else {
var req_56677 = cljs.core.first.call(null,seq__56621_56671__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_56677,prov);

var G__56678 = cljs.core.next.call(null,seq__56621_56671__$1);
var G__56679 = null;
var G__56680 = (0);
var G__56681 = (0);
seq__56621_56661 = G__56678;
chunk__56622_56662 = G__56679;
count__56623_56663 = G__56680;
i__56624_56664 = G__56681;
continue;
}
} else {
}
}
break;
}

var G__56682 = cljs.core.next.call(null,seq__56606__$1);
var G__56683 = null;
var G__56684 = (0);
var G__56685 = (0);
seq__56606 = G__56682;
chunk__56607 = G__56683;
count__56608 = G__56684;
i__56609 = G__56685;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__56686_56690 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__56687_56691 = null;
var count__56688_56692 = (0);
var i__56689_56693 = (0);
while(true){
if((i__56689_56693 < count__56688_56692)){
var ns_56694 = cljs.core._nth.call(null,chunk__56687_56691,i__56689_56693);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_56694);

var G__56695 = seq__56686_56690;
var G__56696 = chunk__56687_56691;
var G__56697 = count__56688_56692;
var G__56698 = (i__56689_56693 + (1));
seq__56686_56690 = G__56695;
chunk__56687_56691 = G__56696;
count__56688_56692 = G__56697;
i__56689_56693 = G__56698;
continue;
} else {
var temp__5459__auto___56699 = cljs.core.seq.call(null,seq__56686_56690);
if(temp__5459__auto___56699){
var seq__56686_56700__$1 = temp__5459__auto___56699;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__56686_56700__$1)){
var c__48006__auto___56701 = cljs.core.chunk_first.call(null,seq__56686_56700__$1);
var G__56702 = cljs.core.chunk_rest.call(null,seq__56686_56700__$1);
var G__56703 = c__48006__auto___56701;
var G__56704 = cljs.core.count.call(null,c__48006__auto___56701);
var G__56705 = (0);
seq__56686_56690 = G__56702;
chunk__56687_56691 = G__56703;
count__56688_56692 = G__56704;
i__56689_56693 = G__56705;
continue;
} else {
var ns_56706 = cljs.core.first.call(null,seq__56686_56700__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_56706);

var G__56707 = cljs.core.next.call(null,seq__56686_56700__$1);
var G__56708 = null;
var G__56709 = (0);
var G__56710 = (0);
seq__56686_56690 = G__56707;
chunk__56687_56691 = G__56708;
count__56688_56692 = G__56709;
i__56689_56693 = G__56710;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__47075__auto__ = goog.require__;
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__56714__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__56714 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__56715__i = 0, G__56715__a = new Array(arguments.length -  0);
while (G__56715__i < G__56715__a.length) {G__56715__a[G__56715__i] = arguments[G__56715__i + 0]; ++G__56715__i;}
  args = new cljs.core.IndexedSeq(G__56715__a,0,null);
} 
return G__56714__delegate.call(this,args);};
G__56714.cljs$lang$maxFixedArity = 0;
G__56714.cljs$lang$applyTo = (function (arglist__56716){
var args = cljs.core.seq(arglist__56716);
return G__56714__delegate(args);
});
G__56714.cljs$core$IFn$_invoke$arity$variadic = G__56714__delegate;
return G__56714;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__56717_SHARP_,p2__56718_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__56717_SHARP_)].join('')),p2__56718_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__56719_SHARP_,p2__56720_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__56719_SHARP_)].join(''),p2__56720_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__56724 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__56724.addCallback(((function (G__56724){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__56724))
);

G__56724.addErrback(((function (G__56724){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__56724))
);

return G__56724;
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__56729 = cljs.core._EQ_;
var expr__56730 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__56729.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__56730))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__56729,expr__56730){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__56729,expr__56730))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__56729,expr__56730){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e56732){if((e56732 instanceof Error)){
var e = e56732;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e56732;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__56729,expr__56730))
} else {
if(cljs.core.truth_(pred__56729.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__56730))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__56729.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__56730))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__56729.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__56730))){
return ((function (pred__56729,expr__56730){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e56733){if((e56733 instanceof Error)){
var e = e56733;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e56733;

}
}})());
});
;})(pred__56729,expr__56730))
} else {
return ((function (pred__56729,expr__56730){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__56729,expr__56730))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__56736,callback){
var map__56737 = p__56736;
var map__56737__$1 = ((((!((map__56737 == null)))?((((map__56737.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56737.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56737):map__56737);
var file_msg = map__56737__$1;
var request_url = cljs.core.get.call(null,map__56737__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__56737,map__56737__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__56737,map__56737__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__54472__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto__){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto__){
return (function (state_56765){
var state_val_56766 = (state_56765[(1)]);
if((state_val_56766 === (7))){
var inst_56761 = (state_56765[(2)]);
var state_56765__$1 = state_56765;
var statearr_56770_56789 = state_56765__$1;
(statearr_56770_56789[(2)] = inst_56761);

(statearr_56770_56789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56766 === (1))){
var state_56765__$1 = state_56765;
var statearr_56771_56790 = state_56765__$1;
(statearr_56771_56790[(2)] = null);

(statearr_56771_56790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56766 === (4))){
var inst_56745 = (state_56765[(7)]);
var inst_56745__$1 = (state_56765[(2)]);
var state_56765__$1 = (function (){var statearr_56773 = state_56765;
(statearr_56773[(7)] = inst_56745__$1);

return statearr_56773;
})();
if(cljs.core.truth_(inst_56745__$1)){
var statearr_56775_56807 = state_56765__$1;
(statearr_56775_56807[(1)] = (5));

} else {
var statearr_56776_56811 = state_56765__$1;
(statearr_56776_56811[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56766 === (6))){
var state_56765__$1 = state_56765;
var statearr_56777_56812 = state_56765__$1;
(statearr_56777_56812[(2)] = null);

(statearr_56777_56812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56766 === (3))){
var inst_56763 = (state_56765[(2)]);
var state_56765__$1 = state_56765;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56765__$1,inst_56763);
} else {
if((state_val_56766 === (2))){
var state_56765__$1 = state_56765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56765__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_56766 === (11))){
var inst_56757 = (state_56765[(2)]);
var state_56765__$1 = (function (){var statearr_56778 = state_56765;
(statearr_56778[(8)] = inst_56757);

return statearr_56778;
})();
var statearr_56779_56816 = state_56765__$1;
(statearr_56779_56816[(2)] = null);

(statearr_56779_56816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56766 === (9))){
var inst_56749 = (state_56765[(9)]);
var inst_56751 = (state_56765[(10)]);
var inst_56753 = inst_56751.call(null,inst_56749);
var state_56765__$1 = state_56765;
var statearr_56780_56820 = state_56765__$1;
(statearr_56780_56820[(2)] = inst_56753);

(statearr_56780_56820[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56766 === (5))){
var inst_56745 = (state_56765[(7)]);
var inst_56747 = figwheel.client.file_reloading.blocking_load.call(null,inst_56745);
var state_56765__$1 = state_56765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56765__$1,(8),inst_56747);
} else {
if((state_val_56766 === (10))){
var inst_56749 = (state_56765[(9)]);
var inst_56755 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_56749);
var state_56765__$1 = state_56765;
var statearr_56781_56822 = state_56765__$1;
(statearr_56781_56822[(2)] = inst_56755);

(statearr_56781_56822[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56766 === (8))){
var inst_56745 = (state_56765[(7)]);
var inst_56751 = (state_56765[(10)]);
var inst_56749 = (state_56765[(2)]);
var inst_56750 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_56751__$1 = cljs.core.get.call(null,inst_56750,inst_56745);
var state_56765__$1 = (function (){var statearr_56782 = state_56765;
(statearr_56782[(9)] = inst_56749);

(statearr_56782[(10)] = inst_56751__$1);

return statearr_56782;
})();
if(cljs.core.truth_(inst_56751__$1)){
var statearr_56783_56823 = state_56765__$1;
(statearr_56783_56823[(1)] = (9));

} else {
var statearr_56784_56824 = state_56765__$1;
(statearr_56784_56824[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto__))
;
return ((function (switch__54129__auto__,c__54472__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__54130__auto__ = null;
var figwheel$client$file_reloading$state_machine__54130__auto____0 = (function (){
var statearr_56785 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_56785[(0)] = figwheel$client$file_reloading$state_machine__54130__auto__);

(statearr_56785[(1)] = (1));

return statearr_56785;
});
var figwheel$client$file_reloading$state_machine__54130__auto____1 = (function (state_56765){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_56765);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e56786){if((e56786 instanceof Object)){
var ex__54133__auto__ = e56786;
var statearr_56787_56825 = state_56765;
(statearr_56787_56825[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56765);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56786;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56826 = state_56765;
state_56765 = G__56826;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__54130__auto__ = function(state_56765){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__54130__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__54130__auto____1.call(this,state_56765);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__54130__auto____0;
figwheel$client$file_reloading$state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__54130__auto____1;
return figwheel$client$file_reloading$state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto__))
})();
var state__54474__auto__ = (function (){var statearr_56788 = f__54473__auto__.call(null);
(statearr_56788[(6)] = c__54472__auto__);

return statearr_56788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto__))
);

return c__54472__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__56828,callback){
var map__56829 = p__56828;
var map__56829__$1 = ((((!((map__56829 == null)))?((((map__56829.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56829.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56829):map__56829);
var file_msg = map__56829__$1;
var namespace = cljs.core.get.call(null,map__56829__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__56829,map__56829__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__56829,map__56829__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__56845){
var map__56846 = p__56845;
var map__56846__$1 = ((((!((map__56846 == null)))?((((map__56846.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56846.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56846):map__56846);
var file_msg = map__56846__$1;
var namespace = cljs.core.get.call(null,map__56846__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__56853){
var map__56854 = p__56853;
var map__56854__$1 = ((((!((map__56854 == null)))?((((map__56854.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56854.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56854):map__56854);
var file_msg = map__56854__$1;
var namespace = cljs.core.get.call(null,map__56854__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__47063__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__47063__auto__){
var or__47075__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__47075__auto__)){
return or__47075__auto__;
} else {
var or__47075__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__47075__auto____$1)){
return or__47075__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__47063__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__56858,callback){
var map__56859 = p__56858;
var map__56859__$1 = ((((!((map__56859 == null)))?((((map__56859.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56859.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56859):map__56859);
var file_msg = map__56859__$1;
var request_url = cljs.core.get.call(null,map__56859__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__56859__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__54472__auto___56909 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto___56909,out){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto___56909,out){
return (function (state_56894){
var state_val_56895 = (state_56894[(1)]);
if((state_val_56895 === (1))){
var inst_56868 = cljs.core.seq.call(null,files);
var inst_56869 = cljs.core.first.call(null,inst_56868);
var inst_56870 = cljs.core.next.call(null,inst_56868);
var inst_56871 = files;
var state_56894__$1 = (function (){var statearr_56896 = state_56894;
(statearr_56896[(7)] = inst_56869);

(statearr_56896[(8)] = inst_56871);

(statearr_56896[(9)] = inst_56870);

return statearr_56896;
})();
var statearr_56897_56910 = state_56894__$1;
(statearr_56897_56910[(2)] = null);

(statearr_56897_56910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56895 === (2))){
var inst_56871 = (state_56894[(8)]);
var inst_56877 = (state_56894[(10)]);
var inst_56876 = cljs.core.seq.call(null,inst_56871);
var inst_56877__$1 = cljs.core.first.call(null,inst_56876);
var inst_56878 = cljs.core.next.call(null,inst_56876);
var inst_56879 = (inst_56877__$1 == null);
var inst_56880 = cljs.core.not.call(null,inst_56879);
var state_56894__$1 = (function (){var statearr_56898 = state_56894;
(statearr_56898[(11)] = inst_56878);

(statearr_56898[(10)] = inst_56877__$1);

return statearr_56898;
})();
if(inst_56880){
var statearr_56899_56911 = state_56894__$1;
(statearr_56899_56911[(1)] = (4));

} else {
var statearr_56900_56912 = state_56894__$1;
(statearr_56900_56912[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56895 === (3))){
var inst_56892 = (state_56894[(2)]);
var state_56894__$1 = state_56894;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56894__$1,inst_56892);
} else {
if((state_val_56895 === (4))){
var inst_56877 = (state_56894[(10)]);
var inst_56882 = figwheel.client.file_reloading.reload_js_file.call(null,inst_56877);
var state_56894__$1 = state_56894;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56894__$1,(7),inst_56882);
} else {
if((state_val_56895 === (5))){
var inst_56888 = cljs.core.async.close_BANG_.call(null,out);
var state_56894__$1 = state_56894;
var statearr_56901_56913 = state_56894__$1;
(statearr_56901_56913[(2)] = inst_56888);

(statearr_56901_56913[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56895 === (6))){
var inst_56890 = (state_56894[(2)]);
var state_56894__$1 = state_56894;
var statearr_56902_56914 = state_56894__$1;
(statearr_56902_56914[(2)] = inst_56890);

(statearr_56902_56914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56895 === (7))){
var inst_56878 = (state_56894[(11)]);
var inst_56884 = (state_56894[(2)]);
var inst_56885 = cljs.core.async.put_BANG_.call(null,out,inst_56884);
var inst_56871 = inst_56878;
var state_56894__$1 = (function (){var statearr_56903 = state_56894;
(statearr_56903[(12)] = inst_56885);

(statearr_56903[(8)] = inst_56871);

return statearr_56903;
})();
var statearr_56904_56915 = state_56894__$1;
(statearr_56904_56915[(2)] = null);

(statearr_56904_56915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__54472__auto___56909,out))
;
return ((function (switch__54129__auto__,c__54472__auto___56909,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto____0 = (function (){
var statearr_56905 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56905[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto__);

(statearr_56905[(1)] = (1));

return statearr_56905;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto____1 = (function (state_56894){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_56894);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e56906){if((e56906 instanceof Object)){
var ex__54133__auto__ = e56906;
var statearr_56907_56916 = state_56894;
(statearr_56907_56916[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_56894);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e56906;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56917 = state_56894;
state_56894 = G__56917;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto__ = function(state_56894){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto____1.call(this,state_56894);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto___56909,out))
})();
var state__54474__auto__ = (function (){var statearr_56908 = f__54473__auto__.call(null);
(statearr_56908[(6)] = c__54472__auto___56909);

return statearr_56908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto___56909,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__56918,opts){
var map__56919 = p__56918;
var map__56919__$1 = ((((!((map__56919 == null)))?((((map__56919.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56919.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56919):map__56919);
var eval_body = cljs.core.get.call(null,map__56919__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__56919__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__47063__auto__ = eval_body;
if(cljs.core.truth_(and__47063__auto__)){
return typeof eval_body === 'string';
} else {
return and__47063__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e56921){var e = e56921;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__5457__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__56922_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__56922_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__5457__auto__)){
var file_msg = temp__5457__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__56923){
var vec__56924 = p__56923;
var k = cljs.core.nth.call(null,vec__56924,(0),null);
var v = cljs.core.nth.call(null,vec__56924,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__56927){
var vec__56928 = p__56927;
var k = cljs.core.nth.call(null,vec__56928,(0),null);
var v = cljs.core.nth.call(null,vec__56928,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__56934,p__56935){
var map__56936 = p__56934;
var map__56936__$1 = ((((!((map__56936 == null)))?((((map__56936.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56936.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56936):map__56936);
var opts = map__56936__$1;
var before_jsload = cljs.core.get.call(null,map__56936__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__56936__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__56936__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__56937 = p__56935;
var map__56937__$1 = ((((!((map__56937 == null)))?((((map__56937.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56937.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__56937):map__56937);
var msg = map__56937__$1;
var files = cljs.core.get.call(null,map__56937__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__56937__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__56937__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__54472__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__54473__auto__ = (function (){var switch__54129__auto__ = ((function (c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_57091){
var state_val_57092 = (state_57091[(1)]);
if((state_val_57092 === (7))){
var inst_56953 = (state_57091[(7)]);
var inst_56954 = (state_57091[(8)]);
var inst_56951 = (state_57091[(9)]);
var inst_56952 = (state_57091[(10)]);
var inst_56959 = cljs.core._nth.call(null,inst_56952,inst_56954);
var inst_56960 = figwheel.client.file_reloading.eval_body.call(null,inst_56959,opts);
var inst_56961 = (inst_56954 + (1));
var tmp57093 = inst_56953;
var tmp57094 = inst_56951;
var tmp57095 = inst_56952;
var inst_56951__$1 = tmp57094;
var inst_56952__$1 = tmp57095;
var inst_56953__$1 = tmp57093;
var inst_56954__$1 = inst_56961;
var state_57091__$1 = (function (){var statearr_57096 = state_57091;
(statearr_57096[(7)] = inst_56953__$1);

(statearr_57096[(8)] = inst_56954__$1);

(statearr_57096[(9)] = inst_56951__$1);

(statearr_57096[(11)] = inst_56960);

(statearr_57096[(10)] = inst_56952__$1);

return statearr_57096;
})();
var statearr_57097_57180 = state_57091__$1;
(statearr_57097_57180[(2)] = null);

(statearr_57097_57180[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (20))){
var inst_56994 = (state_57091[(12)]);
var inst_57002 = figwheel.client.file_reloading.sort_files.call(null,inst_56994);
var state_57091__$1 = state_57091;
var statearr_57098_57181 = state_57091__$1;
(statearr_57098_57181[(2)] = inst_57002);

(statearr_57098_57181[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (27))){
var state_57091__$1 = state_57091;
var statearr_57099_57182 = state_57091__$1;
(statearr_57099_57182[(2)] = null);

(statearr_57099_57182[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (1))){
var inst_56943 = (state_57091[(13)]);
var inst_56940 = before_jsload.call(null,files);
var inst_56941 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_56942 = (function (){return ((function (inst_56943,inst_56940,inst_56941,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__56931_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__56931_SHARP_);
});
;})(inst_56943,inst_56940,inst_56941,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_56943__$1 = cljs.core.filter.call(null,inst_56942,files);
var inst_56944 = cljs.core.not_empty.call(null,inst_56943__$1);
var state_57091__$1 = (function (){var statearr_57100 = state_57091;
(statearr_57100[(14)] = inst_56940);

(statearr_57100[(13)] = inst_56943__$1);

(statearr_57100[(15)] = inst_56941);

return statearr_57100;
})();
if(cljs.core.truth_(inst_56944)){
var statearr_57101_57183 = state_57091__$1;
(statearr_57101_57183[(1)] = (2));

} else {
var statearr_57102_57184 = state_57091__$1;
(statearr_57102_57184[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (24))){
var state_57091__$1 = state_57091;
var statearr_57103_57185 = state_57091__$1;
(statearr_57103_57185[(2)] = null);

(statearr_57103_57185[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (39))){
var inst_57044 = (state_57091[(16)]);
var state_57091__$1 = state_57091;
var statearr_57104_57186 = state_57091__$1;
(statearr_57104_57186[(2)] = inst_57044);

(statearr_57104_57186[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (46))){
var inst_57086 = (state_57091[(2)]);
var state_57091__$1 = state_57091;
var statearr_57105_57187 = state_57091__$1;
(statearr_57105_57187[(2)] = inst_57086);

(statearr_57105_57187[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (4))){
var inst_56988 = (state_57091[(2)]);
var inst_56989 = cljs.core.List.EMPTY;
var inst_56990 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_56989);
var inst_56991 = (function (){return ((function (inst_56988,inst_56989,inst_56990,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__56932_SHARP_){
var and__47063__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__56932_SHARP_);
if(cljs.core.truth_(and__47063__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__56932_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__56932_SHARP_)));
} else {
return and__47063__auto__;
}
});
;})(inst_56988,inst_56989,inst_56990,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_56992 = cljs.core.filter.call(null,inst_56991,files);
var inst_56993 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_56994 = cljs.core.concat.call(null,inst_56992,inst_56993);
var state_57091__$1 = (function (){var statearr_57106 = state_57091;
(statearr_57106[(17)] = inst_56990);

(statearr_57106[(18)] = inst_56988);

(statearr_57106[(12)] = inst_56994);

return statearr_57106;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_57107_57188 = state_57091__$1;
(statearr_57107_57188[(1)] = (16));

} else {
var statearr_57108_57189 = state_57091__$1;
(statearr_57108_57189[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (15))){
var inst_56978 = (state_57091[(2)]);
var state_57091__$1 = state_57091;
var statearr_57109_57190 = state_57091__$1;
(statearr_57109_57190[(2)] = inst_56978);

(statearr_57109_57190[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (21))){
var inst_57004 = (state_57091[(19)]);
var inst_57004__$1 = (state_57091[(2)]);
var inst_57005 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_57004__$1);
var state_57091__$1 = (function (){var statearr_57110 = state_57091;
(statearr_57110[(19)] = inst_57004__$1);

return statearr_57110;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57091__$1,(22),inst_57005);
} else {
if((state_val_57092 === (31))){
var inst_57089 = (state_57091[(2)]);
var state_57091__$1 = state_57091;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57091__$1,inst_57089);
} else {
if((state_val_57092 === (32))){
var inst_57044 = (state_57091[(16)]);
var inst_57049 = inst_57044.cljs$lang$protocol_mask$partition0$;
var inst_57050 = (inst_57049 & (64));
var inst_57051 = inst_57044.cljs$core$ISeq$;
var inst_57052 = (cljs.core.PROTOCOL_SENTINEL === inst_57051);
var inst_57053 = (inst_57050) || (inst_57052);
var state_57091__$1 = state_57091;
if(cljs.core.truth_(inst_57053)){
var statearr_57111_57191 = state_57091__$1;
(statearr_57111_57191[(1)] = (35));

} else {
var statearr_57112_57192 = state_57091__$1;
(statearr_57112_57192[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (40))){
var inst_57066 = (state_57091[(20)]);
var inst_57065 = (state_57091[(2)]);
var inst_57066__$1 = cljs.core.get.call(null,inst_57065,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_57067 = cljs.core.get.call(null,inst_57065,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_57068 = cljs.core.not_empty.call(null,inst_57066__$1);
var state_57091__$1 = (function (){var statearr_57113 = state_57091;
(statearr_57113[(21)] = inst_57067);

(statearr_57113[(20)] = inst_57066__$1);

return statearr_57113;
})();
if(cljs.core.truth_(inst_57068)){
var statearr_57114_57193 = state_57091__$1;
(statearr_57114_57193[(1)] = (41));

} else {
var statearr_57115_57194 = state_57091__$1;
(statearr_57115_57194[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (33))){
var state_57091__$1 = state_57091;
var statearr_57116_57195 = state_57091__$1;
(statearr_57116_57195[(2)] = false);

(statearr_57116_57195[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (13))){
var inst_56964 = (state_57091[(22)]);
var inst_56968 = cljs.core.chunk_first.call(null,inst_56964);
var inst_56969 = cljs.core.chunk_rest.call(null,inst_56964);
var inst_56970 = cljs.core.count.call(null,inst_56968);
var inst_56951 = inst_56969;
var inst_56952 = inst_56968;
var inst_56953 = inst_56970;
var inst_56954 = (0);
var state_57091__$1 = (function (){var statearr_57117 = state_57091;
(statearr_57117[(7)] = inst_56953);

(statearr_57117[(8)] = inst_56954);

(statearr_57117[(9)] = inst_56951);

(statearr_57117[(10)] = inst_56952);

return statearr_57117;
})();
var statearr_57118_57196 = state_57091__$1;
(statearr_57118_57196[(2)] = null);

(statearr_57118_57196[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (22))){
var inst_57012 = (state_57091[(23)]);
var inst_57008 = (state_57091[(24)]);
var inst_57007 = (state_57091[(25)]);
var inst_57004 = (state_57091[(19)]);
var inst_57007__$1 = (state_57091[(2)]);
var inst_57008__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_57007__$1);
var inst_57009 = (function (){var all_files = inst_57004;
var res_SINGLEQUOTE_ = inst_57007__$1;
var res = inst_57008__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_57012,inst_57008,inst_57007,inst_57004,inst_57007__$1,inst_57008__$1,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__56933_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__56933_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_57012,inst_57008,inst_57007,inst_57004,inst_57007__$1,inst_57008__$1,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57010 = cljs.core.filter.call(null,inst_57009,inst_57007__$1);
var inst_57011 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_57012__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_57011);
var inst_57013 = cljs.core.not_empty.call(null,inst_57012__$1);
var state_57091__$1 = (function (){var statearr_57119 = state_57091;
(statearr_57119[(23)] = inst_57012__$1);

(statearr_57119[(24)] = inst_57008__$1);

(statearr_57119[(26)] = inst_57010);

(statearr_57119[(25)] = inst_57007__$1);

return statearr_57119;
})();
if(cljs.core.truth_(inst_57013)){
var statearr_57120_57197 = state_57091__$1;
(statearr_57120_57197[(1)] = (23));

} else {
var statearr_57121_57198 = state_57091__$1;
(statearr_57121_57198[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (36))){
var state_57091__$1 = state_57091;
var statearr_57122_57199 = state_57091__$1;
(statearr_57122_57199[(2)] = false);

(statearr_57122_57199[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (41))){
var inst_57066 = (state_57091[(20)]);
var inst_57070 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_57071 = cljs.core.map.call(null,inst_57070,inst_57066);
var inst_57072 = cljs.core.pr_str.call(null,inst_57071);
var inst_57073 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57072)].join('');
var inst_57074 = figwheel.client.utils.log.call(null,inst_57073);
var state_57091__$1 = state_57091;
var statearr_57123_57200 = state_57091__$1;
(statearr_57123_57200[(2)] = inst_57074);

(statearr_57123_57200[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (43))){
var inst_57067 = (state_57091[(21)]);
var inst_57077 = (state_57091[(2)]);
var inst_57078 = cljs.core.not_empty.call(null,inst_57067);
var state_57091__$1 = (function (){var statearr_57124 = state_57091;
(statearr_57124[(27)] = inst_57077);

return statearr_57124;
})();
if(cljs.core.truth_(inst_57078)){
var statearr_57125_57201 = state_57091__$1;
(statearr_57125_57201[(1)] = (44));

} else {
var statearr_57126_57202 = state_57091__$1;
(statearr_57126_57202[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (29))){
var inst_57012 = (state_57091[(23)]);
var inst_57044 = (state_57091[(16)]);
var inst_57008 = (state_57091[(24)]);
var inst_57010 = (state_57091[(26)]);
var inst_57007 = (state_57091[(25)]);
var inst_57004 = (state_57091[(19)]);
var inst_57040 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_57043 = (function (){var all_files = inst_57004;
var res_SINGLEQUOTE_ = inst_57007;
var res = inst_57008;
var files_not_loaded = inst_57010;
var dependencies_that_loaded = inst_57012;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57012,inst_57044,inst_57008,inst_57010,inst_57007,inst_57004,inst_57040,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__57042){
var map__57127 = p__57042;
var map__57127__$1 = ((((!((map__57127 == null)))?((((map__57127.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57127.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57127):map__57127);
var namespace = cljs.core.get.call(null,map__57127__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57012,inst_57044,inst_57008,inst_57010,inst_57007,inst_57004,inst_57040,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57044__$1 = cljs.core.group_by.call(null,inst_57043,inst_57010);
var inst_57046 = (inst_57044__$1 == null);
var inst_57047 = cljs.core.not.call(null,inst_57046);
var state_57091__$1 = (function (){var statearr_57129 = state_57091;
(statearr_57129[(16)] = inst_57044__$1);

(statearr_57129[(28)] = inst_57040);

return statearr_57129;
})();
if(inst_57047){
var statearr_57130_57203 = state_57091__$1;
(statearr_57130_57203[(1)] = (32));

} else {
var statearr_57131_57204 = state_57091__$1;
(statearr_57131_57204[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (44))){
var inst_57067 = (state_57091[(21)]);
var inst_57080 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_57067);
var inst_57081 = cljs.core.pr_str.call(null,inst_57080);
var inst_57082 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57081)].join('');
var inst_57083 = figwheel.client.utils.log.call(null,inst_57082);
var state_57091__$1 = state_57091;
var statearr_57132_57205 = state_57091__$1;
(statearr_57132_57205[(2)] = inst_57083);

(statearr_57132_57205[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (6))){
var inst_56985 = (state_57091[(2)]);
var state_57091__$1 = state_57091;
var statearr_57133_57206 = state_57091__$1;
(statearr_57133_57206[(2)] = inst_56985);

(statearr_57133_57206[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (28))){
var inst_57010 = (state_57091[(26)]);
var inst_57037 = (state_57091[(2)]);
var inst_57038 = cljs.core.not_empty.call(null,inst_57010);
var state_57091__$1 = (function (){var statearr_57134 = state_57091;
(statearr_57134[(29)] = inst_57037);

return statearr_57134;
})();
if(cljs.core.truth_(inst_57038)){
var statearr_57135_57207 = state_57091__$1;
(statearr_57135_57207[(1)] = (29));

} else {
var statearr_57136_57208 = state_57091__$1;
(statearr_57136_57208[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (25))){
var inst_57008 = (state_57091[(24)]);
var inst_57024 = (state_57091[(2)]);
var inst_57025 = cljs.core.not_empty.call(null,inst_57008);
var state_57091__$1 = (function (){var statearr_57137 = state_57091;
(statearr_57137[(30)] = inst_57024);

return statearr_57137;
})();
if(cljs.core.truth_(inst_57025)){
var statearr_57138_57209 = state_57091__$1;
(statearr_57138_57209[(1)] = (26));

} else {
var statearr_57139_57210 = state_57091__$1;
(statearr_57139_57210[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (34))){
var inst_57060 = (state_57091[(2)]);
var state_57091__$1 = state_57091;
if(cljs.core.truth_(inst_57060)){
var statearr_57140_57211 = state_57091__$1;
(statearr_57140_57211[(1)] = (38));

} else {
var statearr_57141_57212 = state_57091__$1;
(statearr_57141_57212[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (17))){
var state_57091__$1 = state_57091;
var statearr_57142_57213 = state_57091__$1;
(statearr_57142_57213[(2)] = recompile_dependents);

(statearr_57142_57213[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (3))){
var state_57091__$1 = state_57091;
var statearr_57143_57214 = state_57091__$1;
(statearr_57143_57214[(2)] = null);

(statearr_57143_57214[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (12))){
var inst_56981 = (state_57091[(2)]);
var state_57091__$1 = state_57091;
var statearr_57144_57215 = state_57091__$1;
(statearr_57144_57215[(2)] = inst_56981);

(statearr_57144_57215[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (2))){
var inst_56943 = (state_57091[(13)]);
var inst_56950 = cljs.core.seq.call(null,inst_56943);
var inst_56951 = inst_56950;
var inst_56952 = null;
var inst_56953 = (0);
var inst_56954 = (0);
var state_57091__$1 = (function (){var statearr_57145 = state_57091;
(statearr_57145[(7)] = inst_56953);

(statearr_57145[(8)] = inst_56954);

(statearr_57145[(9)] = inst_56951);

(statearr_57145[(10)] = inst_56952);

return statearr_57145;
})();
var statearr_57146_57216 = state_57091__$1;
(statearr_57146_57216[(2)] = null);

(statearr_57146_57216[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (23))){
var inst_57012 = (state_57091[(23)]);
var inst_57008 = (state_57091[(24)]);
var inst_57010 = (state_57091[(26)]);
var inst_57007 = (state_57091[(25)]);
var inst_57004 = (state_57091[(19)]);
var inst_57015 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_57017 = (function (){var all_files = inst_57004;
var res_SINGLEQUOTE_ = inst_57007;
var res = inst_57008;
var files_not_loaded = inst_57010;
var dependencies_that_loaded = inst_57012;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57012,inst_57008,inst_57010,inst_57007,inst_57004,inst_57015,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__57016){
var map__57147 = p__57016;
var map__57147__$1 = ((((!((map__57147 == null)))?((((map__57147.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57147.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57147):map__57147);
var request_url = cljs.core.get.call(null,map__57147__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57012,inst_57008,inst_57010,inst_57007,inst_57004,inst_57015,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57018 = cljs.core.reverse.call(null,inst_57012);
var inst_57019 = cljs.core.map.call(null,inst_57017,inst_57018);
var inst_57020 = cljs.core.pr_str.call(null,inst_57019);
var inst_57021 = figwheel.client.utils.log.call(null,inst_57020);
var state_57091__$1 = (function (){var statearr_57149 = state_57091;
(statearr_57149[(31)] = inst_57015);

return statearr_57149;
})();
var statearr_57150_57217 = state_57091__$1;
(statearr_57150_57217[(2)] = inst_57021);

(statearr_57150_57217[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (35))){
var state_57091__$1 = state_57091;
var statearr_57151_57218 = state_57091__$1;
(statearr_57151_57218[(2)] = true);

(statearr_57151_57218[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (19))){
var inst_56994 = (state_57091[(12)]);
var inst_57000 = figwheel.client.file_reloading.expand_files.call(null,inst_56994);
var state_57091__$1 = state_57091;
var statearr_57152_57219 = state_57091__$1;
(statearr_57152_57219[(2)] = inst_57000);

(statearr_57152_57219[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (11))){
var state_57091__$1 = state_57091;
var statearr_57153_57220 = state_57091__$1;
(statearr_57153_57220[(2)] = null);

(statearr_57153_57220[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (9))){
var inst_56983 = (state_57091[(2)]);
var state_57091__$1 = state_57091;
var statearr_57154_57221 = state_57091__$1;
(statearr_57154_57221[(2)] = inst_56983);

(statearr_57154_57221[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (5))){
var inst_56953 = (state_57091[(7)]);
var inst_56954 = (state_57091[(8)]);
var inst_56956 = (inst_56954 < inst_56953);
var inst_56957 = inst_56956;
var state_57091__$1 = state_57091;
if(cljs.core.truth_(inst_56957)){
var statearr_57155_57222 = state_57091__$1;
(statearr_57155_57222[(1)] = (7));

} else {
var statearr_57156_57223 = state_57091__$1;
(statearr_57156_57223[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (14))){
var inst_56964 = (state_57091[(22)]);
var inst_56973 = cljs.core.first.call(null,inst_56964);
var inst_56974 = figwheel.client.file_reloading.eval_body.call(null,inst_56973,opts);
var inst_56975 = cljs.core.next.call(null,inst_56964);
var inst_56951 = inst_56975;
var inst_56952 = null;
var inst_56953 = (0);
var inst_56954 = (0);
var state_57091__$1 = (function (){var statearr_57157 = state_57091;
(statearr_57157[(7)] = inst_56953);

(statearr_57157[(8)] = inst_56954);

(statearr_57157[(32)] = inst_56974);

(statearr_57157[(9)] = inst_56951);

(statearr_57157[(10)] = inst_56952);

return statearr_57157;
})();
var statearr_57158_57224 = state_57091__$1;
(statearr_57158_57224[(2)] = null);

(statearr_57158_57224[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (45))){
var state_57091__$1 = state_57091;
var statearr_57159_57225 = state_57091__$1;
(statearr_57159_57225[(2)] = null);

(statearr_57159_57225[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (26))){
var inst_57012 = (state_57091[(23)]);
var inst_57008 = (state_57091[(24)]);
var inst_57010 = (state_57091[(26)]);
var inst_57007 = (state_57091[(25)]);
var inst_57004 = (state_57091[(19)]);
var inst_57027 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_57029 = (function (){var all_files = inst_57004;
var res_SINGLEQUOTE_ = inst_57007;
var res = inst_57008;
var files_not_loaded = inst_57010;
var dependencies_that_loaded = inst_57012;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57012,inst_57008,inst_57010,inst_57007,inst_57004,inst_57027,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__57028){
var map__57160 = p__57028;
var map__57160__$1 = ((((!((map__57160 == null)))?((((map__57160.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57160.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57160):map__57160);
var namespace = cljs.core.get.call(null,map__57160__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__57160__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57012,inst_57008,inst_57010,inst_57007,inst_57004,inst_57027,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57030 = cljs.core.map.call(null,inst_57029,inst_57008);
var inst_57031 = cljs.core.pr_str.call(null,inst_57030);
var inst_57032 = figwheel.client.utils.log.call(null,inst_57031);
var inst_57033 = (function (){var all_files = inst_57004;
var res_SINGLEQUOTE_ = inst_57007;
var res = inst_57008;
var files_not_loaded = inst_57010;
var dependencies_that_loaded = inst_57012;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57012,inst_57008,inst_57010,inst_57007,inst_57004,inst_57027,inst_57029,inst_57030,inst_57031,inst_57032,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_57012,inst_57008,inst_57010,inst_57007,inst_57004,inst_57027,inst_57029,inst_57030,inst_57031,inst_57032,state_val_57092,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_57034 = setTimeout(inst_57033,(10));
var state_57091__$1 = (function (){var statearr_57162 = state_57091;
(statearr_57162[(33)] = inst_57027);

(statearr_57162[(34)] = inst_57032);

return statearr_57162;
})();
var statearr_57163_57226 = state_57091__$1;
(statearr_57163_57226[(2)] = inst_57034);

(statearr_57163_57226[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (16))){
var state_57091__$1 = state_57091;
var statearr_57164_57227 = state_57091__$1;
(statearr_57164_57227[(2)] = reload_dependents);

(statearr_57164_57227[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (38))){
var inst_57044 = (state_57091[(16)]);
var inst_57062 = cljs.core.apply.call(null,cljs.core.hash_map,inst_57044);
var state_57091__$1 = state_57091;
var statearr_57165_57228 = state_57091__$1;
(statearr_57165_57228[(2)] = inst_57062);

(statearr_57165_57228[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (30))){
var state_57091__$1 = state_57091;
var statearr_57166_57229 = state_57091__$1;
(statearr_57166_57229[(2)] = null);

(statearr_57166_57229[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (10))){
var inst_56964 = (state_57091[(22)]);
var inst_56966 = cljs.core.chunked_seq_QMARK_.call(null,inst_56964);
var state_57091__$1 = state_57091;
if(inst_56966){
var statearr_57167_57230 = state_57091__$1;
(statearr_57167_57230[(1)] = (13));

} else {
var statearr_57168_57231 = state_57091__$1;
(statearr_57168_57231[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (18))){
var inst_56998 = (state_57091[(2)]);
var state_57091__$1 = state_57091;
if(cljs.core.truth_(inst_56998)){
var statearr_57169_57232 = state_57091__$1;
(statearr_57169_57232[(1)] = (19));

} else {
var statearr_57170_57233 = state_57091__$1;
(statearr_57170_57233[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (42))){
var state_57091__$1 = state_57091;
var statearr_57171_57234 = state_57091__$1;
(statearr_57171_57234[(2)] = null);

(statearr_57171_57234[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (37))){
var inst_57057 = (state_57091[(2)]);
var state_57091__$1 = state_57091;
var statearr_57172_57235 = state_57091__$1;
(statearr_57172_57235[(2)] = inst_57057);

(statearr_57172_57235[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57092 === (8))){
var inst_56964 = (state_57091[(22)]);
var inst_56951 = (state_57091[(9)]);
var inst_56964__$1 = cljs.core.seq.call(null,inst_56951);
var state_57091__$1 = (function (){var statearr_57173 = state_57091;
(statearr_57173[(22)] = inst_56964__$1);

return statearr_57173;
})();
if(inst_56964__$1){
var statearr_57174_57236 = state_57091__$1;
(statearr_57174_57236[(1)] = (10));

} else {
var statearr_57175_57237 = state_57091__$1;
(statearr_57175_57237[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__54129__auto__,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto____0 = (function (){
var statearr_57176 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57176[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto__);

(statearr_57176[(1)] = (1));

return statearr_57176;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto____1 = (function (state_57091){
while(true){
var ret_value__54131__auto__ = (function (){try{while(true){
var result__54132__auto__ = switch__54129__auto__.call(null,state_57091);
if(cljs.core.keyword_identical_QMARK_.call(null,result__54132__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__54132__auto__;
}
break;
}
}catch (e57177){if((e57177 instanceof Object)){
var ex__54133__auto__ = e57177;
var statearr_57178_57238 = state_57091;
(statearr_57178_57238[(5)] = ex__54133__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_57091);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e57177;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__54131__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57239 = state_57091;
state_57091 = G__57239;
continue;
} else {
return ret_value__54131__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto__ = function(state_57091){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto____1.call(this,state_57091);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__54130__auto__;
})()
;})(switch__54129__auto__,c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__54474__auto__ = (function (){var statearr_57179 = f__54473__auto__.call(null);
(statearr_57179[(6)] = c__54472__auto__);

return statearr_57179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__54474__auto__);
});})(c__54472__auto__,map__56936,map__56936__$1,opts,before_jsload,on_jsload,reload_dependents,map__56937,map__56937__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__54472__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__57242,link){
var map__57243 = p__57242;
var map__57243__$1 = ((((!((map__57243 == null)))?((((map__57243.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57243.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57243):map__57243);
var file = cljs.core.get.call(null,map__57243__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__5459__auto__ = link.href;
if(cljs.core.truth_(temp__5459__auto__)){
var link_href = temp__5459__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__5459__auto__,map__57243,map__57243__$1,file){
return (function (p1__57240_SHARP_,p2__57241_SHARP_){
if(cljs.core._EQ_.call(null,p1__57240_SHARP_,p2__57241_SHARP_)){
return p1__57240_SHARP_;
} else {
return false;
}
});})(link_href,temp__5459__auto__,map__57243,map__57243__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5459__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__57246){
var map__57247 = p__57246;
var map__57247__$1 = ((((!((map__57247 == null)))?((((map__57247.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57247.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57247):map__57247);
var match_length = cljs.core.get.call(null,map__57247__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__57247__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__57245_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__57245_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5459__auto__)){
var res = temp__5459__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__57249_SHARP_,p2__57250_SHARP_){
return cljs.core.assoc.call(null,p1__57249_SHARP_,cljs.core.get.call(null,p2__57250_SHARP_,key),p2__57250_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5457__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5457__auto__)){
var link = temp__5457__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__5457__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__5457__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_57251 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_57251);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_57251);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__57252,p__57253){
var map__57254 = p__57252;
var map__57254__$1 = ((((!((map__57254 == null)))?((((map__57254.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57254.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57254):map__57254);
var on_cssload = cljs.core.get.call(null,map__57254__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__57255 = p__57253;
var map__57255__$1 = ((((!((map__57255 == null)))?((((map__57255.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57255.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57255):map__57255);
var files_msg = map__57255__$1;
var files = cljs.core.get.call(null,map__57255__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__5459__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__5459__auto__)){
var f_datas = temp__5459__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1509156896625
