(ns lemonade.demos.quil
  (:require #?(:cljs [lemonade.demos.util :as util])
            [quil.core :as q #?@(:cljs [:include-macros true])]
            [quil.middleware :as m]
            [lemonade.renderers.quil :refer [renderer]]
            [lemonade.examples.basic :as basic]))

(defn setup []
  ; Set frame rate to 30 frames per second.
  (q/frame-rate 3)
  (q/background 255)
  ; Set color mode to HSB (HSV) instead of default RGB.
  (q/color-mode :hsb)
  ; setup function returns initial state. It contains
  ; circle color and position.
  {:color 0
   :angle 0})

(defn update-state [_]
  @#'basic/ex)



(defn draw! [_]
  (let [r (renderer basic/ex)]
    (r)))

(defn sketch! [w h]
   (q/defsketch quil-test
     :host "canvas"
     :size [w h]
     ;; setup function called only once, during sketch initialization.
     :setup setup
     ;; update-state is called on each iteration before draw-state.
     :draw draw!
     ;; This sketch uses functional-mode middleware.
     ;; Check quil wiki for more info about middlewares and particularly
     ;; fun-mode.
))

#?(:cljs
   (defn ^:export init []
     (let [[w h] (util/canvas-container-dimensions)]
       (sketch! w h))))

#?(:cljs
   (defn on-js-reload []
     (init)))
