(ns lemonade.geometry
  (:require [lemonade.core :as core]))

(defn lookup-by-point
  "Returns the minimal subtree of world where all of the leaves contain point."
  [world point])

(defmulti extent :type)

(defmethod extent :default
  [s]
  [[0 0] [1 1]])

(declare walk*)

(defmulti walk core/classify)

(defmethod walk :default
  [shape]
  (assoc shape ::extent (extent shape)))

(defmethod walk ::core/sequential
  [shape]
  (map walk shape))

(defmethod walk ::core/composite
  [{:keys [contents] :as shape}]
  (map (fn [s] (assoc shape :contents (walk s))) contents))

(defmethod walk ::core/atx
  [shape]
  (update shape :base-shape walk))

(def walk* (memoize walk))

(defn index-world [world]
  (walk world))

;; There are two problems to keep in mind.
;;
;; The Needle in a Haystack:
;;
;; If there's only one thing we're interested in, then knowing whether it was
;; clicked on or not should take constant time.
;;
;; The General Problem:
;;
;; If there are a great number of objects of interest on the screen, then
;; determining which one(s) of them contain a given point should be at most
;; logarithmic in the number of objects.
;;
;;
;; I'm convinced that the tetrafurcation algorithm with a fixed cutoff (to be
;; tuned) will do the trick.
