(ns {{project-ns}}.core
  (:require
    [bidi.bidi :as bidi]
    [cljs.nodejs]
    [hiccups.runtime]
    [macchiato.http :refer [handler]]
    [mount.core :as mount :refer [defstate]]
    [taoensso.timbre :refer-macros [log trace debug info warn error fatal]])
  (:require-macros
    [hiccups.core :refer [html]]))

(mount/in-cljc-mode)

(cljs.nodejs/enable-util-print!)

(defstate http :start (js/require "http"))

(def routes
  ["/"
   [[""
     (fn [req res]
       (res
         {:headers {}
          :status  200
          :body    (html
                     [:html
                      [:body
                       [:h2 "Hello World!"]
                       [:p
                        "Your user-agent is: "
                        (str (-> req :headers :user-agent))]]])}))]
    [true
     (fn [req res]
       (res
         {:headers {}
          :status  404
          :body    (html
                     [:html
                      [:body
                       [:h2 (:uri req) " was not found"]]])}))]]])

(defn app []
  (let [host (or (.-HOST (.-env js/process)) "127.0.0.1")
        port (or (.-PORT (.-env js/process)) 3000)]
    (mount/start)
    (-> @http
        (.createServer (handler #(->> % :uri (bidi/match-route routes) :handler)))
        (.listen port host #(info "{{name}} started on" host ":" port)))))

(defn start-workers [cluster]
  (dotimes [_ (-> (js/require "os") .cpus .-length)]
           (.fork cluster))
  (.on cluster "exit"
       (fn [worker code signal]
         (info "worker terminated" (-> worker .-process .-pid)))))

(defn main [& args]
  (let [cluster (js/require "cluster")]
    (if (.-isMaster cluster)
      (start-workers cluster)
      (app))))

(set! *main-cli-fn* main)
