(ns macchiato.http
  (:require [clojure.string :as s]))

(defn req->map [req]
  {:headers        (js->clj (.-headers req) :keywordize-keys true)
   :method         (keyword (.-method req))
   :url            (.-url req)
   :body           (.-body req)
   :cookies        (.-cookies req)
   :fresh?         (.-fresh req)
   :hostname       (-> req .-headers .-host (s/split #":") first)
   :params         (js->clj (.-param req) :keywordize-keys true)
   :protocol       (.-protocol req)
   :secure?        (.-secure req)
   :signed-cookies (js->clj (.-signedCookies req))
   :stale?         (.-state req)
   :subdomains     (js->clj (.-subdomains req))
   :xhr?           (.-xhr req)
   :req            req})

(defn response [res]
  (fn [{:keys [status headers body]}]
    (.writeHead res status (clj->js headers))
    (.write res body)
    (.end res)))

(defn handler [router]
  (fn [req res]
    (let [req-map (req->map req)
          handler (router req-map)]
      (handler req-map (response res)))))
