/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentParser;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.parser.MarkedUpTextAssembler;
import com.lowagie.text.pdf.parser.PdfContentStreamHandler;
import com.lowagie.text.pdf.parser.TextAssembler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;

public class PdfTextExtractor {
    private final PdfReader reader;
    private final TextAssembler renderListener;

    public PdfTextExtractor(PdfReader pdfReader) {
        this(pdfReader, new MarkedUpTextAssembler(pdfReader));
    }

    public PdfTextExtractor(PdfReader pdfReader, boolean bl) {
        this(pdfReader, new MarkedUpTextAssembler(pdfReader, bl));
    }

    public PdfTextExtractor(PdfReader pdfReader, TextAssembler textAssembler) {
        this.reader = pdfReader;
        this.renderListener = textAssembler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getContentBytesForPage(int n) throws IOException {
        try (RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();){
            byte[] byArray;
            PdfDictionary pdfDictionary = this.reader.getPageN(n);
            PdfObject pdfObject = pdfDictionary.get(PdfName.CONTENTS);
            byte[] byArray2 = byArray = this.getContentBytesFromContentObject(pdfObject);
            return byArray2;
        }
    }

    private byte[] getContentBytesFromContentObject(PdfObject pdfObject) throws IOException {
        byte[] byArray;
        switch (pdfObject.type()) {
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
                PdfObject pdfObject2 = PdfReader.getPdfObject(pRIndirectReference);
                byArray = this.getContentBytesFromContentObject(pdfObject2);
                break;
            }
            case 7: {
                PRStream pRStream = (PRStream)PdfReader.getPdfObject(pdfObject);
                byArray = PdfReader.getStreamBytes(pRStream);
                break;
            }
            case 5: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PdfArray pdfArray = (PdfArray)pdfObject;
                ListIterator<PdfObject> listIterator = pdfArray.listIterator();
                while (listIterator.hasNext()) {
                    PdfObject pdfObject3 = listIterator.next();
                    byteArrayOutputStream.write(this.getContentBytesFromContentObject(pdfObject3));
                }
                byArray = byteArrayOutputStream.toByteArray();
                break;
            }
            default: {
                String string = "Unable to handle Content of type " + pdfObject.getClass();
                throw new IllegalStateException(string);
            }
        }
        return byArray;
    }

    public String getTextFromPage(int n) throws IOException {
        return this.getTextFromPage(n, false);
    }

    public String getTextFromPage(int n, boolean bl) throws IOException {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.RESOURCES);
        this.renderListener.reset();
        this.renderListener.setPage(n);
        PdfContentStreamHandler pdfContentStreamHandler = new PdfContentStreamHandler(this.renderListener);
        this.processContent(this.getContentBytesForPage(n), pdfDictionary2, pdfContentStreamHandler);
        return pdfContentStreamHandler.getResultantText();
    }

    public void processContent(byte[] byArray, PdfDictionary pdfDictionary, PdfContentStreamHandler pdfContentStreamHandler) {
        pdfContentStreamHandler.pushContext("div class='t-extracted-page'");
        try {
            PdfContentParser pdfContentParser = new PdfContentParser(new PRTokeniser(byArray));
            ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
            while (pdfContentParser.parse(arrayList).size() > 0) {
                PdfLiteral pdfLiteral = (PdfLiteral)arrayList.get(arrayList.size() - 1);
                pdfContentStreamHandler.invokeOperator(pdfLiteral, arrayList, pdfDictionary);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        pdfContentStreamHandler.popContext();
    }
}

