/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.CMapAwareDocumentFont;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.parser.ContentOperator;
import com.lowagie.text.pdf.parser.FinalText;
import com.lowagie.text.pdf.parser.GraphicsState;
import com.lowagie.text.pdf.parser.Matrix;
import com.lowagie.text.pdf.parser.ParsedText;
import com.lowagie.text.pdf.parser.TextAssembler;
import com.lowagie.text.pdf.parser.TextAssemblyBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

public class PdfContentStreamHandler {
    Stack<Collection<TextAssemblyBuffer>> textFragmentStreams = new Stack();
    Stack<String> contextNames = new Stack();
    Collection<TextAssemblyBuffer> textFragments = new ArrayList<TextAssemblyBuffer>();
    public Map<String, ContentOperator> operators;
    public Stack<GraphicsState> gsStack;
    public Matrix textMatrix;
    public Matrix textLineMatrix;
    boolean useContainerMarkup;
    TextAssembler renderListener;

    public PdfContentStreamHandler(TextAssembler textAssembler) {
        this.renderListener = textAssembler;
        this.installDefaultOperators();
        this.reset();
    }

    public void registerContentOperator(ContentOperator contentOperator) {
        String string = contentOperator.getOperatorName();
        if (this.operators.containsKey(string)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("operator.1.already.registered", string));
        }
        this.operators.put(string, contentOperator);
    }

    protected void installDefaultOperators() {
        this.operators = new HashMap<String, ContentOperator>();
        this.registerContentOperator(new PushGraphicsState());
        this.registerContentOperator(new PopGraphicsState());
        this.registerContentOperator(new ModifyCurrentTransformationMatrix());
        this.registerContentOperator(new ProcessGraphicsStateResource());
        SetTextCharacterSpacing setTextCharacterSpacing = new SetTextCharacterSpacing();
        this.registerContentOperator(setTextCharacterSpacing);
        SetTextWordSpacing setTextWordSpacing = new SetTextWordSpacing();
        this.registerContentOperator(setTextWordSpacing);
        this.registerContentOperator(new SetTextHorizontalScaling());
        SetTextLeading setTextLeading = new SetTextLeading();
        this.registerContentOperator(setTextLeading);
        this.registerContentOperator(new SetTextFont());
        this.registerContentOperator(new SetTextRenderMode());
        this.registerContentOperator(new SetTextRise());
        this.registerContentOperator(new BeginText());
        this.registerContentOperator(new EndText());
        TextMoveStartNextLine textMoveStartNextLine = new TextMoveStartNextLine();
        this.registerContentOperator(textMoveStartNextLine);
        this.registerContentOperator(new TextMoveStartNextLineWithLeading(textMoveStartNextLine, setTextLeading));
        this.registerContentOperator(new TextSetTextMatrix());
        TextMoveNextLine textMoveNextLine = new TextMoveNextLine(textMoveStartNextLine);
        this.registerContentOperator(textMoveNextLine);
        ShowText showText = new ShowText();
        this.registerContentOperator(new ShowText());
        MoveNextLineAndShowText moveNextLineAndShowText = new MoveNextLineAndShowText(textMoveNextLine, showText);
        this.registerContentOperator(moveNextLineAndShowText);
        this.registerContentOperator(new MoveNextLineAndShowTextWithSpacing(setTextWordSpacing, setTextCharacterSpacing, moveNextLineAndShowText));
        this.registerContentOperator(new ShowTextArray());
        this.registerContentOperator(new BeginMarked());
        this.registerContentOperator(new BeginMarkedDict());
        this.registerContentOperator(new EndMarked());
    }

    public ContentOperator lookupOperator(String string) {
        return this.operators.get(string);
    }

    public void invokeOperator(PdfLiteral pdfLiteral, ArrayList<PdfObject> arrayList, PdfDictionary pdfDictionary) {
        String string = pdfLiteral.toString();
        ContentOperator contentOperator = this.lookupOperator(string);
        if (contentOperator == null) {
            return;
        }
        contentOperator.invoke(arrayList, this, pdfDictionary);
    }

    void popContext() {
        String string = this.contextNames.pop();
        Collection<TextAssemblyBuffer> collection = this.textFragmentStreams.pop();
        this.renderListener.reset();
        for (TextAssemblyBuffer textAssemblyBuffer : this.textFragments) {
            textAssemblyBuffer.accumulate(this.renderListener, string);
        }
        FinalText finalText = this.renderListener.endParsingContext(string);
        if (finalText != null && finalText.getText().length() > 0) {
            collection.add(finalText);
        }
        this.textFragments = collection;
    }

    void pushContext(String string) {
        this.contextNames.push(string);
        this.textFragmentStreams.push(this.textFragments);
        this.textFragments = new ArrayList<TextAssemblyBuffer>();
    }

    GraphicsState gs() {
        return this.gsStack.peek();
    }

    public void reset() {
        if (this.gsStack == null || this.gsStack.isEmpty()) {
            this.gsStack = new Stack();
        }
        this.gsStack.add(new GraphicsState());
        this.textMatrix = null;
        this.textLineMatrix = null;
    }

    protected Matrix getCurrentTextMatrix() {
        return this.textMatrix;
    }

    protected Matrix getCurrentTextLineMatrix() {
        return this.textLineMatrix;
    }

    void applyTextAdjust(float f) {
        float f2 = -f / 1000.0f * this.gs().fontSize * this.gs().horizontalScaling;
        this.textMatrix = new Matrix(f2, 0.0f).multiply(this.textMatrix);
    }

    protected String decode(PdfString pdfString) {
        byte[] byArray = pdfString.getBytes();
        return this.getCurrentFont().decode(byArray, 0, byArray.length);
    }

    public CMapAwareDocumentFont getCurrentFont() {
        return this.gs().font;
    }

    void displayPdfString(PdfString pdfString) {
        String string = this.decode(pdfString);
        ParsedText parsedText = new ParsedText(string, this.gs(), this.textMatrix);
        if (this.contextNames.peek() != null) {
            this.textFragments.add(parsedText);
        }
        this.textMatrix = new Matrix(parsedText.getUnscaledWidth(this.gs()), 0.0f).multiply(this.textMatrix);
    }

    public String getResultantText() {
        if (this.contextNames.size() > 0) {
            throw new RuntimeException("can't get text with unprocessed stack items");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (TextAssemblyBuffer textAssemblyBuffer : this.textFragments) {
            stringBuffer.append(textAssemblyBuffer.getText());
        }
        return stringBuffer.toString();
    }

    private static class EndMarked
    implements ContentOperator {
        private EndMarked() {
        }

        @Override
        public String getOperatorName() {
            return "EMC";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            pdfContentStreamHandler.popContext();
        }
    }

    private static class BeginMarkedDict
    implements ContentOperator {
        private BeginMarkedDict() {
        }

        @Override
        public String getOperatorName() {
            return "BDC";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfString pdfString;
            String string = ((PdfName)arrayList.get(0)).toString().substring(1).toLowerCase();
            if ("artifact".equals(string) || "placedpdf".equals(string) || pdfContentStreamHandler.contextNames.peek() == null) {
                string = null;
            } else if ("l".equals(string)) {
                string = "ul";
            }
            PdfDictionary pdfDictionary2 = this.getBDCDictionary(arrayList, pdfDictionary);
            if (pdfDictionary2 != null && (pdfString = pdfDictionary2.getAsString(PdfName.E)) != null) {
                pdfContentStreamHandler.pushContext(string);
                pdfContentStreamHandler.textFragments.add(new FinalText(pdfString.toString()));
                pdfContentStreamHandler.popContext();
                pdfContentStreamHandler.pushContext(null);
                return;
            }
            pdfContentStreamHandler.pushContext(string);
        }

        private PdfDictionary getBDCDictionary(ArrayList<PdfObject> arrayList, PdfDictionary pdfDictionary) {
            PdfDictionary pdfDictionary2;
            PdfObject pdfObject = arrayList.get(1);
            if (pdfObject.isName()) {
                pdfDictionary2 = pdfDictionary.getAsDict(PdfName.PROPERTIES);
                PdfIndirectReference pdfIndirectReference = pdfDictionary2.getAsIndirectObject((PdfName)pdfObject);
                pdfObject = pdfIndirectReference != null ? pdfIndirectReference.getIndRef() : pdfDictionary2.getAsDict((PdfName)pdfObject);
            }
            pdfDictionary2 = (PdfDictionary)pdfObject;
            return pdfDictionary2;
        }
    }

    private static class BeginMarked
    implements ContentOperator {
        private BeginMarked() {
        }

        @Override
        public String getOperatorName() {
            return "BMC";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfName pdfName = (PdfName)arrayList.get(0);
            String string = pdfName.toString().substring(1);
            if ("Artifact".equals(string)) {
                pdfContentStreamHandler.pushContext(null);
            } else {
                pdfContentStreamHandler.pushContext(string);
            }
        }
    }

    static class SetTextWordSpacing
    implements ContentOperator {
        SetTextWordSpacing() {
        }

        @Override
        public String getOperatorName() {
            return "Tw";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamHandler.gs().wordSpacing = pdfNumber.floatValue();
        }
    }

    static class SetTextHorizontalScaling
    implements ContentOperator {
        SetTextHorizontalScaling() {
        }

        @Override
        public String getOperatorName() {
            return "Tz";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamHandler.gs().horizontalScaling = pdfNumber.floatValue();
        }
    }

    static class SetTextLeading
    implements ContentOperator {
        SetTextLeading() {
        }

        @Override
        public String getOperatorName() {
            return "TL";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamHandler.gs().leading = pdfNumber.floatValue();
        }
    }

    static class SetTextRise
    implements ContentOperator {
        SetTextRise() {
        }

        @Override
        public String getOperatorName() {
            return "Ts";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamHandler.gs().rise = pdfNumber.floatValue();
        }
    }

    static class SetTextRenderMode
    implements ContentOperator {
        SetTextRenderMode() {
        }

        @Override
        public String getOperatorName() {
            return "Tr";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamHandler.gs().renderMode = pdfNumber.intValue();
        }
    }

    static class TextMoveStartNextLine
    implements ContentOperator {
        TextMoveStartNextLine() {
        }

        @Override
        public String getOperatorName() {
            return "Td";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            float f = ((PdfNumber)arrayList.get(0)).floatValue();
            float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
            Matrix matrix = new Matrix(f, f2);
            pdfContentStreamHandler.textLineMatrix = pdfContentStreamHandler.textMatrix = matrix.multiply(pdfContentStreamHandler.textLineMatrix);
        }
    }

    static class TextMoveNextLine
    implements ContentOperator {
        private final TextMoveStartNextLine moveStartNextLine;

        @Override
        public String getOperatorName() {
            return "T*";
        }

        public TextMoveNextLine(TextMoveStartNextLine textMoveStartNextLine) {
            this.moveStartNextLine = textMoveStartNextLine;
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            ArrayList<PdfObject> arrayList2 = new ArrayList<PdfObject>(2);
            arrayList2.add(0, new PdfNumber(0));
            arrayList2.add(1, new PdfNumber(-pdfContentStreamHandler.gs().leading));
            this.moveStartNextLine.invoke(arrayList2, pdfContentStreamHandler, pdfDictionary);
        }
    }

    static class ShowText
    implements ContentOperator {
        ShowText() {
        }

        @Override
        public String getOperatorName() {
            return "Tj";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfString pdfString = (PdfString)arrayList.get(0);
            pdfContentStreamHandler.displayPdfString(pdfString);
        }
    }

    static class TextMoveStartNextLineWithLeading
    implements ContentOperator {
        private final TextMoveStartNextLine moveStartNextLine;
        private final SetTextLeading setTextLeading;

        @Override
        public String getOperatorName() {
            return "TD";
        }

        public TextMoveStartNextLineWithLeading(TextMoveStartNextLine textMoveStartNextLine, SetTextLeading setTextLeading) {
            this.moveStartNextLine = textMoveStartNextLine;
            this.setTextLeading = setTextLeading;
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            float f = ((PdfNumber)arrayList.get(1)).floatValue();
            ArrayList<PdfObject> arrayList2 = new ArrayList<PdfObject>(1);
            arrayList2.add(0, new PdfNumber(-f));
            this.setTextLeading.invoke(arrayList2, pdfContentStreamHandler, pdfDictionary);
            this.moveStartNextLine.invoke(arrayList, pdfContentStreamHandler, pdfDictionary);
        }
    }

    static class TextSetTextMatrix
    implements ContentOperator {
        TextSetTextMatrix() {
        }

        @Override
        public String getOperatorName() {
            return "Tm";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            float f = ((PdfNumber)arrayList.get(0)).floatValue();
            float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
            float f3 = ((PdfNumber)arrayList.get(2)).floatValue();
            float f4 = ((PdfNumber)arrayList.get(3)).floatValue();
            float f5 = ((PdfNumber)arrayList.get(4)).floatValue();
            float f6 = ((PdfNumber)arrayList.get(5)).floatValue();
            pdfContentStreamHandler.textMatrix = pdfContentStreamHandler.textLineMatrix = new Matrix(f, f2, f3, f4, f5, f6);
        }
    }

    static class SetTextFont
    implements ContentOperator {
        SetTextFont() {
        }

        @Override
        public String getOperatorName() {
            return "Tf";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            CMapAwareDocumentFont cMapAwareDocumentFont;
            PdfName pdfName = (PdfName)arrayList.get(0);
            float f = ((PdfNumber)arrayList.get(1)).floatValue();
            PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.FONT);
            pdfContentStreamHandler.gs().font = cMapAwareDocumentFont = new CMapAwareDocumentFont((PRIndirectReference)pdfDictionary2.get(pdfName));
            pdfContentStreamHandler.gs().fontSize = f;
        }
    }

    static class SetTextCharacterSpacing
    implements ContentOperator {
        SetTextCharacterSpacing() {
        }

        @Override
        public String getOperatorName() {
            return "Tc";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            pdfContentStreamHandler.gs().characterSpacing = pdfNumber.floatValue();
        }
    }

    static class PushGraphicsState
    implements ContentOperator {
        PushGraphicsState() {
        }

        @Override
        public String getOperatorName() {
            return "q";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            GraphicsState graphicsState = pdfContentStreamHandler.gsStack.peek();
            GraphicsState graphicsState2 = new GraphicsState(graphicsState);
            pdfContentStreamHandler.gsStack.push(graphicsState2);
        }
    }

    static class ProcessGraphicsStateResource
    implements ContentOperator {
        ProcessGraphicsStateResource() {
        }

        @Override
        public String getOperatorName() {
            return "gs";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfName pdfName = (PdfName)arrayList.get(0);
            PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.EXTGSTATE);
            if (pdfDictionary2 == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("resources.do.not.contain.extgstate.entry.unable.to.process.operator.1", this.getOperatorName()));
            }
            PdfDictionary pdfDictionary3 = pdfDictionary2.getAsDict(pdfName);
            if (pdfDictionary3 == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("1.is.an.unknown.graphics.state.dictionary", pdfName));
            }
            PdfArray pdfArray = pdfDictionary3.getAsArray(PdfName.FONT);
            if (pdfArray != null) {
                CMapAwareDocumentFont cMapAwareDocumentFont = new CMapAwareDocumentFont((PRIndirectReference)pdfArray.getPdfObject(0));
                float f = pdfArray.getAsNumber(1).floatValue();
                pdfContentStreamHandler.gs().font = cMapAwareDocumentFont;
                pdfContentStreamHandler.gs().fontSize = f;
            }
        }
    }

    static class PopGraphicsState
    implements ContentOperator {
        PopGraphicsState() {
        }

        @Override
        public String getOperatorName() {
            return "Q";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            pdfContentStreamHandler.gsStack.pop();
        }
    }

    static class MoveNextLineAndShowTextWithSpacing
    implements ContentOperator {
        private final SetTextWordSpacing setTextWordSpacing;
        private final SetTextCharacterSpacing setTextCharacterSpacing;
        private final MoveNextLineAndShowText moveNextLineAndShowText;

        @Override
        public String getOperatorName() {
            return "\"";
        }

        public MoveNextLineAndShowTextWithSpacing(SetTextWordSpacing setTextWordSpacing, SetTextCharacterSpacing setTextCharacterSpacing, MoveNextLineAndShowText moveNextLineAndShowText) {
            this.setTextWordSpacing = setTextWordSpacing;
            this.setTextCharacterSpacing = setTextCharacterSpacing;
            this.moveNextLineAndShowText = moveNextLineAndShowText;
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfNumber pdfNumber = (PdfNumber)arrayList.get(0);
            PdfNumber pdfNumber2 = (PdfNumber)arrayList.get(1);
            PdfString pdfString = (PdfString)arrayList.get(2);
            ArrayList<PdfObject> arrayList2 = new ArrayList<PdfObject>(1);
            arrayList2.add(0, pdfNumber);
            this.setTextWordSpacing.invoke(arrayList2, pdfContentStreamHandler, pdfDictionary);
            ArrayList<PdfObject> arrayList3 = new ArrayList<PdfObject>(1);
            arrayList3.add(0, pdfNumber2);
            this.setTextCharacterSpacing.invoke(arrayList3, pdfContentStreamHandler, pdfDictionary);
            ArrayList<PdfObject> arrayList4 = new ArrayList<PdfObject>(1);
            arrayList4.add(0, pdfString);
            this.moveNextLineAndShowText.invoke(arrayList4, pdfContentStreamHandler, pdfDictionary);
        }
    }

    static class MoveNextLineAndShowText
    implements ContentOperator {
        private final TextMoveNextLine textMoveNextLine;
        private final ShowText showText;

        @Override
        public String getOperatorName() {
            return "'";
        }

        public MoveNextLineAndShowText(TextMoveNextLine textMoveNextLine, ShowText showText) {
            this.textMoveNextLine = textMoveNextLine;
            this.showText = showText;
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            this.textMoveNextLine.invoke(new ArrayList<PdfObject>(0), pdfContentStreamHandler, pdfDictionary);
            this.showText.invoke(arrayList, pdfContentStreamHandler, pdfDictionary);
        }
    }

    static class ModifyCurrentTransformationMatrix
    implements ContentOperator {
        ModifyCurrentTransformationMatrix() {
        }

        @Override
        public String getOperatorName() {
            return "cm";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            float f = ((PdfNumber)arrayList.get(0)).floatValue();
            float f2 = ((PdfNumber)arrayList.get(1)).floatValue();
            float f3 = ((PdfNumber)arrayList.get(2)).floatValue();
            float f4 = ((PdfNumber)arrayList.get(3)).floatValue();
            float f5 = ((PdfNumber)arrayList.get(4)).floatValue();
            float f6 = ((PdfNumber)arrayList.get(5)).floatValue();
            Matrix matrix = new Matrix(f, f2, f3, f4, f5, f6);
            GraphicsState graphicsState = pdfContentStreamHandler.gsStack.peek();
            graphicsState.ctm = graphicsState.ctm.multiply(matrix);
        }
    }

    static class EndText
    implements ContentOperator {
        EndText() {
        }

        @Override
        public String getOperatorName() {
            return "ET";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            pdfContentStreamHandler.textMatrix = null;
            pdfContentStreamHandler.textLineMatrix = null;
        }
    }

    static class BeginText
    implements ContentOperator {
        BeginText() {
        }

        @Override
        public String getOperatorName() {
            return "BT";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            pdfContentStreamHandler.textLineMatrix = pdfContentStreamHandler.textMatrix = new Matrix();
        }
    }

    static class ShowTextArray
    implements ContentOperator {
        ShowTextArray() {
        }

        @Override
        public String getOperatorName() {
            return "TJ";
        }

        @Override
        public void invoke(ArrayList<PdfObject> arrayList, PdfContentStreamHandler pdfContentStreamHandler, PdfDictionary pdfDictionary) {
            PdfArray pdfArray = (PdfArray)arrayList.get(0);
            float f = 0.0f;
            ListIterator<PdfObject> listIterator = pdfArray.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                if (e instanceof PdfString) {
                    pdfContentStreamHandler.displayPdfString((PdfString)e);
                    f = 0.0f;
                    continue;
                }
                f = ((PdfNumber)e).floatValue();
                pdfContentStreamHandler.applyTextAdjust(f);
            }
        }
    }
}

