/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.Utilities;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class PngImage {
    public static final int[] PNGID = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    public static final String IHDR = "IHDR";
    public static final String PLTE = "PLTE";
    public static final String IDAT = "IDAT";
    public static final String IEND = "IEND";
    public static final String tRNS = "tRNS";
    public static final String pHYs = "pHYs";
    public static final String gAMA = "gAMA";
    public static final String cHRM = "cHRM";
    public static final String sRGB = "sRGB";
    public static final String iCCP = "iCCP";
    private static final int TRANSFERSIZE = 4096;
    private static final int PNG_FILTER_NONE = 0;
    private static final int PNG_FILTER_SUB = 1;
    private static final int PNG_FILTER_UP = 2;
    private static final int PNG_FILTER_AVERAGE = 3;
    private static final int PNG_FILTER_PAETH = 4;
    private static final PdfName[] intents = new PdfName[]{PdfName.PERCEPTUAL, PdfName.RELATIVECOLORIMETRIC, PdfName.SATURATION, PdfName.ABSOLUTECOLORIMETRIC};
    InputStream is;
    DataInputStream dataStream;
    int width;
    int height;
    int bitDepth;
    int colorType;
    int compressionMethod;
    int filterMethod;
    int interlaceMethod;
    PdfDictionary additional = new PdfDictionary();
    byte[] image;
    byte[] smask;
    byte[] trans;
    NewByteArrayOutputStream idat = new NewByteArrayOutputStream();
    int dpiX;
    int dpiY;
    float XYRatio;
    boolean genBWMask;
    boolean palShades;
    int transRedGray = -1;
    int transGreen = -1;
    int transBlue = -1;
    int inputBands;
    int bytesPerPixel;
    byte[] colorTable;
    float gamma = 1.0f;
    boolean hasCHRM = false;
    float xW;
    float yW;
    float xR;
    float yR;
    float xG;
    float yG;
    float xB;
    float yB;
    PdfName intent;
    ICC_Profile icc_profile;

    PngImage(InputStream inputStream) {
        this.is = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(URL uRL) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = uRL.openStream();
            Image image = PngImage.getImage(inputStream);
            image.setUrl(uRL);
            Image image2 = image;
            return image2;
        }
    }

    public static Image getImage(InputStream inputStream) throws IOException {
        PngImage pngImage = new PngImage(inputStream);
        return pngImage.getImage();
    }

    public static Image getImage(String string) throws IOException {
        return PngImage.getImage(Utilities.toURL(string));
    }

    public static Image getImage(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Image image = PngImage.getImage(byteArrayInputStream);
        image.setOriginalData(byArray);
        return image;
    }

    boolean checkMarker(String string) {
        if (string.length() != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    void readPng() throws IOException {
        for (int i = 0; i < PNGID.length; ++i) {
            if (PNGID[i] == this.is.read()) continue;
            throw new IOException(MessageLocalization.getComposedMessage("file.is.not.a.valid.png"));
        }
        byte[] byArray = new byte[4096];
        while (true) {
            int n;
            int n2;
            int n3;
            String string = PngImage.getString(this.is);
            if (n3 < 0 || !this.checkMarker(string)) {
                throw new IOException(MessageLocalization.getComposedMessage("corrupted.png.file"));
            }
            if (IDAT.equals(string)) {
                int n4;
                for (n3 = PngImage.getInt(this.is); n3 != 0; n3 -= n4) {
                    n4 = this.is.read(byArray, 0, Math.min(n3, 4096));
                    if (n4 < 0) {
                        return;
                    }
                    this.idat.write(byArray, 0, n4);
                }
            } else if (tRNS.equals(string)) {
                switch (this.colorType) {
                    case 0: {
                        if (n3 < 2) break;
                        n3 -= 2;
                        int n5 = PngImage.getWord(this.is);
                        if (this.bitDepth == 16) {
                            this.transRedGray = n5;
                            break;
                        }
                        this.additional.put(PdfName.MASK, new PdfLiteral("[" + n5 + " " + n5 + "]"));
                        break;
                    }
                    case 2: {
                        if (n3 < 6) break;
                        n3 -= 6;
                        int n6 = PngImage.getWord(this.is);
                        n2 = PngImage.getWord(this.is);
                        n = PngImage.getWord(this.is);
                        if (this.bitDepth == 16) {
                            this.transRedGray = n6;
                            this.transGreen = n2;
                            this.transBlue = n;
                            break;
                        }
                        this.additional.put(PdfName.MASK, new PdfLiteral("[" + n6 + " " + n6 + " " + n2 + " " + n2 + " " + n + " " + n + "]"));
                        break;
                    }
                    case 3: {
                        if (n3 <= 0) break;
                        this.trans = new byte[n3];
                        for (int i = 0; i < n3; ++i) {
                            this.trans[i] = (byte)this.is.read();
                        }
                        n3 = 0;
                    }
                }
                Utilities.skip(this.is, n3);
            } else if (IHDR.equals(string)) {
                this.width = PngImage.getInt(this.is);
                this.height = PngImage.getInt(this.is);
                this.bitDepth = this.is.read();
                this.colorType = this.is.read();
                this.compressionMethod = this.is.read();
                this.filterMethod = this.is.read();
                this.interlaceMethod = this.is.read();
            } else if (PLTE.equals(string)) {
                if (this.colorType == 3) {
                    PdfArray pdfArray = new PdfArray();
                    pdfArray.add(PdfName.INDEXED);
                    pdfArray.add(this.getColorspace());
                    pdfArray.add(new PdfNumber(n3 / 3 - 1));
                    ByteBuffer byteBuffer = new ByteBuffer();
                    while (n3-- > 0) {
                        byteBuffer.append_i(this.is.read());
                    }
                    this.colorTable = byteBuffer.toByteArray();
                    pdfArray.add(new PdfString(this.colorTable));
                    this.additional.put(PdfName.COLORSPACE, pdfArray);
                } else {
                    Utilities.skip(this.is, n3);
                }
            } else if (pHYs.equals(string)) {
                int n7 = PngImage.getInt(this.is);
                n2 = PngImage.getInt(this.is);
                n = this.is.read();
                if (n == 1) {
                    this.dpiX = (int)((float)n7 * 0.0254f + 0.5f);
                    this.dpiY = (int)((float)n2 * 0.0254f + 0.5f);
                } else if (n2 != 0) {
                    this.XYRatio = (float)n7 / (float)n2;
                }
            } else if (cHRM.equals(string)) {
                this.xW = (float)PngImage.getInt(this.is) / 100000.0f;
                this.yW = (float)PngImage.getInt(this.is) / 100000.0f;
                this.xR = (float)PngImage.getInt(this.is) / 100000.0f;
                this.yR = (float)PngImage.getInt(this.is) / 100000.0f;
                this.xG = (float)PngImage.getInt(this.is) / 100000.0f;
                this.yG = (float)PngImage.getInt(this.is) / 100000.0f;
                this.xB = (float)PngImage.getInt(this.is) / 100000.0f;
                this.yB = (float)PngImage.getInt(this.is) / 100000.0f;
                this.hasCHRM = !(Math.abs(this.xW) < 1.0E-4f || Math.abs(this.yW) < 1.0E-4f || Math.abs(this.xR) < 1.0E-4f || Math.abs(this.yR) < 1.0E-4f || Math.abs(this.xG) < 1.0E-4f || Math.abs(this.yG) < 1.0E-4f || Math.abs(this.xB) < 1.0E-4f || Math.abs(this.yB) < 1.0E-4f);
            } else if (sRGB.equals(string)) {
                int n8 = this.is.read();
                this.intent = intents[n8];
                this.gamma = 2.2f;
                this.xW = 0.3127f;
                this.yW = 0.329f;
                this.xR = 0.64f;
                this.yR = 0.33f;
                this.xG = 0.3f;
                this.yG = 0.6f;
                this.xB = 0.15f;
                this.yB = 0.06f;
                this.hasCHRM = true;
            } else if (gAMA.equals(string)) {
                int n9 = PngImage.getInt(this.is);
                if (n9 != 0) {
                    this.gamma = 100000.0f / (float)n9;
                    if (!this.hasCHRM) {
                        this.xW = 0.3127f;
                        this.yW = 0.329f;
                        this.xR = 0.64f;
                        this.yR = 0.33f;
                        this.xG = 0.3f;
                        this.yG = 0.6f;
                        this.xB = 0.15f;
                        this.yB = 0.06f;
                        this.hasCHRM = true;
                    }
                }
            } else if (iCCP.equals(string)) {
                do {
                    --n3;
                } while (this.is.read() != 0);
                this.is.read();
                byte[] byArray2 = new byte[--n3];
                n2 = 0;
                while (n3 > 0) {
                    n = this.is.read(byArray2, n2, n3);
                    if (n < 0) {
                        throw new IOException(MessageLocalization.getComposedMessage("premature.end.of.file"));
                    }
                    n2 += n;
                    n3 -= n;
                }
                byte[] byArray3 = PdfReader.FlateDecode(byArray2, true);
                byArray2 = null;
                try {
                    this.icc_profile = ICC_Profile.getInstance(byArray3);
                }
                catch (RuntimeException runtimeException) {
                    this.icc_profile = null;
                }
            } else {
                if (IEND.equals(string)) break;
                Utilities.skip(this.is, n3);
            }
            Utilities.skip(this.is, 4);
        }
    }

    PdfObject getColorspace() {
        if (this.icc_profile != null) {
            if ((this.colorType & 2) == 0) {
                return PdfName.DEVICEGRAY;
            }
            return PdfName.DEVICERGB;
        }
        if (this.gamma == 1.0f && !this.hasCHRM) {
            if ((this.colorType & 2) == 0) {
                return PdfName.DEVICEGRAY;
            }
            return PdfName.DEVICERGB;
        }
        PdfArray pdfArray = new PdfArray();
        PdfDictionary pdfDictionary = new PdfDictionary();
        if ((this.colorType & 2) == 0) {
            if (this.gamma == 1.0f) {
                return PdfName.DEVICEGRAY;
            }
            pdfArray.add(PdfName.CALGRAY);
            pdfDictionary.put(PdfName.GAMMA, new PdfNumber(this.gamma));
            pdfDictionary.put(PdfName.WHITEPOINT, new PdfLiteral("[1 1 1]"));
            pdfArray.add(pdfDictionary);
        } else {
            PdfObject pdfObject = new PdfLiteral("[1 1 1]");
            pdfArray.add(PdfName.CALRGB);
            if (this.gamma != 1.0f) {
                PdfArray pdfArray2 = new PdfArray();
                PdfNumber pdfNumber = new PdfNumber(this.gamma);
                pdfArray2.add(pdfNumber);
                pdfArray2.add(pdfNumber);
                pdfArray2.add(pdfNumber);
                pdfDictionary.put(PdfName.GAMMA, pdfArray2);
            }
            if (this.hasCHRM) {
                float f = this.yW * ((this.xG - this.xB) * this.yR - (this.xR - this.xB) * this.yG + (this.xR - this.xG) * this.yB);
                float f2 = this.yR * ((this.xG - this.xB) * this.yW - (this.xW - this.xB) * this.yG + (this.xW - this.xG) * this.yB) / f;
                float f3 = f2 * this.xR / this.yR;
                float f4 = f2 * ((1.0f - this.xR) / this.yR - 1.0f);
                float f5 = -this.yG * ((this.xR - this.xB) * this.yW - (this.xW - this.xB) * this.yR + (this.xW - this.xR) * this.yB) / f;
                float f6 = f5 * this.xG / this.yG;
                float f7 = f5 * ((1.0f - this.xG) / this.yG - 1.0f);
                float f8 = this.yB * ((this.xR - this.xG) * this.yW - (this.xW - this.xG) * this.yW + (this.xW - this.xR) * this.yG) / f;
                float f9 = f8 * this.xB / this.yB;
                float f10 = f8 * ((1.0f - this.xB) / this.yB - 1.0f);
                float f11 = f3 + f6 + f9;
                float f12 = 1.0f;
                float f13 = f4 + f7 + f10;
                PdfArray pdfArray3 = new PdfArray();
                pdfArray3.add(new PdfNumber(f11));
                pdfArray3.add(new PdfNumber(f12));
                pdfArray3.add(new PdfNumber(f13));
                pdfObject = pdfArray3;
                PdfArray pdfArray4 = new PdfArray();
                pdfArray4.add(new PdfNumber(f3));
                pdfArray4.add(new PdfNumber(f2));
                pdfArray4.add(new PdfNumber(f4));
                pdfArray4.add(new PdfNumber(f6));
                pdfArray4.add(new PdfNumber(f5));
                pdfArray4.add(new PdfNumber(f7));
                pdfArray4.add(new PdfNumber(f9));
                pdfArray4.add(new PdfNumber(f8));
                pdfArray4.add(new PdfNumber(f10));
                pdfDictionary.put(PdfName.MATRIX, pdfArray4);
            }
            pdfDictionary.put(PdfName.WHITEPOINT, pdfObject);
            pdfArray.add(pdfDictionary);
        }
        return pdfArray;
    }

    Image getImage() throws IOException {
        this.readPng();
        try {
            Object object;
            Image image;
            int n;
            int n2;
            int n3;
            int n4 = 0;
            int n5 = 0;
            this.palShades = false;
            if (this.trans != null) {
                for (n3 = 0; n3 < this.trans.length; ++n3) {
                    n2 = this.trans[n3] & 0xFF;
                    if (n2 == 0) {
                        ++n4;
                        n5 = n3;
                    }
                    if (n2 == 0 || n2 == 255) continue;
                    this.palShades = true;
                    break;
                }
            }
            if ((this.colorType & 4) != 0) {
                this.palShades = true;
            }
            boolean bl = this.genBWMask = !this.palShades && (n4 > 1 || this.transRedGray >= 0);
            if (!this.palShades && !this.genBWMask && n4 == 1) {
                this.additional.put(PdfName.MASK, new PdfLiteral("[" + n5 + " " + n5 + "]"));
            }
            n3 = this.interlaceMethod == 1 || this.bitDepth == 16 || (this.colorType & 4) != 0 || this.palShades || this.genBWMask ? 1 : 0;
            switch (this.colorType) {
                case 0: {
                    this.inputBands = 1;
                    break;
                }
                case 2: {
                    this.inputBands = 3;
                    break;
                }
                case 3: {
                    this.inputBands = 1;
                    break;
                }
                case 4: {
                    this.inputBands = 2;
                    break;
                }
                case 6: {
                    this.inputBands = 4;
                }
            }
            if (n3 != 0) {
                this.decodeIdat();
            }
            n2 = this.inputBands;
            if ((this.colorType & 4) != 0) {
                --n2;
            }
            if ((n = this.bitDepth) == 16) {
                n = 8;
            }
            if (this.image != null) {
                image = this.colorType == 3 ? new ImgRaw(this.width, this.height, n2, n, this.image) : Image.getInstance(this.width, this.height, n2, n, this.image);
            } else {
                image = new ImgRaw(this.width, this.height, n2, n, this.idat.toByteArray());
                image.setDeflated(true);
                object = new PdfDictionary();
                ((PdfDictionary)object).put(PdfName.BITSPERCOMPONENT, new PdfNumber(this.bitDepth));
                ((PdfDictionary)object).put(PdfName.PREDICTOR, new PdfNumber(15));
                ((PdfDictionary)object).put(PdfName.COLUMNS, new PdfNumber(this.width));
                ((PdfDictionary)object).put(PdfName.COLORS, new PdfNumber(this.colorType == 3 || (this.colorType & 2) == 0 ? 1 : 3));
                this.additional.put(PdfName.DECODEPARMS, (PdfObject)object);
            }
            if (this.additional.get(PdfName.COLORSPACE) == null) {
                this.additional.put(PdfName.COLORSPACE, this.getColorspace());
            }
            if (this.intent != null) {
                this.additional.put(PdfName.INTENT, this.intent);
            }
            if (this.additional.size() > 0) {
                image.setAdditional(this.additional);
            }
            if (this.icc_profile != null) {
                image.tagICC(this.icc_profile);
            }
            if (this.palShades) {
                object = Image.getInstance(this.width, this.height, 1, 8, this.smask);
                ((Image)object).makeMask();
                image.setImageMask((Image)object);
            }
            if (this.genBWMask) {
                object = Image.getInstance(this.width, this.height, 1, 1, this.smask);
                ((Image)object).makeMask();
                image.setImageMask((Image)object);
            }
            image.setDpi(this.dpiX, this.dpiY);
            image.setXYRatio(this.XYRatio);
            image.setOriginalType(2);
            return image;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    void decodeIdat() {
        int n = this.bitDepth;
        if (n == 16) {
            n = 8;
        }
        int n2 = -1;
        this.bytesPerPixel = this.bitDepth == 16 ? 2 : 1;
        switch (this.colorType) {
            case 0: {
                n2 = (n * this.width + 7) / 8 * this.height;
                break;
            }
            case 2: {
                n2 = this.width * 3 * this.height;
                this.bytesPerPixel *= 3;
                break;
            }
            case 3: {
                if (this.interlaceMethod == 1) {
                    n2 = (n * this.width + 7) / 8 * this.height;
                }
                this.bytesPerPixel = 1;
                break;
            }
            case 4: {
                n2 = this.width * this.height;
                this.bytesPerPixel *= 2;
                break;
            }
            case 6: {
                n2 = this.width * 3 * this.height;
                this.bytesPerPixel *= 4;
            }
        }
        if (n2 >= 0) {
            this.image = new byte[n2];
        }
        if (this.palShades) {
            this.smask = new byte[this.width * this.height];
        } else if (this.genBWMask) {
            this.smask = new byte[(this.width + 7) / 8 * this.height];
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.idat.getBuf(), 0, this.idat.size());
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, new Inflater());
        this.dataStream = new DataInputStream(inflaterInputStream);
        if (this.interlaceMethod != 1) {
            this.decodePass(0, 0, 1, 1, this.width, this.height);
        } else {
            this.decodePass(0, 0, 8, 8, (this.width + 7) / 8, (this.height + 7) / 8);
            this.decodePass(4, 0, 8, 8, (this.width + 3) / 8, (this.height + 7) / 8);
            this.decodePass(0, 4, 4, 8, (this.width + 3) / 4, (this.height + 3) / 8);
            this.decodePass(2, 0, 4, 4, (this.width + 1) / 4, (this.height + 3) / 4);
            this.decodePass(0, 2, 2, 4, (this.width + 1) / 2, (this.height + 1) / 4);
            this.decodePass(1, 0, 2, 2, this.width / 2, (this.height + 1) / 2);
            this.decodePass(0, 1, 1, 2, this.width, this.height / 2);
        }
    }

    void decodePass(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == 0 || n6 == 0) {
            return;
        }
        int n7 = (this.inputBands * n5 * this.bitDepth + 7) / 8;
        byte[] byArray = new byte[n7];
        byte[] byArray2 = new byte[n7];
        int n8 = 0;
        int n9 = n2;
        while (n8 < n6) {
            int n10 = 0;
            try {
                n10 = this.dataStream.read();
                this.dataStream.readFully(byArray, 0, n7);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (n10) {
                case 0: {
                    break;
                }
                case 1: {
                    PngImage.decodeSubFilter(byArray, n7, this.bytesPerPixel);
                    break;
                }
                case 2: {
                    PngImage.decodeUpFilter(byArray, byArray2, n7);
                    break;
                }
                case 3: {
                    PngImage.decodeAverageFilter(byArray, byArray2, n7, this.bytesPerPixel);
                    break;
                }
                case 4: {
                    PngImage.decodePaethFilter(byArray, byArray2, n7, this.bytesPerPixel);
                    break;
                }
                default: {
                    throw new RuntimeException(MessageLocalization.getComposedMessage("png.filter.unknown"));
                }
            }
            this.processPixels(byArray, n, n3, n9, n5);
            byte[] byArray3 = byArray2;
            byArray2 = byArray;
            byArray = byArray3;
            ++n8;
            n9 += n4;
        }
    }

    void processPixels(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int[] nArray = this.getPixel(byArray);
        int n8 = 0;
        switch (this.colorType) {
            case 0: 
            case 3: 
            case 4: {
                n8 = 1;
                break;
            }
            case 2: 
            case 6: {
                n8 = 3;
            }
        }
        if (this.image != null) {
            n7 = n;
            n6 = (n8 * this.width * (this.bitDepth == 16 ? 8 : this.bitDepth) + 7) / 8;
            for (n5 = 0; n5 < n4; ++n5) {
                PngImage.setPixel(this.image, nArray, this.inputBands * n5, n8, n7, n3, this.bitDepth, n6);
                n7 += n2;
            }
        }
        if (this.palShades) {
            if ((this.colorType & 4) != 0) {
                if (this.bitDepth == 16) {
                    for (n6 = 0; n6 < n4; ++n6) {
                        int n9 = n6 * this.inputBands + n8;
                        nArray[n9] = nArray[n9] >>> 8;
                    }
                }
                n6 = this.width;
                n7 = n;
                for (n5 = 0; n5 < n4; ++n5) {
                    PngImage.setPixel(this.smask, nArray, this.inputBands * n5 + n8, 1, n7, n3, 8, n6);
                    n7 += n2;
                }
            } else {
                n6 = this.width;
                int[] nArray2 = new int[1];
                n7 = n;
                for (n5 = 0; n5 < n4; ++n5) {
                    int n10 = nArray[n5];
                    nArray2[0] = n10 < this.trans.length ? this.trans[n10] : 255;
                    PngImage.setPixel(this.smask, nArray2, 0, 1, n7, n3, 8, n6);
                    n7 += n2;
                }
            }
        } else if (this.genBWMask) {
            switch (this.colorType) {
                case 3: {
                    n6 = (this.width + 7) / 8;
                    int[] nArray3 = new int[1];
                    n7 = n;
                    for (n5 = 0; n5 < n4; ++n5) {
                        int n11 = nArray[n5];
                        nArray3[0] = n11 < this.trans.length && this.trans[n11] == 0 ? 1 : 0;
                        PngImage.setPixel(this.smask, nArray3, 0, 1, n7, n3, 1, n6);
                        n7 += n2;
                    }
                    break;
                }
                case 0: {
                    n6 = (this.width + 7) / 8;
                    int[] nArray4 = new int[1];
                    n7 = n;
                    for (n5 = 0; n5 < n4; ++n5) {
                        int n12 = nArray[n5];
                        nArray4[0] = n12 == this.transRedGray ? 1 : 0;
                        PngImage.setPixel(this.smask, nArray4, 0, 1, n7, n3, 1, n6);
                        n7 += n2;
                    }
                    break;
                }
                case 2: {
                    n6 = (this.width + 7) / 8;
                    int[] nArray5 = new int[1];
                    n7 = n;
                    for (n5 = 0; n5 < n4; ++n5) {
                        int n13 = this.inputBands * n5;
                        nArray5[0] = nArray[n13] == this.transRedGray && nArray[n13 + 1] == this.transGreen && nArray[n13 + 2] == this.transBlue ? 1 : 0;
                        PngImage.setPixel(this.smask, nArray5, 0, 1, n7, n3, 1, n6);
                        n7 += n2;
                    }
                    break;
                }
            }
        }
    }

    static int getPixel(byte[] byArray, int n, int n2, int n3, int n4) {
        if (n3 == 8) {
            int n5 = n4 * n2 + n;
            return byArray[n5] & 0xFF;
        }
        int n6 = n4 * n2 + n / (8 / n3);
        int n7 = byArray[n6] >> 8 - n3 * (n % (8 / n3)) - n3;
        return n7 & (1 << n3) - 1;
    }

    static void setPixel(byte[] byArray, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == 8) {
            int n7 = n6 * n4 + n2 * n3;
            for (int i = 0; i < n2; ++i) {
                byArray[n7 + i] = (byte)nArray[i + n];
            }
        } else if (n5 == 16) {
            int n8 = n6 * n4 + n2 * n3;
            for (int i = 0; i < n2; ++i) {
                byArray[n8 + i] = (byte)(nArray[i + n] >>> 8);
            }
        } else {
            int n9 = n6 * n4 + n3 / (8 / n5);
            int n10 = nArray[n] << 8 - n5 * (n3 % (8 / n5)) - n5;
            int n11 = n9;
            byArray[n11] = (byte)(byArray[n11] | n10);
        }
    }

    int[] getPixel(byte[] byArray) {
        switch (this.bitDepth) {
            case 8: {
                int[] nArray = new int[byArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = byArray[i] & 0xFF;
                }
                return nArray;
            }
            case 16: {
                int[] nArray = new int[byArray.length / 2];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = ((byArray[i * 2] & 0xFF) << 8) + (byArray[i * 2 + 1] & 0xFF);
                }
                return nArray;
            }
        }
        int[] nArray = new int[byArray.length * 8 / this.bitDepth];
        int n = 0;
        int n2 = 8 / this.bitDepth;
        int n3 = (1 << this.bitDepth) - 1;
        for (int i = 0; i < byArray.length; ++i) {
            for (int j = n2 - 1; j >= 0; --j) {
                nArray[n++] = byArray[i] >>> this.bitDepth * j & n3;
            }
        }
        return nArray;
    }

    private static void decodeSubFilter(byte[] byArray, int n, int n2) {
        for (int i = n2; i < n; ++i) {
            int n3 = byArray[i] & 0xFF;
            byArray[i] = (byte)(n3 += byArray[i - n2] & 0xFF);
        }
    }

    private static void decodeUpFilter(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            int n3 = byArray2[i] & 0xFF;
            byArray[i] = (byte)(n2 + n3);
        }
    }

    private static void decodeAverageFilter(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = byArray[n5] & 0xFF;
            n3 = byArray2[n5] & 0xFF;
            byArray[n5] = (byte)(n4 + n3 / 2);
        }
        for (n5 = n2; n5 < n; ++n5) {
            n4 = byArray[n5] & 0xFF;
            int n6 = byArray[n5 - n2] & 0xFF;
            n3 = byArray2[n5] & 0xFF;
            byArray[n5] = (byte)(n4 + (n6 + n3) / 2);
        }
    }

    private static int paethPredictor(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = Math.abs(n4 - n);
        int n6 = Math.abs(n4 - n2);
        int n7 = Math.abs(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }

    private static void decodePaethFilter(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = byArray[n5] & 0xFF;
            n3 = byArray2[n5] & 0xFF;
            byArray[n5] = (byte)(n4 + n3);
        }
        for (n5 = n2; n5 < n; ++n5) {
            n4 = byArray[n5] & 0xFF;
            int n6 = byArray[n5 - n2] & 0xFF;
            n3 = byArray2[n5] & 0xFF;
            int n7 = byArray2[n5 - n2] & 0xFF;
            byArray[n5] = (byte)(n4 + PngImage.paethPredictor(n6, n3, n7));
        }
    }

    public static final int getInt(InputStream inputStream) throws IOException {
        return (inputStream.read() << 24) + (inputStream.read() << 16) + (inputStream.read() << 8) + inputStream.read();
    }

    public static final int getWord(InputStream inputStream) throws IOException {
        return (inputStream.read() << 8) + inputStream.read();
    }

    public static final String getString(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append((char)inputStream.read());
        }
        return stringBuffer.toString();
    }

    static class NewByteArrayOutputStream
    extends ByteArrayOutputStream {
        NewByteArrayOutputStream() {
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

