(ns lupapiste-invoice-commons.validators
  "This namespace contains validators that can be used with state changed by the 'state-change-state-machine'"
  (:require [clojure.string :refer [blank?]]))

(defn valid-for-checked->confirmed? [{:keys [sap-number] :as invoice}]
  ((every-pred string? (complement blank?)) sap-number))
