(ns janus.dates
  "SQL Date/Time wrangling for Clojure."
  (:require [clj-time.coerce :as t-c]
            [clojure.java.jdbc :as sql])
  (:import [java.sql PreparedStatement]
           [org.postgresql.util PGInterval]))

(extend-protocol sql/IResultSetReadColumn
  java.sql.Date
  (result-set-read-column [v _ _] (t-c/from-sql-date v))

  java.sql.Timestamp
  (result-set-read-column [v _ _] (t-c/from-sql-time v)))

(extend-type java.util.Date
  sql/ISQLParameter
  (set-parameter [v ^PreparedStatement stmt idx]
    (.setTimestamp stmt idx (t-c/to-sql-time v))))

(extend-type org.joda.time.DateTime
  sql/ISQLParameter
  (set-parameter [v ^PreparedStatement stmt idx]
    (.setTimestamp stmt idx (t-c/to-sql-time v))))

(extend-type org.joda.time.Interval
  sql/ISQLParameter
  (set-parameter [v ^PreparedStatement stmt idx]
    (.setObject stmt idx (doto (PGInterval. )
                           (.setSeconds (/ (clj-time.core/in-millis v) 1000))))))
