(ns leiningen.new.lumiere-app
  (:require [leiningen.new.templates :refer [raw-resourcer renderer date year name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "lumiere-app"))
(def raw (raw-resourcer "lumiere-app"))

(defn lumiere-app
  "Create a new Lumiere project"
  [name]
  (let [data {:name name
              :date (date)
              :year (year)
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' lumiere-app project.")
    (->files data
             ;; core assets 
             ["project.clj" (render "project.clj" data)]
             ["dev-config.end" (render "dev-config.edn" data)]
             ["test-config.edn" (render "test-config.edn" data)]
             ["Procfile" (render "Procfile" data)]
             ["Dockerfile" (render "Dockerfile" data)]
             ["LICENSE" (render "LICENSE" data)]
             [".gitignore" (render "gitignore" data)]
             ["CHANGELOG.md" (render "CHANGELOG.md" data)]
             ["README.md" (render "README.md" data)]

             ;; env config
             ["env/prod/resources/config.edn" (render "env/prod/resources/config.edn" data)]
             ["env/dev/resources/config.edn" (render "env/dev/resources/config.edn" data)]
             ["env/test/resources/config.edn" (render "env/dev/resources/config.edn" data)]
             ["env/prod/resources/log4j.properties" (render "env/prod/resources/log4j.properties" data)]
             ["env/dev/resources/log4j.properties" (render "env/dev/resources/log4j.properties" data)]

             ;; env
             ["env/dev/clj/{{sanitized}}/env.clj" (render "env/dev/clj/lumiere_app/env.clj" data)]
             ["env/dev/clj/{{sanitized}}/dev_middleware.clj"
              (render "env/dev/clj/lumiere_app/dev_middleware.clj" data)]
             ["env/dev/clj/{{sanitized}}/figwheel.clj" (render "env/dev/clj/lumiere_app/figwheel.clj" data)]
             ["env/dev/clj/user.clj" (render "env/dev/clj/user.clj" data)]
             ["env/dev/cljs/{{sanitized}}/dev.cljs" (render "env/dev/cljs/lumiere_app/dev.cljs" data)]
             ["env/prod/clj/{{sanitized}}/env.clj" (render "env/prod/clj/lumiere_app/env.clj" data)]
             ["env/prod/cljs/{{sanitized}}/prod.cljs" (render "env/prod/cljs/lumiere_app/prod.cljs" data)]
             
             ;; resources
             ["resources/docs/docs.md" (render "resources/docs/docs.md" data)]
             ["resources/public/css/screen.css" (render "resources/public/css/screen.css" data)]
             ["resources/public/favicon.ico" (raw "resources/public/favicon.ico")]
             "resources/public/js"
             "resources/public/img"
             ["resources/templates/error.html" (render "resources/templates/error.html" data)]
             ["resources/templates/home.html" (render "resources/templates/home.html" data)]
             
             ;; clj namespaces
             ["src/clj/{{sanitized}}/config.clj" (render "src/clj/lumiere_app/config.clj" data)]
             ["src/clj/{{sanitized}}/core.clj" (render "src/clj/lumiere_app/core.clj" data)]
             ["src/clj/{{sanitized}}/handler.clj" (render "src/clj/lumiere_app/handler.clj" data)]
             ["src/clj/{{sanitized}}/layout.clj" (render "src/clj/lumiere_app/layout.clj" data)]
             ["src/clj/{{sanitized}}/logger.clj" (render "src/clj/lumiere_app/logger.clj" data)]
             ["src/clj/{{sanitized}}/middleware.clj" (render "src/clj/lumiere_app/middleware.clj" data)]
             ["src/clj/{{sanitized}}/repl.clj" (render "src/clj/lumiere_app/repl.clj" data)]
             ["src/clj/{{sanitized}}/session.clj" (render "src/clj/lumiere_app/session.clj" data)]
             ["src/clj/{{sanitized}}/db/core.clj" (render "src/clj/lumiere_app/db/core.clj" data)]
             ["src/clj/{{sanitized}}/routes/home.clj" (render "src/clj/lumiere_app/routes/home.clj" data)]
             ["src/clj/{{sanitized}}/routes/services.clj"
              (render "src/clj/lumiere_app/routes/services.clj" data)]
             ["src/clj/{{sanitized}}/routes/websockets.clj"
              (render "src/clj/lumiere_app/routes/websockets.clj" data)]

             ;; cljc namespaces
             ["src/cljc/{{sanitized}}/validation.cljc" (render "src/cljc/lumiere_app/validation.cljc" data)]
             
             ;; cljs namespaces
             ["src/cljs/{{sanitized}}/ajax.cljs" (render "src/cljs/lumiere_app/ajax.cljs" data)]
             ["src/cljs/{{sanitized}}/core.cljs" (render "src/cljs/lumiere_app/core.cljs" data)]
             ["src/cljs/{{sanitized}}/data.cljs" (render "src/cljs/lumiere_app/data.cljs" data)]
             ["src/cljs/{{sanitized}}/websockets.cljs" (render "src/cljs/lumiere_app/websockets.cljs" data)]
             
             ;; tests
             ["test/clj/{{sanitized}}/test/handler.clj" (render "test/clj/lumiere_app/test/handler.clj" data)]
             ["test/cljs/{{sanitized}}/core_test.cljs" (render "test/cljs/lumiere_app/core_test.cljs" data)]
             ["test/cljs/{{sanitized}}/doo_runner.cljs"
              (render "test/cljs/lumiere_app/doo_runner.cljs" data)])))
