(defproject {{name}} "0.1.0"

  :description "FIXME: write description"
  :url "http://example.com/FIXME"

  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies [[log4j-edn-config "0.1.1"]
                 [org.slf4j/slf4j-log4j12 "1.7.25"]
                 [org.apache.logging.log4j/log4j-core "2.8.2"]
                 [metosin/compojure-api "1.1.10"]
                 [cljs-ajax "0.5.9"]
                 [secretary "1.2.3"]
                 [reagent-utils "0.2.1"]
                 [reagent "0.6.1"]
                 [org.clojure/clojurescript "1.9.521" :scope "provided"]
                 [org.clojure/clojure "1.8.0"]
                 [org.clojure/core.async "0.3.442" :exclusions [org.clojure/tools.reader]]
                 [selmer "1.10.7"]
                 [markdown-clj "0.9.99"]
                 [ring-middleware-format "0.7.2"]
                 [metosin/ring-http-response "0.8.2"]
                 [bouncer "1.0.1"]
                 [org.webjars/pure "2.83"]
                 [org.clojure/tools.logging "0.3.1"]
                 [org.clojure/tools.nrepl "0.2.13"]
                 [compojure "1.5.2"]
                 [ring-webjars "0.1.1"]
                 [ring/ring-defaults "0.2.3"]
                 [ring/ring-core "1.5.1"]
                 [expiring-map "0.1.8"]
                 [mount "0.1.11"]
                 [cprop "0.1.10"]
                 [org.clojure/tools.cli "0.3.5"]
                 [buddy "1.3.0"]
                 [datascript "0.16.0"]
                 [posh "0.5.6"]
                 [com.datomic/datomic-free "0.9.5561" :exclusions [com.google.guava/guava
                                                                   org.slf4j/log4j-over-slf4j
                                                                   org.slf4j/slf4j-nop]]
                 [http-kit "2.2.0"]]

  :min-lein-version "2.6.1"

  :jvm-opts ["-server" "-Dconf=.lein-env"]
  :source-paths ["src/clj" "src/cljc"]
  :resource-paths ["resources" "target/cljsbuild"]

  :main {{name}}.core

  :plugins [[lein-cprop "1.0.1"]
            [lein-cljsbuild "1.1.3"]]
  
  :clean-targets ^{:protect false} [:target-path
                                    [:cljsbuild :builds :app :compiler :output-dir]
                                    [:cljsbuild :builds :app :compiler :output-to]]

  :cljsbuild {:builds {:app {:source-paths ["src/cljc" "src/cljs"]
                             :compiler {:output-to "target/cljsbuild/public/js/app.js"
                                        :output-dir "target/cljsbuild/public/js/out"
                                        :externs ["react/externs/react.js"]
                                        :pretty-print true}}}}
  
  :target-path "target/%s/"

  :profiles {:uberjar {:omit-source true
                       :prep-tasks ["compile" ["cljsbuild" "once"]]
                       :cljsbuild {:builds {:app {:source-paths ["env/prod/cljs"]
                                                  :compiler {:optimizations :advanced
                                                             :pretty-print false
                                                             :closure-warnings {:externs-validation :off
                                                                                :non-standard-jsdoc :off}}}}} 
                       :aot :all
                       :uberjar-name "{{name}}.jar"
                       :source-paths ["env/prod/clj"]
                       :resource-paths ["env/prod/resources"]}
             
             :dev           [:project/dev :profiles/dev]
             
             :test          [:project/test :profiles/test]
             
             :project/dev  {:dependencies [[prone "1.1.4"]
                                           [ring/ring-mock "0.3.0"]
                                           [ring/ring-devel "1.5.1"]
                                           [pjstadig/humane-test-output "0.8.1"]
                                           [lein-figwheel "0.5.10"]
                                           [figwheel-sidecar "0.5.10"]
                                           [lein-doo "0.1.7"]
                                           [com.cemerick/piggieback "0.2.1"]]
                            
                            :plugins      [[com.jakemccrary/lein-test-refresh "0.14.0"]
                                           [lein-figwheel "0.5.10"]
                                           [lein-doo "0.1.7"]
                                           [org.clojure/clojurescript "1.9.521"]]
                  
                            :cljsbuild {:builds {:app {:source-paths ["env/dev/cljs"]
                                                       :compiler {:main "{{name}}.app"
                                                                  :asset-path "/js/out"
                                                                  :optimizations :none
                                                                  :source-map true}}
                                                 :test {:source-paths ["src/cljc" "src/cljs" "test/cljs"]
                                                        :compiler {:output-to "target/test.js"
                                                                   :main "{{name}}.doo-runner"
                                                                   :optimizations :whitespace
                                                                   :pretty-print true}}}} 
                            
                            :figwheel {:http-server-root "public"
                                       :nrepl-port 7002
                                       :css-dirs ["resources/public/css"]}
                            
                            :doo {:build "test"}
                            :source-paths ["env/dev/clj" "test/clj"]
                            :resource-paths ["env/dev/resources"]
                            :repl-options {:init-ns user
                                           :nrepl-middleware
                                           [cemerick.piggieback/wrap-cljs-repl]}
                            :injections [(require 'pjstadig.humane-test-output)
                                         (pjstadig.humane-test-output/activate!)]}
             
             :project/test {:resource-paths ["env/dev/resources" "env/test/resources"]}

             :profiles/dev {}
             :profiles/test {}})
