(ns exterial.core-test
  (:require [cljs.test :as t :include-macros true]
            [exterial.core :as core]))

(t/deftest basic-tests
  (let [obj (clj->js {:a :b
                      :c {:d :e
                          :f inc
                          :g (fn [] (this-as this this.d))}})]
    (t/testing "Testing setup test"
      (t/is (= "e" (.g ^js (.-c ^js obj)))))
    (t/testing "Bang tests"
      (t/is (= "b" (core/! obj -a)))
      (t/is (= "e" (-> obj (core/! -c) (core/! -d))))
      (t/is (= 3 (-> obj (core/! -c) (core/! f 2))))
      (t/is (= "e" (-> obj (core/! -c) (core/! g)))))
    (t/testing "Bang bang tests"
      (t/is (= "b" (core/!! obj (-a))))
      (t/is (= "b" (core/!! obj -a)))
      (t/is (= "e" (core/!! obj (-c) (-d))))
      (t/is (= "e" (core/!! obj -c (-d))))
      (t/is (= "e" (core/!! obj (-c) -d)))
      (t/is (= "e" (core/!! obj -c -d)))
      (t/is (= 3 (core/!! obj (-c) (f 2))))
      (t/is (= 3 (core/!! obj -c (f 2))))
      (t/is (= "e" (core/!! obj -c g))))))
