(ns exterial.core
  #?(:cljs
     (:use-macros [exterial.core :only [! !!]])))

(defn- method-name->field-name
  [method-name]
  (let [[c & others] (str method-name)]
    (when (= \- c)
      (apply str others))))

(defn- field-access
  [object method-name]
  `(goog.object.get ~object ~(str method-name)))

(defn- method-call
  [object method-name args]
  `(let [f# (goog.object.get ~object ~(str method-name))]
     ((.bind ^js f# ~object) ~@args)))

(defmacro !
  [object method-name & args]
  (if-let [field-name (method-name->field-name method-name)]
    (field-access object field-name)
    (method-call object method-name args)))

(defn- normalize-form
  [form]
  (if (seq? form)
    form
    (list form)))

(defmacro !!
  ([x form] `(! ~x ~@(normalize-form form)))
  ([x form & more] `(!! (! ~x ~@(normalize-form form)) ~@more)))
