/*
 * Decompiled with CFR 0.152.
 */
package dev.morling.quarkus.extensions.lucene.extension.deployment;

import dev.morling.quarkus.extensions.lucene.extension.DirectoryProvider;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;

class QuarkusLuceneExtensionProcessor {
    private static final String FEATURE = "quarkus-lucene-extension";
    private static final String SEARCH_INDEX_FILE = "/META-INF/searchindex.json";

    QuarkusLuceneExtensionProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void createIndex(BuildProducer<GeneratedFileSystemResourceBuildItem> gen) throws Exception {
        Path indexLocation = Files.createTempDirectory("quarkus-build", new FileAttribute[0]).resolve("index").toAbsolutePath();
        this.createIndexDirectory(indexLocation);
        Path indexDir = Paths.get("index", new String[0]);
        Files.walk(indexLocation, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
            try {
                String path = indexDir.resolve(indexLocation.relativize((Path)file)).toString();
                gen.produce((BuildItem)new GeneratedFileSystemResourceBuildItem(path, Files.readAllBytes(file)));
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't generate resource", e);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Directory createIndexDirectory(Path root) throws Exception {
        SimpleFSDirectory dir = new SimpleFSDirectory(root);
        EnglishAnalyzer analyzer = new EnglishAnalyzer();
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        try (InputStream fis = QuarkusLuceneExtensionProcessor.getSearchIndexFile();){
            Iterator iterator;
            try (IndexWriter indexWriter = new IndexWriter((Directory)dir, iwc);){
                JsonReader reader = Json.createReader((InputStream)fis);
                for (JsonValue object : reader.readArray()) {
                    JsonObject jsonObject = object.asJsonObject();
                    if (jsonObject.getString("content").isEmpty()) continue;
                    Document doc = new Document();
                    FieldType ft = new FieldType();
                    ft.setStored(true);
                    ft.setStoreTermVectors(true);
                    ft.setStoreTermVectorOffsets(true);
                    ft.setStoreTermVectorPositions(true);
                    ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
                    doc.add((IndexableField)new Field("content", (CharSequence)jsonObject.getString("content"), (IndexableFieldType)ft));
                    doc.add((IndexableField)new Field("title", (CharSequence)jsonObject.getString("title"), (IndexableFieldType)ft));
                    doc.add((IndexableField)new Field("uri", (CharSequence)jsonObject.getString("uri"), (IndexableFieldType)ft));
                    String tags = this.getTags(jsonObject);
                    if (tags != null) {
                        doc.add((IndexableField)new Field("tags", (CharSequence)tags, (IndexableFieldType)ft));
                    }
                    doc.add((IndexableField)new TextField("publicationdate", jsonObject.getString("publicationdate"), Field.Store.YES));
                    indexWriter.addDocument((Iterable)doc);
                }
                indexWriter.commit();
                iterator = dir;
            }
            return iterator;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't index JSON file", e);
        }
    }

    private String getTags(JsonObject jsonObject) {
        JsonValue tags = (JsonValue)jsonObject.get((Object)"tags");
        if (tags != null) {
            if (tags.getValueType() == JsonValue.ValueType.ARRAY) {
                JsonString[] tagsAsString = (JsonString[])tags.asJsonArray().toArray((Object[])new JsonString[0]);
                return Arrays.stream(tagsAsString).map(JsonString::getString).collect(Collectors.joining(", "));
            }
            if (tags.getValueType() == JsonValue.ValueType.STRING) {
                return tags.toString();
            }
        }
        return null;
    }

    @BuildStep
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DirectoryProvider.class}));
    }

    private static InputStream getSearchIndexFile() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(SEARCH_INDEX_FILE);
    }
}

