/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;

public class TokenStreamToDot {
    private final TokenStream in;
    private final CharTermAttribute termAtt;
    private final PositionIncrementAttribute posIncAtt;
    private final PositionLengthAttribute posLengthAtt;
    private final OffsetAttribute offsetAtt;
    private final String inputText;
    protected final PrintWriter out;
    private static final String FONT_NAME = "Helvetica";

    public TokenStreamToDot(String string, TokenStream tokenStream, PrintWriter printWriter) {
        this.in = tokenStream;
        this.out = printWriter;
        this.inputText = string;
        this.termAtt = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
        this.posIncAtt = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
        this.posLengthAtt = (PositionLengthAttribute)tokenStream.addAttribute(PositionLengthAttribute.class);
        this.offsetAtt = tokenStream.hasAttribute(OffsetAttribute.class) ? (OffsetAttribute)tokenStream.addAttribute(OffsetAttribute.class) : null;
    }

    public void toDot() throws IOException {
        this.in.reset();
        this.writeHeader();
        int n = -1;
        int n2 = -1;
        while (this.in.incrementToken()) {
            boolean bl = n == -1;
            int n3 = this.posIncAtt.getPositionIncrement();
            if (bl && n3 == 0) {
                System.err.println("WARNING: first posInc was 0; correcting to 1");
                n3 = 1;
            }
            if (n3 > 0) {
                this.writeNode(n += n3, Integer.toString(n));
            }
            if (n3 > 1) {
                this.writeArc(n2, n, null, "dotted");
            }
            if (bl) {
                this.writeNode(-1, null);
                this.writeArc(-1, n, null, null);
            }
            Object object = this.termAtt.toString();
            if (this.offsetAtt != null) {
                int n4 = this.offsetAtt.startOffset();
                int n5 = this.offsetAtt.endOffset();
                if (this.inputText != null) {
                    String string = this.inputText.substring(n4, n5);
                    if (!string.equals(this.termAtt.toString())) {
                        object = (String)object + " / " + string;
                    }
                } else {
                    object = (String)object + " / " + n4 + "-" + n5;
                }
            }
            this.writeArc(n, n + this.posLengthAtt.getPositionLength(), (String)object, null);
            n2 = n + this.posLengthAtt.getPositionLength();
        }
        this.in.end();
        if (n2 != -1) {
            this.writeNode(-2, null);
            this.writeArc(n2, -2, null, null);
        }
        this.writeTrailer();
    }

    protected void writeArc(int n, int n2, String string, String string2) {
        this.out.print("  " + n + " -> " + n2 + " [");
        if (string != null) {
            this.out.print(" label=\"" + string + "\"");
        }
        if (string2 != null) {
            this.out.print(" style=\"" + string2 + "\"");
        }
        this.out.println("]");
    }

    protected void writeNode(int n, String string) {
        this.out.print("  " + n);
        if (string != null) {
            this.out.print(" [label=\"" + string + "\"]");
        } else {
            this.out.print(" [shape=point color=white]");
        }
        this.out.println();
    }

    protected void writeHeader() {
        this.out.println("digraph tokens {");
        this.out.println("  graph [ fontsize=30 labelloc=\"t\" label=\"\" splines=true overlap=false rankdir = \"LR\" ];");
        this.out.println("  // A2 paper size");
        this.out.println("  size = \"34.4,16.5\";");
        this.out.println("  edge [ fontname=\"Helvetica\" fontcolor=\"red\" color=\"#606060\" ]");
        this.out.println("  node [ style=\"filled\" fillcolor=\"#e8e8f0\" shape=\"Mrecord\" fontname=\"Helvetica\" ]");
        this.out.println();
    }

    protected void writeTrailer() {
        this.out.println("}");
    }
}

