// Compiled by ClojureScript 1.9.521 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (hasch.benc._coerce[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__10138__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__55812_55816 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__55813_55817 = null;
var count__55814_55818 = (0);
var i__55815_55819 = (0);
while(true){
if((i__55815_55819 < count__55814_55818)){
var bs_55820 = cljs.core._nth.call(null,chunk__55813_55817,i__55815_55819);
md.update(bs_55820);

var G__55821 = seq__55812_55816;
var G__55822 = chunk__55813_55817;
var G__55823 = count__55814_55818;
var G__55824 = (i__55815_55819 + (1));
seq__55812_55816 = G__55821;
chunk__55813_55817 = G__55822;
count__55814_55818 = G__55823;
i__55815_55819 = G__55824;
continue;
} else {
var temp__6738__auto___55825 = cljs.core.seq.call(null,seq__55812_55816);
if(temp__6738__auto___55825){
var seq__55812_55826__$1 = temp__6738__auto___55825;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__55812_55826__$1)){
var c__10330__auto___55827 = cljs.core.chunk_first.call(null,seq__55812_55826__$1);
var G__55828 = cljs.core.chunk_rest.call(null,seq__55812_55826__$1);
var G__55829 = c__10330__auto___55827;
var G__55830 = cljs.core.count.call(null,c__10330__auto___55827);
var G__55831 = (0);
seq__55812_55816 = G__55828;
chunk__55813_55817 = G__55829;
count__55814_55818 = G__55830;
i__55815_55819 = G__55831;
continue;
} else {
var bs_55832 = cljs.core.first.call(null,seq__55812_55826__$1);
md.update(bs_55832);

var G__55833 = cljs.core.next.call(null,seq__55812_55826__$1);
var G__55834 = null;
var G__55835 = (0);
var G__55836 = (0);
seq__55812_55816 = G__55833;
chunk__55813_55817 = G__55834;
count__55814_55818 = G__55835;
i__55815_55819 = G__55836;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_55843 = seq;
while(true){
var vec__55840_55844 = s_55843;
var seq__55841_55845 = cljs.core.seq.call(null,vec__55840_55844);
var first__55842_55846 = cljs.core.first.call(null,seq__55841_55845);
var seq__55841_55847__$1 = cljs.core.next.call(null,seq__55841_55845);
var f_55848 = first__55842_55846;
var r_55849 = seq__55841_55847__$1;
seq_md.update(hasch.benc._coerce.call(null,f_55848,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_55849)){
} else {
var G__55850 = cljs.core.rest.call(null,s_55843);
s_55843 = G__55850;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__9764__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__9765__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__9764__auto__ < y__9765__auto__) ? x__9764__auto__ : y__9765__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_55851 = (0);
while(true){
if((i_55851 < len)){
(acc[i_55851] = ((acc[i_55851]) ^ (elem[i_55851])));

var G__55852 = (i_55851 + (1));
i_55851 = G__55852;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_55853 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_55853,len)){
} else {
var e_55854 = (a[i_55853]);
if(((e_55854 > (0))) && ((e_55854 < (30)))){
(ea[i_55853] = (1));
} else {
}

var G__55855 = (i_55853 + (1));
i_55853 = G__55855;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});

//# sourceMappingURL=benc.js.map