Figwheel Testbook
=================

Test runner & reporter in your browser, 
shows a pretty list of running tests and tries to make your life easier.

For Clojurescript only.

Usage
-----

[![Clojars Project](https://img.shields.io/clojars/v/figwheel-testbook.svg)](https://clojars.org/figwheel-testbook)
[![CircleCI](https://circleci.com/gh/lsenta/figwheel-testbook.svg?style=svg)](https://circleci.com/gh/lsenta/figwheel-testbook)

The library provides a single function `(figwheel-testbook.core/testbook "root-div-id")`  
which displays the result or your `cljs.test` test run on the page.

A simple example would be:

```clojure
(ns running.testbook
  (:require
    [running.test-all]
    [cljs.test :as test :refer-macros [run-all-tests]]
    [figwheel-testbook.core :refer [testbook]]))

(defn ^:export reload-hook []
  (run-all-tests)
  (testbook "root"))

(defn ^:export init []
  (enable-console-print!)
  (reload-hook))
```

Checkout the `example/` folder for a fully working demo. 
It should be possible to embed it directly inside your app too.


TODOs
-----

- [ ] Have some tests
- [ ] Find a way to pass the resources (bootstrap, font-awesome, etc) 
      to the client figwheel instance.
- [ ] Find a way to provide the features as a simple plugin / options instead
      of forcing the client to define their fighweel config and entry.


Contribute
----------

```bash
git clone git@github.com:lsenta/figwheel-testbook.git
lein cljsbuild once test
```


License
-------

MIT License

Copyright (c) 2017 Laurent Senta

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
