(defproject lsenta/figwheel-testbook "0.0.1"

  :description "A pretty runner & reporter for your Clojurescript tests relying on figwheel."
  :url "https://github.com/lsenta/figwheel-testbook"

  :dependencies
  [[org.clojure/clojure "1.9.0-alpha16" :scope "provided"]
   [org.clojure/clojurescript "1.9.521" :scope "provided"]

   [reagent "0.6.1"]
   [com.taoensso/timbre "4.10.0"]

   [lein-doo "0.1.7" :scope "test"]]

  :source-paths
  ["src/cljc" "src/cljs"]
  :test-paths
  ["test/cljc" "test/cljs"]
  :resource-paths
  ["resources"]

  :plugins [[lein-cljsbuild "1.1.6"]
            [lein-doo "0.1.7"]]

  :hooks [leiningen.cljsbuild]

  :doo {:build "test"}

  :profiles
  {:dev
   {:plugins [[lein-doo "0.1.7"]]}}

  :cljsbuild
  {:builds
   [
    ;; -- CLJS: Test --
    ;; Build in a debuggable mode with the doo-runner available
    {:id           "test"
     :source-paths ["src/cljc" "src/cljs"
                    "test/cljc" "test/cljs"]
     :compiler     {:output-to     "target/test/testable.js"
                    :main          fighweel-testbook.doo-runner
                    :optimizations :none
                    :pretty-print  true
                    :source-map    true}}
    ;; -- CLJS: Release --
    ;; Build with optimization mode
    {:id           "release"
     :source-paths ["src/cljc"
                    "src/cljs"]
     :compiler     {:output-to     "target/release/js/"
                    :optimizations :advanced
                    :pretty-print  false}}]})
