(defproject lsenta/budb "0.0.2-SNAPSHOT"
  :description "A CRDT Database for Clojure(script)"
  :url "https://github.com/lsenta/budb"
  :license {:name "MIT License"}

  :repositories [["releases" {:url      "https://clojars.org/repo/"
                              ;; no gpg signin, this makes deploy from circleci easier.
                              ;; Open an issue if that's an issue for you.
                              :sign-releases false
                              :username :env/clojars_account
                              :password :env/clojars_password}]
                 ["snapshots" {:url      "https://clojars.org/repo/"
                               :username :env/clojars_account
                               :password :env/clojars_password}]]

  :dependencies
  [[org.clojure/clojure "1.9.0-alpha16" :scope "provided"]
   [org.clojure/clojurescript "1.9.521" :scope "provided"]

   [com.taoensso/timbre "4.8.0"]

   [io.replikativ/superv.async "0.2.6"]
   [io.replikativ/konserve "0.4.9"]
   [lsenta/konserve-firebase "0.0.3-SNAPSHOT"]

   [devcards "0.2.2" :scope "test"]
   [lein-doo "0.1.7" :scope "test"]
   [binaryage/devtools "0.9.2" :scope "test"]
   [binaryage/dirac "1.2.2" :scope "test"]
   [lsenta/figwheel-testbook "0.0.3-SNAPSHOT" :scope "test"]]

  :source-paths
  ["src/cljc" "src/clj" "src/cljs"]
  :test-paths
  ["test/cljc" "test/clj" "test/cljs"]
  :resource-paths
  ["resources"]

  ;; Clean everything, especially the resources/target folder
  ; ; that contains all the generated javascript.
  :clean-targets
  ^{:protect false} [:target-path :compile-path "resources/public/test-js"]

  :plugins [[lein-cljsbuild "1.1.6"]
            [lein-doo "0.1.7"]]
  :doo {:build "test"}

  ;; -- Figwheel Server --
  ;; Custom port because multi-projects.
  :figwheel
  {:server-port 8100}

  :profiles
  {:dev
   {:dependencies [[pjstadig/humane-test-output "0.8.1"]]
    :plugins      [[lein-doo "0.1.7"]
                   [lein-resource "16.9.1"]
                   [lein-figwheel "0.5.10"]
                   [com.jakemccrary/lein-test-refresh "0.20.0"]]
    :injections   [(require 'pjstadig.humane-test-output)
                   (pjstadig.humane-test-output/activate!)]}}

  :cljsbuild
  {:builds
   [
    ;; -- CLJS: Test --
    ;; Build in a debuggable mode with the doo-runner available
    ;; generate to testable.js
    {:id           "test"
     :source-paths ["env/cljs"
                    "src/cljc" "src/cljs"
                    "test/cljc" "test/cljs"]
     :compiler     {:output-to     "resources/public/test-js/testable.js"
                    :main          running.doo-runner
                    :optimizations :none
                    :pretty-print  true
                    :source-map    true}}
    ;; -- CLJS: Testbook --
    ;; The small test runner on top of figwheel
    ;; generates to testbook.js
    {:id           "testbook"
     :source-paths ["env/cljs"
                    "src/cljc" "src/cljs"
                    "test/cljc" "test/cljs"]
     :figwheel     {:on-jsload running.testbook/reload-hook}
     :compiler     {:main          running.testbook
                    :asset-path    "/test-js/testbook"
                    :output-to     "resources/public/test-js/testbook.js"
                    :output-dir    "resources/public/test-js/testbook"
                    :optimizations :none
                    :pretty-print  true
                    :source-map    true}}
    ;; -- CLJS: Devbook --
    ;; The devcard build
    ;; generates to devbook.js
    {:id           "devbook"
     :source-paths ["env"
                    "src/cljc" "src/cljs"
                    "test/cljc" "test/cljs"]
     :figwheel     {:devcards true}
     :compiler     {:main          devbook.core
                    :asset-path    "/test-js/devbook"
                    :output-to     "resources/public/test-js/devbook.js"
                    :output-dir    "resources/public/test-js/devbook"
                    :optimizations :none
                    :pretty-print  true
                    :source-map    true}}]})
