// Compiled by ClojureScript 1.9.521 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__52592__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__52589 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__52590 = cljs.core.seq.call(null,vec__52589);
var first__52591 = cljs.core.first.call(null,seq__52590);
var seq__52590__$1 = cljs.core.next.call(null,seq__52590);
var tag = first__52591;
var body = seq__52590__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__52592 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__52593__i = 0, G__52593__a = new Array(arguments.length -  0);
while (G__52593__i < G__52593__a.length) {G__52593__a[G__52593__i] = arguments[G__52593__i + 0]; ++G__52593__i;}
  args = new cljs.core.IndexedSeq(G__52593__a,0);
} 
return G__52592__delegate.call(this,args);};
G__52592.cljs$lang$maxFixedArity = 0;
G__52592.cljs$lang$applyTo = (function (arglist__52594){
var args = cljs.core.seq(arglist__52594);
return G__52592__delegate(args);
});
G__52592.cljs$core$IFn$_invoke$arity$variadic = G__52592__delegate;
return G__52592;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__10281__auto__ = (function sablono$core$update_arglists_$_iter__52599(s__52600){
return (new cljs.core.LazySeq(null,(function (){
var s__52600__$1 = s__52600;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__52600__$1);
if(temp__6738__auto__){
var s__52600__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__52600__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__52600__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__52602 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__52601 = (0);
while(true){
if((i__52601 < size__10280__auto__)){
var args = cljs.core._nth.call(null,c__10279__auto__,i__52601);
cljs.core.chunk_append.call(null,b__52602,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__52603 = (i__52601 + (1));
i__52601 = G__52603;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52602),sablono$core$update_arglists_$_iter__52599.call(null,cljs.core.chunk_rest.call(null,s__52600__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52602),null);
}
} else {
var args = cljs.core.first.call(null,s__52600__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__52599.call(null,cljs.core.rest.call(null,s__52600__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__10647__auto__ = [];
var len__10640__auto___52609 = arguments.length;
var i__10641__auto___52610 = (0);
while(true){
if((i__10641__auto___52610 < len__10640__auto___52609)){
args__10647__auto__.push((arguments[i__10641__auto___52610]));

var G__52611 = (i__10641__auto___52610 + (1));
i__10641__auto___52610 = G__52611;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((0) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__10648__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__10281__auto__ = (function sablono$core$iter__52605(s__52606){
return (new cljs.core.LazySeq(null,(function (){
var s__52606__$1 = s__52606;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__52606__$1);
if(temp__6738__auto__){
var s__52606__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__52606__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__52606__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__52608 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__52607 = (0);
while(true){
if((i__52607 < size__10280__auto__)){
var style = cljs.core._nth.call(null,c__10279__auto__,i__52607);
cljs.core.chunk_append.call(null,b__52608,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__52612 = (i__52607 + (1));
i__52607 = G__52612;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52608),sablono$core$iter__52605.call(null,cljs.core.chunk_rest.call(null,s__52606__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52608),null);
}
} else {
var style = cljs.core.first.call(null,s__52606__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__52605.call(null,cljs.core.rest.call(null,s__52606__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq52604){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq52604));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to52613 = (function sablono$core$link_to52613(var_args){
var args__10647__auto__ = [];
var len__10640__auto___52616 = arguments.length;
var i__10641__auto___52617 = (0);
while(true){
if((i__10641__auto___52617 < len__10640__auto___52616)){
args__10647__auto__.push((arguments[i__10641__auto___52617]));

var G__52618 = (i__10641__auto___52617 + (1));
i__10641__auto___52617 = G__52618;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to52613.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.link_to52613.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to52613.cljs$lang$maxFixedArity = (1);

sablono.core.link_to52613.cljs$lang$applyTo = (function (seq52614){
var G__52615 = cljs.core.first.call(null,seq52614);
var seq52614__$1 = cljs.core.next.call(null,seq52614);
return sablono.core.link_to52613.cljs$core$IFn$_invoke$arity$variadic(G__52615,seq52614__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to52613);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to52619 = (function sablono$core$mail_to52619(var_args){
var args__10647__auto__ = [];
var len__10640__auto___52626 = arguments.length;
var i__10641__auto___52627 = (0);
while(true){
if((i__10641__auto___52627 < len__10640__auto___52626)){
args__10647__auto__.push((arguments[i__10641__auto___52627]));

var G__52628 = (i__10641__auto___52627 + (1));
i__10641__auto___52627 = G__52628;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to52619.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.mail_to52619.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__52622){
var vec__52623 = p__52622;
var content = cljs.core.nth.call(null,vec__52623,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("mailto:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__9419__auto__ = content;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to52619.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to52619.cljs$lang$applyTo = (function (seq52620){
var G__52621 = cljs.core.first.call(null,seq52620);
var seq52620__$1 = cljs.core.next.call(null,seq52620);
return sablono.core.mail_to52619.cljs$core$IFn$_invoke$arity$variadic(G__52621,seq52620__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to52619);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list52629 = (function sablono$core$unordered_list52629(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__10281__auto__ = (function sablono$core$unordered_list52629_$_iter__52634(s__52635){
return (new cljs.core.LazySeq(null,(function (){
var s__52635__$1 = s__52635;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__52635__$1);
if(temp__6738__auto__){
var s__52635__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__52635__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__52635__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__52637 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__52636 = (0);
while(true){
if((i__52636 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__52636);
cljs.core.chunk_append.call(null,b__52637,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__52638 = (i__52636 + (1));
i__52636 = G__52638;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52637),sablono$core$unordered_list52629_$_iter__52634.call(null,cljs.core.chunk_rest.call(null,s__52635__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52637),null);
}
} else {
var x = cljs.core.first.call(null,s__52635__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list52629_$_iter__52634.call(null,cljs.core.rest.call(null,s__52635__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list52629);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list52639 = (function sablono$core$ordered_list52639(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__10281__auto__ = (function sablono$core$ordered_list52639_$_iter__52644(s__52645){
return (new cljs.core.LazySeq(null,(function (){
var s__52645__$1 = s__52645;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__52645__$1);
if(temp__6738__auto__){
var s__52645__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__52645__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__52645__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__52647 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__52646 = (0);
while(true){
if((i__52646 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__52646);
cljs.core.chunk_append.call(null,b__52647,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__52648 = (i__52646 + (1));
i__52646 = G__52648;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52647),sablono$core$ordered_list52639_$_iter__52644.call(null,cljs.core.chunk_rest.call(null,s__52645__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52647),null);
}
} else {
var x = cljs.core.first.call(null,s__52645__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list52639_$_iter__52644.call(null,cljs.core.rest.call(null,s__52645__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list52639);
/**
 * Create an image element.
 */
sablono.core.image52649 = (function sablono$core$image52649(var_args){
var args52650 = [];
var len__10640__auto___52653 = arguments.length;
var i__10641__auto___52654 = (0);
while(true){
if((i__10641__auto___52654 < len__10640__auto___52653)){
args52650.push((arguments[i__10641__auto___52654]));

var G__52655 = (i__10641__auto___52654 + (1));
i__10641__auto___52654 = G__52655;
continue;
} else {
}
break;
}

var G__52652 = args52650.length;
switch (G__52652) {
case 1:
return sablono.core.image52649.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image52649.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52650.length)].join('')));

}
});

sablono.core.image52649.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image52649.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image52649.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image52649);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__52657_SHARP_,p2__52658_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__52657_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("["),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__52658_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__52659_SHARP_,p2__52660_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__52659_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__52660_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field52661 = (function sablono$core$color_field52661(var_args){
var args52662 = [];
var len__10640__auto___52729 = arguments.length;
var i__10641__auto___52730 = (0);
while(true){
if((i__10641__auto___52730 < len__10640__auto___52729)){
args52662.push((arguments[i__10641__auto___52730]));

var G__52731 = (i__10641__auto___52730 + (1));
i__10641__auto___52730 = G__52731;
continue;
} else {
}
break;
}

var G__52664 = args52662.length;
switch (G__52664) {
case 1:
return sablono.core.color_field52661.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field52661.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52662.length)].join('')));

}
});

sablono.core.color_field52661.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.color_field52661.call(null,name__30665__auto__,null);
});

sablono.core.color_field52661.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.color_field52661.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field52661);

/**
 * Creates a date input field.
 */
sablono.core.date_field52665 = (function sablono$core$date_field52665(var_args){
var args52666 = [];
var len__10640__auto___52733 = arguments.length;
var i__10641__auto___52734 = (0);
while(true){
if((i__10641__auto___52734 < len__10640__auto___52733)){
args52666.push((arguments[i__10641__auto___52734]));

var G__52735 = (i__10641__auto___52734 + (1));
i__10641__auto___52734 = G__52735;
continue;
} else {
}
break;
}

var G__52668 = args52666.length;
switch (G__52668) {
case 1:
return sablono.core.date_field52665.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field52665.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52666.length)].join('')));

}
});

sablono.core.date_field52665.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.date_field52665.call(null,name__30665__auto__,null);
});

sablono.core.date_field52665.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.date_field52665.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field52665);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field52669 = (function sablono$core$datetime_field52669(var_args){
var args52670 = [];
var len__10640__auto___52737 = arguments.length;
var i__10641__auto___52738 = (0);
while(true){
if((i__10641__auto___52738 < len__10640__auto___52737)){
args52670.push((arguments[i__10641__auto___52738]));

var G__52739 = (i__10641__auto___52738 + (1));
i__10641__auto___52738 = G__52739;
continue;
} else {
}
break;
}

var G__52672 = args52670.length;
switch (G__52672) {
case 1:
return sablono.core.datetime_field52669.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field52669.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52670.length)].join('')));

}
});

sablono.core.datetime_field52669.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.datetime_field52669.call(null,name__30665__auto__,null);
});

sablono.core.datetime_field52669.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.datetime_field52669.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field52669);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field52673 = (function sablono$core$datetime_local_field52673(var_args){
var args52674 = [];
var len__10640__auto___52741 = arguments.length;
var i__10641__auto___52742 = (0);
while(true){
if((i__10641__auto___52742 < len__10640__auto___52741)){
args52674.push((arguments[i__10641__auto___52742]));

var G__52743 = (i__10641__auto___52742 + (1));
i__10641__auto___52742 = G__52743;
continue;
} else {
}
break;
}

var G__52676 = args52674.length;
switch (G__52676) {
case 1:
return sablono.core.datetime_local_field52673.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field52673.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52674.length)].join('')));

}
});

sablono.core.datetime_local_field52673.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.datetime_local_field52673.call(null,name__30665__auto__,null);
});

sablono.core.datetime_local_field52673.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.datetime_local_field52673.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field52673);

/**
 * Creates a email input field.
 */
sablono.core.email_field52677 = (function sablono$core$email_field52677(var_args){
var args52678 = [];
var len__10640__auto___52745 = arguments.length;
var i__10641__auto___52746 = (0);
while(true){
if((i__10641__auto___52746 < len__10640__auto___52745)){
args52678.push((arguments[i__10641__auto___52746]));

var G__52747 = (i__10641__auto___52746 + (1));
i__10641__auto___52746 = G__52747;
continue;
} else {
}
break;
}

var G__52680 = args52678.length;
switch (G__52680) {
case 1:
return sablono.core.email_field52677.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field52677.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52678.length)].join('')));

}
});

sablono.core.email_field52677.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.email_field52677.call(null,name__30665__auto__,null);
});

sablono.core.email_field52677.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.email_field52677.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field52677);

/**
 * Creates a file input field.
 */
sablono.core.file_field52681 = (function sablono$core$file_field52681(var_args){
var args52682 = [];
var len__10640__auto___52749 = arguments.length;
var i__10641__auto___52750 = (0);
while(true){
if((i__10641__auto___52750 < len__10640__auto___52749)){
args52682.push((arguments[i__10641__auto___52750]));

var G__52751 = (i__10641__auto___52750 + (1));
i__10641__auto___52750 = G__52751;
continue;
} else {
}
break;
}

var G__52684 = args52682.length;
switch (G__52684) {
case 1:
return sablono.core.file_field52681.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field52681.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52682.length)].join('')));

}
});

sablono.core.file_field52681.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.file_field52681.call(null,name__30665__auto__,null);
});

sablono.core.file_field52681.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.file_field52681.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field52681);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field52685 = (function sablono$core$hidden_field52685(var_args){
var args52686 = [];
var len__10640__auto___52753 = arguments.length;
var i__10641__auto___52754 = (0);
while(true){
if((i__10641__auto___52754 < len__10640__auto___52753)){
args52686.push((arguments[i__10641__auto___52754]));

var G__52755 = (i__10641__auto___52754 + (1));
i__10641__auto___52754 = G__52755;
continue;
} else {
}
break;
}

var G__52688 = args52686.length;
switch (G__52688) {
case 1:
return sablono.core.hidden_field52685.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field52685.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52686.length)].join('')));

}
});

sablono.core.hidden_field52685.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.hidden_field52685.call(null,name__30665__auto__,null);
});

sablono.core.hidden_field52685.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.hidden_field52685.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field52685);

/**
 * Creates a month input field.
 */
sablono.core.month_field52689 = (function sablono$core$month_field52689(var_args){
var args52690 = [];
var len__10640__auto___52757 = arguments.length;
var i__10641__auto___52758 = (0);
while(true){
if((i__10641__auto___52758 < len__10640__auto___52757)){
args52690.push((arguments[i__10641__auto___52758]));

var G__52759 = (i__10641__auto___52758 + (1));
i__10641__auto___52758 = G__52759;
continue;
} else {
}
break;
}

var G__52692 = args52690.length;
switch (G__52692) {
case 1:
return sablono.core.month_field52689.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field52689.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52690.length)].join('')));

}
});

sablono.core.month_field52689.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.month_field52689.call(null,name__30665__auto__,null);
});

sablono.core.month_field52689.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.month_field52689.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field52689);

/**
 * Creates a number input field.
 */
sablono.core.number_field52693 = (function sablono$core$number_field52693(var_args){
var args52694 = [];
var len__10640__auto___52761 = arguments.length;
var i__10641__auto___52762 = (0);
while(true){
if((i__10641__auto___52762 < len__10640__auto___52761)){
args52694.push((arguments[i__10641__auto___52762]));

var G__52763 = (i__10641__auto___52762 + (1));
i__10641__auto___52762 = G__52763;
continue;
} else {
}
break;
}

var G__52696 = args52694.length;
switch (G__52696) {
case 1:
return sablono.core.number_field52693.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field52693.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52694.length)].join('')));

}
});

sablono.core.number_field52693.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.number_field52693.call(null,name__30665__auto__,null);
});

sablono.core.number_field52693.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.number_field52693.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field52693);

/**
 * Creates a password input field.
 */
sablono.core.password_field52697 = (function sablono$core$password_field52697(var_args){
var args52698 = [];
var len__10640__auto___52765 = arguments.length;
var i__10641__auto___52766 = (0);
while(true){
if((i__10641__auto___52766 < len__10640__auto___52765)){
args52698.push((arguments[i__10641__auto___52766]));

var G__52767 = (i__10641__auto___52766 + (1));
i__10641__auto___52766 = G__52767;
continue;
} else {
}
break;
}

var G__52700 = args52698.length;
switch (G__52700) {
case 1:
return sablono.core.password_field52697.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field52697.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52698.length)].join('')));

}
});

sablono.core.password_field52697.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.password_field52697.call(null,name__30665__auto__,null);
});

sablono.core.password_field52697.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.password_field52697.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field52697);

/**
 * Creates a range input field.
 */
sablono.core.range_field52701 = (function sablono$core$range_field52701(var_args){
var args52702 = [];
var len__10640__auto___52769 = arguments.length;
var i__10641__auto___52770 = (0);
while(true){
if((i__10641__auto___52770 < len__10640__auto___52769)){
args52702.push((arguments[i__10641__auto___52770]));

var G__52771 = (i__10641__auto___52770 + (1));
i__10641__auto___52770 = G__52771;
continue;
} else {
}
break;
}

var G__52704 = args52702.length;
switch (G__52704) {
case 1:
return sablono.core.range_field52701.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field52701.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52702.length)].join('')));

}
});

sablono.core.range_field52701.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.range_field52701.call(null,name__30665__auto__,null);
});

sablono.core.range_field52701.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.range_field52701.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field52701);

/**
 * Creates a search input field.
 */
sablono.core.search_field52705 = (function sablono$core$search_field52705(var_args){
var args52706 = [];
var len__10640__auto___52773 = arguments.length;
var i__10641__auto___52774 = (0);
while(true){
if((i__10641__auto___52774 < len__10640__auto___52773)){
args52706.push((arguments[i__10641__auto___52774]));

var G__52775 = (i__10641__auto___52774 + (1));
i__10641__auto___52774 = G__52775;
continue;
} else {
}
break;
}

var G__52708 = args52706.length;
switch (G__52708) {
case 1:
return sablono.core.search_field52705.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field52705.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52706.length)].join('')));

}
});

sablono.core.search_field52705.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.search_field52705.call(null,name__30665__auto__,null);
});

sablono.core.search_field52705.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.search_field52705.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field52705);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field52709 = (function sablono$core$tel_field52709(var_args){
var args52710 = [];
var len__10640__auto___52777 = arguments.length;
var i__10641__auto___52778 = (0);
while(true){
if((i__10641__auto___52778 < len__10640__auto___52777)){
args52710.push((arguments[i__10641__auto___52778]));

var G__52779 = (i__10641__auto___52778 + (1));
i__10641__auto___52778 = G__52779;
continue;
} else {
}
break;
}

var G__52712 = args52710.length;
switch (G__52712) {
case 1:
return sablono.core.tel_field52709.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field52709.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52710.length)].join('')));

}
});

sablono.core.tel_field52709.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.tel_field52709.call(null,name__30665__auto__,null);
});

sablono.core.tel_field52709.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.tel_field52709.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field52709);

/**
 * Creates a text input field.
 */
sablono.core.text_field52713 = (function sablono$core$text_field52713(var_args){
var args52714 = [];
var len__10640__auto___52781 = arguments.length;
var i__10641__auto___52782 = (0);
while(true){
if((i__10641__auto___52782 < len__10640__auto___52781)){
args52714.push((arguments[i__10641__auto___52782]));

var G__52783 = (i__10641__auto___52782 + (1));
i__10641__auto___52782 = G__52783;
continue;
} else {
}
break;
}

var G__52716 = args52714.length;
switch (G__52716) {
case 1:
return sablono.core.text_field52713.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field52713.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52714.length)].join('')));

}
});

sablono.core.text_field52713.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.text_field52713.call(null,name__30665__auto__,null);
});

sablono.core.text_field52713.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.text_field52713.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field52713);

/**
 * Creates a time input field.
 */
sablono.core.time_field52717 = (function sablono$core$time_field52717(var_args){
var args52718 = [];
var len__10640__auto___52785 = arguments.length;
var i__10641__auto___52786 = (0);
while(true){
if((i__10641__auto___52786 < len__10640__auto___52785)){
args52718.push((arguments[i__10641__auto___52786]));

var G__52787 = (i__10641__auto___52786 + (1));
i__10641__auto___52786 = G__52787;
continue;
} else {
}
break;
}

var G__52720 = args52718.length;
switch (G__52720) {
case 1:
return sablono.core.time_field52717.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field52717.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52718.length)].join('')));

}
});

sablono.core.time_field52717.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.time_field52717.call(null,name__30665__auto__,null);
});

sablono.core.time_field52717.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.time_field52717.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field52717);

/**
 * Creates a url input field.
 */
sablono.core.url_field52721 = (function sablono$core$url_field52721(var_args){
var args52722 = [];
var len__10640__auto___52789 = arguments.length;
var i__10641__auto___52790 = (0);
while(true){
if((i__10641__auto___52790 < len__10640__auto___52789)){
args52722.push((arguments[i__10641__auto___52790]));

var G__52791 = (i__10641__auto___52790 + (1));
i__10641__auto___52790 = G__52791;
continue;
} else {
}
break;
}

var G__52724 = args52722.length;
switch (G__52724) {
case 1:
return sablono.core.url_field52721.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field52721.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52722.length)].join('')));

}
});

sablono.core.url_field52721.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.url_field52721.call(null,name__30665__auto__,null);
});

sablono.core.url_field52721.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.url_field52721.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field52721);

/**
 * Creates a week input field.
 */
sablono.core.week_field52725 = (function sablono$core$week_field52725(var_args){
var args52726 = [];
var len__10640__auto___52793 = arguments.length;
var i__10641__auto___52794 = (0);
while(true){
if((i__10641__auto___52794 < len__10640__auto___52793)){
args52726.push((arguments[i__10641__auto___52794]));

var G__52795 = (i__10641__auto___52794 + (1));
i__10641__auto___52794 = G__52795;
continue;
} else {
}
break;
}

var G__52728 = args52726.length;
switch (G__52728) {
case 1:
return sablono.core.week_field52725.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field52725.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52726.length)].join('')));

}
});

sablono.core.week_field52725.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.week_field52725.call(null,name__30665__auto__,null);
});

sablono.core.week_field52725.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.week_field52725.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field52725);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box52797 = (function sablono$core$check_box52797(var_args){
var args52798 = [];
var len__10640__auto___52801 = arguments.length;
var i__10641__auto___52802 = (0);
while(true){
if((i__10641__auto___52802 < len__10640__auto___52801)){
args52798.push((arguments[i__10641__auto___52802]));

var G__52803 = (i__10641__auto___52802 + (1));
i__10641__auto___52802 = G__52803;
continue;
} else {
}
break;
}

var G__52800 = args52798.length;
switch (G__52800) {
case 1:
return sablono.core.check_box52797.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box52797.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box52797.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52798.length)].join('')));

}
});

sablono.core.check_box52797.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box52797.call(null,name,null);
});

sablono.core.check_box52797.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box52797.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box52797.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box52797.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box52797);
/**
 * Creates a radio button.
 */
sablono.core.radio_button52805 = (function sablono$core$radio_button52805(var_args){
var args52806 = [];
var len__10640__auto___52809 = arguments.length;
var i__10641__auto___52810 = (0);
while(true){
if((i__10641__auto___52810 < len__10640__auto___52809)){
args52806.push((arguments[i__10641__auto___52810]));

var G__52811 = (i__10641__auto___52810 + (1));
i__10641__auto___52810 = G__52811;
continue;
} else {
}
break;
}

var G__52808 = args52806.length;
switch (G__52808) {
case 1:
return sablono.core.radio_button52805.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button52805.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button52805.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52806.length)].join('')));

}
});

sablono.core.radio_button52805.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button52805.call(null,group,null);
});

sablono.core.radio_button52805.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button52805.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button52805.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button52805.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button52805);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options52813 = (function sablono$core$select_options52813(coll){
var iter__10281__auto__ = (function sablono$core$select_options52813_$_iter__52830(s__52831){
return (new cljs.core.LazySeq(null,(function (){
var s__52831__$1 = s__52831;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__52831__$1);
if(temp__6738__auto__){
var s__52831__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__52831__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__52831__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__52833 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__52832 = (0);
while(true){
if((i__52832 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__52832);
cljs.core.chunk_append.call(null,b__52833,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__52840 = x;
var text = cljs.core.nth.call(null,vec__52840,(0),null);
var val = cljs.core.nth.call(null,vec__52840,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__52840,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options52813.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__52846 = (i__52832 + (1));
i__52832 = G__52846;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52833),sablono$core$select_options52813_$_iter__52830.call(null,cljs.core.chunk_rest.call(null,s__52831__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52833),null);
}
} else {
var x = cljs.core.first.call(null,s__52831__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__52843 = x;
var text = cljs.core.nth.call(null,vec__52843,(0),null);
var val = cljs.core.nth.call(null,vec__52843,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__52843,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options52813.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options52813_$_iter__52830.call(null,cljs.core.rest.call(null,s__52831__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options52813);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down52847 = (function sablono$core$drop_down52847(var_args){
var args52848 = [];
var len__10640__auto___52851 = arguments.length;
var i__10641__auto___52852 = (0);
while(true){
if((i__10641__auto___52852 < len__10640__auto___52851)){
args52848.push((arguments[i__10641__auto___52852]));

var G__52853 = (i__10641__auto___52852 + (1));
i__10641__auto___52852 = G__52853;
continue;
} else {
}
break;
}

var G__52850 = args52848.length;
switch (G__52850) {
case 2:
return sablono.core.drop_down52847.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down52847.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52848.length)].join('')));

}
});

sablono.core.drop_down52847.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down52847.call(null,name,options,null);
});

sablono.core.drop_down52847.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down52847.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down52847);
/**
 * Creates a text area element.
 */
sablono.core.text_area52855 = (function sablono$core$text_area52855(var_args){
var args52856 = [];
var len__10640__auto___52859 = arguments.length;
var i__10641__auto___52860 = (0);
while(true){
if((i__10641__auto___52860 < len__10640__auto___52859)){
args52856.push((arguments[i__10641__auto___52860]));

var G__52861 = (i__10641__auto___52860 + (1));
i__10641__auto___52860 = G__52861;
continue;
} else {
}
break;
}

var G__52858 = args52856.length;
switch (G__52858) {
case 1:
return sablono.core.text_area52855.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area52855.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52856.length)].join('')));

}
});

sablono.core.text_area52855.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area52855.call(null,name,null);
});

sablono.core.text_area52855.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area52855.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area52855);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label52863 = (function sablono$core$label52863(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label52863);
/**
 * Creates a submit button.
 */
sablono.core.submit_button52864 = (function sablono$core$submit_button52864(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button52864);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button52865 = (function sablono$core$reset_button52865(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button52865);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to52866 = (function sablono$core$form_to52866(var_args){
var args__10647__auto__ = [];
var len__10640__auto___52873 = arguments.length;
var i__10641__auto___52874 = (0);
while(true){
if((i__10641__auto___52874 < len__10640__auto___52873)){
args__10647__auto__.push((arguments[i__10641__auto___52874]));

var G__52875 = (i__10641__auto___52874 + (1));
i__10641__auto___52874 = G__52875;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to52866.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.form_to52866.cljs$core$IFn$_invoke$arity$variadic = (function (p__52869,body){
var vec__52870 = p__52869;
var method = cljs.core.nth.call(null,vec__52870,(0),null);
var action = cljs.core.nth.call(null,vec__52870,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to52866.cljs$lang$maxFixedArity = (1);

sablono.core.form_to52866.cljs$lang$applyTo = (function (seq52867){
var G__52868 = cljs.core.first.call(null,seq52867);
var seq52867__$1 = cljs.core.next.call(null,seq52867);
return sablono.core.form_to52866.cljs$core$IFn$_invoke$arity$variadic(G__52868,seq52867__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to52866);

//# sourceMappingURL=core.js.map