// Compiled by ClojureScript 1.9.521 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (hasch.benc._coerce[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__10138__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__64787_64791 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__64788_64792 = null;
var count__64789_64793 = (0);
var i__64790_64794 = (0);
while(true){
if((i__64790_64794 < count__64789_64793)){
var bs_64795 = cljs.core._nth.call(null,chunk__64788_64792,i__64790_64794);
md.update(bs_64795);

var G__64796 = seq__64787_64791;
var G__64797 = chunk__64788_64792;
var G__64798 = count__64789_64793;
var G__64799 = (i__64790_64794 + (1));
seq__64787_64791 = G__64796;
chunk__64788_64792 = G__64797;
count__64789_64793 = G__64798;
i__64790_64794 = G__64799;
continue;
} else {
var temp__6738__auto___64800 = cljs.core.seq.call(null,seq__64787_64791);
if(temp__6738__auto___64800){
var seq__64787_64801__$1 = temp__6738__auto___64800;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__64787_64801__$1)){
var c__10330__auto___64802 = cljs.core.chunk_first.call(null,seq__64787_64801__$1);
var G__64803 = cljs.core.chunk_rest.call(null,seq__64787_64801__$1);
var G__64804 = c__10330__auto___64802;
var G__64805 = cljs.core.count.call(null,c__10330__auto___64802);
var G__64806 = (0);
seq__64787_64791 = G__64803;
chunk__64788_64792 = G__64804;
count__64789_64793 = G__64805;
i__64790_64794 = G__64806;
continue;
} else {
var bs_64807 = cljs.core.first.call(null,seq__64787_64801__$1);
md.update(bs_64807);

var G__64808 = cljs.core.next.call(null,seq__64787_64801__$1);
var G__64809 = null;
var G__64810 = (0);
var G__64811 = (0);
seq__64787_64791 = G__64808;
chunk__64788_64792 = G__64809;
count__64789_64793 = G__64810;
i__64790_64794 = G__64811;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_64818 = seq;
while(true){
var vec__64815_64819 = s_64818;
var seq__64816_64820 = cljs.core.seq.call(null,vec__64815_64819);
var first__64817_64821 = cljs.core.first.call(null,seq__64816_64820);
var seq__64816_64822__$1 = cljs.core.next.call(null,seq__64816_64820);
var f_64823 = first__64817_64821;
var r_64824 = seq__64816_64822__$1;
seq_md.update(hasch.benc._coerce.call(null,f_64823,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_64824)){
} else {
var G__64825 = cljs.core.rest.call(null,s_64818);
s_64818 = G__64825;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__9764__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__9765__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__9764__auto__ < y__9765__auto__) ? x__9764__auto__ : y__9765__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_64826 = (0);
while(true){
if((i_64826 < len)){
(acc[i_64826] = ((acc[i_64826]) ^ (elem[i_64826])));

var G__64827 = (i_64826 + (1));
i_64826 = G__64827;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_64828 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_64828,len)){
} else {
var e_64829 = (a[i_64828]);
if(((e_64829 > (0))) && ((e_64829 < (30)))){
(ea[i_64828] = (1));
} else {
}

var G__64830 = (i_64828 + (1));
i_64828 = G__64830;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});

//# sourceMappingURL=benc.js.map