(ns budb.helpers
  (:require [taoensso.timbre :as log :include-macros true]))

;; Maths

(defn shift< [x n]
  (loop [x x n n]
    (if (zero? n) x (recur #?(:clj (*' 2 x) :cljs (* 2 x)) (dec n)))))


;; Id Tools

(defn concat-ints [& size-value-tuples]
  ;; TODO: need a size check somewhere (value overflows size)
  (loop [acc 0 [size value] (first size-value-tuples) then (rest size-value-tuples)]
    (if (nil? size)
      acc
      (recur
        #?(:clj  (+' (if (zero? acc) acc (shift< acc size)) value)
           :cljs (+ (if (zero? acc) acc (shift< acc size)) value))
        (first then) (rest then)))))

(defn random-id [id-size]
  (rand-int (shift< 2 id-size)))


;; Time

(defn now []
  #?(:clj
     (System/currentTimeMillis)
     :cljs
     (.getTime (js/Date.))))


;; Unique ID

(def t-size 50)
(def id-size 20)

;; TODO: deal with multiple call during the same ms
;; -> Use a local inc

(defn with-suffix-id [x suffix-id]
  (concat-ints [nil x] [id-size suffix-id]))

(defn time-ordered-unique-id
  ([]
   (time-ordered-unique-id (random-id id-size)))
  ([suffix-id]
   (concat-ints [t-size (now)] [id-size suffix-id])))

