// Compiled by ClojureScript 1.9.521 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__70940__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__70937 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__70938 = cljs.core.seq.call(null,vec__70937);
var first__70939 = cljs.core.first.call(null,seq__70938);
var seq__70938__$1 = cljs.core.next.call(null,seq__70938);
var tag = first__70939;
var body = seq__70938__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__70940 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__70941__i = 0, G__70941__a = new Array(arguments.length -  0);
while (G__70941__i < G__70941__a.length) {G__70941__a[G__70941__i] = arguments[G__70941__i + 0]; ++G__70941__i;}
  args = new cljs.core.IndexedSeq(G__70941__a,0);
} 
return G__70940__delegate.call(this,args);};
G__70940.cljs$lang$maxFixedArity = 0;
G__70940.cljs$lang$applyTo = (function (arglist__70942){
var args = cljs.core.seq(arglist__70942);
return G__70940__delegate(args);
});
G__70940.cljs$core$IFn$_invoke$arity$variadic = G__70940__delegate;
return G__70940;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__10281__auto__ = (function sablono$core$update_arglists_$_iter__70947(s__70948){
return (new cljs.core.LazySeq(null,(function (){
var s__70948__$1 = s__70948;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__70948__$1);
if(temp__6738__auto__){
var s__70948__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__70948__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__70948__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__70950 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__70949 = (0);
while(true){
if((i__70949 < size__10280__auto__)){
var args = cljs.core._nth.call(null,c__10279__auto__,i__70949);
cljs.core.chunk_append.call(null,b__70950,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__70951 = (i__70949 + (1));
i__70949 = G__70951;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70950),sablono$core$update_arglists_$_iter__70947.call(null,cljs.core.chunk_rest.call(null,s__70948__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70950),null);
}
} else {
var args = cljs.core.first.call(null,s__70948__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__70947.call(null,cljs.core.rest.call(null,s__70948__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__10647__auto__ = [];
var len__10640__auto___70957 = arguments.length;
var i__10641__auto___70958 = (0);
while(true){
if((i__10641__auto___70958 < len__10640__auto___70957)){
args__10647__auto__.push((arguments[i__10641__auto___70958]));

var G__70959 = (i__10641__auto___70958 + (1));
i__10641__auto___70958 = G__70959;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((0) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__10648__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__10281__auto__ = (function sablono$core$iter__70953(s__70954){
return (new cljs.core.LazySeq(null,(function (){
var s__70954__$1 = s__70954;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__70954__$1);
if(temp__6738__auto__){
var s__70954__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__70954__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__70954__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__70956 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__70955 = (0);
while(true){
if((i__70955 < size__10280__auto__)){
var style = cljs.core._nth.call(null,c__10279__auto__,i__70955);
cljs.core.chunk_append.call(null,b__70956,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__70960 = (i__70955 + (1));
i__70955 = G__70960;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70956),sablono$core$iter__70953.call(null,cljs.core.chunk_rest.call(null,s__70954__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70956),null);
}
} else {
var style = cljs.core.first.call(null,s__70954__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__70953.call(null,cljs.core.rest.call(null,s__70954__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq70952){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq70952));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to70961 = (function sablono$core$link_to70961(var_args){
var args__10647__auto__ = [];
var len__10640__auto___70964 = arguments.length;
var i__10641__auto___70965 = (0);
while(true){
if((i__10641__auto___70965 < len__10640__auto___70964)){
args__10647__auto__.push((arguments[i__10641__auto___70965]));

var G__70966 = (i__10641__auto___70965 + (1));
i__10641__auto___70965 = G__70966;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to70961.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.link_to70961.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to70961.cljs$lang$maxFixedArity = (1);

sablono.core.link_to70961.cljs$lang$applyTo = (function (seq70962){
var G__70963 = cljs.core.first.call(null,seq70962);
var seq70962__$1 = cljs.core.next.call(null,seq70962);
return sablono.core.link_to70961.cljs$core$IFn$_invoke$arity$variadic(G__70963,seq70962__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to70961);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to70967 = (function sablono$core$mail_to70967(var_args){
var args__10647__auto__ = [];
var len__10640__auto___70974 = arguments.length;
var i__10641__auto___70975 = (0);
while(true){
if((i__10641__auto___70975 < len__10640__auto___70974)){
args__10647__auto__.push((arguments[i__10641__auto___70975]));

var G__70976 = (i__10641__auto___70975 + (1));
i__10641__auto___70975 = G__70976;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to70967.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.mail_to70967.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__70970){
var vec__70971 = p__70970;
var content = cljs.core.nth.call(null,vec__70971,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("mailto:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__9419__auto__ = content;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to70967.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to70967.cljs$lang$applyTo = (function (seq70968){
var G__70969 = cljs.core.first.call(null,seq70968);
var seq70968__$1 = cljs.core.next.call(null,seq70968);
return sablono.core.mail_to70967.cljs$core$IFn$_invoke$arity$variadic(G__70969,seq70968__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to70967);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list70977 = (function sablono$core$unordered_list70977(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__10281__auto__ = (function sablono$core$unordered_list70977_$_iter__70982(s__70983){
return (new cljs.core.LazySeq(null,(function (){
var s__70983__$1 = s__70983;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__70983__$1);
if(temp__6738__auto__){
var s__70983__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__70983__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__70983__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__70985 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__70984 = (0);
while(true){
if((i__70984 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__70984);
cljs.core.chunk_append.call(null,b__70985,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__70986 = (i__70984 + (1));
i__70984 = G__70986;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70985),sablono$core$unordered_list70977_$_iter__70982.call(null,cljs.core.chunk_rest.call(null,s__70983__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70985),null);
}
} else {
var x = cljs.core.first.call(null,s__70983__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list70977_$_iter__70982.call(null,cljs.core.rest.call(null,s__70983__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list70977);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list70987 = (function sablono$core$ordered_list70987(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__10281__auto__ = (function sablono$core$ordered_list70987_$_iter__70992(s__70993){
return (new cljs.core.LazySeq(null,(function (){
var s__70993__$1 = s__70993;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__70993__$1);
if(temp__6738__auto__){
var s__70993__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__70993__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__70993__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__70995 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__70994 = (0);
while(true){
if((i__70994 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__70994);
cljs.core.chunk_append.call(null,b__70995,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__70996 = (i__70994 + (1));
i__70994 = G__70996;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70995),sablono$core$ordered_list70987_$_iter__70992.call(null,cljs.core.chunk_rest.call(null,s__70993__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70995),null);
}
} else {
var x = cljs.core.first.call(null,s__70993__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list70987_$_iter__70992.call(null,cljs.core.rest.call(null,s__70993__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list70987);
/**
 * Create an image element.
 */
sablono.core.image70997 = (function sablono$core$image70997(var_args){
var args70998 = [];
var len__10640__auto___71001 = arguments.length;
var i__10641__auto___71002 = (0);
while(true){
if((i__10641__auto___71002 < len__10640__auto___71001)){
args70998.push((arguments[i__10641__auto___71002]));

var G__71003 = (i__10641__auto___71002 + (1));
i__10641__auto___71002 = G__71003;
continue;
} else {
}
break;
}

var G__71000 = args70998.length;
switch (G__71000) {
case 1:
return sablono.core.image70997.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image70997.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70998.length)].join('')));

}
});

sablono.core.image70997.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image70997.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image70997.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image70997);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__71005_SHARP_,p2__71006_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__71005_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("["),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__71006_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__71007_SHARP_,p2__71008_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__71007_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__71008_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field71009 = (function sablono$core$color_field71009(var_args){
var args71010 = [];
var len__10640__auto___71077 = arguments.length;
var i__10641__auto___71078 = (0);
while(true){
if((i__10641__auto___71078 < len__10640__auto___71077)){
args71010.push((arguments[i__10641__auto___71078]));

var G__71079 = (i__10641__auto___71078 + (1));
i__10641__auto___71078 = G__71079;
continue;
} else {
}
break;
}

var G__71012 = args71010.length;
switch (G__71012) {
case 1:
return sablono.core.color_field71009.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field71009.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71010.length)].join('')));

}
});

sablono.core.color_field71009.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.color_field71009.call(null,name__30665__auto__,null);
});

sablono.core.color_field71009.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.color_field71009.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field71009);

/**
 * Creates a date input field.
 */
sablono.core.date_field71013 = (function sablono$core$date_field71013(var_args){
var args71014 = [];
var len__10640__auto___71081 = arguments.length;
var i__10641__auto___71082 = (0);
while(true){
if((i__10641__auto___71082 < len__10640__auto___71081)){
args71014.push((arguments[i__10641__auto___71082]));

var G__71083 = (i__10641__auto___71082 + (1));
i__10641__auto___71082 = G__71083;
continue;
} else {
}
break;
}

var G__71016 = args71014.length;
switch (G__71016) {
case 1:
return sablono.core.date_field71013.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field71013.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71014.length)].join('')));

}
});

sablono.core.date_field71013.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.date_field71013.call(null,name__30665__auto__,null);
});

sablono.core.date_field71013.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.date_field71013.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field71013);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field71017 = (function sablono$core$datetime_field71017(var_args){
var args71018 = [];
var len__10640__auto___71085 = arguments.length;
var i__10641__auto___71086 = (0);
while(true){
if((i__10641__auto___71086 < len__10640__auto___71085)){
args71018.push((arguments[i__10641__auto___71086]));

var G__71087 = (i__10641__auto___71086 + (1));
i__10641__auto___71086 = G__71087;
continue;
} else {
}
break;
}

var G__71020 = args71018.length;
switch (G__71020) {
case 1:
return sablono.core.datetime_field71017.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field71017.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71018.length)].join('')));

}
});

sablono.core.datetime_field71017.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.datetime_field71017.call(null,name__30665__auto__,null);
});

sablono.core.datetime_field71017.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.datetime_field71017.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field71017);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field71021 = (function sablono$core$datetime_local_field71021(var_args){
var args71022 = [];
var len__10640__auto___71089 = arguments.length;
var i__10641__auto___71090 = (0);
while(true){
if((i__10641__auto___71090 < len__10640__auto___71089)){
args71022.push((arguments[i__10641__auto___71090]));

var G__71091 = (i__10641__auto___71090 + (1));
i__10641__auto___71090 = G__71091;
continue;
} else {
}
break;
}

var G__71024 = args71022.length;
switch (G__71024) {
case 1:
return sablono.core.datetime_local_field71021.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field71021.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71022.length)].join('')));

}
});

sablono.core.datetime_local_field71021.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.datetime_local_field71021.call(null,name__30665__auto__,null);
});

sablono.core.datetime_local_field71021.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.datetime_local_field71021.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field71021);

/**
 * Creates a email input field.
 */
sablono.core.email_field71025 = (function sablono$core$email_field71025(var_args){
var args71026 = [];
var len__10640__auto___71093 = arguments.length;
var i__10641__auto___71094 = (0);
while(true){
if((i__10641__auto___71094 < len__10640__auto___71093)){
args71026.push((arguments[i__10641__auto___71094]));

var G__71095 = (i__10641__auto___71094 + (1));
i__10641__auto___71094 = G__71095;
continue;
} else {
}
break;
}

var G__71028 = args71026.length;
switch (G__71028) {
case 1:
return sablono.core.email_field71025.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field71025.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71026.length)].join('')));

}
});

sablono.core.email_field71025.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.email_field71025.call(null,name__30665__auto__,null);
});

sablono.core.email_field71025.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.email_field71025.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field71025);

/**
 * Creates a file input field.
 */
sablono.core.file_field71029 = (function sablono$core$file_field71029(var_args){
var args71030 = [];
var len__10640__auto___71097 = arguments.length;
var i__10641__auto___71098 = (0);
while(true){
if((i__10641__auto___71098 < len__10640__auto___71097)){
args71030.push((arguments[i__10641__auto___71098]));

var G__71099 = (i__10641__auto___71098 + (1));
i__10641__auto___71098 = G__71099;
continue;
} else {
}
break;
}

var G__71032 = args71030.length;
switch (G__71032) {
case 1:
return sablono.core.file_field71029.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field71029.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71030.length)].join('')));

}
});

sablono.core.file_field71029.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.file_field71029.call(null,name__30665__auto__,null);
});

sablono.core.file_field71029.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.file_field71029.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field71029);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field71033 = (function sablono$core$hidden_field71033(var_args){
var args71034 = [];
var len__10640__auto___71101 = arguments.length;
var i__10641__auto___71102 = (0);
while(true){
if((i__10641__auto___71102 < len__10640__auto___71101)){
args71034.push((arguments[i__10641__auto___71102]));

var G__71103 = (i__10641__auto___71102 + (1));
i__10641__auto___71102 = G__71103;
continue;
} else {
}
break;
}

var G__71036 = args71034.length;
switch (G__71036) {
case 1:
return sablono.core.hidden_field71033.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field71033.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71034.length)].join('')));

}
});

sablono.core.hidden_field71033.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.hidden_field71033.call(null,name__30665__auto__,null);
});

sablono.core.hidden_field71033.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.hidden_field71033.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field71033);

/**
 * Creates a month input field.
 */
sablono.core.month_field71037 = (function sablono$core$month_field71037(var_args){
var args71038 = [];
var len__10640__auto___71105 = arguments.length;
var i__10641__auto___71106 = (0);
while(true){
if((i__10641__auto___71106 < len__10640__auto___71105)){
args71038.push((arguments[i__10641__auto___71106]));

var G__71107 = (i__10641__auto___71106 + (1));
i__10641__auto___71106 = G__71107;
continue;
} else {
}
break;
}

var G__71040 = args71038.length;
switch (G__71040) {
case 1:
return sablono.core.month_field71037.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field71037.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71038.length)].join('')));

}
});

sablono.core.month_field71037.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.month_field71037.call(null,name__30665__auto__,null);
});

sablono.core.month_field71037.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.month_field71037.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field71037);

/**
 * Creates a number input field.
 */
sablono.core.number_field71041 = (function sablono$core$number_field71041(var_args){
var args71042 = [];
var len__10640__auto___71109 = arguments.length;
var i__10641__auto___71110 = (0);
while(true){
if((i__10641__auto___71110 < len__10640__auto___71109)){
args71042.push((arguments[i__10641__auto___71110]));

var G__71111 = (i__10641__auto___71110 + (1));
i__10641__auto___71110 = G__71111;
continue;
} else {
}
break;
}

var G__71044 = args71042.length;
switch (G__71044) {
case 1:
return sablono.core.number_field71041.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field71041.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71042.length)].join('')));

}
});

sablono.core.number_field71041.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.number_field71041.call(null,name__30665__auto__,null);
});

sablono.core.number_field71041.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.number_field71041.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field71041);

/**
 * Creates a password input field.
 */
sablono.core.password_field71045 = (function sablono$core$password_field71045(var_args){
var args71046 = [];
var len__10640__auto___71113 = arguments.length;
var i__10641__auto___71114 = (0);
while(true){
if((i__10641__auto___71114 < len__10640__auto___71113)){
args71046.push((arguments[i__10641__auto___71114]));

var G__71115 = (i__10641__auto___71114 + (1));
i__10641__auto___71114 = G__71115;
continue;
} else {
}
break;
}

var G__71048 = args71046.length;
switch (G__71048) {
case 1:
return sablono.core.password_field71045.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field71045.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71046.length)].join('')));

}
});

sablono.core.password_field71045.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.password_field71045.call(null,name__30665__auto__,null);
});

sablono.core.password_field71045.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.password_field71045.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field71045);

/**
 * Creates a range input field.
 */
sablono.core.range_field71049 = (function sablono$core$range_field71049(var_args){
var args71050 = [];
var len__10640__auto___71117 = arguments.length;
var i__10641__auto___71118 = (0);
while(true){
if((i__10641__auto___71118 < len__10640__auto___71117)){
args71050.push((arguments[i__10641__auto___71118]));

var G__71119 = (i__10641__auto___71118 + (1));
i__10641__auto___71118 = G__71119;
continue;
} else {
}
break;
}

var G__71052 = args71050.length;
switch (G__71052) {
case 1:
return sablono.core.range_field71049.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field71049.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71050.length)].join('')));

}
});

sablono.core.range_field71049.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.range_field71049.call(null,name__30665__auto__,null);
});

sablono.core.range_field71049.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.range_field71049.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field71049);

/**
 * Creates a search input field.
 */
sablono.core.search_field71053 = (function sablono$core$search_field71053(var_args){
var args71054 = [];
var len__10640__auto___71121 = arguments.length;
var i__10641__auto___71122 = (0);
while(true){
if((i__10641__auto___71122 < len__10640__auto___71121)){
args71054.push((arguments[i__10641__auto___71122]));

var G__71123 = (i__10641__auto___71122 + (1));
i__10641__auto___71122 = G__71123;
continue;
} else {
}
break;
}

var G__71056 = args71054.length;
switch (G__71056) {
case 1:
return sablono.core.search_field71053.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field71053.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71054.length)].join('')));

}
});

sablono.core.search_field71053.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.search_field71053.call(null,name__30665__auto__,null);
});

sablono.core.search_field71053.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.search_field71053.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field71053);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field71057 = (function sablono$core$tel_field71057(var_args){
var args71058 = [];
var len__10640__auto___71125 = arguments.length;
var i__10641__auto___71126 = (0);
while(true){
if((i__10641__auto___71126 < len__10640__auto___71125)){
args71058.push((arguments[i__10641__auto___71126]));

var G__71127 = (i__10641__auto___71126 + (1));
i__10641__auto___71126 = G__71127;
continue;
} else {
}
break;
}

var G__71060 = args71058.length;
switch (G__71060) {
case 1:
return sablono.core.tel_field71057.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field71057.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71058.length)].join('')));

}
});

sablono.core.tel_field71057.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.tel_field71057.call(null,name__30665__auto__,null);
});

sablono.core.tel_field71057.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.tel_field71057.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field71057);

/**
 * Creates a text input field.
 */
sablono.core.text_field71061 = (function sablono$core$text_field71061(var_args){
var args71062 = [];
var len__10640__auto___71129 = arguments.length;
var i__10641__auto___71130 = (0);
while(true){
if((i__10641__auto___71130 < len__10640__auto___71129)){
args71062.push((arguments[i__10641__auto___71130]));

var G__71131 = (i__10641__auto___71130 + (1));
i__10641__auto___71130 = G__71131;
continue;
} else {
}
break;
}

var G__71064 = args71062.length;
switch (G__71064) {
case 1:
return sablono.core.text_field71061.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field71061.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71062.length)].join('')));

}
});

sablono.core.text_field71061.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.text_field71061.call(null,name__30665__auto__,null);
});

sablono.core.text_field71061.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.text_field71061.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field71061);

/**
 * Creates a time input field.
 */
sablono.core.time_field71065 = (function sablono$core$time_field71065(var_args){
var args71066 = [];
var len__10640__auto___71133 = arguments.length;
var i__10641__auto___71134 = (0);
while(true){
if((i__10641__auto___71134 < len__10640__auto___71133)){
args71066.push((arguments[i__10641__auto___71134]));

var G__71135 = (i__10641__auto___71134 + (1));
i__10641__auto___71134 = G__71135;
continue;
} else {
}
break;
}

var G__71068 = args71066.length;
switch (G__71068) {
case 1:
return sablono.core.time_field71065.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field71065.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71066.length)].join('')));

}
});

sablono.core.time_field71065.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.time_field71065.call(null,name__30665__auto__,null);
});

sablono.core.time_field71065.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.time_field71065.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field71065);

/**
 * Creates a url input field.
 */
sablono.core.url_field71069 = (function sablono$core$url_field71069(var_args){
var args71070 = [];
var len__10640__auto___71137 = arguments.length;
var i__10641__auto___71138 = (0);
while(true){
if((i__10641__auto___71138 < len__10640__auto___71137)){
args71070.push((arguments[i__10641__auto___71138]));

var G__71139 = (i__10641__auto___71138 + (1));
i__10641__auto___71138 = G__71139;
continue;
} else {
}
break;
}

var G__71072 = args71070.length;
switch (G__71072) {
case 1:
return sablono.core.url_field71069.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field71069.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71070.length)].join('')));

}
});

sablono.core.url_field71069.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.url_field71069.call(null,name__30665__auto__,null);
});

sablono.core.url_field71069.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.url_field71069.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field71069);

/**
 * Creates a week input field.
 */
sablono.core.week_field71073 = (function sablono$core$week_field71073(var_args){
var args71074 = [];
var len__10640__auto___71141 = arguments.length;
var i__10641__auto___71142 = (0);
while(true){
if((i__10641__auto___71142 < len__10640__auto___71141)){
args71074.push((arguments[i__10641__auto___71142]));

var G__71143 = (i__10641__auto___71142 + (1));
i__10641__auto___71142 = G__71143;
continue;
} else {
}
break;
}

var G__71076 = args71074.length;
switch (G__71076) {
case 1:
return sablono.core.week_field71073.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field71073.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71074.length)].join('')));

}
});

sablono.core.week_field71073.cljs$core$IFn$_invoke$arity$1 = (function (name__30665__auto__){
return sablono.core.week_field71073.call(null,name__30665__auto__,null);
});

sablono.core.week_field71073.cljs$core$IFn$_invoke$arity$2 = (function (name__30665__auto__,value__30666__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__30665__auto__,value__30666__auto__);
});

sablono.core.week_field71073.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field71073);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box71145 = (function sablono$core$check_box71145(var_args){
var args71146 = [];
var len__10640__auto___71149 = arguments.length;
var i__10641__auto___71150 = (0);
while(true){
if((i__10641__auto___71150 < len__10640__auto___71149)){
args71146.push((arguments[i__10641__auto___71150]));

var G__71151 = (i__10641__auto___71150 + (1));
i__10641__auto___71150 = G__71151;
continue;
} else {
}
break;
}

var G__71148 = args71146.length;
switch (G__71148) {
case 1:
return sablono.core.check_box71145.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box71145.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box71145.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71146.length)].join('')));

}
});

sablono.core.check_box71145.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box71145.call(null,name,null);
});

sablono.core.check_box71145.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box71145.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box71145.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box71145.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box71145);
/**
 * Creates a radio button.
 */
sablono.core.radio_button71153 = (function sablono$core$radio_button71153(var_args){
var args71154 = [];
var len__10640__auto___71157 = arguments.length;
var i__10641__auto___71158 = (0);
while(true){
if((i__10641__auto___71158 < len__10640__auto___71157)){
args71154.push((arguments[i__10641__auto___71158]));

var G__71159 = (i__10641__auto___71158 + (1));
i__10641__auto___71158 = G__71159;
continue;
} else {
}
break;
}

var G__71156 = args71154.length;
switch (G__71156) {
case 1:
return sablono.core.radio_button71153.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button71153.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button71153.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71154.length)].join('')));

}
});

sablono.core.radio_button71153.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button71153.call(null,group,null);
});

sablono.core.radio_button71153.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button71153.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button71153.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button71153.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button71153);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options71161 = (function sablono$core$select_options71161(coll){
var iter__10281__auto__ = (function sablono$core$select_options71161_$_iter__71178(s__71179){
return (new cljs.core.LazySeq(null,(function (){
var s__71179__$1 = s__71179;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__71179__$1);
if(temp__6738__auto__){
var s__71179__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__71179__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__71179__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__71181 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__71180 = (0);
while(true){
if((i__71180 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__71180);
cljs.core.chunk_append.call(null,b__71181,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__71188 = x;
var text = cljs.core.nth.call(null,vec__71188,(0),null);
var val = cljs.core.nth.call(null,vec__71188,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__71188,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options71161.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__71194 = (i__71180 + (1));
i__71180 = G__71194;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__71181),sablono$core$select_options71161_$_iter__71178.call(null,cljs.core.chunk_rest.call(null,s__71179__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__71181),null);
}
} else {
var x = cljs.core.first.call(null,s__71179__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__71191 = x;
var text = cljs.core.nth.call(null,vec__71191,(0),null);
var val = cljs.core.nth.call(null,vec__71191,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__71191,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options71161.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options71161_$_iter__71178.call(null,cljs.core.rest.call(null,s__71179__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options71161);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down71195 = (function sablono$core$drop_down71195(var_args){
var args71196 = [];
var len__10640__auto___71199 = arguments.length;
var i__10641__auto___71200 = (0);
while(true){
if((i__10641__auto___71200 < len__10640__auto___71199)){
args71196.push((arguments[i__10641__auto___71200]));

var G__71201 = (i__10641__auto___71200 + (1));
i__10641__auto___71200 = G__71201;
continue;
} else {
}
break;
}

var G__71198 = args71196.length;
switch (G__71198) {
case 2:
return sablono.core.drop_down71195.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down71195.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71196.length)].join('')));

}
});

sablono.core.drop_down71195.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down71195.call(null,name,options,null);
});

sablono.core.drop_down71195.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down71195.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down71195);
/**
 * Creates a text area element.
 */
sablono.core.text_area71203 = (function sablono$core$text_area71203(var_args){
var args71204 = [];
var len__10640__auto___71207 = arguments.length;
var i__10641__auto___71208 = (0);
while(true){
if((i__10641__auto___71208 < len__10640__auto___71207)){
args71204.push((arguments[i__10641__auto___71208]));

var G__71209 = (i__10641__auto___71208 + (1));
i__10641__auto___71208 = G__71209;
continue;
} else {
}
break;
}

var G__71206 = args71204.length;
switch (G__71206) {
case 1:
return sablono.core.text_area71203.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area71203.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71204.length)].join('')));

}
});

sablono.core.text_area71203.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area71203.call(null,name,null);
});

sablono.core.text_area71203.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area71203.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area71203);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label71211 = (function sablono$core$label71211(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label71211);
/**
 * Creates a submit button.
 */
sablono.core.submit_button71212 = (function sablono$core$submit_button71212(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button71212);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button71213 = (function sablono$core$reset_button71213(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button71213);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to71214 = (function sablono$core$form_to71214(var_args){
var args__10647__auto__ = [];
var len__10640__auto___71221 = arguments.length;
var i__10641__auto___71222 = (0);
while(true){
if((i__10641__auto___71222 < len__10640__auto___71221)){
args__10647__auto__.push((arguments[i__10641__auto___71222]));

var G__71223 = (i__10641__auto___71222 + (1));
i__10641__auto___71222 = G__71223;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to71214.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.form_to71214.cljs$core$IFn$_invoke$arity$variadic = (function (p__71217,body){
var vec__71218 = p__71217;
var method = cljs.core.nth.call(null,vec__71218,(0),null);
var action = cljs.core.nth.call(null,vec__71218,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to71214.cljs$lang$maxFixedArity = (1);

sablono.core.form_to71214.cljs$lang$applyTo = (function (seq71215){
var G__71216 = cljs.core.first.call(null,seq71215);
var seq71215__$1 = cljs.core.next.call(null,seq71215);
return sablono.core.form_to71214.cljs$core$IFn$_invoke$arity$variadic(G__71216,seq71215__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to71214);

//# sourceMappingURL=core.js.map