// Compiled by ClojureScript 1.9.521 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('cljsjs.react.dom');
goog.require('reagent.impl.util');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('reagent.ratom');
goog.require('reagent.debug');
goog.require('reagent.interop');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(!((reagent.dom.imported == null))){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__9419__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_74096 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_74096){
return (function (){
var _STAR_always_update_STAR_74097 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(!((callback == null))){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_74097;
}});})(_STAR_always_update_STAR_74096))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_74096;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args74098 = [];
var len__10640__auto___74101 = arguments.length;
var i__10641__auto___74102 = (0);
while(true){
if((i__10641__auto___74102 < len__10640__auto___74101)){
args74098.push((arguments[i__10641__auto___74102]));

var G__74103 = (i__10641__auto___74102 + (1));
i__10641__auto___74102 = G__74103;
continue;
} else {
}
break;
}

var G__74100 = args74098.length;
switch (G__74100) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74098.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
reagent.impl.template.find_dom_node = reagent.dom.dom_node;
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__74109_74113 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__74110_74114 = null;
var count__74111_74115 = (0);
var i__74112_74116 = (0);
while(true){
if((i__74112_74116 < count__74111_74115)){
var v_74117 = cljs.core._nth.call(null,chunk__74110_74114,i__74112_74116);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_74117);

var G__74118 = seq__74109_74113;
var G__74119 = chunk__74110_74114;
var G__74120 = count__74111_74115;
var G__74121 = (i__74112_74116 + (1));
seq__74109_74113 = G__74118;
chunk__74110_74114 = G__74119;
count__74111_74115 = G__74120;
i__74112_74116 = G__74121;
continue;
} else {
var temp__6738__auto___74122 = cljs.core.seq.call(null,seq__74109_74113);
if(temp__6738__auto___74122){
var seq__74109_74123__$1 = temp__6738__auto___74122;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74109_74123__$1)){
var c__10330__auto___74124 = cljs.core.chunk_first.call(null,seq__74109_74123__$1);
var G__74125 = cljs.core.chunk_rest.call(null,seq__74109_74123__$1);
var G__74126 = c__10330__auto___74124;
var G__74127 = cljs.core.count.call(null,c__10330__auto___74124);
var G__74128 = (0);
seq__74109_74113 = G__74125;
chunk__74110_74114 = G__74126;
count__74111_74115 = G__74127;
i__74112_74116 = G__74128;
continue;
} else {
var v_74129 = cljs.core.first.call(null,seq__74109_74123__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_74129);

var G__74130 = cljs.core.next.call(null,seq__74109_74123__$1);
var G__74131 = null;
var G__74132 = (0);
var G__74133 = (0);
seq__74109_74113 = G__74130;
chunk__74110_74114 = G__74131;
count__74111_74115 = G__74132;
i__74112_74116 = G__74133;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map