// Compiled by ClojureScript 1.9.521 {}
goog.provide('konserve.memory');
goog.require('cljs.core');
goog.require('konserve.protocols');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {konserve.protocols.PEDNAsyncKeyValueStore}
 * @implements {konserve.protocols.PBinaryAsyncKeyValueStore}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
konserve.memory.MemAsyncKeyValueStore = (function (state,read_handlers,write_handlers,locks,__meta,__extmap,__hash){
this.state = state;
this.read_handlers = read_handlers;
this.write_handlers = write_handlers;
this.locks = locks;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10094__auto__,k__10095__auto__){
var self__ = this;
var this__10094__auto____$1 = this;
return this__10094__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__10095__auto__,null);
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10096__auto__,k85730,else__10097__auto__){
var self__ = this;
var this__10096__auto____$1 = this;
var G__85732 = (((k85730 instanceof cljs.core.Keyword))?k85730.fqn:null);
switch (G__85732) {
case "state":
return self__.state;

break;
case "read-handlers":
return self__.read_handlers;

break;
case "write-handlers":
return self__.write_handlers;

break;
case "locks":
return self__.locks;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k85730,else__10097__auto__);

}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10108__auto__,writer__10109__auto__,opts__10110__auto__){
var self__ = this;
var this__10108__auto____$1 = this;
var pr_pair__10111__auto__ = ((function (this__10108__auto____$1){
return (function (keyval__10112__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,cljs.core.pr_writer,""," ","",opts__10110__auto__,keyval__10112__auto__);
});})(this__10108__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,pr_pair__10111__auto__,"#konserve.memory.MemAsyncKeyValueStore{",", ","}",opts__10110__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__85729){
var self__ = this;
var G__85729__$1 = this;
return (new cljs.core.RecordIter((0),G__85729__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10092__auto__){
var self__ = this;
var this__10092__auto____$1 = this;
return self__.__meta;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10088__auto__){
var self__ = this;
var this__10088__auto____$1 = this;
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,self__.__hash));
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_exists_QMARK_$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_85740){
var state_val_85741 = (state_85740[(1)]);
if((state_val_85741 === (1))){
var inst_85733 = cljs.core.deref.call(null,self__.state);
var inst_85734 = inst_85733.call(null,key);
var state_85740__$1 = state_85740;
if(cljs.core.truth_(inst_85734)){
var statearr_85742_85826 = state_85740__$1;
(statearr_85742_85826[(1)] = (2));

} else {
var statearr_85743_85827 = state_85740__$1;
(statearr_85743_85827[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85741 === (2))){
var state_85740__$1 = state_85740;
var statearr_85744_85828 = state_85740__$1;
(statearr_85744_85828[(2)] = true);

(statearr_85744_85828[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85741 === (3))){
var state_85740__$1 = state_85740;
var statearr_85745_85829 = state_85740__$1;
(statearr_85745_85829[(2)] = false);

(statearr_85745_85829[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85741 === (4))){
var inst_85738 = (state_85740[(2)]);
var state_85740__$1 = state_85740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_85740__$1,inst_85738);
} else {
return null;
}
}
}
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_85749 = [null,null,null,null,null,null,null];
(statearr_85749[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_85749[(1)] = (1));

return statearr_85749;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_85740){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_85740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e85750){if((e85750 instanceof Object)){
var ex__38199__auto__ = e85750;
var statearr_85751_85830 = state_85740;
(statearr_85751_85830[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_85740);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85750;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85831 = state_85740;
state_85740 = G__85831;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_85740){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_85740);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_85752 = f__38310__auto__.call(null);
(statearr_85752[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_85752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_get_in$arity$2 = (function (this$,key_vec){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_85756){
var state_val_85757 = (state_85756[(1)]);
if((state_val_85757 === (1))){
var inst_85753 = cljs.core.deref.call(null,self__.state);
var inst_85754 = cljs.core.get_in.call(null,inst_85753,key_vec);
var state_85756__$1 = state_85756;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_85756__$1,inst_85754);
} else {
return null;
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_85761 = [null,null,null,null,null,null,null];
(statearr_85761[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_85761[(1)] = (1));

return statearr_85761;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_85756){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_85756);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e85762){if((e85762 instanceof Object)){
var ex__38199__auto__ = e85762;
var statearr_85763_85832 = state_85756;
(statearr_85763_85832[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_85756);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85762;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85833 = state_85756;
state_85756 = G__85833;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_85756){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_85756);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_85764 = f__38310__auto__.call(null);
(statearr_85764[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_85764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_update_in$arity$3 = (function (this$,key_vec,up_fn){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_85773){
var state_val_85774 = (state_85773[(1)]);
if((state_val_85774 === (1))){
var inst_85765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85766 = cljs.core.deref.call(null,self__.state);
var inst_85767 = cljs.core.get_in.call(null,inst_85766,key_vec);
var inst_85768 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.update_in,key_vec,up_fn);
var inst_85769 = cljs.core.get_in.call(null,inst_85768,key_vec);
var inst_85770 = [inst_85767,inst_85769];
var inst_85771 = (new cljs.core.PersistentVector(null,2,(5),inst_85765,inst_85770,null));
var state_85773__$1 = state_85773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_85773__$1,inst_85771);
} else {
return null;
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_85778 = [null,null,null,null,null,null,null];
(statearr_85778[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_85778[(1)] = (1));

return statearr_85778;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_85773){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_85773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e85779){if((e85779 instanceof Object)){
var ex__38199__auto__ = e85779;
var statearr_85780_85834 = state_85773;
(statearr_85780_85834[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_85773);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85779;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85835 = state_85773;
state_85773 = G__85835;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_85773){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_85773);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_85781 = f__38310__auto__.call(null);
(statearr_85781[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_85781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_assoc_in$arity$3 = (function (this$,key_vec,val){
var self__ = this;
var this$__$1 = this;
return this$__$1.konserve$protocols$PEDNAsyncKeyValueStore$_update_in$arity$3(null,key_vec,((function (this$__$1){
return (function (_){
return val;
});})(this$__$1))
);
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_dissoc$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_85784){
var state_val_85785 = (state_85784[(1)]);
if((state_val_85785 === (1))){
var inst_85782 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.dissoc,key);
var state_85784__$1 = (function (){var statearr_85786 = state_85784;
(statearr_85786[(7)] = inst_85782);

return statearr_85786;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_85784__$1,null);
} else {
return null;
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_85790 = [null,null,null,null,null,null,null,null];
(statearr_85790[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_85790[(1)] = (1));

return statearr_85790;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_85784){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_85784);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e85791){if((e85791 instanceof Object)){
var ex__38199__auto__ = e85791;
var statearr_85792_85836 = state_85784;
(statearr_85792_85836[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_85784);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85791;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85837 = state_85784;
state_85784 = G__85837;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_85784){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_85784);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_85793 = f__38310__auto__.call(null);
(statearr_85793[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_85793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10098__auto__){
var self__ = this;
var this__10098__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bget$arity$3 = (function (this$,key,locked_cb){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_85798){
var state_val_85799 = (state_85798[(1)]);
if((state_val_85799 === (1))){
var inst_85794 = cljs.core.deref.call(null,self__.state);
var inst_85795 = cljs.core.get.call(null,inst_85794,key);
var inst_85796 = locked_cb.call(null,inst_85795);
var state_85798__$1 = state_85798;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_85798__$1,inst_85796);
} else {
return null;
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_85803 = [null,null,null,null,null,null,null];
(statearr_85803[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_85803[(1)] = (1));

return statearr_85803;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_85798){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_85798);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e85804){if((e85804 instanceof Object)){
var ex__38199__auto__ = e85804;
var statearr_85805_85838 = state_85798;
(statearr_85805_85838[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_85798);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85804;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85839 = state_85798;
state_85798 = G__85839;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_85798){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_85798);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_85806 = f__38310__auto__.call(null);
(statearr_85806[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_85806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bassoc$arity$3 = (function (this$,key,input){
var self__ = this;
var this$__$1 = this;
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,this$__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,this$__$1){
return (function (state_85812){
var state_val_85813 = (state_85812[(1)]);
if((state_val_85813 === (1))){
var inst_85807 = [new cljs.core.Keyword(null,"input-stream","input-stream",-179909472),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_85808 = [input,new cljs.core.Keyword(null,"unknown","unknown",-935977881)];
var inst_85809 = cljs.core.PersistentHashMap.fromArrays(inst_85807,inst_85808);
var inst_85810 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.assoc,key,inst_85809);
var state_85812__$1 = (function (){var statearr_85814 = state_85812;
(statearr_85814[(7)] = inst_85810);

return statearr_85814;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_85812__$1,null);
} else {
return null;
}
});})(c__38309__auto__,this$__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_85818 = [null,null,null,null,null,null,null,null];
(statearr_85818[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_85818[(1)] = (1));

return statearr_85818;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_85812){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_85812);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e85819){if((e85819 instanceof Object)){
var ex__38199__auto__ = e85819;
var statearr_85820_85840 = state_85812;
(statearr_85820_85840[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_85812);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85819;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85841 = state_85812;
state_85812 = G__85841;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_85812){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_85812);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,this$__$1))
})();
var state__38311__auto__ = (function (){var statearr_85821 = f__38310__auto__.call(null);
(statearr_85821[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_85821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,this$__$1))
);

return c__38309__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10089__auto__){
var self__ = this;
var this__10089__auto____$1 = this;
var h__9861__auto__ = self__.__hash;
if(!((h__9861__auto__ == null))){
return h__9861__auto__;
} else {
var h__9861__auto____$1 = cljs.core.hash_imap.call(null,this__10089__auto____$1);
self__.__hash = h__9861__auto____$1;

return h__9861__auto____$1;
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10090__auto__,other__10091__auto__){
var self__ = this;
var this__10090__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9407__auto__ = other__10091__auto__;
if(cljs.core.truth_(and__9407__auto__)){
return ((this__10090__auto____$1.constructor === other__10091__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__10090__auto____$1,other__10091__auto__));
} else {
return and__9407__auto__;
}
})())){
return true;
} else {
return false;
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10103__auto__,k__10104__auto__){
var self__ = this;
var this__10103__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"locks","locks",1560476518),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),null], null), null),k__10104__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10103__auto____$1),self__.__meta),k__10104__auto__);
} else {
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10104__auto__)),null));
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10101__auto__,k__10102__auto__,G__85729){
var self__ = this;
var this__10101__auto____$1 = this;
var pred__85822 = cljs.core.keyword_identical_QMARK_;
var expr__85823 = k__10102__auto__;
if(cljs.core.truth_(pred__85822.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__85823))){
return (new konserve.memory.MemAsyncKeyValueStore(G__85729,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__85822.call(null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),expr__85823))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,G__85729,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__85822.call(null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),expr__85823))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,G__85729,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__85822.call(null,new cljs.core.Keyword(null,"locks","locks",1560476518),expr__85823))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,G__85729,self__.__meta,self__.__extmap,null));
} else {
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10102__auto__,G__85729),null));
}
}
}
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10106__auto__){
var self__ = this;
var this__10106__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10093__auto__,G__85729){
var self__ = this;
var this__10093__auto____$1 = this;
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,G__85729,self__.__extmap,self__.__hash));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10099__auto__,entry__10100__auto__){
var self__ = this;
var this__10099__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10100__auto__)){
return this__10099__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__10100__auto__,(0)),cljs.core._nth.call(null,entry__10100__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10099__auto____$1,entry__10100__auto__);
}
});

konserve.memory.MemAsyncKeyValueStore.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"read-handlers","read-handlers",-544976454,null),new cljs.core.Symbol(null,"write-handlers","write-handlers",-456757384,null),new cljs.core.Symbol(null,"locks","locks",-1093959251,null)], null);
});

konserve.memory.MemAsyncKeyValueStore.cljs$lang$type = true;

konserve.memory.MemAsyncKeyValueStore.cljs$lang$ctorPrSeq = (function (this__10130__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"konserve.memory/MemAsyncKeyValueStore");
});

konserve.memory.MemAsyncKeyValueStore.cljs$lang$ctorPrWriter = (function (this__10130__auto__,writer__10131__auto__){
return cljs.core._write.call(null,writer__10131__auto__,"konserve.memory/MemAsyncKeyValueStore");
});

konserve.memory.__GT_MemAsyncKeyValueStore = (function konserve$memory$__GT_MemAsyncKeyValueStore(state,read_handlers,write_handlers,locks){
return (new konserve.memory.MemAsyncKeyValueStore(state,read_handlers,write_handlers,locks,null,null,null));
});

konserve.memory.map__GT_MemAsyncKeyValueStore = (function konserve$memory$map__GT_MemAsyncKeyValueStore(G__85731){
return (new konserve.memory.MemAsyncKeyValueStore(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__85731),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315).cljs$core$IFn$_invoke$arity$1(G__85731),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911).cljs$core$IFn$_invoke$arity$1(G__85731),new cljs.core.Keyword(null,"locks","locks",1560476518).cljs$core$IFn$_invoke$arity$1(G__85731),null,cljs.core.dissoc.call(null,G__85731,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)),null));
});

/**
 * Create in memory store. Binaries are not properly locked yet and
 *   the read and write-handlers are dummy ones for compatibility.
 */
konserve.memory.new_mem_store = (function konserve$memory$new_mem_store(var_args){
var args85842 = [];
var len__10640__auto___85865 = arguments.length;
var i__10641__auto___85866 = (0);
while(true){
if((i__10641__auto___85866 < len__10640__auto___85865)){
args85842.push((arguments[i__10641__auto___85866]));

var G__85867 = (i__10641__auto___85866 + (1));
i__10641__auto___85866 = G__85867;
continue;
} else {
}
break;
}

var G__85844 = args85842.length;
switch (G__85844) {
case 0:
return konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args85842.length)].join('')));

}
});

konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$0 = (function (){
return konserve.memory.new_mem_store.call(null,cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
});

konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$1 = (function (init_atom){
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__){
return (function (state_85856){
var state_val_85857 = (state_85856[(1)]);
if((state_val_85857 === (1))){
var inst_85845 = [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)];
var inst_85846 = cljs.core.PersistentHashMap.EMPTY;
var inst_85847 = cljs.core.atom.call(null,inst_85846);
var inst_85848 = cljs.core.PersistentHashMap.EMPTY;
var inst_85849 = cljs.core.atom.call(null,inst_85848);
var inst_85850 = cljs.core.PersistentHashMap.EMPTY;
var inst_85851 = cljs.core.atom.call(null,inst_85850);
var inst_85852 = [init_atom,inst_85847,inst_85849,inst_85851];
var inst_85853 = cljs.core.PersistentHashMap.fromArrays(inst_85845,inst_85852);
var inst_85854 = konserve.memory.map__GT_MemAsyncKeyValueStore.call(null,inst_85853);
var state_85856__$1 = state_85856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_85856__$1,inst_85854);
} else {
return null;
}
});})(c__38309__auto__))
;
return ((function (switch__38195__auto__,c__38309__auto__){
return (function() {
var konserve$memory$state_machine__38196__auto__ = null;
var konserve$memory$state_machine__38196__auto____0 = (function (){
var statearr_85861 = [null,null,null,null,null,null,null];
(statearr_85861[(0)] = konserve$memory$state_machine__38196__auto__);

(statearr_85861[(1)] = (1));

return statearr_85861;
});
var konserve$memory$state_machine__38196__auto____1 = (function (state_85856){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_85856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e85862){if((e85862 instanceof Object)){
var ex__38199__auto__ = e85862;
var statearr_85863_85869 = state_85856;
(statearr_85863_85869[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_85856);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85862;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__85870 = state_85856;
state_85856 = G__85870;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
konserve$memory$state_machine__38196__auto__ = function(state_85856){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38196__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38196__auto____1.call(this,state_85856);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38196__auto____0;
konserve$memory$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38196__auto____1;
return konserve$memory$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__))
})();
var state__38311__auto__ = (function (){var statearr_85864 = f__38310__auto__.call(null);
(statearr_85864[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_85864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__))
);

return c__38309__auto__;
});

konserve.memory.new_mem_store.cljs$lang$maxFixedArity = 1;


//# sourceMappingURL=memory.js.map