// Compiled by ClojureScript 1.9.521 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args76285 = [];
var len__10640__auto___76291 = arguments.length;
var i__10641__auto___76292 = (0);
while(true){
if((i__10641__auto___76292 < len__10640__auto___76291)){
args76285.push((arguments[i__10641__auto___76292]));

var G__76293 = (i__10641__auto___76292 + (1));
i__10641__auto___76292 = G__76293;
continue;
} else {
}
break;
}

var G__76287 = args76285.length;
switch (G__76287) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76285.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async76288 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async76288 = (function (f,blockable,meta76289){
this.f = f;
this.blockable = blockable;
this.meta76289 = meta76289;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async76288.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_76290,meta76289__$1){
var self__ = this;
var _76290__$1 = this;
return (new cljs.core.async.t_cljs$core$async76288(self__.f,self__.blockable,meta76289__$1));
});

cljs.core.async.t_cljs$core$async76288.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_76290){
var self__ = this;
var _76290__$1 = this;
return self__.meta76289;
});

cljs.core.async.t_cljs$core$async76288.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async76288.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async76288.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async76288.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async76288.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta76289","meta76289",1302115292,null)], null);
});

cljs.core.async.t_cljs$core$async76288.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async76288.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async76288";

cljs.core.async.t_cljs$core$async76288.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async76288");
});

cljs.core.async.__GT_t_cljs$core$async76288 = (function cljs$core$async$__GT_t_cljs$core$async76288(f__$1,blockable__$1,meta76289){
return (new cljs.core.async.t_cljs$core$async76288(f__$1,blockable__$1,meta76289));
});

}

return (new cljs.core.async.t_cljs$core$async76288(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args76297 = [];
var len__10640__auto___76300 = arguments.length;
var i__10641__auto___76301 = (0);
while(true){
if((i__10641__auto___76301 < len__10640__auto___76300)){
args76297.push((arguments[i__10641__auto___76301]));

var G__76302 = (i__10641__auto___76301 + (1));
i__10641__auto___76301 = G__76302;
continue;
} else {
}
break;
}

var G__76299 = args76297.length;
switch (G__76299) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76297.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args76304 = [];
var len__10640__auto___76307 = arguments.length;
var i__10641__auto___76308 = (0);
while(true){
if((i__10641__auto___76308 < len__10640__auto___76307)){
args76304.push((arguments[i__10641__auto___76308]));

var G__76309 = (i__10641__auto___76308 + (1));
i__10641__auto___76308 = G__76309;
continue;
} else {
}
break;
}

var G__76306 = args76304.length;
switch (G__76306) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76304.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args76311 = [];
var len__10640__auto___76314 = arguments.length;
var i__10641__auto___76315 = (0);
while(true){
if((i__10641__auto___76315 < len__10640__auto___76314)){
args76311.push((arguments[i__10641__auto___76315]));

var G__76316 = (i__10641__auto___76315 + (1));
i__10641__auto___76315 = G__76316;
continue;
} else {
}
break;
}

var G__76313 = args76311.length;
switch (G__76313) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76311.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_76318 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_76318);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_76318,ret){
return (function (){
return fn1.call(null,val_76318);
});})(val_76318,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args76319 = [];
var len__10640__auto___76322 = arguments.length;
var i__10641__auto___76323 = (0);
while(true){
if((i__10641__auto___76323 < len__10640__auto___76322)){
args76319.push((arguments[i__10641__auto___76323]));

var G__76324 = (i__10641__auto___76323 + (1));
i__10641__auto___76323 = G__76324;
continue;
} else {
}
break;
}

var G__76321 = args76319.length;
switch (G__76321) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76319.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6736__auto__)){
var ret = temp__6736__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6736__auto__)){
var retb = temp__6736__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6736__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6736__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__10440__auto___76326 = n;
var x_76327 = (0);
while(true){
if((x_76327 < n__10440__auto___76326)){
(a[x_76327] = (0));

var G__76328 = (x_76327 + (1));
x_76327 = G__76328;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__76329 = (i + (1));
i = G__76329;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async76333 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async76333 = (function (flag,meta76334){
this.flag = flag;
this.meta76334 = meta76334;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async76333.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_76335,meta76334__$1){
var self__ = this;
var _76335__$1 = this;
return (new cljs.core.async.t_cljs$core$async76333(self__.flag,meta76334__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async76333.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_76335){
var self__ = this;
var _76335__$1 = this;
return self__.meta76334;
});})(flag))
;

cljs.core.async.t_cljs$core$async76333.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async76333.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async76333.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async76333.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async76333.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta76334","meta76334",-1629448521,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async76333.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async76333.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async76333";

cljs.core.async.t_cljs$core$async76333.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async76333");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async76333 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async76333(flag__$1,meta76334){
return (new cljs.core.async.t_cljs$core$async76333(flag__$1,meta76334));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async76333(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async76339 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async76339 = (function (flag,cb,meta76340){
this.flag = flag;
this.cb = cb;
this.meta76340 = meta76340;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async76339.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_76341,meta76340__$1){
var self__ = this;
var _76341__$1 = this;
return (new cljs.core.async.t_cljs$core$async76339(self__.flag,self__.cb,meta76340__$1));
});

cljs.core.async.t_cljs$core$async76339.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_76341){
var self__ = this;
var _76341__$1 = this;
return self__.meta76340;
});

cljs.core.async.t_cljs$core$async76339.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async76339.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async76339.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async76339.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async76339.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta76340","meta76340",1665757145,null)], null);
});

cljs.core.async.t_cljs$core$async76339.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async76339.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async76339";

cljs.core.async.t_cljs$core$async76339.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async76339");
});

cljs.core.async.__GT_t_cljs$core$async76339 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async76339(flag__$1,cb__$1,meta76340){
return (new cljs.core.async.t_cljs$core$async76339(flag__$1,cb__$1,meta76340));
});

}

return (new cljs.core.async.t_cljs$core$async76339(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__76342_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__76342_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__76343_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__76343_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__9419__auto__ = wport;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return port;
}
})()], null));
} else {
var G__76344 = (i + (1));
i = G__76344;
continue;
}
} else {
return null;
}
break;
}
})();
var or__9419__auto__ = ret;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6738__auto__ = (function (){var and__9407__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__9407__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__9407__auto__;
}
})();
if(cljs.core.truth_(temp__6738__auto__)){
var got = temp__6738__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___76350 = arguments.length;
var i__10641__auto___76351 = (0);
while(true){
if((i__10641__auto___76351 < len__10640__auto___76350)){
args__10647__auto__.push((arguments[i__10641__auto___76351]));

var G__76352 = (i__10641__auto___76351 + (1));
i__10641__auto___76351 = G__76352;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__76347){
var map__76348 = p__76347;
var map__76348__$1 = ((((!((map__76348 == null)))?((((map__76348.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__76348.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__76348):map__76348);
var opts = map__76348__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq76345){
var G__76346 = cljs.core.first.call(null,seq76345);
var seq76345__$1 = cljs.core.next.call(null,seq76345);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__76346,seq76345__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args76353 = [];
var len__10640__auto___76403 = arguments.length;
var i__10641__auto___76404 = (0);
while(true){
if((i__10641__auto___76404 < len__10640__auto___76403)){
args76353.push((arguments[i__10641__auto___76404]));

var G__76405 = (i__10641__auto___76404 + (1));
i__10641__auto___76404 = G__76405;
continue;
} else {
}
break;
}

var G__76355 = args76353.length;
switch (G__76355) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76353.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__38309__auto___76407 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___76407){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___76407){
return (function (state_76379){
var state_val_76380 = (state_76379[(1)]);
if((state_val_76380 === (7))){
var inst_76375 = (state_76379[(2)]);
var state_76379__$1 = state_76379;
var statearr_76381_76408 = state_76379__$1;
(statearr_76381_76408[(2)] = inst_76375);

(statearr_76381_76408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76380 === (1))){
var state_76379__$1 = state_76379;
var statearr_76382_76409 = state_76379__$1;
(statearr_76382_76409[(2)] = null);

(statearr_76382_76409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76380 === (4))){
var inst_76358 = (state_76379[(7)]);
var inst_76358__$1 = (state_76379[(2)]);
var inst_76359 = (inst_76358__$1 == null);
var state_76379__$1 = (function (){var statearr_76383 = state_76379;
(statearr_76383[(7)] = inst_76358__$1);

return statearr_76383;
})();
if(cljs.core.truth_(inst_76359)){
var statearr_76384_76410 = state_76379__$1;
(statearr_76384_76410[(1)] = (5));

} else {
var statearr_76385_76411 = state_76379__$1;
(statearr_76385_76411[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76380 === (13))){
var state_76379__$1 = state_76379;
var statearr_76386_76412 = state_76379__$1;
(statearr_76386_76412[(2)] = null);

(statearr_76386_76412[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76380 === (6))){
var inst_76358 = (state_76379[(7)]);
var state_76379__$1 = state_76379;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76379__$1,(11),to,inst_76358);
} else {
if((state_val_76380 === (3))){
var inst_76377 = (state_76379[(2)]);
var state_76379__$1 = state_76379;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76379__$1,inst_76377);
} else {
if((state_val_76380 === (12))){
var state_76379__$1 = state_76379;
var statearr_76387_76413 = state_76379__$1;
(statearr_76387_76413[(2)] = null);

(statearr_76387_76413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76380 === (2))){
var state_76379__$1 = state_76379;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76379__$1,(4),from);
} else {
if((state_val_76380 === (11))){
var inst_76368 = (state_76379[(2)]);
var state_76379__$1 = state_76379;
if(cljs.core.truth_(inst_76368)){
var statearr_76388_76414 = state_76379__$1;
(statearr_76388_76414[(1)] = (12));

} else {
var statearr_76389_76415 = state_76379__$1;
(statearr_76389_76415[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76380 === (9))){
var state_76379__$1 = state_76379;
var statearr_76390_76416 = state_76379__$1;
(statearr_76390_76416[(2)] = null);

(statearr_76390_76416[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76380 === (5))){
var state_76379__$1 = state_76379;
if(cljs.core.truth_(close_QMARK_)){
var statearr_76391_76417 = state_76379__$1;
(statearr_76391_76417[(1)] = (8));

} else {
var statearr_76392_76418 = state_76379__$1;
(statearr_76392_76418[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76380 === (14))){
var inst_76373 = (state_76379[(2)]);
var state_76379__$1 = state_76379;
var statearr_76393_76419 = state_76379__$1;
(statearr_76393_76419[(2)] = inst_76373);

(statearr_76393_76419[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76380 === (10))){
var inst_76365 = (state_76379[(2)]);
var state_76379__$1 = state_76379;
var statearr_76394_76420 = state_76379__$1;
(statearr_76394_76420[(2)] = inst_76365);

(statearr_76394_76420[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76380 === (8))){
var inst_76362 = cljs.core.async.close_BANG_.call(null,to);
var state_76379__$1 = state_76379;
var statearr_76395_76421 = state_76379__$1;
(statearr_76395_76421[(2)] = inst_76362);

(statearr_76395_76421[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___76407))
;
return ((function (switch__38195__auto__,c__38309__auto___76407){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_76399 = [null,null,null,null,null,null,null,null];
(statearr_76399[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_76399[(1)] = (1));

return statearr_76399;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_76379){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_76379);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e76400){if((e76400 instanceof Object)){
var ex__38199__auto__ = e76400;
var statearr_76401_76422 = state_76379;
(statearr_76401_76422[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76379);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76400;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76423 = state_76379;
state_76379 = G__76423;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_76379){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_76379);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___76407))
})();
var state__38311__auto__ = (function (){var statearr_76402 = f__38310__auto__.call(null);
(statearr_76402[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___76407);

return statearr_76402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___76407))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__76611){
var vec__76612 = p__76611;
var v = cljs.core.nth.call(null,vec__76612,(0),null);
var p = cljs.core.nth.call(null,vec__76612,(1),null);
var job = vec__76612;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__38309__auto___76798 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___76798,res,vec__76612,v,p,job,jobs,results){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___76798,res,vec__76612,v,p,job,jobs,results){
return (function (state_76619){
var state_val_76620 = (state_76619[(1)]);
if((state_val_76620 === (1))){
var state_76619__$1 = state_76619;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76619__$1,(2),res,v);
} else {
if((state_val_76620 === (2))){
var inst_76616 = (state_76619[(2)]);
var inst_76617 = cljs.core.async.close_BANG_.call(null,res);
var state_76619__$1 = (function (){var statearr_76621 = state_76619;
(statearr_76621[(7)] = inst_76616);

return statearr_76621;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76619__$1,inst_76617);
} else {
return null;
}
}
});})(c__38309__auto___76798,res,vec__76612,v,p,job,jobs,results))
;
return ((function (switch__38195__auto__,c__38309__auto___76798,res,vec__76612,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_76625 = [null,null,null,null,null,null,null,null];
(statearr_76625[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__);

(statearr_76625[(1)] = (1));

return statearr_76625;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1 = (function (state_76619){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_76619);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e76626){if((e76626 instanceof Object)){
var ex__38199__auto__ = e76626;
var statearr_76627_76799 = state_76619;
(statearr_76627_76799[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76619);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76626;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76800 = state_76619;
state_76619 = G__76800;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = function(state_76619){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1.call(this,state_76619);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___76798,res,vec__76612,v,p,job,jobs,results))
})();
var state__38311__auto__ = (function (){var statearr_76628 = f__38310__auto__.call(null);
(statearr_76628[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___76798);

return statearr_76628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___76798,res,vec__76612,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__76629){
var vec__76630 = p__76629;
var v = cljs.core.nth.call(null,vec__76630,(0),null);
var p = cljs.core.nth.call(null,vec__76630,(1),null);
var job = vec__76630;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__10440__auto___76801 = n;
var __76802 = (0);
while(true){
if((__76802 < n__10440__auto___76801)){
var G__76633_76803 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__76633_76803) {
case "compute":
var c__38309__auto___76805 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__76802,c__38309__auto___76805,G__76633_76803,n__10440__auto___76801,jobs,results,process,async){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (__76802,c__38309__auto___76805,G__76633_76803,n__10440__auto___76801,jobs,results,process,async){
return (function (state_76646){
var state_val_76647 = (state_76646[(1)]);
if((state_val_76647 === (1))){
var state_76646__$1 = state_76646;
var statearr_76648_76806 = state_76646__$1;
(statearr_76648_76806[(2)] = null);

(statearr_76648_76806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76647 === (2))){
var state_76646__$1 = state_76646;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76646__$1,(4),jobs);
} else {
if((state_val_76647 === (3))){
var inst_76644 = (state_76646[(2)]);
var state_76646__$1 = state_76646;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76646__$1,inst_76644);
} else {
if((state_val_76647 === (4))){
var inst_76636 = (state_76646[(2)]);
var inst_76637 = process.call(null,inst_76636);
var state_76646__$1 = state_76646;
if(cljs.core.truth_(inst_76637)){
var statearr_76649_76807 = state_76646__$1;
(statearr_76649_76807[(1)] = (5));

} else {
var statearr_76650_76808 = state_76646__$1;
(statearr_76650_76808[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76647 === (5))){
var state_76646__$1 = state_76646;
var statearr_76651_76809 = state_76646__$1;
(statearr_76651_76809[(2)] = null);

(statearr_76651_76809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76647 === (6))){
var state_76646__$1 = state_76646;
var statearr_76652_76810 = state_76646__$1;
(statearr_76652_76810[(2)] = null);

(statearr_76652_76810[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76647 === (7))){
var inst_76642 = (state_76646[(2)]);
var state_76646__$1 = state_76646;
var statearr_76653_76811 = state_76646__$1;
(statearr_76653_76811[(2)] = inst_76642);

(statearr_76653_76811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__76802,c__38309__auto___76805,G__76633_76803,n__10440__auto___76801,jobs,results,process,async))
;
return ((function (__76802,switch__38195__auto__,c__38309__auto___76805,G__76633_76803,n__10440__auto___76801,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_76657 = [null,null,null,null,null,null,null];
(statearr_76657[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__);

(statearr_76657[(1)] = (1));

return statearr_76657;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1 = (function (state_76646){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_76646);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e76658){if((e76658 instanceof Object)){
var ex__38199__auto__ = e76658;
var statearr_76659_76812 = state_76646;
(statearr_76659_76812[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76646);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76658;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76813 = state_76646;
state_76646 = G__76813;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = function(state_76646){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1.call(this,state_76646);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__;
})()
;})(__76802,switch__38195__auto__,c__38309__auto___76805,G__76633_76803,n__10440__auto___76801,jobs,results,process,async))
})();
var state__38311__auto__ = (function (){var statearr_76660 = f__38310__auto__.call(null);
(statearr_76660[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___76805);

return statearr_76660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(__76802,c__38309__auto___76805,G__76633_76803,n__10440__auto___76801,jobs,results,process,async))
);


break;
case "async":
var c__38309__auto___76814 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__76802,c__38309__auto___76814,G__76633_76803,n__10440__auto___76801,jobs,results,process,async){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (__76802,c__38309__auto___76814,G__76633_76803,n__10440__auto___76801,jobs,results,process,async){
return (function (state_76673){
var state_val_76674 = (state_76673[(1)]);
if((state_val_76674 === (1))){
var state_76673__$1 = state_76673;
var statearr_76675_76815 = state_76673__$1;
(statearr_76675_76815[(2)] = null);

(statearr_76675_76815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76674 === (2))){
var state_76673__$1 = state_76673;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76673__$1,(4),jobs);
} else {
if((state_val_76674 === (3))){
var inst_76671 = (state_76673[(2)]);
var state_76673__$1 = state_76673;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76673__$1,inst_76671);
} else {
if((state_val_76674 === (4))){
var inst_76663 = (state_76673[(2)]);
var inst_76664 = async.call(null,inst_76663);
var state_76673__$1 = state_76673;
if(cljs.core.truth_(inst_76664)){
var statearr_76676_76816 = state_76673__$1;
(statearr_76676_76816[(1)] = (5));

} else {
var statearr_76677_76817 = state_76673__$1;
(statearr_76677_76817[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76674 === (5))){
var state_76673__$1 = state_76673;
var statearr_76678_76818 = state_76673__$1;
(statearr_76678_76818[(2)] = null);

(statearr_76678_76818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76674 === (6))){
var state_76673__$1 = state_76673;
var statearr_76679_76819 = state_76673__$1;
(statearr_76679_76819[(2)] = null);

(statearr_76679_76819[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76674 === (7))){
var inst_76669 = (state_76673[(2)]);
var state_76673__$1 = state_76673;
var statearr_76680_76820 = state_76673__$1;
(statearr_76680_76820[(2)] = inst_76669);

(statearr_76680_76820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__76802,c__38309__auto___76814,G__76633_76803,n__10440__auto___76801,jobs,results,process,async))
;
return ((function (__76802,switch__38195__auto__,c__38309__auto___76814,G__76633_76803,n__10440__auto___76801,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_76684 = [null,null,null,null,null,null,null];
(statearr_76684[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__);

(statearr_76684[(1)] = (1));

return statearr_76684;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1 = (function (state_76673){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_76673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e76685){if((e76685 instanceof Object)){
var ex__38199__auto__ = e76685;
var statearr_76686_76821 = state_76673;
(statearr_76686_76821[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76673);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76685;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76822 = state_76673;
state_76673 = G__76822;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = function(state_76673){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1.call(this,state_76673);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__;
})()
;})(__76802,switch__38195__auto__,c__38309__auto___76814,G__76633_76803,n__10440__auto___76801,jobs,results,process,async))
})();
var state__38311__auto__ = (function (){var statearr_76687 = f__38310__auto__.call(null);
(statearr_76687[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___76814);

return statearr_76687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(__76802,c__38309__auto___76814,G__76633_76803,n__10440__auto___76801,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__76823 = (__76802 + (1));
__76802 = G__76823;
continue;
} else {
}
break;
}

var c__38309__auto___76824 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___76824,jobs,results,process,async){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___76824,jobs,results,process,async){
return (function (state_76709){
var state_val_76710 = (state_76709[(1)]);
if((state_val_76710 === (1))){
var state_76709__$1 = state_76709;
var statearr_76711_76825 = state_76709__$1;
(statearr_76711_76825[(2)] = null);

(statearr_76711_76825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76710 === (2))){
var state_76709__$1 = state_76709;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76709__$1,(4),from);
} else {
if((state_val_76710 === (3))){
var inst_76707 = (state_76709[(2)]);
var state_76709__$1 = state_76709;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76709__$1,inst_76707);
} else {
if((state_val_76710 === (4))){
var inst_76690 = (state_76709[(7)]);
var inst_76690__$1 = (state_76709[(2)]);
var inst_76691 = (inst_76690__$1 == null);
var state_76709__$1 = (function (){var statearr_76712 = state_76709;
(statearr_76712[(7)] = inst_76690__$1);

return statearr_76712;
})();
if(cljs.core.truth_(inst_76691)){
var statearr_76713_76826 = state_76709__$1;
(statearr_76713_76826[(1)] = (5));

} else {
var statearr_76714_76827 = state_76709__$1;
(statearr_76714_76827[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76710 === (5))){
var inst_76693 = cljs.core.async.close_BANG_.call(null,jobs);
var state_76709__$1 = state_76709;
var statearr_76715_76828 = state_76709__$1;
(statearr_76715_76828[(2)] = inst_76693);

(statearr_76715_76828[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76710 === (6))){
var inst_76695 = (state_76709[(8)]);
var inst_76690 = (state_76709[(7)]);
var inst_76695__$1 = cljs.core.async.chan.call(null,(1));
var inst_76696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76697 = [inst_76690,inst_76695__$1];
var inst_76698 = (new cljs.core.PersistentVector(null,2,(5),inst_76696,inst_76697,null));
var state_76709__$1 = (function (){var statearr_76716 = state_76709;
(statearr_76716[(8)] = inst_76695__$1);

return statearr_76716;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76709__$1,(8),jobs,inst_76698);
} else {
if((state_val_76710 === (7))){
var inst_76705 = (state_76709[(2)]);
var state_76709__$1 = state_76709;
var statearr_76717_76829 = state_76709__$1;
(statearr_76717_76829[(2)] = inst_76705);

(statearr_76717_76829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76710 === (8))){
var inst_76695 = (state_76709[(8)]);
var inst_76700 = (state_76709[(2)]);
var state_76709__$1 = (function (){var statearr_76718 = state_76709;
(statearr_76718[(9)] = inst_76700);

return statearr_76718;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76709__$1,(9),results,inst_76695);
} else {
if((state_val_76710 === (9))){
var inst_76702 = (state_76709[(2)]);
var state_76709__$1 = (function (){var statearr_76719 = state_76709;
(statearr_76719[(10)] = inst_76702);

return statearr_76719;
})();
var statearr_76720_76830 = state_76709__$1;
(statearr_76720_76830[(2)] = null);

(statearr_76720_76830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___76824,jobs,results,process,async))
;
return ((function (switch__38195__auto__,c__38309__auto___76824,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_76724 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_76724[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__);

(statearr_76724[(1)] = (1));

return statearr_76724;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1 = (function (state_76709){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_76709);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e76725){if((e76725 instanceof Object)){
var ex__38199__auto__ = e76725;
var statearr_76726_76831 = state_76709;
(statearr_76726_76831[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76709);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76725;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76832 = state_76709;
state_76709 = G__76832;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = function(state_76709){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1.call(this,state_76709);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___76824,jobs,results,process,async))
})();
var state__38311__auto__ = (function (){var statearr_76727 = f__38310__auto__.call(null);
(statearr_76727[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___76824);

return statearr_76727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___76824,jobs,results,process,async))
);


var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,jobs,results,process,async){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,jobs,results,process,async){
return (function (state_76765){
var state_val_76766 = (state_76765[(1)]);
if((state_val_76766 === (7))){
var inst_76761 = (state_76765[(2)]);
var state_76765__$1 = state_76765;
var statearr_76767_76833 = state_76765__$1;
(statearr_76767_76833[(2)] = inst_76761);

(statearr_76767_76833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (20))){
var state_76765__$1 = state_76765;
var statearr_76768_76834 = state_76765__$1;
(statearr_76768_76834[(2)] = null);

(statearr_76768_76834[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (1))){
var state_76765__$1 = state_76765;
var statearr_76769_76835 = state_76765__$1;
(statearr_76769_76835[(2)] = null);

(statearr_76769_76835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (4))){
var inst_76730 = (state_76765[(7)]);
var inst_76730__$1 = (state_76765[(2)]);
var inst_76731 = (inst_76730__$1 == null);
var state_76765__$1 = (function (){var statearr_76770 = state_76765;
(statearr_76770[(7)] = inst_76730__$1);

return statearr_76770;
})();
if(cljs.core.truth_(inst_76731)){
var statearr_76771_76836 = state_76765__$1;
(statearr_76771_76836[(1)] = (5));

} else {
var statearr_76772_76837 = state_76765__$1;
(statearr_76772_76837[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (15))){
var inst_76743 = (state_76765[(8)]);
var state_76765__$1 = state_76765;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76765__$1,(18),to,inst_76743);
} else {
if((state_val_76766 === (21))){
var inst_76756 = (state_76765[(2)]);
var state_76765__$1 = state_76765;
var statearr_76773_76838 = state_76765__$1;
(statearr_76773_76838[(2)] = inst_76756);

(statearr_76773_76838[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (13))){
var inst_76758 = (state_76765[(2)]);
var state_76765__$1 = (function (){var statearr_76774 = state_76765;
(statearr_76774[(9)] = inst_76758);

return statearr_76774;
})();
var statearr_76775_76839 = state_76765__$1;
(statearr_76775_76839[(2)] = null);

(statearr_76775_76839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (6))){
var inst_76730 = (state_76765[(7)]);
var state_76765__$1 = state_76765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76765__$1,(11),inst_76730);
} else {
if((state_val_76766 === (17))){
var inst_76751 = (state_76765[(2)]);
var state_76765__$1 = state_76765;
if(cljs.core.truth_(inst_76751)){
var statearr_76776_76840 = state_76765__$1;
(statearr_76776_76840[(1)] = (19));

} else {
var statearr_76777_76841 = state_76765__$1;
(statearr_76777_76841[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (3))){
var inst_76763 = (state_76765[(2)]);
var state_76765__$1 = state_76765;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76765__$1,inst_76763);
} else {
if((state_val_76766 === (12))){
var inst_76740 = (state_76765[(10)]);
var state_76765__$1 = state_76765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76765__$1,(14),inst_76740);
} else {
if((state_val_76766 === (2))){
var state_76765__$1 = state_76765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76765__$1,(4),results);
} else {
if((state_val_76766 === (19))){
var state_76765__$1 = state_76765;
var statearr_76778_76842 = state_76765__$1;
(statearr_76778_76842[(2)] = null);

(statearr_76778_76842[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (11))){
var inst_76740 = (state_76765[(2)]);
var state_76765__$1 = (function (){var statearr_76779 = state_76765;
(statearr_76779[(10)] = inst_76740);

return statearr_76779;
})();
var statearr_76780_76843 = state_76765__$1;
(statearr_76780_76843[(2)] = null);

(statearr_76780_76843[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (9))){
var state_76765__$1 = state_76765;
var statearr_76781_76844 = state_76765__$1;
(statearr_76781_76844[(2)] = null);

(statearr_76781_76844[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (5))){
var state_76765__$1 = state_76765;
if(cljs.core.truth_(close_QMARK_)){
var statearr_76782_76845 = state_76765__$1;
(statearr_76782_76845[(1)] = (8));

} else {
var statearr_76783_76846 = state_76765__$1;
(statearr_76783_76846[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (14))){
var inst_76745 = (state_76765[(11)]);
var inst_76743 = (state_76765[(8)]);
var inst_76743__$1 = (state_76765[(2)]);
var inst_76744 = (inst_76743__$1 == null);
var inst_76745__$1 = cljs.core.not.call(null,inst_76744);
var state_76765__$1 = (function (){var statearr_76784 = state_76765;
(statearr_76784[(11)] = inst_76745__$1);

(statearr_76784[(8)] = inst_76743__$1);

return statearr_76784;
})();
if(inst_76745__$1){
var statearr_76785_76847 = state_76765__$1;
(statearr_76785_76847[(1)] = (15));

} else {
var statearr_76786_76848 = state_76765__$1;
(statearr_76786_76848[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (16))){
var inst_76745 = (state_76765[(11)]);
var state_76765__$1 = state_76765;
var statearr_76787_76849 = state_76765__$1;
(statearr_76787_76849[(2)] = inst_76745);

(statearr_76787_76849[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (10))){
var inst_76737 = (state_76765[(2)]);
var state_76765__$1 = state_76765;
var statearr_76788_76850 = state_76765__$1;
(statearr_76788_76850[(2)] = inst_76737);

(statearr_76788_76850[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (18))){
var inst_76748 = (state_76765[(2)]);
var state_76765__$1 = state_76765;
var statearr_76789_76851 = state_76765__$1;
(statearr_76789_76851[(2)] = inst_76748);

(statearr_76789_76851[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76766 === (8))){
var inst_76734 = cljs.core.async.close_BANG_.call(null,to);
var state_76765__$1 = state_76765;
var statearr_76790_76852 = state_76765__$1;
(statearr_76790_76852[(2)] = inst_76734);

(statearr_76790_76852[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto__,jobs,results,process,async))
;
return ((function (switch__38195__auto__,c__38309__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_76794 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76794[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__);

(statearr_76794[(1)] = (1));

return statearr_76794;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1 = (function (state_76765){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_76765);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e76795){if((e76795 instanceof Object)){
var ex__38199__auto__ = e76795;
var statearr_76796_76853 = state_76765;
(statearr_76796_76853[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76765);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76795;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76854 = state_76765;
state_76765 = G__76854;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__ = function(state_76765){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1.call(this,state_76765);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,jobs,results,process,async))
})();
var state__38311__auto__ = (function (){var statearr_76797 = f__38310__auto__.call(null);
(statearr_76797[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_76797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,jobs,results,process,async))
);

return c__38309__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args76855 = [];
var len__10640__auto___76858 = arguments.length;
var i__10641__auto___76859 = (0);
while(true){
if((i__10641__auto___76859 < len__10640__auto___76858)){
args76855.push((arguments[i__10641__auto___76859]));

var G__76860 = (i__10641__auto___76859 + (1));
i__10641__auto___76859 = G__76860;
continue;
} else {
}
break;
}

var G__76857 = args76855.length;
switch (G__76857) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76855.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args76862 = [];
var len__10640__auto___76865 = arguments.length;
var i__10641__auto___76866 = (0);
while(true){
if((i__10641__auto___76866 < len__10640__auto___76865)){
args76862.push((arguments[i__10641__auto___76866]));

var G__76867 = (i__10641__auto___76866 + (1));
i__10641__auto___76866 = G__76867;
continue;
} else {
}
break;
}

var G__76864 = args76862.length;
switch (G__76864) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76862.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args76869 = [];
var len__10640__auto___76922 = arguments.length;
var i__10641__auto___76923 = (0);
while(true){
if((i__10641__auto___76923 < len__10640__auto___76922)){
args76869.push((arguments[i__10641__auto___76923]));

var G__76924 = (i__10641__auto___76923 + (1));
i__10641__auto___76923 = G__76924;
continue;
} else {
}
break;
}

var G__76871 = args76869.length;
switch (G__76871) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76869.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__38309__auto___76926 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___76926,tc,fc){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___76926,tc,fc){
return (function (state_76897){
var state_val_76898 = (state_76897[(1)]);
if((state_val_76898 === (7))){
var inst_76893 = (state_76897[(2)]);
var state_76897__$1 = state_76897;
var statearr_76899_76927 = state_76897__$1;
(statearr_76899_76927[(2)] = inst_76893);

(statearr_76899_76927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76898 === (1))){
var state_76897__$1 = state_76897;
var statearr_76900_76928 = state_76897__$1;
(statearr_76900_76928[(2)] = null);

(statearr_76900_76928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76898 === (4))){
var inst_76874 = (state_76897[(7)]);
var inst_76874__$1 = (state_76897[(2)]);
var inst_76875 = (inst_76874__$1 == null);
var state_76897__$1 = (function (){var statearr_76901 = state_76897;
(statearr_76901[(7)] = inst_76874__$1);

return statearr_76901;
})();
if(cljs.core.truth_(inst_76875)){
var statearr_76902_76929 = state_76897__$1;
(statearr_76902_76929[(1)] = (5));

} else {
var statearr_76903_76930 = state_76897__$1;
(statearr_76903_76930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76898 === (13))){
var state_76897__$1 = state_76897;
var statearr_76904_76931 = state_76897__$1;
(statearr_76904_76931[(2)] = null);

(statearr_76904_76931[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76898 === (6))){
var inst_76874 = (state_76897[(7)]);
var inst_76880 = p.call(null,inst_76874);
var state_76897__$1 = state_76897;
if(cljs.core.truth_(inst_76880)){
var statearr_76905_76932 = state_76897__$1;
(statearr_76905_76932[(1)] = (9));

} else {
var statearr_76906_76933 = state_76897__$1;
(statearr_76906_76933[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76898 === (3))){
var inst_76895 = (state_76897[(2)]);
var state_76897__$1 = state_76897;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76897__$1,inst_76895);
} else {
if((state_val_76898 === (12))){
var state_76897__$1 = state_76897;
var statearr_76907_76934 = state_76897__$1;
(statearr_76907_76934[(2)] = null);

(statearr_76907_76934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76898 === (2))){
var state_76897__$1 = state_76897;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76897__$1,(4),ch);
} else {
if((state_val_76898 === (11))){
var inst_76874 = (state_76897[(7)]);
var inst_76884 = (state_76897[(2)]);
var state_76897__$1 = state_76897;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76897__$1,(8),inst_76884,inst_76874);
} else {
if((state_val_76898 === (9))){
var state_76897__$1 = state_76897;
var statearr_76908_76935 = state_76897__$1;
(statearr_76908_76935[(2)] = tc);

(statearr_76908_76935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76898 === (5))){
var inst_76877 = cljs.core.async.close_BANG_.call(null,tc);
var inst_76878 = cljs.core.async.close_BANG_.call(null,fc);
var state_76897__$1 = (function (){var statearr_76909 = state_76897;
(statearr_76909[(8)] = inst_76877);

return statearr_76909;
})();
var statearr_76910_76936 = state_76897__$1;
(statearr_76910_76936[(2)] = inst_76878);

(statearr_76910_76936[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76898 === (14))){
var inst_76891 = (state_76897[(2)]);
var state_76897__$1 = state_76897;
var statearr_76911_76937 = state_76897__$1;
(statearr_76911_76937[(2)] = inst_76891);

(statearr_76911_76937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76898 === (10))){
var state_76897__$1 = state_76897;
var statearr_76912_76938 = state_76897__$1;
(statearr_76912_76938[(2)] = fc);

(statearr_76912_76938[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76898 === (8))){
var inst_76886 = (state_76897[(2)]);
var state_76897__$1 = state_76897;
if(cljs.core.truth_(inst_76886)){
var statearr_76913_76939 = state_76897__$1;
(statearr_76913_76939[(1)] = (12));

} else {
var statearr_76914_76940 = state_76897__$1;
(statearr_76914_76940[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___76926,tc,fc))
;
return ((function (switch__38195__auto__,c__38309__auto___76926,tc,fc){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_76918 = [null,null,null,null,null,null,null,null,null];
(statearr_76918[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_76918[(1)] = (1));

return statearr_76918;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_76897){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_76897);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e76919){if((e76919 instanceof Object)){
var ex__38199__auto__ = e76919;
var statearr_76920_76941 = state_76897;
(statearr_76920_76941[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76897);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76919;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76942 = state_76897;
state_76897 = G__76942;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_76897){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_76897);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___76926,tc,fc))
})();
var state__38311__auto__ = (function (){var statearr_76921 = f__38310__auto__.call(null);
(statearr_76921[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___76926);

return statearr_76921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___76926,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__){
return (function (state_77006){
var state_val_77007 = (state_77006[(1)]);
if((state_val_77007 === (7))){
var inst_77002 = (state_77006[(2)]);
var state_77006__$1 = state_77006;
var statearr_77008_77029 = state_77006__$1;
(statearr_77008_77029[(2)] = inst_77002);

(statearr_77008_77029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77007 === (1))){
var inst_76986 = init;
var state_77006__$1 = (function (){var statearr_77009 = state_77006;
(statearr_77009[(7)] = inst_76986);

return statearr_77009;
})();
var statearr_77010_77030 = state_77006__$1;
(statearr_77010_77030[(2)] = null);

(statearr_77010_77030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77007 === (4))){
var inst_76989 = (state_77006[(8)]);
var inst_76989__$1 = (state_77006[(2)]);
var inst_76990 = (inst_76989__$1 == null);
var state_77006__$1 = (function (){var statearr_77011 = state_77006;
(statearr_77011[(8)] = inst_76989__$1);

return statearr_77011;
})();
if(cljs.core.truth_(inst_76990)){
var statearr_77012_77031 = state_77006__$1;
(statearr_77012_77031[(1)] = (5));

} else {
var statearr_77013_77032 = state_77006__$1;
(statearr_77013_77032[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77007 === (6))){
var inst_76986 = (state_77006[(7)]);
var inst_76993 = (state_77006[(9)]);
var inst_76989 = (state_77006[(8)]);
var inst_76993__$1 = f.call(null,inst_76986,inst_76989);
var inst_76994 = cljs.core.reduced_QMARK_.call(null,inst_76993__$1);
var state_77006__$1 = (function (){var statearr_77014 = state_77006;
(statearr_77014[(9)] = inst_76993__$1);

return statearr_77014;
})();
if(inst_76994){
var statearr_77015_77033 = state_77006__$1;
(statearr_77015_77033[(1)] = (8));

} else {
var statearr_77016_77034 = state_77006__$1;
(statearr_77016_77034[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77007 === (3))){
var inst_77004 = (state_77006[(2)]);
var state_77006__$1 = state_77006;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77006__$1,inst_77004);
} else {
if((state_val_77007 === (2))){
var state_77006__$1 = state_77006;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77006__$1,(4),ch);
} else {
if((state_val_77007 === (9))){
var inst_76993 = (state_77006[(9)]);
var inst_76986 = inst_76993;
var state_77006__$1 = (function (){var statearr_77017 = state_77006;
(statearr_77017[(7)] = inst_76986);

return statearr_77017;
})();
var statearr_77018_77035 = state_77006__$1;
(statearr_77018_77035[(2)] = null);

(statearr_77018_77035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77007 === (5))){
var inst_76986 = (state_77006[(7)]);
var state_77006__$1 = state_77006;
var statearr_77019_77036 = state_77006__$1;
(statearr_77019_77036[(2)] = inst_76986);

(statearr_77019_77036[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77007 === (10))){
var inst_77000 = (state_77006[(2)]);
var state_77006__$1 = state_77006;
var statearr_77020_77037 = state_77006__$1;
(statearr_77020_77037[(2)] = inst_77000);

(statearr_77020_77037[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77007 === (8))){
var inst_76993 = (state_77006[(9)]);
var inst_76996 = cljs.core.deref.call(null,inst_76993);
var state_77006__$1 = state_77006;
var statearr_77021_77038 = state_77006__$1;
(statearr_77021_77038[(2)] = inst_76996);

(statearr_77021_77038[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto__))
;
return ((function (switch__38195__auto__,c__38309__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__38196__auto__ = null;
var cljs$core$async$reduce_$_state_machine__38196__auto____0 = (function (){
var statearr_77025 = [null,null,null,null,null,null,null,null,null,null];
(statearr_77025[(0)] = cljs$core$async$reduce_$_state_machine__38196__auto__);

(statearr_77025[(1)] = (1));

return statearr_77025;
});
var cljs$core$async$reduce_$_state_machine__38196__auto____1 = (function (state_77006){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_77006);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e77026){if((e77026 instanceof Object)){
var ex__38199__auto__ = e77026;
var statearr_77027_77039 = state_77006;
(statearr_77027_77039[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_77006);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e77026;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77040 = state_77006;
state_77006 = G__77040;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__38196__auto__ = function(state_77006){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__38196__auto____1.call(this,state_77006);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__38196__auto____0;
cljs$core$async$reduce_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__38196__auto____1;
return cljs$core$async$reduce_$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__))
})();
var state__38311__auto__ = (function (){var statearr_77028 = f__38310__auto__.call(null);
(statearr_77028[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_77028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__))
);

return c__38309__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__,f__$1){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__,f__$1){
return (function (state_77060){
var state_val_77061 = (state_77060[(1)]);
if((state_val_77061 === (1))){
var inst_77055 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_77060__$1 = state_77060;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77060__$1,(2),inst_77055);
} else {
if((state_val_77061 === (2))){
var inst_77057 = (state_77060[(2)]);
var inst_77058 = f__$1.call(null,inst_77057);
var state_77060__$1 = state_77060;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77060__$1,inst_77058);
} else {
return null;
}
}
});})(c__38309__auto__,f__$1))
;
return ((function (switch__38195__auto__,c__38309__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__38196__auto__ = null;
var cljs$core$async$transduce_$_state_machine__38196__auto____0 = (function (){
var statearr_77065 = [null,null,null,null,null,null,null];
(statearr_77065[(0)] = cljs$core$async$transduce_$_state_machine__38196__auto__);

(statearr_77065[(1)] = (1));

return statearr_77065;
});
var cljs$core$async$transduce_$_state_machine__38196__auto____1 = (function (state_77060){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_77060);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e77066){if((e77066 instanceof Object)){
var ex__38199__auto__ = e77066;
var statearr_77067_77069 = state_77060;
(statearr_77067_77069[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_77060);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e77066;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77070 = state_77060;
state_77060 = G__77070;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__38196__auto__ = function(state_77060){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__38196__auto____1.call(this,state_77060);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__38196__auto____0;
cljs$core$async$transduce_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__38196__auto____1;
return cljs$core$async$transduce_$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__,f__$1))
})();
var state__38311__auto__ = (function (){var statearr_77068 = f__38310__auto__.call(null);
(statearr_77068[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_77068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__,f__$1))
);

return c__38309__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args77071 = [];
var len__10640__auto___77123 = arguments.length;
var i__10641__auto___77124 = (0);
while(true){
if((i__10641__auto___77124 < len__10640__auto___77123)){
args77071.push((arguments[i__10641__auto___77124]));

var G__77125 = (i__10641__auto___77124 + (1));
i__10641__auto___77124 = G__77125;
continue;
} else {
}
break;
}

var G__77073 = args77071.length;
switch (G__77073) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args77071.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__){
return (function (state_77098){
var state_val_77099 = (state_77098[(1)]);
if((state_val_77099 === (7))){
var inst_77080 = (state_77098[(2)]);
var state_77098__$1 = state_77098;
var statearr_77100_77127 = state_77098__$1;
(statearr_77100_77127[(2)] = inst_77080);

(statearr_77100_77127[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77099 === (1))){
var inst_77074 = cljs.core.seq.call(null,coll);
var inst_77075 = inst_77074;
var state_77098__$1 = (function (){var statearr_77101 = state_77098;
(statearr_77101[(7)] = inst_77075);

return statearr_77101;
})();
var statearr_77102_77128 = state_77098__$1;
(statearr_77102_77128[(2)] = null);

(statearr_77102_77128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77099 === (4))){
var inst_77075 = (state_77098[(7)]);
var inst_77078 = cljs.core.first.call(null,inst_77075);
var state_77098__$1 = state_77098;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_77098__$1,(7),ch,inst_77078);
} else {
if((state_val_77099 === (13))){
var inst_77092 = (state_77098[(2)]);
var state_77098__$1 = state_77098;
var statearr_77103_77129 = state_77098__$1;
(statearr_77103_77129[(2)] = inst_77092);

(statearr_77103_77129[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77099 === (6))){
var inst_77083 = (state_77098[(2)]);
var state_77098__$1 = state_77098;
if(cljs.core.truth_(inst_77083)){
var statearr_77104_77130 = state_77098__$1;
(statearr_77104_77130[(1)] = (8));

} else {
var statearr_77105_77131 = state_77098__$1;
(statearr_77105_77131[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77099 === (3))){
var inst_77096 = (state_77098[(2)]);
var state_77098__$1 = state_77098;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77098__$1,inst_77096);
} else {
if((state_val_77099 === (12))){
var state_77098__$1 = state_77098;
var statearr_77106_77132 = state_77098__$1;
(statearr_77106_77132[(2)] = null);

(statearr_77106_77132[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77099 === (2))){
var inst_77075 = (state_77098[(7)]);
var state_77098__$1 = state_77098;
if(cljs.core.truth_(inst_77075)){
var statearr_77107_77133 = state_77098__$1;
(statearr_77107_77133[(1)] = (4));

} else {
var statearr_77108_77134 = state_77098__$1;
(statearr_77108_77134[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77099 === (11))){
var inst_77089 = cljs.core.async.close_BANG_.call(null,ch);
var state_77098__$1 = state_77098;
var statearr_77109_77135 = state_77098__$1;
(statearr_77109_77135[(2)] = inst_77089);

(statearr_77109_77135[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77099 === (9))){
var state_77098__$1 = state_77098;
if(cljs.core.truth_(close_QMARK_)){
var statearr_77110_77136 = state_77098__$1;
(statearr_77110_77136[(1)] = (11));

} else {
var statearr_77111_77137 = state_77098__$1;
(statearr_77111_77137[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77099 === (5))){
var inst_77075 = (state_77098[(7)]);
var state_77098__$1 = state_77098;
var statearr_77112_77138 = state_77098__$1;
(statearr_77112_77138[(2)] = inst_77075);

(statearr_77112_77138[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77099 === (10))){
var inst_77094 = (state_77098[(2)]);
var state_77098__$1 = state_77098;
var statearr_77113_77139 = state_77098__$1;
(statearr_77113_77139[(2)] = inst_77094);

(statearr_77113_77139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77099 === (8))){
var inst_77075 = (state_77098[(7)]);
var inst_77085 = cljs.core.next.call(null,inst_77075);
var inst_77075__$1 = inst_77085;
var state_77098__$1 = (function (){var statearr_77114 = state_77098;
(statearr_77114[(7)] = inst_77075__$1);

return statearr_77114;
})();
var statearr_77115_77140 = state_77098__$1;
(statearr_77115_77140[(2)] = null);

(statearr_77115_77140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto__))
;
return ((function (switch__38195__auto__,c__38309__auto__){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_77119 = [null,null,null,null,null,null,null,null];
(statearr_77119[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_77119[(1)] = (1));

return statearr_77119;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_77098){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_77098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e77120){if((e77120 instanceof Object)){
var ex__38199__auto__ = e77120;
var statearr_77121_77141 = state_77098;
(statearr_77121_77141[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_77098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e77120;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77142 = state_77098;
state_77098 = G__77142;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_77098){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_77098);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__))
})();
var state__38311__auto__ = (function (){var statearr_77122 = f__38310__auto__.call(null);
(statearr_77122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_77122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__))
);

return c__38309__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__10137__auto__ = (((_ == null))?null:_);
var m__10138__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,_);
} else {
var m__10138__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async77368 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async77368 = (function (ch,cs,meta77369){
this.ch = ch;
this.cs = cs;
this.meta77369 = meta77369;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async77368.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_77370,meta77369__$1){
var self__ = this;
var _77370__$1 = this;
return (new cljs.core.async.t_cljs$core$async77368(self__.ch,self__.cs,meta77369__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async77368.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_77370){
var self__ = this;
var _77370__$1 = this;
return self__.meta77369;
});})(cs))
;

cljs.core.async.t_cljs$core$async77368.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async77368.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async77368.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async77368.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async77368.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async77368.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async77368.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta77369","meta77369",1726894202,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async77368.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async77368.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async77368";

cljs.core.async.t_cljs$core$async77368.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async77368");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async77368 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async77368(ch__$1,cs__$1,meta77369){
return (new cljs.core.async.t_cljs$core$async77368(ch__$1,cs__$1,meta77369));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async77368(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__38309__auto___77593 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___77593,cs,m,dchan,dctr,done){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___77593,cs,m,dchan,dctr,done){
return (function (state_77505){
var state_val_77506 = (state_77505[(1)]);
if((state_val_77506 === (7))){
var inst_77501 = (state_77505[(2)]);
var state_77505__$1 = state_77505;
var statearr_77507_77594 = state_77505__$1;
(statearr_77507_77594[(2)] = inst_77501);

(statearr_77507_77594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (20))){
var inst_77404 = (state_77505[(7)]);
var inst_77416 = cljs.core.first.call(null,inst_77404);
var inst_77417 = cljs.core.nth.call(null,inst_77416,(0),null);
var inst_77418 = cljs.core.nth.call(null,inst_77416,(1),null);
var state_77505__$1 = (function (){var statearr_77508 = state_77505;
(statearr_77508[(8)] = inst_77417);

return statearr_77508;
})();
if(cljs.core.truth_(inst_77418)){
var statearr_77509_77595 = state_77505__$1;
(statearr_77509_77595[(1)] = (22));

} else {
var statearr_77510_77596 = state_77505__$1;
(statearr_77510_77596[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (27))){
var inst_77448 = (state_77505[(9)]);
var inst_77446 = (state_77505[(10)]);
var inst_77453 = (state_77505[(11)]);
var inst_77373 = (state_77505[(12)]);
var inst_77453__$1 = cljs.core._nth.call(null,inst_77446,inst_77448);
var inst_77454 = cljs.core.async.put_BANG_.call(null,inst_77453__$1,inst_77373,done);
var state_77505__$1 = (function (){var statearr_77511 = state_77505;
(statearr_77511[(11)] = inst_77453__$1);

return statearr_77511;
})();
if(cljs.core.truth_(inst_77454)){
var statearr_77512_77597 = state_77505__$1;
(statearr_77512_77597[(1)] = (30));

} else {
var statearr_77513_77598 = state_77505__$1;
(statearr_77513_77598[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (1))){
var state_77505__$1 = state_77505;
var statearr_77514_77599 = state_77505__$1;
(statearr_77514_77599[(2)] = null);

(statearr_77514_77599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (24))){
var inst_77404 = (state_77505[(7)]);
var inst_77423 = (state_77505[(2)]);
var inst_77424 = cljs.core.next.call(null,inst_77404);
var inst_77382 = inst_77424;
var inst_77383 = null;
var inst_77384 = (0);
var inst_77385 = (0);
var state_77505__$1 = (function (){var statearr_77515 = state_77505;
(statearr_77515[(13)] = inst_77382);

(statearr_77515[(14)] = inst_77385);

(statearr_77515[(15)] = inst_77423);

(statearr_77515[(16)] = inst_77384);

(statearr_77515[(17)] = inst_77383);

return statearr_77515;
})();
var statearr_77516_77600 = state_77505__$1;
(statearr_77516_77600[(2)] = null);

(statearr_77516_77600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (39))){
var state_77505__$1 = state_77505;
var statearr_77520_77601 = state_77505__$1;
(statearr_77520_77601[(2)] = null);

(statearr_77520_77601[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (4))){
var inst_77373 = (state_77505[(12)]);
var inst_77373__$1 = (state_77505[(2)]);
var inst_77374 = (inst_77373__$1 == null);
var state_77505__$1 = (function (){var statearr_77521 = state_77505;
(statearr_77521[(12)] = inst_77373__$1);

return statearr_77521;
})();
if(cljs.core.truth_(inst_77374)){
var statearr_77522_77602 = state_77505__$1;
(statearr_77522_77602[(1)] = (5));

} else {
var statearr_77523_77603 = state_77505__$1;
(statearr_77523_77603[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (15))){
var inst_77382 = (state_77505[(13)]);
var inst_77385 = (state_77505[(14)]);
var inst_77384 = (state_77505[(16)]);
var inst_77383 = (state_77505[(17)]);
var inst_77400 = (state_77505[(2)]);
var inst_77401 = (inst_77385 + (1));
var tmp77517 = inst_77382;
var tmp77518 = inst_77384;
var tmp77519 = inst_77383;
var inst_77382__$1 = tmp77517;
var inst_77383__$1 = tmp77519;
var inst_77384__$1 = tmp77518;
var inst_77385__$1 = inst_77401;
var state_77505__$1 = (function (){var statearr_77524 = state_77505;
(statearr_77524[(18)] = inst_77400);

(statearr_77524[(13)] = inst_77382__$1);

(statearr_77524[(14)] = inst_77385__$1);

(statearr_77524[(16)] = inst_77384__$1);

(statearr_77524[(17)] = inst_77383__$1);

return statearr_77524;
})();
var statearr_77525_77604 = state_77505__$1;
(statearr_77525_77604[(2)] = null);

(statearr_77525_77604[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (21))){
var inst_77427 = (state_77505[(2)]);
var state_77505__$1 = state_77505;
var statearr_77529_77605 = state_77505__$1;
(statearr_77529_77605[(2)] = inst_77427);

(statearr_77529_77605[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (31))){
var inst_77453 = (state_77505[(11)]);
var inst_77457 = done.call(null,null);
var inst_77458 = cljs.core.async.untap_STAR_.call(null,m,inst_77453);
var state_77505__$1 = (function (){var statearr_77530 = state_77505;
(statearr_77530[(19)] = inst_77457);

return statearr_77530;
})();
var statearr_77531_77606 = state_77505__$1;
(statearr_77531_77606[(2)] = inst_77458);

(statearr_77531_77606[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (32))){
var inst_77445 = (state_77505[(20)]);
var inst_77448 = (state_77505[(9)]);
var inst_77447 = (state_77505[(21)]);
var inst_77446 = (state_77505[(10)]);
var inst_77460 = (state_77505[(2)]);
var inst_77461 = (inst_77448 + (1));
var tmp77526 = inst_77445;
var tmp77527 = inst_77447;
var tmp77528 = inst_77446;
var inst_77445__$1 = tmp77526;
var inst_77446__$1 = tmp77528;
var inst_77447__$1 = tmp77527;
var inst_77448__$1 = inst_77461;
var state_77505__$1 = (function (){var statearr_77532 = state_77505;
(statearr_77532[(20)] = inst_77445__$1);

(statearr_77532[(9)] = inst_77448__$1);

(statearr_77532[(21)] = inst_77447__$1);

(statearr_77532[(10)] = inst_77446__$1);

(statearr_77532[(22)] = inst_77460);

return statearr_77532;
})();
var statearr_77533_77607 = state_77505__$1;
(statearr_77533_77607[(2)] = null);

(statearr_77533_77607[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (40))){
var inst_77473 = (state_77505[(23)]);
var inst_77477 = done.call(null,null);
var inst_77478 = cljs.core.async.untap_STAR_.call(null,m,inst_77473);
var state_77505__$1 = (function (){var statearr_77534 = state_77505;
(statearr_77534[(24)] = inst_77477);

return statearr_77534;
})();
var statearr_77535_77608 = state_77505__$1;
(statearr_77535_77608[(2)] = inst_77478);

(statearr_77535_77608[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (33))){
var inst_77464 = (state_77505[(25)]);
var inst_77466 = cljs.core.chunked_seq_QMARK_.call(null,inst_77464);
var state_77505__$1 = state_77505;
if(inst_77466){
var statearr_77536_77609 = state_77505__$1;
(statearr_77536_77609[(1)] = (36));

} else {
var statearr_77537_77610 = state_77505__$1;
(statearr_77537_77610[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (13))){
var inst_77394 = (state_77505[(26)]);
var inst_77397 = cljs.core.async.close_BANG_.call(null,inst_77394);
var state_77505__$1 = state_77505;
var statearr_77538_77611 = state_77505__$1;
(statearr_77538_77611[(2)] = inst_77397);

(statearr_77538_77611[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (22))){
var inst_77417 = (state_77505[(8)]);
var inst_77420 = cljs.core.async.close_BANG_.call(null,inst_77417);
var state_77505__$1 = state_77505;
var statearr_77539_77612 = state_77505__$1;
(statearr_77539_77612[(2)] = inst_77420);

(statearr_77539_77612[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (36))){
var inst_77464 = (state_77505[(25)]);
var inst_77468 = cljs.core.chunk_first.call(null,inst_77464);
var inst_77469 = cljs.core.chunk_rest.call(null,inst_77464);
var inst_77470 = cljs.core.count.call(null,inst_77468);
var inst_77445 = inst_77469;
var inst_77446 = inst_77468;
var inst_77447 = inst_77470;
var inst_77448 = (0);
var state_77505__$1 = (function (){var statearr_77540 = state_77505;
(statearr_77540[(20)] = inst_77445);

(statearr_77540[(9)] = inst_77448);

(statearr_77540[(21)] = inst_77447);

(statearr_77540[(10)] = inst_77446);

return statearr_77540;
})();
var statearr_77541_77613 = state_77505__$1;
(statearr_77541_77613[(2)] = null);

(statearr_77541_77613[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (41))){
var inst_77464 = (state_77505[(25)]);
var inst_77480 = (state_77505[(2)]);
var inst_77481 = cljs.core.next.call(null,inst_77464);
var inst_77445 = inst_77481;
var inst_77446 = null;
var inst_77447 = (0);
var inst_77448 = (0);
var state_77505__$1 = (function (){var statearr_77542 = state_77505;
(statearr_77542[(20)] = inst_77445);

(statearr_77542[(9)] = inst_77448);

(statearr_77542[(21)] = inst_77447);

(statearr_77542[(10)] = inst_77446);

(statearr_77542[(27)] = inst_77480);

return statearr_77542;
})();
var statearr_77543_77614 = state_77505__$1;
(statearr_77543_77614[(2)] = null);

(statearr_77543_77614[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (43))){
var state_77505__$1 = state_77505;
var statearr_77544_77615 = state_77505__$1;
(statearr_77544_77615[(2)] = null);

(statearr_77544_77615[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (29))){
var inst_77489 = (state_77505[(2)]);
var state_77505__$1 = state_77505;
var statearr_77545_77616 = state_77505__$1;
(statearr_77545_77616[(2)] = inst_77489);

(statearr_77545_77616[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (44))){
var inst_77498 = (state_77505[(2)]);
var state_77505__$1 = (function (){var statearr_77546 = state_77505;
(statearr_77546[(28)] = inst_77498);

return statearr_77546;
})();
var statearr_77547_77617 = state_77505__$1;
(statearr_77547_77617[(2)] = null);

(statearr_77547_77617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (6))){
var inst_77437 = (state_77505[(29)]);
var inst_77436 = cljs.core.deref.call(null,cs);
var inst_77437__$1 = cljs.core.keys.call(null,inst_77436);
var inst_77438 = cljs.core.count.call(null,inst_77437__$1);
var inst_77439 = cljs.core.reset_BANG_.call(null,dctr,inst_77438);
var inst_77444 = cljs.core.seq.call(null,inst_77437__$1);
var inst_77445 = inst_77444;
var inst_77446 = null;
var inst_77447 = (0);
var inst_77448 = (0);
var state_77505__$1 = (function (){var statearr_77548 = state_77505;
(statearr_77548[(20)] = inst_77445);

(statearr_77548[(9)] = inst_77448);

(statearr_77548[(21)] = inst_77447);

(statearr_77548[(29)] = inst_77437__$1);

(statearr_77548[(10)] = inst_77446);

(statearr_77548[(30)] = inst_77439);

return statearr_77548;
})();
var statearr_77549_77618 = state_77505__$1;
(statearr_77549_77618[(2)] = null);

(statearr_77549_77618[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (28))){
var inst_77445 = (state_77505[(20)]);
var inst_77464 = (state_77505[(25)]);
var inst_77464__$1 = cljs.core.seq.call(null,inst_77445);
var state_77505__$1 = (function (){var statearr_77550 = state_77505;
(statearr_77550[(25)] = inst_77464__$1);

return statearr_77550;
})();
if(inst_77464__$1){
var statearr_77551_77619 = state_77505__$1;
(statearr_77551_77619[(1)] = (33));

} else {
var statearr_77552_77620 = state_77505__$1;
(statearr_77552_77620[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (25))){
var inst_77448 = (state_77505[(9)]);
var inst_77447 = (state_77505[(21)]);
var inst_77450 = (inst_77448 < inst_77447);
var inst_77451 = inst_77450;
var state_77505__$1 = state_77505;
if(cljs.core.truth_(inst_77451)){
var statearr_77553_77621 = state_77505__$1;
(statearr_77553_77621[(1)] = (27));

} else {
var statearr_77554_77622 = state_77505__$1;
(statearr_77554_77622[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (34))){
var state_77505__$1 = state_77505;
var statearr_77555_77623 = state_77505__$1;
(statearr_77555_77623[(2)] = null);

(statearr_77555_77623[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (17))){
var state_77505__$1 = state_77505;
var statearr_77556_77624 = state_77505__$1;
(statearr_77556_77624[(2)] = null);

(statearr_77556_77624[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (3))){
var inst_77503 = (state_77505[(2)]);
var state_77505__$1 = state_77505;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77505__$1,inst_77503);
} else {
if((state_val_77506 === (12))){
var inst_77432 = (state_77505[(2)]);
var state_77505__$1 = state_77505;
var statearr_77557_77625 = state_77505__$1;
(statearr_77557_77625[(2)] = inst_77432);

(statearr_77557_77625[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (2))){
var state_77505__$1 = state_77505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77505__$1,(4),ch);
} else {
if((state_val_77506 === (23))){
var state_77505__$1 = state_77505;
var statearr_77558_77626 = state_77505__$1;
(statearr_77558_77626[(2)] = null);

(statearr_77558_77626[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (35))){
var inst_77487 = (state_77505[(2)]);
var state_77505__$1 = state_77505;
var statearr_77559_77627 = state_77505__$1;
(statearr_77559_77627[(2)] = inst_77487);

(statearr_77559_77627[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (19))){
var inst_77404 = (state_77505[(7)]);
var inst_77408 = cljs.core.chunk_first.call(null,inst_77404);
var inst_77409 = cljs.core.chunk_rest.call(null,inst_77404);
var inst_77410 = cljs.core.count.call(null,inst_77408);
var inst_77382 = inst_77409;
var inst_77383 = inst_77408;
var inst_77384 = inst_77410;
var inst_77385 = (0);
var state_77505__$1 = (function (){var statearr_77560 = state_77505;
(statearr_77560[(13)] = inst_77382);

(statearr_77560[(14)] = inst_77385);

(statearr_77560[(16)] = inst_77384);

(statearr_77560[(17)] = inst_77383);

return statearr_77560;
})();
var statearr_77561_77628 = state_77505__$1;
(statearr_77561_77628[(2)] = null);

(statearr_77561_77628[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (11))){
var inst_77382 = (state_77505[(13)]);
var inst_77404 = (state_77505[(7)]);
var inst_77404__$1 = cljs.core.seq.call(null,inst_77382);
var state_77505__$1 = (function (){var statearr_77562 = state_77505;
(statearr_77562[(7)] = inst_77404__$1);

return statearr_77562;
})();
if(inst_77404__$1){
var statearr_77563_77629 = state_77505__$1;
(statearr_77563_77629[(1)] = (16));

} else {
var statearr_77564_77630 = state_77505__$1;
(statearr_77564_77630[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (9))){
var inst_77434 = (state_77505[(2)]);
var state_77505__$1 = state_77505;
var statearr_77565_77631 = state_77505__$1;
(statearr_77565_77631[(2)] = inst_77434);

(statearr_77565_77631[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (5))){
var inst_77380 = cljs.core.deref.call(null,cs);
var inst_77381 = cljs.core.seq.call(null,inst_77380);
var inst_77382 = inst_77381;
var inst_77383 = null;
var inst_77384 = (0);
var inst_77385 = (0);
var state_77505__$1 = (function (){var statearr_77566 = state_77505;
(statearr_77566[(13)] = inst_77382);

(statearr_77566[(14)] = inst_77385);

(statearr_77566[(16)] = inst_77384);

(statearr_77566[(17)] = inst_77383);

return statearr_77566;
})();
var statearr_77567_77632 = state_77505__$1;
(statearr_77567_77632[(2)] = null);

(statearr_77567_77632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (14))){
var state_77505__$1 = state_77505;
var statearr_77568_77633 = state_77505__$1;
(statearr_77568_77633[(2)] = null);

(statearr_77568_77633[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (45))){
var inst_77495 = (state_77505[(2)]);
var state_77505__$1 = state_77505;
var statearr_77569_77634 = state_77505__$1;
(statearr_77569_77634[(2)] = inst_77495);

(statearr_77569_77634[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (26))){
var inst_77437 = (state_77505[(29)]);
var inst_77491 = (state_77505[(2)]);
var inst_77492 = cljs.core.seq.call(null,inst_77437);
var state_77505__$1 = (function (){var statearr_77570 = state_77505;
(statearr_77570[(31)] = inst_77491);

return statearr_77570;
})();
if(inst_77492){
var statearr_77571_77635 = state_77505__$1;
(statearr_77571_77635[(1)] = (42));

} else {
var statearr_77572_77636 = state_77505__$1;
(statearr_77572_77636[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (16))){
var inst_77404 = (state_77505[(7)]);
var inst_77406 = cljs.core.chunked_seq_QMARK_.call(null,inst_77404);
var state_77505__$1 = state_77505;
if(inst_77406){
var statearr_77573_77637 = state_77505__$1;
(statearr_77573_77637[(1)] = (19));

} else {
var statearr_77574_77638 = state_77505__$1;
(statearr_77574_77638[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (38))){
var inst_77484 = (state_77505[(2)]);
var state_77505__$1 = state_77505;
var statearr_77575_77639 = state_77505__$1;
(statearr_77575_77639[(2)] = inst_77484);

(statearr_77575_77639[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (30))){
var state_77505__$1 = state_77505;
var statearr_77576_77640 = state_77505__$1;
(statearr_77576_77640[(2)] = null);

(statearr_77576_77640[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (10))){
var inst_77385 = (state_77505[(14)]);
var inst_77383 = (state_77505[(17)]);
var inst_77393 = cljs.core._nth.call(null,inst_77383,inst_77385);
var inst_77394 = cljs.core.nth.call(null,inst_77393,(0),null);
var inst_77395 = cljs.core.nth.call(null,inst_77393,(1),null);
var state_77505__$1 = (function (){var statearr_77577 = state_77505;
(statearr_77577[(26)] = inst_77394);

return statearr_77577;
})();
if(cljs.core.truth_(inst_77395)){
var statearr_77578_77641 = state_77505__$1;
(statearr_77578_77641[(1)] = (13));

} else {
var statearr_77579_77642 = state_77505__$1;
(statearr_77579_77642[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (18))){
var inst_77430 = (state_77505[(2)]);
var state_77505__$1 = state_77505;
var statearr_77580_77643 = state_77505__$1;
(statearr_77580_77643[(2)] = inst_77430);

(statearr_77580_77643[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (42))){
var state_77505__$1 = state_77505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77505__$1,(45),dchan);
} else {
if((state_val_77506 === (37))){
var inst_77473 = (state_77505[(23)]);
var inst_77373 = (state_77505[(12)]);
var inst_77464 = (state_77505[(25)]);
var inst_77473__$1 = cljs.core.first.call(null,inst_77464);
var inst_77474 = cljs.core.async.put_BANG_.call(null,inst_77473__$1,inst_77373,done);
var state_77505__$1 = (function (){var statearr_77581 = state_77505;
(statearr_77581[(23)] = inst_77473__$1);

return statearr_77581;
})();
if(cljs.core.truth_(inst_77474)){
var statearr_77582_77644 = state_77505__$1;
(statearr_77582_77644[(1)] = (39));

} else {
var statearr_77583_77645 = state_77505__$1;
(statearr_77583_77645[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77506 === (8))){
var inst_77385 = (state_77505[(14)]);
var inst_77384 = (state_77505[(16)]);
var inst_77387 = (inst_77385 < inst_77384);
var inst_77388 = inst_77387;
var state_77505__$1 = state_77505;
if(cljs.core.truth_(inst_77388)){
var statearr_77584_77646 = state_77505__$1;
(statearr_77584_77646[(1)] = (10));

} else {
var statearr_77585_77647 = state_77505__$1;
(statearr_77585_77647[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___77593,cs,m,dchan,dctr,done))
;
return ((function (switch__38195__auto__,c__38309__auto___77593,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__38196__auto__ = null;
var cljs$core$async$mult_$_state_machine__38196__auto____0 = (function (){
var statearr_77589 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77589[(0)] = cljs$core$async$mult_$_state_machine__38196__auto__);

(statearr_77589[(1)] = (1));

return statearr_77589;
});
var cljs$core$async$mult_$_state_machine__38196__auto____1 = (function (state_77505){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_77505);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e77590){if((e77590 instanceof Object)){
var ex__38199__auto__ = e77590;
var statearr_77591_77648 = state_77505;
(statearr_77591_77648[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_77505);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e77590;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77649 = state_77505;
state_77505 = G__77649;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__38196__auto__ = function(state_77505){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__38196__auto____1.call(this,state_77505);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__38196__auto____0;
cljs$core$async$mult_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__38196__auto____1;
return cljs$core$async$mult_$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___77593,cs,m,dchan,dctr,done))
})();
var state__38311__auto__ = (function (){var statearr_77592 = f__38310__auto__.call(null);
(statearr_77592[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___77593);

return statearr_77592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___77593,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args77650 = [];
var len__10640__auto___77653 = arguments.length;
var i__10641__auto___77654 = (0);
while(true){
if((i__10641__auto___77654 < len__10640__auto___77653)){
args77650.push((arguments[i__10641__auto___77654]));

var G__77655 = (i__10641__auto___77654 + (1));
i__10641__auto___77654 = G__77655;
continue;
} else {
}
break;
}

var G__77652 = args77650.length;
switch (G__77652) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args77650.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,state_map);
} else {
var m__10138__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,mode);
} else {
var m__10138__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___77667 = arguments.length;
var i__10641__auto___77668 = (0);
while(true){
if((i__10641__auto___77668 < len__10640__auto___77667)){
args__10647__auto__.push((arguments[i__10641__auto___77668]));

var G__77669 = (i__10641__auto___77668 + (1));
i__10641__auto___77668 = G__77669;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__77661){
var map__77662 = p__77661;
var map__77662__$1 = ((((!((map__77662 == null)))?((((map__77662.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__77662.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__77662):map__77662);
var opts = map__77662__$1;
var statearr_77664_77670 = state;
(statearr_77664_77670[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6738__auto__ = cljs.core.async.do_alts.call(null,((function (map__77662,map__77662__$1,opts){
return (function (val){
var statearr_77665_77671 = state;
(statearr_77665_77671[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__77662,map__77662__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6738__auto__)){
var cb = temp__6738__auto__;
var statearr_77666_77672 = state;
(statearr_77666_77672[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq77657){
var G__77658 = cljs.core.first.call(null,seq77657);
var seq77657__$1 = cljs.core.next.call(null,seq77657);
var G__77659 = cljs.core.first.call(null,seq77657__$1);
var seq77657__$2 = cljs.core.next.call(null,seq77657__$1);
var G__77660 = cljs.core.first.call(null,seq77657__$2);
var seq77657__$3 = cljs.core.next.call(null,seq77657__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__77658,G__77659,G__77660,seq77657__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async77840 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async77840 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta77841){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta77841 = meta77841;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async77840.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_77842,meta77841__$1){
var self__ = this;
var _77842__$1 = this;
return (new cljs.core.async.t_cljs$core$async77840(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta77841__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77840.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_77842){
var self__ = this;
var _77842__$1 = this;
return self__.meta77841;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77840.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async77840.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77840.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async77840.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77840.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77840.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77840.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77840.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77840.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta77841","meta77841",301443707,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77840.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async77840.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async77840";

cljs.core.async.t_cljs$core$async77840.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async77840");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async77840 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async77840(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta77841){
return (new cljs.core.async.t_cljs$core$async77840(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta77841));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async77840(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38309__auto___78007 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___78007,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___78007,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_77944){
var state_val_77945 = (state_77944[(1)]);
if((state_val_77945 === (7))){
var inst_77859 = (state_77944[(2)]);
var state_77944__$1 = state_77944;
var statearr_77946_78008 = state_77944__$1;
(statearr_77946_78008[(2)] = inst_77859);

(statearr_77946_78008[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (20))){
var inst_77871 = (state_77944[(7)]);
var state_77944__$1 = state_77944;
var statearr_77947_78009 = state_77944__$1;
(statearr_77947_78009[(2)] = inst_77871);

(statearr_77947_78009[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (27))){
var state_77944__$1 = state_77944;
var statearr_77948_78010 = state_77944__$1;
(statearr_77948_78010[(2)] = null);

(statearr_77948_78010[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (1))){
var inst_77846 = (state_77944[(8)]);
var inst_77846__$1 = calc_state.call(null);
var inst_77848 = (inst_77846__$1 == null);
var inst_77849 = cljs.core.not.call(null,inst_77848);
var state_77944__$1 = (function (){var statearr_77949 = state_77944;
(statearr_77949[(8)] = inst_77846__$1);

return statearr_77949;
})();
if(inst_77849){
var statearr_77950_78011 = state_77944__$1;
(statearr_77950_78011[(1)] = (2));

} else {
var statearr_77951_78012 = state_77944__$1;
(statearr_77951_78012[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (24))){
var inst_77904 = (state_77944[(9)]);
var inst_77895 = (state_77944[(10)]);
var inst_77918 = (state_77944[(11)]);
var inst_77918__$1 = inst_77895.call(null,inst_77904);
var state_77944__$1 = (function (){var statearr_77952 = state_77944;
(statearr_77952[(11)] = inst_77918__$1);

return statearr_77952;
})();
if(cljs.core.truth_(inst_77918__$1)){
var statearr_77953_78013 = state_77944__$1;
(statearr_77953_78013[(1)] = (29));

} else {
var statearr_77954_78014 = state_77944__$1;
(statearr_77954_78014[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (4))){
var inst_77862 = (state_77944[(2)]);
var state_77944__$1 = state_77944;
if(cljs.core.truth_(inst_77862)){
var statearr_77955_78015 = state_77944__$1;
(statearr_77955_78015[(1)] = (8));

} else {
var statearr_77956_78016 = state_77944__$1;
(statearr_77956_78016[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (15))){
var inst_77889 = (state_77944[(2)]);
var state_77944__$1 = state_77944;
if(cljs.core.truth_(inst_77889)){
var statearr_77957_78017 = state_77944__$1;
(statearr_77957_78017[(1)] = (19));

} else {
var statearr_77958_78018 = state_77944__$1;
(statearr_77958_78018[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (21))){
var inst_77894 = (state_77944[(12)]);
var inst_77894__$1 = (state_77944[(2)]);
var inst_77895 = cljs.core.get.call(null,inst_77894__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_77896 = cljs.core.get.call(null,inst_77894__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_77897 = cljs.core.get.call(null,inst_77894__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_77944__$1 = (function (){var statearr_77959 = state_77944;
(statearr_77959[(13)] = inst_77896);

(statearr_77959[(10)] = inst_77895);

(statearr_77959[(12)] = inst_77894__$1);

return statearr_77959;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_77944__$1,(22),inst_77897);
} else {
if((state_val_77945 === (31))){
var inst_77926 = (state_77944[(2)]);
var state_77944__$1 = state_77944;
if(cljs.core.truth_(inst_77926)){
var statearr_77960_78019 = state_77944__$1;
(statearr_77960_78019[(1)] = (32));

} else {
var statearr_77961_78020 = state_77944__$1;
(statearr_77961_78020[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (32))){
var inst_77903 = (state_77944[(14)]);
var state_77944__$1 = state_77944;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_77944__$1,(35),out,inst_77903);
} else {
if((state_val_77945 === (33))){
var inst_77894 = (state_77944[(12)]);
var inst_77871 = inst_77894;
var state_77944__$1 = (function (){var statearr_77962 = state_77944;
(statearr_77962[(7)] = inst_77871);

return statearr_77962;
})();
var statearr_77963_78021 = state_77944__$1;
(statearr_77963_78021[(2)] = null);

(statearr_77963_78021[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (13))){
var inst_77871 = (state_77944[(7)]);
var inst_77878 = inst_77871.cljs$lang$protocol_mask$partition0$;
var inst_77879 = (inst_77878 & (64));
var inst_77880 = inst_77871.cljs$core$ISeq$;
var inst_77881 = (cljs.core.PROTOCOL_SENTINEL === inst_77880);
var inst_77882 = (inst_77879) || (inst_77881);
var state_77944__$1 = state_77944;
if(cljs.core.truth_(inst_77882)){
var statearr_77964_78022 = state_77944__$1;
(statearr_77964_78022[(1)] = (16));

} else {
var statearr_77965_78023 = state_77944__$1;
(statearr_77965_78023[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (22))){
var inst_77904 = (state_77944[(9)]);
var inst_77903 = (state_77944[(14)]);
var inst_77902 = (state_77944[(2)]);
var inst_77903__$1 = cljs.core.nth.call(null,inst_77902,(0),null);
var inst_77904__$1 = cljs.core.nth.call(null,inst_77902,(1),null);
var inst_77905 = (inst_77903__$1 == null);
var inst_77906 = cljs.core._EQ_.call(null,inst_77904__$1,change);
var inst_77907 = (inst_77905) || (inst_77906);
var state_77944__$1 = (function (){var statearr_77966 = state_77944;
(statearr_77966[(9)] = inst_77904__$1);

(statearr_77966[(14)] = inst_77903__$1);

return statearr_77966;
})();
if(cljs.core.truth_(inst_77907)){
var statearr_77967_78024 = state_77944__$1;
(statearr_77967_78024[(1)] = (23));

} else {
var statearr_77968_78025 = state_77944__$1;
(statearr_77968_78025[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (36))){
var inst_77894 = (state_77944[(12)]);
var inst_77871 = inst_77894;
var state_77944__$1 = (function (){var statearr_77969 = state_77944;
(statearr_77969[(7)] = inst_77871);

return statearr_77969;
})();
var statearr_77970_78026 = state_77944__$1;
(statearr_77970_78026[(2)] = null);

(statearr_77970_78026[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (29))){
var inst_77918 = (state_77944[(11)]);
var state_77944__$1 = state_77944;
var statearr_77971_78027 = state_77944__$1;
(statearr_77971_78027[(2)] = inst_77918);

(statearr_77971_78027[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (6))){
var state_77944__$1 = state_77944;
var statearr_77972_78028 = state_77944__$1;
(statearr_77972_78028[(2)] = false);

(statearr_77972_78028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (28))){
var inst_77914 = (state_77944[(2)]);
var inst_77915 = calc_state.call(null);
var inst_77871 = inst_77915;
var state_77944__$1 = (function (){var statearr_77973 = state_77944;
(statearr_77973[(7)] = inst_77871);

(statearr_77973[(15)] = inst_77914);

return statearr_77973;
})();
var statearr_77974_78029 = state_77944__$1;
(statearr_77974_78029[(2)] = null);

(statearr_77974_78029[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (25))){
var inst_77940 = (state_77944[(2)]);
var state_77944__$1 = state_77944;
var statearr_77975_78030 = state_77944__$1;
(statearr_77975_78030[(2)] = inst_77940);

(statearr_77975_78030[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (34))){
var inst_77938 = (state_77944[(2)]);
var state_77944__$1 = state_77944;
var statearr_77976_78031 = state_77944__$1;
(statearr_77976_78031[(2)] = inst_77938);

(statearr_77976_78031[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (17))){
var state_77944__$1 = state_77944;
var statearr_77977_78032 = state_77944__$1;
(statearr_77977_78032[(2)] = false);

(statearr_77977_78032[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (3))){
var state_77944__$1 = state_77944;
var statearr_77978_78033 = state_77944__$1;
(statearr_77978_78033[(2)] = false);

(statearr_77978_78033[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (12))){
var inst_77942 = (state_77944[(2)]);
var state_77944__$1 = state_77944;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77944__$1,inst_77942);
} else {
if((state_val_77945 === (2))){
var inst_77846 = (state_77944[(8)]);
var inst_77851 = inst_77846.cljs$lang$protocol_mask$partition0$;
var inst_77852 = (inst_77851 & (64));
var inst_77853 = inst_77846.cljs$core$ISeq$;
var inst_77854 = (cljs.core.PROTOCOL_SENTINEL === inst_77853);
var inst_77855 = (inst_77852) || (inst_77854);
var state_77944__$1 = state_77944;
if(cljs.core.truth_(inst_77855)){
var statearr_77979_78034 = state_77944__$1;
(statearr_77979_78034[(1)] = (5));

} else {
var statearr_77980_78035 = state_77944__$1;
(statearr_77980_78035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (23))){
var inst_77903 = (state_77944[(14)]);
var inst_77909 = (inst_77903 == null);
var state_77944__$1 = state_77944;
if(cljs.core.truth_(inst_77909)){
var statearr_77981_78036 = state_77944__$1;
(statearr_77981_78036[(1)] = (26));

} else {
var statearr_77982_78037 = state_77944__$1;
(statearr_77982_78037[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (35))){
var inst_77929 = (state_77944[(2)]);
var state_77944__$1 = state_77944;
if(cljs.core.truth_(inst_77929)){
var statearr_77983_78038 = state_77944__$1;
(statearr_77983_78038[(1)] = (36));

} else {
var statearr_77984_78039 = state_77944__$1;
(statearr_77984_78039[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (19))){
var inst_77871 = (state_77944[(7)]);
var inst_77891 = cljs.core.apply.call(null,cljs.core.hash_map,inst_77871);
var state_77944__$1 = state_77944;
var statearr_77985_78040 = state_77944__$1;
(statearr_77985_78040[(2)] = inst_77891);

(statearr_77985_78040[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (11))){
var inst_77871 = (state_77944[(7)]);
var inst_77875 = (inst_77871 == null);
var inst_77876 = cljs.core.not.call(null,inst_77875);
var state_77944__$1 = state_77944;
if(inst_77876){
var statearr_77986_78041 = state_77944__$1;
(statearr_77986_78041[(1)] = (13));

} else {
var statearr_77987_78042 = state_77944__$1;
(statearr_77987_78042[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (9))){
var inst_77846 = (state_77944[(8)]);
var state_77944__$1 = state_77944;
var statearr_77988_78043 = state_77944__$1;
(statearr_77988_78043[(2)] = inst_77846);

(statearr_77988_78043[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (5))){
var state_77944__$1 = state_77944;
var statearr_77989_78044 = state_77944__$1;
(statearr_77989_78044[(2)] = true);

(statearr_77989_78044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (14))){
var state_77944__$1 = state_77944;
var statearr_77990_78045 = state_77944__$1;
(statearr_77990_78045[(2)] = false);

(statearr_77990_78045[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (26))){
var inst_77904 = (state_77944[(9)]);
var inst_77911 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_77904);
var state_77944__$1 = state_77944;
var statearr_77991_78046 = state_77944__$1;
(statearr_77991_78046[(2)] = inst_77911);

(statearr_77991_78046[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (16))){
var state_77944__$1 = state_77944;
var statearr_77992_78047 = state_77944__$1;
(statearr_77992_78047[(2)] = true);

(statearr_77992_78047[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (38))){
var inst_77934 = (state_77944[(2)]);
var state_77944__$1 = state_77944;
var statearr_77993_78048 = state_77944__$1;
(statearr_77993_78048[(2)] = inst_77934);

(statearr_77993_78048[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (30))){
var inst_77904 = (state_77944[(9)]);
var inst_77896 = (state_77944[(13)]);
var inst_77895 = (state_77944[(10)]);
var inst_77921 = cljs.core.empty_QMARK_.call(null,inst_77895);
var inst_77922 = inst_77896.call(null,inst_77904);
var inst_77923 = cljs.core.not.call(null,inst_77922);
var inst_77924 = (inst_77921) && (inst_77923);
var state_77944__$1 = state_77944;
var statearr_77994_78049 = state_77944__$1;
(statearr_77994_78049[(2)] = inst_77924);

(statearr_77994_78049[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (10))){
var inst_77846 = (state_77944[(8)]);
var inst_77867 = (state_77944[(2)]);
var inst_77868 = cljs.core.get.call(null,inst_77867,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_77869 = cljs.core.get.call(null,inst_77867,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_77870 = cljs.core.get.call(null,inst_77867,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_77871 = inst_77846;
var state_77944__$1 = (function (){var statearr_77995 = state_77944;
(statearr_77995[(7)] = inst_77871);

(statearr_77995[(16)] = inst_77870);

(statearr_77995[(17)] = inst_77868);

(statearr_77995[(18)] = inst_77869);

return statearr_77995;
})();
var statearr_77996_78050 = state_77944__$1;
(statearr_77996_78050[(2)] = null);

(statearr_77996_78050[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (18))){
var inst_77886 = (state_77944[(2)]);
var state_77944__$1 = state_77944;
var statearr_77997_78051 = state_77944__$1;
(statearr_77997_78051[(2)] = inst_77886);

(statearr_77997_78051[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (37))){
var state_77944__$1 = state_77944;
var statearr_77998_78052 = state_77944__$1;
(statearr_77998_78052[(2)] = null);

(statearr_77998_78052[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77945 === (8))){
var inst_77846 = (state_77944[(8)]);
var inst_77864 = cljs.core.apply.call(null,cljs.core.hash_map,inst_77846);
var state_77944__$1 = state_77944;
var statearr_77999_78053 = state_77944__$1;
(statearr_77999_78053[(2)] = inst_77864);

(statearr_77999_78053[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___78007,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__38195__auto__,c__38309__auto___78007,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__38196__auto__ = null;
var cljs$core$async$mix_$_state_machine__38196__auto____0 = (function (){
var statearr_78003 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78003[(0)] = cljs$core$async$mix_$_state_machine__38196__auto__);

(statearr_78003[(1)] = (1));

return statearr_78003;
});
var cljs$core$async$mix_$_state_machine__38196__auto____1 = (function (state_77944){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_77944);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e78004){if((e78004 instanceof Object)){
var ex__38199__auto__ = e78004;
var statearr_78005_78054 = state_77944;
(statearr_78005_78054[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_77944);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78004;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78055 = state_77944;
state_77944 = G__78055;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__38196__auto__ = function(state_77944){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__38196__auto____1.call(this,state_77944);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__38196__auto____0;
cljs$core$async$mix_$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__38196__auto____1;
return cljs$core$async$mix_$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___78007,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__38311__auto__ = (function (){var statearr_78006 = f__38310__auto__.call(null);
(statearr_78006[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___78007);

return statearr_78006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___78007,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args78056 = [];
var len__10640__auto___78059 = arguments.length;
var i__10641__auto___78060 = (0);
while(true){
if((i__10641__auto___78060 < len__10640__auto___78059)){
args78056.push((arguments[i__10641__auto___78060]));

var G__78061 = (i__10641__auto___78060 + (1));
i__10641__auto___78060 = G__78061;
continue;
} else {
}
break;
}

var G__78058 = args78056.length;
switch (G__78058) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78056.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args78064 = [];
var len__10640__auto___78189 = arguments.length;
var i__10641__auto___78190 = (0);
while(true){
if((i__10641__auto___78190 < len__10640__auto___78189)){
args78064.push((arguments[i__10641__auto___78190]));

var G__78191 = (i__10641__auto___78190 + (1));
i__10641__auto___78190 = G__78191;
continue;
} else {
}
break;
}

var G__78066 = args78064.length;
switch (G__78066) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78064.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__9419__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__9419__auto__,mults){
return (function (p1__78063_SHARP_){
if(cljs.core.truth_(p1__78063_SHARP_.call(null,topic))){
return p1__78063_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__78063_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__9419__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async78067 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async78067 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta78068){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta78068 = meta78068;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async78067.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_78069,meta78068__$1){
var self__ = this;
var _78069__$1 = this;
return (new cljs.core.async.t_cljs$core$async78067(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta78068__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async78067.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_78069){
var self__ = this;
var _78069__$1 = this;
return self__.meta78068;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async78067.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78067.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async78067.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78067.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async78067.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6738__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6738__auto__)){
var m = temp__6738__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async78067.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async78067.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async78067.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta78068","meta78068",-2085656581,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async78067.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async78067.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async78067";

cljs.core.async.t_cljs$core$async78067.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async78067");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async78067 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async78067(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta78068){
return (new cljs.core.async.t_cljs$core$async78067(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta78068));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async78067(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38309__auto___78193 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___78193,mults,ensure_mult,p){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___78193,mults,ensure_mult,p){
return (function (state_78141){
var state_val_78142 = (state_78141[(1)]);
if((state_val_78142 === (7))){
var inst_78137 = (state_78141[(2)]);
var state_78141__$1 = state_78141;
var statearr_78143_78194 = state_78141__$1;
(statearr_78143_78194[(2)] = inst_78137);

(statearr_78143_78194[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (20))){
var state_78141__$1 = state_78141;
var statearr_78144_78195 = state_78141__$1;
(statearr_78144_78195[(2)] = null);

(statearr_78144_78195[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (1))){
var state_78141__$1 = state_78141;
var statearr_78145_78196 = state_78141__$1;
(statearr_78145_78196[(2)] = null);

(statearr_78145_78196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (24))){
var inst_78120 = (state_78141[(7)]);
var inst_78129 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_78120);
var state_78141__$1 = state_78141;
var statearr_78146_78197 = state_78141__$1;
(statearr_78146_78197[(2)] = inst_78129);

(statearr_78146_78197[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (4))){
var inst_78072 = (state_78141[(8)]);
var inst_78072__$1 = (state_78141[(2)]);
var inst_78073 = (inst_78072__$1 == null);
var state_78141__$1 = (function (){var statearr_78147 = state_78141;
(statearr_78147[(8)] = inst_78072__$1);

return statearr_78147;
})();
if(cljs.core.truth_(inst_78073)){
var statearr_78148_78198 = state_78141__$1;
(statearr_78148_78198[(1)] = (5));

} else {
var statearr_78149_78199 = state_78141__$1;
(statearr_78149_78199[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (15))){
var inst_78114 = (state_78141[(2)]);
var state_78141__$1 = state_78141;
var statearr_78150_78200 = state_78141__$1;
(statearr_78150_78200[(2)] = inst_78114);

(statearr_78150_78200[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (21))){
var inst_78134 = (state_78141[(2)]);
var state_78141__$1 = (function (){var statearr_78151 = state_78141;
(statearr_78151[(9)] = inst_78134);

return statearr_78151;
})();
var statearr_78152_78201 = state_78141__$1;
(statearr_78152_78201[(2)] = null);

(statearr_78152_78201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (13))){
var inst_78096 = (state_78141[(10)]);
var inst_78098 = cljs.core.chunked_seq_QMARK_.call(null,inst_78096);
var state_78141__$1 = state_78141;
if(inst_78098){
var statearr_78153_78202 = state_78141__$1;
(statearr_78153_78202[(1)] = (16));

} else {
var statearr_78154_78203 = state_78141__$1;
(statearr_78154_78203[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (22))){
var inst_78126 = (state_78141[(2)]);
var state_78141__$1 = state_78141;
if(cljs.core.truth_(inst_78126)){
var statearr_78155_78204 = state_78141__$1;
(statearr_78155_78204[(1)] = (23));

} else {
var statearr_78156_78205 = state_78141__$1;
(statearr_78156_78205[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (6))){
var inst_78122 = (state_78141[(11)]);
var inst_78072 = (state_78141[(8)]);
var inst_78120 = (state_78141[(7)]);
var inst_78120__$1 = topic_fn.call(null,inst_78072);
var inst_78121 = cljs.core.deref.call(null,mults);
var inst_78122__$1 = cljs.core.get.call(null,inst_78121,inst_78120__$1);
var state_78141__$1 = (function (){var statearr_78157 = state_78141;
(statearr_78157[(11)] = inst_78122__$1);

(statearr_78157[(7)] = inst_78120__$1);

return statearr_78157;
})();
if(cljs.core.truth_(inst_78122__$1)){
var statearr_78158_78206 = state_78141__$1;
(statearr_78158_78206[(1)] = (19));

} else {
var statearr_78159_78207 = state_78141__$1;
(statearr_78159_78207[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (25))){
var inst_78131 = (state_78141[(2)]);
var state_78141__$1 = state_78141;
var statearr_78160_78208 = state_78141__$1;
(statearr_78160_78208[(2)] = inst_78131);

(statearr_78160_78208[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (17))){
var inst_78096 = (state_78141[(10)]);
var inst_78105 = cljs.core.first.call(null,inst_78096);
var inst_78106 = cljs.core.async.muxch_STAR_.call(null,inst_78105);
var inst_78107 = cljs.core.async.close_BANG_.call(null,inst_78106);
var inst_78108 = cljs.core.next.call(null,inst_78096);
var inst_78082 = inst_78108;
var inst_78083 = null;
var inst_78084 = (0);
var inst_78085 = (0);
var state_78141__$1 = (function (){var statearr_78161 = state_78141;
(statearr_78161[(12)] = inst_78084);

(statearr_78161[(13)] = inst_78107);

(statearr_78161[(14)] = inst_78082);

(statearr_78161[(15)] = inst_78085);

(statearr_78161[(16)] = inst_78083);

return statearr_78161;
})();
var statearr_78162_78209 = state_78141__$1;
(statearr_78162_78209[(2)] = null);

(statearr_78162_78209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (3))){
var inst_78139 = (state_78141[(2)]);
var state_78141__$1 = state_78141;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78141__$1,inst_78139);
} else {
if((state_val_78142 === (12))){
var inst_78116 = (state_78141[(2)]);
var state_78141__$1 = state_78141;
var statearr_78163_78210 = state_78141__$1;
(statearr_78163_78210[(2)] = inst_78116);

(statearr_78163_78210[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (2))){
var state_78141__$1 = state_78141;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78141__$1,(4),ch);
} else {
if((state_val_78142 === (23))){
var state_78141__$1 = state_78141;
var statearr_78164_78211 = state_78141__$1;
(statearr_78164_78211[(2)] = null);

(statearr_78164_78211[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (19))){
var inst_78122 = (state_78141[(11)]);
var inst_78072 = (state_78141[(8)]);
var inst_78124 = cljs.core.async.muxch_STAR_.call(null,inst_78122);
var state_78141__$1 = state_78141;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78141__$1,(22),inst_78124,inst_78072);
} else {
if((state_val_78142 === (11))){
var inst_78082 = (state_78141[(14)]);
var inst_78096 = (state_78141[(10)]);
var inst_78096__$1 = cljs.core.seq.call(null,inst_78082);
var state_78141__$1 = (function (){var statearr_78165 = state_78141;
(statearr_78165[(10)] = inst_78096__$1);

return statearr_78165;
})();
if(inst_78096__$1){
var statearr_78166_78212 = state_78141__$1;
(statearr_78166_78212[(1)] = (13));

} else {
var statearr_78167_78213 = state_78141__$1;
(statearr_78167_78213[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (9))){
var inst_78118 = (state_78141[(2)]);
var state_78141__$1 = state_78141;
var statearr_78168_78214 = state_78141__$1;
(statearr_78168_78214[(2)] = inst_78118);

(statearr_78168_78214[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (5))){
var inst_78079 = cljs.core.deref.call(null,mults);
var inst_78080 = cljs.core.vals.call(null,inst_78079);
var inst_78081 = cljs.core.seq.call(null,inst_78080);
var inst_78082 = inst_78081;
var inst_78083 = null;
var inst_78084 = (0);
var inst_78085 = (0);
var state_78141__$1 = (function (){var statearr_78169 = state_78141;
(statearr_78169[(12)] = inst_78084);

(statearr_78169[(14)] = inst_78082);

(statearr_78169[(15)] = inst_78085);

(statearr_78169[(16)] = inst_78083);

return statearr_78169;
})();
var statearr_78170_78215 = state_78141__$1;
(statearr_78170_78215[(2)] = null);

(statearr_78170_78215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (14))){
var state_78141__$1 = state_78141;
var statearr_78174_78216 = state_78141__$1;
(statearr_78174_78216[(2)] = null);

(statearr_78174_78216[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (16))){
var inst_78096 = (state_78141[(10)]);
var inst_78100 = cljs.core.chunk_first.call(null,inst_78096);
var inst_78101 = cljs.core.chunk_rest.call(null,inst_78096);
var inst_78102 = cljs.core.count.call(null,inst_78100);
var inst_78082 = inst_78101;
var inst_78083 = inst_78100;
var inst_78084 = inst_78102;
var inst_78085 = (0);
var state_78141__$1 = (function (){var statearr_78175 = state_78141;
(statearr_78175[(12)] = inst_78084);

(statearr_78175[(14)] = inst_78082);

(statearr_78175[(15)] = inst_78085);

(statearr_78175[(16)] = inst_78083);

return statearr_78175;
})();
var statearr_78176_78217 = state_78141__$1;
(statearr_78176_78217[(2)] = null);

(statearr_78176_78217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (10))){
var inst_78084 = (state_78141[(12)]);
var inst_78082 = (state_78141[(14)]);
var inst_78085 = (state_78141[(15)]);
var inst_78083 = (state_78141[(16)]);
var inst_78090 = cljs.core._nth.call(null,inst_78083,inst_78085);
var inst_78091 = cljs.core.async.muxch_STAR_.call(null,inst_78090);
var inst_78092 = cljs.core.async.close_BANG_.call(null,inst_78091);
var inst_78093 = (inst_78085 + (1));
var tmp78171 = inst_78084;
var tmp78172 = inst_78082;
var tmp78173 = inst_78083;
var inst_78082__$1 = tmp78172;
var inst_78083__$1 = tmp78173;
var inst_78084__$1 = tmp78171;
var inst_78085__$1 = inst_78093;
var state_78141__$1 = (function (){var statearr_78177 = state_78141;
(statearr_78177[(12)] = inst_78084__$1);

(statearr_78177[(14)] = inst_78082__$1);

(statearr_78177[(17)] = inst_78092);

(statearr_78177[(15)] = inst_78085__$1);

(statearr_78177[(16)] = inst_78083__$1);

return statearr_78177;
})();
var statearr_78178_78218 = state_78141__$1;
(statearr_78178_78218[(2)] = null);

(statearr_78178_78218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (18))){
var inst_78111 = (state_78141[(2)]);
var state_78141__$1 = state_78141;
var statearr_78179_78219 = state_78141__$1;
(statearr_78179_78219[(2)] = inst_78111);

(statearr_78179_78219[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78142 === (8))){
var inst_78084 = (state_78141[(12)]);
var inst_78085 = (state_78141[(15)]);
var inst_78087 = (inst_78085 < inst_78084);
var inst_78088 = inst_78087;
var state_78141__$1 = state_78141;
if(cljs.core.truth_(inst_78088)){
var statearr_78180_78220 = state_78141__$1;
(statearr_78180_78220[(1)] = (10));

} else {
var statearr_78181_78221 = state_78141__$1;
(statearr_78181_78221[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___78193,mults,ensure_mult,p))
;
return ((function (switch__38195__auto__,c__38309__auto___78193,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_78185 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78185[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_78185[(1)] = (1));

return statearr_78185;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_78141){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_78141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e78186){if((e78186 instanceof Object)){
var ex__38199__auto__ = e78186;
var statearr_78187_78222 = state_78141;
(statearr_78187_78222[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78141);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78186;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78223 = state_78141;
state_78141 = G__78223;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_78141){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_78141);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___78193,mults,ensure_mult,p))
})();
var state__38311__auto__ = (function (){var statearr_78188 = f__38310__auto__.call(null);
(statearr_78188[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___78193);

return statearr_78188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___78193,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args78224 = [];
var len__10640__auto___78227 = arguments.length;
var i__10641__auto___78228 = (0);
while(true){
if((i__10641__auto___78228 < len__10640__auto___78227)){
args78224.push((arguments[i__10641__auto___78228]));

var G__78229 = (i__10641__auto___78228 + (1));
i__10641__auto___78228 = G__78229;
continue;
} else {
}
break;
}

var G__78226 = args78224.length;
switch (G__78226) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78224.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args78231 = [];
var len__10640__auto___78234 = arguments.length;
var i__10641__auto___78235 = (0);
while(true){
if((i__10641__auto___78235 < len__10640__auto___78234)){
args78231.push((arguments[i__10641__auto___78235]));

var G__78236 = (i__10641__auto___78235 + (1));
i__10641__auto___78235 = G__78236;
continue;
} else {
}
break;
}

var G__78233 = args78231.length;
switch (G__78233) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78231.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args78238 = [];
var len__10640__auto___78309 = arguments.length;
var i__10641__auto___78310 = (0);
while(true){
if((i__10641__auto___78310 < len__10640__auto___78309)){
args78238.push((arguments[i__10641__auto___78310]));

var G__78311 = (i__10641__auto___78310 + (1));
i__10641__auto___78310 = G__78311;
continue;
} else {
}
break;
}

var G__78240 = args78238.length;
switch (G__78240) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78238.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__38309__auto___78313 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___78313,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___78313,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_78279){
var state_val_78280 = (state_78279[(1)]);
if((state_val_78280 === (7))){
var state_78279__$1 = state_78279;
var statearr_78281_78314 = state_78279__$1;
(statearr_78281_78314[(2)] = null);

(statearr_78281_78314[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (1))){
var state_78279__$1 = state_78279;
var statearr_78282_78315 = state_78279__$1;
(statearr_78282_78315[(2)] = null);

(statearr_78282_78315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (4))){
var inst_78243 = (state_78279[(7)]);
var inst_78245 = (inst_78243 < cnt);
var state_78279__$1 = state_78279;
if(cljs.core.truth_(inst_78245)){
var statearr_78283_78316 = state_78279__$1;
(statearr_78283_78316[(1)] = (6));

} else {
var statearr_78284_78317 = state_78279__$1;
(statearr_78284_78317[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (15))){
var inst_78275 = (state_78279[(2)]);
var state_78279__$1 = state_78279;
var statearr_78285_78318 = state_78279__$1;
(statearr_78285_78318[(2)] = inst_78275);

(statearr_78285_78318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (13))){
var inst_78268 = cljs.core.async.close_BANG_.call(null,out);
var state_78279__$1 = state_78279;
var statearr_78286_78319 = state_78279__$1;
(statearr_78286_78319[(2)] = inst_78268);

(statearr_78286_78319[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (6))){
var state_78279__$1 = state_78279;
var statearr_78287_78320 = state_78279__$1;
(statearr_78287_78320[(2)] = null);

(statearr_78287_78320[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (3))){
var inst_78277 = (state_78279[(2)]);
var state_78279__$1 = state_78279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78279__$1,inst_78277);
} else {
if((state_val_78280 === (12))){
var inst_78265 = (state_78279[(8)]);
var inst_78265__$1 = (state_78279[(2)]);
var inst_78266 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_78265__$1);
var state_78279__$1 = (function (){var statearr_78288 = state_78279;
(statearr_78288[(8)] = inst_78265__$1);

return statearr_78288;
})();
if(cljs.core.truth_(inst_78266)){
var statearr_78289_78321 = state_78279__$1;
(statearr_78289_78321[(1)] = (13));

} else {
var statearr_78290_78322 = state_78279__$1;
(statearr_78290_78322[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (2))){
var inst_78242 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_78243 = (0);
var state_78279__$1 = (function (){var statearr_78291 = state_78279;
(statearr_78291[(9)] = inst_78242);

(statearr_78291[(7)] = inst_78243);

return statearr_78291;
})();
var statearr_78292_78323 = state_78279__$1;
(statearr_78292_78323[(2)] = null);

(statearr_78292_78323[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (11))){
var inst_78243 = (state_78279[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_78279,(10),Object,null,(9));
var inst_78252 = chs__$1.call(null,inst_78243);
var inst_78253 = done.call(null,inst_78243);
var inst_78254 = cljs.core.async.take_BANG_.call(null,inst_78252,inst_78253);
var state_78279__$1 = state_78279;
var statearr_78293_78324 = state_78279__$1;
(statearr_78293_78324[(2)] = inst_78254);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78279__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (9))){
var inst_78243 = (state_78279[(7)]);
var inst_78256 = (state_78279[(2)]);
var inst_78257 = (inst_78243 + (1));
var inst_78243__$1 = inst_78257;
var state_78279__$1 = (function (){var statearr_78294 = state_78279;
(statearr_78294[(10)] = inst_78256);

(statearr_78294[(7)] = inst_78243__$1);

return statearr_78294;
})();
var statearr_78295_78325 = state_78279__$1;
(statearr_78295_78325[(2)] = null);

(statearr_78295_78325[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (5))){
var inst_78263 = (state_78279[(2)]);
var state_78279__$1 = (function (){var statearr_78296 = state_78279;
(statearr_78296[(11)] = inst_78263);

return statearr_78296;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78279__$1,(12),dchan);
} else {
if((state_val_78280 === (14))){
var inst_78265 = (state_78279[(8)]);
var inst_78270 = cljs.core.apply.call(null,f,inst_78265);
var state_78279__$1 = state_78279;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78279__$1,(16),out,inst_78270);
} else {
if((state_val_78280 === (16))){
var inst_78272 = (state_78279[(2)]);
var state_78279__$1 = (function (){var statearr_78297 = state_78279;
(statearr_78297[(12)] = inst_78272);

return statearr_78297;
})();
var statearr_78298_78326 = state_78279__$1;
(statearr_78298_78326[(2)] = null);

(statearr_78298_78326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (10))){
var inst_78247 = (state_78279[(2)]);
var inst_78248 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_78279__$1 = (function (){var statearr_78299 = state_78279;
(statearr_78299[(13)] = inst_78247);

return statearr_78299;
})();
var statearr_78300_78327 = state_78279__$1;
(statearr_78300_78327[(2)] = inst_78248);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78279__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78280 === (8))){
var inst_78261 = (state_78279[(2)]);
var state_78279__$1 = state_78279;
var statearr_78301_78328 = state_78279__$1;
(statearr_78301_78328[(2)] = inst_78261);

(statearr_78301_78328[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___78313,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__38195__auto__,c__38309__auto___78313,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_78305 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78305[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_78305[(1)] = (1));

return statearr_78305;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_78279){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_78279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e78306){if((e78306 instanceof Object)){
var ex__38199__auto__ = e78306;
var statearr_78307_78329 = state_78279;
(statearr_78307_78329[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78279);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78306;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78330 = state_78279;
state_78279 = G__78330;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_78279){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_78279);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___78313,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__38311__auto__ = (function (){var statearr_78308 = f__38310__auto__.call(null);
(statearr_78308[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___78313);

return statearr_78308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___78313,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args78332 = [];
var len__10640__auto___78390 = arguments.length;
var i__10641__auto___78391 = (0);
while(true){
if((i__10641__auto___78391 < len__10640__auto___78390)){
args78332.push((arguments[i__10641__auto___78391]));

var G__78392 = (i__10641__auto___78391 + (1));
i__10641__auto___78391 = G__78392;
continue;
} else {
}
break;
}

var G__78334 = args78332.length;
switch (G__78334) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78332.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___78394 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___78394,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___78394,out){
return (function (state_78366){
var state_val_78367 = (state_78366[(1)]);
if((state_val_78367 === (7))){
var inst_78346 = (state_78366[(7)]);
var inst_78345 = (state_78366[(8)]);
var inst_78345__$1 = (state_78366[(2)]);
var inst_78346__$1 = cljs.core.nth.call(null,inst_78345__$1,(0),null);
var inst_78347 = cljs.core.nth.call(null,inst_78345__$1,(1),null);
var inst_78348 = (inst_78346__$1 == null);
var state_78366__$1 = (function (){var statearr_78368 = state_78366;
(statearr_78368[(7)] = inst_78346__$1);

(statearr_78368[(9)] = inst_78347);

(statearr_78368[(8)] = inst_78345__$1);

return statearr_78368;
})();
if(cljs.core.truth_(inst_78348)){
var statearr_78369_78395 = state_78366__$1;
(statearr_78369_78395[(1)] = (8));

} else {
var statearr_78370_78396 = state_78366__$1;
(statearr_78370_78396[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78367 === (1))){
var inst_78335 = cljs.core.vec.call(null,chs);
var inst_78336 = inst_78335;
var state_78366__$1 = (function (){var statearr_78371 = state_78366;
(statearr_78371[(10)] = inst_78336);

return statearr_78371;
})();
var statearr_78372_78397 = state_78366__$1;
(statearr_78372_78397[(2)] = null);

(statearr_78372_78397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78367 === (4))){
var inst_78336 = (state_78366[(10)]);
var state_78366__$1 = state_78366;
return cljs.core.async.ioc_alts_BANG_.call(null,state_78366__$1,(7),inst_78336);
} else {
if((state_val_78367 === (6))){
var inst_78362 = (state_78366[(2)]);
var state_78366__$1 = state_78366;
var statearr_78373_78398 = state_78366__$1;
(statearr_78373_78398[(2)] = inst_78362);

(statearr_78373_78398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78367 === (3))){
var inst_78364 = (state_78366[(2)]);
var state_78366__$1 = state_78366;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78366__$1,inst_78364);
} else {
if((state_val_78367 === (2))){
var inst_78336 = (state_78366[(10)]);
var inst_78338 = cljs.core.count.call(null,inst_78336);
var inst_78339 = (inst_78338 > (0));
var state_78366__$1 = state_78366;
if(cljs.core.truth_(inst_78339)){
var statearr_78375_78399 = state_78366__$1;
(statearr_78375_78399[(1)] = (4));

} else {
var statearr_78376_78400 = state_78366__$1;
(statearr_78376_78400[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78367 === (11))){
var inst_78336 = (state_78366[(10)]);
var inst_78355 = (state_78366[(2)]);
var tmp78374 = inst_78336;
var inst_78336__$1 = tmp78374;
var state_78366__$1 = (function (){var statearr_78377 = state_78366;
(statearr_78377[(11)] = inst_78355);

(statearr_78377[(10)] = inst_78336__$1);

return statearr_78377;
})();
var statearr_78378_78401 = state_78366__$1;
(statearr_78378_78401[(2)] = null);

(statearr_78378_78401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78367 === (9))){
var inst_78346 = (state_78366[(7)]);
var state_78366__$1 = state_78366;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78366__$1,(11),out,inst_78346);
} else {
if((state_val_78367 === (5))){
var inst_78360 = cljs.core.async.close_BANG_.call(null,out);
var state_78366__$1 = state_78366;
var statearr_78379_78402 = state_78366__$1;
(statearr_78379_78402[(2)] = inst_78360);

(statearr_78379_78402[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78367 === (10))){
var inst_78358 = (state_78366[(2)]);
var state_78366__$1 = state_78366;
var statearr_78380_78403 = state_78366__$1;
(statearr_78380_78403[(2)] = inst_78358);

(statearr_78380_78403[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78367 === (8))){
var inst_78346 = (state_78366[(7)]);
var inst_78336 = (state_78366[(10)]);
var inst_78347 = (state_78366[(9)]);
var inst_78345 = (state_78366[(8)]);
var inst_78350 = (function (){var cs = inst_78336;
var vec__78341 = inst_78345;
var v = inst_78346;
var c = inst_78347;
return ((function (cs,vec__78341,v,c,inst_78346,inst_78336,inst_78347,inst_78345,state_val_78367,c__38309__auto___78394,out){
return (function (p1__78331_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__78331_SHARP_);
});
;})(cs,vec__78341,v,c,inst_78346,inst_78336,inst_78347,inst_78345,state_val_78367,c__38309__auto___78394,out))
})();
var inst_78351 = cljs.core.filterv.call(null,inst_78350,inst_78336);
var inst_78336__$1 = inst_78351;
var state_78366__$1 = (function (){var statearr_78381 = state_78366;
(statearr_78381[(10)] = inst_78336__$1);

return statearr_78381;
})();
var statearr_78382_78404 = state_78366__$1;
(statearr_78382_78404[(2)] = null);

(statearr_78382_78404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___78394,out))
;
return ((function (switch__38195__auto__,c__38309__auto___78394,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_78386 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78386[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_78386[(1)] = (1));

return statearr_78386;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_78366){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_78366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e78387){if((e78387 instanceof Object)){
var ex__38199__auto__ = e78387;
var statearr_78388_78405 = state_78366;
(statearr_78388_78405[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78366);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78387;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78406 = state_78366;
state_78366 = G__78406;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_78366){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_78366);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___78394,out))
})();
var state__38311__auto__ = (function (){var statearr_78389 = f__38310__auto__.call(null);
(statearr_78389[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___78394);

return statearr_78389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___78394,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args78407 = [];
var len__10640__auto___78456 = arguments.length;
var i__10641__auto___78457 = (0);
while(true){
if((i__10641__auto___78457 < len__10640__auto___78456)){
args78407.push((arguments[i__10641__auto___78457]));

var G__78458 = (i__10641__auto___78457 + (1));
i__10641__auto___78457 = G__78458;
continue;
} else {
}
break;
}

var G__78409 = args78407.length;
switch (G__78409) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78407.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___78460 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___78460,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___78460,out){
return (function (state_78433){
var state_val_78434 = (state_78433[(1)]);
if((state_val_78434 === (7))){
var inst_78415 = (state_78433[(7)]);
var inst_78415__$1 = (state_78433[(2)]);
var inst_78416 = (inst_78415__$1 == null);
var inst_78417 = cljs.core.not.call(null,inst_78416);
var state_78433__$1 = (function (){var statearr_78435 = state_78433;
(statearr_78435[(7)] = inst_78415__$1);

return statearr_78435;
})();
if(inst_78417){
var statearr_78436_78461 = state_78433__$1;
(statearr_78436_78461[(1)] = (8));

} else {
var statearr_78437_78462 = state_78433__$1;
(statearr_78437_78462[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78434 === (1))){
var inst_78410 = (0);
var state_78433__$1 = (function (){var statearr_78438 = state_78433;
(statearr_78438[(8)] = inst_78410);

return statearr_78438;
})();
var statearr_78439_78463 = state_78433__$1;
(statearr_78439_78463[(2)] = null);

(statearr_78439_78463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78434 === (4))){
var state_78433__$1 = state_78433;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78433__$1,(7),ch);
} else {
if((state_val_78434 === (6))){
var inst_78428 = (state_78433[(2)]);
var state_78433__$1 = state_78433;
var statearr_78440_78464 = state_78433__$1;
(statearr_78440_78464[(2)] = inst_78428);

(statearr_78440_78464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78434 === (3))){
var inst_78430 = (state_78433[(2)]);
var inst_78431 = cljs.core.async.close_BANG_.call(null,out);
var state_78433__$1 = (function (){var statearr_78441 = state_78433;
(statearr_78441[(9)] = inst_78430);

return statearr_78441;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78433__$1,inst_78431);
} else {
if((state_val_78434 === (2))){
var inst_78410 = (state_78433[(8)]);
var inst_78412 = (inst_78410 < n);
var state_78433__$1 = state_78433;
if(cljs.core.truth_(inst_78412)){
var statearr_78442_78465 = state_78433__$1;
(statearr_78442_78465[(1)] = (4));

} else {
var statearr_78443_78466 = state_78433__$1;
(statearr_78443_78466[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78434 === (11))){
var inst_78410 = (state_78433[(8)]);
var inst_78420 = (state_78433[(2)]);
var inst_78421 = (inst_78410 + (1));
var inst_78410__$1 = inst_78421;
var state_78433__$1 = (function (){var statearr_78444 = state_78433;
(statearr_78444[(10)] = inst_78420);

(statearr_78444[(8)] = inst_78410__$1);

return statearr_78444;
})();
var statearr_78445_78467 = state_78433__$1;
(statearr_78445_78467[(2)] = null);

(statearr_78445_78467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78434 === (9))){
var state_78433__$1 = state_78433;
var statearr_78446_78468 = state_78433__$1;
(statearr_78446_78468[(2)] = null);

(statearr_78446_78468[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78434 === (5))){
var state_78433__$1 = state_78433;
var statearr_78447_78469 = state_78433__$1;
(statearr_78447_78469[(2)] = null);

(statearr_78447_78469[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78434 === (10))){
var inst_78425 = (state_78433[(2)]);
var state_78433__$1 = state_78433;
var statearr_78448_78470 = state_78433__$1;
(statearr_78448_78470[(2)] = inst_78425);

(statearr_78448_78470[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78434 === (8))){
var inst_78415 = (state_78433[(7)]);
var state_78433__$1 = state_78433;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78433__$1,(11),out,inst_78415);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___78460,out))
;
return ((function (switch__38195__auto__,c__38309__auto___78460,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_78452 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_78452[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_78452[(1)] = (1));

return statearr_78452;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_78433){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_78433);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e78453){if((e78453 instanceof Object)){
var ex__38199__auto__ = e78453;
var statearr_78454_78471 = state_78433;
(statearr_78454_78471[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78433);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78453;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78472 = state_78433;
state_78433 = G__78472;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_78433){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_78433);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___78460,out))
})();
var state__38311__auto__ = (function (){var statearr_78455 = f__38310__auto__.call(null);
(statearr_78455[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___78460);

return statearr_78455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___78460,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async78480 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async78480 = (function (f,ch,meta78481){
this.f = f;
this.ch = ch;
this.meta78481 = meta78481;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async78480.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_78482,meta78481__$1){
var self__ = this;
var _78482__$1 = this;
return (new cljs.core.async.t_cljs$core$async78480(self__.f,self__.ch,meta78481__$1));
});

cljs.core.async.t_cljs$core$async78480.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_78482){
var self__ = this;
var _78482__$1 = this;
return self__.meta78481;
});

cljs.core.async.t_cljs$core$async78480.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78480.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async78480.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async78480.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78480.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async78483 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async78483 = (function (f,ch,meta78481,_,fn1,meta78484){
this.f = f;
this.ch = ch;
this.meta78481 = meta78481;
this._ = _;
this.fn1 = fn1;
this.meta78484 = meta78484;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async78483.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_78485,meta78484__$1){
var self__ = this;
var _78485__$1 = this;
return (new cljs.core.async.t_cljs$core$async78483(self__.f,self__.ch,self__.meta78481,self__._,self__.fn1,meta78484__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async78483.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_78485){
var self__ = this;
var _78485__$1 = this;
return self__.meta78484;
});})(___$1))
;

cljs.core.async.t_cljs$core$async78483.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78483.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async78483.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async78483.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__78473_SHARP_){
return f1.call(null,(((p1__78473_SHARP_ == null))?null:self__.f.call(null,p1__78473_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async78483.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta78481","meta78481",-2012714592,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async78480","cljs.core.async/t_cljs$core$async78480",-993966001,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta78484","meta78484",338020876,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async78483.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async78483.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async78483";

cljs.core.async.t_cljs$core$async78483.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async78483");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async78483 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async78483(f__$1,ch__$1,meta78481__$1,___$2,fn1__$1,meta78484){
return (new cljs.core.async.t_cljs$core$async78483(f__$1,ch__$1,meta78481__$1,___$2,fn1__$1,meta78484));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async78483(self__.f,self__.ch,self__.meta78481,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__9407__auto__ = ret;
if(cljs.core.truth_(and__9407__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__9407__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async78480.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78480.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async78480.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta78481","meta78481",-2012714592,null)], null);
});

cljs.core.async.t_cljs$core$async78480.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async78480.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async78480";

cljs.core.async.t_cljs$core$async78480.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async78480");
});

cljs.core.async.__GT_t_cljs$core$async78480 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async78480(f__$1,ch__$1,meta78481){
return (new cljs.core.async.t_cljs$core$async78480(f__$1,ch__$1,meta78481));
});

}

return (new cljs.core.async.t_cljs$core$async78480(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async78489 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async78489 = (function (f,ch,meta78490){
this.f = f;
this.ch = ch;
this.meta78490 = meta78490;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async78489.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_78491,meta78490__$1){
var self__ = this;
var _78491__$1 = this;
return (new cljs.core.async.t_cljs$core$async78489(self__.f,self__.ch,meta78490__$1));
});

cljs.core.async.t_cljs$core$async78489.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_78491){
var self__ = this;
var _78491__$1 = this;
return self__.meta78490;
});

cljs.core.async.t_cljs$core$async78489.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78489.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async78489.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78489.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async78489.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78489.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async78489.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta78490","meta78490",695592568,null)], null);
});

cljs.core.async.t_cljs$core$async78489.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async78489.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async78489";

cljs.core.async.t_cljs$core$async78489.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async78489");
});

cljs.core.async.__GT_t_cljs$core$async78489 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async78489(f__$1,ch__$1,meta78490){
return (new cljs.core.async.t_cljs$core$async78489(f__$1,ch__$1,meta78490));
});

}

return (new cljs.core.async.t_cljs$core$async78489(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async78495 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async78495 = (function (p,ch,meta78496){
this.p = p;
this.ch = ch;
this.meta78496 = meta78496;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async78495.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_78497,meta78496__$1){
var self__ = this;
var _78497__$1 = this;
return (new cljs.core.async.t_cljs$core$async78495(self__.p,self__.ch,meta78496__$1));
});

cljs.core.async.t_cljs$core$async78495.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_78497){
var self__ = this;
var _78497__$1 = this;
return self__.meta78496;
});

cljs.core.async.t_cljs$core$async78495.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78495.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async78495.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async78495.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78495.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async78495.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78495.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async78495.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta78496","meta78496",1987289764,null)], null);
});

cljs.core.async.t_cljs$core$async78495.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async78495.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async78495";

cljs.core.async.t_cljs$core$async78495.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async78495");
});

cljs.core.async.__GT_t_cljs$core$async78495 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async78495(p__$1,ch__$1,meta78496){
return (new cljs.core.async.t_cljs$core$async78495(p__$1,ch__$1,meta78496));
});

}

return (new cljs.core.async.t_cljs$core$async78495(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args78498 = [];
var len__10640__auto___78542 = arguments.length;
var i__10641__auto___78543 = (0);
while(true){
if((i__10641__auto___78543 < len__10640__auto___78542)){
args78498.push((arguments[i__10641__auto___78543]));

var G__78544 = (i__10641__auto___78543 + (1));
i__10641__auto___78543 = G__78544;
continue;
} else {
}
break;
}

var G__78500 = args78498.length;
switch (G__78500) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78498.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___78546 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___78546,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___78546,out){
return (function (state_78521){
var state_val_78522 = (state_78521[(1)]);
if((state_val_78522 === (7))){
var inst_78517 = (state_78521[(2)]);
var state_78521__$1 = state_78521;
var statearr_78523_78547 = state_78521__$1;
(statearr_78523_78547[(2)] = inst_78517);

(statearr_78523_78547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78522 === (1))){
var state_78521__$1 = state_78521;
var statearr_78524_78548 = state_78521__$1;
(statearr_78524_78548[(2)] = null);

(statearr_78524_78548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78522 === (4))){
var inst_78503 = (state_78521[(7)]);
var inst_78503__$1 = (state_78521[(2)]);
var inst_78504 = (inst_78503__$1 == null);
var state_78521__$1 = (function (){var statearr_78525 = state_78521;
(statearr_78525[(7)] = inst_78503__$1);

return statearr_78525;
})();
if(cljs.core.truth_(inst_78504)){
var statearr_78526_78549 = state_78521__$1;
(statearr_78526_78549[(1)] = (5));

} else {
var statearr_78527_78550 = state_78521__$1;
(statearr_78527_78550[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78522 === (6))){
var inst_78503 = (state_78521[(7)]);
var inst_78508 = p.call(null,inst_78503);
var state_78521__$1 = state_78521;
if(cljs.core.truth_(inst_78508)){
var statearr_78528_78551 = state_78521__$1;
(statearr_78528_78551[(1)] = (8));

} else {
var statearr_78529_78552 = state_78521__$1;
(statearr_78529_78552[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78522 === (3))){
var inst_78519 = (state_78521[(2)]);
var state_78521__$1 = state_78521;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78521__$1,inst_78519);
} else {
if((state_val_78522 === (2))){
var state_78521__$1 = state_78521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78521__$1,(4),ch);
} else {
if((state_val_78522 === (11))){
var inst_78511 = (state_78521[(2)]);
var state_78521__$1 = state_78521;
var statearr_78530_78553 = state_78521__$1;
(statearr_78530_78553[(2)] = inst_78511);

(statearr_78530_78553[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78522 === (9))){
var state_78521__$1 = state_78521;
var statearr_78531_78554 = state_78521__$1;
(statearr_78531_78554[(2)] = null);

(statearr_78531_78554[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78522 === (5))){
var inst_78506 = cljs.core.async.close_BANG_.call(null,out);
var state_78521__$1 = state_78521;
var statearr_78532_78555 = state_78521__$1;
(statearr_78532_78555[(2)] = inst_78506);

(statearr_78532_78555[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78522 === (10))){
var inst_78514 = (state_78521[(2)]);
var state_78521__$1 = (function (){var statearr_78533 = state_78521;
(statearr_78533[(8)] = inst_78514);

return statearr_78533;
})();
var statearr_78534_78556 = state_78521__$1;
(statearr_78534_78556[(2)] = null);

(statearr_78534_78556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78522 === (8))){
var inst_78503 = (state_78521[(7)]);
var state_78521__$1 = state_78521;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78521__$1,(11),out,inst_78503);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___78546,out))
;
return ((function (switch__38195__auto__,c__38309__auto___78546,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_78538 = [null,null,null,null,null,null,null,null,null];
(statearr_78538[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_78538[(1)] = (1));

return statearr_78538;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_78521){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_78521);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e78539){if((e78539 instanceof Object)){
var ex__38199__auto__ = e78539;
var statearr_78540_78557 = state_78521;
(statearr_78540_78557[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78521);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78539;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78558 = state_78521;
state_78521 = G__78558;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_78521){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_78521);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___78546,out))
})();
var state__38311__auto__ = (function (){var statearr_78541 = f__38310__auto__.call(null);
(statearr_78541[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___78546);

return statearr_78541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___78546,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args78559 = [];
var len__10640__auto___78562 = arguments.length;
var i__10641__auto___78563 = (0);
while(true){
if((i__10641__auto___78563 < len__10640__auto___78562)){
args78559.push((arguments[i__10641__auto___78563]));

var G__78564 = (i__10641__auto___78563 + (1));
i__10641__auto___78563 = G__78564;
continue;
} else {
}
break;
}

var G__78561 = args78559.length;
switch (G__78561) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78559.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__38309__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto__){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto__){
return (function (state_78731){
var state_val_78732 = (state_78731[(1)]);
if((state_val_78732 === (7))){
var inst_78727 = (state_78731[(2)]);
var state_78731__$1 = state_78731;
var statearr_78733_78774 = state_78731__$1;
(statearr_78733_78774[(2)] = inst_78727);

(statearr_78733_78774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (20))){
var inst_78697 = (state_78731[(7)]);
var inst_78708 = (state_78731[(2)]);
var inst_78709 = cljs.core.next.call(null,inst_78697);
var inst_78683 = inst_78709;
var inst_78684 = null;
var inst_78685 = (0);
var inst_78686 = (0);
var state_78731__$1 = (function (){var statearr_78734 = state_78731;
(statearr_78734[(8)] = inst_78686);

(statearr_78734[(9)] = inst_78683);

(statearr_78734[(10)] = inst_78685);

(statearr_78734[(11)] = inst_78708);

(statearr_78734[(12)] = inst_78684);

return statearr_78734;
})();
var statearr_78735_78775 = state_78731__$1;
(statearr_78735_78775[(2)] = null);

(statearr_78735_78775[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (1))){
var state_78731__$1 = state_78731;
var statearr_78736_78776 = state_78731__$1;
(statearr_78736_78776[(2)] = null);

(statearr_78736_78776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (4))){
var inst_78672 = (state_78731[(13)]);
var inst_78672__$1 = (state_78731[(2)]);
var inst_78673 = (inst_78672__$1 == null);
var state_78731__$1 = (function (){var statearr_78737 = state_78731;
(statearr_78737[(13)] = inst_78672__$1);

return statearr_78737;
})();
if(cljs.core.truth_(inst_78673)){
var statearr_78738_78777 = state_78731__$1;
(statearr_78738_78777[(1)] = (5));

} else {
var statearr_78739_78778 = state_78731__$1;
(statearr_78739_78778[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (15))){
var state_78731__$1 = state_78731;
var statearr_78743_78779 = state_78731__$1;
(statearr_78743_78779[(2)] = null);

(statearr_78743_78779[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (21))){
var state_78731__$1 = state_78731;
var statearr_78744_78780 = state_78731__$1;
(statearr_78744_78780[(2)] = null);

(statearr_78744_78780[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (13))){
var inst_78686 = (state_78731[(8)]);
var inst_78683 = (state_78731[(9)]);
var inst_78685 = (state_78731[(10)]);
var inst_78684 = (state_78731[(12)]);
var inst_78693 = (state_78731[(2)]);
var inst_78694 = (inst_78686 + (1));
var tmp78740 = inst_78683;
var tmp78741 = inst_78685;
var tmp78742 = inst_78684;
var inst_78683__$1 = tmp78740;
var inst_78684__$1 = tmp78742;
var inst_78685__$1 = tmp78741;
var inst_78686__$1 = inst_78694;
var state_78731__$1 = (function (){var statearr_78745 = state_78731;
(statearr_78745[(8)] = inst_78686__$1);

(statearr_78745[(14)] = inst_78693);

(statearr_78745[(9)] = inst_78683__$1);

(statearr_78745[(10)] = inst_78685__$1);

(statearr_78745[(12)] = inst_78684__$1);

return statearr_78745;
})();
var statearr_78746_78781 = state_78731__$1;
(statearr_78746_78781[(2)] = null);

(statearr_78746_78781[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (22))){
var state_78731__$1 = state_78731;
var statearr_78747_78782 = state_78731__$1;
(statearr_78747_78782[(2)] = null);

(statearr_78747_78782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (6))){
var inst_78672 = (state_78731[(13)]);
var inst_78681 = f.call(null,inst_78672);
var inst_78682 = cljs.core.seq.call(null,inst_78681);
var inst_78683 = inst_78682;
var inst_78684 = null;
var inst_78685 = (0);
var inst_78686 = (0);
var state_78731__$1 = (function (){var statearr_78748 = state_78731;
(statearr_78748[(8)] = inst_78686);

(statearr_78748[(9)] = inst_78683);

(statearr_78748[(10)] = inst_78685);

(statearr_78748[(12)] = inst_78684);

return statearr_78748;
})();
var statearr_78749_78783 = state_78731__$1;
(statearr_78749_78783[(2)] = null);

(statearr_78749_78783[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (17))){
var inst_78697 = (state_78731[(7)]);
var inst_78701 = cljs.core.chunk_first.call(null,inst_78697);
var inst_78702 = cljs.core.chunk_rest.call(null,inst_78697);
var inst_78703 = cljs.core.count.call(null,inst_78701);
var inst_78683 = inst_78702;
var inst_78684 = inst_78701;
var inst_78685 = inst_78703;
var inst_78686 = (0);
var state_78731__$1 = (function (){var statearr_78750 = state_78731;
(statearr_78750[(8)] = inst_78686);

(statearr_78750[(9)] = inst_78683);

(statearr_78750[(10)] = inst_78685);

(statearr_78750[(12)] = inst_78684);

return statearr_78750;
})();
var statearr_78751_78784 = state_78731__$1;
(statearr_78751_78784[(2)] = null);

(statearr_78751_78784[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (3))){
var inst_78729 = (state_78731[(2)]);
var state_78731__$1 = state_78731;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78731__$1,inst_78729);
} else {
if((state_val_78732 === (12))){
var inst_78717 = (state_78731[(2)]);
var state_78731__$1 = state_78731;
var statearr_78752_78785 = state_78731__$1;
(statearr_78752_78785[(2)] = inst_78717);

(statearr_78752_78785[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (2))){
var state_78731__$1 = state_78731;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78731__$1,(4),in$);
} else {
if((state_val_78732 === (23))){
var inst_78725 = (state_78731[(2)]);
var state_78731__$1 = state_78731;
var statearr_78753_78786 = state_78731__$1;
(statearr_78753_78786[(2)] = inst_78725);

(statearr_78753_78786[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (19))){
var inst_78712 = (state_78731[(2)]);
var state_78731__$1 = state_78731;
var statearr_78754_78787 = state_78731__$1;
(statearr_78754_78787[(2)] = inst_78712);

(statearr_78754_78787[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (11))){
var inst_78697 = (state_78731[(7)]);
var inst_78683 = (state_78731[(9)]);
var inst_78697__$1 = cljs.core.seq.call(null,inst_78683);
var state_78731__$1 = (function (){var statearr_78755 = state_78731;
(statearr_78755[(7)] = inst_78697__$1);

return statearr_78755;
})();
if(inst_78697__$1){
var statearr_78756_78788 = state_78731__$1;
(statearr_78756_78788[(1)] = (14));

} else {
var statearr_78757_78789 = state_78731__$1;
(statearr_78757_78789[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (9))){
var inst_78719 = (state_78731[(2)]);
var inst_78720 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_78731__$1 = (function (){var statearr_78758 = state_78731;
(statearr_78758[(15)] = inst_78719);

return statearr_78758;
})();
if(cljs.core.truth_(inst_78720)){
var statearr_78759_78790 = state_78731__$1;
(statearr_78759_78790[(1)] = (21));

} else {
var statearr_78760_78791 = state_78731__$1;
(statearr_78760_78791[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (5))){
var inst_78675 = cljs.core.async.close_BANG_.call(null,out);
var state_78731__$1 = state_78731;
var statearr_78761_78792 = state_78731__$1;
(statearr_78761_78792[(2)] = inst_78675);

(statearr_78761_78792[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (14))){
var inst_78697 = (state_78731[(7)]);
var inst_78699 = cljs.core.chunked_seq_QMARK_.call(null,inst_78697);
var state_78731__$1 = state_78731;
if(inst_78699){
var statearr_78762_78793 = state_78731__$1;
(statearr_78762_78793[(1)] = (17));

} else {
var statearr_78763_78794 = state_78731__$1;
(statearr_78763_78794[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (16))){
var inst_78715 = (state_78731[(2)]);
var state_78731__$1 = state_78731;
var statearr_78764_78795 = state_78731__$1;
(statearr_78764_78795[(2)] = inst_78715);

(statearr_78764_78795[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78732 === (10))){
var inst_78686 = (state_78731[(8)]);
var inst_78684 = (state_78731[(12)]);
var inst_78691 = cljs.core._nth.call(null,inst_78684,inst_78686);
var state_78731__$1 = state_78731;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78731__$1,(13),out,inst_78691);
} else {
if((state_val_78732 === (18))){
var inst_78697 = (state_78731[(7)]);
var inst_78706 = cljs.core.first.call(null,inst_78697);
var state_78731__$1 = state_78731;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78731__$1,(20),out,inst_78706);
} else {
if((state_val_78732 === (8))){
var inst_78686 = (state_78731[(8)]);
var inst_78685 = (state_78731[(10)]);
var inst_78688 = (inst_78686 < inst_78685);
var inst_78689 = inst_78688;
var state_78731__$1 = state_78731;
if(cljs.core.truth_(inst_78689)){
var statearr_78765_78796 = state_78731__$1;
(statearr_78765_78796[(1)] = (10));

} else {
var statearr_78766_78797 = state_78731__$1;
(statearr_78766_78797[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto__))
;
return ((function (switch__38195__auto__,c__38309__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____0 = (function (){
var statearr_78770 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78770[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__);

(statearr_78770[(1)] = (1));

return statearr_78770;
});
var cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____1 = (function (state_78731){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_78731);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e78771){if((e78771 instanceof Object)){
var ex__38199__auto__ = e78771;
var statearr_78772_78798 = state_78731;
(statearr_78772_78798[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78731);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78771;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78799 = state_78731;
state_78731 = G__78799;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__ = function(state_78731){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____1.call(this,state_78731);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__38196__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto__))
})();
var state__38311__auto__ = (function (){var statearr_78773 = f__38310__auto__.call(null);
(statearr_78773[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto__);

return statearr_78773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto__))
);

return c__38309__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args78800 = [];
var len__10640__auto___78803 = arguments.length;
var i__10641__auto___78804 = (0);
while(true){
if((i__10641__auto___78804 < len__10640__auto___78803)){
args78800.push((arguments[i__10641__auto___78804]));

var G__78805 = (i__10641__auto___78804 + (1));
i__10641__auto___78804 = G__78805;
continue;
} else {
}
break;
}

var G__78802 = args78800.length;
switch (G__78802) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78800.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args78807 = [];
var len__10640__auto___78810 = arguments.length;
var i__10641__auto___78811 = (0);
while(true){
if((i__10641__auto___78811 < len__10640__auto___78810)){
args78807.push((arguments[i__10641__auto___78811]));

var G__78812 = (i__10641__auto___78811 + (1));
i__10641__auto___78811 = G__78812;
continue;
} else {
}
break;
}

var G__78809 = args78807.length;
switch (G__78809) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78807.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args78814 = [];
var len__10640__auto___78865 = arguments.length;
var i__10641__auto___78866 = (0);
while(true){
if((i__10641__auto___78866 < len__10640__auto___78865)){
args78814.push((arguments[i__10641__auto___78866]));

var G__78867 = (i__10641__auto___78866 + (1));
i__10641__auto___78866 = G__78867;
continue;
} else {
}
break;
}

var G__78816 = args78814.length;
switch (G__78816) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78814.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___78869 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___78869,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___78869,out){
return (function (state_78840){
var state_val_78841 = (state_78840[(1)]);
if((state_val_78841 === (7))){
var inst_78835 = (state_78840[(2)]);
var state_78840__$1 = state_78840;
var statearr_78842_78870 = state_78840__$1;
(statearr_78842_78870[(2)] = inst_78835);

(statearr_78842_78870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78841 === (1))){
var inst_78817 = null;
var state_78840__$1 = (function (){var statearr_78843 = state_78840;
(statearr_78843[(7)] = inst_78817);

return statearr_78843;
})();
var statearr_78844_78871 = state_78840__$1;
(statearr_78844_78871[(2)] = null);

(statearr_78844_78871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78841 === (4))){
var inst_78820 = (state_78840[(8)]);
var inst_78820__$1 = (state_78840[(2)]);
var inst_78821 = (inst_78820__$1 == null);
var inst_78822 = cljs.core.not.call(null,inst_78821);
var state_78840__$1 = (function (){var statearr_78845 = state_78840;
(statearr_78845[(8)] = inst_78820__$1);

return statearr_78845;
})();
if(inst_78822){
var statearr_78846_78872 = state_78840__$1;
(statearr_78846_78872[(1)] = (5));

} else {
var statearr_78847_78873 = state_78840__$1;
(statearr_78847_78873[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78841 === (6))){
var state_78840__$1 = state_78840;
var statearr_78848_78874 = state_78840__$1;
(statearr_78848_78874[(2)] = null);

(statearr_78848_78874[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78841 === (3))){
var inst_78837 = (state_78840[(2)]);
var inst_78838 = cljs.core.async.close_BANG_.call(null,out);
var state_78840__$1 = (function (){var statearr_78849 = state_78840;
(statearr_78849[(9)] = inst_78837);

return statearr_78849;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78840__$1,inst_78838);
} else {
if((state_val_78841 === (2))){
var state_78840__$1 = state_78840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78840__$1,(4),ch);
} else {
if((state_val_78841 === (11))){
var inst_78820 = (state_78840[(8)]);
var inst_78829 = (state_78840[(2)]);
var inst_78817 = inst_78820;
var state_78840__$1 = (function (){var statearr_78850 = state_78840;
(statearr_78850[(10)] = inst_78829);

(statearr_78850[(7)] = inst_78817);

return statearr_78850;
})();
var statearr_78851_78875 = state_78840__$1;
(statearr_78851_78875[(2)] = null);

(statearr_78851_78875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78841 === (9))){
var inst_78820 = (state_78840[(8)]);
var state_78840__$1 = state_78840;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78840__$1,(11),out,inst_78820);
} else {
if((state_val_78841 === (5))){
var inst_78817 = (state_78840[(7)]);
var inst_78820 = (state_78840[(8)]);
var inst_78824 = cljs.core._EQ_.call(null,inst_78820,inst_78817);
var state_78840__$1 = state_78840;
if(inst_78824){
var statearr_78853_78876 = state_78840__$1;
(statearr_78853_78876[(1)] = (8));

} else {
var statearr_78854_78877 = state_78840__$1;
(statearr_78854_78877[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78841 === (10))){
var inst_78832 = (state_78840[(2)]);
var state_78840__$1 = state_78840;
var statearr_78855_78878 = state_78840__$1;
(statearr_78855_78878[(2)] = inst_78832);

(statearr_78855_78878[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78841 === (8))){
var inst_78817 = (state_78840[(7)]);
var tmp78852 = inst_78817;
var inst_78817__$1 = tmp78852;
var state_78840__$1 = (function (){var statearr_78856 = state_78840;
(statearr_78856[(7)] = inst_78817__$1);

return statearr_78856;
})();
var statearr_78857_78879 = state_78840__$1;
(statearr_78857_78879[(2)] = null);

(statearr_78857_78879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___78869,out))
;
return ((function (switch__38195__auto__,c__38309__auto___78869,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_78861 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_78861[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_78861[(1)] = (1));

return statearr_78861;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_78840){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_78840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e78862){if((e78862 instanceof Object)){
var ex__38199__auto__ = e78862;
var statearr_78863_78880 = state_78840;
(statearr_78863_78880[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78840);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78862;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78881 = state_78840;
state_78840 = G__78881;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_78840){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_78840);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___78869,out))
})();
var state__38311__auto__ = (function (){var statearr_78864 = f__38310__auto__.call(null);
(statearr_78864[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___78869);

return statearr_78864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___78869,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args78882 = [];
var len__10640__auto___78952 = arguments.length;
var i__10641__auto___78953 = (0);
while(true){
if((i__10641__auto___78953 < len__10640__auto___78952)){
args78882.push((arguments[i__10641__auto___78953]));

var G__78954 = (i__10641__auto___78953 + (1));
i__10641__auto___78953 = G__78954;
continue;
} else {
}
break;
}

var G__78884 = args78882.length;
switch (G__78884) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78882.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___78956 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___78956,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___78956,out){
return (function (state_78922){
var state_val_78923 = (state_78922[(1)]);
if((state_val_78923 === (7))){
var inst_78918 = (state_78922[(2)]);
var state_78922__$1 = state_78922;
var statearr_78924_78957 = state_78922__$1;
(statearr_78924_78957[(2)] = inst_78918);

(statearr_78924_78957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78923 === (1))){
var inst_78885 = (new Array(n));
var inst_78886 = inst_78885;
var inst_78887 = (0);
var state_78922__$1 = (function (){var statearr_78925 = state_78922;
(statearr_78925[(7)] = inst_78887);

(statearr_78925[(8)] = inst_78886);

return statearr_78925;
})();
var statearr_78926_78958 = state_78922__$1;
(statearr_78926_78958[(2)] = null);

(statearr_78926_78958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78923 === (4))){
var inst_78890 = (state_78922[(9)]);
var inst_78890__$1 = (state_78922[(2)]);
var inst_78891 = (inst_78890__$1 == null);
var inst_78892 = cljs.core.not.call(null,inst_78891);
var state_78922__$1 = (function (){var statearr_78927 = state_78922;
(statearr_78927[(9)] = inst_78890__$1);

return statearr_78927;
})();
if(inst_78892){
var statearr_78928_78959 = state_78922__$1;
(statearr_78928_78959[(1)] = (5));

} else {
var statearr_78929_78960 = state_78922__$1;
(statearr_78929_78960[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78923 === (15))){
var inst_78912 = (state_78922[(2)]);
var state_78922__$1 = state_78922;
var statearr_78930_78961 = state_78922__$1;
(statearr_78930_78961[(2)] = inst_78912);

(statearr_78930_78961[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78923 === (13))){
var state_78922__$1 = state_78922;
var statearr_78931_78962 = state_78922__$1;
(statearr_78931_78962[(2)] = null);

(statearr_78931_78962[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78923 === (6))){
var inst_78887 = (state_78922[(7)]);
var inst_78908 = (inst_78887 > (0));
var state_78922__$1 = state_78922;
if(cljs.core.truth_(inst_78908)){
var statearr_78932_78963 = state_78922__$1;
(statearr_78932_78963[(1)] = (12));

} else {
var statearr_78933_78964 = state_78922__$1;
(statearr_78933_78964[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78923 === (3))){
var inst_78920 = (state_78922[(2)]);
var state_78922__$1 = state_78922;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78922__$1,inst_78920);
} else {
if((state_val_78923 === (12))){
var inst_78886 = (state_78922[(8)]);
var inst_78910 = cljs.core.vec.call(null,inst_78886);
var state_78922__$1 = state_78922;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78922__$1,(15),out,inst_78910);
} else {
if((state_val_78923 === (2))){
var state_78922__$1 = state_78922;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78922__$1,(4),ch);
} else {
if((state_val_78923 === (11))){
var inst_78902 = (state_78922[(2)]);
var inst_78903 = (new Array(n));
var inst_78886 = inst_78903;
var inst_78887 = (0);
var state_78922__$1 = (function (){var statearr_78934 = state_78922;
(statearr_78934[(7)] = inst_78887);

(statearr_78934[(10)] = inst_78902);

(statearr_78934[(8)] = inst_78886);

return statearr_78934;
})();
var statearr_78935_78965 = state_78922__$1;
(statearr_78935_78965[(2)] = null);

(statearr_78935_78965[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78923 === (9))){
var inst_78886 = (state_78922[(8)]);
var inst_78900 = cljs.core.vec.call(null,inst_78886);
var state_78922__$1 = state_78922;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78922__$1,(11),out,inst_78900);
} else {
if((state_val_78923 === (5))){
var inst_78887 = (state_78922[(7)]);
var inst_78895 = (state_78922[(11)]);
var inst_78890 = (state_78922[(9)]);
var inst_78886 = (state_78922[(8)]);
var inst_78894 = (inst_78886[inst_78887] = inst_78890);
var inst_78895__$1 = (inst_78887 + (1));
var inst_78896 = (inst_78895__$1 < n);
var state_78922__$1 = (function (){var statearr_78936 = state_78922;
(statearr_78936[(12)] = inst_78894);

(statearr_78936[(11)] = inst_78895__$1);

return statearr_78936;
})();
if(cljs.core.truth_(inst_78896)){
var statearr_78937_78966 = state_78922__$1;
(statearr_78937_78966[(1)] = (8));

} else {
var statearr_78938_78967 = state_78922__$1;
(statearr_78938_78967[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78923 === (14))){
var inst_78915 = (state_78922[(2)]);
var inst_78916 = cljs.core.async.close_BANG_.call(null,out);
var state_78922__$1 = (function (){var statearr_78940 = state_78922;
(statearr_78940[(13)] = inst_78915);

return statearr_78940;
})();
var statearr_78941_78968 = state_78922__$1;
(statearr_78941_78968[(2)] = inst_78916);

(statearr_78941_78968[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78923 === (10))){
var inst_78906 = (state_78922[(2)]);
var state_78922__$1 = state_78922;
var statearr_78942_78969 = state_78922__$1;
(statearr_78942_78969[(2)] = inst_78906);

(statearr_78942_78969[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78923 === (8))){
var inst_78895 = (state_78922[(11)]);
var inst_78886 = (state_78922[(8)]);
var tmp78939 = inst_78886;
var inst_78886__$1 = tmp78939;
var inst_78887 = inst_78895;
var state_78922__$1 = (function (){var statearr_78943 = state_78922;
(statearr_78943[(7)] = inst_78887);

(statearr_78943[(8)] = inst_78886__$1);

return statearr_78943;
})();
var statearr_78944_78970 = state_78922__$1;
(statearr_78944_78970[(2)] = null);

(statearr_78944_78970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___78956,out))
;
return ((function (switch__38195__auto__,c__38309__auto___78956,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_78948 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78948[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_78948[(1)] = (1));

return statearr_78948;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_78922){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_78922);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e78949){if((e78949 instanceof Object)){
var ex__38199__auto__ = e78949;
var statearr_78950_78971 = state_78922;
(statearr_78950_78971[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78922);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78949;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78972 = state_78922;
state_78922 = G__78972;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_78922){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_78922);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___78956,out))
})();
var state__38311__auto__ = (function (){var statearr_78951 = f__38310__auto__.call(null);
(statearr_78951[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___78956);

return statearr_78951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___78956,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args78973 = [];
var len__10640__auto___79047 = arguments.length;
var i__10641__auto___79048 = (0);
while(true){
if((i__10641__auto___79048 < len__10640__auto___79047)){
args78973.push((arguments[i__10641__auto___79048]));

var G__79049 = (i__10641__auto___79048 + (1));
i__10641__auto___79048 = G__79049;
continue;
} else {
}
break;
}

var G__78975 = args78973.length;
switch (G__78975) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78973.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38309__auto___79051 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38309__auto___79051,out){
return (function (){
var f__38310__auto__ = (function (){var switch__38195__auto__ = ((function (c__38309__auto___79051,out){
return (function (state_79017){
var state_val_79018 = (state_79017[(1)]);
if((state_val_79018 === (7))){
var inst_79013 = (state_79017[(2)]);
var state_79017__$1 = state_79017;
var statearr_79019_79052 = state_79017__$1;
(statearr_79019_79052[(2)] = inst_79013);

(statearr_79019_79052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79018 === (1))){
var inst_78976 = [];
var inst_78977 = inst_78976;
var inst_78978 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_79017__$1 = (function (){var statearr_79020 = state_79017;
(statearr_79020[(7)] = inst_78978);

(statearr_79020[(8)] = inst_78977);

return statearr_79020;
})();
var statearr_79021_79053 = state_79017__$1;
(statearr_79021_79053[(2)] = null);

(statearr_79021_79053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79018 === (4))){
var inst_78981 = (state_79017[(9)]);
var inst_78981__$1 = (state_79017[(2)]);
var inst_78982 = (inst_78981__$1 == null);
var inst_78983 = cljs.core.not.call(null,inst_78982);
var state_79017__$1 = (function (){var statearr_79022 = state_79017;
(statearr_79022[(9)] = inst_78981__$1);

return statearr_79022;
})();
if(inst_78983){
var statearr_79023_79054 = state_79017__$1;
(statearr_79023_79054[(1)] = (5));

} else {
var statearr_79024_79055 = state_79017__$1;
(statearr_79024_79055[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79018 === (15))){
var inst_79007 = (state_79017[(2)]);
var state_79017__$1 = state_79017;
var statearr_79025_79056 = state_79017__$1;
(statearr_79025_79056[(2)] = inst_79007);

(statearr_79025_79056[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79018 === (13))){
var state_79017__$1 = state_79017;
var statearr_79026_79057 = state_79017__$1;
(statearr_79026_79057[(2)] = null);

(statearr_79026_79057[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79018 === (6))){
var inst_78977 = (state_79017[(8)]);
var inst_79002 = inst_78977.length;
var inst_79003 = (inst_79002 > (0));
var state_79017__$1 = state_79017;
if(cljs.core.truth_(inst_79003)){
var statearr_79027_79058 = state_79017__$1;
(statearr_79027_79058[(1)] = (12));

} else {
var statearr_79028_79059 = state_79017__$1;
(statearr_79028_79059[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79018 === (3))){
var inst_79015 = (state_79017[(2)]);
var state_79017__$1 = state_79017;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79017__$1,inst_79015);
} else {
if((state_val_79018 === (12))){
var inst_78977 = (state_79017[(8)]);
var inst_79005 = cljs.core.vec.call(null,inst_78977);
var state_79017__$1 = state_79017;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79017__$1,(15),out,inst_79005);
} else {
if((state_val_79018 === (2))){
var state_79017__$1 = state_79017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79017__$1,(4),ch);
} else {
if((state_val_79018 === (11))){
var inst_78985 = (state_79017[(10)]);
var inst_78981 = (state_79017[(9)]);
var inst_78995 = (state_79017[(2)]);
var inst_78996 = [];
var inst_78997 = inst_78996.push(inst_78981);
var inst_78977 = inst_78996;
var inst_78978 = inst_78985;
var state_79017__$1 = (function (){var statearr_79029 = state_79017;
(statearr_79029[(7)] = inst_78978);

(statearr_79029[(11)] = inst_78995);

(statearr_79029[(8)] = inst_78977);

(statearr_79029[(12)] = inst_78997);

return statearr_79029;
})();
var statearr_79030_79060 = state_79017__$1;
(statearr_79030_79060[(2)] = null);

(statearr_79030_79060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79018 === (9))){
var inst_78977 = (state_79017[(8)]);
var inst_78993 = cljs.core.vec.call(null,inst_78977);
var state_79017__$1 = state_79017;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_79017__$1,(11),out,inst_78993);
} else {
if((state_val_79018 === (5))){
var inst_78985 = (state_79017[(10)]);
var inst_78978 = (state_79017[(7)]);
var inst_78981 = (state_79017[(9)]);
var inst_78985__$1 = f.call(null,inst_78981);
var inst_78986 = cljs.core._EQ_.call(null,inst_78985__$1,inst_78978);
var inst_78987 = cljs.core.keyword_identical_QMARK_.call(null,inst_78978,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_78988 = (inst_78986) || (inst_78987);
var state_79017__$1 = (function (){var statearr_79031 = state_79017;
(statearr_79031[(10)] = inst_78985__$1);

return statearr_79031;
})();
if(cljs.core.truth_(inst_78988)){
var statearr_79032_79061 = state_79017__$1;
(statearr_79032_79061[(1)] = (8));

} else {
var statearr_79033_79062 = state_79017__$1;
(statearr_79033_79062[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79018 === (14))){
var inst_79010 = (state_79017[(2)]);
var inst_79011 = cljs.core.async.close_BANG_.call(null,out);
var state_79017__$1 = (function (){var statearr_79035 = state_79017;
(statearr_79035[(13)] = inst_79010);

return statearr_79035;
})();
var statearr_79036_79063 = state_79017__$1;
(statearr_79036_79063[(2)] = inst_79011);

(statearr_79036_79063[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79018 === (10))){
var inst_79000 = (state_79017[(2)]);
var state_79017__$1 = state_79017;
var statearr_79037_79064 = state_79017__$1;
(statearr_79037_79064[(2)] = inst_79000);

(statearr_79037_79064[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79018 === (8))){
var inst_78985 = (state_79017[(10)]);
var inst_78977 = (state_79017[(8)]);
var inst_78981 = (state_79017[(9)]);
var inst_78990 = inst_78977.push(inst_78981);
var tmp79034 = inst_78977;
var inst_78977__$1 = tmp79034;
var inst_78978 = inst_78985;
var state_79017__$1 = (function (){var statearr_79038 = state_79017;
(statearr_79038[(7)] = inst_78978);

(statearr_79038[(8)] = inst_78977__$1);

(statearr_79038[(14)] = inst_78990);

return statearr_79038;
})();
var statearr_79039_79065 = state_79017__$1;
(statearr_79039_79065[(2)] = null);

(statearr_79039_79065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38309__auto___79051,out))
;
return ((function (switch__38195__auto__,c__38309__auto___79051,out){
return (function() {
var cljs$core$async$state_machine__38196__auto__ = null;
var cljs$core$async$state_machine__38196__auto____0 = (function (){
var statearr_79043 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79043[(0)] = cljs$core$async$state_machine__38196__auto__);

(statearr_79043[(1)] = (1));

return statearr_79043;
});
var cljs$core$async$state_machine__38196__auto____1 = (function (state_79017){
while(true){
var ret_value__38197__auto__ = (function (){try{while(true){
var result__38198__auto__ = switch__38195__auto__.call(null,state_79017);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38198__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38198__auto__;
}
break;
}
}catch (e79044){if((e79044 instanceof Object)){
var ex__38199__auto__ = e79044;
var statearr_79045_79066 = state_79017;
(statearr_79045_79066[(5)] = ex__38199__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_79017);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e79044;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38197__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79067 = state_79017;
state_79017 = G__79067;
continue;
} else {
return ret_value__38197__auto__;
}
break;
}
});
cljs$core$async$state_machine__38196__auto__ = function(state_79017){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38196__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38196__auto____1.call(this,state_79017);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38196__auto____0;
cljs$core$async$state_machine__38196__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38196__auto____1;
return cljs$core$async$state_machine__38196__auto__;
})()
;})(switch__38195__auto__,c__38309__auto___79051,out))
})();
var state__38311__auto__ = (function (){var statearr_79046 = f__38310__auto__.call(null);
(statearr_79046[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38309__auto___79051);

return statearr_79046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38311__auto__);
});})(c__38309__auto___79051,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map