// Compiled by ClojureScript 1.9.521 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args57931 = [];
var len__10640__auto___57937 = arguments.length;
var i__10641__auto___57938 = (0);
while(true){
if((i__10641__auto___57938 < len__10640__auto___57937)){
args57931.push((arguments[i__10641__auto___57938]));

var G__57939 = (i__10641__auto___57938 + (1));
i__10641__auto___57938 = G__57939;
continue;
} else {
}
break;
}

var G__57933 = args57931.length;
switch (G__57933) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57931.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async57934 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57934 = (function (f,blockable,meta57935){
this.f = f;
this.blockable = blockable;
this.meta57935 = meta57935;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async57934.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57936,meta57935__$1){
var self__ = this;
var _57936__$1 = this;
return (new cljs.core.async.t_cljs$core$async57934(self__.f,self__.blockable,meta57935__$1));
});

cljs.core.async.t_cljs$core$async57934.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57936){
var self__ = this;
var _57936__$1 = this;
return self__.meta57935;
});

cljs.core.async.t_cljs$core$async57934.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async57934.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async57934.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async57934.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async57934.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta57935","meta57935",-90984865,null)], null);
});

cljs.core.async.t_cljs$core$async57934.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57934.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57934";

cljs.core.async.t_cljs$core$async57934.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async57934");
});

cljs.core.async.__GT_t_cljs$core$async57934 = (function cljs$core$async$__GT_t_cljs$core$async57934(f__$1,blockable__$1,meta57935){
return (new cljs.core.async.t_cljs$core$async57934(f__$1,blockable__$1,meta57935));
});

}

return (new cljs.core.async.t_cljs$core$async57934(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args57943 = [];
var len__10640__auto___57946 = arguments.length;
var i__10641__auto___57947 = (0);
while(true){
if((i__10641__auto___57947 < len__10640__auto___57946)){
args57943.push((arguments[i__10641__auto___57947]));

var G__57948 = (i__10641__auto___57947 + (1));
i__10641__auto___57947 = G__57948;
continue;
} else {
}
break;
}

var G__57945 = args57943.length;
switch (G__57945) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57943.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args57950 = [];
var len__10640__auto___57953 = arguments.length;
var i__10641__auto___57954 = (0);
while(true){
if((i__10641__auto___57954 < len__10640__auto___57953)){
args57950.push((arguments[i__10641__auto___57954]));

var G__57955 = (i__10641__auto___57954 + (1));
i__10641__auto___57954 = G__57955;
continue;
} else {
}
break;
}

var G__57952 = args57950.length;
switch (G__57952) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57950.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args57957 = [];
var len__10640__auto___57960 = arguments.length;
var i__10641__auto___57961 = (0);
while(true){
if((i__10641__auto___57961 < len__10640__auto___57960)){
args57957.push((arguments[i__10641__auto___57961]));

var G__57962 = (i__10641__auto___57961 + (1));
i__10641__auto___57961 = G__57962;
continue;
} else {
}
break;
}

var G__57959 = args57957.length;
switch (G__57959) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57957.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_57964 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_57964);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_57964,ret){
return (function (){
return fn1.call(null,val_57964);
});})(val_57964,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args57965 = [];
var len__10640__auto___57968 = arguments.length;
var i__10641__auto___57969 = (0);
while(true){
if((i__10641__auto___57969 < len__10640__auto___57968)){
args57965.push((arguments[i__10641__auto___57969]));

var G__57970 = (i__10641__auto___57969 + (1));
i__10641__auto___57969 = G__57970;
continue;
} else {
}
break;
}

var G__57967 = args57965.length;
switch (G__57967) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57965.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6736__auto__)){
var ret = temp__6736__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6736__auto__)){
var retb = temp__6736__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6736__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6736__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__10440__auto___57972 = n;
var x_57973 = (0);
while(true){
if((x_57973 < n__10440__auto___57972)){
(a[x_57973] = (0));

var G__57974 = (x_57973 + (1));
x_57973 = G__57974;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__57975 = (i + (1));
i = G__57975;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async57979 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57979 = (function (flag,meta57980){
this.flag = flag;
this.meta57980 = meta57980;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async57979.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_57981,meta57980__$1){
var self__ = this;
var _57981__$1 = this;
return (new cljs.core.async.t_cljs$core$async57979(self__.flag,meta57980__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async57979.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_57981){
var self__ = this;
var _57981__$1 = this;
return self__.meta57980;
});})(flag))
;

cljs.core.async.t_cljs$core$async57979.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async57979.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async57979.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async57979.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async57979.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta57980","meta57980",1939509545,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async57979.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57979.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57979";

cljs.core.async.t_cljs$core$async57979.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async57979");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async57979 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async57979(flag__$1,meta57980){
return (new cljs.core.async.t_cljs$core$async57979(flag__$1,meta57980));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async57979(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async57985 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async57985 = (function (flag,cb,meta57986){
this.flag = flag;
this.cb = cb;
this.meta57986 = meta57986;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_57987,meta57986__$1){
var self__ = this;
var _57987__$1 = this;
return (new cljs.core.async.t_cljs$core$async57985(self__.flag,self__.cb,meta57986__$1));
});

cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_57987){
var self__ = this;
var _57987__$1 = this;
return self__.meta57986;
});

cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async57985.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async57985.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta57986","meta57986",1444545600,null)], null);
});

cljs.core.async.t_cljs$core$async57985.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async57985.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async57985";

cljs.core.async.t_cljs$core$async57985.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async57985");
});

cljs.core.async.__GT_t_cljs$core$async57985 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async57985(flag__$1,cb__$1,meta57986){
return (new cljs.core.async.t_cljs$core$async57985(flag__$1,cb__$1,meta57986));
});

}

return (new cljs.core.async.t_cljs$core$async57985(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__57988_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__57988_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__57989_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__57989_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__9419__auto__ = wport;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return port;
}
})()], null));
} else {
var G__57990 = (i + (1));
i = G__57990;
continue;
}
} else {
return null;
}
break;
}
})();
var or__9419__auto__ = ret;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6738__auto__ = (function (){var and__9407__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__9407__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__9407__auto__;
}
})();
if(cljs.core.truth_(temp__6738__auto__)){
var got = temp__6738__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___57996 = arguments.length;
var i__10641__auto___57997 = (0);
while(true){
if((i__10641__auto___57997 < len__10640__auto___57996)){
args__10647__auto__.push((arguments[i__10641__auto___57997]));

var G__57998 = (i__10641__auto___57997 + (1));
i__10641__auto___57997 = G__57998;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__57993){
var map__57994 = p__57993;
var map__57994__$1 = ((((!((map__57994 == null)))?((((map__57994.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57994.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__57994):map__57994);
var opts = map__57994__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq57991){
var G__57992 = cljs.core.first.call(null,seq57991);
var seq57991__$1 = cljs.core.next.call(null,seq57991);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__57992,seq57991__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args57999 = [];
var len__10640__auto___58049 = arguments.length;
var i__10641__auto___58050 = (0);
while(true){
if((i__10641__auto___58050 < len__10640__auto___58049)){
args57999.push((arguments[i__10641__auto___58050]));

var G__58051 = (i__10641__auto___58050 + (1));
i__10641__auto___58050 = G__58051;
continue;
} else {
}
break;
}

var G__58001 = args57999.length;
switch (G__58001) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args57999.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__38457__auto___58053 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___58053){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___58053){
return (function (state_58025){
var state_val_58026 = (state_58025[(1)]);
if((state_val_58026 === (7))){
var inst_58021 = (state_58025[(2)]);
var state_58025__$1 = state_58025;
var statearr_58027_58054 = state_58025__$1;
(statearr_58027_58054[(2)] = inst_58021);

(statearr_58027_58054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58026 === (1))){
var state_58025__$1 = state_58025;
var statearr_58028_58055 = state_58025__$1;
(statearr_58028_58055[(2)] = null);

(statearr_58028_58055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58026 === (4))){
var inst_58004 = (state_58025[(7)]);
var inst_58004__$1 = (state_58025[(2)]);
var inst_58005 = (inst_58004__$1 == null);
var state_58025__$1 = (function (){var statearr_58029 = state_58025;
(statearr_58029[(7)] = inst_58004__$1);

return statearr_58029;
})();
if(cljs.core.truth_(inst_58005)){
var statearr_58030_58056 = state_58025__$1;
(statearr_58030_58056[(1)] = (5));

} else {
var statearr_58031_58057 = state_58025__$1;
(statearr_58031_58057[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58026 === (13))){
var state_58025__$1 = state_58025;
var statearr_58032_58058 = state_58025__$1;
(statearr_58032_58058[(2)] = null);

(statearr_58032_58058[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58026 === (6))){
var inst_58004 = (state_58025[(7)]);
var state_58025__$1 = state_58025;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58025__$1,(11),to,inst_58004);
} else {
if((state_val_58026 === (3))){
var inst_58023 = (state_58025[(2)]);
var state_58025__$1 = state_58025;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58025__$1,inst_58023);
} else {
if((state_val_58026 === (12))){
var state_58025__$1 = state_58025;
var statearr_58033_58059 = state_58025__$1;
(statearr_58033_58059[(2)] = null);

(statearr_58033_58059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58026 === (2))){
var state_58025__$1 = state_58025;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58025__$1,(4),from);
} else {
if((state_val_58026 === (11))){
var inst_58014 = (state_58025[(2)]);
var state_58025__$1 = state_58025;
if(cljs.core.truth_(inst_58014)){
var statearr_58034_58060 = state_58025__$1;
(statearr_58034_58060[(1)] = (12));

} else {
var statearr_58035_58061 = state_58025__$1;
(statearr_58035_58061[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58026 === (9))){
var state_58025__$1 = state_58025;
var statearr_58036_58062 = state_58025__$1;
(statearr_58036_58062[(2)] = null);

(statearr_58036_58062[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58026 === (5))){
var state_58025__$1 = state_58025;
if(cljs.core.truth_(close_QMARK_)){
var statearr_58037_58063 = state_58025__$1;
(statearr_58037_58063[(1)] = (8));

} else {
var statearr_58038_58064 = state_58025__$1;
(statearr_58038_58064[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58026 === (14))){
var inst_58019 = (state_58025[(2)]);
var state_58025__$1 = state_58025;
var statearr_58039_58065 = state_58025__$1;
(statearr_58039_58065[(2)] = inst_58019);

(statearr_58039_58065[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58026 === (10))){
var inst_58011 = (state_58025[(2)]);
var state_58025__$1 = state_58025;
var statearr_58040_58066 = state_58025__$1;
(statearr_58040_58066[(2)] = inst_58011);

(statearr_58040_58066[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58026 === (8))){
var inst_58008 = cljs.core.async.close_BANG_.call(null,to);
var state_58025__$1 = state_58025;
var statearr_58041_58067 = state_58025__$1;
(statearr_58041_58067[(2)] = inst_58008);

(statearr_58041_58067[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___58053))
;
return ((function (switch__38343__auto__,c__38457__auto___58053){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_58045 = [null,null,null,null,null,null,null,null];
(statearr_58045[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_58045[(1)] = (1));

return statearr_58045;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_58025){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_58025);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e58046){if((e58046 instanceof Object)){
var ex__38347__auto__ = e58046;
var statearr_58047_58068 = state_58025;
(statearr_58047_58068[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58025);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58046;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58069 = state_58025;
state_58025 = G__58069;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_58025){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_58025);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___58053))
})();
var state__38459__auto__ = (function (){var statearr_58048 = f__38458__auto__.call(null);
(statearr_58048[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___58053);

return statearr_58048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___58053))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__58257){
var vec__58258 = p__58257;
var v = cljs.core.nth.call(null,vec__58258,(0),null);
var p = cljs.core.nth.call(null,vec__58258,(1),null);
var job = vec__58258;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__38457__auto___58444 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___58444,res,vec__58258,v,p,job,jobs,results){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___58444,res,vec__58258,v,p,job,jobs,results){
return (function (state_58265){
var state_val_58266 = (state_58265[(1)]);
if((state_val_58266 === (1))){
var state_58265__$1 = state_58265;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58265__$1,(2),res,v);
} else {
if((state_val_58266 === (2))){
var inst_58262 = (state_58265[(2)]);
var inst_58263 = cljs.core.async.close_BANG_.call(null,res);
var state_58265__$1 = (function (){var statearr_58267 = state_58265;
(statearr_58267[(7)] = inst_58262);

return statearr_58267;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58265__$1,inst_58263);
} else {
return null;
}
}
});})(c__38457__auto___58444,res,vec__58258,v,p,job,jobs,results))
;
return ((function (switch__38343__auto__,c__38457__auto___58444,res,vec__58258,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_58271 = [null,null,null,null,null,null,null,null];
(statearr_58271[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__);

(statearr_58271[(1)] = (1));

return statearr_58271;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1 = (function (state_58265){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_58265);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e58272){if((e58272 instanceof Object)){
var ex__38347__auto__ = e58272;
var statearr_58273_58445 = state_58265;
(statearr_58273_58445[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58265);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58272;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58446 = state_58265;
state_58265 = G__58446;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = function(state_58265){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1.call(this,state_58265);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___58444,res,vec__58258,v,p,job,jobs,results))
})();
var state__38459__auto__ = (function (){var statearr_58274 = f__38458__auto__.call(null);
(statearr_58274[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___58444);

return statearr_58274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___58444,res,vec__58258,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__58275){
var vec__58276 = p__58275;
var v = cljs.core.nth.call(null,vec__58276,(0),null);
var p = cljs.core.nth.call(null,vec__58276,(1),null);
var job = vec__58276;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__10440__auto___58447 = n;
var __58448 = (0);
while(true){
if((__58448 < n__10440__auto___58447)){
var G__58279_58449 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__58279_58449) {
case "compute":
var c__38457__auto___58451 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__58448,c__38457__auto___58451,G__58279_58449,n__10440__auto___58447,jobs,results,process,async){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (__58448,c__38457__auto___58451,G__58279_58449,n__10440__auto___58447,jobs,results,process,async){
return (function (state_58292){
var state_val_58293 = (state_58292[(1)]);
if((state_val_58293 === (1))){
var state_58292__$1 = state_58292;
var statearr_58294_58452 = state_58292__$1;
(statearr_58294_58452[(2)] = null);

(statearr_58294_58452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58293 === (2))){
var state_58292__$1 = state_58292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58292__$1,(4),jobs);
} else {
if((state_val_58293 === (3))){
var inst_58290 = (state_58292[(2)]);
var state_58292__$1 = state_58292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58292__$1,inst_58290);
} else {
if((state_val_58293 === (4))){
var inst_58282 = (state_58292[(2)]);
var inst_58283 = process.call(null,inst_58282);
var state_58292__$1 = state_58292;
if(cljs.core.truth_(inst_58283)){
var statearr_58295_58453 = state_58292__$1;
(statearr_58295_58453[(1)] = (5));

} else {
var statearr_58296_58454 = state_58292__$1;
(statearr_58296_58454[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58293 === (5))){
var state_58292__$1 = state_58292;
var statearr_58297_58455 = state_58292__$1;
(statearr_58297_58455[(2)] = null);

(statearr_58297_58455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58293 === (6))){
var state_58292__$1 = state_58292;
var statearr_58298_58456 = state_58292__$1;
(statearr_58298_58456[(2)] = null);

(statearr_58298_58456[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58293 === (7))){
var inst_58288 = (state_58292[(2)]);
var state_58292__$1 = state_58292;
var statearr_58299_58457 = state_58292__$1;
(statearr_58299_58457[(2)] = inst_58288);

(statearr_58299_58457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__58448,c__38457__auto___58451,G__58279_58449,n__10440__auto___58447,jobs,results,process,async))
;
return ((function (__58448,switch__38343__auto__,c__38457__auto___58451,G__58279_58449,n__10440__auto___58447,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_58303 = [null,null,null,null,null,null,null];
(statearr_58303[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__);

(statearr_58303[(1)] = (1));

return statearr_58303;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1 = (function (state_58292){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_58292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e58304){if((e58304 instanceof Object)){
var ex__38347__auto__ = e58304;
var statearr_58305_58458 = state_58292;
(statearr_58305_58458[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58292);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58304;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58459 = state_58292;
state_58292 = G__58459;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = function(state_58292){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1.call(this,state_58292);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__;
})()
;})(__58448,switch__38343__auto__,c__38457__auto___58451,G__58279_58449,n__10440__auto___58447,jobs,results,process,async))
})();
var state__38459__auto__ = (function (){var statearr_58306 = f__38458__auto__.call(null);
(statearr_58306[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___58451);

return statearr_58306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(__58448,c__38457__auto___58451,G__58279_58449,n__10440__auto___58447,jobs,results,process,async))
);


break;
case "async":
var c__38457__auto___58460 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__58448,c__38457__auto___58460,G__58279_58449,n__10440__auto___58447,jobs,results,process,async){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (__58448,c__38457__auto___58460,G__58279_58449,n__10440__auto___58447,jobs,results,process,async){
return (function (state_58319){
var state_val_58320 = (state_58319[(1)]);
if((state_val_58320 === (1))){
var state_58319__$1 = state_58319;
var statearr_58321_58461 = state_58319__$1;
(statearr_58321_58461[(2)] = null);

(statearr_58321_58461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58320 === (2))){
var state_58319__$1 = state_58319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58319__$1,(4),jobs);
} else {
if((state_val_58320 === (3))){
var inst_58317 = (state_58319[(2)]);
var state_58319__$1 = state_58319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58319__$1,inst_58317);
} else {
if((state_val_58320 === (4))){
var inst_58309 = (state_58319[(2)]);
var inst_58310 = async.call(null,inst_58309);
var state_58319__$1 = state_58319;
if(cljs.core.truth_(inst_58310)){
var statearr_58322_58462 = state_58319__$1;
(statearr_58322_58462[(1)] = (5));

} else {
var statearr_58323_58463 = state_58319__$1;
(statearr_58323_58463[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58320 === (5))){
var state_58319__$1 = state_58319;
var statearr_58324_58464 = state_58319__$1;
(statearr_58324_58464[(2)] = null);

(statearr_58324_58464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58320 === (6))){
var state_58319__$1 = state_58319;
var statearr_58325_58465 = state_58319__$1;
(statearr_58325_58465[(2)] = null);

(statearr_58325_58465[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58320 === (7))){
var inst_58315 = (state_58319[(2)]);
var state_58319__$1 = state_58319;
var statearr_58326_58466 = state_58319__$1;
(statearr_58326_58466[(2)] = inst_58315);

(statearr_58326_58466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__58448,c__38457__auto___58460,G__58279_58449,n__10440__auto___58447,jobs,results,process,async))
;
return ((function (__58448,switch__38343__auto__,c__38457__auto___58460,G__58279_58449,n__10440__auto___58447,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_58330 = [null,null,null,null,null,null,null];
(statearr_58330[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__);

(statearr_58330[(1)] = (1));

return statearr_58330;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1 = (function (state_58319){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_58319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e58331){if((e58331 instanceof Object)){
var ex__38347__auto__ = e58331;
var statearr_58332_58467 = state_58319;
(statearr_58332_58467[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58331;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58468 = state_58319;
state_58319 = G__58468;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = function(state_58319){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1.call(this,state_58319);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__;
})()
;})(__58448,switch__38343__auto__,c__38457__auto___58460,G__58279_58449,n__10440__auto___58447,jobs,results,process,async))
})();
var state__38459__auto__ = (function (){var statearr_58333 = f__38458__auto__.call(null);
(statearr_58333[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___58460);

return statearr_58333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(__58448,c__38457__auto___58460,G__58279_58449,n__10440__auto___58447,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__58469 = (__58448 + (1));
__58448 = G__58469;
continue;
} else {
}
break;
}

var c__38457__auto___58470 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___58470,jobs,results,process,async){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___58470,jobs,results,process,async){
return (function (state_58355){
var state_val_58356 = (state_58355[(1)]);
if((state_val_58356 === (1))){
var state_58355__$1 = state_58355;
var statearr_58357_58471 = state_58355__$1;
(statearr_58357_58471[(2)] = null);

(statearr_58357_58471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58356 === (2))){
var state_58355__$1 = state_58355;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58355__$1,(4),from);
} else {
if((state_val_58356 === (3))){
var inst_58353 = (state_58355[(2)]);
var state_58355__$1 = state_58355;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58355__$1,inst_58353);
} else {
if((state_val_58356 === (4))){
var inst_58336 = (state_58355[(7)]);
var inst_58336__$1 = (state_58355[(2)]);
var inst_58337 = (inst_58336__$1 == null);
var state_58355__$1 = (function (){var statearr_58358 = state_58355;
(statearr_58358[(7)] = inst_58336__$1);

return statearr_58358;
})();
if(cljs.core.truth_(inst_58337)){
var statearr_58359_58472 = state_58355__$1;
(statearr_58359_58472[(1)] = (5));

} else {
var statearr_58360_58473 = state_58355__$1;
(statearr_58360_58473[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58356 === (5))){
var inst_58339 = cljs.core.async.close_BANG_.call(null,jobs);
var state_58355__$1 = state_58355;
var statearr_58361_58474 = state_58355__$1;
(statearr_58361_58474[(2)] = inst_58339);

(statearr_58361_58474[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58356 === (6))){
var inst_58341 = (state_58355[(8)]);
var inst_58336 = (state_58355[(7)]);
var inst_58341__$1 = cljs.core.async.chan.call(null,(1));
var inst_58342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58343 = [inst_58336,inst_58341__$1];
var inst_58344 = (new cljs.core.PersistentVector(null,2,(5),inst_58342,inst_58343,null));
var state_58355__$1 = (function (){var statearr_58362 = state_58355;
(statearr_58362[(8)] = inst_58341__$1);

return statearr_58362;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58355__$1,(8),jobs,inst_58344);
} else {
if((state_val_58356 === (7))){
var inst_58351 = (state_58355[(2)]);
var state_58355__$1 = state_58355;
var statearr_58363_58475 = state_58355__$1;
(statearr_58363_58475[(2)] = inst_58351);

(statearr_58363_58475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58356 === (8))){
var inst_58341 = (state_58355[(8)]);
var inst_58346 = (state_58355[(2)]);
var state_58355__$1 = (function (){var statearr_58364 = state_58355;
(statearr_58364[(9)] = inst_58346);

return statearr_58364;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58355__$1,(9),results,inst_58341);
} else {
if((state_val_58356 === (9))){
var inst_58348 = (state_58355[(2)]);
var state_58355__$1 = (function (){var statearr_58365 = state_58355;
(statearr_58365[(10)] = inst_58348);

return statearr_58365;
})();
var statearr_58366_58476 = state_58355__$1;
(statearr_58366_58476[(2)] = null);

(statearr_58366_58476[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___58470,jobs,results,process,async))
;
return ((function (switch__38343__auto__,c__38457__auto___58470,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_58370 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_58370[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__);

(statearr_58370[(1)] = (1));

return statearr_58370;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1 = (function (state_58355){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_58355);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e58371){if((e58371 instanceof Object)){
var ex__38347__auto__ = e58371;
var statearr_58372_58477 = state_58355;
(statearr_58372_58477[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58355);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58371;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58478 = state_58355;
state_58355 = G__58478;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = function(state_58355){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1.call(this,state_58355);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___58470,jobs,results,process,async))
})();
var state__38459__auto__ = (function (){var statearr_58373 = f__38458__auto__.call(null);
(statearr_58373[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___58470);

return statearr_58373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___58470,jobs,results,process,async))
);


var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,jobs,results,process,async){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,jobs,results,process,async){
return (function (state_58411){
var state_val_58412 = (state_58411[(1)]);
if((state_val_58412 === (7))){
var inst_58407 = (state_58411[(2)]);
var state_58411__$1 = state_58411;
var statearr_58413_58479 = state_58411__$1;
(statearr_58413_58479[(2)] = inst_58407);

(statearr_58413_58479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (20))){
var state_58411__$1 = state_58411;
var statearr_58414_58480 = state_58411__$1;
(statearr_58414_58480[(2)] = null);

(statearr_58414_58480[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (1))){
var state_58411__$1 = state_58411;
var statearr_58415_58481 = state_58411__$1;
(statearr_58415_58481[(2)] = null);

(statearr_58415_58481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (4))){
var inst_58376 = (state_58411[(7)]);
var inst_58376__$1 = (state_58411[(2)]);
var inst_58377 = (inst_58376__$1 == null);
var state_58411__$1 = (function (){var statearr_58416 = state_58411;
(statearr_58416[(7)] = inst_58376__$1);

return statearr_58416;
})();
if(cljs.core.truth_(inst_58377)){
var statearr_58417_58482 = state_58411__$1;
(statearr_58417_58482[(1)] = (5));

} else {
var statearr_58418_58483 = state_58411__$1;
(statearr_58418_58483[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (15))){
var inst_58389 = (state_58411[(8)]);
var state_58411__$1 = state_58411;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58411__$1,(18),to,inst_58389);
} else {
if((state_val_58412 === (21))){
var inst_58402 = (state_58411[(2)]);
var state_58411__$1 = state_58411;
var statearr_58419_58484 = state_58411__$1;
(statearr_58419_58484[(2)] = inst_58402);

(statearr_58419_58484[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (13))){
var inst_58404 = (state_58411[(2)]);
var state_58411__$1 = (function (){var statearr_58420 = state_58411;
(statearr_58420[(9)] = inst_58404);

return statearr_58420;
})();
var statearr_58421_58485 = state_58411__$1;
(statearr_58421_58485[(2)] = null);

(statearr_58421_58485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (6))){
var inst_58376 = (state_58411[(7)]);
var state_58411__$1 = state_58411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58411__$1,(11),inst_58376);
} else {
if((state_val_58412 === (17))){
var inst_58397 = (state_58411[(2)]);
var state_58411__$1 = state_58411;
if(cljs.core.truth_(inst_58397)){
var statearr_58422_58486 = state_58411__$1;
(statearr_58422_58486[(1)] = (19));

} else {
var statearr_58423_58487 = state_58411__$1;
(statearr_58423_58487[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (3))){
var inst_58409 = (state_58411[(2)]);
var state_58411__$1 = state_58411;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58411__$1,inst_58409);
} else {
if((state_val_58412 === (12))){
var inst_58386 = (state_58411[(10)]);
var state_58411__$1 = state_58411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58411__$1,(14),inst_58386);
} else {
if((state_val_58412 === (2))){
var state_58411__$1 = state_58411;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58411__$1,(4),results);
} else {
if((state_val_58412 === (19))){
var state_58411__$1 = state_58411;
var statearr_58424_58488 = state_58411__$1;
(statearr_58424_58488[(2)] = null);

(statearr_58424_58488[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (11))){
var inst_58386 = (state_58411[(2)]);
var state_58411__$1 = (function (){var statearr_58425 = state_58411;
(statearr_58425[(10)] = inst_58386);

return statearr_58425;
})();
var statearr_58426_58489 = state_58411__$1;
(statearr_58426_58489[(2)] = null);

(statearr_58426_58489[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (9))){
var state_58411__$1 = state_58411;
var statearr_58427_58490 = state_58411__$1;
(statearr_58427_58490[(2)] = null);

(statearr_58427_58490[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (5))){
var state_58411__$1 = state_58411;
if(cljs.core.truth_(close_QMARK_)){
var statearr_58428_58491 = state_58411__$1;
(statearr_58428_58491[(1)] = (8));

} else {
var statearr_58429_58492 = state_58411__$1;
(statearr_58429_58492[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (14))){
var inst_58389 = (state_58411[(8)]);
var inst_58391 = (state_58411[(11)]);
var inst_58389__$1 = (state_58411[(2)]);
var inst_58390 = (inst_58389__$1 == null);
var inst_58391__$1 = cljs.core.not.call(null,inst_58390);
var state_58411__$1 = (function (){var statearr_58430 = state_58411;
(statearr_58430[(8)] = inst_58389__$1);

(statearr_58430[(11)] = inst_58391__$1);

return statearr_58430;
})();
if(inst_58391__$1){
var statearr_58431_58493 = state_58411__$1;
(statearr_58431_58493[(1)] = (15));

} else {
var statearr_58432_58494 = state_58411__$1;
(statearr_58432_58494[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (16))){
var inst_58391 = (state_58411[(11)]);
var state_58411__$1 = state_58411;
var statearr_58433_58495 = state_58411__$1;
(statearr_58433_58495[(2)] = inst_58391);

(statearr_58433_58495[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (10))){
var inst_58383 = (state_58411[(2)]);
var state_58411__$1 = state_58411;
var statearr_58434_58496 = state_58411__$1;
(statearr_58434_58496[(2)] = inst_58383);

(statearr_58434_58496[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (18))){
var inst_58394 = (state_58411[(2)]);
var state_58411__$1 = state_58411;
var statearr_58435_58497 = state_58411__$1;
(statearr_58435_58497[(2)] = inst_58394);

(statearr_58435_58497[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58412 === (8))){
var inst_58380 = cljs.core.async.close_BANG_.call(null,to);
var state_58411__$1 = state_58411;
var statearr_58436_58498 = state_58411__$1;
(statearr_58436_58498[(2)] = inst_58380);

(statearr_58436_58498[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto__,jobs,results,process,async))
;
return ((function (switch__38343__auto__,c__38457__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_58440 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58440[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__);

(statearr_58440[(1)] = (1));

return statearr_58440;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1 = (function (state_58411){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_58411);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e58441){if((e58441 instanceof Object)){
var ex__38347__auto__ = e58441;
var statearr_58442_58499 = state_58411;
(statearr_58442_58499[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58411);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58441;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58500 = state_58411;
state_58411 = G__58500;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = function(state_58411){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1.call(this,state_58411);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,jobs,results,process,async))
})();
var state__38459__auto__ = (function (){var statearr_58443 = f__38458__auto__.call(null);
(statearr_58443[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_58443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,jobs,results,process,async))
);

return c__38457__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args58501 = [];
var len__10640__auto___58504 = arguments.length;
var i__10641__auto___58505 = (0);
while(true){
if((i__10641__auto___58505 < len__10640__auto___58504)){
args58501.push((arguments[i__10641__auto___58505]));

var G__58506 = (i__10641__auto___58505 + (1));
i__10641__auto___58505 = G__58506;
continue;
} else {
}
break;
}

var G__58503 = args58501.length;
switch (G__58503) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58501.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args58508 = [];
var len__10640__auto___58511 = arguments.length;
var i__10641__auto___58512 = (0);
while(true){
if((i__10641__auto___58512 < len__10640__auto___58511)){
args58508.push((arguments[i__10641__auto___58512]));

var G__58513 = (i__10641__auto___58512 + (1));
i__10641__auto___58512 = G__58513;
continue;
} else {
}
break;
}

var G__58510 = args58508.length;
switch (G__58510) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58508.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args58515 = [];
var len__10640__auto___58568 = arguments.length;
var i__10641__auto___58569 = (0);
while(true){
if((i__10641__auto___58569 < len__10640__auto___58568)){
args58515.push((arguments[i__10641__auto___58569]));

var G__58570 = (i__10641__auto___58569 + (1));
i__10641__auto___58569 = G__58570;
continue;
} else {
}
break;
}

var G__58517 = args58515.length;
switch (G__58517) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58515.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__38457__auto___58572 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___58572,tc,fc){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___58572,tc,fc){
return (function (state_58543){
var state_val_58544 = (state_58543[(1)]);
if((state_val_58544 === (7))){
var inst_58539 = (state_58543[(2)]);
var state_58543__$1 = state_58543;
var statearr_58545_58573 = state_58543__$1;
(statearr_58545_58573[(2)] = inst_58539);

(statearr_58545_58573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58544 === (1))){
var state_58543__$1 = state_58543;
var statearr_58546_58574 = state_58543__$1;
(statearr_58546_58574[(2)] = null);

(statearr_58546_58574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58544 === (4))){
var inst_58520 = (state_58543[(7)]);
var inst_58520__$1 = (state_58543[(2)]);
var inst_58521 = (inst_58520__$1 == null);
var state_58543__$1 = (function (){var statearr_58547 = state_58543;
(statearr_58547[(7)] = inst_58520__$1);

return statearr_58547;
})();
if(cljs.core.truth_(inst_58521)){
var statearr_58548_58575 = state_58543__$1;
(statearr_58548_58575[(1)] = (5));

} else {
var statearr_58549_58576 = state_58543__$1;
(statearr_58549_58576[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58544 === (13))){
var state_58543__$1 = state_58543;
var statearr_58550_58577 = state_58543__$1;
(statearr_58550_58577[(2)] = null);

(statearr_58550_58577[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58544 === (6))){
var inst_58520 = (state_58543[(7)]);
var inst_58526 = p.call(null,inst_58520);
var state_58543__$1 = state_58543;
if(cljs.core.truth_(inst_58526)){
var statearr_58551_58578 = state_58543__$1;
(statearr_58551_58578[(1)] = (9));

} else {
var statearr_58552_58579 = state_58543__$1;
(statearr_58552_58579[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58544 === (3))){
var inst_58541 = (state_58543[(2)]);
var state_58543__$1 = state_58543;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58543__$1,inst_58541);
} else {
if((state_val_58544 === (12))){
var state_58543__$1 = state_58543;
var statearr_58553_58580 = state_58543__$1;
(statearr_58553_58580[(2)] = null);

(statearr_58553_58580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58544 === (2))){
var state_58543__$1 = state_58543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58543__$1,(4),ch);
} else {
if((state_val_58544 === (11))){
var inst_58520 = (state_58543[(7)]);
var inst_58530 = (state_58543[(2)]);
var state_58543__$1 = state_58543;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58543__$1,(8),inst_58530,inst_58520);
} else {
if((state_val_58544 === (9))){
var state_58543__$1 = state_58543;
var statearr_58554_58581 = state_58543__$1;
(statearr_58554_58581[(2)] = tc);

(statearr_58554_58581[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58544 === (5))){
var inst_58523 = cljs.core.async.close_BANG_.call(null,tc);
var inst_58524 = cljs.core.async.close_BANG_.call(null,fc);
var state_58543__$1 = (function (){var statearr_58555 = state_58543;
(statearr_58555[(8)] = inst_58523);

return statearr_58555;
})();
var statearr_58556_58582 = state_58543__$1;
(statearr_58556_58582[(2)] = inst_58524);

(statearr_58556_58582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58544 === (14))){
var inst_58537 = (state_58543[(2)]);
var state_58543__$1 = state_58543;
var statearr_58557_58583 = state_58543__$1;
(statearr_58557_58583[(2)] = inst_58537);

(statearr_58557_58583[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58544 === (10))){
var state_58543__$1 = state_58543;
var statearr_58558_58584 = state_58543__$1;
(statearr_58558_58584[(2)] = fc);

(statearr_58558_58584[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58544 === (8))){
var inst_58532 = (state_58543[(2)]);
var state_58543__$1 = state_58543;
if(cljs.core.truth_(inst_58532)){
var statearr_58559_58585 = state_58543__$1;
(statearr_58559_58585[(1)] = (12));

} else {
var statearr_58560_58586 = state_58543__$1;
(statearr_58560_58586[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___58572,tc,fc))
;
return ((function (switch__38343__auto__,c__38457__auto___58572,tc,fc){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_58564 = [null,null,null,null,null,null,null,null,null];
(statearr_58564[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_58564[(1)] = (1));

return statearr_58564;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_58543){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_58543);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e58565){if((e58565 instanceof Object)){
var ex__38347__auto__ = e58565;
var statearr_58566_58587 = state_58543;
(statearr_58566_58587[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58543);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58565;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58588 = state_58543;
state_58543 = G__58588;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_58543){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_58543);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___58572,tc,fc))
})();
var state__38459__auto__ = (function (){var statearr_58567 = f__38458__auto__.call(null);
(statearr_58567[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___58572);

return statearr_58567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___58572,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__){
return (function (state_58652){
var state_val_58653 = (state_58652[(1)]);
if((state_val_58653 === (7))){
var inst_58648 = (state_58652[(2)]);
var state_58652__$1 = state_58652;
var statearr_58654_58675 = state_58652__$1;
(statearr_58654_58675[(2)] = inst_58648);

(statearr_58654_58675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58653 === (1))){
var inst_58632 = init;
var state_58652__$1 = (function (){var statearr_58655 = state_58652;
(statearr_58655[(7)] = inst_58632);

return statearr_58655;
})();
var statearr_58656_58676 = state_58652__$1;
(statearr_58656_58676[(2)] = null);

(statearr_58656_58676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58653 === (4))){
var inst_58635 = (state_58652[(8)]);
var inst_58635__$1 = (state_58652[(2)]);
var inst_58636 = (inst_58635__$1 == null);
var state_58652__$1 = (function (){var statearr_58657 = state_58652;
(statearr_58657[(8)] = inst_58635__$1);

return statearr_58657;
})();
if(cljs.core.truth_(inst_58636)){
var statearr_58658_58677 = state_58652__$1;
(statearr_58658_58677[(1)] = (5));

} else {
var statearr_58659_58678 = state_58652__$1;
(statearr_58659_58678[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58653 === (6))){
var inst_58639 = (state_58652[(9)]);
var inst_58635 = (state_58652[(8)]);
var inst_58632 = (state_58652[(7)]);
var inst_58639__$1 = f.call(null,inst_58632,inst_58635);
var inst_58640 = cljs.core.reduced_QMARK_.call(null,inst_58639__$1);
var state_58652__$1 = (function (){var statearr_58660 = state_58652;
(statearr_58660[(9)] = inst_58639__$1);

return statearr_58660;
})();
if(inst_58640){
var statearr_58661_58679 = state_58652__$1;
(statearr_58661_58679[(1)] = (8));

} else {
var statearr_58662_58680 = state_58652__$1;
(statearr_58662_58680[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58653 === (3))){
var inst_58650 = (state_58652[(2)]);
var state_58652__$1 = state_58652;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58652__$1,inst_58650);
} else {
if((state_val_58653 === (2))){
var state_58652__$1 = state_58652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58652__$1,(4),ch);
} else {
if((state_val_58653 === (9))){
var inst_58639 = (state_58652[(9)]);
var inst_58632 = inst_58639;
var state_58652__$1 = (function (){var statearr_58663 = state_58652;
(statearr_58663[(7)] = inst_58632);

return statearr_58663;
})();
var statearr_58664_58681 = state_58652__$1;
(statearr_58664_58681[(2)] = null);

(statearr_58664_58681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58653 === (5))){
var inst_58632 = (state_58652[(7)]);
var state_58652__$1 = state_58652;
var statearr_58665_58682 = state_58652__$1;
(statearr_58665_58682[(2)] = inst_58632);

(statearr_58665_58682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58653 === (10))){
var inst_58646 = (state_58652[(2)]);
var state_58652__$1 = state_58652;
var statearr_58666_58683 = state_58652__$1;
(statearr_58666_58683[(2)] = inst_58646);

(statearr_58666_58683[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58653 === (8))){
var inst_58639 = (state_58652[(9)]);
var inst_58642 = cljs.core.deref.call(null,inst_58639);
var state_58652__$1 = state_58652;
var statearr_58667_58684 = state_58652__$1;
(statearr_58667_58684[(2)] = inst_58642);

(statearr_58667_58684[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto__))
;
return ((function (switch__38343__auto__,c__38457__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__38344__auto__ = null;
var cljs$core$async$reduce_$_state_machine__38344__auto____0 = (function (){
var statearr_58671 = [null,null,null,null,null,null,null,null,null,null];
(statearr_58671[(0)] = cljs$core$async$reduce_$_state_machine__38344__auto__);

(statearr_58671[(1)] = (1));

return statearr_58671;
});
var cljs$core$async$reduce_$_state_machine__38344__auto____1 = (function (state_58652){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_58652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e58672){if((e58672 instanceof Object)){
var ex__38347__auto__ = e58672;
var statearr_58673_58685 = state_58652;
(statearr_58673_58685[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58652);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58672;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58686 = state_58652;
state_58652 = G__58686;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__38344__auto__ = function(state_58652){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__38344__auto____1.call(this,state_58652);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__38344__auto____0;
cljs$core$async$reduce_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__38344__auto____1;
return cljs$core$async$reduce_$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__))
})();
var state__38459__auto__ = (function (){var statearr_58674 = f__38458__auto__.call(null);
(statearr_58674[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_58674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__))
);

return c__38457__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,f__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,f__$1){
return (function (state_58706){
var state_val_58707 = (state_58706[(1)]);
if((state_val_58707 === (1))){
var inst_58701 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_58706__$1 = state_58706;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58706__$1,(2),inst_58701);
} else {
if((state_val_58707 === (2))){
var inst_58703 = (state_58706[(2)]);
var inst_58704 = f__$1.call(null,inst_58703);
var state_58706__$1 = state_58706;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58706__$1,inst_58704);
} else {
return null;
}
}
});})(c__38457__auto__,f__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__38344__auto__ = null;
var cljs$core$async$transduce_$_state_machine__38344__auto____0 = (function (){
var statearr_58711 = [null,null,null,null,null,null,null];
(statearr_58711[(0)] = cljs$core$async$transduce_$_state_machine__38344__auto__);

(statearr_58711[(1)] = (1));

return statearr_58711;
});
var cljs$core$async$transduce_$_state_machine__38344__auto____1 = (function (state_58706){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_58706);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e58712){if((e58712 instanceof Object)){
var ex__38347__auto__ = e58712;
var statearr_58713_58715 = state_58706;
(statearr_58713_58715[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58706);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58712;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58716 = state_58706;
state_58706 = G__58716;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__38344__auto__ = function(state_58706){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__38344__auto____1.call(this,state_58706);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__38344__auto____0;
cljs$core$async$transduce_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__38344__auto____1;
return cljs$core$async$transduce_$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,f__$1))
})();
var state__38459__auto__ = (function (){var statearr_58714 = f__38458__auto__.call(null);
(statearr_58714[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_58714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,f__$1))
);

return c__38457__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args58717 = [];
var len__10640__auto___58769 = arguments.length;
var i__10641__auto___58770 = (0);
while(true){
if((i__10641__auto___58770 < len__10640__auto___58769)){
args58717.push((arguments[i__10641__auto___58770]));

var G__58771 = (i__10641__auto___58770 + (1));
i__10641__auto___58770 = G__58771;
continue;
} else {
}
break;
}

var G__58719 = args58717.length;
switch (G__58719) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args58717.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__){
return (function (state_58744){
var state_val_58745 = (state_58744[(1)]);
if((state_val_58745 === (7))){
var inst_58726 = (state_58744[(2)]);
var state_58744__$1 = state_58744;
var statearr_58746_58773 = state_58744__$1;
(statearr_58746_58773[(2)] = inst_58726);

(statearr_58746_58773[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58745 === (1))){
var inst_58720 = cljs.core.seq.call(null,coll);
var inst_58721 = inst_58720;
var state_58744__$1 = (function (){var statearr_58747 = state_58744;
(statearr_58747[(7)] = inst_58721);

return statearr_58747;
})();
var statearr_58748_58774 = state_58744__$1;
(statearr_58748_58774[(2)] = null);

(statearr_58748_58774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58745 === (4))){
var inst_58721 = (state_58744[(7)]);
var inst_58724 = cljs.core.first.call(null,inst_58721);
var state_58744__$1 = state_58744;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_58744__$1,(7),ch,inst_58724);
} else {
if((state_val_58745 === (13))){
var inst_58738 = (state_58744[(2)]);
var state_58744__$1 = state_58744;
var statearr_58749_58775 = state_58744__$1;
(statearr_58749_58775[(2)] = inst_58738);

(statearr_58749_58775[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58745 === (6))){
var inst_58729 = (state_58744[(2)]);
var state_58744__$1 = state_58744;
if(cljs.core.truth_(inst_58729)){
var statearr_58750_58776 = state_58744__$1;
(statearr_58750_58776[(1)] = (8));

} else {
var statearr_58751_58777 = state_58744__$1;
(statearr_58751_58777[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58745 === (3))){
var inst_58742 = (state_58744[(2)]);
var state_58744__$1 = state_58744;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58744__$1,inst_58742);
} else {
if((state_val_58745 === (12))){
var state_58744__$1 = state_58744;
var statearr_58752_58778 = state_58744__$1;
(statearr_58752_58778[(2)] = null);

(statearr_58752_58778[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58745 === (2))){
var inst_58721 = (state_58744[(7)]);
var state_58744__$1 = state_58744;
if(cljs.core.truth_(inst_58721)){
var statearr_58753_58779 = state_58744__$1;
(statearr_58753_58779[(1)] = (4));

} else {
var statearr_58754_58780 = state_58744__$1;
(statearr_58754_58780[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58745 === (11))){
var inst_58735 = cljs.core.async.close_BANG_.call(null,ch);
var state_58744__$1 = state_58744;
var statearr_58755_58781 = state_58744__$1;
(statearr_58755_58781[(2)] = inst_58735);

(statearr_58755_58781[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58745 === (9))){
var state_58744__$1 = state_58744;
if(cljs.core.truth_(close_QMARK_)){
var statearr_58756_58782 = state_58744__$1;
(statearr_58756_58782[(1)] = (11));

} else {
var statearr_58757_58783 = state_58744__$1;
(statearr_58757_58783[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58745 === (5))){
var inst_58721 = (state_58744[(7)]);
var state_58744__$1 = state_58744;
var statearr_58758_58784 = state_58744__$1;
(statearr_58758_58784[(2)] = inst_58721);

(statearr_58758_58784[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58745 === (10))){
var inst_58740 = (state_58744[(2)]);
var state_58744__$1 = state_58744;
var statearr_58759_58785 = state_58744__$1;
(statearr_58759_58785[(2)] = inst_58740);

(statearr_58759_58785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58745 === (8))){
var inst_58721 = (state_58744[(7)]);
var inst_58731 = cljs.core.next.call(null,inst_58721);
var inst_58721__$1 = inst_58731;
var state_58744__$1 = (function (){var statearr_58760 = state_58744;
(statearr_58760[(7)] = inst_58721__$1);

return statearr_58760;
})();
var statearr_58761_58786 = state_58744__$1;
(statearr_58761_58786[(2)] = null);

(statearr_58761_58786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto__))
;
return ((function (switch__38343__auto__,c__38457__auto__){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_58765 = [null,null,null,null,null,null,null,null];
(statearr_58765[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_58765[(1)] = (1));

return statearr_58765;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_58744){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_58744);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e58766){if((e58766 instanceof Object)){
var ex__38347__auto__ = e58766;
var statearr_58767_58787 = state_58744;
(statearr_58767_58787[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_58744);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e58766;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58788 = state_58744;
state_58744 = G__58788;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_58744){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_58744);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__))
})();
var state__38459__auto__ = (function (){var statearr_58768 = f__38458__auto__.call(null);
(statearr_58768[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_58768;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__))
);

return c__38457__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__10137__auto__ = (((_ == null))?null:_);
var m__10138__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,_);
} else {
var m__10138__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async59014 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59014 = (function (ch,cs,meta59015){
this.ch = ch;
this.cs = cs;
this.meta59015 = meta59015;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async59014.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_59016,meta59015__$1){
var self__ = this;
var _59016__$1 = this;
return (new cljs.core.async.t_cljs$core$async59014(self__.ch,self__.cs,meta59015__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async59014.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_59016){
var self__ = this;
var _59016__$1 = this;
return self__.meta59015;
});})(cs))
;

cljs.core.async.t_cljs$core$async59014.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59014.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async59014.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59014.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async59014.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async59014.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async59014.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta59015","meta59015",1302135514,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async59014.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59014.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59014";

cljs.core.async.t_cljs$core$async59014.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async59014");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async59014 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async59014(ch__$1,cs__$1,meta59015){
return (new cljs.core.async.t_cljs$core$async59014(ch__$1,cs__$1,meta59015));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async59014(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__38457__auto___59239 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___59239,cs,m,dchan,dctr,done){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___59239,cs,m,dchan,dctr,done){
return (function (state_59151){
var state_val_59152 = (state_59151[(1)]);
if((state_val_59152 === (7))){
var inst_59147 = (state_59151[(2)]);
var state_59151__$1 = state_59151;
var statearr_59153_59240 = state_59151__$1;
(statearr_59153_59240[(2)] = inst_59147);

(statearr_59153_59240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (20))){
var inst_59050 = (state_59151[(7)]);
var inst_59062 = cljs.core.first.call(null,inst_59050);
var inst_59063 = cljs.core.nth.call(null,inst_59062,(0),null);
var inst_59064 = cljs.core.nth.call(null,inst_59062,(1),null);
var state_59151__$1 = (function (){var statearr_59154 = state_59151;
(statearr_59154[(8)] = inst_59063);

return statearr_59154;
})();
if(cljs.core.truth_(inst_59064)){
var statearr_59155_59241 = state_59151__$1;
(statearr_59155_59241[(1)] = (22));

} else {
var statearr_59156_59242 = state_59151__$1;
(statearr_59156_59242[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (27))){
var inst_59092 = (state_59151[(9)]);
var inst_59094 = (state_59151[(10)]);
var inst_59099 = (state_59151[(11)]);
var inst_59019 = (state_59151[(12)]);
var inst_59099__$1 = cljs.core._nth.call(null,inst_59092,inst_59094);
var inst_59100 = cljs.core.async.put_BANG_.call(null,inst_59099__$1,inst_59019,done);
var state_59151__$1 = (function (){var statearr_59157 = state_59151;
(statearr_59157[(11)] = inst_59099__$1);

return statearr_59157;
})();
if(cljs.core.truth_(inst_59100)){
var statearr_59158_59243 = state_59151__$1;
(statearr_59158_59243[(1)] = (30));

} else {
var statearr_59159_59244 = state_59151__$1;
(statearr_59159_59244[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (1))){
var state_59151__$1 = state_59151;
var statearr_59160_59245 = state_59151__$1;
(statearr_59160_59245[(2)] = null);

(statearr_59160_59245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (24))){
var inst_59050 = (state_59151[(7)]);
var inst_59069 = (state_59151[(2)]);
var inst_59070 = cljs.core.next.call(null,inst_59050);
var inst_59028 = inst_59070;
var inst_59029 = null;
var inst_59030 = (0);
var inst_59031 = (0);
var state_59151__$1 = (function (){var statearr_59161 = state_59151;
(statearr_59161[(13)] = inst_59029);

(statearr_59161[(14)] = inst_59031);

(statearr_59161[(15)] = inst_59028);

(statearr_59161[(16)] = inst_59069);

(statearr_59161[(17)] = inst_59030);

return statearr_59161;
})();
var statearr_59162_59246 = state_59151__$1;
(statearr_59162_59246[(2)] = null);

(statearr_59162_59246[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (39))){
var state_59151__$1 = state_59151;
var statearr_59166_59247 = state_59151__$1;
(statearr_59166_59247[(2)] = null);

(statearr_59166_59247[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (4))){
var inst_59019 = (state_59151[(12)]);
var inst_59019__$1 = (state_59151[(2)]);
var inst_59020 = (inst_59019__$1 == null);
var state_59151__$1 = (function (){var statearr_59167 = state_59151;
(statearr_59167[(12)] = inst_59019__$1);

return statearr_59167;
})();
if(cljs.core.truth_(inst_59020)){
var statearr_59168_59248 = state_59151__$1;
(statearr_59168_59248[(1)] = (5));

} else {
var statearr_59169_59249 = state_59151__$1;
(statearr_59169_59249[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (15))){
var inst_59029 = (state_59151[(13)]);
var inst_59031 = (state_59151[(14)]);
var inst_59028 = (state_59151[(15)]);
var inst_59030 = (state_59151[(17)]);
var inst_59046 = (state_59151[(2)]);
var inst_59047 = (inst_59031 + (1));
var tmp59163 = inst_59029;
var tmp59164 = inst_59028;
var tmp59165 = inst_59030;
var inst_59028__$1 = tmp59164;
var inst_59029__$1 = tmp59163;
var inst_59030__$1 = tmp59165;
var inst_59031__$1 = inst_59047;
var state_59151__$1 = (function (){var statearr_59170 = state_59151;
(statearr_59170[(13)] = inst_59029__$1);

(statearr_59170[(18)] = inst_59046);

(statearr_59170[(14)] = inst_59031__$1);

(statearr_59170[(15)] = inst_59028__$1);

(statearr_59170[(17)] = inst_59030__$1);

return statearr_59170;
})();
var statearr_59171_59250 = state_59151__$1;
(statearr_59171_59250[(2)] = null);

(statearr_59171_59250[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (21))){
var inst_59073 = (state_59151[(2)]);
var state_59151__$1 = state_59151;
var statearr_59175_59251 = state_59151__$1;
(statearr_59175_59251[(2)] = inst_59073);

(statearr_59175_59251[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (31))){
var inst_59099 = (state_59151[(11)]);
var inst_59103 = done.call(null,null);
var inst_59104 = cljs.core.async.untap_STAR_.call(null,m,inst_59099);
var state_59151__$1 = (function (){var statearr_59176 = state_59151;
(statearr_59176[(19)] = inst_59103);

return statearr_59176;
})();
var statearr_59177_59252 = state_59151__$1;
(statearr_59177_59252[(2)] = inst_59104);

(statearr_59177_59252[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (32))){
var inst_59091 = (state_59151[(20)]);
var inst_59092 = (state_59151[(9)]);
var inst_59094 = (state_59151[(10)]);
var inst_59093 = (state_59151[(21)]);
var inst_59106 = (state_59151[(2)]);
var inst_59107 = (inst_59094 + (1));
var tmp59172 = inst_59091;
var tmp59173 = inst_59092;
var tmp59174 = inst_59093;
var inst_59091__$1 = tmp59172;
var inst_59092__$1 = tmp59173;
var inst_59093__$1 = tmp59174;
var inst_59094__$1 = inst_59107;
var state_59151__$1 = (function (){var statearr_59178 = state_59151;
(statearr_59178[(20)] = inst_59091__$1);

(statearr_59178[(9)] = inst_59092__$1);

(statearr_59178[(10)] = inst_59094__$1);

(statearr_59178[(21)] = inst_59093__$1);

(statearr_59178[(22)] = inst_59106);

return statearr_59178;
})();
var statearr_59179_59253 = state_59151__$1;
(statearr_59179_59253[(2)] = null);

(statearr_59179_59253[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (40))){
var inst_59119 = (state_59151[(23)]);
var inst_59123 = done.call(null,null);
var inst_59124 = cljs.core.async.untap_STAR_.call(null,m,inst_59119);
var state_59151__$1 = (function (){var statearr_59180 = state_59151;
(statearr_59180[(24)] = inst_59123);

return statearr_59180;
})();
var statearr_59181_59254 = state_59151__$1;
(statearr_59181_59254[(2)] = inst_59124);

(statearr_59181_59254[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (33))){
var inst_59110 = (state_59151[(25)]);
var inst_59112 = cljs.core.chunked_seq_QMARK_.call(null,inst_59110);
var state_59151__$1 = state_59151;
if(inst_59112){
var statearr_59182_59255 = state_59151__$1;
(statearr_59182_59255[(1)] = (36));

} else {
var statearr_59183_59256 = state_59151__$1;
(statearr_59183_59256[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (13))){
var inst_59040 = (state_59151[(26)]);
var inst_59043 = cljs.core.async.close_BANG_.call(null,inst_59040);
var state_59151__$1 = state_59151;
var statearr_59184_59257 = state_59151__$1;
(statearr_59184_59257[(2)] = inst_59043);

(statearr_59184_59257[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (22))){
var inst_59063 = (state_59151[(8)]);
var inst_59066 = cljs.core.async.close_BANG_.call(null,inst_59063);
var state_59151__$1 = state_59151;
var statearr_59185_59258 = state_59151__$1;
(statearr_59185_59258[(2)] = inst_59066);

(statearr_59185_59258[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (36))){
var inst_59110 = (state_59151[(25)]);
var inst_59114 = cljs.core.chunk_first.call(null,inst_59110);
var inst_59115 = cljs.core.chunk_rest.call(null,inst_59110);
var inst_59116 = cljs.core.count.call(null,inst_59114);
var inst_59091 = inst_59115;
var inst_59092 = inst_59114;
var inst_59093 = inst_59116;
var inst_59094 = (0);
var state_59151__$1 = (function (){var statearr_59186 = state_59151;
(statearr_59186[(20)] = inst_59091);

(statearr_59186[(9)] = inst_59092);

(statearr_59186[(10)] = inst_59094);

(statearr_59186[(21)] = inst_59093);

return statearr_59186;
})();
var statearr_59187_59259 = state_59151__$1;
(statearr_59187_59259[(2)] = null);

(statearr_59187_59259[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (41))){
var inst_59110 = (state_59151[(25)]);
var inst_59126 = (state_59151[(2)]);
var inst_59127 = cljs.core.next.call(null,inst_59110);
var inst_59091 = inst_59127;
var inst_59092 = null;
var inst_59093 = (0);
var inst_59094 = (0);
var state_59151__$1 = (function (){var statearr_59188 = state_59151;
(statearr_59188[(20)] = inst_59091);

(statearr_59188[(9)] = inst_59092);

(statearr_59188[(10)] = inst_59094);

(statearr_59188[(21)] = inst_59093);

(statearr_59188[(27)] = inst_59126);

return statearr_59188;
})();
var statearr_59189_59260 = state_59151__$1;
(statearr_59189_59260[(2)] = null);

(statearr_59189_59260[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (43))){
var state_59151__$1 = state_59151;
var statearr_59190_59261 = state_59151__$1;
(statearr_59190_59261[(2)] = null);

(statearr_59190_59261[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (29))){
var inst_59135 = (state_59151[(2)]);
var state_59151__$1 = state_59151;
var statearr_59191_59262 = state_59151__$1;
(statearr_59191_59262[(2)] = inst_59135);

(statearr_59191_59262[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (44))){
var inst_59144 = (state_59151[(2)]);
var state_59151__$1 = (function (){var statearr_59192 = state_59151;
(statearr_59192[(28)] = inst_59144);

return statearr_59192;
})();
var statearr_59193_59263 = state_59151__$1;
(statearr_59193_59263[(2)] = null);

(statearr_59193_59263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (6))){
var inst_59083 = (state_59151[(29)]);
var inst_59082 = cljs.core.deref.call(null,cs);
var inst_59083__$1 = cljs.core.keys.call(null,inst_59082);
var inst_59084 = cljs.core.count.call(null,inst_59083__$1);
var inst_59085 = cljs.core.reset_BANG_.call(null,dctr,inst_59084);
var inst_59090 = cljs.core.seq.call(null,inst_59083__$1);
var inst_59091 = inst_59090;
var inst_59092 = null;
var inst_59093 = (0);
var inst_59094 = (0);
var state_59151__$1 = (function (){var statearr_59194 = state_59151;
(statearr_59194[(29)] = inst_59083__$1);

(statearr_59194[(20)] = inst_59091);

(statearr_59194[(9)] = inst_59092);

(statearr_59194[(10)] = inst_59094);

(statearr_59194[(21)] = inst_59093);

(statearr_59194[(30)] = inst_59085);

return statearr_59194;
})();
var statearr_59195_59264 = state_59151__$1;
(statearr_59195_59264[(2)] = null);

(statearr_59195_59264[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (28))){
var inst_59091 = (state_59151[(20)]);
var inst_59110 = (state_59151[(25)]);
var inst_59110__$1 = cljs.core.seq.call(null,inst_59091);
var state_59151__$1 = (function (){var statearr_59196 = state_59151;
(statearr_59196[(25)] = inst_59110__$1);

return statearr_59196;
})();
if(inst_59110__$1){
var statearr_59197_59265 = state_59151__$1;
(statearr_59197_59265[(1)] = (33));

} else {
var statearr_59198_59266 = state_59151__$1;
(statearr_59198_59266[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (25))){
var inst_59094 = (state_59151[(10)]);
var inst_59093 = (state_59151[(21)]);
var inst_59096 = (inst_59094 < inst_59093);
var inst_59097 = inst_59096;
var state_59151__$1 = state_59151;
if(cljs.core.truth_(inst_59097)){
var statearr_59199_59267 = state_59151__$1;
(statearr_59199_59267[(1)] = (27));

} else {
var statearr_59200_59268 = state_59151__$1;
(statearr_59200_59268[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (34))){
var state_59151__$1 = state_59151;
var statearr_59201_59269 = state_59151__$1;
(statearr_59201_59269[(2)] = null);

(statearr_59201_59269[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (17))){
var state_59151__$1 = state_59151;
var statearr_59202_59270 = state_59151__$1;
(statearr_59202_59270[(2)] = null);

(statearr_59202_59270[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (3))){
var inst_59149 = (state_59151[(2)]);
var state_59151__$1 = state_59151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59151__$1,inst_59149);
} else {
if((state_val_59152 === (12))){
var inst_59078 = (state_59151[(2)]);
var state_59151__$1 = state_59151;
var statearr_59203_59271 = state_59151__$1;
(statearr_59203_59271[(2)] = inst_59078);

(statearr_59203_59271[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (2))){
var state_59151__$1 = state_59151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59151__$1,(4),ch);
} else {
if((state_val_59152 === (23))){
var state_59151__$1 = state_59151;
var statearr_59204_59272 = state_59151__$1;
(statearr_59204_59272[(2)] = null);

(statearr_59204_59272[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (35))){
var inst_59133 = (state_59151[(2)]);
var state_59151__$1 = state_59151;
var statearr_59205_59273 = state_59151__$1;
(statearr_59205_59273[(2)] = inst_59133);

(statearr_59205_59273[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (19))){
var inst_59050 = (state_59151[(7)]);
var inst_59054 = cljs.core.chunk_first.call(null,inst_59050);
var inst_59055 = cljs.core.chunk_rest.call(null,inst_59050);
var inst_59056 = cljs.core.count.call(null,inst_59054);
var inst_59028 = inst_59055;
var inst_59029 = inst_59054;
var inst_59030 = inst_59056;
var inst_59031 = (0);
var state_59151__$1 = (function (){var statearr_59206 = state_59151;
(statearr_59206[(13)] = inst_59029);

(statearr_59206[(14)] = inst_59031);

(statearr_59206[(15)] = inst_59028);

(statearr_59206[(17)] = inst_59030);

return statearr_59206;
})();
var statearr_59207_59274 = state_59151__$1;
(statearr_59207_59274[(2)] = null);

(statearr_59207_59274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (11))){
var inst_59028 = (state_59151[(15)]);
var inst_59050 = (state_59151[(7)]);
var inst_59050__$1 = cljs.core.seq.call(null,inst_59028);
var state_59151__$1 = (function (){var statearr_59208 = state_59151;
(statearr_59208[(7)] = inst_59050__$1);

return statearr_59208;
})();
if(inst_59050__$1){
var statearr_59209_59275 = state_59151__$1;
(statearr_59209_59275[(1)] = (16));

} else {
var statearr_59210_59276 = state_59151__$1;
(statearr_59210_59276[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (9))){
var inst_59080 = (state_59151[(2)]);
var state_59151__$1 = state_59151;
var statearr_59211_59277 = state_59151__$1;
(statearr_59211_59277[(2)] = inst_59080);

(statearr_59211_59277[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (5))){
var inst_59026 = cljs.core.deref.call(null,cs);
var inst_59027 = cljs.core.seq.call(null,inst_59026);
var inst_59028 = inst_59027;
var inst_59029 = null;
var inst_59030 = (0);
var inst_59031 = (0);
var state_59151__$1 = (function (){var statearr_59212 = state_59151;
(statearr_59212[(13)] = inst_59029);

(statearr_59212[(14)] = inst_59031);

(statearr_59212[(15)] = inst_59028);

(statearr_59212[(17)] = inst_59030);

return statearr_59212;
})();
var statearr_59213_59278 = state_59151__$1;
(statearr_59213_59278[(2)] = null);

(statearr_59213_59278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (14))){
var state_59151__$1 = state_59151;
var statearr_59214_59279 = state_59151__$1;
(statearr_59214_59279[(2)] = null);

(statearr_59214_59279[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (45))){
var inst_59141 = (state_59151[(2)]);
var state_59151__$1 = state_59151;
var statearr_59215_59280 = state_59151__$1;
(statearr_59215_59280[(2)] = inst_59141);

(statearr_59215_59280[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (26))){
var inst_59083 = (state_59151[(29)]);
var inst_59137 = (state_59151[(2)]);
var inst_59138 = cljs.core.seq.call(null,inst_59083);
var state_59151__$1 = (function (){var statearr_59216 = state_59151;
(statearr_59216[(31)] = inst_59137);

return statearr_59216;
})();
if(inst_59138){
var statearr_59217_59281 = state_59151__$1;
(statearr_59217_59281[(1)] = (42));

} else {
var statearr_59218_59282 = state_59151__$1;
(statearr_59218_59282[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (16))){
var inst_59050 = (state_59151[(7)]);
var inst_59052 = cljs.core.chunked_seq_QMARK_.call(null,inst_59050);
var state_59151__$1 = state_59151;
if(inst_59052){
var statearr_59219_59283 = state_59151__$1;
(statearr_59219_59283[(1)] = (19));

} else {
var statearr_59220_59284 = state_59151__$1;
(statearr_59220_59284[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (38))){
var inst_59130 = (state_59151[(2)]);
var state_59151__$1 = state_59151;
var statearr_59221_59285 = state_59151__$1;
(statearr_59221_59285[(2)] = inst_59130);

(statearr_59221_59285[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (30))){
var state_59151__$1 = state_59151;
var statearr_59222_59286 = state_59151__$1;
(statearr_59222_59286[(2)] = null);

(statearr_59222_59286[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (10))){
var inst_59029 = (state_59151[(13)]);
var inst_59031 = (state_59151[(14)]);
var inst_59039 = cljs.core._nth.call(null,inst_59029,inst_59031);
var inst_59040 = cljs.core.nth.call(null,inst_59039,(0),null);
var inst_59041 = cljs.core.nth.call(null,inst_59039,(1),null);
var state_59151__$1 = (function (){var statearr_59223 = state_59151;
(statearr_59223[(26)] = inst_59040);

return statearr_59223;
})();
if(cljs.core.truth_(inst_59041)){
var statearr_59224_59287 = state_59151__$1;
(statearr_59224_59287[(1)] = (13));

} else {
var statearr_59225_59288 = state_59151__$1;
(statearr_59225_59288[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (18))){
var inst_59076 = (state_59151[(2)]);
var state_59151__$1 = state_59151;
var statearr_59226_59289 = state_59151__$1;
(statearr_59226_59289[(2)] = inst_59076);

(statearr_59226_59289[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (42))){
var state_59151__$1 = state_59151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59151__$1,(45),dchan);
} else {
if((state_val_59152 === (37))){
var inst_59110 = (state_59151[(25)]);
var inst_59119 = (state_59151[(23)]);
var inst_59019 = (state_59151[(12)]);
var inst_59119__$1 = cljs.core.first.call(null,inst_59110);
var inst_59120 = cljs.core.async.put_BANG_.call(null,inst_59119__$1,inst_59019,done);
var state_59151__$1 = (function (){var statearr_59227 = state_59151;
(statearr_59227[(23)] = inst_59119__$1);

return statearr_59227;
})();
if(cljs.core.truth_(inst_59120)){
var statearr_59228_59290 = state_59151__$1;
(statearr_59228_59290[(1)] = (39));

} else {
var statearr_59229_59291 = state_59151__$1;
(statearr_59229_59291[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59152 === (8))){
var inst_59031 = (state_59151[(14)]);
var inst_59030 = (state_59151[(17)]);
var inst_59033 = (inst_59031 < inst_59030);
var inst_59034 = inst_59033;
var state_59151__$1 = state_59151;
if(cljs.core.truth_(inst_59034)){
var statearr_59230_59292 = state_59151__$1;
(statearr_59230_59292[(1)] = (10));

} else {
var statearr_59231_59293 = state_59151__$1;
(statearr_59231_59293[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___59239,cs,m,dchan,dctr,done))
;
return ((function (switch__38343__auto__,c__38457__auto___59239,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__38344__auto__ = null;
var cljs$core$async$mult_$_state_machine__38344__auto____0 = (function (){
var statearr_59235 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59235[(0)] = cljs$core$async$mult_$_state_machine__38344__auto__);

(statearr_59235[(1)] = (1));

return statearr_59235;
});
var cljs$core$async$mult_$_state_machine__38344__auto____1 = (function (state_59151){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_59151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e59236){if((e59236 instanceof Object)){
var ex__38347__auto__ = e59236;
var statearr_59237_59294 = state_59151;
(statearr_59237_59294[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59151);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59236;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59295 = state_59151;
state_59151 = G__59295;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__38344__auto__ = function(state_59151){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__38344__auto____1.call(this,state_59151);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__38344__auto____0;
cljs$core$async$mult_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__38344__auto____1;
return cljs$core$async$mult_$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___59239,cs,m,dchan,dctr,done))
})();
var state__38459__auto__ = (function (){var statearr_59238 = f__38458__auto__.call(null);
(statearr_59238[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___59239);

return statearr_59238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___59239,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args59296 = [];
var len__10640__auto___59299 = arguments.length;
var i__10641__auto___59300 = (0);
while(true){
if((i__10641__auto___59300 < len__10640__auto___59299)){
args59296.push((arguments[i__10641__auto___59300]));

var G__59301 = (i__10641__auto___59300 + (1));
i__10641__auto___59300 = G__59301;
continue;
} else {
}
break;
}

var G__59298 = args59296.length;
switch (G__59298) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59296.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,state_map);
} else {
var m__10138__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,mode);
} else {
var m__10138__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___59313 = arguments.length;
var i__10641__auto___59314 = (0);
while(true){
if((i__10641__auto___59314 < len__10640__auto___59313)){
args__10647__auto__.push((arguments[i__10641__auto___59314]));

var G__59315 = (i__10641__auto___59314 + (1));
i__10641__auto___59314 = G__59315;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__59307){
var map__59308 = p__59307;
var map__59308__$1 = ((((!((map__59308 == null)))?((((map__59308.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__59308.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__59308):map__59308);
var opts = map__59308__$1;
var statearr_59310_59316 = state;
(statearr_59310_59316[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6738__auto__ = cljs.core.async.do_alts.call(null,((function (map__59308,map__59308__$1,opts){
return (function (val){
var statearr_59311_59317 = state;
(statearr_59311_59317[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__59308,map__59308__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6738__auto__)){
var cb = temp__6738__auto__;
var statearr_59312_59318 = state;
(statearr_59312_59318[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq59303){
var G__59304 = cljs.core.first.call(null,seq59303);
var seq59303__$1 = cljs.core.next.call(null,seq59303);
var G__59305 = cljs.core.first.call(null,seq59303__$1);
var seq59303__$2 = cljs.core.next.call(null,seq59303__$1);
var G__59306 = cljs.core.first.call(null,seq59303__$2);
var seq59303__$3 = cljs.core.next.call(null,seq59303__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__59304,G__59305,G__59306,seq59303__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async59486 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59486 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta59487){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta59487 = meta59487;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async59486.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_59488,meta59487__$1){
var self__ = this;
var _59488__$1 = this;
return (new cljs.core.async.t_cljs$core$async59486(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta59487__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59486.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_59488){
var self__ = this;
var _59488__$1 = this;
return self__.meta59487;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59486.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59486.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59486.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59486.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59486.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59486.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59486.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59486.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59486.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta59487","meta59487",1763201571,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async59486.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59486.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59486";

cljs.core.async.t_cljs$core$async59486.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async59486");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async59486 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async59486(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta59487){
return (new cljs.core.async.t_cljs$core$async59486(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta59487));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async59486(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38457__auto___59653 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___59653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___59653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_59590){
var state_val_59591 = (state_59590[(1)]);
if((state_val_59591 === (7))){
var inst_59505 = (state_59590[(2)]);
var state_59590__$1 = state_59590;
var statearr_59592_59654 = state_59590__$1;
(statearr_59592_59654[(2)] = inst_59505);

(statearr_59592_59654[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (20))){
var inst_59517 = (state_59590[(7)]);
var state_59590__$1 = state_59590;
var statearr_59593_59655 = state_59590__$1;
(statearr_59593_59655[(2)] = inst_59517);

(statearr_59593_59655[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (27))){
var state_59590__$1 = state_59590;
var statearr_59594_59656 = state_59590__$1;
(statearr_59594_59656[(2)] = null);

(statearr_59594_59656[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (1))){
var inst_59492 = (state_59590[(8)]);
var inst_59492__$1 = calc_state.call(null);
var inst_59494 = (inst_59492__$1 == null);
var inst_59495 = cljs.core.not.call(null,inst_59494);
var state_59590__$1 = (function (){var statearr_59595 = state_59590;
(statearr_59595[(8)] = inst_59492__$1);

return statearr_59595;
})();
if(inst_59495){
var statearr_59596_59657 = state_59590__$1;
(statearr_59596_59657[(1)] = (2));

} else {
var statearr_59597_59658 = state_59590__$1;
(statearr_59597_59658[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (24))){
var inst_59541 = (state_59590[(9)]);
var inst_59564 = (state_59590[(10)]);
var inst_59550 = (state_59590[(11)]);
var inst_59564__$1 = inst_59541.call(null,inst_59550);
var state_59590__$1 = (function (){var statearr_59598 = state_59590;
(statearr_59598[(10)] = inst_59564__$1);

return statearr_59598;
})();
if(cljs.core.truth_(inst_59564__$1)){
var statearr_59599_59659 = state_59590__$1;
(statearr_59599_59659[(1)] = (29));

} else {
var statearr_59600_59660 = state_59590__$1;
(statearr_59600_59660[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (4))){
var inst_59508 = (state_59590[(2)]);
var state_59590__$1 = state_59590;
if(cljs.core.truth_(inst_59508)){
var statearr_59601_59661 = state_59590__$1;
(statearr_59601_59661[(1)] = (8));

} else {
var statearr_59602_59662 = state_59590__$1;
(statearr_59602_59662[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (15))){
var inst_59535 = (state_59590[(2)]);
var state_59590__$1 = state_59590;
if(cljs.core.truth_(inst_59535)){
var statearr_59603_59663 = state_59590__$1;
(statearr_59603_59663[(1)] = (19));

} else {
var statearr_59604_59664 = state_59590__$1;
(statearr_59604_59664[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (21))){
var inst_59540 = (state_59590[(12)]);
var inst_59540__$1 = (state_59590[(2)]);
var inst_59541 = cljs.core.get.call(null,inst_59540__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_59542 = cljs.core.get.call(null,inst_59540__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_59543 = cljs.core.get.call(null,inst_59540__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_59590__$1 = (function (){var statearr_59605 = state_59590;
(statearr_59605[(9)] = inst_59541);

(statearr_59605[(13)] = inst_59542);

(statearr_59605[(12)] = inst_59540__$1);

return statearr_59605;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_59590__$1,(22),inst_59543);
} else {
if((state_val_59591 === (31))){
var inst_59572 = (state_59590[(2)]);
var state_59590__$1 = state_59590;
if(cljs.core.truth_(inst_59572)){
var statearr_59606_59665 = state_59590__$1;
(statearr_59606_59665[(1)] = (32));

} else {
var statearr_59607_59666 = state_59590__$1;
(statearr_59607_59666[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (32))){
var inst_59549 = (state_59590[(14)]);
var state_59590__$1 = state_59590;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59590__$1,(35),out,inst_59549);
} else {
if((state_val_59591 === (33))){
var inst_59540 = (state_59590[(12)]);
var inst_59517 = inst_59540;
var state_59590__$1 = (function (){var statearr_59608 = state_59590;
(statearr_59608[(7)] = inst_59517);

return statearr_59608;
})();
var statearr_59609_59667 = state_59590__$1;
(statearr_59609_59667[(2)] = null);

(statearr_59609_59667[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (13))){
var inst_59517 = (state_59590[(7)]);
var inst_59524 = inst_59517.cljs$lang$protocol_mask$partition0$;
var inst_59525 = (inst_59524 & (64));
var inst_59526 = inst_59517.cljs$core$ISeq$;
var inst_59527 = (cljs.core.PROTOCOL_SENTINEL === inst_59526);
var inst_59528 = (inst_59525) || (inst_59527);
var state_59590__$1 = state_59590;
if(cljs.core.truth_(inst_59528)){
var statearr_59610_59668 = state_59590__$1;
(statearr_59610_59668[(1)] = (16));

} else {
var statearr_59611_59669 = state_59590__$1;
(statearr_59611_59669[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (22))){
var inst_59550 = (state_59590[(11)]);
var inst_59549 = (state_59590[(14)]);
var inst_59548 = (state_59590[(2)]);
var inst_59549__$1 = cljs.core.nth.call(null,inst_59548,(0),null);
var inst_59550__$1 = cljs.core.nth.call(null,inst_59548,(1),null);
var inst_59551 = (inst_59549__$1 == null);
var inst_59552 = cljs.core._EQ_.call(null,inst_59550__$1,change);
var inst_59553 = (inst_59551) || (inst_59552);
var state_59590__$1 = (function (){var statearr_59612 = state_59590;
(statearr_59612[(11)] = inst_59550__$1);

(statearr_59612[(14)] = inst_59549__$1);

return statearr_59612;
})();
if(cljs.core.truth_(inst_59553)){
var statearr_59613_59670 = state_59590__$1;
(statearr_59613_59670[(1)] = (23));

} else {
var statearr_59614_59671 = state_59590__$1;
(statearr_59614_59671[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (36))){
var inst_59540 = (state_59590[(12)]);
var inst_59517 = inst_59540;
var state_59590__$1 = (function (){var statearr_59615 = state_59590;
(statearr_59615[(7)] = inst_59517);

return statearr_59615;
})();
var statearr_59616_59672 = state_59590__$1;
(statearr_59616_59672[(2)] = null);

(statearr_59616_59672[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (29))){
var inst_59564 = (state_59590[(10)]);
var state_59590__$1 = state_59590;
var statearr_59617_59673 = state_59590__$1;
(statearr_59617_59673[(2)] = inst_59564);

(statearr_59617_59673[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (6))){
var state_59590__$1 = state_59590;
var statearr_59618_59674 = state_59590__$1;
(statearr_59618_59674[(2)] = false);

(statearr_59618_59674[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (28))){
var inst_59560 = (state_59590[(2)]);
var inst_59561 = calc_state.call(null);
var inst_59517 = inst_59561;
var state_59590__$1 = (function (){var statearr_59619 = state_59590;
(statearr_59619[(15)] = inst_59560);

(statearr_59619[(7)] = inst_59517);

return statearr_59619;
})();
var statearr_59620_59675 = state_59590__$1;
(statearr_59620_59675[(2)] = null);

(statearr_59620_59675[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (25))){
var inst_59586 = (state_59590[(2)]);
var state_59590__$1 = state_59590;
var statearr_59621_59676 = state_59590__$1;
(statearr_59621_59676[(2)] = inst_59586);

(statearr_59621_59676[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (34))){
var inst_59584 = (state_59590[(2)]);
var state_59590__$1 = state_59590;
var statearr_59622_59677 = state_59590__$1;
(statearr_59622_59677[(2)] = inst_59584);

(statearr_59622_59677[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (17))){
var state_59590__$1 = state_59590;
var statearr_59623_59678 = state_59590__$1;
(statearr_59623_59678[(2)] = false);

(statearr_59623_59678[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (3))){
var state_59590__$1 = state_59590;
var statearr_59624_59679 = state_59590__$1;
(statearr_59624_59679[(2)] = false);

(statearr_59624_59679[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (12))){
var inst_59588 = (state_59590[(2)]);
var state_59590__$1 = state_59590;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59590__$1,inst_59588);
} else {
if((state_val_59591 === (2))){
var inst_59492 = (state_59590[(8)]);
var inst_59497 = inst_59492.cljs$lang$protocol_mask$partition0$;
var inst_59498 = (inst_59497 & (64));
var inst_59499 = inst_59492.cljs$core$ISeq$;
var inst_59500 = (cljs.core.PROTOCOL_SENTINEL === inst_59499);
var inst_59501 = (inst_59498) || (inst_59500);
var state_59590__$1 = state_59590;
if(cljs.core.truth_(inst_59501)){
var statearr_59625_59680 = state_59590__$1;
(statearr_59625_59680[(1)] = (5));

} else {
var statearr_59626_59681 = state_59590__$1;
(statearr_59626_59681[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (23))){
var inst_59549 = (state_59590[(14)]);
var inst_59555 = (inst_59549 == null);
var state_59590__$1 = state_59590;
if(cljs.core.truth_(inst_59555)){
var statearr_59627_59682 = state_59590__$1;
(statearr_59627_59682[(1)] = (26));

} else {
var statearr_59628_59683 = state_59590__$1;
(statearr_59628_59683[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (35))){
var inst_59575 = (state_59590[(2)]);
var state_59590__$1 = state_59590;
if(cljs.core.truth_(inst_59575)){
var statearr_59629_59684 = state_59590__$1;
(statearr_59629_59684[(1)] = (36));

} else {
var statearr_59630_59685 = state_59590__$1;
(statearr_59630_59685[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (19))){
var inst_59517 = (state_59590[(7)]);
var inst_59537 = cljs.core.apply.call(null,cljs.core.hash_map,inst_59517);
var state_59590__$1 = state_59590;
var statearr_59631_59686 = state_59590__$1;
(statearr_59631_59686[(2)] = inst_59537);

(statearr_59631_59686[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (11))){
var inst_59517 = (state_59590[(7)]);
var inst_59521 = (inst_59517 == null);
var inst_59522 = cljs.core.not.call(null,inst_59521);
var state_59590__$1 = state_59590;
if(inst_59522){
var statearr_59632_59687 = state_59590__$1;
(statearr_59632_59687[(1)] = (13));

} else {
var statearr_59633_59688 = state_59590__$1;
(statearr_59633_59688[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (9))){
var inst_59492 = (state_59590[(8)]);
var state_59590__$1 = state_59590;
var statearr_59634_59689 = state_59590__$1;
(statearr_59634_59689[(2)] = inst_59492);

(statearr_59634_59689[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (5))){
var state_59590__$1 = state_59590;
var statearr_59635_59690 = state_59590__$1;
(statearr_59635_59690[(2)] = true);

(statearr_59635_59690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (14))){
var state_59590__$1 = state_59590;
var statearr_59636_59691 = state_59590__$1;
(statearr_59636_59691[(2)] = false);

(statearr_59636_59691[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (26))){
var inst_59550 = (state_59590[(11)]);
var inst_59557 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_59550);
var state_59590__$1 = state_59590;
var statearr_59637_59692 = state_59590__$1;
(statearr_59637_59692[(2)] = inst_59557);

(statearr_59637_59692[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (16))){
var state_59590__$1 = state_59590;
var statearr_59638_59693 = state_59590__$1;
(statearr_59638_59693[(2)] = true);

(statearr_59638_59693[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (38))){
var inst_59580 = (state_59590[(2)]);
var state_59590__$1 = state_59590;
var statearr_59639_59694 = state_59590__$1;
(statearr_59639_59694[(2)] = inst_59580);

(statearr_59639_59694[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (30))){
var inst_59541 = (state_59590[(9)]);
var inst_59542 = (state_59590[(13)]);
var inst_59550 = (state_59590[(11)]);
var inst_59567 = cljs.core.empty_QMARK_.call(null,inst_59541);
var inst_59568 = inst_59542.call(null,inst_59550);
var inst_59569 = cljs.core.not.call(null,inst_59568);
var inst_59570 = (inst_59567) && (inst_59569);
var state_59590__$1 = state_59590;
var statearr_59640_59695 = state_59590__$1;
(statearr_59640_59695[(2)] = inst_59570);

(statearr_59640_59695[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (10))){
var inst_59492 = (state_59590[(8)]);
var inst_59513 = (state_59590[(2)]);
var inst_59514 = cljs.core.get.call(null,inst_59513,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_59515 = cljs.core.get.call(null,inst_59513,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_59516 = cljs.core.get.call(null,inst_59513,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_59517 = inst_59492;
var state_59590__$1 = (function (){var statearr_59641 = state_59590;
(statearr_59641[(16)] = inst_59515);

(statearr_59641[(17)] = inst_59516);

(statearr_59641[(18)] = inst_59514);

(statearr_59641[(7)] = inst_59517);

return statearr_59641;
})();
var statearr_59642_59696 = state_59590__$1;
(statearr_59642_59696[(2)] = null);

(statearr_59642_59696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (18))){
var inst_59532 = (state_59590[(2)]);
var state_59590__$1 = state_59590;
var statearr_59643_59697 = state_59590__$1;
(statearr_59643_59697[(2)] = inst_59532);

(statearr_59643_59697[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (37))){
var state_59590__$1 = state_59590;
var statearr_59644_59698 = state_59590__$1;
(statearr_59644_59698[(2)] = null);

(statearr_59644_59698[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59591 === (8))){
var inst_59492 = (state_59590[(8)]);
var inst_59510 = cljs.core.apply.call(null,cljs.core.hash_map,inst_59492);
var state_59590__$1 = state_59590;
var statearr_59645_59699 = state_59590__$1;
(statearr_59645_59699[(2)] = inst_59510);

(statearr_59645_59699[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___59653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__38343__auto__,c__38457__auto___59653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__38344__auto__ = null;
var cljs$core$async$mix_$_state_machine__38344__auto____0 = (function (){
var statearr_59649 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59649[(0)] = cljs$core$async$mix_$_state_machine__38344__auto__);

(statearr_59649[(1)] = (1));

return statearr_59649;
});
var cljs$core$async$mix_$_state_machine__38344__auto____1 = (function (state_59590){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_59590);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e59650){if((e59650 instanceof Object)){
var ex__38347__auto__ = e59650;
var statearr_59651_59700 = state_59590;
(statearr_59651_59700[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59590);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59650;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59701 = state_59590;
state_59590 = G__59701;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__38344__auto__ = function(state_59590){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__38344__auto____1.call(this,state_59590);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__38344__auto____0;
cljs$core$async$mix_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__38344__auto____1;
return cljs$core$async$mix_$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___59653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__38459__auto__ = (function (){var statearr_59652 = f__38458__auto__.call(null);
(statearr_59652[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___59653);

return statearr_59652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___59653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args59702 = [];
var len__10640__auto___59705 = arguments.length;
var i__10641__auto___59706 = (0);
while(true){
if((i__10641__auto___59706 < len__10640__auto___59705)){
args59702.push((arguments[i__10641__auto___59706]));

var G__59707 = (i__10641__auto___59706 + (1));
i__10641__auto___59706 = G__59707;
continue;
} else {
}
break;
}

var G__59704 = args59702.length;
switch (G__59704) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59702.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args59710 = [];
var len__10640__auto___59835 = arguments.length;
var i__10641__auto___59836 = (0);
while(true){
if((i__10641__auto___59836 < len__10640__auto___59835)){
args59710.push((arguments[i__10641__auto___59836]));

var G__59837 = (i__10641__auto___59836 + (1));
i__10641__auto___59836 = G__59837;
continue;
} else {
}
break;
}

var G__59712 = args59710.length;
switch (G__59712) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59710.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__9419__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__9419__auto__,mults){
return (function (p1__59709_SHARP_){
if(cljs.core.truth_(p1__59709_SHARP_.call(null,topic))){
return p1__59709_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__59709_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__9419__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async59713 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async59713 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta59714){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta59714 = meta59714;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async59713.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_59715,meta59714__$1){
var self__ = this;
var _59715__$1 = this;
return (new cljs.core.async.t_cljs$core$async59713(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta59714__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59713.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_59715){
var self__ = this;
var _59715__$1 = this;
return self__.meta59714;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59713.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59713.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59713.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async59713.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59713.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6738__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6738__auto__)){
var m = temp__6738__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59713.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59713.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59713.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta59714","meta59714",330114298,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async59713.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async59713.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async59713";

cljs.core.async.t_cljs$core$async59713.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async59713");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async59713 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async59713(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta59714){
return (new cljs.core.async.t_cljs$core$async59713(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta59714));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async59713(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38457__auto___59839 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___59839,mults,ensure_mult,p){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___59839,mults,ensure_mult,p){
return (function (state_59787){
var state_val_59788 = (state_59787[(1)]);
if((state_val_59788 === (7))){
var inst_59783 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
var statearr_59789_59840 = state_59787__$1;
(statearr_59789_59840[(2)] = inst_59783);

(statearr_59789_59840[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (20))){
var state_59787__$1 = state_59787;
var statearr_59790_59841 = state_59787__$1;
(statearr_59790_59841[(2)] = null);

(statearr_59790_59841[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (1))){
var state_59787__$1 = state_59787;
var statearr_59791_59842 = state_59787__$1;
(statearr_59791_59842[(2)] = null);

(statearr_59791_59842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (24))){
var inst_59766 = (state_59787[(7)]);
var inst_59775 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_59766);
var state_59787__$1 = state_59787;
var statearr_59792_59843 = state_59787__$1;
(statearr_59792_59843[(2)] = inst_59775);

(statearr_59792_59843[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (4))){
var inst_59718 = (state_59787[(8)]);
var inst_59718__$1 = (state_59787[(2)]);
var inst_59719 = (inst_59718__$1 == null);
var state_59787__$1 = (function (){var statearr_59793 = state_59787;
(statearr_59793[(8)] = inst_59718__$1);

return statearr_59793;
})();
if(cljs.core.truth_(inst_59719)){
var statearr_59794_59844 = state_59787__$1;
(statearr_59794_59844[(1)] = (5));

} else {
var statearr_59795_59845 = state_59787__$1;
(statearr_59795_59845[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (15))){
var inst_59760 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
var statearr_59796_59846 = state_59787__$1;
(statearr_59796_59846[(2)] = inst_59760);

(statearr_59796_59846[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (21))){
var inst_59780 = (state_59787[(2)]);
var state_59787__$1 = (function (){var statearr_59797 = state_59787;
(statearr_59797[(9)] = inst_59780);

return statearr_59797;
})();
var statearr_59798_59847 = state_59787__$1;
(statearr_59798_59847[(2)] = null);

(statearr_59798_59847[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (13))){
var inst_59742 = (state_59787[(10)]);
var inst_59744 = cljs.core.chunked_seq_QMARK_.call(null,inst_59742);
var state_59787__$1 = state_59787;
if(inst_59744){
var statearr_59799_59848 = state_59787__$1;
(statearr_59799_59848[(1)] = (16));

} else {
var statearr_59800_59849 = state_59787__$1;
(statearr_59800_59849[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (22))){
var inst_59772 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
if(cljs.core.truth_(inst_59772)){
var statearr_59801_59850 = state_59787__$1;
(statearr_59801_59850[(1)] = (23));

} else {
var statearr_59802_59851 = state_59787__$1;
(statearr_59802_59851[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (6))){
var inst_59766 = (state_59787[(7)]);
var inst_59768 = (state_59787[(11)]);
var inst_59718 = (state_59787[(8)]);
var inst_59766__$1 = topic_fn.call(null,inst_59718);
var inst_59767 = cljs.core.deref.call(null,mults);
var inst_59768__$1 = cljs.core.get.call(null,inst_59767,inst_59766__$1);
var state_59787__$1 = (function (){var statearr_59803 = state_59787;
(statearr_59803[(7)] = inst_59766__$1);

(statearr_59803[(11)] = inst_59768__$1);

return statearr_59803;
})();
if(cljs.core.truth_(inst_59768__$1)){
var statearr_59804_59852 = state_59787__$1;
(statearr_59804_59852[(1)] = (19));

} else {
var statearr_59805_59853 = state_59787__$1;
(statearr_59805_59853[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (25))){
var inst_59777 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
var statearr_59806_59854 = state_59787__$1;
(statearr_59806_59854[(2)] = inst_59777);

(statearr_59806_59854[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (17))){
var inst_59742 = (state_59787[(10)]);
var inst_59751 = cljs.core.first.call(null,inst_59742);
var inst_59752 = cljs.core.async.muxch_STAR_.call(null,inst_59751);
var inst_59753 = cljs.core.async.close_BANG_.call(null,inst_59752);
var inst_59754 = cljs.core.next.call(null,inst_59742);
var inst_59728 = inst_59754;
var inst_59729 = null;
var inst_59730 = (0);
var inst_59731 = (0);
var state_59787__$1 = (function (){var statearr_59807 = state_59787;
(statearr_59807[(12)] = inst_59729);

(statearr_59807[(13)] = inst_59731);

(statearr_59807[(14)] = inst_59753);

(statearr_59807[(15)] = inst_59730);

(statearr_59807[(16)] = inst_59728);

return statearr_59807;
})();
var statearr_59808_59855 = state_59787__$1;
(statearr_59808_59855[(2)] = null);

(statearr_59808_59855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (3))){
var inst_59785 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59787__$1,inst_59785);
} else {
if((state_val_59788 === (12))){
var inst_59762 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
var statearr_59809_59856 = state_59787__$1;
(statearr_59809_59856[(2)] = inst_59762);

(statearr_59809_59856[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (2))){
var state_59787__$1 = state_59787;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59787__$1,(4),ch);
} else {
if((state_val_59788 === (23))){
var state_59787__$1 = state_59787;
var statearr_59810_59857 = state_59787__$1;
(statearr_59810_59857[(2)] = null);

(statearr_59810_59857[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (19))){
var inst_59768 = (state_59787[(11)]);
var inst_59718 = (state_59787[(8)]);
var inst_59770 = cljs.core.async.muxch_STAR_.call(null,inst_59768);
var state_59787__$1 = state_59787;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59787__$1,(22),inst_59770,inst_59718);
} else {
if((state_val_59788 === (11))){
var inst_59742 = (state_59787[(10)]);
var inst_59728 = (state_59787[(16)]);
var inst_59742__$1 = cljs.core.seq.call(null,inst_59728);
var state_59787__$1 = (function (){var statearr_59811 = state_59787;
(statearr_59811[(10)] = inst_59742__$1);

return statearr_59811;
})();
if(inst_59742__$1){
var statearr_59812_59858 = state_59787__$1;
(statearr_59812_59858[(1)] = (13));

} else {
var statearr_59813_59859 = state_59787__$1;
(statearr_59813_59859[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (9))){
var inst_59764 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
var statearr_59814_59860 = state_59787__$1;
(statearr_59814_59860[(2)] = inst_59764);

(statearr_59814_59860[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (5))){
var inst_59725 = cljs.core.deref.call(null,mults);
var inst_59726 = cljs.core.vals.call(null,inst_59725);
var inst_59727 = cljs.core.seq.call(null,inst_59726);
var inst_59728 = inst_59727;
var inst_59729 = null;
var inst_59730 = (0);
var inst_59731 = (0);
var state_59787__$1 = (function (){var statearr_59815 = state_59787;
(statearr_59815[(12)] = inst_59729);

(statearr_59815[(13)] = inst_59731);

(statearr_59815[(15)] = inst_59730);

(statearr_59815[(16)] = inst_59728);

return statearr_59815;
})();
var statearr_59816_59861 = state_59787__$1;
(statearr_59816_59861[(2)] = null);

(statearr_59816_59861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (14))){
var state_59787__$1 = state_59787;
var statearr_59820_59862 = state_59787__$1;
(statearr_59820_59862[(2)] = null);

(statearr_59820_59862[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (16))){
var inst_59742 = (state_59787[(10)]);
var inst_59746 = cljs.core.chunk_first.call(null,inst_59742);
var inst_59747 = cljs.core.chunk_rest.call(null,inst_59742);
var inst_59748 = cljs.core.count.call(null,inst_59746);
var inst_59728 = inst_59747;
var inst_59729 = inst_59746;
var inst_59730 = inst_59748;
var inst_59731 = (0);
var state_59787__$1 = (function (){var statearr_59821 = state_59787;
(statearr_59821[(12)] = inst_59729);

(statearr_59821[(13)] = inst_59731);

(statearr_59821[(15)] = inst_59730);

(statearr_59821[(16)] = inst_59728);

return statearr_59821;
})();
var statearr_59822_59863 = state_59787__$1;
(statearr_59822_59863[(2)] = null);

(statearr_59822_59863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (10))){
var inst_59729 = (state_59787[(12)]);
var inst_59731 = (state_59787[(13)]);
var inst_59730 = (state_59787[(15)]);
var inst_59728 = (state_59787[(16)]);
var inst_59736 = cljs.core._nth.call(null,inst_59729,inst_59731);
var inst_59737 = cljs.core.async.muxch_STAR_.call(null,inst_59736);
var inst_59738 = cljs.core.async.close_BANG_.call(null,inst_59737);
var inst_59739 = (inst_59731 + (1));
var tmp59817 = inst_59729;
var tmp59818 = inst_59730;
var tmp59819 = inst_59728;
var inst_59728__$1 = tmp59819;
var inst_59729__$1 = tmp59817;
var inst_59730__$1 = tmp59818;
var inst_59731__$1 = inst_59739;
var state_59787__$1 = (function (){var statearr_59823 = state_59787;
(statearr_59823[(12)] = inst_59729__$1);

(statearr_59823[(17)] = inst_59738);

(statearr_59823[(13)] = inst_59731__$1);

(statearr_59823[(15)] = inst_59730__$1);

(statearr_59823[(16)] = inst_59728__$1);

return statearr_59823;
})();
var statearr_59824_59864 = state_59787__$1;
(statearr_59824_59864[(2)] = null);

(statearr_59824_59864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (18))){
var inst_59757 = (state_59787[(2)]);
var state_59787__$1 = state_59787;
var statearr_59825_59865 = state_59787__$1;
(statearr_59825_59865[(2)] = inst_59757);

(statearr_59825_59865[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59788 === (8))){
var inst_59731 = (state_59787[(13)]);
var inst_59730 = (state_59787[(15)]);
var inst_59733 = (inst_59731 < inst_59730);
var inst_59734 = inst_59733;
var state_59787__$1 = state_59787;
if(cljs.core.truth_(inst_59734)){
var statearr_59826_59866 = state_59787__$1;
(statearr_59826_59866[(1)] = (10));

} else {
var statearr_59827_59867 = state_59787__$1;
(statearr_59827_59867[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___59839,mults,ensure_mult,p))
;
return ((function (switch__38343__auto__,c__38457__auto___59839,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_59831 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59831[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_59831[(1)] = (1));

return statearr_59831;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_59787){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_59787);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e59832){if((e59832 instanceof Object)){
var ex__38347__auto__ = e59832;
var statearr_59833_59868 = state_59787;
(statearr_59833_59868[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59787);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59832;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59869 = state_59787;
state_59787 = G__59869;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_59787){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_59787);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___59839,mults,ensure_mult,p))
})();
var state__38459__auto__ = (function (){var statearr_59834 = f__38458__auto__.call(null);
(statearr_59834[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___59839);

return statearr_59834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___59839,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args59870 = [];
var len__10640__auto___59873 = arguments.length;
var i__10641__auto___59874 = (0);
while(true){
if((i__10641__auto___59874 < len__10640__auto___59873)){
args59870.push((arguments[i__10641__auto___59874]));

var G__59875 = (i__10641__auto___59874 + (1));
i__10641__auto___59874 = G__59875;
continue;
} else {
}
break;
}

var G__59872 = args59870.length;
switch (G__59872) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59870.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args59877 = [];
var len__10640__auto___59880 = arguments.length;
var i__10641__auto___59881 = (0);
while(true){
if((i__10641__auto___59881 < len__10640__auto___59880)){
args59877.push((arguments[i__10641__auto___59881]));

var G__59882 = (i__10641__auto___59881 + (1));
i__10641__auto___59881 = G__59882;
continue;
} else {
}
break;
}

var G__59879 = args59877.length;
switch (G__59879) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59877.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args59884 = [];
var len__10640__auto___59955 = arguments.length;
var i__10641__auto___59956 = (0);
while(true){
if((i__10641__auto___59956 < len__10640__auto___59955)){
args59884.push((arguments[i__10641__auto___59956]));

var G__59957 = (i__10641__auto___59956 + (1));
i__10641__auto___59956 = G__59957;
continue;
} else {
}
break;
}

var G__59886 = args59884.length;
switch (G__59886) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59884.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__38457__auto___59959 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___59959,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___59959,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_59925){
var state_val_59926 = (state_59925[(1)]);
if((state_val_59926 === (7))){
var state_59925__$1 = state_59925;
var statearr_59927_59960 = state_59925__$1;
(statearr_59927_59960[(2)] = null);

(statearr_59927_59960[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (1))){
var state_59925__$1 = state_59925;
var statearr_59928_59961 = state_59925__$1;
(statearr_59928_59961[(2)] = null);

(statearr_59928_59961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (4))){
var inst_59889 = (state_59925[(7)]);
var inst_59891 = (inst_59889 < cnt);
var state_59925__$1 = state_59925;
if(cljs.core.truth_(inst_59891)){
var statearr_59929_59962 = state_59925__$1;
(statearr_59929_59962[(1)] = (6));

} else {
var statearr_59930_59963 = state_59925__$1;
(statearr_59930_59963[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (15))){
var inst_59921 = (state_59925[(2)]);
var state_59925__$1 = state_59925;
var statearr_59931_59964 = state_59925__$1;
(statearr_59931_59964[(2)] = inst_59921);

(statearr_59931_59964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (13))){
var inst_59914 = cljs.core.async.close_BANG_.call(null,out);
var state_59925__$1 = state_59925;
var statearr_59932_59965 = state_59925__$1;
(statearr_59932_59965[(2)] = inst_59914);

(statearr_59932_59965[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (6))){
var state_59925__$1 = state_59925;
var statearr_59933_59966 = state_59925__$1;
(statearr_59933_59966[(2)] = null);

(statearr_59933_59966[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (3))){
var inst_59923 = (state_59925[(2)]);
var state_59925__$1 = state_59925;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_59925__$1,inst_59923);
} else {
if((state_val_59926 === (12))){
var inst_59911 = (state_59925[(8)]);
var inst_59911__$1 = (state_59925[(2)]);
var inst_59912 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_59911__$1);
var state_59925__$1 = (function (){var statearr_59934 = state_59925;
(statearr_59934[(8)] = inst_59911__$1);

return statearr_59934;
})();
if(cljs.core.truth_(inst_59912)){
var statearr_59935_59967 = state_59925__$1;
(statearr_59935_59967[(1)] = (13));

} else {
var statearr_59936_59968 = state_59925__$1;
(statearr_59936_59968[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (2))){
var inst_59888 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_59889 = (0);
var state_59925__$1 = (function (){var statearr_59937 = state_59925;
(statearr_59937[(9)] = inst_59888);

(statearr_59937[(7)] = inst_59889);

return statearr_59937;
})();
var statearr_59938_59969 = state_59925__$1;
(statearr_59938_59969[(2)] = null);

(statearr_59938_59969[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (11))){
var inst_59889 = (state_59925[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_59925,(10),Object,null,(9));
var inst_59898 = chs__$1.call(null,inst_59889);
var inst_59899 = done.call(null,inst_59889);
var inst_59900 = cljs.core.async.take_BANG_.call(null,inst_59898,inst_59899);
var state_59925__$1 = state_59925;
var statearr_59939_59970 = state_59925__$1;
(statearr_59939_59970[(2)] = inst_59900);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59925__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (9))){
var inst_59889 = (state_59925[(7)]);
var inst_59902 = (state_59925[(2)]);
var inst_59903 = (inst_59889 + (1));
var inst_59889__$1 = inst_59903;
var state_59925__$1 = (function (){var statearr_59940 = state_59925;
(statearr_59940[(7)] = inst_59889__$1);

(statearr_59940[(10)] = inst_59902);

return statearr_59940;
})();
var statearr_59941_59971 = state_59925__$1;
(statearr_59941_59971[(2)] = null);

(statearr_59941_59971[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (5))){
var inst_59909 = (state_59925[(2)]);
var state_59925__$1 = (function (){var statearr_59942 = state_59925;
(statearr_59942[(11)] = inst_59909);

return statearr_59942;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_59925__$1,(12),dchan);
} else {
if((state_val_59926 === (14))){
var inst_59911 = (state_59925[(8)]);
var inst_59916 = cljs.core.apply.call(null,f,inst_59911);
var state_59925__$1 = state_59925;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_59925__$1,(16),out,inst_59916);
} else {
if((state_val_59926 === (16))){
var inst_59918 = (state_59925[(2)]);
var state_59925__$1 = (function (){var statearr_59943 = state_59925;
(statearr_59943[(12)] = inst_59918);

return statearr_59943;
})();
var statearr_59944_59972 = state_59925__$1;
(statearr_59944_59972[(2)] = null);

(statearr_59944_59972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (10))){
var inst_59893 = (state_59925[(2)]);
var inst_59894 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_59925__$1 = (function (){var statearr_59945 = state_59925;
(statearr_59945[(13)] = inst_59893);

return statearr_59945;
})();
var statearr_59946_59973 = state_59925__$1;
(statearr_59946_59973[(2)] = inst_59894);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59925__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59926 === (8))){
var inst_59907 = (state_59925[(2)]);
var state_59925__$1 = state_59925;
var statearr_59947_59974 = state_59925__$1;
(statearr_59947_59974[(2)] = inst_59907);

(statearr_59947_59974[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___59959,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__38343__auto__,c__38457__auto___59959,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_59951 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59951[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_59951[(1)] = (1));

return statearr_59951;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_59925){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_59925);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e59952){if((e59952 instanceof Object)){
var ex__38347__auto__ = e59952;
var statearr_59953_59975 = state_59925;
(statearr_59953_59975[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_59925);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e59952;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59976 = state_59925;
state_59925 = G__59976;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_59925){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_59925);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___59959,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__38459__auto__ = (function (){var statearr_59954 = f__38458__auto__.call(null);
(statearr_59954[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___59959);

return statearr_59954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___59959,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args59978 = [];
var len__10640__auto___60036 = arguments.length;
var i__10641__auto___60037 = (0);
while(true){
if((i__10641__auto___60037 < len__10640__auto___60036)){
args59978.push((arguments[i__10641__auto___60037]));

var G__60038 = (i__10641__auto___60037 + (1));
i__10641__auto___60037 = G__60038;
continue;
} else {
}
break;
}

var G__59980 = args59978.length;
switch (G__59980) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args59978.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___60040 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___60040,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___60040,out){
return (function (state_60012){
var state_val_60013 = (state_60012[(1)]);
if((state_val_60013 === (7))){
var inst_59991 = (state_60012[(7)]);
var inst_59992 = (state_60012[(8)]);
var inst_59991__$1 = (state_60012[(2)]);
var inst_59992__$1 = cljs.core.nth.call(null,inst_59991__$1,(0),null);
var inst_59993 = cljs.core.nth.call(null,inst_59991__$1,(1),null);
var inst_59994 = (inst_59992__$1 == null);
var state_60012__$1 = (function (){var statearr_60014 = state_60012;
(statearr_60014[(9)] = inst_59993);

(statearr_60014[(7)] = inst_59991__$1);

(statearr_60014[(8)] = inst_59992__$1);

return statearr_60014;
})();
if(cljs.core.truth_(inst_59994)){
var statearr_60015_60041 = state_60012__$1;
(statearr_60015_60041[(1)] = (8));

} else {
var statearr_60016_60042 = state_60012__$1;
(statearr_60016_60042[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60013 === (1))){
var inst_59981 = cljs.core.vec.call(null,chs);
var inst_59982 = inst_59981;
var state_60012__$1 = (function (){var statearr_60017 = state_60012;
(statearr_60017[(10)] = inst_59982);

return statearr_60017;
})();
var statearr_60018_60043 = state_60012__$1;
(statearr_60018_60043[(2)] = null);

(statearr_60018_60043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60013 === (4))){
var inst_59982 = (state_60012[(10)]);
var state_60012__$1 = state_60012;
return cljs.core.async.ioc_alts_BANG_.call(null,state_60012__$1,(7),inst_59982);
} else {
if((state_val_60013 === (6))){
var inst_60008 = (state_60012[(2)]);
var state_60012__$1 = state_60012;
var statearr_60019_60044 = state_60012__$1;
(statearr_60019_60044[(2)] = inst_60008);

(statearr_60019_60044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60013 === (3))){
var inst_60010 = (state_60012[(2)]);
var state_60012__$1 = state_60012;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60012__$1,inst_60010);
} else {
if((state_val_60013 === (2))){
var inst_59982 = (state_60012[(10)]);
var inst_59984 = cljs.core.count.call(null,inst_59982);
var inst_59985 = (inst_59984 > (0));
var state_60012__$1 = state_60012;
if(cljs.core.truth_(inst_59985)){
var statearr_60021_60045 = state_60012__$1;
(statearr_60021_60045[(1)] = (4));

} else {
var statearr_60022_60046 = state_60012__$1;
(statearr_60022_60046[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60013 === (11))){
var inst_59982 = (state_60012[(10)]);
var inst_60001 = (state_60012[(2)]);
var tmp60020 = inst_59982;
var inst_59982__$1 = tmp60020;
var state_60012__$1 = (function (){var statearr_60023 = state_60012;
(statearr_60023[(11)] = inst_60001);

(statearr_60023[(10)] = inst_59982__$1);

return statearr_60023;
})();
var statearr_60024_60047 = state_60012__$1;
(statearr_60024_60047[(2)] = null);

(statearr_60024_60047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60013 === (9))){
var inst_59992 = (state_60012[(8)]);
var state_60012__$1 = state_60012;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60012__$1,(11),out,inst_59992);
} else {
if((state_val_60013 === (5))){
var inst_60006 = cljs.core.async.close_BANG_.call(null,out);
var state_60012__$1 = state_60012;
var statearr_60025_60048 = state_60012__$1;
(statearr_60025_60048[(2)] = inst_60006);

(statearr_60025_60048[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60013 === (10))){
var inst_60004 = (state_60012[(2)]);
var state_60012__$1 = state_60012;
var statearr_60026_60049 = state_60012__$1;
(statearr_60026_60049[(2)] = inst_60004);

(statearr_60026_60049[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60013 === (8))){
var inst_59993 = (state_60012[(9)]);
var inst_59991 = (state_60012[(7)]);
var inst_59982 = (state_60012[(10)]);
var inst_59992 = (state_60012[(8)]);
var inst_59996 = (function (){var cs = inst_59982;
var vec__59987 = inst_59991;
var v = inst_59992;
var c = inst_59993;
return ((function (cs,vec__59987,v,c,inst_59993,inst_59991,inst_59982,inst_59992,state_val_60013,c__38457__auto___60040,out){
return (function (p1__59977_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__59977_SHARP_);
});
;})(cs,vec__59987,v,c,inst_59993,inst_59991,inst_59982,inst_59992,state_val_60013,c__38457__auto___60040,out))
})();
var inst_59997 = cljs.core.filterv.call(null,inst_59996,inst_59982);
var inst_59982__$1 = inst_59997;
var state_60012__$1 = (function (){var statearr_60027 = state_60012;
(statearr_60027[(10)] = inst_59982__$1);

return statearr_60027;
})();
var statearr_60028_60050 = state_60012__$1;
(statearr_60028_60050[(2)] = null);

(statearr_60028_60050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___60040,out))
;
return ((function (switch__38343__auto__,c__38457__auto___60040,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_60032 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60032[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_60032[(1)] = (1));

return statearr_60032;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_60012){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_60012);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e60033){if((e60033 instanceof Object)){
var ex__38347__auto__ = e60033;
var statearr_60034_60051 = state_60012;
(statearr_60034_60051[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60012);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60033;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60052 = state_60012;
state_60012 = G__60052;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_60012){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_60012);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___60040,out))
})();
var state__38459__auto__ = (function (){var statearr_60035 = f__38458__auto__.call(null);
(statearr_60035[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___60040);

return statearr_60035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___60040,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args60053 = [];
var len__10640__auto___60102 = arguments.length;
var i__10641__auto___60103 = (0);
while(true){
if((i__10641__auto___60103 < len__10640__auto___60102)){
args60053.push((arguments[i__10641__auto___60103]));

var G__60104 = (i__10641__auto___60103 + (1));
i__10641__auto___60103 = G__60104;
continue;
} else {
}
break;
}

var G__60055 = args60053.length;
switch (G__60055) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60053.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___60106 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___60106,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___60106,out){
return (function (state_60079){
var state_val_60080 = (state_60079[(1)]);
if((state_val_60080 === (7))){
var inst_60061 = (state_60079[(7)]);
var inst_60061__$1 = (state_60079[(2)]);
var inst_60062 = (inst_60061__$1 == null);
var inst_60063 = cljs.core.not.call(null,inst_60062);
var state_60079__$1 = (function (){var statearr_60081 = state_60079;
(statearr_60081[(7)] = inst_60061__$1);

return statearr_60081;
})();
if(inst_60063){
var statearr_60082_60107 = state_60079__$1;
(statearr_60082_60107[(1)] = (8));

} else {
var statearr_60083_60108 = state_60079__$1;
(statearr_60083_60108[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60080 === (1))){
var inst_60056 = (0);
var state_60079__$1 = (function (){var statearr_60084 = state_60079;
(statearr_60084[(8)] = inst_60056);

return statearr_60084;
})();
var statearr_60085_60109 = state_60079__$1;
(statearr_60085_60109[(2)] = null);

(statearr_60085_60109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60080 === (4))){
var state_60079__$1 = state_60079;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60079__$1,(7),ch);
} else {
if((state_val_60080 === (6))){
var inst_60074 = (state_60079[(2)]);
var state_60079__$1 = state_60079;
var statearr_60086_60110 = state_60079__$1;
(statearr_60086_60110[(2)] = inst_60074);

(statearr_60086_60110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60080 === (3))){
var inst_60076 = (state_60079[(2)]);
var inst_60077 = cljs.core.async.close_BANG_.call(null,out);
var state_60079__$1 = (function (){var statearr_60087 = state_60079;
(statearr_60087[(9)] = inst_60076);

return statearr_60087;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60079__$1,inst_60077);
} else {
if((state_val_60080 === (2))){
var inst_60056 = (state_60079[(8)]);
var inst_60058 = (inst_60056 < n);
var state_60079__$1 = state_60079;
if(cljs.core.truth_(inst_60058)){
var statearr_60088_60111 = state_60079__$1;
(statearr_60088_60111[(1)] = (4));

} else {
var statearr_60089_60112 = state_60079__$1;
(statearr_60089_60112[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60080 === (11))){
var inst_60056 = (state_60079[(8)]);
var inst_60066 = (state_60079[(2)]);
var inst_60067 = (inst_60056 + (1));
var inst_60056__$1 = inst_60067;
var state_60079__$1 = (function (){var statearr_60090 = state_60079;
(statearr_60090[(10)] = inst_60066);

(statearr_60090[(8)] = inst_60056__$1);

return statearr_60090;
})();
var statearr_60091_60113 = state_60079__$1;
(statearr_60091_60113[(2)] = null);

(statearr_60091_60113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60080 === (9))){
var state_60079__$1 = state_60079;
var statearr_60092_60114 = state_60079__$1;
(statearr_60092_60114[(2)] = null);

(statearr_60092_60114[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60080 === (5))){
var state_60079__$1 = state_60079;
var statearr_60093_60115 = state_60079__$1;
(statearr_60093_60115[(2)] = null);

(statearr_60093_60115[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60080 === (10))){
var inst_60071 = (state_60079[(2)]);
var state_60079__$1 = state_60079;
var statearr_60094_60116 = state_60079__$1;
(statearr_60094_60116[(2)] = inst_60071);

(statearr_60094_60116[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60080 === (8))){
var inst_60061 = (state_60079[(7)]);
var state_60079__$1 = state_60079;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60079__$1,(11),out,inst_60061);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___60106,out))
;
return ((function (switch__38343__auto__,c__38457__auto___60106,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_60098 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_60098[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_60098[(1)] = (1));

return statearr_60098;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_60079){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_60079);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e60099){if((e60099 instanceof Object)){
var ex__38347__auto__ = e60099;
var statearr_60100_60117 = state_60079;
(statearr_60100_60117[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60079);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60099;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60118 = state_60079;
state_60079 = G__60118;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_60079){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_60079);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___60106,out))
})();
var state__38459__auto__ = (function (){var statearr_60101 = f__38458__auto__.call(null);
(statearr_60101[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___60106);

return statearr_60101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___60106,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async60126 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60126 = (function (f,ch,meta60127){
this.f = f;
this.ch = ch;
this.meta60127 = meta60127;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async60126.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_60128,meta60127__$1){
var self__ = this;
var _60128__$1 = this;
return (new cljs.core.async.t_cljs$core$async60126(self__.f,self__.ch,meta60127__$1));
});

cljs.core.async.t_cljs$core$async60126.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_60128){
var self__ = this;
var _60128__$1 = this;
return self__.meta60127;
});

cljs.core.async.t_cljs$core$async60126.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60126.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60126.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60126.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60126.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async60129 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60129 = (function (f,ch,meta60127,_,fn1,meta60130){
this.f = f;
this.ch = ch;
this.meta60127 = meta60127;
this._ = _;
this.fn1 = fn1;
this.meta60130 = meta60130;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async60129.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_60131,meta60130__$1){
var self__ = this;
var _60131__$1 = this;
return (new cljs.core.async.t_cljs$core$async60129(self__.f,self__.ch,self__.meta60127,self__._,self__.fn1,meta60130__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async60129.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_60131){
var self__ = this;
var _60131__$1 = this;
return self__.meta60130;
});})(___$1))
;

cljs.core.async.t_cljs$core$async60129.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60129.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async60129.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async60129.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__60119_SHARP_){
return f1.call(null,(((p1__60119_SHARP_ == null))?null:self__.f.call(null,p1__60119_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async60129.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60127","meta60127",-2088392664,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async60126","cljs.core.async/t_cljs$core$async60126",-1942466227,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta60130","meta60130",-966852155,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async60129.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60129.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60129";

cljs.core.async.t_cljs$core$async60129.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async60129");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async60129 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async60129(f__$1,ch__$1,meta60127__$1,___$2,fn1__$1,meta60130){
return (new cljs.core.async.t_cljs$core$async60129(f__$1,ch__$1,meta60127__$1,___$2,fn1__$1,meta60130));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async60129(self__.f,self__.ch,self__.meta60127,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__9407__auto__ = ret;
if(cljs.core.truth_(and__9407__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__9407__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async60126.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60126.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async60126.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60127","meta60127",-2088392664,null)], null);
});

cljs.core.async.t_cljs$core$async60126.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60126.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60126";

cljs.core.async.t_cljs$core$async60126.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async60126");
});

cljs.core.async.__GT_t_cljs$core$async60126 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async60126(f__$1,ch__$1,meta60127){
return (new cljs.core.async.t_cljs$core$async60126(f__$1,ch__$1,meta60127));
});

}

return (new cljs.core.async.t_cljs$core$async60126(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async60135 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60135 = (function (f,ch,meta60136){
this.f = f;
this.ch = ch;
this.meta60136 = meta60136;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_60137,meta60136__$1){
var self__ = this;
var _60137__$1 = this;
return (new cljs.core.async.t_cljs$core$async60135(self__.f,self__.ch,meta60136__$1));
});

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_60137){
var self__ = this;
var _60137__$1 = this;
return self__.meta60136;
});

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60135.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async60135.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60136","meta60136",-922771574,null)], null);
});

cljs.core.async.t_cljs$core$async60135.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60135.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60135";

cljs.core.async.t_cljs$core$async60135.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async60135");
});

cljs.core.async.__GT_t_cljs$core$async60135 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async60135(f__$1,ch__$1,meta60136){
return (new cljs.core.async.t_cljs$core$async60135(f__$1,ch__$1,meta60136));
});

}

return (new cljs.core.async.t_cljs$core$async60135(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async60141 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async60141 = (function (p,ch,meta60142){
this.p = p;
this.ch = ch;
this.meta60142 = meta60142;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_60143,meta60142__$1){
var self__ = this;
var _60143__$1 = this;
return (new cljs.core.async.t_cljs$core$async60141(self__.p,self__.ch,meta60142__$1));
});

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_60143){
var self__ = this;
var _60143__$1 = this;
return self__.meta60142;
});

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async60141.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async60141.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta60142","meta60142",421603310,null)], null);
});

cljs.core.async.t_cljs$core$async60141.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async60141.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async60141";

cljs.core.async.t_cljs$core$async60141.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async60141");
});

cljs.core.async.__GT_t_cljs$core$async60141 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async60141(p__$1,ch__$1,meta60142){
return (new cljs.core.async.t_cljs$core$async60141(p__$1,ch__$1,meta60142));
});

}

return (new cljs.core.async.t_cljs$core$async60141(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args60144 = [];
var len__10640__auto___60188 = arguments.length;
var i__10641__auto___60189 = (0);
while(true){
if((i__10641__auto___60189 < len__10640__auto___60188)){
args60144.push((arguments[i__10641__auto___60189]));

var G__60190 = (i__10641__auto___60189 + (1));
i__10641__auto___60189 = G__60190;
continue;
} else {
}
break;
}

var G__60146 = args60144.length;
switch (G__60146) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60144.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___60192 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___60192,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___60192,out){
return (function (state_60167){
var state_val_60168 = (state_60167[(1)]);
if((state_val_60168 === (7))){
var inst_60163 = (state_60167[(2)]);
var state_60167__$1 = state_60167;
var statearr_60169_60193 = state_60167__$1;
(statearr_60169_60193[(2)] = inst_60163);

(statearr_60169_60193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60168 === (1))){
var state_60167__$1 = state_60167;
var statearr_60170_60194 = state_60167__$1;
(statearr_60170_60194[(2)] = null);

(statearr_60170_60194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60168 === (4))){
var inst_60149 = (state_60167[(7)]);
var inst_60149__$1 = (state_60167[(2)]);
var inst_60150 = (inst_60149__$1 == null);
var state_60167__$1 = (function (){var statearr_60171 = state_60167;
(statearr_60171[(7)] = inst_60149__$1);

return statearr_60171;
})();
if(cljs.core.truth_(inst_60150)){
var statearr_60172_60195 = state_60167__$1;
(statearr_60172_60195[(1)] = (5));

} else {
var statearr_60173_60196 = state_60167__$1;
(statearr_60173_60196[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60168 === (6))){
var inst_60149 = (state_60167[(7)]);
var inst_60154 = p.call(null,inst_60149);
var state_60167__$1 = state_60167;
if(cljs.core.truth_(inst_60154)){
var statearr_60174_60197 = state_60167__$1;
(statearr_60174_60197[(1)] = (8));

} else {
var statearr_60175_60198 = state_60167__$1;
(statearr_60175_60198[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60168 === (3))){
var inst_60165 = (state_60167[(2)]);
var state_60167__$1 = state_60167;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60167__$1,inst_60165);
} else {
if((state_val_60168 === (2))){
var state_60167__$1 = state_60167;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60167__$1,(4),ch);
} else {
if((state_val_60168 === (11))){
var inst_60157 = (state_60167[(2)]);
var state_60167__$1 = state_60167;
var statearr_60176_60199 = state_60167__$1;
(statearr_60176_60199[(2)] = inst_60157);

(statearr_60176_60199[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60168 === (9))){
var state_60167__$1 = state_60167;
var statearr_60177_60200 = state_60167__$1;
(statearr_60177_60200[(2)] = null);

(statearr_60177_60200[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60168 === (5))){
var inst_60152 = cljs.core.async.close_BANG_.call(null,out);
var state_60167__$1 = state_60167;
var statearr_60178_60201 = state_60167__$1;
(statearr_60178_60201[(2)] = inst_60152);

(statearr_60178_60201[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60168 === (10))){
var inst_60160 = (state_60167[(2)]);
var state_60167__$1 = (function (){var statearr_60179 = state_60167;
(statearr_60179[(8)] = inst_60160);

return statearr_60179;
})();
var statearr_60180_60202 = state_60167__$1;
(statearr_60180_60202[(2)] = null);

(statearr_60180_60202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60168 === (8))){
var inst_60149 = (state_60167[(7)]);
var state_60167__$1 = state_60167;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60167__$1,(11),out,inst_60149);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___60192,out))
;
return ((function (switch__38343__auto__,c__38457__auto___60192,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_60184 = [null,null,null,null,null,null,null,null,null];
(statearr_60184[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_60184[(1)] = (1));

return statearr_60184;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_60167){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_60167);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e60185){if((e60185 instanceof Object)){
var ex__38347__auto__ = e60185;
var statearr_60186_60203 = state_60167;
(statearr_60186_60203[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60167);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60185;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60204 = state_60167;
state_60167 = G__60204;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_60167){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_60167);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___60192,out))
})();
var state__38459__auto__ = (function (){var statearr_60187 = f__38458__auto__.call(null);
(statearr_60187[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___60192);

return statearr_60187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___60192,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args60205 = [];
var len__10640__auto___60208 = arguments.length;
var i__10641__auto___60209 = (0);
while(true){
if((i__10641__auto___60209 < len__10640__auto___60208)){
args60205.push((arguments[i__10641__auto___60209]));

var G__60210 = (i__10641__auto___60209 + (1));
i__10641__auto___60209 = G__60210;
continue;
} else {
}
break;
}

var G__60207 = args60205.length;
switch (G__60207) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60205.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__){
return (function (state_60377){
var state_val_60378 = (state_60377[(1)]);
if((state_val_60378 === (7))){
var inst_60373 = (state_60377[(2)]);
var state_60377__$1 = state_60377;
var statearr_60379_60420 = state_60377__$1;
(statearr_60379_60420[(2)] = inst_60373);

(statearr_60379_60420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (20))){
var inst_60343 = (state_60377[(7)]);
var inst_60354 = (state_60377[(2)]);
var inst_60355 = cljs.core.next.call(null,inst_60343);
var inst_60329 = inst_60355;
var inst_60330 = null;
var inst_60331 = (0);
var inst_60332 = (0);
var state_60377__$1 = (function (){var statearr_60380 = state_60377;
(statearr_60380[(8)] = inst_60332);

(statearr_60380[(9)] = inst_60354);

(statearr_60380[(10)] = inst_60329);

(statearr_60380[(11)] = inst_60330);

(statearr_60380[(12)] = inst_60331);

return statearr_60380;
})();
var statearr_60381_60421 = state_60377__$1;
(statearr_60381_60421[(2)] = null);

(statearr_60381_60421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (1))){
var state_60377__$1 = state_60377;
var statearr_60382_60422 = state_60377__$1;
(statearr_60382_60422[(2)] = null);

(statearr_60382_60422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (4))){
var inst_60318 = (state_60377[(13)]);
var inst_60318__$1 = (state_60377[(2)]);
var inst_60319 = (inst_60318__$1 == null);
var state_60377__$1 = (function (){var statearr_60383 = state_60377;
(statearr_60383[(13)] = inst_60318__$1);

return statearr_60383;
})();
if(cljs.core.truth_(inst_60319)){
var statearr_60384_60423 = state_60377__$1;
(statearr_60384_60423[(1)] = (5));

} else {
var statearr_60385_60424 = state_60377__$1;
(statearr_60385_60424[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (15))){
var state_60377__$1 = state_60377;
var statearr_60389_60425 = state_60377__$1;
(statearr_60389_60425[(2)] = null);

(statearr_60389_60425[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (21))){
var state_60377__$1 = state_60377;
var statearr_60390_60426 = state_60377__$1;
(statearr_60390_60426[(2)] = null);

(statearr_60390_60426[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (13))){
var inst_60332 = (state_60377[(8)]);
var inst_60329 = (state_60377[(10)]);
var inst_60330 = (state_60377[(11)]);
var inst_60331 = (state_60377[(12)]);
var inst_60339 = (state_60377[(2)]);
var inst_60340 = (inst_60332 + (1));
var tmp60386 = inst_60329;
var tmp60387 = inst_60330;
var tmp60388 = inst_60331;
var inst_60329__$1 = tmp60386;
var inst_60330__$1 = tmp60387;
var inst_60331__$1 = tmp60388;
var inst_60332__$1 = inst_60340;
var state_60377__$1 = (function (){var statearr_60391 = state_60377;
(statearr_60391[(14)] = inst_60339);

(statearr_60391[(8)] = inst_60332__$1);

(statearr_60391[(10)] = inst_60329__$1);

(statearr_60391[(11)] = inst_60330__$1);

(statearr_60391[(12)] = inst_60331__$1);

return statearr_60391;
})();
var statearr_60392_60427 = state_60377__$1;
(statearr_60392_60427[(2)] = null);

(statearr_60392_60427[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (22))){
var state_60377__$1 = state_60377;
var statearr_60393_60428 = state_60377__$1;
(statearr_60393_60428[(2)] = null);

(statearr_60393_60428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (6))){
var inst_60318 = (state_60377[(13)]);
var inst_60327 = f.call(null,inst_60318);
var inst_60328 = cljs.core.seq.call(null,inst_60327);
var inst_60329 = inst_60328;
var inst_60330 = null;
var inst_60331 = (0);
var inst_60332 = (0);
var state_60377__$1 = (function (){var statearr_60394 = state_60377;
(statearr_60394[(8)] = inst_60332);

(statearr_60394[(10)] = inst_60329);

(statearr_60394[(11)] = inst_60330);

(statearr_60394[(12)] = inst_60331);

return statearr_60394;
})();
var statearr_60395_60429 = state_60377__$1;
(statearr_60395_60429[(2)] = null);

(statearr_60395_60429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (17))){
var inst_60343 = (state_60377[(7)]);
var inst_60347 = cljs.core.chunk_first.call(null,inst_60343);
var inst_60348 = cljs.core.chunk_rest.call(null,inst_60343);
var inst_60349 = cljs.core.count.call(null,inst_60347);
var inst_60329 = inst_60348;
var inst_60330 = inst_60347;
var inst_60331 = inst_60349;
var inst_60332 = (0);
var state_60377__$1 = (function (){var statearr_60396 = state_60377;
(statearr_60396[(8)] = inst_60332);

(statearr_60396[(10)] = inst_60329);

(statearr_60396[(11)] = inst_60330);

(statearr_60396[(12)] = inst_60331);

return statearr_60396;
})();
var statearr_60397_60430 = state_60377__$1;
(statearr_60397_60430[(2)] = null);

(statearr_60397_60430[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (3))){
var inst_60375 = (state_60377[(2)]);
var state_60377__$1 = state_60377;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60377__$1,inst_60375);
} else {
if((state_val_60378 === (12))){
var inst_60363 = (state_60377[(2)]);
var state_60377__$1 = state_60377;
var statearr_60398_60431 = state_60377__$1;
(statearr_60398_60431[(2)] = inst_60363);

(statearr_60398_60431[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (2))){
var state_60377__$1 = state_60377;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60377__$1,(4),in$);
} else {
if((state_val_60378 === (23))){
var inst_60371 = (state_60377[(2)]);
var state_60377__$1 = state_60377;
var statearr_60399_60432 = state_60377__$1;
(statearr_60399_60432[(2)] = inst_60371);

(statearr_60399_60432[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (19))){
var inst_60358 = (state_60377[(2)]);
var state_60377__$1 = state_60377;
var statearr_60400_60433 = state_60377__$1;
(statearr_60400_60433[(2)] = inst_60358);

(statearr_60400_60433[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (11))){
var inst_60343 = (state_60377[(7)]);
var inst_60329 = (state_60377[(10)]);
var inst_60343__$1 = cljs.core.seq.call(null,inst_60329);
var state_60377__$1 = (function (){var statearr_60401 = state_60377;
(statearr_60401[(7)] = inst_60343__$1);

return statearr_60401;
})();
if(inst_60343__$1){
var statearr_60402_60434 = state_60377__$1;
(statearr_60402_60434[(1)] = (14));

} else {
var statearr_60403_60435 = state_60377__$1;
(statearr_60403_60435[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (9))){
var inst_60365 = (state_60377[(2)]);
var inst_60366 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_60377__$1 = (function (){var statearr_60404 = state_60377;
(statearr_60404[(15)] = inst_60365);

return statearr_60404;
})();
if(cljs.core.truth_(inst_60366)){
var statearr_60405_60436 = state_60377__$1;
(statearr_60405_60436[(1)] = (21));

} else {
var statearr_60406_60437 = state_60377__$1;
(statearr_60406_60437[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (5))){
var inst_60321 = cljs.core.async.close_BANG_.call(null,out);
var state_60377__$1 = state_60377;
var statearr_60407_60438 = state_60377__$1;
(statearr_60407_60438[(2)] = inst_60321);

(statearr_60407_60438[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (14))){
var inst_60343 = (state_60377[(7)]);
var inst_60345 = cljs.core.chunked_seq_QMARK_.call(null,inst_60343);
var state_60377__$1 = state_60377;
if(inst_60345){
var statearr_60408_60439 = state_60377__$1;
(statearr_60408_60439[(1)] = (17));

} else {
var statearr_60409_60440 = state_60377__$1;
(statearr_60409_60440[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (16))){
var inst_60361 = (state_60377[(2)]);
var state_60377__$1 = state_60377;
var statearr_60410_60441 = state_60377__$1;
(statearr_60410_60441[(2)] = inst_60361);

(statearr_60410_60441[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60378 === (10))){
var inst_60332 = (state_60377[(8)]);
var inst_60330 = (state_60377[(11)]);
var inst_60337 = cljs.core._nth.call(null,inst_60330,inst_60332);
var state_60377__$1 = state_60377;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60377__$1,(13),out,inst_60337);
} else {
if((state_val_60378 === (18))){
var inst_60343 = (state_60377[(7)]);
var inst_60352 = cljs.core.first.call(null,inst_60343);
var state_60377__$1 = state_60377;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60377__$1,(20),out,inst_60352);
} else {
if((state_val_60378 === (8))){
var inst_60332 = (state_60377[(8)]);
var inst_60331 = (state_60377[(12)]);
var inst_60334 = (inst_60332 < inst_60331);
var inst_60335 = inst_60334;
var state_60377__$1 = state_60377;
if(cljs.core.truth_(inst_60335)){
var statearr_60411_60442 = state_60377__$1;
(statearr_60411_60442[(1)] = (10));

} else {
var statearr_60412_60443 = state_60377__$1;
(statearr_60412_60443[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto__))
;
return ((function (switch__38343__auto__,c__38457__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_60416 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60416[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__);

(statearr_60416[(1)] = (1));

return statearr_60416;
});
var cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____1 = (function (state_60377){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_60377);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e60417){if((e60417 instanceof Object)){
var ex__38347__auto__ = e60417;
var statearr_60418_60444 = state_60377;
(statearr_60418_60444[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60377);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60417;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60445 = state_60377;
state_60377 = G__60445;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__ = function(state_60377){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____1.call(this,state_60377);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__))
})();
var state__38459__auto__ = (function (){var statearr_60419 = f__38458__auto__.call(null);
(statearr_60419[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_60419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__))
);

return c__38457__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args60446 = [];
var len__10640__auto___60449 = arguments.length;
var i__10641__auto___60450 = (0);
while(true){
if((i__10641__auto___60450 < len__10640__auto___60449)){
args60446.push((arguments[i__10641__auto___60450]));

var G__60451 = (i__10641__auto___60450 + (1));
i__10641__auto___60450 = G__60451;
continue;
} else {
}
break;
}

var G__60448 = args60446.length;
switch (G__60448) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60446.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args60453 = [];
var len__10640__auto___60456 = arguments.length;
var i__10641__auto___60457 = (0);
while(true){
if((i__10641__auto___60457 < len__10640__auto___60456)){
args60453.push((arguments[i__10641__auto___60457]));

var G__60458 = (i__10641__auto___60457 + (1));
i__10641__auto___60457 = G__60458;
continue;
} else {
}
break;
}

var G__60455 = args60453.length;
switch (G__60455) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60453.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args60460 = [];
var len__10640__auto___60511 = arguments.length;
var i__10641__auto___60512 = (0);
while(true){
if((i__10641__auto___60512 < len__10640__auto___60511)){
args60460.push((arguments[i__10641__auto___60512]));

var G__60513 = (i__10641__auto___60512 + (1));
i__10641__auto___60512 = G__60513;
continue;
} else {
}
break;
}

var G__60462 = args60460.length;
switch (G__60462) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60460.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___60515 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___60515,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___60515,out){
return (function (state_60486){
var state_val_60487 = (state_60486[(1)]);
if((state_val_60487 === (7))){
var inst_60481 = (state_60486[(2)]);
var state_60486__$1 = state_60486;
var statearr_60488_60516 = state_60486__$1;
(statearr_60488_60516[(2)] = inst_60481);

(statearr_60488_60516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60487 === (1))){
var inst_60463 = null;
var state_60486__$1 = (function (){var statearr_60489 = state_60486;
(statearr_60489[(7)] = inst_60463);

return statearr_60489;
})();
var statearr_60490_60517 = state_60486__$1;
(statearr_60490_60517[(2)] = null);

(statearr_60490_60517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60487 === (4))){
var inst_60466 = (state_60486[(8)]);
var inst_60466__$1 = (state_60486[(2)]);
var inst_60467 = (inst_60466__$1 == null);
var inst_60468 = cljs.core.not.call(null,inst_60467);
var state_60486__$1 = (function (){var statearr_60491 = state_60486;
(statearr_60491[(8)] = inst_60466__$1);

return statearr_60491;
})();
if(inst_60468){
var statearr_60492_60518 = state_60486__$1;
(statearr_60492_60518[(1)] = (5));

} else {
var statearr_60493_60519 = state_60486__$1;
(statearr_60493_60519[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60487 === (6))){
var state_60486__$1 = state_60486;
var statearr_60494_60520 = state_60486__$1;
(statearr_60494_60520[(2)] = null);

(statearr_60494_60520[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60487 === (3))){
var inst_60483 = (state_60486[(2)]);
var inst_60484 = cljs.core.async.close_BANG_.call(null,out);
var state_60486__$1 = (function (){var statearr_60495 = state_60486;
(statearr_60495[(9)] = inst_60483);

return statearr_60495;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60486__$1,inst_60484);
} else {
if((state_val_60487 === (2))){
var state_60486__$1 = state_60486;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60486__$1,(4),ch);
} else {
if((state_val_60487 === (11))){
var inst_60466 = (state_60486[(8)]);
var inst_60475 = (state_60486[(2)]);
var inst_60463 = inst_60466;
var state_60486__$1 = (function (){var statearr_60496 = state_60486;
(statearr_60496[(10)] = inst_60475);

(statearr_60496[(7)] = inst_60463);

return statearr_60496;
})();
var statearr_60497_60521 = state_60486__$1;
(statearr_60497_60521[(2)] = null);

(statearr_60497_60521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60487 === (9))){
var inst_60466 = (state_60486[(8)]);
var state_60486__$1 = state_60486;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60486__$1,(11),out,inst_60466);
} else {
if((state_val_60487 === (5))){
var inst_60463 = (state_60486[(7)]);
var inst_60466 = (state_60486[(8)]);
var inst_60470 = cljs.core._EQ_.call(null,inst_60466,inst_60463);
var state_60486__$1 = state_60486;
if(inst_60470){
var statearr_60499_60522 = state_60486__$1;
(statearr_60499_60522[(1)] = (8));

} else {
var statearr_60500_60523 = state_60486__$1;
(statearr_60500_60523[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60487 === (10))){
var inst_60478 = (state_60486[(2)]);
var state_60486__$1 = state_60486;
var statearr_60501_60524 = state_60486__$1;
(statearr_60501_60524[(2)] = inst_60478);

(statearr_60501_60524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60487 === (8))){
var inst_60463 = (state_60486[(7)]);
var tmp60498 = inst_60463;
var inst_60463__$1 = tmp60498;
var state_60486__$1 = (function (){var statearr_60502 = state_60486;
(statearr_60502[(7)] = inst_60463__$1);

return statearr_60502;
})();
var statearr_60503_60525 = state_60486__$1;
(statearr_60503_60525[(2)] = null);

(statearr_60503_60525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___60515,out))
;
return ((function (switch__38343__auto__,c__38457__auto___60515,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_60507 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_60507[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_60507[(1)] = (1));

return statearr_60507;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_60486){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_60486);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e60508){if((e60508 instanceof Object)){
var ex__38347__auto__ = e60508;
var statearr_60509_60526 = state_60486;
(statearr_60509_60526[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60486);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60508;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60527 = state_60486;
state_60486 = G__60527;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_60486){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_60486);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___60515,out))
})();
var state__38459__auto__ = (function (){var statearr_60510 = f__38458__auto__.call(null);
(statearr_60510[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___60515);

return statearr_60510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___60515,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args60528 = [];
var len__10640__auto___60598 = arguments.length;
var i__10641__auto___60599 = (0);
while(true){
if((i__10641__auto___60599 < len__10640__auto___60598)){
args60528.push((arguments[i__10641__auto___60599]));

var G__60600 = (i__10641__auto___60599 + (1));
i__10641__auto___60599 = G__60600;
continue;
} else {
}
break;
}

var G__60530 = args60528.length;
switch (G__60530) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60528.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___60602 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___60602,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___60602,out){
return (function (state_60568){
var state_val_60569 = (state_60568[(1)]);
if((state_val_60569 === (7))){
var inst_60564 = (state_60568[(2)]);
var state_60568__$1 = state_60568;
var statearr_60570_60603 = state_60568__$1;
(statearr_60570_60603[(2)] = inst_60564);

(statearr_60570_60603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (1))){
var inst_60531 = (new Array(n));
var inst_60532 = inst_60531;
var inst_60533 = (0);
var state_60568__$1 = (function (){var statearr_60571 = state_60568;
(statearr_60571[(7)] = inst_60532);

(statearr_60571[(8)] = inst_60533);

return statearr_60571;
})();
var statearr_60572_60604 = state_60568__$1;
(statearr_60572_60604[(2)] = null);

(statearr_60572_60604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (4))){
var inst_60536 = (state_60568[(9)]);
var inst_60536__$1 = (state_60568[(2)]);
var inst_60537 = (inst_60536__$1 == null);
var inst_60538 = cljs.core.not.call(null,inst_60537);
var state_60568__$1 = (function (){var statearr_60573 = state_60568;
(statearr_60573[(9)] = inst_60536__$1);

return statearr_60573;
})();
if(inst_60538){
var statearr_60574_60605 = state_60568__$1;
(statearr_60574_60605[(1)] = (5));

} else {
var statearr_60575_60606 = state_60568__$1;
(statearr_60575_60606[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (15))){
var inst_60558 = (state_60568[(2)]);
var state_60568__$1 = state_60568;
var statearr_60576_60607 = state_60568__$1;
(statearr_60576_60607[(2)] = inst_60558);

(statearr_60576_60607[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (13))){
var state_60568__$1 = state_60568;
var statearr_60577_60608 = state_60568__$1;
(statearr_60577_60608[(2)] = null);

(statearr_60577_60608[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (6))){
var inst_60533 = (state_60568[(8)]);
var inst_60554 = (inst_60533 > (0));
var state_60568__$1 = state_60568;
if(cljs.core.truth_(inst_60554)){
var statearr_60578_60609 = state_60568__$1;
(statearr_60578_60609[(1)] = (12));

} else {
var statearr_60579_60610 = state_60568__$1;
(statearr_60579_60610[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (3))){
var inst_60566 = (state_60568[(2)]);
var state_60568__$1 = state_60568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60568__$1,inst_60566);
} else {
if((state_val_60569 === (12))){
var inst_60532 = (state_60568[(7)]);
var inst_60556 = cljs.core.vec.call(null,inst_60532);
var state_60568__$1 = state_60568;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60568__$1,(15),out,inst_60556);
} else {
if((state_val_60569 === (2))){
var state_60568__$1 = state_60568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60568__$1,(4),ch);
} else {
if((state_val_60569 === (11))){
var inst_60548 = (state_60568[(2)]);
var inst_60549 = (new Array(n));
var inst_60532 = inst_60549;
var inst_60533 = (0);
var state_60568__$1 = (function (){var statearr_60580 = state_60568;
(statearr_60580[(7)] = inst_60532);

(statearr_60580[(10)] = inst_60548);

(statearr_60580[(8)] = inst_60533);

return statearr_60580;
})();
var statearr_60581_60611 = state_60568__$1;
(statearr_60581_60611[(2)] = null);

(statearr_60581_60611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (9))){
var inst_60532 = (state_60568[(7)]);
var inst_60546 = cljs.core.vec.call(null,inst_60532);
var state_60568__$1 = state_60568;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60568__$1,(11),out,inst_60546);
} else {
if((state_val_60569 === (5))){
var inst_60532 = (state_60568[(7)]);
var inst_60536 = (state_60568[(9)]);
var inst_60533 = (state_60568[(8)]);
var inst_60541 = (state_60568[(11)]);
var inst_60540 = (inst_60532[inst_60533] = inst_60536);
var inst_60541__$1 = (inst_60533 + (1));
var inst_60542 = (inst_60541__$1 < n);
var state_60568__$1 = (function (){var statearr_60582 = state_60568;
(statearr_60582[(12)] = inst_60540);

(statearr_60582[(11)] = inst_60541__$1);

return statearr_60582;
})();
if(cljs.core.truth_(inst_60542)){
var statearr_60583_60612 = state_60568__$1;
(statearr_60583_60612[(1)] = (8));

} else {
var statearr_60584_60613 = state_60568__$1;
(statearr_60584_60613[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (14))){
var inst_60561 = (state_60568[(2)]);
var inst_60562 = cljs.core.async.close_BANG_.call(null,out);
var state_60568__$1 = (function (){var statearr_60586 = state_60568;
(statearr_60586[(13)] = inst_60561);

return statearr_60586;
})();
var statearr_60587_60614 = state_60568__$1;
(statearr_60587_60614[(2)] = inst_60562);

(statearr_60587_60614[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (10))){
var inst_60552 = (state_60568[(2)]);
var state_60568__$1 = state_60568;
var statearr_60588_60615 = state_60568__$1;
(statearr_60588_60615[(2)] = inst_60552);

(statearr_60588_60615[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (8))){
var inst_60532 = (state_60568[(7)]);
var inst_60541 = (state_60568[(11)]);
var tmp60585 = inst_60532;
var inst_60532__$1 = tmp60585;
var inst_60533 = inst_60541;
var state_60568__$1 = (function (){var statearr_60589 = state_60568;
(statearr_60589[(7)] = inst_60532__$1);

(statearr_60589[(8)] = inst_60533);

return statearr_60589;
})();
var statearr_60590_60616 = state_60568__$1;
(statearr_60590_60616[(2)] = null);

(statearr_60590_60616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___60602,out))
;
return ((function (switch__38343__auto__,c__38457__auto___60602,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_60594 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60594[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_60594[(1)] = (1));

return statearr_60594;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_60568){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_60568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e60595){if((e60595 instanceof Object)){
var ex__38347__auto__ = e60595;
var statearr_60596_60617 = state_60568;
(statearr_60596_60617[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60568);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60595;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60618 = state_60568;
state_60568 = G__60618;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_60568){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_60568);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___60602,out))
})();
var state__38459__auto__ = (function (){var statearr_60597 = f__38458__auto__.call(null);
(statearr_60597[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___60602);

return statearr_60597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___60602,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args60619 = [];
var len__10640__auto___60693 = arguments.length;
var i__10641__auto___60694 = (0);
while(true){
if((i__10641__auto___60694 < len__10640__auto___60693)){
args60619.push((arguments[i__10641__auto___60694]));

var G__60695 = (i__10641__auto___60694 + (1));
i__10641__auto___60694 = G__60695;
continue;
} else {
}
break;
}

var G__60621 = args60619.length;
switch (G__60621) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args60619.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___60697 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___60697,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___60697,out){
return (function (state_60663){
var state_val_60664 = (state_60663[(1)]);
if((state_val_60664 === (7))){
var inst_60659 = (state_60663[(2)]);
var state_60663__$1 = state_60663;
var statearr_60665_60698 = state_60663__$1;
(statearr_60665_60698[(2)] = inst_60659);

(statearr_60665_60698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60664 === (1))){
var inst_60622 = [];
var inst_60623 = inst_60622;
var inst_60624 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_60663__$1 = (function (){var statearr_60666 = state_60663;
(statearr_60666[(7)] = inst_60624);

(statearr_60666[(8)] = inst_60623);

return statearr_60666;
})();
var statearr_60667_60699 = state_60663__$1;
(statearr_60667_60699[(2)] = null);

(statearr_60667_60699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60664 === (4))){
var inst_60627 = (state_60663[(9)]);
var inst_60627__$1 = (state_60663[(2)]);
var inst_60628 = (inst_60627__$1 == null);
var inst_60629 = cljs.core.not.call(null,inst_60628);
var state_60663__$1 = (function (){var statearr_60668 = state_60663;
(statearr_60668[(9)] = inst_60627__$1);

return statearr_60668;
})();
if(inst_60629){
var statearr_60669_60700 = state_60663__$1;
(statearr_60669_60700[(1)] = (5));

} else {
var statearr_60670_60701 = state_60663__$1;
(statearr_60670_60701[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60664 === (15))){
var inst_60653 = (state_60663[(2)]);
var state_60663__$1 = state_60663;
var statearr_60671_60702 = state_60663__$1;
(statearr_60671_60702[(2)] = inst_60653);

(statearr_60671_60702[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60664 === (13))){
var state_60663__$1 = state_60663;
var statearr_60672_60703 = state_60663__$1;
(statearr_60672_60703[(2)] = null);

(statearr_60672_60703[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60664 === (6))){
var inst_60623 = (state_60663[(8)]);
var inst_60648 = inst_60623.length;
var inst_60649 = (inst_60648 > (0));
var state_60663__$1 = state_60663;
if(cljs.core.truth_(inst_60649)){
var statearr_60673_60704 = state_60663__$1;
(statearr_60673_60704[(1)] = (12));

} else {
var statearr_60674_60705 = state_60663__$1;
(statearr_60674_60705[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60664 === (3))){
var inst_60661 = (state_60663[(2)]);
var state_60663__$1 = state_60663;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60663__$1,inst_60661);
} else {
if((state_val_60664 === (12))){
var inst_60623 = (state_60663[(8)]);
var inst_60651 = cljs.core.vec.call(null,inst_60623);
var state_60663__$1 = state_60663;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60663__$1,(15),out,inst_60651);
} else {
if((state_val_60664 === (2))){
var state_60663__$1 = state_60663;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60663__$1,(4),ch);
} else {
if((state_val_60664 === (11))){
var inst_60631 = (state_60663[(10)]);
var inst_60627 = (state_60663[(9)]);
var inst_60641 = (state_60663[(2)]);
var inst_60642 = [];
var inst_60643 = inst_60642.push(inst_60627);
var inst_60623 = inst_60642;
var inst_60624 = inst_60631;
var state_60663__$1 = (function (){var statearr_60675 = state_60663;
(statearr_60675[(7)] = inst_60624);

(statearr_60675[(8)] = inst_60623);

(statearr_60675[(11)] = inst_60641);

(statearr_60675[(12)] = inst_60643);

return statearr_60675;
})();
var statearr_60676_60706 = state_60663__$1;
(statearr_60676_60706[(2)] = null);

(statearr_60676_60706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60664 === (9))){
var inst_60623 = (state_60663[(8)]);
var inst_60639 = cljs.core.vec.call(null,inst_60623);
var state_60663__$1 = state_60663;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_60663__$1,(11),out,inst_60639);
} else {
if((state_val_60664 === (5))){
var inst_60624 = (state_60663[(7)]);
var inst_60631 = (state_60663[(10)]);
var inst_60627 = (state_60663[(9)]);
var inst_60631__$1 = f.call(null,inst_60627);
var inst_60632 = cljs.core._EQ_.call(null,inst_60631__$1,inst_60624);
var inst_60633 = cljs.core.keyword_identical_QMARK_.call(null,inst_60624,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_60634 = (inst_60632) || (inst_60633);
var state_60663__$1 = (function (){var statearr_60677 = state_60663;
(statearr_60677[(10)] = inst_60631__$1);

return statearr_60677;
})();
if(cljs.core.truth_(inst_60634)){
var statearr_60678_60707 = state_60663__$1;
(statearr_60678_60707[(1)] = (8));

} else {
var statearr_60679_60708 = state_60663__$1;
(statearr_60679_60708[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60664 === (14))){
var inst_60656 = (state_60663[(2)]);
var inst_60657 = cljs.core.async.close_BANG_.call(null,out);
var state_60663__$1 = (function (){var statearr_60681 = state_60663;
(statearr_60681[(13)] = inst_60656);

return statearr_60681;
})();
var statearr_60682_60709 = state_60663__$1;
(statearr_60682_60709[(2)] = inst_60657);

(statearr_60682_60709[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60664 === (10))){
var inst_60646 = (state_60663[(2)]);
var state_60663__$1 = state_60663;
var statearr_60683_60710 = state_60663__$1;
(statearr_60683_60710[(2)] = inst_60646);

(statearr_60683_60710[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60664 === (8))){
var inst_60623 = (state_60663[(8)]);
var inst_60631 = (state_60663[(10)]);
var inst_60627 = (state_60663[(9)]);
var inst_60636 = inst_60623.push(inst_60627);
var tmp60680 = inst_60623;
var inst_60623__$1 = tmp60680;
var inst_60624 = inst_60631;
var state_60663__$1 = (function (){var statearr_60684 = state_60663;
(statearr_60684[(7)] = inst_60624);

(statearr_60684[(8)] = inst_60623__$1);

(statearr_60684[(14)] = inst_60636);

return statearr_60684;
})();
var statearr_60685_60711 = state_60663__$1;
(statearr_60685_60711[(2)] = null);

(statearr_60685_60711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___60697,out))
;
return ((function (switch__38343__auto__,c__38457__auto___60697,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_60689 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60689[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_60689[(1)] = (1));

return statearr_60689;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_60663){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_60663);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e60690){if((e60690 instanceof Object)){
var ex__38347__auto__ = e60690;
var statearr_60691_60712 = state_60663;
(statearr_60691_60712[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_60663);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e60690;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60713 = state_60663;
state_60663 = G__60713;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_60663){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_60663);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___60697,out))
})();
var state__38459__auto__ = (function (){var statearr_60692 = f__38458__auto__.call(null);
(statearr_60692[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___60697);

return statearr_60692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___60697,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map