// Compiled by ClojureScript 1.9.521 {}
goog.provide('konserve.indexeddb');
goog.require('cljs.core');
goog.require('incognito.edn');
goog.require('konserve.core');
goog.require('konserve.serializers');
goog.require('konserve.protocols');
goog.require('cljs.core.async');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {konserve.protocols.PJSONAsyncKeyValueStore}
 * @implements {konserve.protocols.PEDNAsyncKeyValueStore}
 * @implements {konserve.protocols.PBinaryAsyncKeyValueStore}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
konserve.indexeddb.IndexedDBKeyValueStore = (function (db,store_name,serializer,read_handlers,write_handlers,locks,__meta,__extmap,__hash){
this.db = db;
this.store_name = store_name;
this.serializer = serializer;
this.read_handlers = read_handlers;
this.write_handlers = write_handlers;
this.locks = locks;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10094__auto__,k__10095__auto__){
var self__ = this;
var this__10094__auto____$1 = this;
return this__10094__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__10095__auto__,null);
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10096__auto__,k83799,else__10097__auto__){
var self__ = this;
var this__10096__auto____$1 = this;
var G__83801 = (((k83799 instanceof cljs.core.Keyword))?k83799.fqn:null);
switch (G__83801) {
case "db":
return self__.db;

break;
case "store-name":
return self__.store_name;

break;
case "serializer":
return self__.serializer;

break;
case "read-handlers":
return self__.read_handlers;

break;
case "write-handlers":
return self__.write_handlers;

break;
case "locks":
return self__.locks;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k83799,else__10097__auto__);

}
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10108__auto__,writer__10109__auto__,opts__10110__auto__){
var self__ = this;
var this__10108__auto____$1 = this;
var pr_pair__10111__auto__ = ((function (this__10108__auto____$1){
return (function (keyval__10112__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,cljs.core.pr_writer,""," ","",opts__10110__auto__,keyval__10112__auto__);
});})(this__10108__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,pr_pair__10111__auto__,"#konserve.indexeddb.IndexedDBKeyValueStore{",", ","}",opts__10110__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db","db",993250759),self__.db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"store-name","store-name",1423922810),self__.store_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__83798){
var self__ = this;
var G__83798__$1 = this;
return (new cljs.core.RecordIter((0),G__83798__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"store-name","store-name",1423922810),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PJSONAsyncKeyValueStore$ = cljs.core.PROTOCOL_SENTINEL;

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PJSONAsyncKeyValueStore$_jget_in$arity$2 = (function (this$,key_vec){
var self__ = this;
var this$__$1 = this;
var vec__83802 = key_vec;
var seq__83803 = cljs.core.seq.call(null,vec__83802);
var first__83804 = cljs.core.first.call(null,seq__83803);
var seq__83803__$1 = cljs.core.next.call(null,seq__83803);
var fkey = first__83804;
var rkey = seq__83803__$1;
var res = cljs.core.async.chan.call(null);
var tx = self__.db.transaction([self__.store_name]);
var obj_store = tx.objectStore(self__.store_name);
var req = obj_store.get(cljs.core.pr_str.call(null,fkey));
req.onerror = ((function (vec__83802,seq__83803,first__83804,seq__83803__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot write json value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"write-error","write-error",1404655507),new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.key,new cljs.core.Keyword(null,"error","error",-978969032),e.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(vec__83802,seq__83803,first__83804,seq__83803__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

req.onsuccess = ((function (vec__83802,seq__83803,first__83804,seq__83803__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e){
var temp__6738__auto___83823 = req.result;
if(cljs.core.truth_(temp__6738__auto___83823)){
var r_83824 = temp__6738__auto___83823;
cljs.core.async.put_BANG_.call(null,res,cljs.core.get_in.call(null,cljs.core.js__GT_clj.call(null,(r_83824["json_value"])),rkey));
} else {
}

return cljs.core.async.close_BANG_.call(null,res);
});})(vec__83802,seq__83803,first__83804,seq__83803__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

return res;
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PJSONAsyncKeyValueStore$_jassoc_in$arity$3 = (function (this$,key_vec,value){
var self__ = this;
var this$__$1 = this;
var vec__83805 = key_vec;
var seq__83806 = cljs.core.seq.call(null,vec__83805);
var first__83807 = cljs.core.first.call(null,seq__83806);
var seq__83806__$1 = cljs.core.next.call(null,seq__83806);
var fkey = first__83807;
var rkey = seq__83806__$1;
var res = cljs.core.async.chan.call(null);
var tx = self__.db.transaction([self__.store_name],"readwrite");
var obj_store = tx.objectStore(self__.store_name);
var req = obj_store.get(cljs.core.pr_str.call(null,fkey));
req.onerror = ((function (vec__83805,seq__83806,first__83807,seq__83806__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot write json value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"write-error","write-error",1404655507),new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.key,new cljs.core.Keyword(null,"error","error",-978969032),e.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(vec__83805,seq__83806,first__83807,seq__83806__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

req.onsuccess = ((function (vec__83805,seq__83806,first__83807,seq__83806__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function konserve$indexeddb$read_old(e){
var old = (function (){var temp__6738__auto__ = req.result;
if(cljs.core.truth_(temp__6738__auto__)){
var r = temp__6738__auto__;
return cljs.core.js__GT_clj.call(null,(r["json_value"]));
} else {
return null;
}
})();
var up_req = (cljs.core.truth_((function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return !(cljs.core.empty_QMARK_.call(null,rkey));
}
})())?obj_store.put(({"key": cljs.core.pr_str.call(null,fkey), "json_value": ((!(cljs.core.empty_QMARK_.call(null,rkey)))?cljs.core.clj__GT_js.call(null,cljs.core.assoc_in.call(null,old,rkey,value)):value)})):obj_store.delete(cljs.core.pr_str.call(null,fkey)));
up_req.onerror = ((function (old,up_req,vec__83805,seq__83806,first__83807,seq__83806__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e__$1){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot write json value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"write-error","write-error",1404655507),new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.key,new cljs.core.Keyword(null,"error","error",-978969032),e__$1.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(old,up_req,vec__83805,seq__83806,first__83807,seq__83806__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

return up_req.onsuccess = ((function (old,up_req,vec__83805,seq__83806,first__83807,seq__83806__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e__$1){
return cljs.core.async.close_BANG_.call(null,res);
});})(old,up_req,vec__83805,seq__83806,first__83807,seq__83806__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;
});})(vec__83805,seq__83806,first__83807,seq__83806__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

return res;
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PJSONAsyncKeyValueStore$_jupdate_in$arity$3 = (function (this$,key_vec,up_fn){
var self__ = this;
var this$__$1 = this;
var vec__83808 = key_vec;
var seq__83809 = cljs.core.seq.call(null,vec__83808);
var first__83810 = cljs.core.first.call(null,seq__83809);
var seq__83809__$1 = cljs.core.next.call(null,seq__83809);
var fkey = first__83810;
var rkey = seq__83809__$1;
var res = cljs.core.async.chan.call(null);
var tx = self__.db.transaction([self__.store_name],"readwrite");
var obj_store = tx.objectStore(self__.store_name);
var req = obj_store.get(cljs.core.pr_str.call(null,fkey));
req.onerror = ((function (vec__83808,seq__83809,first__83810,seq__83809__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot write json value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"write-error","write-error",1404655507),new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.key,new cljs.core.Keyword(null,"error","error",-978969032),e.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(vec__83808,seq__83809,first__83810,seq__83809__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

req.onsuccess = ((function (vec__83808,seq__83809,first__83810,seq__83809__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function konserve$indexeddb$read_old(e){
var old = (function (){var temp__6738__auto__ = req.result;
if(cljs.core.truth_(temp__6738__auto__)){
var r = temp__6738__auto__;
return (r["json_value"]);
} else {
return null;
}
})();
var new$ = ((!(cljs.core.empty_QMARK_.call(null,rkey)))?cljs.core.update_in.call(null,old,rkey,up_fn):up_fn.call(null,old));
var up_req = (cljs.core.truth_(new$)?obj_store.put(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.pr_str.call(null,fkey),new cljs.core.Keyword(null,"json_value","json_value",-1620527912),cljs.core.pr_str.call(null,new$)], null))):obj_store.delete(cljs.core.pr_str.call(null,fkey)));
up_req.onerror = ((function (old,new$,up_req,vec__83808,seq__83809,first__83810,seq__83809__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e__$1){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot write json value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"write-error","write-error",1404655507),new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.key,new cljs.core.Keyword(null,"error","error",-978969032),e__$1.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(old,new$,up_req,vec__83808,seq__83809,first__83810,seq__83809__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

return up_req.onsuccess = ((function (old,new$,up_req,vec__83808,seq__83809,first__83810,seq__83809__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e__$1){
cljs.core.async.put_BANG_.call(null,res,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,old,rkey),cljs.core.get_in.call(null,new$,rkey)], null));

return cljs.core.async.close_BANG_.call(null,res);
});})(old,new$,up_req,vec__83808,seq__83809,first__83810,seq__83809__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;
});})(vec__83808,seq__83809,first__83810,seq__83809__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

return res;
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10092__auto__){
var self__ = this;
var this__10092__auto____$1 = this;
return self__.__meta;
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10088__auto__){
var self__ = this;
var this__10088__auto____$1 = this;
return (new konserve.indexeddb.IndexedDBKeyValueStore(self__.db,self__.store_name,self__.serializer,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,self__.__hash));
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$ = cljs.core.PROTOCOL_SENTINEL;

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_exists_QMARK_$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var res = cljs.core.async.chan.call(null);
var tx = self__.db.transaction([self__.store_name]);
var obj_store = tx.objectStore(self__.store_name);
var req = obj_store.openCursor(cljs.core.pr_str.call(null,key));
req.onerror = ((function (res,tx,obj_store,req,this$__$1){
return (function (e){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot check for existence.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"access-error","access-error",2084886472),new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"error","error",-978969032),e.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(res,tx,obj_store,req,this$__$1))
;

req.onsuccess = ((function (res,tx,obj_store,req,this$__$1){
return (function (e){
cljs.core.async.put_BANG_.call(null,res,(cljs.core.truth_(e.target.result)?true:false));

return cljs.core.async.close_BANG_.call(null,res);
});})(res,tx,obj_store,req,this$__$1))
;

return res;
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_get_in$arity$2 = (function (this$,key_vec){
var self__ = this;
var this$__$1 = this;
var vec__83811 = key_vec;
var seq__83812 = cljs.core.seq.call(null,vec__83811);
var first__83813 = cljs.core.first.call(null,seq__83812);
var seq__83812__$1 = cljs.core.next.call(null,seq__83812);
var fkey = first__83813;
var rkey = seq__83812__$1;
var res = cljs.core.async.chan.call(null);
var tx = self__.db.transaction([self__.store_name]);
var obj_store = tx.objectStore(self__.store_name);
var req = obj_store.get(cljs.core.pr_str.call(null,fkey));
req.onerror = ((function (vec__83811,seq__83812,first__83813,seq__83812__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot read edn value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"read-error","read-error",1254709471),new cljs.core.Keyword(null,"key","key",-1516042587),key_vec,new cljs.core.Keyword(null,"error","error",-978969032),e.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(vec__83811,seq__83812,first__83813,seq__83812__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

req.onsuccess = ((function (vec__83811,seq__83812,first__83813,seq__83812__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e){
var temp__6738__auto___83825 = req.result;
if(cljs.core.truth_(temp__6738__auto___83825)){
var r_83826 = temp__6738__auto___83825;
cljs.core.async.put_BANG_.call(null,res,cljs.core.get_in.call(null,konserve.protocols._deserialize.call(null,self__.serializer,self__.read_handlers,(r_83826["edn_value"])),rkey));
} else {
}

return cljs.core.async.close_BANG_.call(null,res);
});})(vec__83811,seq__83812,first__83813,seq__83812__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

return res;
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_update_in$arity$3 = (function (this$,key_vec,up_fn){
var self__ = this;
var this$__$1 = this;
var vec__83814 = key_vec;
var seq__83815 = cljs.core.seq.call(null,vec__83814);
var first__83816 = cljs.core.first.call(null,seq__83815);
var seq__83815__$1 = cljs.core.next.call(null,seq__83815);
var fkey = first__83816;
var rkey = seq__83815__$1;
var res = cljs.core.async.chan.call(null);
var tx = self__.db.transaction([self__.store_name],"readwrite");
var obj_store = tx.objectStore(self__.store_name);
var req = obj_store.get(cljs.core.pr_str.call(null,fkey));
req.onerror = ((function (vec__83814,seq__83815,first__83816,seq__83815__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot read edn value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"read-error","read-error",1254709471),new cljs.core.Keyword(null,"key","key",-1516042587),key_vec,new cljs.core.Keyword(null,"error","error",-978969032),e.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(vec__83814,seq__83815,first__83816,seq__83815__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

req.onsuccess = ((function (vec__83814,seq__83815,first__83816,seq__83815__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function konserve$indexeddb$read_old(e){
try{var old = (function (){var temp__6738__auto__ = req.result;
if(cljs.core.truth_(temp__6738__auto__)){
var r = temp__6738__auto__;
return konserve.protocols._deserialize.call(null,self__.serializer,self__.read_handlers,(r["edn_value"]));
} else {
return null;
}
})();
var up = ((!(cljs.core.empty_QMARK_.call(null,rkey)))?cljs.core.update_in.call(null,old,rkey,up_fn):up_fn.call(null,old));
var up_req = obj_store.put(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),cljs.core.pr_str.call(null,fkey),new cljs.core.Keyword(null,"edn_value","edn_value",51042300),konserve.protocols._serialize.call(null,self__.serializer,null,self__.write_handlers,up)], null)));
up_req.onerror = ((function (up_req,old,up,vec__83814,seq__83815,first__83816,seq__83815__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e__$1){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot write edn value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"write-error","write-error",1404655507),new cljs.core.Keyword(null,"key","key",-1516042587),key_vec,new cljs.core.Keyword(null,"error","error",-978969032),e__$1.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(up_req,old,up,vec__83814,seq__83815,first__83816,seq__83815__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

return up_req.onsuccess = ((function (up_req,old,up,vec__83814,seq__83815,first__83816,seq__83815__$1,fkey,rkey,res,tx,obj_store,req,this$__$1){
return (function (e__$1){
cljs.core.async.put_BANG_.call(null,res,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,old,rkey),up], null));

return cljs.core.async.close_BANG_.call(null,res);
});})(up_req,old,up,vec__83814,seq__83815,first__83816,seq__83815__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;
}catch (e83818){var e__$1 = e83818;
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot parse edn value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"read-error","read-error",1254709471),new cljs.core.Keyword(null,"key","key",-1516042587),key_vec,new cljs.core.Keyword(null,"error","error",-978969032),e__$1], null)));

return cljs.core.async.close_BANG_.call(null,res);
}});})(vec__83814,seq__83815,first__83816,seq__83815__$1,fkey,rkey,res,tx,obj_store,req,this$__$1))
;

return res;
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_assoc_in$arity$3 = (function (this$,key_vec,val){
var self__ = this;
var this$__$1 = this;
return this$__$1.konserve$protocols$PEDNAsyncKeyValueStore$_update_in$arity$3(null,key_vec,((function (this$__$1){
return (function (_){
return val;
});})(this$__$1))
);
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_dissoc$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var res = cljs.core.async.chan.call(null);
var tx = self__.db.transaction([self__.store_name],"readwrite");
var obj_store = tx.objectStore(self__.store_name);
var up_req = obj_store.delete(cljs.core.pr_str.call(null,key));
up_req.onerror = ((function (res,tx,obj_store,up_req,this$__$1){
return (function (e){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot write edn value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"write-error","write-error",1404655507),new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"error","error",-978969032),e.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(res,tx,obj_store,up_req,this$__$1))
;

up_req.onsuccess = ((function (res,tx,obj_store,up_req,this$__$1){
return (function (e){
return cljs.core.async.close_BANG_.call(null,res);
});})(res,tx,obj_store,up_req,this$__$1))
;

return res;
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10098__auto__){
var self__ = this;
var this__10098__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$ = cljs.core.PROTOCOL_SENTINEL;

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bget$arity$3 = (function (this$,key,lock_cb){
var self__ = this;
var this$__$1 = this;
var res = cljs.core.async.chan.call(null);
var tx = self__.db.transaction([self__.store_name]);
var obj_store = tx.objectStore(self__.store_name);
var req = obj_store.get(cljs.core.pr_str.call(null,key));
req.onerror = ((function (res,tx,obj_store,req,this$__$1){
return (function (e){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot read binary value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"read-error","read-error",1254709471),new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"error","error",-978969032),e.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(res,tx,obj_store,req,this$__$1))
;

req.onsuccess = ((function (res,tx,obj_store,req,this$__$1){
return (function (e){
var temp__6738__auto___83827 = req.result;
if(cljs.core.truth_(temp__6738__auto___83827)){
var r_83828 = temp__6738__auto___83827;
cljs.core.async.put_BANG_.call(null,res,lock_cb.call(null,(r_83828["value"])));
} else {
}

return cljs.core.async.close_BANG_.call(null,res);
});})(res,tx,obj_store,req,this$__$1))
;

return res;
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bassoc$arity$3 = (function (this$,key,blob){
var self__ = this;
var this$__$1 = this;
var res = cljs.core.async.chan.call(null);
var tx = self__.db.transaction([self__.store_name],"readwrite");
var obj_store = tx.objectStore(self__.store_name);
var req = obj_store.put(({"key": cljs.core.pr_str.call(null,key), "value": blob}));
req.onerror = ((function (res,tx,obj_store,req,this$__$1){
return (function (e){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot write binary value.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"write-error","write-error",1404655507),new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"error","error",-978969032),e.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(res,tx,obj_store,req,this$__$1))
;

req.onsuccess = ((function (res,tx,obj_store,req,this$__$1){
return (function (e){
return cljs.core.async.close_BANG_.call(null,res);
});})(res,tx,obj_store,req,this$__$1))
;

return res;
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10089__auto__){
var self__ = this;
var this__10089__auto____$1 = this;
var h__9861__auto__ = self__.__hash;
if(!((h__9861__auto__ == null))){
return h__9861__auto__;
} else {
var h__9861__auto____$1 = cljs.core.hash_imap.call(null,this__10089__auto____$1);
self__.__hash = h__9861__auto____$1;

return h__9861__auto____$1;
}
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10090__auto__,other__10091__auto__){
var self__ = this;
var this__10090__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9407__auto__ = other__10091__auto__;
if(cljs.core.truth_(and__9407__auto__)){
return ((this__10090__auto____$1.constructor === other__10091__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__10090__auto____$1,other__10091__auto__));
} else {
return and__9407__auto__;
}
})())){
return true;
} else {
return false;
}
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10103__auto__,k__10104__auto__){
var self__ = this;
var this__10103__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"locks","locks",1560476518),null,new cljs.core.Keyword(null,"db","db",993250759),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),null,new cljs.core.Keyword(null,"store-name","store-name",1423922810),null], null), null),k__10104__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10103__auto____$1),self__.__meta),k__10104__auto__);
} else {
return (new konserve.indexeddb.IndexedDBKeyValueStore(self__.db,self__.store_name,self__.serializer,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10104__auto__)),null));
}
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10101__auto__,k__10102__auto__,G__83798){
var self__ = this;
var this__10101__auto____$1 = this;
var pred__83819 = cljs.core.keyword_identical_QMARK_;
var expr__83820 = k__10102__auto__;
if(cljs.core.truth_(pred__83819.call(null,new cljs.core.Keyword(null,"db","db",993250759),expr__83820))){
return (new konserve.indexeddb.IndexedDBKeyValueStore(G__83798,self__.store_name,self__.serializer,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__83819.call(null,new cljs.core.Keyword(null,"store-name","store-name",1423922810),expr__83820))){
return (new konserve.indexeddb.IndexedDBKeyValueStore(self__.db,G__83798,self__.serializer,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__83819.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__83820))){
return (new konserve.indexeddb.IndexedDBKeyValueStore(self__.db,self__.store_name,G__83798,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__83819.call(null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),expr__83820))){
return (new konserve.indexeddb.IndexedDBKeyValueStore(self__.db,self__.store_name,self__.serializer,G__83798,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__83819.call(null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),expr__83820))){
return (new konserve.indexeddb.IndexedDBKeyValueStore(self__.db,self__.store_name,self__.serializer,self__.read_handlers,G__83798,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__83819.call(null,new cljs.core.Keyword(null,"locks","locks",1560476518),expr__83820))){
return (new konserve.indexeddb.IndexedDBKeyValueStore(self__.db,self__.store_name,self__.serializer,self__.read_handlers,self__.write_handlers,G__83798,self__.__meta,self__.__extmap,null));
} else {
return (new konserve.indexeddb.IndexedDBKeyValueStore(self__.db,self__.store_name,self__.serializer,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10102__auto__,G__83798),null));
}
}
}
}
}
}
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10106__auto__){
var self__ = this;
var this__10106__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db","db",993250759),self__.db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"store-name","store-name",1423922810),self__.store_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10093__auto__,G__83798){
var self__ = this;
var this__10093__auto____$1 = this;
return (new konserve.indexeddb.IndexedDBKeyValueStore(self__.db,self__.store_name,self__.serializer,self__.read_handlers,self__.write_handlers,self__.locks,G__83798,self__.__extmap,self__.__hash));
});

konserve.indexeddb.IndexedDBKeyValueStore.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10099__auto__,entry__10100__auto__){
var self__ = this;
var this__10099__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10100__auto__)){
return this__10099__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__10100__auto__,(0)),cljs.core._nth.call(null,entry__10100__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10099__auto____$1,entry__10100__auto__);
}
});

konserve.indexeddb.IndexedDBKeyValueStore.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null),new cljs.core.Symbol(null,"store-name","store-name",-1230512959,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"read-handlers","read-handlers",-544976454,null),new cljs.core.Symbol(null,"write-handlers","write-handlers",-456757384,null),new cljs.core.Symbol(null,"locks","locks",-1093959251,null)], null);
});

konserve.indexeddb.IndexedDBKeyValueStore.cljs$lang$type = true;

konserve.indexeddb.IndexedDBKeyValueStore.cljs$lang$ctorPrSeq = (function (this__10130__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"konserve.indexeddb/IndexedDBKeyValueStore");
});

konserve.indexeddb.IndexedDBKeyValueStore.cljs$lang$ctorPrWriter = (function (this__10130__auto__,writer__10131__auto__){
return cljs.core._write.call(null,writer__10131__auto__,"konserve.indexeddb/IndexedDBKeyValueStore");
});

konserve.indexeddb.__GT_IndexedDBKeyValueStore = (function konserve$indexeddb$__GT_IndexedDBKeyValueStore(db,store_name,serializer,read_handlers,write_handlers,locks){
return (new konserve.indexeddb.IndexedDBKeyValueStore(db,store_name,serializer,read_handlers,write_handlers,locks,null,null,null));
});

konserve.indexeddb.map__GT_IndexedDBKeyValueStore = (function konserve$indexeddb$map__GT_IndexedDBKeyValueStore(G__83800){
return (new konserve.indexeddb.IndexedDBKeyValueStore(new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(G__83800),new cljs.core.Keyword(null,"store-name","store-name",1423922810).cljs$core$IFn$_invoke$arity$1(G__83800),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__83800),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315).cljs$core$IFn$_invoke$arity$1(G__83800),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911).cljs$core$IFn$_invoke$arity$1(G__83800),new cljs.core.Keyword(null,"locks","locks",1560476518).cljs$core$IFn$_invoke$arity$1(G__83800),null,cljs.core.dissoc.call(null,G__83800,new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"store-name","store-name",1423922810),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)),null));
});

/**
 * Create an IndexedDB backed edn store with read-handlers according to
 *   incognito.
 * 
 *   Be careful not to mix up edn and JSON values.
 */
konserve.indexeddb.new_indexeddb_store = (function konserve$indexeddb$new_indexeddb_store(var_args){
var args__10647__auto__ = [];
var len__10640__auto___83834 = arguments.length;
var i__10641__auto___83835 = (0);
while(true){
if((i__10641__auto___83835 < len__10640__auto___83834)){
args__10647__auto__.push((arguments[i__10641__auto___83835]));

var G__83836 = (i__10641__auto___83835 + (1));
i__10641__auto___83835 = G__83836;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return konserve.indexeddb.new_indexeddb_store.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

konserve.indexeddb.new_indexeddb_store.cljs$core$IFn$_invoke$arity$variadic = (function (name,p__83831){
var map__83832 = p__83831;
var map__83832__$1 = ((((!((map__83832 == null)))?((((map__83832.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__83832.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__83832):map__83832);
var read_handlers = cljs.core.get.call(null,map__83832__$1,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var write_handlers = cljs.core.get.call(null,map__83832__$1,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var serializer = cljs.core.get.call(null,map__83832__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),konserve.serializers.string_serializer.call(null));
var res = cljs.core.async.chan.call(null);
var req = window.indexedDB.open(name,(1));
req.onerror = ((function (res,req,map__83832,map__83832__$1,read_handlers,write_handlers,serializer){
return (function (e){
cljs.core.async.put_BANG_.call(null,res,cljs.core.ex_info.call(null,"Cannot open IndexedDB store.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db-error","db-error",592028563),new cljs.core.Keyword(null,"error","error",-978969032),e.target], null)));

return cljs.core.async.close_BANG_.call(null,res);
});})(res,req,map__83832,map__83832__$1,read_handlers,write_handlers,serializer))
;

req.onsuccess = ((function (res,req,map__83832,map__83832__$1,read_handlers,write_handlers,serializer){
return (function konserve$indexeddb$success_handler(e){
return cljs.core.async.put_BANG_.call(null,res,konserve.indexeddb.map__GT_IndexedDBKeyValueStore.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"db","db",993250759),req.result,new cljs.core.Keyword(null,"serializer","serializer",-875689688),serializer,new cljs.core.Keyword(null,"store-name","store-name",1423922810),name,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),read_handlers,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),write_handlers,new cljs.core.Keyword(null,"locks","locks",1560476518),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)], null)));
});})(res,req,map__83832,map__83832__$1,read_handlers,write_handlers,serializer))
;

req.onupgradeneeded = ((function (res,req,map__83832,map__83832__$1,read_handlers,write_handlers,serializer){
return (function konserve$indexeddb$upgrade_handler(e){
var db = e.target.result;
return db.createObjectStore(name,({"keyPath": "key"}));
});})(res,req,map__83832,map__83832__$1,read_handlers,write_handlers,serializer))
;

return res;
});

konserve.indexeddb.new_indexeddb_store.cljs$lang$maxFixedArity = (1);

konserve.indexeddb.new_indexeddb_store.cljs$lang$applyTo = (function (seq83829){
var G__83830 = cljs.core.first.call(null,seq83829);
var seq83829__$1 = cljs.core.next.call(null,seq83829);
return konserve.indexeddb.new_indexeddb_store.cljs$core$IFn$_invoke$arity$variadic(G__83830,seq83829__$1);
});


//# sourceMappingURL=indexeddb.js.map