// Compiled by ClojureScript 1.9.521 {}
goog.provide('hasch.benc');
goog.require('cljs.core');

/**
 * @interface
 */
hasch.benc.PHashCoercion = function(){};

hasch.benc._coerce = (function hasch$benc$_coerce(this$,md_create_fn,write_handlers){
if((!((this$ == null))) && (!((this$.hasch$benc$PHashCoercion$_coerce$arity$3 == null)))){
return this$.hasch$benc$PHashCoercion$_coerce$arity$3(this$,md_create_fn,write_handlers);
} else {
var x__10137__auto__ = (((this$ == null))?null:this$);
var m__10138__auto__ = (hasch.benc._coerce[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,this$,md_create_fn,write_handlers);
} else {
var m__10138__auto____$1 = (hasch.benc._coerce["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,this$,md_create_fn,write_handlers);
} else {
throw cljs.core.missing_protocol.call(null,"PHashCoercion.-coerce",this$);
}
}
}
});

hasch.benc.magics = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"binary","binary",-1802232288),new cljs.core.Keyword(null,"inst","inst",645962501),new cljs.core.Keyword(null,"number","number",1570378438),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"vector","vector",1902966158),new cljs.core.Keyword(null,"keyword","keyword",811389747),new cljs.core.Keyword(null,"nil","nil",99600501),new cljs.core.Keyword(null,"literal","literal",1664775605),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"seq","seq",-1817803783),new cljs.core.Keyword(null,"set","set",304602554),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"map","map",1371690461)],[(13),(6),(2),(4),(3),(9),(5),(0),(12),(7),(8),(11),(1),(10)]);
hasch.benc.split_size = (1024);
hasch.benc.max_entropy_byte_count = (32);
hasch.benc.byte_array = (function hasch$benc$byte_array(len){
return cljs.core.into_array.call(null,cljs.core.repeat.call(null,len,(0)));
});
hasch.benc.digest = (function hasch$benc$digest(bytes_or_seq_of_bytes,md_create_fn){
var md = md_create_fn.call(null);
if(cljs.core.seq_QMARK_.call(null,bytes_or_seq_of_bytes)){
var seq__82395_82399 = cljs.core.seq.call(null,bytes_or_seq_of_bytes);
var chunk__82396_82400 = null;
var count__82397_82401 = (0);
var i__82398_82402 = (0);
while(true){
if((i__82398_82402 < count__82397_82401)){
var bs_82403 = cljs.core._nth.call(null,chunk__82396_82400,i__82398_82402);
md.update(bs_82403);

var G__82404 = seq__82395_82399;
var G__82405 = chunk__82396_82400;
var G__82406 = count__82397_82401;
var G__82407 = (i__82398_82402 + (1));
seq__82395_82399 = G__82404;
chunk__82396_82400 = G__82405;
count__82397_82401 = G__82406;
i__82398_82402 = G__82407;
continue;
} else {
var temp__6738__auto___82408 = cljs.core.seq.call(null,seq__82395_82399);
if(temp__6738__auto___82408){
var seq__82395_82409__$1 = temp__6738__auto___82408;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__82395_82409__$1)){
var c__10330__auto___82410 = cljs.core.chunk_first.call(null,seq__82395_82409__$1);
var G__82411 = cljs.core.chunk_rest.call(null,seq__82395_82409__$1);
var G__82412 = c__10330__auto___82410;
var G__82413 = cljs.core.count.call(null,c__10330__auto___82410);
var G__82414 = (0);
seq__82395_82399 = G__82411;
chunk__82396_82400 = G__82412;
count__82397_82401 = G__82413;
i__82398_82402 = G__82414;
continue;
} else {
var bs_82415 = cljs.core.first.call(null,seq__82395_82409__$1);
md.update(bs_82415);

var G__82416 = cljs.core.next.call(null,seq__82395_82409__$1);
var G__82417 = null;
var G__82418 = (0);
var G__82419 = (0);
seq__82395_82399 = G__82416;
chunk__82396_82400 = G__82417;
count__82397_82401 = G__82418;
i__82398_82402 = G__82419;
continue;
}
} else {
}
}
break;
}
} else {
md.update(bytes_or_seq_of_bytes);
}

return md.digest();
});
hasch.benc.coerce_seq = (function hasch$benc$coerce_seq(seq,md_create_fn,write_handlers){
var seq_md = md_create_fn.call(null);
var s_82426 = seq;
while(true){
var vec__82423_82427 = s_82426;
var seq__82424_82428 = cljs.core.seq.call(null,vec__82423_82427);
var first__82425_82429 = cljs.core.first.call(null,seq__82424_82428);
var seq__82424_82430__$1 = cljs.core.next.call(null,seq__82424_82428);
var f_82431 = first__82425_82429;
var r_82432 = seq__82424_82430__$1;
seq_md.update(hasch.benc._coerce.call(null,f_82431,md_create_fn,write_handlers));

if(cljs.core.empty_QMARK_.call(null,r_82432)){
} else {
var G__82433 = cljs.core.rest.call(null,s_82426);
s_82426 = G__82433;
continue;
}
break;
}

return seq_md.digest();
});
/**
 * Commutatively coerces elements of collection, seq entries must already be crypto hashes
 *   to avoid collisions in XOR. Takes at maximum 32 bytes into account.
 */
hasch.benc.xor_hashes = (function hasch$benc$xor_hashes(seq){
var len = (function (){var x__9764__auto__ = cljs.core.count.call(null,cljs.core.first.call(null,seq));
var y__9765__auto__ = hasch.benc.max_entropy_byte_count;
return ((x__9764__auto__ < y__9765__auto__) ? x__9764__auto__ : y__9765__auto__);
})();
return cljs.core.reduce.call(null,((function (len){
return (function (acc,elem){
var i_82434 = (0);
while(true){
if((i_82434 < len)){
(acc[i_82434] = ((acc[i_82434]) ^ (elem[i_82434])));

var G__82435 = (i_82434 + (1));
i_82434 = G__82435;
continue;
} else {
}
break;
}

return acc;
});})(len))
,hasch.benc.byte_array.call(null,len),seq);
});
hasch.benc.encode_safe = (function hasch$benc$encode_safe(a,md_create_fn){
if((cljs.core.count.call(null,a) < hasch.benc.split_size)){
var len = cljs.core.long$.call(null,a.length);
var ea = hasch.benc.byte_array.call(null,len);
var i_82436 = (0);
while(true){
if(cljs.core._EQ_.call(null,i_82436,len)){
} else {
var e_82437 = (a[i_82436]);
if(((e_82437 > (0))) && ((e_82437 < (30)))){
(ea[i_82436] = (1));
} else {
}

var G__82438 = (i_82436 + (1));
i_82436 = G__82438;
continue;
}
break;
}

return a.concat(ea);
} else {
return hasch.benc.digest.call(null,a,md_create_fn);
}
});

//# sourceMappingURL=benc.js.map