// Compiled by ClojureScript 1.9.521 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__52586__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__52583 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__52584 = cljs.core.seq.call(null,vec__52583);
var first__52585 = cljs.core.first.call(null,seq__52584);
var seq__52584__$1 = cljs.core.next.call(null,seq__52584);
var tag = first__52585;
var body = seq__52584__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__52586 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__52587__i = 0, G__52587__a = new Array(arguments.length -  0);
while (G__52587__i < G__52587__a.length) {G__52587__a[G__52587__i] = arguments[G__52587__i + 0]; ++G__52587__i;}
  args = new cljs.core.IndexedSeq(G__52587__a,0);
} 
return G__52586__delegate.call(this,args);};
G__52586.cljs$lang$maxFixedArity = 0;
G__52586.cljs$lang$applyTo = (function (arglist__52588){
var args = cljs.core.seq(arglist__52588);
return G__52586__delegate(args);
});
G__52586.cljs$core$IFn$_invoke$arity$variadic = G__52586__delegate;
return G__52586;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__10281__auto__ = (function sablono$core$update_arglists_$_iter__52593(s__52594){
return (new cljs.core.LazySeq(null,(function (){
var s__52594__$1 = s__52594;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__52594__$1);
if(temp__6738__auto__){
var s__52594__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__52594__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__52594__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__52596 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__52595 = (0);
while(true){
if((i__52595 < size__10280__auto__)){
var args = cljs.core._nth.call(null,c__10279__auto__,i__52595);
cljs.core.chunk_append.call(null,b__52596,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__52597 = (i__52595 + (1));
i__52595 = G__52597;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52596),sablono$core$update_arglists_$_iter__52593.call(null,cljs.core.chunk_rest.call(null,s__52594__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52596),null);
}
} else {
var args = cljs.core.first.call(null,s__52594__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__52593.call(null,cljs.core.rest.call(null,s__52594__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__10647__auto__ = [];
var len__10640__auto___52603 = arguments.length;
var i__10641__auto___52604 = (0);
while(true){
if((i__10641__auto___52604 < len__10640__auto___52603)){
args__10647__auto__.push((arguments[i__10641__auto___52604]));

var G__52605 = (i__10641__auto___52604 + (1));
i__10641__auto___52604 = G__52605;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((0) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__10648__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__10281__auto__ = (function sablono$core$iter__52599(s__52600){
return (new cljs.core.LazySeq(null,(function (){
var s__52600__$1 = s__52600;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__52600__$1);
if(temp__6738__auto__){
var s__52600__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__52600__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__52600__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__52602 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__52601 = (0);
while(true){
if((i__52601 < size__10280__auto__)){
var style = cljs.core._nth.call(null,c__10279__auto__,i__52601);
cljs.core.chunk_append.call(null,b__52602,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__52606 = (i__52601 + (1));
i__52601 = G__52606;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52602),sablono$core$iter__52599.call(null,cljs.core.chunk_rest.call(null,s__52600__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52602),null);
}
} else {
var style = cljs.core.first.call(null,s__52600__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__52599.call(null,cljs.core.rest.call(null,s__52600__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq52598){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq52598));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to52607 = (function sablono$core$link_to52607(var_args){
var args__10647__auto__ = [];
var len__10640__auto___52610 = arguments.length;
var i__10641__auto___52611 = (0);
while(true){
if((i__10641__auto___52611 < len__10640__auto___52610)){
args__10647__auto__.push((arguments[i__10641__auto___52611]));

var G__52612 = (i__10641__auto___52611 + (1));
i__10641__auto___52611 = G__52612;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to52607.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.link_to52607.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to52607.cljs$lang$maxFixedArity = (1);

sablono.core.link_to52607.cljs$lang$applyTo = (function (seq52608){
var G__52609 = cljs.core.first.call(null,seq52608);
var seq52608__$1 = cljs.core.next.call(null,seq52608);
return sablono.core.link_to52607.cljs$core$IFn$_invoke$arity$variadic(G__52609,seq52608__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to52607);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to52613 = (function sablono$core$mail_to52613(var_args){
var args__10647__auto__ = [];
var len__10640__auto___52620 = arguments.length;
var i__10641__auto___52621 = (0);
while(true){
if((i__10641__auto___52621 < len__10640__auto___52620)){
args__10647__auto__.push((arguments[i__10641__auto___52621]));

var G__52622 = (i__10641__auto___52621 + (1));
i__10641__auto___52621 = G__52622;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to52613.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.mail_to52613.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__52616){
var vec__52617 = p__52616;
var content = cljs.core.nth.call(null,vec__52617,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("mailto:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__9419__auto__ = content;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to52613.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to52613.cljs$lang$applyTo = (function (seq52614){
var G__52615 = cljs.core.first.call(null,seq52614);
var seq52614__$1 = cljs.core.next.call(null,seq52614);
return sablono.core.mail_to52613.cljs$core$IFn$_invoke$arity$variadic(G__52615,seq52614__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to52613);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list52623 = (function sablono$core$unordered_list52623(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__10281__auto__ = (function sablono$core$unordered_list52623_$_iter__52628(s__52629){
return (new cljs.core.LazySeq(null,(function (){
var s__52629__$1 = s__52629;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__52629__$1);
if(temp__6738__auto__){
var s__52629__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__52629__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__52629__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__52631 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__52630 = (0);
while(true){
if((i__52630 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__52630);
cljs.core.chunk_append.call(null,b__52631,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__52632 = (i__52630 + (1));
i__52630 = G__52632;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52631),sablono$core$unordered_list52623_$_iter__52628.call(null,cljs.core.chunk_rest.call(null,s__52629__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52631),null);
}
} else {
var x = cljs.core.first.call(null,s__52629__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list52623_$_iter__52628.call(null,cljs.core.rest.call(null,s__52629__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list52623);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list52633 = (function sablono$core$ordered_list52633(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__10281__auto__ = (function sablono$core$ordered_list52633_$_iter__52638(s__52639){
return (new cljs.core.LazySeq(null,(function (){
var s__52639__$1 = s__52639;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__52639__$1);
if(temp__6738__auto__){
var s__52639__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__52639__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__52639__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__52641 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__52640 = (0);
while(true){
if((i__52640 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__52640);
cljs.core.chunk_append.call(null,b__52641,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__52642 = (i__52640 + (1));
i__52640 = G__52642;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52641),sablono$core$ordered_list52633_$_iter__52638.call(null,cljs.core.chunk_rest.call(null,s__52639__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52641),null);
}
} else {
var x = cljs.core.first.call(null,s__52639__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list52633_$_iter__52638.call(null,cljs.core.rest.call(null,s__52639__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list52633);
/**
 * Create an image element.
 */
sablono.core.image52643 = (function sablono$core$image52643(var_args){
var args52644 = [];
var len__10640__auto___52647 = arguments.length;
var i__10641__auto___52648 = (0);
while(true){
if((i__10641__auto___52648 < len__10640__auto___52647)){
args52644.push((arguments[i__10641__auto___52648]));

var G__52649 = (i__10641__auto___52648 + (1));
i__10641__auto___52648 = G__52649;
continue;
} else {
}
break;
}

var G__52646 = args52644.length;
switch (G__52646) {
case 1:
return sablono.core.image52643.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image52643.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52644.length)].join('')));

}
});

sablono.core.image52643.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image52643.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image52643.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image52643);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__52651_SHARP_,p2__52652_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__52651_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("["),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__52652_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__52653_SHARP_,p2__52654_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__52653_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__52654_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field52655 = (function sablono$core$color_field52655(var_args){
var args52656 = [];
var len__10640__auto___52723 = arguments.length;
var i__10641__auto___52724 = (0);
while(true){
if((i__10641__auto___52724 < len__10640__auto___52723)){
args52656.push((arguments[i__10641__auto___52724]));

var G__52725 = (i__10641__auto___52724 + (1));
i__10641__auto___52724 = G__52725;
continue;
} else {
}
break;
}

var G__52658 = args52656.length;
switch (G__52658) {
case 1:
return sablono.core.color_field52655.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field52655.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52656.length)].join('')));

}
});

sablono.core.color_field52655.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.color_field52655.call(null,name__30813__auto__,null);
});

sablono.core.color_field52655.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.color_field52655.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field52655);

/**
 * Creates a date input field.
 */
sablono.core.date_field52659 = (function sablono$core$date_field52659(var_args){
var args52660 = [];
var len__10640__auto___52727 = arguments.length;
var i__10641__auto___52728 = (0);
while(true){
if((i__10641__auto___52728 < len__10640__auto___52727)){
args52660.push((arguments[i__10641__auto___52728]));

var G__52729 = (i__10641__auto___52728 + (1));
i__10641__auto___52728 = G__52729;
continue;
} else {
}
break;
}

var G__52662 = args52660.length;
switch (G__52662) {
case 1:
return sablono.core.date_field52659.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field52659.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52660.length)].join('')));

}
});

sablono.core.date_field52659.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.date_field52659.call(null,name__30813__auto__,null);
});

sablono.core.date_field52659.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.date_field52659.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field52659);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field52663 = (function sablono$core$datetime_field52663(var_args){
var args52664 = [];
var len__10640__auto___52731 = arguments.length;
var i__10641__auto___52732 = (0);
while(true){
if((i__10641__auto___52732 < len__10640__auto___52731)){
args52664.push((arguments[i__10641__auto___52732]));

var G__52733 = (i__10641__auto___52732 + (1));
i__10641__auto___52732 = G__52733;
continue;
} else {
}
break;
}

var G__52666 = args52664.length;
switch (G__52666) {
case 1:
return sablono.core.datetime_field52663.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field52663.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52664.length)].join('')));

}
});

sablono.core.datetime_field52663.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.datetime_field52663.call(null,name__30813__auto__,null);
});

sablono.core.datetime_field52663.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.datetime_field52663.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field52663);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field52667 = (function sablono$core$datetime_local_field52667(var_args){
var args52668 = [];
var len__10640__auto___52735 = arguments.length;
var i__10641__auto___52736 = (0);
while(true){
if((i__10641__auto___52736 < len__10640__auto___52735)){
args52668.push((arguments[i__10641__auto___52736]));

var G__52737 = (i__10641__auto___52736 + (1));
i__10641__auto___52736 = G__52737;
continue;
} else {
}
break;
}

var G__52670 = args52668.length;
switch (G__52670) {
case 1:
return sablono.core.datetime_local_field52667.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field52667.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52668.length)].join('')));

}
});

sablono.core.datetime_local_field52667.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.datetime_local_field52667.call(null,name__30813__auto__,null);
});

sablono.core.datetime_local_field52667.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.datetime_local_field52667.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field52667);

/**
 * Creates a email input field.
 */
sablono.core.email_field52671 = (function sablono$core$email_field52671(var_args){
var args52672 = [];
var len__10640__auto___52739 = arguments.length;
var i__10641__auto___52740 = (0);
while(true){
if((i__10641__auto___52740 < len__10640__auto___52739)){
args52672.push((arguments[i__10641__auto___52740]));

var G__52741 = (i__10641__auto___52740 + (1));
i__10641__auto___52740 = G__52741;
continue;
} else {
}
break;
}

var G__52674 = args52672.length;
switch (G__52674) {
case 1:
return sablono.core.email_field52671.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field52671.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52672.length)].join('')));

}
});

sablono.core.email_field52671.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.email_field52671.call(null,name__30813__auto__,null);
});

sablono.core.email_field52671.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.email_field52671.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field52671);

/**
 * Creates a file input field.
 */
sablono.core.file_field52675 = (function sablono$core$file_field52675(var_args){
var args52676 = [];
var len__10640__auto___52743 = arguments.length;
var i__10641__auto___52744 = (0);
while(true){
if((i__10641__auto___52744 < len__10640__auto___52743)){
args52676.push((arguments[i__10641__auto___52744]));

var G__52745 = (i__10641__auto___52744 + (1));
i__10641__auto___52744 = G__52745;
continue;
} else {
}
break;
}

var G__52678 = args52676.length;
switch (G__52678) {
case 1:
return sablono.core.file_field52675.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field52675.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52676.length)].join('')));

}
});

sablono.core.file_field52675.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.file_field52675.call(null,name__30813__auto__,null);
});

sablono.core.file_field52675.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.file_field52675.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field52675);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field52679 = (function sablono$core$hidden_field52679(var_args){
var args52680 = [];
var len__10640__auto___52747 = arguments.length;
var i__10641__auto___52748 = (0);
while(true){
if((i__10641__auto___52748 < len__10640__auto___52747)){
args52680.push((arguments[i__10641__auto___52748]));

var G__52749 = (i__10641__auto___52748 + (1));
i__10641__auto___52748 = G__52749;
continue;
} else {
}
break;
}

var G__52682 = args52680.length;
switch (G__52682) {
case 1:
return sablono.core.hidden_field52679.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field52679.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52680.length)].join('')));

}
});

sablono.core.hidden_field52679.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.hidden_field52679.call(null,name__30813__auto__,null);
});

sablono.core.hidden_field52679.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.hidden_field52679.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field52679);

/**
 * Creates a month input field.
 */
sablono.core.month_field52683 = (function sablono$core$month_field52683(var_args){
var args52684 = [];
var len__10640__auto___52751 = arguments.length;
var i__10641__auto___52752 = (0);
while(true){
if((i__10641__auto___52752 < len__10640__auto___52751)){
args52684.push((arguments[i__10641__auto___52752]));

var G__52753 = (i__10641__auto___52752 + (1));
i__10641__auto___52752 = G__52753;
continue;
} else {
}
break;
}

var G__52686 = args52684.length;
switch (G__52686) {
case 1:
return sablono.core.month_field52683.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field52683.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52684.length)].join('')));

}
});

sablono.core.month_field52683.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.month_field52683.call(null,name__30813__auto__,null);
});

sablono.core.month_field52683.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.month_field52683.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field52683);

/**
 * Creates a number input field.
 */
sablono.core.number_field52687 = (function sablono$core$number_field52687(var_args){
var args52688 = [];
var len__10640__auto___52755 = arguments.length;
var i__10641__auto___52756 = (0);
while(true){
if((i__10641__auto___52756 < len__10640__auto___52755)){
args52688.push((arguments[i__10641__auto___52756]));

var G__52757 = (i__10641__auto___52756 + (1));
i__10641__auto___52756 = G__52757;
continue;
} else {
}
break;
}

var G__52690 = args52688.length;
switch (G__52690) {
case 1:
return sablono.core.number_field52687.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field52687.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52688.length)].join('')));

}
});

sablono.core.number_field52687.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.number_field52687.call(null,name__30813__auto__,null);
});

sablono.core.number_field52687.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.number_field52687.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field52687);

/**
 * Creates a password input field.
 */
sablono.core.password_field52691 = (function sablono$core$password_field52691(var_args){
var args52692 = [];
var len__10640__auto___52759 = arguments.length;
var i__10641__auto___52760 = (0);
while(true){
if((i__10641__auto___52760 < len__10640__auto___52759)){
args52692.push((arguments[i__10641__auto___52760]));

var G__52761 = (i__10641__auto___52760 + (1));
i__10641__auto___52760 = G__52761;
continue;
} else {
}
break;
}

var G__52694 = args52692.length;
switch (G__52694) {
case 1:
return sablono.core.password_field52691.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field52691.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52692.length)].join('')));

}
});

sablono.core.password_field52691.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.password_field52691.call(null,name__30813__auto__,null);
});

sablono.core.password_field52691.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.password_field52691.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field52691);

/**
 * Creates a range input field.
 */
sablono.core.range_field52695 = (function sablono$core$range_field52695(var_args){
var args52696 = [];
var len__10640__auto___52763 = arguments.length;
var i__10641__auto___52764 = (0);
while(true){
if((i__10641__auto___52764 < len__10640__auto___52763)){
args52696.push((arguments[i__10641__auto___52764]));

var G__52765 = (i__10641__auto___52764 + (1));
i__10641__auto___52764 = G__52765;
continue;
} else {
}
break;
}

var G__52698 = args52696.length;
switch (G__52698) {
case 1:
return sablono.core.range_field52695.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field52695.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52696.length)].join('')));

}
});

sablono.core.range_field52695.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.range_field52695.call(null,name__30813__auto__,null);
});

sablono.core.range_field52695.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.range_field52695.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field52695);

/**
 * Creates a search input field.
 */
sablono.core.search_field52699 = (function sablono$core$search_field52699(var_args){
var args52700 = [];
var len__10640__auto___52767 = arguments.length;
var i__10641__auto___52768 = (0);
while(true){
if((i__10641__auto___52768 < len__10640__auto___52767)){
args52700.push((arguments[i__10641__auto___52768]));

var G__52769 = (i__10641__auto___52768 + (1));
i__10641__auto___52768 = G__52769;
continue;
} else {
}
break;
}

var G__52702 = args52700.length;
switch (G__52702) {
case 1:
return sablono.core.search_field52699.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field52699.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52700.length)].join('')));

}
});

sablono.core.search_field52699.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.search_field52699.call(null,name__30813__auto__,null);
});

sablono.core.search_field52699.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.search_field52699.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field52699);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field52703 = (function sablono$core$tel_field52703(var_args){
var args52704 = [];
var len__10640__auto___52771 = arguments.length;
var i__10641__auto___52772 = (0);
while(true){
if((i__10641__auto___52772 < len__10640__auto___52771)){
args52704.push((arguments[i__10641__auto___52772]));

var G__52773 = (i__10641__auto___52772 + (1));
i__10641__auto___52772 = G__52773;
continue;
} else {
}
break;
}

var G__52706 = args52704.length;
switch (G__52706) {
case 1:
return sablono.core.tel_field52703.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field52703.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52704.length)].join('')));

}
});

sablono.core.tel_field52703.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.tel_field52703.call(null,name__30813__auto__,null);
});

sablono.core.tel_field52703.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.tel_field52703.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field52703);

/**
 * Creates a text input field.
 */
sablono.core.text_field52707 = (function sablono$core$text_field52707(var_args){
var args52708 = [];
var len__10640__auto___52775 = arguments.length;
var i__10641__auto___52776 = (0);
while(true){
if((i__10641__auto___52776 < len__10640__auto___52775)){
args52708.push((arguments[i__10641__auto___52776]));

var G__52777 = (i__10641__auto___52776 + (1));
i__10641__auto___52776 = G__52777;
continue;
} else {
}
break;
}

var G__52710 = args52708.length;
switch (G__52710) {
case 1:
return sablono.core.text_field52707.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field52707.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52708.length)].join('')));

}
});

sablono.core.text_field52707.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.text_field52707.call(null,name__30813__auto__,null);
});

sablono.core.text_field52707.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.text_field52707.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field52707);

/**
 * Creates a time input field.
 */
sablono.core.time_field52711 = (function sablono$core$time_field52711(var_args){
var args52712 = [];
var len__10640__auto___52779 = arguments.length;
var i__10641__auto___52780 = (0);
while(true){
if((i__10641__auto___52780 < len__10640__auto___52779)){
args52712.push((arguments[i__10641__auto___52780]));

var G__52781 = (i__10641__auto___52780 + (1));
i__10641__auto___52780 = G__52781;
continue;
} else {
}
break;
}

var G__52714 = args52712.length;
switch (G__52714) {
case 1:
return sablono.core.time_field52711.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field52711.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52712.length)].join('')));

}
});

sablono.core.time_field52711.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.time_field52711.call(null,name__30813__auto__,null);
});

sablono.core.time_field52711.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.time_field52711.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field52711);

/**
 * Creates a url input field.
 */
sablono.core.url_field52715 = (function sablono$core$url_field52715(var_args){
var args52716 = [];
var len__10640__auto___52783 = arguments.length;
var i__10641__auto___52784 = (0);
while(true){
if((i__10641__auto___52784 < len__10640__auto___52783)){
args52716.push((arguments[i__10641__auto___52784]));

var G__52785 = (i__10641__auto___52784 + (1));
i__10641__auto___52784 = G__52785;
continue;
} else {
}
break;
}

var G__52718 = args52716.length;
switch (G__52718) {
case 1:
return sablono.core.url_field52715.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field52715.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52716.length)].join('')));

}
});

sablono.core.url_field52715.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.url_field52715.call(null,name__30813__auto__,null);
});

sablono.core.url_field52715.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.url_field52715.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field52715);

/**
 * Creates a week input field.
 */
sablono.core.week_field52719 = (function sablono$core$week_field52719(var_args){
var args52720 = [];
var len__10640__auto___52787 = arguments.length;
var i__10641__auto___52788 = (0);
while(true){
if((i__10641__auto___52788 < len__10640__auto___52787)){
args52720.push((arguments[i__10641__auto___52788]));

var G__52789 = (i__10641__auto___52788 + (1));
i__10641__auto___52788 = G__52789;
continue;
} else {
}
break;
}

var G__52722 = args52720.length;
switch (G__52722) {
case 1:
return sablono.core.week_field52719.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field52719.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52720.length)].join('')));

}
});

sablono.core.week_field52719.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.week_field52719.call(null,name__30813__auto__,null);
});

sablono.core.week_field52719.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.week_field52719.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field52719);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box52791 = (function sablono$core$check_box52791(var_args){
var args52792 = [];
var len__10640__auto___52795 = arguments.length;
var i__10641__auto___52796 = (0);
while(true){
if((i__10641__auto___52796 < len__10640__auto___52795)){
args52792.push((arguments[i__10641__auto___52796]));

var G__52797 = (i__10641__auto___52796 + (1));
i__10641__auto___52796 = G__52797;
continue;
} else {
}
break;
}

var G__52794 = args52792.length;
switch (G__52794) {
case 1:
return sablono.core.check_box52791.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box52791.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box52791.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52792.length)].join('')));

}
});

sablono.core.check_box52791.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box52791.call(null,name,null);
});

sablono.core.check_box52791.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box52791.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box52791.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box52791.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box52791);
/**
 * Creates a radio button.
 */
sablono.core.radio_button52799 = (function sablono$core$radio_button52799(var_args){
var args52800 = [];
var len__10640__auto___52803 = arguments.length;
var i__10641__auto___52804 = (0);
while(true){
if((i__10641__auto___52804 < len__10640__auto___52803)){
args52800.push((arguments[i__10641__auto___52804]));

var G__52805 = (i__10641__auto___52804 + (1));
i__10641__auto___52804 = G__52805;
continue;
} else {
}
break;
}

var G__52802 = args52800.length;
switch (G__52802) {
case 1:
return sablono.core.radio_button52799.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button52799.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button52799.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52800.length)].join('')));

}
});

sablono.core.radio_button52799.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button52799.call(null,group,null);
});

sablono.core.radio_button52799.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button52799.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button52799.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button52799.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button52799);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options52807 = (function sablono$core$select_options52807(coll){
var iter__10281__auto__ = (function sablono$core$select_options52807_$_iter__52824(s__52825){
return (new cljs.core.LazySeq(null,(function (){
var s__52825__$1 = s__52825;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__52825__$1);
if(temp__6738__auto__){
var s__52825__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__52825__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__52825__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__52827 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__52826 = (0);
while(true){
if((i__52826 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__52826);
cljs.core.chunk_append.call(null,b__52827,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__52834 = x;
var text = cljs.core.nth.call(null,vec__52834,(0),null);
var val = cljs.core.nth.call(null,vec__52834,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__52834,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options52807.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__52840 = (i__52826 + (1));
i__52826 = G__52840;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52827),sablono$core$select_options52807_$_iter__52824.call(null,cljs.core.chunk_rest.call(null,s__52825__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__52827),null);
}
} else {
var x = cljs.core.first.call(null,s__52825__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__52837 = x;
var text = cljs.core.nth.call(null,vec__52837,(0),null);
var val = cljs.core.nth.call(null,vec__52837,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__52837,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options52807.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options52807_$_iter__52824.call(null,cljs.core.rest.call(null,s__52825__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options52807);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down52841 = (function sablono$core$drop_down52841(var_args){
var args52842 = [];
var len__10640__auto___52845 = arguments.length;
var i__10641__auto___52846 = (0);
while(true){
if((i__10641__auto___52846 < len__10640__auto___52845)){
args52842.push((arguments[i__10641__auto___52846]));

var G__52847 = (i__10641__auto___52846 + (1));
i__10641__auto___52846 = G__52847;
continue;
} else {
}
break;
}

var G__52844 = args52842.length;
switch (G__52844) {
case 2:
return sablono.core.drop_down52841.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down52841.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52842.length)].join('')));

}
});

sablono.core.drop_down52841.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down52841.call(null,name,options,null);
});

sablono.core.drop_down52841.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down52841.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down52841);
/**
 * Creates a text area element.
 */
sablono.core.text_area52849 = (function sablono$core$text_area52849(var_args){
var args52850 = [];
var len__10640__auto___52853 = arguments.length;
var i__10641__auto___52854 = (0);
while(true){
if((i__10641__auto___52854 < len__10640__auto___52853)){
args52850.push((arguments[i__10641__auto___52854]));

var G__52855 = (i__10641__auto___52854 + (1));
i__10641__auto___52854 = G__52855;
continue;
} else {
}
break;
}

var G__52852 = args52850.length;
switch (G__52852) {
case 1:
return sablono.core.text_area52849.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area52849.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args52850.length)].join('')));

}
});

sablono.core.text_area52849.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area52849.call(null,name,null);
});

sablono.core.text_area52849.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area52849.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area52849);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label52857 = (function sablono$core$label52857(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label52857);
/**
 * Creates a submit button.
 */
sablono.core.submit_button52858 = (function sablono$core$submit_button52858(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button52858);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button52859 = (function sablono$core$reset_button52859(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button52859);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to52860 = (function sablono$core$form_to52860(var_args){
var args__10647__auto__ = [];
var len__10640__auto___52867 = arguments.length;
var i__10641__auto___52868 = (0);
while(true){
if((i__10641__auto___52868 < len__10640__auto___52867)){
args__10647__auto__.push((arguments[i__10641__auto___52868]));

var G__52869 = (i__10641__auto___52868 + (1));
i__10641__auto___52868 = G__52869;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to52860.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.form_to52860.cljs$core$IFn$_invoke$arity$variadic = (function (p__52863,body){
var vec__52864 = p__52863;
var method = cljs.core.nth.call(null,vec__52864,(0),null);
var action = cljs.core.nth.call(null,vec__52864,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to52860.cljs$lang$maxFixedArity = (1);

sablono.core.form_to52860.cljs$lang$applyTo = (function (seq52861){
var G__52862 = cljs.core.first.call(null,seq52861);
var seq52861__$1 = cljs.core.next.call(null,seq52861);
return sablono.core.form_to52860.cljs$core$IFn$_invoke$arity$variadic(G__52862,seq52861__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to52860);

//# sourceMappingURL=core.js.map