// Compiled by ClojureScript 1.9.521 {}
goog.provide('konserve.memory');
goog.require('cljs.core');
goog.require('konserve.protocols');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {konserve.protocols.PEDNAsyncKeyValueStore}
 * @implements {konserve.protocols.PBinaryAsyncKeyValueStore}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
konserve.memory.MemAsyncKeyValueStore = (function (state,read_handlers,write_handlers,locks,__meta,__extmap,__hash){
this.state = state;
this.read_handlers = read_handlers;
this.write_handlers = write_handlers;
this.locks = locks;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__10094__auto__,k__10095__auto__){
var self__ = this;
var this__10094__auto____$1 = this;
return this__10094__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__10095__auto__,null);
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__10096__auto__,k66760,else__10097__auto__){
var self__ = this;
var this__10096__auto____$1 = this;
var G__66762 = (((k66760 instanceof cljs.core.Keyword))?k66760.fqn:null);
switch (G__66762) {
case "state":
return self__.state;

break;
case "read-handlers":
return self__.read_handlers;

break;
case "write-handlers":
return self__.write_handlers;

break;
case "locks":
return self__.locks;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k66760,else__10097__auto__);

}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__10108__auto__,writer__10109__auto__,opts__10110__auto__){
var self__ = this;
var this__10108__auto____$1 = this;
var pr_pair__10111__auto__ = ((function (this__10108__auto____$1){
return (function (keyval__10112__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,cljs.core.pr_writer,""," ","",opts__10110__auto__,keyval__10112__auto__);
});})(this__10108__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__10109__auto__,pr_pair__10111__auto__,"#konserve.memory.MemAsyncKeyValueStore{",", ","}",opts__10110__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__66759){
var self__ = this;
var G__66759__$1 = this;
return (new cljs.core.RecordIter((0),G__66759__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__10092__auto__){
var self__ = this;
var this__10092__auto____$1 = this;
return self__.__meta;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__10088__auto__){
var self__ = this;
var this__10088__auto____$1 = this;
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,self__.__hash));
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_exists_QMARK_$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_66770){
var state_val_66771 = (state_66770[(1)]);
if((state_val_66771 === (1))){
var inst_66763 = cljs.core.deref.call(null,self__.state);
var inst_66764 = inst_66763.call(null,key);
var state_66770__$1 = state_66770;
if(cljs.core.truth_(inst_66764)){
var statearr_66772_66856 = state_66770__$1;
(statearr_66772_66856[(1)] = (2));

} else {
var statearr_66773_66857 = state_66770__$1;
(statearr_66773_66857[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66771 === (2))){
var state_66770__$1 = state_66770;
var statearr_66774_66858 = state_66770__$1;
(statearr_66774_66858[(2)] = true);

(statearr_66774_66858[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66771 === (3))){
var state_66770__$1 = state_66770;
var statearr_66775_66859 = state_66770__$1;
(statearr_66775_66859[(2)] = false);

(statearr_66775_66859[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66771 === (4))){
var inst_66768 = (state_66770[(2)]);
var state_66770__$1 = state_66770;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66770__$1,inst_66768);
} else {
return null;
}
}
}
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_66779 = [null,null,null,null,null,null,null];
(statearr_66779[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_66779[(1)] = (1));

return statearr_66779;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_66770){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_66770);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e66780){if((e66780 instanceof Object)){
var ex__38347__auto__ = e66780;
var statearr_66781_66860 = state_66770;
(statearr_66781_66860[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66770);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66780;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66861 = state_66770;
state_66770 = G__66861;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_66770){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_66770);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_66782 = f__38458__auto__.call(null);
(statearr_66782[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_66782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_get_in$arity$2 = (function (this$,key_vec){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_66786){
var state_val_66787 = (state_66786[(1)]);
if((state_val_66787 === (1))){
var inst_66783 = cljs.core.deref.call(null,self__.state);
var inst_66784 = cljs.core.get_in.call(null,inst_66783,key_vec);
var state_66786__$1 = state_66786;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66786__$1,inst_66784);
} else {
return null;
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_66791 = [null,null,null,null,null,null,null];
(statearr_66791[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_66791[(1)] = (1));

return statearr_66791;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_66786){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_66786);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e66792){if((e66792 instanceof Object)){
var ex__38347__auto__ = e66792;
var statearr_66793_66862 = state_66786;
(statearr_66793_66862[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66786);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66792;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66863 = state_66786;
state_66786 = G__66863;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_66786){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_66786);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_66794 = f__38458__auto__.call(null);
(statearr_66794[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_66794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_update_in$arity$3 = (function (this$,key_vec,up_fn){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_66803){
var state_val_66804 = (state_66803[(1)]);
if((state_val_66804 === (1))){
var inst_66795 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66796 = cljs.core.deref.call(null,self__.state);
var inst_66797 = cljs.core.get_in.call(null,inst_66796,key_vec);
var inst_66798 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.update_in,key_vec,up_fn);
var inst_66799 = cljs.core.get_in.call(null,inst_66798,key_vec);
var inst_66800 = [inst_66797,inst_66799];
var inst_66801 = (new cljs.core.PersistentVector(null,2,(5),inst_66795,inst_66800,null));
var state_66803__$1 = state_66803;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66803__$1,inst_66801);
} else {
return null;
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_66808 = [null,null,null,null,null,null,null];
(statearr_66808[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_66808[(1)] = (1));

return statearr_66808;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_66803){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_66803);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e66809){if((e66809 instanceof Object)){
var ex__38347__auto__ = e66809;
var statearr_66810_66864 = state_66803;
(statearr_66810_66864[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66803);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66809;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66865 = state_66803;
state_66803 = G__66865;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_66803){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_66803);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_66811 = f__38458__auto__.call(null);
(statearr_66811[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_66811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_assoc_in$arity$3 = (function (this$,key_vec,val){
var self__ = this;
var this$__$1 = this;
return this$__$1.konserve$protocols$PEDNAsyncKeyValueStore$_update_in$arity$3(null,key_vec,((function (this$__$1){
return (function (_){
return val;
});})(this$__$1))
);
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PEDNAsyncKeyValueStore$_dissoc$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_66814){
var state_val_66815 = (state_66814[(1)]);
if((state_val_66815 === (1))){
var inst_66812 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.dissoc,key);
var state_66814__$1 = (function (){var statearr_66816 = state_66814;
(statearr_66816[(7)] = inst_66812);

return statearr_66816;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66814__$1,null);
} else {
return null;
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_66820 = [null,null,null,null,null,null,null,null];
(statearr_66820[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_66820[(1)] = (1));

return statearr_66820;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_66814){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_66814);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e66821){if((e66821 instanceof Object)){
var ex__38347__auto__ = e66821;
var statearr_66822_66866 = state_66814;
(statearr_66822_66866[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66814);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66821;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66867 = state_66814;
state_66814 = G__66867;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_66814){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_66814);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_66823 = f__38458__auto__.call(null);
(statearr_66823[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_66823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__10098__auto__){
var self__ = this;
var this__10098__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$ = cljs.core.PROTOCOL_SENTINEL;

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bget$arity$3 = (function (this$,key,locked_cb){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_66828){
var state_val_66829 = (state_66828[(1)]);
if((state_val_66829 === (1))){
var inst_66824 = cljs.core.deref.call(null,self__.state);
var inst_66825 = cljs.core.get.call(null,inst_66824,key);
var inst_66826 = locked_cb.call(null,inst_66825);
var state_66828__$1 = state_66828;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66828__$1,inst_66826);
} else {
return null;
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_66833 = [null,null,null,null,null,null,null];
(statearr_66833[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_66833[(1)] = (1));

return statearr_66833;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_66828){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_66828);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e66834){if((e66834 instanceof Object)){
var ex__38347__auto__ = e66834;
var statearr_66835_66868 = state_66828;
(statearr_66835_66868[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66828);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66834;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66869 = state_66828;
state_66828 = G__66869;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_66828){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_66828);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_66836 = f__38458__auto__.call(null);
(statearr_66836[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_66836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.konserve$protocols$PBinaryAsyncKeyValueStore$_bassoc$arity$3 = (function (this$,key,input){
var self__ = this;
var this$__$1 = this;
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,this$__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,this$__$1){
return (function (state_66842){
var state_val_66843 = (state_66842[(1)]);
if((state_val_66843 === (1))){
var inst_66837 = [new cljs.core.Keyword(null,"input-stream","input-stream",-179909472),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_66838 = [input,new cljs.core.Keyword(null,"unknown","unknown",-935977881)];
var inst_66839 = cljs.core.PersistentHashMap.fromArrays(inst_66837,inst_66838);
var inst_66840 = cljs.core.swap_BANG_.call(null,self__.state,cljs.core.assoc,key,inst_66839);
var state_66842__$1 = (function (){var statearr_66844 = state_66842;
(statearr_66844[(7)] = inst_66840);

return statearr_66844;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66842__$1,null);
} else {
return null;
}
});})(c__38457__auto__,this$__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,this$__$1){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_66848 = [null,null,null,null,null,null,null,null];
(statearr_66848[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_66848[(1)] = (1));

return statearr_66848;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_66842){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_66842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e66849){if((e66849 instanceof Object)){
var ex__38347__auto__ = e66849;
var statearr_66850_66870 = state_66842;
(statearr_66850_66870[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66842);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66849;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66871 = state_66842;
state_66842 = G__66871;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_66842){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_66842);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,this$__$1))
})();
var state__38459__auto__ = (function (){var statearr_66851 = f__38458__auto__.call(null);
(statearr_66851[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_66851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,this$__$1))
);

return c__38457__auto__;
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__10089__auto__){
var self__ = this;
var this__10089__auto____$1 = this;
var h__9861__auto__ = self__.__hash;
if(!((h__9861__auto__ == null))){
return h__9861__auto__;
} else {
var h__9861__auto____$1 = cljs.core.hash_imap.call(null,this__10089__auto____$1);
self__.__hash = h__9861__auto____$1;

return h__9861__auto____$1;
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__10090__auto__,other__10091__auto__){
var self__ = this;
var this__10090__auto____$1 = this;
if(cljs.core.truth_((function (){var and__9407__auto__ = other__10091__auto__;
if(cljs.core.truth_(and__9407__auto__)){
return ((this__10090__auto____$1.constructor === other__10091__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__10090__auto____$1,other__10091__auto__));
} else {
return and__9407__auto__;
}
})())){
return true;
} else {
return false;
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__10103__auto__,k__10104__auto__){
var self__ = this;
var this__10103__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"locks","locks",1560476518),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),null], null), null),k__10104__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__10103__auto____$1),self__.__meta),k__10104__auto__);
} else {
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__10104__auto__)),null));
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__10101__auto__,k__10102__auto__,G__66759){
var self__ = this;
var this__10101__auto____$1 = this;
var pred__66852 = cljs.core.keyword_identical_QMARK_;
var expr__66853 = k__10102__auto__;
if(cljs.core.truth_(pred__66852.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__66853))){
return (new konserve.memory.MemAsyncKeyValueStore(G__66759,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__66852.call(null,new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),expr__66853))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,G__66759,self__.write_handlers,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__66852.call(null,new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),expr__66853))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,G__66759,self__.locks,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__66852.call(null,new cljs.core.Keyword(null,"locks","locks",1560476518),expr__66853))){
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,G__66759,self__.__meta,self__.__extmap,null));
} else {
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__10102__auto__,G__66759),null));
}
}
}
}
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__10106__auto__){
var self__ = this;
var this__10106__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),self__.read_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),self__.write_handlers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locks","locks",1560476518),self__.locks],null))], null),self__.__extmap));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__10093__auto__,G__66759){
var self__ = this;
var this__10093__auto____$1 = this;
return (new konserve.memory.MemAsyncKeyValueStore(self__.state,self__.read_handlers,self__.write_handlers,self__.locks,G__66759,self__.__extmap,self__.__hash));
});

konserve.memory.MemAsyncKeyValueStore.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__10099__auto__,entry__10100__auto__){
var self__ = this;
var this__10099__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__10100__auto__)){
return this__10099__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__10100__auto__,(0)),cljs.core._nth.call(null,entry__10100__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__10099__auto____$1,entry__10100__auto__);
}
});

konserve.memory.MemAsyncKeyValueStore.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"read-handlers","read-handlers",-544976454,null),new cljs.core.Symbol(null,"write-handlers","write-handlers",-456757384,null),new cljs.core.Symbol(null,"locks","locks",-1093959251,null)], null);
});

konserve.memory.MemAsyncKeyValueStore.cljs$lang$type = true;

konserve.memory.MemAsyncKeyValueStore.cljs$lang$ctorPrSeq = (function (this__10130__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"konserve.memory/MemAsyncKeyValueStore");
});

konserve.memory.MemAsyncKeyValueStore.cljs$lang$ctorPrWriter = (function (this__10130__auto__,writer__10131__auto__){
return cljs.core._write.call(null,writer__10131__auto__,"konserve.memory/MemAsyncKeyValueStore");
});

konserve.memory.__GT_MemAsyncKeyValueStore = (function konserve$memory$__GT_MemAsyncKeyValueStore(state,read_handlers,write_handlers,locks){
return (new konserve.memory.MemAsyncKeyValueStore(state,read_handlers,write_handlers,locks,null,null,null));
});

konserve.memory.map__GT_MemAsyncKeyValueStore = (function konserve$memory$map__GT_MemAsyncKeyValueStore(G__66761){
return (new konserve.memory.MemAsyncKeyValueStore(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__66761),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315).cljs$core$IFn$_invoke$arity$1(G__66761),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911).cljs$core$IFn$_invoke$arity$1(G__66761),new cljs.core.Keyword(null,"locks","locks",1560476518).cljs$core$IFn$_invoke$arity$1(G__66761),null,cljs.core.dissoc.call(null,G__66761,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)),null));
});

/**
 * Create in memory store. Binaries are not properly locked yet and
 *   the read and write-handlers are dummy ones for compatibility.
 */
konserve.memory.new_mem_store = (function konserve$memory$new_mem_store(var_args){
var args66872 = [];
var len__10640__auto___66895 = arguments.length;
var i__10641__auto___66896 = (0);
while(true){
if((i__10641__auto___66896 < len__10640__auto___66895)){
args66872.push((arguments[i__10641__auto___66896]));

var G__66897 = (i__10641__auto___66896 + (1));
i__10641__auto___66896 = G__66897;
continue;
} else {
}
break;
}

var G__66874 = args66872.length;
switch (G__66874) {
case 0:
return konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args66872.length)].join('')));

}
});

konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$0 = (function (){
return konserve.memory.new_mem_store.call(null,cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
});

konserve.memory.new_mem_store.cljs$core$IFn$_invoke$arity$1 = (function (init_atom){
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__){
return (function (state_66886){
var state_val_66887 = (state_66886[(1)]);
if((state_val_66887 === (1))){
var inst_66875 = [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"read-handlers","read-handlers",2109459315),new cljs.core.Keyword(null,"write-handlers","write-handlers",-2097288911),new cljs.core.Keyword(null,"locks","locks",1560476518)];
var inst_66876 = cljs.core.PersistentHashMap.EMPTY;
var inst_66877 = cljs.core.atom.call(null,inst_66876);
var inst_66878 = cljs.core.PersistentHashMap.EMPTY;
var inst_66879 = cljs.core.atom.call(null,inst_66878);
var inst_66880 = cljs.core.PersistentHashMap.EMPTY;
var inst_66881 = cljs.core.atom.call(null,inst_66880);
var inst_66882 = [init_atom,inst_66877,inst_66879,inst_66881];
var inst_66883 = cljs.core.PersistentHashMap.fromArrays(inst_66875,inst_66882);
var inst_66884 = konserve.memory.map__GT_MemAsyncKeyValueStore.call(null,inst_66883);
var state_66886__$1 = state_66886;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66886__$1,inst_66884);
} else {
return null;
}
});})(c__38457__auto__))
;
return ((function (switch__38343__auto__,c__38457__auto__){
return (function() {
var konserve$memory$state_machine__38344__auto__ = null;
var konserve$memory$state_machine__38344__auto____0 = (function (){
var statearr_66891 = [null,null,null,null,null,null,null];
(statearr_66891[(0)] = konserve$memory$state_machine__38344__auto__);

(statearr_66891[(1)] = (1));

return statearr_66891;
});
var konserve$memory$state_machine__38344__auto____1 = (function (state_66886){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_66886);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e66892){if((e66892 instanceof Object)){
var ex__38347__auto__ = e66892;
var statearr_66893_66899 = state_66886;
(statearr_66893_66899[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_66886);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e66892;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66900 = state_66886;
state_66886 = G__66900;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
konserve$memory$state_machine__38344__auto__ = function(state_66886){
switch(arguments.length){
case 0:
return konserve$memory$state_machine__38344__auto____0.call(this);
case 1:
return konserve$memory$state_machine__38344__auto____1.call(this,state_66886);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = konserve$memory$state_machine__38344__auto____0;
konserve$memory$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = konserve$memory$state_machine__38344__auto____1;
return konserve$memory$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__))
})();
var state__38459__auto__ = (function (){var statearr_66894 = f__38458__auto__.call(null);
(statearr_66894[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_66894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__))
);

return c__38457__auto__;
});

konserve.memory.new_mem_store.cljs$lang$maxFixedArity = 1;


//# sourceMappingURL=memory.js.map