(ns budb.cljs.test-helpers
  (:require
    [budb.test-env :refer [firebase-config]]
    [cljsjs.firebase]
    [goog.string :as gstring]))

(defn now [] (.getTime (js/Date.)))

(defn make-db []
  ((.. js/firebase -database)))

(defn start-firebase! []
  (.initializeApp js/firebase
                  (clj->js firebase-config)))

(defn stop-firebase! [app then]
  (.then (.delete app)
         then))
