// Compiled by ClojureScript 1.9.521 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__70780__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__70777 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__70778 = cljs.core.seq.call(null,vec__70777);
var first__70779 = cljs.core.first.call(null,seq__70778);
var seq__70778__$1 = cljs.core.next.call(null,seq__70778);
var tag = first__70779;
var body = seq__70778__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__70780 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__70781__i = 0, G__70781__a = new Array(arguments.length -  0);
while (G__70781__i < G__70781__a.length) {G__70781__a[G__70781__i] = arguments[G__70781__i + 0]; ++G__70781__i;}
  args = new cljs.core.IndexedSeq(G__70781__a,0);
} 
return G__70780__delegate.call(this,args);};
G__70780.cljs$lang$maxFixedArity = 0;
G__70780.cljs$lang$applyTo = (function (arglist__70782){
var args = cljs.core.seq(arglist__70782);
return G__70780__delegate(args);
});
G__70780.cljs$core$IFn$_invoke$arity$variadic = G__70780__delegate;
return G__70780;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__10281__auto__ = (function sablono$core$update_arglists_$_iter__70787(s__70788){
return (new cljs.core.LazySeq(null,(function (){
var s__70788__$1 = s__70788;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__70788__$1);
if(temp__6738__auto__){
var s__70788__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__70788__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__70788__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__70790 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__70789 = (0);
while(true){
if((i__70789 < size__10280__auto__)){
var args = cljs.core._nth.call(null,c__10279__auto__,i__70789);
cljs.core.chunk_append.call(null,b__70790,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__70791 = (i__70789 + (1));
i__70789 = G__70791;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70790),sablono$core$update_arglists_$_iter__70787.call(null,cljs.core.chunk_rest.call(null,s__70788__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70790),null);
}
} else {
var args = cljs.core.first.call(null,s__70788__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__70787.call(null,cljs.core.rest.call(null,s__70788__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__10647__auto__ = [];
var len__10640__auto___70797 = arguments.length;
var i__10641__auto___70798 = (0);
while(true){
if((i__10641__auto___70798 < len__10640__auto___70797)){
args__10647__auto__.push((arguments[i__10641__auto___70798]));

var G__70799 = (i__10641__auto___70798 + (1));
i__10641__auto___70798 = G__70799;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((0) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__10648__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__10281__auto__ = (function sablono$core$iter__70793(s__70794){
return (new cljs.core.LazySeq(null,(function (){
var s__70794__$1 = s__70794;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__70794__$1);
if(temp__6738__auto__){
var s__70794__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__70794__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__70794__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__70796 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__70795 = (0);
while(true){
if((i__70795 < size__10280__auto__)){
var style = cljs.core._nth.call(null,c__10279__auto__,i__70795);
cljs.core.chunk_append.call(null,b__70796,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__70800 = (i__70795 + (1));
i__70795 = G__70800;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70796),sablono$core$iter__70793.call(null,cljs.core.chunk_rest.call(null,s__70794__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70796),null);
}
} else {
var style = cljs.core.first.call(null,s__70794__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__70793.call(null,cljs.core.rest.call(null,s__70794__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq70792){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq70792));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to70801 = (function sablono$core$link_to70801(var_args){
var args__10647__auto__ = [];
var len__10640__auto___70804 = arguments.length;
var i__10641__auto___70805 = (0);
while(true){
if((i__10641__auto___70805 < len__10640__auto___70804)){
args__10647__auto__.push((arguments[i__10641__auto___70805]));

var G__70806 = (i__10641__auto___70805 + (1));
i__10641__auto___70805 = G__70806;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to70801.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.link_to70801.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to70801.cljs$lang$maxFixedArity = (1);

sablono.core.link_to70801.cljs$lang$applyTo = (function (seq70802){
var G__70803 = cljs.core.first.call(null,seq70802);
var seq70802__$1 = cljs.core.next.call(null,seq70802);
return sablono.core.link_to70801.cljs$core$IFn$_invoke$arity$variadic(G__70803,seq70802__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to70801);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to70807 = (function sablono$core$mail_to70807(var_args){
var args__10647__auto__ = [];
var len__10640__auto___70814 = arguments.length;
var i__10641__auto___70815 = (0);
while(true){
if((i__10641__auto___70815 < len__10640__auto___70814)){
args__10647__auto__.push((arguments[i__10641__auto___70815]));

var G__70816 = (i__10641__auto___70815 + (1));
i__10641__auto___70815 = G__70816;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to70807.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.mail_to70807.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__70810){
var vec__70811 = p__70810;
var content = cljs.core.nth.call(null,vec__70811,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("mailto:"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__9419__auto__ = content;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to70807.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to70807.cljs$lang$applyTo = (function (seq70808){
var G__70809 = cljs.core.first.call(null,seq70808);
var seq70808__$1 = cljs.core.next.call(null,seq70808);
return sablono.core.mail_to70807.cljs$core$IFn$_invoke$arity$variadic(G__70809,seq70808__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to70807);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list70817 = (function sablono$core$unordered_list70817(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__10281__auto__ = (function sablono$core$unordered_list70817_$_iter__70822(s__70823){
return (new cljs.core.LazySeq(null,(function (){
var s__70823__$1 = s__70823;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__70823__$1);
if(temp__6738__auto__){
var s__70823__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__70823__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__70823__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__70825 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__70824 = (0);
while(true){
if((i__70824 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__70824);
cljs.core.chunk_append.call(null,b__70825,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__70826 = (i__70824 + (1));
i__70824 = G__70826;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70825),sablono$core$unordered_list70817_$_iter__70822.call(null,cljs.core.chunk_rest.call(null,s__70823__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70825),null);
}
} else {
var x = cljs.core.first.call(null,s__70823__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list70817_$_iter__70822.call(null,cljs.core.rest.call(null,s__70823__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list70817);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list70827 = (function sablono$core$ordered_list70827(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__10281__auto__ = (function sablono$core$ordered_list70827_$_iter__70832(s__70833){
return (new cljs.core.LazySeq(null,(function (){
var s__70833__$1 = s__70833;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__70833__$1);
if(temp__6738__auto__){
var s__70833__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__70833__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__70833__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__70835 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__70834 = (0);
while(true){
if((i__70834 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__70834);
cljs.core.chunk_append.call(null,b__70835,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__70836 = (i__70834 + (1));
i__70834 = G__70836;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70835),sablono$core$ordered_list70827_$_iter__70832.call(null,cljs.core.chunk_rest.call(null,s__70833__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__70835),null);
}
} else {
var x = cljs.core.first.call(null,s__70833__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list70827_$_iter__70832.call(null,cljs.core.rest.call(null,s__70833__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list70827);
/**
 * Create an image element.
 */
sablono.core.image70837 = (function sablono$core$image70837(var_args){
var args70838 = [];
var len__10640__auto___70841 = arguments.length;
var i__10641__auto___70842 = (0);
while(true){
if((i__10641__auto___70842 < len__10640__auto___70841)){
args70838.push((arguments[i__10641__auto___70842]));

var G__70843 = (i__10641__auto___70842 + (1));
i__10641__auto___70842 = G__70843;
continue;
} else {
}
break;
}

var G__70840 = args70838.length;
switch (G__70840) {
case 1:
return sablono.core.image70837.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image70837.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70838.length)].join('')));

}
});

sablono.core.image70837.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image70837.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image70837.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image70837);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__70845_SHARP_,p2__70846_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__70845_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("["),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__70846_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__70847_SHARP_,p2__70848_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__70847_SHARP_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__70848_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field70849 = (function sablono$core$color_field70849(var_args){
var args70850 = [];
var len__10640__auto___70917 = arguments.length;
var i__10641__auto___70918 = (0);
while(true){
if((i__10641__auto___70918 < len__10640__auto___70917)){
args70850.push((arguments[i__10641__auto___70918]));

var G__70919 = (i__10641__auto___70918 + (1));
i__10641__auto___70918 = G__70919;
continue;
} else {
}
break;
}

var G__70852 = args70850.length;
switch (G__70852) {
case 1:
return sablono.core.color_field70849.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field70849.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70850.length)].join('')));

}
});

sablono.core.color_field70849.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.color_field70849.call(null,name__30813__auto__,null);
});

sablono.core.color_field70849.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.color_field70849.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field70849);

/**
 * Creates a date input field.
 */
sablono.core.date_field70853 = (function sablono$core$date_field70853(var_args){
var args70854 = [];
var len__10640__auto___70921 = arguments.length;
var i__10641__auto___70922 = (0);
while(true){
if((i__10641__auto___70922 < len__10640__auto___70921)){
args70854.push((arguments[i__10641__auto___70922]));

var G__70923 = (i__10641__auto___70922 + (1));
i__10641__auto___70922 = G__70923;
continue;
} else {
}
break;
}

var G__70856 = args70854.length;
switch (G__70856) {
case 1:
return sablono.core.date_field70853.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field70853.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70854.length)].join('')));

}
});

sablono.core.date_field70853.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.date_field70853.call(null,name__30813__auto__,null);
});

sablono.core.date_field70853.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.date_field70853.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field70853);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field70857 = (function sablono$core$datetime_field70857(var_args){
var args70858 = [];
var len__10640__auto___70925 = arguments.length;
var i__10641__auto___70926 = (0);
while(true){
if((i__10641__auto___70926 < len__10640__auto___70925)){
args70858.push((arguments[i__10641__auto___70926]));

var G__70927 = (i__10641__auto___70926 + (1));
i__10641__auto___70926 = G__70927;
continue;
} else {
}
break;
}

var G__70860 = args70858.length;
switch (G__70860) {
case 1:
return sablono.core.datetime_field70857.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field70857.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70858.length)].join('')));

}
});

sablono.core.datetime_field70857.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.datetime_field70857.call(null,name__30813__auto__,null);
});

sablono.core.datetime_field70857.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.datetime_field70857.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field70857);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field70861 = (function sablono$core$datetime_local_field70861(var_args){
var args70862 = [];
var len__10640__auto___70929 = arguments.length;
var i__10641__auto___70930 = (0);
while(true){
if((i__10641__auto___70930 < len__10640__auto___70929)){
args70862.push((arguments[i__10641__auto___70930]));

var G__70931 = (i__10641__auto___70930 + (1));
i__10641__auto___70930 = G__70931;
continue;
} else {
}
break;
}

var G__70864 = args70862.length;
switch (G__70864) {
case 1:
return sablono.core.datetime_local_field70861.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field70861.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70862.length)].join('')));

}
});

sablono.core.datetime_local_field70861.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.datetime_local_field70861.call(null,name__30813__auto__,null);
});

sablono.core.datetime_local_field70861.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.datetime_local_field70861.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field70861);

/**
 * Creates a email input field.
 */
sablono.core.email_field70865 = (function sablono$core$email_field70865(var_args){
var args70866 = [];
var len__10640__auto___70933 = arguments.length;
var i__10641__auto___70934 = (0);
while(true){
if((i__10641__auto___70934 < len__10640__auto___70933)){
args70866.push((arguments[i__10641__auto___70934]));

var G__70935 = (i__10641__auto___70934 + (1));
i__10641__auto___70934 = G__70935;
continue;
} else {
}
break;
}

var G__70868 = args70866.length;
switch (G__70868) {
case 1:
return sablono.core.email_field70865.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field70865.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70866.length)].join('')));

}
});

sablono.core.email_field70865.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.email_field70865.call(null,name__30813__auto__,null);
});

sablono.core.email_field70865.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.email_field70865.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field70865);

/**
 * Creates a file input field.
 */
sablono.core.file_field70869 = (function sablono$core$file_field70869(var_args){
var args70870 = [];
var len__10640__auto___70937 = arguments.length;
var i__10641__auto___70938 = (0);
while(true){
if((i__10641__auto___70938 < len__10640__auto___70937)){
args70870.push((arguments[i__10641__auto___70938]));

var G__70939 = (i__10641__auto___70938 + (1));
i__10641__auto___70938 = G__70939;
continue;
} else {
}
break;
}

var G__70872 = args70870.length;
switch (G__70872) {
case 1:
return sablono.core.file_field70869.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field70869.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70870.length)].join('')));

}
});

sablono.core.file_field70869.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.file_field70869.call(null,name__30813__auto__,null);
});

sablono.core.file_field70869.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.file_field70869.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field70869);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field70873 = (function sablono$core$hidden_field70873(var_args){
var args70874 = [];
var len__10640__auto___70941 = arguments.length;
var i__10641__auto___70942 = (0);
while(true){
if((i__10641__auto___70942 < len__10640__auto___70941)){
args70874.push((arguments[i__10641__auto___70942]));

var G__70943 = (i__10641__auto___70942 + (1));
i__10641__auto___70942 = G__70943;
continue;
} else {
}
break;
}

var G__70876 = args70874.length;
switch (G__70876) {
case 1:
return sablono.core.hidden_field70873.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field70873.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70874.length)].join('')));

}
});

sablono.core.hidden_field70873.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.hidden_field70873.call(null,name__30813__auto__,null);
});

sablono.core.hidden_field70873.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.hidden_field70873.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field70873);

/**
 * Creates a month input field.
 */
sablono.core.month_field70877 = (function sablono$core$month_field70877(var_args){
var args70878 = [];
var len__10640__auto___70945 = arguments.length;
var i__10641__auto___70946 = (0);
while(true){
if((i__10641__auto___70946 < len__10640__auto___70945)){
args70878.push((arguments[i__10641__auto___70946]));

var G__70947 = (i__10641__auto___70946 + (1));
i__10641__auto___70946 = G__70947;
continue;
} else {
}
break;
}

var G__70880 = args70878.length;
switch (G__70880) {
case 1:
return sablono.core.month_field70877.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field70877.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70878.length)].join('')));

}
});

sablono.core.month_field70877.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.month_field70877.call(null,name__30813__auto__,null);
});

sablono.core.month_field70877.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.month_field70877.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field70877);

/**
 * Creates a number input field.
 */
sablono.core.number_field70881 = (function sablono$core$number_field70881(var_args){
var args70882 = [];
var len__10640__auto___70949 = arguments.length;
var i__10641__auto___70950 = (0);
while(true){
if((i__10641__auto___70950 < len__10640__auto___70949)){
args70882.push((arguments[i__10641__auto___70950]));

var G__70951 = (i__10641__auto___70950 + (1));
i__10641__auto___70950 = G__70951;
continue;
} else {
}
break;
}

var G__70884 = args70882.length;
switch (G__70884) {
case 1:
return sablono.core.number_field70881.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field70881.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70882.length)].join('')));

}
});

sablono.core.number_field70881.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.number_field70881.call(null,name__30813__auto__,null);
});

sablono.core.number_field70881.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.number_field70881.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field70881);

/**
 * Creates a password input field.
 */
sablono.core.password_field70885 = (function sablono$core$password_field70885(var_args){
var args70886 = [];
var len__10640__auto___70953 = arguments.length;
var i__10641__auto___70954 = (0);
while(true){
if((i__10641__auto___70954 < len__10640__auto___70953)){
args70886.push((arguments[i__10641__auto___70954]));

var G__70955 = (i__10641__auto___70954 + (1));
i__10641__auto___70954 = G__70955;
continue;
} else {
}
break;
}

var G__70888 = args70886.length;
switch (G__70888) {
case 1:
return sablono.core.password_field70885.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field70885.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70886.length)].join('')));

}
});

sablono.core.password_field70885.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.password_field70885.call(null,name__30813__auto__,null);
});

sablono.core.password_field70885.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.password_field70885.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field70885);

/**
 * Creates a range input field.
 */
sablono.core.range_field70889 = (function sablono$core$range_field70889(var_args){
var args70890 = [];
var len__10640__auto___70957 = arguments.length;
var i__10641__auto___70958 = (0);
while(true){
if((i__10641__auto___70958 < len__10640__auto___70957)){
args70890.push((arguments[i__10641__auto___70958]));

var G__70959 = (i__10641__auto___70958 + (1));
i__10641__auto___70958 = G__70959;
continue;
} else {
}
break;
}

var G__70892 = args70890.length;
switch (G__70892) {
case 1:
return sablono.core.range_field70889.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field70889.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70890.length)].join('')));

}
});

sablono.core.range_field70889.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.range_field70889.call(null,name__30813__auto__,null);
});

sablono.core.range_field70889.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.range_field70889.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field70889);

/**
 * Creates a search input field.
 */
sablono.core.search_field70893 = (function sablono$core$search_field70893(var_args){
var args70894 = [];
var len__10640__auto___70961 = arguments.length;
var i__10641__auto___70962 = (0);
while(true){
if((i__10641__auto___70962 < len__10640__auto___70961)){
args70894.push((arguments[i__10641__auto___70962]));

var G__70963 = (i__10641__auto___70962 + (1));
i__10641__auto___70962 = G__70963;
continue;
} else {
}
break;
}

var G__70896 = args70894.length;
switch (G__70896) {
case 1:
return sablono.core.search_field70893.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field70893.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70894.length)].join('')));

}
});

sablono.core.search_field70893.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.search_field70893.call(null,name__30813__auto__,null);
});

sablono.core.search_field70893.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.search_field70893.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field70893);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field70897 = (function sablono$core$tel_field70897(var_args){
var args70898 = [];
var len__10640__auto___70965 = arguments.length;
var i__10641__auto___70966 = (0);
while(true){
if((i__10641__auto___70966 < len__10640__auto___70965)){
args70898.push((arguments[i__10641__auto___70966]));

var G__70967 = (i__10641__auto___70966 + (1));
i__10641__auto___70966 = G__70967;
continue;
} else {
}
break;
}

var G__70900 = args70898.length;
switch (G__70900) {
case 1:
return sablono.core.tel_field70897.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field70897.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70898.length)].join('')));

}
});

sablono.core.tel_field70897.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.tel_field70897.call(null,name__30813__auto__,null);
});

sablono.core.tel_field70897.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.tel_field70897.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field70897);

/**
 * Creates a text input field.
 */
sablono.core.text_field70901 = (function sablono$core$text_field70901(var_args){
var args70902 = [];
var len__10640__auto___70969 = arguments.length;
var i__10641__auto___70970 = (0);
while(true){
if((i__10641__auto___70970 < len__10640__auto___70969)){
args70902.push((arguments[i__10641__auto___70970]));

var G__70971 = (i__10641__auto___70970 + (1));
i__10641__auto___70970 = G__70971;
continue;
} else {
}
break;
}

var G__70904 = args70902.length;
switch (G__70904) {
case 1:
return sablono.core.text_field70901.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field70901.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70902.length)].join('')));

}
});

sablono.core.text_field70901.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.text_field70901.call(null,name__30813__auto__,null);
});

sablono.core.text_field70901.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.text_field70901.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field70901);

/**
 * Creates a time input field.
 */
sablono.core.time_field70905 = (function sablono$core$time_field70905(var_args){
var args70906 = [];
var len__10640__auto___70973 = arguments.length;
var i__10641__auto___70974 = (0);
while(true){
if((i__10641__auto___70974 < len__10640__auto___70973)){
args70906.push((arguments[i__10641__auto___70974]));

var G__70975 = (i__10641__auto___70974 + (1));
i__10641__auto___70974 = G__70975;
continue;
} else {
}
break;
}

var G__70908 = args70906.length;
switch (G__70908) {
case 1:
return sablono.core.time_field70905.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field70905.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70906.length)].join('')));

}
});

sablono.core.time_field70905.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.time_field70905.call(null,name__30813__auto__,null);
});

sablono.core.time_field70905.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.time_field70905.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field70905);

/**
 * Creates a url input field.
 */
sablono.core.url_field70909 = (function sablono$core$url_field70909(var_args){
var args70910 = [];
var len__10640__auto___70977 = arguments.length;
var i__10641__auto___70978 = (0);
while(true){
if((i__10641__auto___70978 < len__10640__auto___70977)){
args70910.push((arguments[i__10641__auto___70978]));

var G__70979 = (i__10641__auto___70978 + (1));
i__10641__auto___70978 = G__70979;
continue;
} else {
}
break;
}

var G__70912 = args70910.length;
switch (G__70912) {
case 1:
return sablono.core.url_field70909.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field70909.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70910.length)].join('')));

}
});

sablono.core.url_field70909.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.url_field70909.call(null,name__30813__auto__,null);
});

sablono.core.url_field70909.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.url_field70909.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field70909);

/**
 * Creates a week input field.
 */
sablono.core.week_field70913 = (function sablono$core$week_field70913(var_args){
var args70914 = [];
var len__10640__auto___70981 = arguments.length;
var i__10641__auto___70982 = (0);
while(true){
if((i__10641__auto___70982 < len__10640__auto___70981)){
args70914.push((arguments[i__10641__auto___70982]));

var G__70983 = (i__10641__auto___70982 + (1));
i__10641__auto___70982 = G__70983;
continue;
} else {
}
break;
}

var G__70916 = args70914.length;
switch (G__70916) {
case 1:
return sablono.core.week_field70913.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field70913.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70914.length)].join('')));

}
});

sablono.core.week_field70913.cljs$core$IFn$_invoke$arity$1 = (function (name__30813__auto__){
return sablono.core.week_field70913.call(null,name__30813__auto__,null);
});

sablono.core.week_field70913.cljs$core$IFn$_invoke$arity$2 = (function (name__30813__auto__,value__30814__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__30813__auto__,value__30814__auto__);
});

sablono.core.week_field70913.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field70913);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box70985 = (function sablono$core$check_box70985(var_args){
var args70986 = [];
var len__10640__auto___70989 = arguments.length;
var i__10641__auto___70990 = (0);
while(true){
if((i__10641__auto___70990 < len__10640__auto___70989)){
args70986.push((arguments[i__10641__auto___70990]));

var G__70991 = (i__10641__auto___70990 + (1));
i__10641__auto___70990 = G__70991;
continue;
} else {
}
break;
}

var G__70988 = args70986.length;
switch (G__70988) {
case 1:
return sablono.core.check_box70985.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box70985.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box70985.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70986.length)].join('')));

}
});

sablono.core.check_box70985.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box70985.call(null,name,null);
});

sablono.core.check_box70985.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box70985.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box70985.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box70985.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box70985);
/**
 * Creates a radio button.
 */
sablono.core.radio_button70993 = (function sablono$core$radio_button70993(var_args){
var args70994 = [];
var len__10640__auto___70997 = arguments.length;
var i__10641__auto___70998 = (0);
while(true){
if((i__10641__auto___70998 < len__10640__auto___70997)){
args70994.push((arguments[i__10641__auto___70998]));

var G__70999 = (i__10641__auto___70998 + (1));
i__10641__auto___70998 = G__70999;
continue;
} else {
}
break;
}

var G__70996 = args70994.length;
switch (G__70996) {
case 1:
return sablono.core.radio_button70993.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button70993.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button70993.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70994.length)].join('')));

}
});

sablono.core.radio_button70993.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button70993.call(null,group,null);
});

sablono.core.radio_button70993.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button70993.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button70993.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button70993.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button70993);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options71001 = (function sablono$core$select_options71001(coll){
var iter__10281__auto__ = (function sablono$core$select_options71001_$_iter__71018(s__71019){
return (new cljs.core.LazySeq(null,(function (){
var s__71019__$1 = s__71019;
while(true){
var temp__6738__auto__ = cljs.core.seq.call(null,s__71019__$1);
if(temp__6738__auto__){
var s__71019__$2 = temp__6738__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__71019__$2)){
var c__10279__auto__ = cljs.core.chunk_first.call(null,s__71019__$2);
var size__10280__auto__ = cljs.core.count.call(null,c__10279__auto__);
var b__71021 = cljs.core.chunk_buffer.call(null,size__10280__auto__);
if((function (){var i__71020 = (0);
while(true){
if((i__71020 < size__10280__auto__)){
var x = cljs.core._nth.call(null,c__10279__auto__,i__71020);
cljs.core.chunk_append.call(null,b__71021,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__71028 = x;
var text = cljs.core.nth.call(null,vec__71028,(0),null);
var val = cljs.core.nth.call(null,vec__71028,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__71028,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options71001.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__71034 = (i__71020 + (1));
i__71020 = G__71034;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__71021),sablono$core$select_options71001_$_iter__71018.call(null,cljs.core.chunk_rest.call(null,s__71019__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__71021),null);
}
} else {
var x = cljs.core.first.call(null,s__71019__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__71031 = x;
var text = cljs.core.nth.call(null,vec__71031,(0),null);
var val = cljs.core.nth.call(null,vec__71031,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__71031,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options71001.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options71001_$_iter__71018.call(null,cljs.core.rest.call(null,s__71019__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__10281__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options71001);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down71035 = (function sablono$core$drop_down71035(var_args){
var args71036 = [];
var len__10640__auto___71039 = arguments.length;
var i__10641__auto___71040 = (0);
while(true){
if((i__10641__auto___71040 < len__10640__auto___71039)){
args71036.push((arguments[i__10641__auto___71040]));

var G__71041 = (i__10641__auto___71040 + (1));
i__10641__auto___71040 = G__71041;
continue;
} else {
}
break;
}

var G__71038 = args71036.length;
switch (G__71038) {
case 2:
return sablono.core.drop_down71035.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down71035.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71036.length)].join('')));

}
});

sablono.core.drop_down71035.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down71035.call(null,name,options,null);
});

sablono.core.drop_down71035.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down71035.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down71035);
/**
 * Creates a text area element.
 */
sablono.core.text_area71043 = (function sablono$core$text_area71043(var_args){
var args71044 = [];
var len__10640__auto___71047 = arguments.length;
var i__10641__auto___71048 = (0);
while(true){
if((i__10641__auto___71048 < len__10640__auto___71047)){
args71044.push((arguments[i__10641__auto___71048]));

var G__71049 = (i__10641__auto___71048 + (1));
i__10641__auto___71048 = G__71049;
continue;
} else {
}
break;
}

var G__71046 = args71044.length;
switch (G__71046) {
case 1:
return sablono.core.text_area71043.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area71043.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71044.length)].join('')));

}
});

sablono.core.text_area71043.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area71043.call(null,name,null);
});

sablono.core.text_area71043.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__9419__auto__ = value;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area71043.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area71043);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label71051 = (function sablono$core$label71051(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label71051);
/**
 * Creates a submit button.
 */
sablono.core.submit_button71052 = (function sablono$core$submit_button71052(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button71052);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button71053 = (function sablono$core$reset_button71053(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button71053);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to71054 = (function sablono$core$form_to71054(var_args){
var args__10647__auto__ = [];
var len__10640__auto___71061 = arguments.length;
var i__10641__auto___71062 = (0);
while(true){
if((i__10641__auto___71062 < len__10640__auto___71061)){
args__10647__auto__.push((arguments[i__10641__auto___71062]));

var G__71063 = (i__10641__auto___71062 + (1));
i__10641__auto___71062 = G__71063;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to71054.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

sablono.core.form_to71054.cljs$core$IFn$_invoke$arity$variadic = (function (p__71057,body){
var vec__71058 = p__71057;
var method = cljs.core.nth.call(null,vec__71058,(0),null);
var action = cljs.core.nth.call(null,vec__71058,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to71054.cljs$lang$maxFixedArity = (1);

sablono.core.form_to71054.cljs$lang$applyTo = (function (seq71055){
var G__71056 = cljs.core.first.call(null,seq71055);
var seq71055__$1 = cljs.core.next.call(null,seq71055);
return sablono.core.form_to71054.cljs$core$IFn$_invoke$arity$variadic(G__71056,seq71055__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to71054);

//# sourceMappingURL=core.js.map