// Compiled by ClojureScript 1.9.521 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('cljsjs.react.dom');
goog.require('reagent.impl.util');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('reagent.ratom');
goog.require('reagent.debug');
goog.require('reagent.interop');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(!((reagent.dom.imported == null))){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__9419__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_73936 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_73936){
return (function (){
var _STAR_always_update_STAR_73937 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(!((callback == null))){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_73937;
}});})(_STAR_always_update_STAR_73936))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_73936;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args73938 = [];
var len__10640__auto___73941 = arguments.length;
var i__10641__auto___73942 = (0);
while(true){
if((i__10641__auto___73942 < len__10640__auto___73941)){
args73938.push((arguments[i__10641__auto___73942]));

var G__73943 = (i__10641__auto___73942 + (1));
i__10641__auto___73942 = G__73943;
continue;
} else {
}
break;
}

var G__73940 = args73938.length;
switch (G__73940) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73938.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
reagent.impl.template.find_dom_node = reagent.dom.dom_node;
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__73949_73953 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__73950_73954 = null;
var count__73951_73955 = (0);
var i__73952_73956 = (0);
while(true){
if((i__73952_73956 < count__73951_73955)){
var v_73957 = cljs.core._nth.call(null,chunk__73950_73954,i__73952_73956);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_73957);

var G__73958 = seq__73949_73953;
var G__73959 = chunk__73950_73954;
var G__73960 = count__73951_73955;
var G__73961 = (i__73952_73956 + (1));
seq__73949_73953 = G__73958;
chunk__73950_73954 = G__73959;
count__73951_73955 = G__73960;
i__73952_73956 = G__73961;
continue;
} else {
var temp__6738__auto___73962 = cljs.core.seq.call(null,seq__73949_73953);
if(temp__6738__auto___73962){
var seq__73949_73963__$1 = temp__6738__auto___73962;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73949_73963__$1)){
var c__10330__auto___73964 = cljs.core.chunk_first.call(null,seq__73949_73963__$1);
var G__73965 = cljs.core.chunk_rest.call(null,seq__73949_73963__$1);
var G__73966 = c__10330__auto___73964;
var G__73967 = cljs.core.count.call(null,c__10330__auto___73964);
var G__73968 = (0);
seq__73949_73953 = G__73965;
chunk__73950_73954 = G__73966;
count__73951_73955 = G__73967;
i__73952_73956 = G__73968;
continue;
} else {
var v_73969 = cljs.core.first.call(null,seq__73949_73963__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_73969);

var G__73970 = cljs.core.next.call(null,seq__73949_73963__$1);
var G__73971 = null;
var G__73972 = (0);
var G__73973 = (0);
seq__73949_73953 = G__73970;
chunk__73950_73954 = G__73971;
count__73951_73955 = G__73972;
i__73952_73956 = G__73973;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map