(ns devbook.firebase-store
  (:require
    [konserve.core :as k]
    [budb.test-env :refer [prefix]]
    [budb.cljs.test-helpers :refer [make-db]]
    [konserve-firebase.core :as fb]
    [konserve-firebase.store :refer [new-firebasedb-store]]
    [reagent.core :as reagent :refer [atom]]
    [cljs.core.async :as async :refer [take! <! >! put! close! chan poll!]])
  (:require-macros
    [cljs.core.async.macros :refer [go go-loop]]
    [devcards.core :refer [defcard deftest defcard-rg]]))

(defcard-rg assoc-and-get
  (let [db (make-db)
        x (atom nil)]
    (fn []
      (go (<! (fb/assoc-in! db [prefix "devcards" "just-my-test"] 42))
          (reset! x (<! (fb/get-in! db [prefix "devcards" "just-my-test"]))))
      [:div {}
       [:p {} "simple assoc and get:"]
       [:pre {} (pr-str @x)]])))

(defcard-rg playing-with-the-store
  (let [store (atom nil)
        x (atom nil)
        y (atom nil)]
    (fn []
      (go (reset! store (<! (new-firebasedb-store
                              (make-db)
                              :prefix [prefix "devcards" "helloworld"])))
          (reset! x (<! (k/get-in @store ["random"])))
          (<! (k/assoc-in @store ["a"] :dayum))
          (reset! y (<! (k/get-in @store ["a"]))))
      [:div {}
       [:p {} "That's the firebase store"]
       [:pre {} (pr-str @store)]
       [:p {} "That's getting from a random empty field:"]
       [:pre {} (pr-str @x)]
       [:p {} "That should should :dayum since we assoc'd in"]
       [:pre {} (pr-str @y)]])))

(defcard-rg checking-complex-ops-with-update
  (let [value (atom nil)]
    (fn []
      (go (let [store (<! (new-firebasedb-store
                            (make-db)
                            :prefix [prefix "devcards" "more complex"]))]
            (<! (k/assoc-in store [:yolo] {:a 1 "b" "2" 3 "3"
                                           :d {:da [1 2 "3" :4]
                                               :db {:a 2}}}))
            (<! (k/update-in store [:yolo :d] (fn [x] (assoc x :dc 2))))
            (reset! value (<! (k/get-in store [:yolo :d])))))
      [:div {}
       [:p {} "This should show something with array, maps and a dc = 2"]
       [:pre {} (pr-str @value)]])))

