// Compiled by ClojureScript 1.9.521 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args76125 = [];
var len__10640__auto___76131 = arguments.length;
var i__10641__auto___76132 = (0);
while(true){
if((i__10641__auto___76132 < len__10640__auto___76131)){
args76125.push((arguments[i__10641__auto___76132]));

var G__76133 = (i__10641__auto___76132 + (1));
i__10641__auto___76132 = G__76133;
continue;
} else {
}
break;
}

var G__76127 = args76125.length;
switch (G__76127) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76125.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async76128 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async76128 = (function (f,blockable,meta76129){
this.f = f;
this.blockable = blockable;
this.meta76129 = meta76129;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async76128.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_76130,meta76129__$1){
var self__ = this;
var _76130__$1 = this;
return (new cljs.core.async.t_cljs$core$async76128(self__.f,self__.blockable,meta76129__$1));
});

cljs.core.async.t_cljs$core$async76128.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_76130){
var self__ = this;
var _76130__$1 = this;
return self__.meta76129;
});

cljs.core.async.t_cljs$core$async76128.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async76128.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async76128.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async76128.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async76128.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta76129","meta76129",360921986,null)], null);
});

cljs.core.async.t_cljs$core$async76128.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async76128.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async76128";

cljs.core.async.t_cljs$core$async76128.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async76128");
});

cljs.core.async.__GT_t_cljs$core$async76128 = (function cljs$core$async$__GT_t_cljs$core$async76128(f__$1,blockable__$1,meta76129){
return (new cljs.core.async.t_cljs$core$async76128(f__$1,blockable__$1,meta76129));
});

}

return (new cljs.core.async.t_cljs$core$async76128(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args76137 = [];
var len__10640__auto___76140 = arguments.length;
var i__10641__auto___76141 = (0);
while(true){
if((i__10641__auto___76141 < len__10640__auto___76140)){
args76137.push((arguments[i__10641__auto___76141]));

var G__76142 = (i__10641__auto___76141 + (1));
i__10641__auto___76141 = G__76142;
continue;
} else {
}
break;
}

var G__76139 = args76137.length;
switch (G__76139) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76137.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args76144 = [];
var len__10640__auto___76147 = arguments.length;
var i__10641__auto___76148 = (0);
while(true){
if((i__10641__auto___76148 < len__10640__auto___76147)){
args76144.push((arguments[i__10641__auto___76148]));

var G__76149 = (i__10641__auto___76148 + (1));
i__10641__auto___76148 = G__76149;
continue;
} else {
}
break;
}

var G__76146 = args76144.length;
switch (G__76146) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76144.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args76151 = [];
var len__10640__auto___76154 = arguments.length;
var i__10641__auto___76155 = (0);
while(true){
if((i__10641__auto___76155 < len__10640__auto___76154)){
args76151.push((arguments[i__10641__auto___76155]));

var G__76156 = (i__10641__auto___76155 + (1));
i__10641__auto___76155 = G__76156;
continue;
} else {
}
break;
}

var G__76153 = args76151.length;
switch (G__76153) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76151.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_76158 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_76158);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_76158,ret){
return (function (){
return fn1.call(null,val_76158);
});})(val_76158,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args76159 = [];
var len__10640__auto___76162 = arguments.length;
var i__10641__auto___76163 = (0);
while(true){
if((i__10641__auto___76163 < len__10640__auto___76162)){
args76159.push((arguments[i__10641__auto___76163]));

var G__76164 = (i__10641__auto___76163 + (1));
i__10641__auto___76163 = G__76164;
continue;
} else {
}
break;
}

var G__76161 = args76159.length;
switch (G__76161) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76159.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6736__auto__)){
var ret = temp__6736__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6736__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6736__auto__)){
var retb = temp__6736__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6736__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6736__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__10440__auto___76166 = n;
var x_76167 = (0);
while(true){
if((x_76167 < n__10440__auto___76166)){
(a[x_76167] = (0));

var G__76168 = (x_76167 + (1));
x_76167 = G__76168;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__76169 = (i + (1));
i = G__76169;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async76173 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async76173 = (function (flag,meta76174){
this.flag = flag;
this.meta76174 = meta76174;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async76173.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_76175,meta76174__$1){
var self__ = this;
var _76175__$1 = this;
return (new cljs.core.async.t_cljs$core$async76173(self__.flag,meta76174__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async76173.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_76175){
var self__ = this;
var _76175__$1 = this;
return self__.meta76174;
});})(flag))
;

cljs.core.async.t_cljs$core$async76173.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async76173.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async76173.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async76173.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async76173.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta76174","meta76174",1788478209,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async76173.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async76173.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async76173";

cljs.core.async.t_cljs$core$async76173.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async76173");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async76173 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async76173(flag__$1,meta76174){
return (new cljs.core.async.t_cljs$core$async76173(flag__$1,meta76174));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async76173(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async76179 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async76179 = (function (flag,cb,meta76180){
this.flag = flag;
this.cb = cb;
this.meta76180 = meta76180;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async76179.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_76181,meta76180__$1){
var self__ = this;
var _76181__$1 = this;
return (new cljs.core.async.t_cljs$core$async76179(self__.flag,self__.cb,meta76180__$1));
});

cljs.core.async.t_cljs$core$async76179.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_76181){
var self__ = this;
var _76181__$1 = this;
return self__.meta76180;
});

cljs.core.async.t_cljs$core$async76179.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async76179.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async76179.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async76179.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async76179.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta76180","meta76180",1387760548,null)], null);
});

cljs.core.async.t_cljs$core$async76179.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async76179.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async76179";

cljs.core.async.t_cljs$core$async76179.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async76179");
});

cljs.core.async.__GT_t_cljs$core$async76179 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async76179(flag__$1,cb__$1,meta76180){
return (new cljs.core.async.t_cljs$core$async76179(flag__$1,cb__$1,meta76180));
});

}

return (new cljs.core.async.t_cljs$core$async76179(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__76182_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__76182_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__76183_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__76183_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__9419__auto__ = wport;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return port;
}
})()], null));
} else {
var G__76184 = (i + (1));
i = G__76184;
continue;
}
} else {
return null;
}
break;
}
})();
var or__9419__auto__ = ret;
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6738__auto__ = (function (){var and__9407__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__9407__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__9407__auto__;
}
})();
if(cljs.core.truth_(temp__6738__auto__)){
var got = temp__6738__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___76190 = arguments.length;
var i__10641__auto___76191 = (0);
while(true){
if((i__10641__auto___76191 < len__10640__auto___76190)){
args__10647__auto__.push((arguments[i__10641__auto___76191]));

var G__76192 = (i__10641__auto___76191 + (1));
i__10641__auto___76191 = G__76192;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((1) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__10648__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__76187){
var map__76188 = p__76187;
var map__76188__$1 = ((((!((map__76188 == null)))?((((map__76188.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__76188.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__76188):map__76188);
var opts = map__76188__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq76185){
var G__76186 = cljs.core.first.call(null,seq76185);
var seq76185__$1 = cljs.core.next.call(null,seq76185);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__76186,seq76185__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args76193 = [];
var len__10640__auto___76243 = arguments.length;
var i__10641__auto___76244 = (0);
while(true){
if((i__10641__auto___76244 < len__10640__auto___76243)){
args76193.push((arguments[i__10641__auto___76244]));

var G__76245 = (i__10641__auto___76244 + (1));
i__10641__auto___76244 = G__76245;
continue;
} else {
}
break;
}

var G__76195 = args76193.length;
switch (G__76195) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76193.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__38457__auto___76247 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___76247){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___76247){
return (function (state_76219){
var state_val_76220 = (state_76219[(1)]);
if((state_val_76220 === (7))){
var inst_76215 = (state_76219[(2)]);
var state_76219__$1 = state_76219;
var statearr_76221_76248 = state_76219__$1;
(statearr_76221_76248[(2)] = inst_76215);

(statearr_76221_76248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76220 === (1))){
var state_76219__$1 = state_76219;
var statearr_76222_76249 = state_76219__$1;
(statearr_76222_76249[(2)] = null);

(statearr_76222_76249[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76220 === (4))){
var inst_76198 = (state_76219[(7)]);
var inst_76198__$1 = (state_76219[(2)]);
var inst_76199 = (inst_76198__$1 == null);
var state_76219__$1 = (function (){var statearr_76223 = state_76219;
(statearr_76223[(7)] = inst_76198__$1);

return statearr_76223;
})();
if(cljs.core.truth_(inst_76199)){
var statearr_76224_76250 = state_76219__$1;
(statearr_76224_76250[(1)] = (5));

} else {
var statearr_76225_76251 = state_76219__$1;
(statearr_76225_76251[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76220 === (13))){
var state_76219__$1 = state_76219;
var statearr_76226_76252 = state_76219__$1;
(statearr_76226_76252[(2)] = null);

(statearr_76226_76252[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76220 === (6))){
var inst_76198 = (state_76219[(7)]);
var state_76219__$1 = state_76219;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76219__$1,(11),to,inst_76198);
} else {
if((state_val_76220 === (3))){
var inst_76217 = (state_76219[(2)]);
var state_76219__$1 = state_76219;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76219__$1,inst_76217);
} else {
if((state_val_76220 === (12))){
var state_76219__$1 = state_76219;
var statearr_76227_76253 = state_76219__$1;
(statearr_76227_76253[(2)] = null);

(statearr_76227_76253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76220 === (2))){
var state_76219__$1 = state_76219;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76219__$1,(4),from);
} else {
if((state_val_76220 === (11))){
var inst_76208 = (state_76219[(2)]);
var state_76219__$1 = state_76219;
if(cljs.core.truth_(inst_76208)){
var statearr_76228_76254 = state_76219__$1;
(statearr_76228_76254[(1)] = (12));

} else {
var statearr_76229_76255 = state_76219__$1;
(statearr_76229_76255[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76220 === (9))){
var state_76219__$1 = state_76219;
var statearr_76230_76256 = state_76219__$1;
(statearr_76230_76256[(2)] = null);

(statearr_76230_76256[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76220 === (5))){
var state_76219__$1 = state_76219;
if(cljs.core.truth_(close_QMARK_)){
var statearr_76231_76257 = state_76219__$1;
(statearr_76231_76257[(1)] = (8));

} else {
var statearr_76232_76258 = state_76219__$1;
(statearr_76232_76258[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76220 === (14))){
var inst_76213 = (state_76219[(2)]);
var state_76219__$1 = state_76219;
var statearr_76233_76259 = state_76219__$1;
(statearr_76233_76259[(2)] = inst_76213);

(statearr_76233_76259[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76220 === (10))){
var inst_76205 = (state_76219[(2)]);
var state_76219__$1 = state_76219;
var statearr_76234_76260 = state_76219__$1;
(statearr_76234_76260[(2)] = inst_76205);

(statearr_76234_76260[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76220 === (8))){
var inst_76202 = cljs.core.async.close_BANG_.call(null,to);
var state_76219__$1 = state_76219;
var statearr_76235_76261 = state_76219__$1;
(statearr_76235_76261[(2)] = inst_76202);

(statearr_76235_76261[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___76247))
;
return ((function (switch__38343__auto__,c__38457__auto___76247){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_76239 = [null,null,null,null,null,null,null,null];
(statearr_76239[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_76239[(1)] = (1));

return statearr_76239;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_76219){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_76219);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e76240){if((e76240 instanceof Object)){
var ex__38347__auto__ = e76240;
var statearr_76241_76262 = state_76219;
(statearr_76241_76262[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76219);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76240;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76263 = state_76219;
state_76219 = G__76263;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_76219){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_76219);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___76247))
})();
var state__38459__auto__ = (function (){var statearr_76242 = f__38458__auto__.call(null);
(statearr_76242[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___76247);

return statearr_76242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___76247))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__76451){
var vec__76452 = p__76451;
var v = cljs.core.nth.call(null,vec__76452,(0),null);
var p = cljs.core.nth.call(null,vec__76452,(1),null);
var job = vec__76452;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__38457__auto___76638 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___76638,res,vec__76452,v,p,job,jobs,results){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___76638,res,vec__76452,v,p,job,jobs,results){
return (function (state_76459){
var state_val_76460 = (state_76459[(1)]);
if((state_val_76460 === (1))){
var state_76459__$1 = state_76459;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76459__$1,(2),res,v);
} else {
if((state_val_76460 === (2))){
var inst_76456 = (state_76459[(2)]);
var inst_76457 = cljs.core.async.close_BANG_.call(null,res);
var state_76459__$1 = (function (){var statearr_76461 = state_76459;
(statearr_76461[(7)] = inst_76456);

return statearr_76461;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76459__$1,inst_76457);
} else {
return null;
}
}
});})(c__38457__auto___76638,res,vec__76452,v,p,job,jobs,results))
;
return ((function (switch__38343__auto__,c__38457__auto___76638,res,vec__76452,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_76465 = [null,null,null,null,null,null,null,null];
(statearr_76465[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__);

(statearr_76465[(1)] = (1));

return statearr_76465;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1 = (function (state_76459){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_76459);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e76466){if((e76466 instanceof Object)){
var ex__38347__auto__ = e76466;
var statearr_76467_76639 = state_76459;
(statearr_76467_76639[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76459);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76466;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76640 = state_76459;
state_76459 = G__76640;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = function(state_76459){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1.call(this,state_76459);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___76638,res,vec__76452,v,p,job,jobs,results))
})();
var state__38459__auto__ = (function (){var statearr_76468 = f__38458__auto__.call(null);
(statearr_76468[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___76638);

return statearr_76468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___76638,res,vec__76452,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__76469){
var vec__76470 = p__76469;
var v = cljs.core.nth.call(null,vec__76470,(0),null);
var p = cljs.core.nth.call(null,vec__76470,(1),null);
var job = vec__76470;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__10440__auto___76641 = n;
var __76642 = (0);
while(true){
if((__76642 < n__10440__auto___76641)){
var G__76473_76643 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__76473_76643) {
case "compute":
var c__38457__auto___76645 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__76642,c__38457__auto___76645,G__76473_76643,n__10440__auto___76641,jobs,results,process,async){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (__76642,c__38457__auto___76645,G__76473_76643,n__10440__auto___76641,jobs,results,process,async){
return (function (state_76486){
var state_val_76487 = (state_76486[(1)]);
if((state_val_76487 === (1))){
var state_76486__$1 = state_76486;
var statearr_76488_76646 = state_76486__$1;
(statearr_76488_76646[(2)] = null);

(statearr_76488_76646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76487 === (2))){
var state_76486__$1 = state_76486;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76486__$1,(4),jobs);
} else {
if((state_val_76487 === (3))){
var inst_76484 = (state_76486[(2)]);
var state_76486__$1 = state_76486;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76486__$1,inst_76484);
} else {
if((state_val_76487 === (4))){
var inst_76476 = (state_76486[(2)]);
var inst_76477 = process.call(null,inst_76476);
var state_76486__$1 = state_76486;
if(cljs.core.truth_(inst_76477)){
var statearr_76489_76647 = state_76486__$1;
(statearr_76489_76647[(1)] = (5));

} else {
var statearr_76490_76648 = state_76486__$1;
(statearr_76490_76648[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76487 === (5))){
var state_76486__$1 = state_76486;
var statearr_76491_76649 = state_76486__$1;
(statearr_76491_76649[(2)] = null);

(statearr_76491_76649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76487 === (6))){
var state_76486__$1 = state_76486;
var statearr_76492_76650 = state_76486__$1;
(statearr_76492_76650[(2)] = null);

(statearr_76492_76650[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76487 === (7))){
var inst_76482 = (state_76486[(2)]);
var state_76486__$1 = state_76486;
var statearr_76493_76651 = state_76486__$1;
(statearr_76493_76651[(2)] = inst_76482);

(statearr_76493_76651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__76642,c__38457__auto___76645,G__76473_76643,n__10440__auto___76641,jobs,results,process,async))
;
return ((function (__76642,switch__38343__auto__,c__38457__auto___76645,G__76473_76643,n__10440__auto___76641,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_76497 = [null,null,null,null,null,null,null];
(statearr_76497[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__);

(statearr_76497[(1)] = (1));

return statearr_76497;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1 = (function (state_76486){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_76486);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e76498){if((e76498 instanceof Object)){
var ex__38347__auto__ = e76498;
var statearr_76499_76652 = state_76486;
(statearr_76499_76652[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76486);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76498;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76653 = state_76486;
state_76486 = G__76653;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = function(state_76486){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1.call(this,state_76486);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__;
})()
;})(__76642,switch__38343__auto__,c__38457__auto___76645,G__76473_76643,n__10440__auto___76641,jobs,results,process,async))
})();
var state__38459__auto__ = (function (){var statearr_76500 = f__38458__auto__.call(null);
(statearr_76500[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___76645);

return statearr_76500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(__76642,c__38457__auto___76645,G__76473_76643,n__10440__auto___76641,jobs,results,process,async))
);


break;
case "async":
var c__38457__auto___76654 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__76642,c__38457__auto___76654,G__76473_76643,n__10440__auto___76641,jobs,results,process,async){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (__76642,c__38457__auto___76654,G__76473_76643,n__10440__auto___76641,jobs,results,process,async){
return (function (state_76513){
var state_val_76514 = (state_76513[(1)]);
if((state_val_76514 === (1))){
var state_76513__$1 = state_76513;
var statearr_76515_76655 = state_76513__$1;
(statearr_76515_76655[(2)] = null);

(statearr_76515_76655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76514 === (2))){
var state_76513__$1 = state_76513;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76513__$1,(4),jobs);
} else {
if((state_val_76514 === (3))){
var inst_76511 = (state_76513[(2)]);
var state_76513__$1 = state_76513;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76513__$1,inst_76511);
} else {
if((state_val_76514 === (4))){
var inst_76503 = (state_76513[(2)]);
var inst_76504 = async.call(null,inst_76503);
var state_76513__$1 = state_76513;
if(cljs.core.truth_(inst_76504)){
var statearr_76516_76656 = state_76513__$1;
(statearr_76516_76656[(1)] = (5));

} else {
var statearr_76517_76657 = state_76513__$1;
(statearr_76517_76657[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76514 === (5))){
var state_76513__$1 = state_76513;
var statearr_76518_76658 = state_76513__$1;
(statearr_76518_76658[(2)] = null);

(statearr_76518_76658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76514 === (6))){
var state_76513__$1 = state_76513;
var statearr_76519_76659 = state_76513__$1;
(statearr_76519_76659[(2)] = null);

(statearr_76519_76659[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76514 === (7))){
var inst_76509 = (state_76513[(2)]);
var state_76513__$1 = state_76513;
var statearr_76520_76660 = state_76513__$1;
(statearr_76520_76660[(2)] = inst_76509);

(statearr_76520_76660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__76642,c__38457__auto___76654,G__76473_76643,n__10440__auto___76641,jobs,results,process,async))
;
return ((function (__76642,switch__38343__auto__,c__38457__auto___76654,G__76473_76643,n__10440__auto___76641,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_76524 = [null,null,null,null,null,null,null];
(statearr_76524[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__);

(statearr_76524[(1)] = (1));

return statearr_76524;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1 = (function (state_76513){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_76513);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e76525){if((e76525 instanceof Object)){
var ex__38347__auto__ = e76525;
var statearr_76526_76661 = state_76513;
(statearr_76526_76661[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76513);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76525;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76662 = state_76513;
state_76513 = G__76662;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = function(state_76513){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1.call(this,state_76513);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__;
})()
;})(__76642,switch__38343__auto__,c__38457__auto___76654,G__76473_76643,n__10440__auto___76641,jobs,results,process,async))
})();
var state__38459__auto__ = (function (){var statearr_76527 = f__38458__auto__.call(null);
(statearr_76527[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___76654);

return statearr_76527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(__76642,c__38457__auto___76654,G__76473_76643,n__10440__auto___76641,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__76663 = (__76642 + (1));
__76642 = G__76663;
continue;
} else {
}
break;
}

var c__38457__auto___76664 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___76664,jobs,results,process,async){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___76664,jobs,results,process,async){
return (function (state_76549){
var state_val_76550 = (state_76549[(1)]);
if((state_val_76550 === (1))){
var state_76549__$1 = state_76549;
var statearr_76551_76665 = state_76549__$1;
(statearr_76551_76665[(2)] = null);

(statearr_76551_76665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (2))){
var state_76549__$1 = state_76549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76549__$1,(4),from);
} else {
if((state_val_76550 === (3))){
var inst_76547 = (state_76549[(2)]);
var state_76549__$1 = state_76549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76549__$1,inst_76547);
} else {
if((state_val_76550 === (4))){
var inst_76530 = (state_76549[(7)]);
var inst_76530__$1 = (state_76549[(2)]);
var inst_76531 = (inst_76530__$1 == null);
var state_76549__$1 = (function (){var statearr_76552 = state_76549;
(statearr_76552[(7)] = inst_76530__$1);

return statearr_76552;
})();
if(cljs.core.truth_(inst_76531)){
var statearr_76553_76666 = state_76549__$1;
(statearr_76553_76666[(1)] = (5));

} else {
var statearr_76554_76667 = state_76549__$1;
(statearr_76554_76667[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (5))){
var inst_76533 = cljs.core.async.close_BANG_.call(null,jobs);
var state_76549__$1 = state_76549;
var statearr_76555_76668 = state_76549__$1;
(statearr_76555_76668[(2)] = inst_76533);

(statearr_76555_76668[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (6))){
var inst_76530 = (state_76549[(7)]);
var inst_76535 = (state_76549[(8)]);
var inst_76535__$1 = cljs.core.async.chan.call(null,(1));
var inst_76536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76537 = [inst_76530,inst_76535__$1];
var inst_76538 = (new cljs.core.PersistentVector(null,2,(5),inst_76536,inst_76537,null));
var state_76549__$1 = (function (){var statearr_76556 = state_76549;
(statearr_76556[(8)] = inst_76535__$1);

return statearr_76556;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76549__$1,(8),jobs,inst_76538);
} else {
if((state_val_76550 === (7))){
var inst_76545 = (state_76549[(2)]);
var state_76549__$1 = state_76549;
var statearr_76557_76669 = state_76549__$1;
(statearr_76557_76669[(2)] = inst_76545);

(statearr_76557_76669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76550 === (8))){
var inst_76535 = (state_76549[(8)]);
var inst_76540 = (state_76549[(2)]);
var state_76549__$1 = (function (){var statearr_76558 = state_76549;
(statearr_76558[(9)] = inst_76540);

return statearr_76558;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76549__$1,(9),results,inst_76535);
} else {
if((state_val_76550 === (9))){
var inst_76542 = (state_76549[(2)]);
var state_76549__$1 = (function (){var statearr_76559 = state_76549;
(statearr_76559[(10)] = inst_76542);

return statearr_76559;
})();
var statearr_76560_76670 = state_76549__$1;
(statearr_76560_76670[(2)] = null);

(statearr_76560_76670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___76664,jobs,results,process,async))
;
return ((function (switch__38343__auto__,c__38457__auto___76664,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_76564 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_76564[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__);

(statearr_76564[(1)] = (1));

return statearr_76564;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1 = (function (state_76549){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_76549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e76565){if((e76565 instanceof Object)){
var ex__38347__auto__ = e76565;
var statearr_76566_76671 = state_76549;
(statearr_76566_76671[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76549);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76565;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76672 = state_76549;
state_76549 = G__76672;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = function(state_76549){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1.call(this,state_76549);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___76664,jobs,results,process,async))
})();
var state__38459__auto__ = (function (){var statearr_76567 = f__38458__auto__.call(null);
(statearr_76567[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___76664);

return statearr_76567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___76664,jobs,results,process,async))
);


var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,jobs,results,process,async){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,jobs,results,process,async){
return (function (state_76605){
var state_val_76606 = (state_76605[(1)]);
if((state_val_76606 === (7))){
var inst_76601 = (state_76605[(2)]);
var state_76605__$1 = state_76605;
var statearr_76607_76673 = state_76605__$1;
(statearr_76607_76673[(2)] = inst_76601);

(statearr_76607_76673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (20))){
var state_76605__$1 = state_76605;
var statearr_76608_76674 = state_76605__$1;
(statearr_76608_76674[(2)] = null);

(statearr_76608_76674[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (1))){
var state_76605__$1 = state_76605;
var statearr_76609_76675 = state_76605__$1;
(statearr_76609_76675[(2)] = null);

(statearr_76609_76675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (4))){
var inst_76570 = (state_76605[(7)]);
var inst_76570__$1 = (state_76605[(2)]);
var inst_76571 = (inst_76570__$1 == null);
var state_76605__$1 = (function (){var statearr_76610 = state_76605;
(statearr_76610[(7)] = inst_76570__$1);

return statearr_76610;
})();
if(cljs.core.truth_(inst_76571)){
var statearr_76611_76676 = state_76605__$1;
(statearr_76611_76676[(1)] = (5));

} else {
var statearr_76612_76677 = state_76605__$1;
(statearr_76612_76677[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (15))){
var inst_76583 = (state_76605[(8)]);
var state_76605__$1 = state_76605;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76605__$1,(18),to,inst_76583);
} else {
if((state_val_76606 === (21))){
var inst_76596 = (state_76605[(2)]);
var state_76605__$1 = state_76605;
var statearr_76613_76678 = state_76605__$1;
(statearr_76613_76678[(2)] = inst_76596);

(statearr_76613_76678[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (13))){
var inst_76598 = (state_76605[(2)]);
var state_76605__$1 = (function (){var statearr_76614 = state_76605;
(statearr_76614[(9)] = inst_76598);

return statearr_76614;
})();
var statearr_76615_76679 = state_76605__$1;
(statearr_76615_76679[(2)] = null);

(statearr_76615_76679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (6))){
var inst_76570 = (state_76605[(7)]);
var state_76605__$1 = state_76605;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76605__$1,(11),inst_76570);
} else {
if((state_val_76606 === (17))){
var inst_76591 = (state_76605[(2)]);
var state_76605__$1 = state_76605;
if(cljs.core.truth_(inst_76591)){
var statearr_76616_76680 = state_76605__$1;
(statearr_76616_76680[(1)] = (19));

} else {
var statearr_76617_76681 = state_76605__$1;
(statearr_76617_76681[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (3))){
var inst_76603 = (state_76605[(2)]);
var state_76605__$1 = state_76605;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76605__$1,inst_76603);
} else {
if((state_val_76606 === (12))){
var inst_76580 = (state_76605[(10)]);
var state_76605__$1 = state_76605;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76605__$1,(14),inst_76580);
} else {
if((state_val_76606 === (2))){
var state_76605__$1 = state_76605;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76605__$1,(4),results);
} else {
if((state_val_76606 === (19))){
var state_76605__$1 = state_76605;
var statearr_76618_76682 = state_76605__$1;
(statearr_76618_76682[(2)] = null);

(statearr_76618_76682[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (11))){
var inst_76580 = (state_76605[(2)]);
var state_76605__$1 = (function (){var statearr_76619 = state_76605;
(statearr_76619[(10)] = inst_76580);

return statearr_76619;
})();
var statearr_76620_76683 = state_76605__$1;
(statearr_76620_76683[(2)] = null);

(statearr_76620_76683[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (9))){
var state_76605__$1 = state_76605;
var statearr_76621_76684 = state_76605__$1;
(statearr_76621_76684[(2)] = null);

(statearr_76621_76684[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (5))){
var state_76605__$1 = state_76605;
if(cljs.core.truth_(close_QMARK_)){
var statearr_76622_76685 = state_76605__$1;
(statearr_76622_76685[(1)] = (8));

} else {
var statearr_76623_76686 = state_76605__$1;
(statearr_76623_76686[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (14))){
var inst_76585 = (state_76605[(11)]);
var inst_76583 = (state_76605[(8)]);
var inst_76583__$1 = (state_76605[(2)]);
var inst_76584 = (inst_76583__$1 == null);
var inst_76585__$1 = cljs.core.not.call(null,inst_76584);
var state_76605__$1 = (function (){var statearr_76624 = state_76605;
(statearr_76624[(11)] = inst_76585__$1);

(statearr_76624[(8)] = inst_76583__$1);

return statearr_76624;
})();
if(inst_76585__$1){
var statearr_76625_76687 = state_76605__$1;
(statearr_76625_76687[(1)] = (15));

} else {
var statearr_76626_76688 = state_76605__$1;
(statearr_76626_76688[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (16))){
var inst_76585 = (state_76605[(11)]);
var state_76605__$1 = state_76605;
var statearr_76627_76689 = state_76605__$1;
(statearr_76627_76689[(2)] = inst_76585);

(statearr_76627_76689[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (10))){
var inst_76577 = (state_76605[(2)]);
var state_76605__$1 = state_76605;
var statearr_76628_76690 = state_76605__$1;
(statearr_76628_76690[(2)] = inst_76577);

(statearr_76628_76690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (18))){
var inst_76588 = (state_76605[(2)]);
var state_76605__$1 = state_76605;
var statearr_76629_76691 = state_76605__$1;
(statearr_76629_76691[(2)] = inst_76588);

(statearr_76629_76691[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76606 === (8))){
var inst_76574 = cljs.core.async.close_BANG_.call(null,to);
var state_76605__$1 = state_76605;
var statearr_76630_76692 = state_76605__$1;
(statearr_76630_76692[(2)] = inst_76574);

(statearr_76630_76692[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto__,jobs,results,process,async))
;
return ((function (switch__38343__auto__,c__38457__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_76634 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76634[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__);

(statearr_76634[(1)] = (1));

return statearr_76634;
});
var cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1 = (function (state_76605){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_76605);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e76635){if((e76635 instanceof Object)){
var ex__38347__auto__ = e76635;
var statearr_76636_76693 = state_76605;
(statearr_76636_76693[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76605);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76635;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76694 = state_76605;
state_76605 = G__76694;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__ = function(state_76605){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1.call(this,state_76605);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,jobs,results,process,async))
})();
var state__38459__auto__ = (function (){var statearr_76637 = f__38458__auto__.call(null);
(statearr_76637[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_76637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,jobs,results,process,async))
);

return c__38457__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args76695 = [];
var len__10640__auto___76698 = arguments.length;
var i__10641__auto___76699 = (0);
while(true){
if((i__10641__auto___76699 < len__10640__auto___76698)){
args76695.push((arguments[i__10641__auto___76699]));

var G__76700 = (i__10641__auto___76699 + (1));
i__10641__auto___76699 = G__76700;
continue;
} else {
}
break;
}

var G__76697 = args76695.length;
switch (G__76697) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76695.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args76702 = [];
var len__10640__auto___76705 = arguments.length;
var i__10641__auto___76706 = (0);
while(true){
if((i__10641__auto___76706 < len__10640__auto___76705)){
args76702.push((arguments[i__10641__auto___76706]));

var G__76707 = (i__10641__auto___76706 + (1));
i__10641__auto___76706 = G__76707;
continue;
} else {
}
break;
}

var G__76704 = args76702.length;
switch (G__76704) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76702.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args76709 = [];
var len__10640__auto___76762 = arguments.length;
var i__10641__auto___76763 = (0);
while(true){
if((i__10641__auto___76763 < len__10640__auto___76762)){
args76709.push((arguments[i__10641__auto___76763]));

var G__76764 = (i__10641__auto___76763 + (1));
i__10641__auto___76763 = G__76764;
continue;
} else {
}
break;
}

var G__76711 = args76709.length;
switch (G__76711) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76709.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__38457__auto___76766 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___76766,tc,fc){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___76766,tc,fc){
return (function (state_76737){
var state_val_76738 = (state_76737[(1)]);
if((state_val_76738 === (7))){
var inst_76733 = (state_76737[(2)]);
var state_76737__$1 = state_76737;
var statearr_76739_76767 = state_76737__$1;
(statearr_76739_76767[(2)] = inst_76733);

(statearr_76739_76767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76738 === (1))){
var state_76737__$1 = state_76737;
var statearr_76740_76768 = state_76737__$1;
(statearr_76740_76768[(2)] = null);

(statearr_76740_76768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76738 === (4))){
var inst_76714 = (state_76737[(7)]);
var inst_76714__$1 = (state_76737[(2)]);
var inst_76715 = (inst_76714__$1 == null);
var state_76737__$1 = (function (){var statearr_76741 = state_76737;
(statearr_76741[(7)] = inst_76714__$1);

return statearr_76741;
})();
if(cljs.core.truth_(inst_76715)){
var statearr_76742_76769 = state_76737__$1;
(statearr_76742_76769[(1)] = (5));

} else {
var statearr_76743_76770 = state_76737__$1;
(statearr_76743_76770[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76738 === (13))){
var state_76737__$1 = state_76737;
var statearr_76744_76771 = state_76737__$1;
(statearr_76744_76771[(2)] = null);

(statearr_76744_76771[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76738 === (6))){
var inst_76714 = (state_76737[(7)]);
var inst_76720 = p.call(null,inst_76714);
var state_76737__$1 = state_76737;
if(cljs.core.truth_(inst_76720)){
var statearr_76745_76772 = state_76737__$1;
(statearr_76745_76772[(1)] = (9));

} else {
var statearr_76746_76773 = state_76737__$1;
(statearr_76746_76773[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76738 === (3))){
var inst_76735 = (state_76737[(2)]);
var state_76737__$1 = state_76737;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76737__$1,inst_76735);
} else {
if((state_val_76738 === (12))){
var state_76737__$1 = state_76737;
var statearr_76747_76774 = state_76737__$1;
(statearr_76747_76774[(2)] = null);

(statearr_76747_76774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76738 === (2))){
var state_76737__$1 = state_76737;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76737__$1,(4),ch);
} else {
if((state_val_76738 === (11))){
var inst_76714 = (state_76737[(7)]);
var inst_76724 = (state_76737[(2)]);
var state_76737__$1 = state_76737;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76737__$1,(8),inst_76724,inst_76714);
} else {
if((state_val_76738 === (9))){
var state_76737__$1 = state_76737;
var statearr_76748_76775 = state_76737__$1;
(statearr_76748_76775[(2)] = tc);

(statearr_76748_76775[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76738 === (5))){
var inst_76717 = cljs.core.async.close_BANG_.call(null,tc);
var inst_76718 = cljs.core.async.close_BANG_.call(null,fc);
var state_76737__$1 = (function (){var statearr_76749 = state_76737;
(statearr_76749[(8)] = inst_76717);

return statearr_76749;
})();
var statearr_76750_76776 = state_76737__$1;
(statearr_76750_76776[(2)] = inst_76718);

(statearr_76750_76776[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76738 === (14))){
var inst_76731 = (state_76737[(2)]);
var state_76737__$1 = state_76737;
var statearr_76751_76777 = state_76737__$1;
(statearr_76751_76777[(2)] = inst_76731);

(statearr_76751_76777[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76738 === (10))){
var state_76737__$1 = state_76737;
var statearr_76752_76778 = state_76737__$1;
(statearr_76752_76778[(2)] = fc);

(statearr_76752_76778[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76738 === (8))){
var inst_76726 = (state_76737[(2)]);
var state_76737__$1 = state_76737;
if(cljs.core.truth_(inst_76726)){
var statearr_76753_76779 = state_76737__$1;
(statearr_76753_76779[(1)] = (12));

} else {
var statearr_76754_76780 = state_76737__$1;
(statearr_76754_76780[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___76766,tc,fc))
;
return ((function (switch__38343__auto__,c__38457__auto___76766,tc,fc){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_76758 = [null,null,null,null,null,null,null,null,null];
(statearr_76758[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_76758[(1)] = (1));

return statearr_76758;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_76737){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_76737);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e76759){if((e76759 instanceof Object)){
var ex__38347__auto__ = e76759;
var statearr_76760_76781 = state_76737;
(statearr_76760_76781[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76737);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76759;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76782 = state_76737;
state_76737 = G__76782;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_76737){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_76737);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___76766,tc,fc))
})();
var state__38459__auto__ = (function (){var statearr_76761 = f__38458__auto__.call(null);
(statearr_76761[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___76766);

return statearr_76761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___76766,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__){
return (function (state_76846){
var state_val_76847 = (state_76846[(1)]);
if((state_val_76847 === (7))){
var inst_76842 = (state_76846[(2)]);
var state_76846__$1 = state_76846;
var statearr_76848_76869 = state_76846__$1;
(statearr_76848_76869[(2)] = inst_76842);

(statearr_76848_76869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76847 === (1))){
var inst_76826 = init;
var state_76846__$1 = (function (){var statearr_76849 = state_76846;
(statearr_76849[(7)] = inst_76826);

return statearr_76849;
})();
var statearr_76850_76870 = state_76846__$1;
(statearr_76850_76870[(2)] = null);

(statearr_76850_76870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76847 === (4))){
var inst_76829 = (state_76846[(8)]);
var inst_76829__$1 = (state_76846[(2)]);
var inst_76830 = (inst_76829__$1 == null);
var state_76846__$1 = (function (){var statearr_76851 = state_76846;
(statearr_76851[(8)] = inst_76829__$1);

return statearr_76851;
})();
if(cljs.core.truth_(inst_76830)){
var statearr_76852_76871 = state_76846__$1;
(statearr_76852_76871[(1)] = (5));

} else {
var statearr_76853_76872 = state_76846__$1;
(statearr_76853_76872[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76847 === (6))){
var inst_76829 = (state_76846[(8)]);
var inst_76826 = (state_76846[(7)]);
var inst_76833 = (state_76846[(9)]);
var inst_76833__$1 = f.call(null,inst_76826,inst_76829);
var inst_76834 = cljs.core.reduced_QMARK_.call(null,inst_76833__$1);
var state_76846__$1 = (function (){var statearr_76854 = state_76846;
(statearr_76854[(9)] = inst_76833__$1);

return statearr_76854;
})();
if(inst_76834){
var statearr_76855_76873 = state_76846__$1;
(statearr_76855_76873[(1)] = (8));

} else {
var statearr_76856_76874 = state_76846__$1;
(statearr_76856_76874[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76847 === (3))){
var inst_76844 = (state_76846[(2)]);
var state_76846__$1 = state_76846;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76846__$1,inst_76844);
} else {
if((state_val_76847 === (2))){
var state_76846__$1 = state_76846;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76846__$1,(4),ch);
} else {
if((state_val_76847 === (9))){
var inst_76833 = (state_76846[(9)]);
var inst_76826 = inst_76833;
var state_76846__$1 = (function (){var statearr_76857 = state_76846;
(statearr_76857[(7)] = inst_76826);

return statearr_76857;
})();
var statearr_76858_76875 = state_76846__$1;
(statearr_76858_76875[(2)] = null);

(statearr_76858_76875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76847 === (5))){
var inst_76826 = (state_76846[(7)]);
var state_76846__$1 = state_76846;
var statearr_76859_76876 = state_76846__$1;
(statearr_76859_76876[(2)] = inst_76826);

(statearr_76859_76876[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76847 === (10))){
var inst_76840 = (state_76846[(2)]);
var state_76846__$1 = state_76846;
var statearr_76860_76877 = state_76846__$1;
(statearr_76860_76877[(2)] = inst_76840);

(statearr_76860_76877[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76847 === (8))){
var inst_76833 = (state_76846[(9)]);
var inst_76836 = cljs.core.deref.call(null,inst_76833);
var state_76846__$1 = state_76846;
var statearr_76861_76878 = state_76846__$1;
(statearr_76861_76878[(2)] = inst_76836);

(statearr_76861_76878[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto__))
;
return ((function (switch__38343__auto__,c__38457__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__38344__auto__ = null;
var cljs$core$async$reduce_$_state_machine__38344__auto____0 = (function (){
var statearr_76865 = [null,null,null,null,null,null,null,null,null,null];
(statearr_76865[(0)] = cljs$core$async$reduce_$_state_machine__38344__auto__);

(statearr_76865[(1)] = (1));

return statearr_76865;
});
var cljs$core$async$reduce_$_state_machine__38344__auto____1 = (function (state_76846){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_76846);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e76866){if((e76866 instanceof Object)){
var ex__38347__auto__ = e76866;
var statearr_76867_76879 = state_76846;
(statearr_76867_76879[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76846);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76866;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76880 = state_76846;
state_76846 = G__76880;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__38344__auto__ = function(state_76846){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__38344__auto____1.call(this,state_76846);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__38344__auto____0;
cljs$core$async$reduce_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__38344__auto____1;
return cljs$core$async$reduce_$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__))
})();
var state__38459__auto__ = (function (){var statearr_76868 = f__38458__auto__.call(null);
(statearr_76868[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_76868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__))
);

return c__38457__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__,f__$1){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__,f__$1){
return (function (state_76900){
var state_val_76901 = (state_76900[(1)]);
if((state_val_76901 === (1))){
var inst_76895 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_76900__$1 = state_76900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76900__$1,(2),inst_76895);
} else {
if((state_val_76901 === (2))){
var inst_76897 = (state_76900[(2)]);
var inst_76898 = f__$1.call(null,inst_76897);
var state_76900__$1 = state_76900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76900__$1,inst_76898);
} else {
return null;
}
}
});})(c__38457__auto__,f__$1))
;
return ((function (switch__38343__auto__,c__38457__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__38344__auto__ = null;
var cljs$core$async$transduce_$_state_machine__38344__auto____0 = (function (){
var statearr_76905 = [null,null,null,null,null,null,null];
(statearr_76905[(0)] = cljs$core$async$transduce_$_state_machine__38344__auto__);

(statearr_76905[(1)] = (1));

return statearr_76905;
});
var cljs$core$async$transduce_$_state_machine__38344__auto____1 = (function (state_76900){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_76900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e76906){if((e76906 instanceof Object)){
var ex__38347__auto__ = e76906;
var statearr_76907_76909 = state_76900;
(statearr_76907_76909[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76900);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76906;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76910 = state_76900;
state_76900 = G__76910;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__38344__auto__ = function(state_76900){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__38344__auto____1.call(this,state_76900);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__38344__auto____0;
cljs$core$async$transduce_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__38344__auto____1;
return cljs$core$async$transduce_$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__,f__$1))
})();
var state__38459__auto__ = (function (){var statearr_76908 = f__38458__auto__.call(null);
(statearr_76908[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_76908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__,f__$1))
);

return c__38457__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args76911 = [];
var len__10640__auto___76963 = arguments.length;
var i__10641__auto___76964 = (0);
while(true){
if((i__10641__auto___76964 < len__10640__auto___76963)){
args76911.push((arguments[i__10641__auto___76964]));

var G__76965 = (i__10641__auto___76964 + (1));
i__10641__auto___76964 = G__76965;
continue;
} else {
}
break;
}

var G__76913 = args76911.length;
switch (G__76913) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args76911.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__){
return (function (state_76938){
var state_val_76939 = (state_76938[(1)]);
if((state_val_76939 === (7))){
var inst_76920 = (state_76938[(2)]);
var state_76938__$1 = state_76938;
var statearr_76940_76967 = state_76938__$1;
(statearr_76940_76967[(2)] = inst_76920);

(statearr_76940_76967[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76939 === (1))){
var inst_76914 = cljs.core.seq.call(null,coll);
var inst_76915 = inst_76914;
var state_76938__$1 = (function (){var statearr_76941 = state_76938;
(statearr_76941[(7)] = inst_76915);

return statearr_76941;
})();
var statearr_76942_76968 = state_76938__$1;
(statearr_76942_76968[(2)] = null);

(statearr_76942_76968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76939 === (4))){
var inst_76915 = (state_76938[(7)]);
var inst_76918 = cljs.core.first.call(null,inst_76915);
var state_76938__$1 = state_76938;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_76938__$1,(7),ch,inst_76918);
} else {
if((state_val_76939 === (13))){
var inst_76932 = (state_76938[(2)]);
var state_76938__$1 = state_76938;
var statearr_76943_76969 = state_76938__$1;
(statearr_76943_76969[(2)] = inst_76932);

(statearr_76943_76969[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76939 === (6))){
var inst_76923 = (state_76938[(2)]);
var state_76938__$1 = state_76938;
if(cljs.core.truth_(inst_76923)){
var statearr_76944_76970 = state_76938__$1;
(statearr_76944_76970[(1)] = (8));

} else {
var statearr_76945_76971 = state_76938__$1;
(statearr_76945_76971[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76939 === (3))){
var inst_76936 = (state_76938[(2)]);
var state_76938__$1 = state_76938;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76938__$1,inst_76936);
} else {
if((state_val_76939 === (12))){
var state_76938__$1 = state_76938;
var statearr_76946_76972 = state_76938__$1;
(statearr_76946_76972[(2)] = null);

(statearr_76946_76972[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76939 === (2))){
var inst_76915 = (state_76938[(7)]);
var state_76938__$1 = state_76938;
if(cljs.core.truth_(inst_76915)){
var statearr_76947_76973 = state_76938__$1;
(statearr_76947_76973[(1)] = (4));

} else {
var statearr_76948_76974 = state_76938__$1;
(statearr_76948_76974[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76939 === (11))){
var inst_76929 = cljs.core.async.close_BANG_.call(null,ch);
var state_76938__$1 = state_76938;
var statearr_76949_76975 = state_76938__$1;
(statearr_76949_76975[(2)] = inst_76929);

(statearr_76949_76975[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76939 === (9))){
var state_76938__$1 = state_76938;
if(cljs.core.truth_(close_QMARK_)){
var statearr_76950_76976 = state_76938__$1;
(statearr_76950_76976[(1)] = (11));

} else {
var statearr_76951_76977 = state_76938__$1;
(statearr_76951_76977[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76939 === (5))){
var inst_76915 = (state_76938[(7)]);
var state_76938__$1 = state_76938;
var statearr_76952_76978 = state_76938__$1;
(statearr_76952_76978[(2)] = inst_76915);

(statearr_76952_76978[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76939 === (10))){
var inst_76934 = (state_76938[(2)]);
var state_76938__$1 = state_76938;
var statearr_76953_76979 = state_76938__$1;
(statearr_76953_76979[(2)] = inst_76934);

(statearr_76953_76979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76939 === (8))){
var inst_76915 = (state_76938[(7)]);
var inst_76925 = cljs.core.next.call(null,inst_76915);
var inst_76915__$1 = inst_76925;
var state_76938__$1 = (function (){var statearr_76954 = state_76938;
(statearr_76954[(7)] = inst_76915__$1);

return statearr_76954;
})();
var statearr_76955_76980 = state_76938__$1;
(statearr_76955_76980[(2)] = null);

(statearr_76955_76980[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto__))
;
return ((function (switch__38343__auto__,c__38457__auto__){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_76959 = [null,null,null,null,null,null,null,null];
(statearr_76959[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_76959[(1)] = (1));

return statearr_76959;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_76938){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_76938);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e76960){if((e76960 instanceof Object)){
var ex__38347__auto__ = e76960;
var statearr_76961_76981 = state_76938;
(statearr_76961_76981[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_76938);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e76960;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76982 = state_76938;
state_76938 = G__76982;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_76938){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_76938);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__))
})();
var state__38459__auto__ = (function (){var statearr_76962 = f__38458__auto__.call(null);
(statearr_76962[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_76962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__))
);

return c__38457__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__10137__auto__ = (((_ == null))?null:_);
var m__10138__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,_);
} else {
var m__10138__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async77208 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async77208 = (function (ch,cs,meta77209){
this.ch = ch;
this.cs = cs;
this.meta77209 = meta77209;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async77208.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_77210,meta77209__$1){
var self__ = this;
var _77210__$1 = this;
return (new cljs.core.async.t_cljs$core$async77208(self__.ch,self__.cs,meta77209__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async77208.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_77210){
var self__ = this;
var _77210__$1 = this;
return self__.meta77209;
});})(cs))
;

cljs.core.async.t_cljs$core$async77208.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async77208.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async77208.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async77208.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async77208.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async77208.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async77208.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta77209","meta77209",195298890,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async77208.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async77208.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async77208";

cljs.core.async.t_cljs$core$async77208.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async77208");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async77208 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async77208(ch__$1,cs__$1,meta77209){
return (new cljs.core.async.t_cljs$core$async77208(ch__$1,cs__$1,meta77209));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async77208(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__38457__auto___77433 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___77433,cs,m,dchan,dctr,done){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___77433,cs,m,dchan,dctr,done){
return (function (state_77345){
var state_val_77346 = (state_77345[(1)]);
if((state_val_77346 === (7))){
var inst_77341 = (state_77345[(2)]);
var state_77345__$1 = state_77345;
var statearr_77347_77434 = state_77345__$1;
(statearr_77347_77434[(2)] = inst_77341);

(statearr_77347_77434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (20))){
var inst_77244 = (state_77345[(7)]);
var inst_77256 = cljs.core.first.call(null,inst_77244);
var inst_77257 = cljs.core.nth.call(null,inst_77256,(0),null);
var inst_77258 = cljs.core.nth.call(null,inst_77256,(1),null);
var state_77345__$1 = (function (){var statearr_77348 = state_77345;
(statearr_77348[(8)] = inst_77257);

return statearr_77348;
})();
if(cljs.core.truth_(inst_77258)){
var statearr_77349_77435 = state_77345__$1;
(statearr_77349_77435[(1)] = (22));

} else {
var statearr_77350_77436 = state_77345__$1;
(statearr_77350_77436[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (27))){
var inst_77286 = (state_77345[(9)]);
var inst_77293 = (state_77345[(10)]);
var inst_77213 = (state_77345[(11)]);
var inst_77288 = (state_77345[(12)]);
var inst_77293__$1 = cljs.core._nth.call(null,inst_77286,inst_77288);
var inst_77294 = cljs.core.async.put_BANG_.call(null,inst_77293__$1,inst_77213,done);
var state_77345__$1 = (function (){var statearr_77351 = state_77345;
(statearr_77351[(10)] = inst_77293__$1);

return statearr_77351;
})();
if(cljs.core.truth_(inst_77294)){
var statearr_77352_77437 = state_77345__$1;
(statearr_77352_77437[(1)] = (30));

} else {
var statearr_77353_77438 = state_77345__$1;
(statearr_77353_77438[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (1))){
var state_77345__$1 = state_77345;
var statearr_77354_77439 = state_77345__$1;
(statearr_77354_77439[(2)] = null);

(statearr_77354_77439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (24))){
var inst_77244 = (state_77345[(7)]);
var inst_77263 = (state_77345[(2)]);
var inst_77264 = cljs.core.next.call(null,inst_77244);
var inst_77222 = inst_77264;
var inst_77223 = null;
var inst_77224 = (0);
var inst_77225 = (0);
var state_77345__$1 = (function (){var statearr_77355 = state_77345;
(statearr_77355[(13)] = inst_77223);

(statearr_77355[(14)] = inst_77263);

(statearr_77355[(15)] = inst_77225);

(statearr_77355[(16)] = inst_77222);

(statearr_77355[(17)] = inst_77224);

return statearr_77355;
})();
var statearr_77356_77440 = state_77345__$1;
(statearr_77356_77440[(2)] = null);

(statearr_77356_77440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (39))){
var state_77345__$1 = state_77345;
var statearr_77360_77441 = state_77345__$1;
(statearr_77360_77441[(2)] = null);

(statearr_77360_77441[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (4))){
var inst_77213 = (state_77345[(11)]);
var inst_77213__$1 = (state_77345[(2)]);
var inst_77214 = (inst_77213__$1 == null);
var state_77345__$1 = (function (){var statearr_77361 = state_77345;
(statearr_77361[(11)] = inst_77213__$1);

return statearr_77361;
})();
if(cljs.core.truth_(inst_77214)){
var statearr_77362_77442 = state_77345__$1;
(statearr_77362_77442[(1)] = (5));

} else {
var statearr_77363_77443 = state_77345__$1;
(statearr_77363_77443[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (15))){
var inst_77223 = (state_77345[(13)]);
var inst_77225 = (state_77345[(15)]);
var inst_77222 = (state_77345[(16)]);
var inst_77224 = (state_77345[(17)]);
var inst_77240 = (state_77345[(2)]);
var inst_77241 = (inst_77225 + (1));
var tmp77357 = inst_77223;
var tmp77358 = inst_77222;
var tmp77359 = inst_77224;
var inst_77222__$1 = tmp77358;
var inst_77223__$1 = tmp77357;
var inst_77224__$1 = tmp77359;
var inst_77225__$1 = inst_77241;
var state_77345__$1 = (function (){var statearr_77364 = state_77345;
(statearr_77364[(13)] = inst_77223__$1);

(statearr_77364[(18)] = inst_77240);

(statearr_77364[(15)] = inst_77225__$1);

(statearr_77364[(16)] = inst_77222__$1);

(statearr_77364[(17)] = inst_77224__$1);

return statearr_77364;
})();
var statearr_77365_77444 = state_77345__$1;
(statearr_77365_77444[(2)] = null);

(statearr_77365_77444[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (21))){
var inst_77267 = (state_77345[(2)]);
var state_77345__$1 = state_77345;
var statearr_77369_77445 = state_77345__$1;
(statearr_77369_77445[(2)] = inst_77267);

(statearr_77369_77445[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (31))){
var inst_77293 = (state_77345[(10)]);
var inst_77297 = done.call(null,null);
var inst_77298 = cljs.core.async.untap_STAR_.call(null,m,inst_77293);
var state_77345__$1 = (function (){var statearr_77370 = state_77345;
(statearr_77370[(19)] = inst_77297);

return statearr_77370;
})();
var statearr_77371_77446 = state_77345__$1;
(statearr_77371_77446[(2)] = inst_77298);

(statearr_77371_77446[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (32))){
var inst_77286 = (state_77345[(9)]);
var inst_77287 = (state_77345[(20)]);
var inst_77285 = (state_77345[(21)]);
var inst_77288 = (state_77345[(12)]);
var inst_77300 = (state_77345[(2)]);
var inst_77301 = (inst_77288 + (1));
var tmp77366 = inst_77286;
var tmp77367 = inst_77287;
var tmp77368 = inst_77285;
var inst_77285__$1 = tmp77368;
var inst_77286__$1 = tmp77366;
var inst_77287__$1 = tmp77367;
var inst_77288__$1 = inst_77301;
var state_77345__$1 = (function (){var statearr_77372 = state_77345;
(statearr_77372[(9)] = inst_77286__$1);

(statearr_77372[(20)] = inst_77287__$1);

(statearr_77372[(22)] = inst_77300);

(statearr_77372[(21)] = inst_77285__$1);

(statearr_77372[(12)] = inst_77288__$1);

return statearr_77372;
})();
var statearr_77373_77447 = state_77345__$1;
(statearr_77373_77447[(2)] = null);

(statearr_77373_77447[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (40))){
var inst_77313 = (state_77345[(23)]);
var inst_77317 = done.call(null,null);
var inst_77318 = cljs.core.async.untap_STAR_.call(null,m,inst_77313);
var state_77345__$1 = (function (){var statearr_77374 = state_77345;
(statearr_77374[(24)] = inst_77317);

return statearr_77374;
})();
var statearr_77375_77448 = state_77345__$1;
(statearr_77375_77448[(2)] = inst_77318);

(statearr_77375_77448[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (33))){
var inst_77304 = (state_77345[(25)]);
var inst_77306 = cljs.core.chunked_seq_QMARK_.call(null,inst_77304);
var state_77345__$1 = state_77345;
if(inst_77306){
var statearr_77376_77449 = state_77345__$1;
(statearr_77376_77449[(1)] = (36));

} else {
var statearr_77377_77450 = state_77345__$1;
(statearr_77377_77450[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (13))){
var inst_77234 = (state_77345[(26)]);
var inst_77237 = cljs.core.async.close_BANG_.call(null,inst_77234);
var state_77345__$1 = state_77345;
var statearr_77378_77451 = state_77345__$1;
(statearr_77378_77451[(2)] = inst_77237);

(statearr_77378_77451[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (22))){
var inst_77257 = (state_77345[(8)]);
var inst_77260 = cljs.core.async.close_BANG_.call(null,inst_77257);
var state_77345__$1 = state_77345;
var statearr_77379_77452 = state_77345__$1;
(statearr_77379_77452[(2)] = inst_77260);

(statearr_77379_77452[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (36))){
var inst_77304 = (state_77345[(25)]);
var inst_77308 = cljs.core.chunk_first.call(null,inst_77304);
var inst_77309 = cljs.core.chunk_rest.call(null,inst_77304);
var inst_77310 = cljs.core.count.call(null,inst_77308);
var inst_77285 = inst_77309;
var inst_77286 = inst_77308;
var inst_77287 = inst_77310;
var inst_77288 = (0);
var state_77345__$1 = (function (){var statearr_77380 = state_77345;
(statearr_77380[(9)] = inst_77286);

(statearr_77380[(20)] = inst_77287);

(statearr_77380[(21)] = inst_77285);

(statearr_77380[(12)] = inst_77288);

return statearr_77380;
})();
var statearr_77381_77453 = state_77345__$1;
(statearr_77381_77453[(2)] = null);

(statearr_77381_77453[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (41))){
var inst_77304 = (state_77345[(25)]);
var inst_77320 = (state_77345[(2)]);
var inst_77321 = cljs.core.next.call(null,inst_77304);
var inst_77285 = inst_77321;
var inst_77286 = null;
var inst_77287 = (0);
var inst_77288 = (0);
var state_77345__$1 = (function (){var statearr_77382 = state_77345;
(statearr_77382[(27)] = inst_77320);

(statearr_77382[(9)] = inst_77286);

(statearr_77382[(20)] = inst_77287);

(statearr_77382[(21)] = inst_77285);

(statearr_77382[(12)] = inst_77288);

return statearr_77382;
})();
var statearr_77383_77454 = state_77345__$1;
(statearr_77383_77454[(2)] = null);

(statearr_77383_77454[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (43))){
var state_77345__$1 = state_77345;
var statearr_77384_77455 = state_77345__$1;
(statearr_77384_77455[(2)] = null);

(statearr_77384_77455[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (29))){
var inst_77329 = (state_77345[(2)]);
var state_77345__$1 = state_77345;
var statearr_77385_77456 = state_77345__$1;
(statearr_77385_77456[(2)] = inst_77329);

(statearr_77385_77456[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (44))){
var inst_77338 = (state_77345[(2)]);
var state_77345__$1 = (function (){var statearr_77386 = state_77345;
(statearr_77386[(28)] = inst_77338);

return statearr_77386;
})();
var statearr_77387_77457 = state_77345__$1;
(statearr_77387_77457[(2)] = null);

(statearr_77387_77457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (6))){
var inst_77277 = (state_77345[(29)]);
var inst_77276 = cljs.core.deref.call(null,cs);
var inst_77277__$1 = cljs.core.keys.call(null,inst_77276);
var inst_77278 = cljs.core.count.call(null,inst_77277__$1);
var inst_77279 = cljs.core.reset_BANG_.call(null,dctr,inst_77278);
var inst_77284 = cljs.core.seq.call(null,inst_77277__$1);
var inst_77285 = inst_77284;
var inst_77286 = null;
var inst_77287 = (0);
var inst_77288 = (0);
var state_77345__$1 = (function (){var statearr_77388 = state_77345;
(statearr_77388[(29)] = inst_77277__$1);

(statearr_77388[(9)] = inst_77286);

(statearr_77388[(20)] = inst_77287);

(statearr_77388[(30)] = inst_77279);

(statearr_77388[(21)] = inst_77285);

(statearr_77388[(12)] = inst_77288);

return statearr_77388;
})();
var statearr_77389_77458 = state_77345__$1;
(statearr_77389_77458[(2)] = null);

(statearr_77389_77458[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (28))){
var inst_77304 = (state_77345[(25)]);
var inst_77285 = (state_77345[(21)]);
var inst_77304__$1 = cljs.core.seq.call(null,inst_77285);
var state_77345__$1 = (function (){var statearr_77390 = state_77345;
(statearr_77390[(25)] = inst_77304__$1);

return statearr_77390;
})();
if(inst_77304__$1){
var statearr_77391_77459 = state_77345__$1;
(statearr_77391_77459[(1)] = (33));

} else {
var statearr_77392_77460 = state_77345__$1;
(statearr_77392_77460[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (25))){
var inst_77287 = (state_77345[(20)]);
var inst_77288 = (state_77345[(12)]);
var inst_77290 = (inst_77288 < inst_77287);
var inst_77291 = inst_77290;
var state_77345__$1 = state_77345;
if(cljs.core.truth_(inst_77291)){
var statearr_77393_77461 = state_77345__$1;
(statearr_77393_77461[(1)] = (27));

} else {
var statearr_77394_77462 = state_77345__$1;
(statearr_77394_77462[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (34))){
var state_77345__$1 = state_77345;
var statearr_77395_77463 = state_77345__$1;
(statearr_77395_77463[(2)] = null);

(statearr_77395_77463[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (17))){
var state_77345__$1 = state_77345;
var statearr_77396_77464 = state_77345__$1;
(statearr_77396_77464[(2)] = null);

(statearr_77396_77464[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (3))){
var inst_77343 = (state_77345[(2)]);
var state_77345__$1 = state_77345;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77345__$1,inst_77343);
} else {
if((state_val_77346 === (12))){
var inst_77272 = (state_77345[(2)]);
var state_77345__$1 = state_77345;
var statearr_77397_77465 = state_77345__$1;
(statearr_77397_77465[(2)] = inst_77272);

(statearr_77397_77465[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (2))){
var state_77345__$1 = state_77345;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77345__$1,(4),ch);
} else {
if((state_val_77346 === (23))){
var state_77345__$1 = state_77345;
var statearr_77398_77466 = state_77345__$1;
(statearr_77398_77466[(2)] = null);

(statearr_77398_77466[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (35))){
var inst_77327 = (state_77345[(2)]);
var state_77345__$1 = state_77345;
var statearr_77399_77467 = state_77345__$1;
(statearr_77399_77467[(2)] = inst_77327);

(statearr_77399_77467[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (19))){
var inst_77244 = (state_77345[(7)]);
var inst_77248 = cljs.core.chunk_first.call(null,inst_77244);
var inst_77249 = cljs.core.chunk_rest.call(null,inst_77244);
var inst_77250 = cljs.core.count.call(null,inst_77248);
var inst_77222 = inst_77249;
var inst_77223 = inst_77248;
var inst_77224 = inst_77250;
var inst_77225 = (0);
var state_77345__$1 = (function (){var statearr_77400 = state_77345;
(statearr_77400[(13)] = inst_77223);

(statearr_77400[(15)] = inst_77225);

(statearr_77400[(16)] = inst_77222);

(statearr_77400[(17)] = inst_77224);

return statearr_77400;
})();
var statearr_77401_77468 = state_77345__$1;
(statearr_77401_77468[(2)] = null);

(statearr_77401_77468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (11))){
var inst_77244 = (state_77345[(7)]);
var inst_77222 = (state_77345[(16)]);
var inst_77244__$1 = cljs.core.seq.call(null,inst_77222);
var state_77345__$1 = (function (){var statearr_77402 = state_77345;
(statearr_77402[(7)] = inst_77244__$1);

return statearr_77402;
})();
if(inst_77244__$1){
var statearr_77403_77469 = state_77345__$1;
(statearr_77403_77469[(1)] = (16));

} else {
var statearr_77404_77470 = state_77345__$1;
(statearr_77404_77470[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (9))){
var inst_77274 = (state_77345[(2)]);
var state_77345__$1 = state_77345;
var statearr_77405_77471 = state_77345__$1;
(statearr_77405_77471[(2)] = inst_77274);

(statearr_77405_77471[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (5))){
var inst_77220 = cljs.core.deref.call(null,cs);
var inst_77221 = cljs.core.seq.call(null,inst_77220);
var inst_77222 = inst_77221;
var inst_77223 = null;
var inst_77224 = (0);
var inst_77225 = (0);
var state_77345__$1 = (function (){var statearr_77406 = state_77345;
(statearr_77406[(13)] = inst_77223);

(statearr_77406[(15)] = inst_77225);

(statearr_77406[(16)] = inst_77222);

(statearr_77406[(17)] = inst_77224);

return statearr_77406;
})();
var statearr_77407_77472 = state_77345__$1;
(statearr_77407_77472[(2)] = null);

(statearr_77407_77472[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (14))){
var state_77345__$1 = state_77345;
var statearr_77408_77473 = state_77345__$1;
(statearr_77408_77473[(2)] = null);

(statearr_77408_77473[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (45))){
var inst_77335 = (state_77345[(2)]);
var state_77345__$1 = state_77345;
var statearr_77409_77474 = state_77345__$1;
(statearr_77409_77474[(2)] = inst_77335);

(statearr_77409_77474[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (26))){
var inst_77277 = (state_77345[(29)]);
var inst_77331 = (state_77345[(2)]);
var inst_77332 = cljs.core.seq.call(null,inst_77277);
var state_77345__$1 = (function (){var statearr_77410 = state_77345;
(statearr_77410[(31)] = inst_77331);

return statearr_77410;
})();
if(inst_77332){
var statearr_77411_77475 = state_77345__$1;
(statearr_77411_77475[(1)] = (42));

} else {
var statearr_77412_77476 = state_77345__$1;
(statearr_77412_77476[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (16))){
var inst_77244 = (state_77345[(7)]);
var inst_77246 = cljs.core.chunked_seq_QMARK_.call(null,inst_77244);
var state_77345__$1 = state_77345;
if(inst_77246){
var statearr_77413_77477 = state_77345__$1;
(statearr_77413_77477[(1)] = (19));

} else {
var statearr_77414_77478 = state_77345__$1;
(statearr_77414_77478[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (38))){
var inst_77324 = (state_77345[(2)]);
var state_77345__$1 = state_77345;
var statearr_77415_77479 = state_77345__$1;
(statearr_77415_77479[(2)] = inst_77324);

(statearr_77415_77479[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (30))){
var state_77345__$1 = state_77345;
var statearr_77416_77480 = state_77345__$1;
(statearr_77416_77480[(2)] = null);

(statearr_77416_77480[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (10))){
var inst_77223 = (state_77345[(13)]);
var inst_77225 = (state_77345[(15)]);
var inst_77233 = cljs.core._nth.call(null,inst_77223,inst_77225);
var inst_77234 = cljs.core.nth.call(null,inst_77233,(0),null);
var inst_77235 = cljs.core.nth.call(null,inst_77233,(1),null);
var state_77345__$1 = (function (){var statearr_77417 = state_77345;
(statearr_77417[(26)] = inst_77234);

return statearr_77417;
})();
if(cljs.core.truth_(inst_77235)){
var statearr_77418_77481 = state_77345__$1;
(statearr_77418_77481[(1)] = (13));

} else {
var statearr_77419_77482 = state_77345__$1;
(statearr_77419_77482[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (18))){
var inst_77270 = (state_77345[(2)]);
var state_77345__$1 = state_77345;
var statearr_77420_77483 = state_77345__$1;
(statearr_77420_77483[(2)] = inst_77270);

(statearr_77420_77483[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (42))){
var state_77345__$1 = state_77345;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77345__$1,(45),dchan);
} else {
if((state_val_77346 === (37))){
var inst_77313 = (state_77345[(23)]);
var inst_77304 = (state_77345[(25)]);
var inst_77213 = (state_77345[(11)]);
var inst_77313__$1 = cljs.core.first.call(null,inst_77304);
var inst_77314 = cljs.core.async.put_BANG_.call(null,inst_77313__$1,inst_77213,done);
var state_77345__$1 = (function (){var statearr_77421 = state_77345;
(statearr_77421[(23)] = inst_77313__$1);

return statearr_77421;
})();
if(cljs.core.truth_(inst_77314)){
var statearr_77422_77484 = state_77345__$1;
(statearr_77422_77484[(1)] = (39));

} else {
var statearr_77423_77485 = state_77345__$1;
(statearr_77423_77485[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77346 === (8))){
var inst_77225 = (state_77345[(15)]);
var inst_77224 = (state_77345[(17)]);
var inst_77227 = (inst_77225 < inst_77224);
var inst_77228 = inst_77227;
var state_77345__$1 = state_77345;
if(cljs.core.truth_(inst_77228)){
var statearr_77424_77486 = state_77345__$1;
(statearr_77424_77486[(1)] = (10));

} else {
var statearr_77425_77487 = state_77345__$1;
(statearr_77425_77487[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___77433,cs,m,dchan,dctr,done))
;
return ((function (switch__38343__auto__,c__38457__auto___77433,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__38344__auto__ = null;
var cljs$core$async$mult_$_state_machine__38344__auto____0 = (function (){
var statearr_77429 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77429[(0)] = cljs$core$async$mult_$_state_machine__38344__auto__);

(statearr_77429[(1)] = (1));

return statearr_77429;
});
var cljs$core$async$mult_$_state_machine__38344__auto____1 = (function (state_77345){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_77345);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e77430){if((e77430 instanceof Object)){
var ex__38347__auto__ = e77430;
var statearr_77431_77488 = state_77345;
(statearr_77431_77488[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_77345);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e77430;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77489 = state_77345;
state_77345 = G__77489;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__38344__auto__ = function(state_77345){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__38344__auto____1.call(this,state_77345);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__38344__auto____0;
cljs$core$async$mult_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__38344__auto____1;
return cljs$core$async$mult_$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___77433,cs,m,dchan,dctr,done))
})();
var state__38459__auto__ = (function (){var statearr_77432 = f__38458__auto__.call(null);
(statearr_77432[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___77433);

return statearr_77432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___77433,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args77490 = [];
var len__10640__auto___77493 = arguments.length;
var i__10641__auto___77494 = (0);
while(true){
if((i__10641__auto___77494 < len__10640__auto___77493)){
args77490.push((arguments[i__10641__auto___77494]));

var G__77495 = (i__10641__auto___77494 + (1));
i__10641__auto___77494 = G__77495;
continue;
} else {
}
break;
}

var G__77492 = args77490.length;
switch (G__77492) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args77490.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m);
} else {
var m__10138__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,state_map);
} else {
var m__10138__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__10137__auto__ = (((m == null))?null:m);
var m__10138__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,m,mode);
} else {
var m__10138__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__10647__auto__ = [];
var len__10640__auto___77507 = arguments.length;
var i__10641__auto___77508 = (0);
while(true){
if((i__10641__auto___77508 < len__10640__auto___77507)){
args__10647__auto__.push((arguments[i__10641__auto___77508]));

var G__77509 = (i__10641__auto___77508 + (1));
i__10641__auto___77508 = G__77509;
continue;
} else {
}
break;
}

var argseq__10648__auto__ = ((((3) < args__10647__auto__.length))?(new cljs.core.IndexedSeq(args__10647__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__10648__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__77501){
var map__77502 = p__77501;
var map__77502__$1 = ((((!((map__77502 == null)))?((((map__77502.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__77502.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__77502):map__77502);
var opts = map__77502__$1;
var statearr_77504_77510 = state;
(statearr_77504_77510[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6738__auto__ = cljs.core.async.do_alts.call(null,((function (map__77502,map__77502__$1,opts){
return (function (val){
var statearr_77505_77511 = state;
(statearr_77505_77511[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__77502,map__77502__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6738__auto__)){
var cb = temp__6738__auto__;
var statearr_77506_77512 = state;
(statearr_77506_77512[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq77497){
var G__77498 = cljs.core.first.call(null,seq77497);
var seq77497__$1 = cljs.core.next.call(null,seq77497);
var G__77499 = cljs.core.first.call(null,seq77497__$1);
var seq77497__$2 = cljs.core.next.call(null,seq77497__$1);
var G__77500 = cljs.core.first.call(null,seq77497__$2);
var seq77497__$3 = cljs.core.next.call(null,seq77497__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__77498,G__77499,G__77500,seq77497__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async77680 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async77680 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta77681){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta77681 = meta77681;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async77680.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_77682,meta77681__$1){
var self__ = this;
var _77682__$1 = this;
return (new cljs.core.async.t_cljs$core$async77680(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta77681__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77680.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_77682){
var self__ = this;
var _77682__$1 = this;
return self__.meta77681;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77680.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async77680.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77680.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async77680.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77680.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77680.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77680.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77680.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77680.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta77681","meta77681",-249025789,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async77680.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async77680.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async77680";

cljs.core.async.t_cljs$core$async77680.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async77680");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async77680 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async77680(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta77681){
return (new cljs.core.async.t_cljs$core$async77680(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta77681));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async77680(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38457__auto___77847 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___77847,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___77847,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_77784){
var state_val_77785 = (state_77784[(1)]);
if((state_val_77785 === (7))){
var inst_77699 = (state_77784[(2)]);
var state_77784__$1 = state_77784;
var statearr_77786_77848 = state_77784__$1;
(statearr_77786_77848[(2)] = inst_77699);

(statearr_77786_77848[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (20))){
var inst_77711 = (state_77784[(7)]);
var state_77784__$1 = state_77784;
var statearr_77787_77849 = state_77784__$1;
(statearr_77787_77849[(2)] = inst_77711);

(statearr_77787_77849[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (27))){
var state_77784__$1 = state_77784;
var statearr_77788_77850 = state_77784__$1;
(statearr_77788_77850[(2)] = null);

(statearr_77788_77850[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (1))){
var inst_77686 = (state_77784[(8)]);
var inst_77686__$1 = calc_state.call(null);
var inst_77688 = (inst_77686__$1 == null);
var inst_77689 = cljs.core.not.call(null,inst_77688);
var state_77784__$1 = (function (){var statearr_77789 = state_77784;
(statearr_77789[(8)] = inst_77686__$1);

return statearr_77789;
})();
if(inst_77689){
var statearr_77790_77851 = state_77784__$1;
(statearr_77790_77851[(1)] = (2));

} else {
var statearr_77791_77852 = state_77784__$1;
(statearr_77791_77852[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (24))){
var inst_77744 = (state_77784[(9)]);
var inst_77735 = (state_77784[(10)]);
var inst_77758 = (state_77784[(11)]);
var inst_77758__$1 = inst_77735.call(null,inst_77744);
var state_77784__$1 = (function (){var statearr_77792 = state_77784;
(statearr_77792[(11)] = inst_77758__$1);

return statearr_77792;
})();
if(cljs.core.truth_(inst_77758__$1)){
var statearr_77793_77853 = state_77784__$1;
(statearr_77793_77853[(1)] = (29));

} else {
var statearr_77794_77854 = state_77784__$1;
(statearr_77794_77854[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (4))){
var inst_77702 = (state_77784[(2)]);
var state_77784__$1 = state_77784;
if(cljs.core.truth_(inst_77702)){
var statearr_77795_77855 = state_77784__$1;
(statearr_77795_77855[(1)] = (8));

} else {
var statearr_77796_77856 = state_77784__$1;
(statearr_77796_77856[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (15))){
var inst_77729 = (state_77784[(2)]);
var state_77784__$1 = state_77784;
if(cljs.core.truth_(inst_77729)){
var statearr_77797_77857 = state_77784__$1;
(statearr_77797_77857[(1)] = (19));

} else {
var statearr_77798_77858 = state_77784__$1;
(statearr_77798_77858[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (21))){
var inst_77734 = (state_77784[(12)]);
var inst_77734__$1 = (state_77784[(2)]);
var inst_77735 = cljs.core.get.call(null,inst_77734__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_77736 = cljs.core.get.call(null,inst_77734__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_77737 = cljs.core.get.call(null,inst_77734__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_77784__$1 = (function (){var statearr_77799 = state_77784;
(statearr_77799[(13)] = inst_77736);

(statearr_77799[(12)] = inst_77734__$1);

(statearr_77799[(10)] = inst_77735);

return statearr_77799;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_77784__$1,(22),inst_77737);
} else {
if((state_val_77785 === (31))){
var inst_77766 = (state_77784[(2)]);
var state_77784__$1 = state_77784;
if(cljs.core.truth_(inst_77766)){
var statearr_77800_77859 = state_77784__$1;
(statearr_77800_77859[(1)] = (32));

} else {
var statearr_77801_77860 = state_77784__$1;
(statearr_77801_77860[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (32))){
var inst_77743 = (state_77784[(14)]);
var state_77784__$1 = state_77784;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_77784__$1,(35),out,inst_77743);
} else {
if((state_val_77785 === (33))){
var inst_77734 = (state_77784[(12)]);
var inst_77711 = inst_77734;
var state_77784__$1 = (function (){var statearr_77802 = state_77784;
(statearr_77802[(7)] = inst_77711);

return statearr_77802;
})();
var statearr_77803_77861 = state_77784__$1;
(statearr_77803_77861[(2)] = null);

(statearr_77803_77861[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (13))){
var inst_77711 = (state_77784[(7)]);
var inst_77718 = inst_77711.cljs$lang$protocol_mask$partition0$;
var inst_77719 = (inst_77718 & (64));
var inst_77720 = inst_77711.cljs$core$ISeq$;
var inst_77721 = (cljs.core.PROTOCOL_SENTINEL === inst_77720);
var inst_77722 = (inst_77719) || (inst_77721);
var state_77784__$1 = state_77784;
if(cljs.core.truth_(inst_77722)){
var statearr_77804_77862 = state_77784__$1;
(statearr_77804_77862[(1)] = (16));

} else {
var statearr_77805_77863 = state_77784__$1;
(statearr_77805_77863[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (22))){
var inst_77744 = (state_77784[(9)]);
var inst_77743 = (state_77784[(14)]);
var inst_77742 = (state_77784[(2)]);
var inst_77743__$1 = cljs.core.nth.call(null,inst_77742,(0),null);
var inst_77744__$1 = cljs.core.nth.call(null,inst_77742,(1),null);
var inst_77745 = (inst_77743__$1 == null);
var inst_77746 = cljs.core._EQ_.call(null,inst_77744__$1,change);
var inst_77747 = (inst_77745) || (inst_77746);
var state_77784__$1 = (function (){var statearr_77806 = state_77784;
(statearr_77806[(9)] = inst_77744__$1);

(statearr_77806[(14)] = inst_77743__$1);

return statearr_77806;
})();
if(cljs.core.truth_(inst_77747)){
var statearr_77807_77864 = state_77784__$1;
(statearr_77807_77864[(1)] = (23));

} else {
var statearr_77808_77865 = state_77784__$1;
(statearr_77808_77865[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (36))){
var inst_77734 = (state_77784[(12)]);
var inst_77711 = inst_77734;
var state_77784__$1 = (function (){var statearr_77809 = state_77784;
(statearr_77809[(7)] = inst_77711);

return statearr_77809;
})();
var statearr_77810_77866 = state_77784__$1;
(statearr_77810_77866[(2)] = null);

(statearr_77810_77866[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (29))){
var inst_77758 = (state_77784[(11)]);
var state_77784__$1 = state_77784;
var statearr_77811_77867 = state_77784__$1;
(statearr_77811_77867[(2)] = inst_77758);

(statearr_77811_77867[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (6))){
var state_77784__$1 = state_77784;
var statearr_77812_77868 = state_77784__$1;
(statearr_77812_77868[(2)] = false);

(statearr_77812_77868[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (28))){
var inst_77754 = (state_77784[(2)]);
var inst_77755 = calc_state.call(null);
var inst_77711 = inst_77755;
var state_77784__$1 = (function (){var statearr_77813 = state_77784;
(statearr_77813[(15)] = inst_77754);

(statearr_77813[(7)] = inst_77711);

return statearr_77813;
})();
var statearr_77814_77869 = state_77784__$1;
(statearr_77814_77869[(2)] = null);

(statearr_77814_77869[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (25))){
var inst_77780 = (state_77784[(2)]);
var state_77784__$1 = state_77784;
var statearr_77815_77870 = state_77784__$1;
(statearr_77815_77870[(2)] = inst_77780);

(statearr_77815_77870[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (34))){
var inst_77778 = (state_77784[(2)]);
var state_77784__$1 = state_77784;
var statearr_77816_77871 = state_77784__$1;
(statearr_77816_77871[(2)] = inst_77778);

(statearr_77816_77871[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (17))){
var state_77784__$1 = state_77784;
var statearr_77817_77872 = state_77784__$1;
(statearr_77817_77872[(2)] = false);

(statearr_77817_77872[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (3))){
var state_77784__$1 = state_77784;
var statearr_77818_77873 = state_77784__$1;
(statearr_77818_77873[(2)] = false);

(statearr_77818_77873[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (12))){
var inst_77782 = (state_77784[(2)]);
var state_77784__$1 = state_77784;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77784__$1,inst_77782);
} else {
if((state_val_77785 === (2))){
var inst_77686 = (state_77784[(8)]);
var inst_77691 = inst_77686.cljs$lang$protocol_mask$partition0$;
var inst_77692 = (inst_77691 & (64));
var inst_77693 = inst_77686.cljs$core$ISeq$;
var inst_77694 = (cljs.core.PROTOCOL_SENTINEL === inst_77693);
var inst_77695 = (inst_77692) || (inst_77694);
var state_77784__$1 = state_77784;
if(cljs.core.truth_(inst_77695)){
var statearr_77819_77874 = state_77784__$1;
(statearr_77819_77874[(1)] = (5));

} else {
var statearr_77820_77875 = state_77784__$1;
(statearr_77820_77875[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (23))){
var inst_77743 = (state_77784[(14)]);
var inst_77749 = (inst_77743 == null);
var state_77784__$1 = state_77784;
if(cljs.core.truth_(inst_77749)){
var statearr_77821_77876 = state_77784__$1;
(statearr_77821_77876[(1)] = (26));

} else {
var statearr_77822_77877 = state_77784__$1;
(statearr_77822_77877[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (35))){
var inst_77769 = (state_77784[(2)]);
var state_77784__$1 = state_77784;
if(cljs.core.truth_(inst_77769)){
var statearr_77823_77878 = state_77784__$1;
(statearr_77823_77878[(1)] = (36));

} else {
var statearr_77824_77879 = state_77784__$1;
(statearr_77824_77879[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (19))){
var inst_77711 = (state_77784[(7)]);
var inst_77731 = cljs.core.apply.call(null,cljs.core.hash_map,inst_77711);
var state_77784__$1 = state_77784;
var statearr_77825_77880 = state_77784__$1;
(statearr_77825_77880[(2)] = inst_77731);

(statearr_77825_77880[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (11))){
var inst_77711 = (state_77784[(7)]);
var inst_77715 = (inst_77711 == null);
var inst_77716 = cljs.core.not.call(null,inst_77715);
var state_77784__$1 = state_77784;
if(inst_77716){
var statearr_77826_77881 = state_77784__$1;
(statearr_77826_77881[(1)] = (13));

} else {
var statearr_77827_77882 = state_77784__$1;
(statearr_77827_77882[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (9))){
var inst_77686 = (state_77784[(8)]);
var state_77784__$1 = state_77784;
var statearr_77828_77883 = state_77784__$1;
(statearr_77828_77883[(2)] = inst_77686);

(statearr_77828_77883[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (5))){
var state_77784__$1 = state_77784;
var statearr_77829_77884 = state_77784__$1;
(statearr_77829_77884[(2)] = true);

(statearr_77829_77884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (14))){
var state_77784__$1 = state_77784;
var statearr_77830_77885 = state_77784__$1;
(statearr_77830_77885[(2)] = false);

(statearr_77830_77885[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (26))){
var inst_77744 = (state_77784[(9)]);
var inst_77751 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_77744);
var state_77784__$1 = state_77784;
var statearr_77831_77886 = state_77784__$1;
(statearr_77831_77886[(2)] = inst_77751);

(statearr_77831_77886[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (16))){
var state_77784__$1 = state_77784;
var statearr_77832_77887 = state_77784__$1;
(statearr_77832_77887[(2)] = true);

(statearr_77832_77887[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (38))){
var inst_77774 = (state_77784[(2)]);
var state_77784__$1 = state_77784;
var statearr_77833_77888 = state_77784__$1;
(statearr_77833_77888[(2)] = inst_77774);

(statearr_77833_77888[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (30))){
var inst_77736 = (state_77784[(13)]);
var inst_77744 = (state_77784[(9)]);
var inst_77735 = (state_77784[(10)]);
var inst_77761 = cljs.core.empty_QMARK_.call(null,inst_77735);
var inst_77762 = inst_77736.call(null,inst_77744);
var inst_77763 = cljs.core.not.call(null,inst_77762);
var inst_77764 = (inst_77761) && (inst_77763);
var state_77784__$1 = state_77784;
var statearr_77834_77889 = state_77784__$1;
(statearr_77834_77889[(2)] = inst_77764);

(statearr_77834_77889[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (10))){
var inst_77686 = (state_77784[(8)]);
var inst_77707 = (state_77784[(2)]);
var inst_77708 = cljs.core.get.call(null,inst_77707,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_77709 = cljs.core.get.call(null,inst_77707,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_77710 = cljs.core.get.call(null,inst_77707,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_77711 = inst_77686;
var state_77784__$1 = (function (){var statearr_77835 = state_77784;
(statearr_77835[(16)] = inst_77708);

(statearr_77835[(17)] = inst_77709);

(statearr_77835[(7)] = inst_77711);

(statearr_77835[(18)] = inst_77710);

return statearr_77835;
})();
var statearr_77836_77890 = state_77784__$1;
(statearr_77836_77890[(2)] = null);

(statearr_77836_77890[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (18))){
var inst_77726 = (state_77784[(2)]);
var state_77784__$1 = state_77784;
var statearr_77837_77891 = state_77784__$1;
(statearr_77837_77891[(2)] = inst_77726);

(statearr_77837_77891[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (37))){
var state_77784__$1 = state_77784;
var statearr_77838_77892 = state_77784__$1;
(statearr_77838_77892[(2)] = null);

(statearr_77838_77892[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77785 === (8))){
var inst_77686 = (state_77784[(8)]);
var inst_77704 = cljs.core.apply.call(null,cljs.core.hash_map,inst_77686);
var state_77784__$1 = state_77784;
var statearr_77839_77893 = state_77784__$1;
(statearr_77839_77893[(2)] = inst_77704);

(statearr_77839_77893[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___77847,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__38343__auto__,c__38457__auto___77847,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__38344__auto__ = null;
var cljs$core$async$mix_$_state_machine__38344__auto____0 = (function (){
var statearr_77843 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77843[(0)] = cljs$core$async$mix_$_state_machine__38344__auto__);

(statearr_77843[(1)] = (1));

return statearr_77843;
});
var cljs$core$async$mix_$_state_machine__38344__auto____1 = (function (state_77784){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_77784);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e77844){if((e77844 instanceof Object)){
var ex__38347__auto__ = e77844;
var statearr_77845_77894 = state_77784;
(statearr_77845_77894[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_77784);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e77844;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77895 = state_77784;
state_77784 = G__77895;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__38344__auto__ = function(state_77784){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__38344__auto____1.call(this,state_77784);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__38344__auto____0;
cljs$core$async$mix_$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__38344__auto____1;
return cljs$core$async$mix_$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___77847,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__38459__auto__ = (function (){var statearr_77846 = f__38458__auto__.call(null);
(statearr_77846[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___77847);

return statearr_77846;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___77847,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__10138__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v,ch);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args77896 = [];
var len__10640__auto___77899 = arguments.length;
var i__10641__auto___77900 = (0);
while(true){
if((i__10641__auto___77900 < len__10640__auto___77899)){
args77896.push((arguments[i__10641__auto___77900]));

var G__77901 = (i__10641__auto___77900 + (1));
i__10641__auto___77900 = G__77901;
continue;
} else {
}
break;
}

var G__77898 = args77896.length;
switch (G__77898) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args77896.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__10137__auto__ = (((p == null))?null:p);
var m__10138__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__10137__auto__)]);
if(!((m__10138__auto__ == null))){
return m__10138__auto__.call(null,p,v);
} else {
var m__10138__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__10138__auto____$1 == null))){
return m__10138__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args77904 = [];
var len__10640__auto___78029 = arguments.length;
var i__10641__auto___78030 = (0);
while(true){
if((i__10641__auto___78030 < len__10640__auto___78029)){
args77904.push((arguments[i__10641__auto___78030]));

var G__78031 = (i__10641__auto___78030 + (1));
i__10641__auto___78030 = G__78031;
continue;
} else {
}
break;
}

var G__77906 = args77904.length;
switch (G__77906) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args77904.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__9419__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__9419__auto__)){
return or__9419__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__9419__auto__,mults){
return (function (p1__77903_SHARP_){
if(cljs.core.truth_(p1__77903_SHARP_.call(null,topic))){
return p1__77903_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__77903_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__9419__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async77907 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async77907 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta77908){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta77908 = meta77908;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async77907.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_77909,meta77908__$1){
var self__ = this;
var _77909__$1 = this;
return (new cljs.core.async.t_cljs$core$async77907(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta77908__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async77907.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_77909){
var self__ = this;
var _77909__$1 = this;
return self__.meta77908;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async77907.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async77907.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async77907.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async77907.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async77907.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6738__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6738__auto__)){
var m = temp__6738__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async77907.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async77907.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async77907.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta77908","meta77908",-77335468,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async77907.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async77907.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async77907";

cljs.core.async.t_cljs$core$async77907.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async77907");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async77907 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async77907(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta77908){
return (new cljs.core.async.t_cljs$core$async77907(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta77908));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async77907(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38457__auto___78033 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___78033,mults,ensure_mult,p){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___78033,mults,ensure_mult,p){
return (function (state_77981){
var state_val_77982 = (state_77981[(1)]);
if((state_val_77982 === (7))){
var inst_77977 = (state_77981[(2)]);
var state_77981__$1 = state_77981;
var statearr_77983_78034 = state_77981__$1;
(statearr_77983_78034[(2)] = inst_77977);

(statearr_77983_78034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (20))){
var state_77981__$1 = state_77981;
var statearr_77984_78035 = state_77981__$1;
(statearr_77984_78035[(2)] = null);

(statearr_77984_78035[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (1))){
var state_77981__$1 = state_77981;
var statearr_77985_78036 = state_77981__$1;
(statearr_77985_78036[(2)] = null);

(statearr_77985_78036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (24))){
var inst_77960 = (state_77981[(7)]);
var inst_77969 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_77960);
var state_77981__$1 = state_77981;
var statearr_77986_78037 = state_77981__$1;
(statearr_77986_78037[(2)] = inst_77969);

(statearr_77986_78037[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (4))){
var inst_77912 = (state_77981[(8)]);
var inst_77912__$1 = (state_77981[(2)]);
var inst_77913 = (inst_77912__$1 == null);
var state_77981__$1 = (function (){var statearr_77987 = state_77981;
(statearr_77987[(8)] = inst_77912__$1);

return statearr_77987;
})();
if(cljs.core.truth_(inst_77913)){
var statearr_77988_78038 = state_77981__$1;
(statearr_77988_78038[(1)] = (5));

} else {
var statearr_77989_78039 = state_77981__$1;
(statearr_77989_78039[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (15))){
var inst_77954 = (state_77981[(2)]);
var state_77981__$1 = state_77981;
var statearr_77990_78040 = state_77981__$1;
(statearr_77990_78040[(2)] = inst_77954);

(statearr_77990_78040[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (21))){
var inst_77974 = (state_77981[(2)]);
var state_77981__$1 = (function (){var statearr_77991 = state_77981;
(statearr_77991[(9)] = inst_77974);

return statearr_77991;
})();
var statearr_77992_78041 = state_77981__$1;
(statearr_77992_78041[(2)] = null);

(statearr_77992_78041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (13))){
var inst_77936 = (state_77981[(10)]);
var inst_77938 = cljs.core.chunked_seq_QMARK_.call(null,inst_77936);
var state_77981__$1 = state_77981;
if(inst_77938){
var statearr_77993_78042 = state_77981__$1;
(statearr_77993_78042[(1)] = (16));

} else {
var statearr_77994_78043 = state_77981__$1;
(statearr_77994_78043[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (22))){
var inst_77966 = (state_77981[(2)]);
var state_77981__$1 = state_77981;
if(cljs.core.truth_(inst_77966)){
var statearr_77995_78044 = state_77981__$1;
(statearr_77995_78044[(1)] = (23));

} else {
var statearr_77996_78045 = state_77981__$1;
(statearr_77996_78045[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (6))){
var inst_77962 = (state_77981[(11)]);
var inst_77960 = (state_77981[(7)]);
var inst_77912 = (state_77981[(8)]);
var inst_77960__$1 = topic_fn.call(null,inst_77912);
var inst_77961 = cljs.core.deref.call(null,mults);
var inst_77962__$1 = cljs.core.get.call(null,inst_77961,inst_77960__$1);
var state_77981__$1 = (function (){var statearr_77997 = state_77981;
(statearr_77997[(11)] = inst_77962__$1);

(statearr_77997[(7)] = inst_77960__$1);

return statearr_77997;
})();
if(cljs.core.truth_(inst_77962__$1)){
var statearr_77998_78046 = state_77981__$1;
(statearr_77998_78046[(1)] = (19));

} else {
var statearr_77999_78047 = state_77981__$1;
(statearr_77999_78047[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (25))){
var inst_77971 = (state_77981[(2)]);
var state_77981__$1 = state_77981;
var statearr_78000_78048 = state_77981__$1;
(statearr_78000_78048[(2)] = inst_77971);

(statearr_78000_78048[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (17))){
var inst_77936 = (state_77981[(10)]);
var inst_77945 = cljs.core.first.call(null,inst_77936);
var inst_77946 = cljs.core.async.muxch_STAR_.call(null,inst_77945);
var inst_77947 = cljs.core.async.close_BANG_.call(null,inst_77946);
var inst_77948 = cljs.core.next.call(null,inst_77936);
var inst_77922 = inst_77948;
var inst_77923 = null;
var inst_77924 = (0);
var inst_77925 = (0);
var state_77981__$1 = (function (){var statearr_78001 = state_77981;
(statearr_78001[(12)] = inst_77923);

(statearr_78001[(13)] = inst_77924);

(statearr_78001[(14)] = inst_77922);

(statearr_78001[(15)] = inst_77925);

(statearr_78001[(16)] = inst_77947);

return statearr_78001;
})();
var statearr_78002_78049 = state_77981__$1;
(statearr_78002_78049[(2)] = null);

(statearr_78002_78049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (3))){
var inst_77979 = (state_77981[(2)]);
var state_77981__$1 = state_77981;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77981__$1,inst_77979);
} else {
if((state_val_77982 === (12))){
var inst_77956 = (state_77981[(2)]);
var state_77981__$1 = state_77981;
var statearr_78003_78050 = state_77981__$1;
(statearr_78003_78050[(2)] = inst_77956);

(statearr_78003_78050[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (2))){
var state_77981__$1 = state_77981;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77981__$1,(4),ch);
} else {
if((state_val_77982 === (23))){
var state_77981__$1 = state_77981;
var statearr_78004_78051 = state_77981__$1;
(statearr_78004_78051[(2)] = null);

(statearr_78004_78051[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (19))){
var inst_77962 = (state_77981[(11)]);
var inst_77912 = (state_77981[(8)]);
var inst_77964 = cljs.core.async.muxch_STAR_.call(null,inst_77962);
var state_77981__$1 = state_77981;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_77981__$1,(22),inst_77964,inst_77912);
} else {
if((state_val_77982 === (11))){
var inst_77936 = (state_77981[(10)]);
var inst_77922 = (state_77981[(14)]);
var inst_77936__$1 = cljs.core.seq.call(null,inst_77922);
var state_77981__$1 = (function (){var statearr_78005 = state_77981;
(statearr_78005[(10)] = inst_77936__$1);

return statearr_78005;
})();
if(inst_77936__$1){
var statearr_78006_78052 = state_77981__$1;
(statearr_78006_78052[(1)] = (13));

} else {
var statearr_78007_78053 = state_77981__$1;
(statearr_78007_78053[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (9))){
var inst_77958 = (state_77981[(2)]);
var state_77981__$1 = state_77981;
var statearr_78008_78054 = state_77981__$1;
(statearr_78008_78054[(2)] = inst_77958);

(statearr_78008_78054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (5))){
var inst_77919 = cljs.core.deref.call(null,mults);
var inst_77920 = cljs.core.vals.call(null,inst_77919);
var inst_77921 = cljs.core.seq.call(null,inst_77920);
var inst_77922 = inst_77921;
var inst_77923 = null;
var inst_77924 = (0);
var inst_77925 = (0);
var state_77981__$1 = (function (){var statearr_78009 = state_77981;
(statearr_78009[(12)] = inst_77923);

(statearr_78009[(13)] = inst_77924);

(statearr_78009[(14)] = inst_77922);

(statearr_78009[(15)] = inst_77925);

return statearr_78009;
})();
var statearr_78010_78055 = state_77981__$1;
(statearr_78010_78055[(2)] = null);

(statearr_78010_78055[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (14))){
var state_77981__$1 = state_77981;
var statearr_78014_78056 = state_77981__$1;
(statearr_78014_78056[(2)] = null);

(statearr_78014_78056[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (16))){
var inst_77936 = (state_77981[(10)]);
var inst_77940 = cljs.core.chunk_first.call(null,inst_77936);
var inst_77941 = cljs.core.chunk_rest.call(null,inst_77936);
var inst_77942 = cljs.core.count.call(null,inst_77940);
var inst_77922 = inst_77941;
var inst_77923 = inst_77940;
var inst_77924 = inst_77942;
var inst_77925 = (0);
var state_77981__$1 = (function (){var statearr_78015 = state_77981;
(statearr_78015[(12)] = inst_77923);

(statearr_78015[(13)] = inst_77924);

(statearr_78015[(14)] = inst_77922);

(statearr_78015[(15)] = inst_77925);

return statearr_78015;
})();
var statearr_78016_78057 = state_77981__$1;
(statearr_78016_78057[(2)] = null);

(statearr_78016_78057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (10))){
var inst_77923 = (state_77981[(12)]);
var inst_77924 = (state_77981[(13)]);
var inst_77922 = (state_77981[(14)]);
var inst_77925 = (state_77981[(15)]);
var inst_77930 = cljs.core._nth.call(null,inst_77923,inst_77925);
var inst_77931 = cljs.core.async.muxch_STAR_.call(null,inst_77930);
var inst_77932 = cljs.core.async.close_BANG_.call(null,inst_77931);
var inst_77933 = (inst_77925 + (1));
var tmp78011 = inst_77923;
var tmp78012 = inst_77924;
var tmp78013 = inst_77922;
var inst_77922__$1 = tmp78013;
var inst_77923__$1 = tmp78011;
var inst_77924__$1 = tmp78012;
var inst_77925__$1 = inst_77933;
var state_77981__$1 = (function (){var statearr_78017 = state_77981;
(statearr_78017[(12)] = inst_77923__$1);

(statearr_78017[(13)] = inst_77924__$1);

(statearr_78017[(14)] = inst_77922__$1);

(statearr_78017[(17)] = inst_77932);

(statearr_78017[(15)] = inst_77925__$1);

return statearr_78017;
})();
var statearr_78018_78058 = state_77981__$1;
(statearr_78018_78058[(2)] = null);

(statearr_78018_78058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (18))){
var inst_77951 = (state_77981[(2)]);
var state_77981__$1 = state_77981;
var statearr_78019_78059 = state_77981__$1;
(statearr_78019_78059[(2)] = inst_77951);

(statearr_78019_78059[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77982 === (8))){
var inst_77924 = (state_77981[(13)]);
var inst_77925 = (state_77981[(15)]);
var inst_77927 = (inst_77925 < inst_77924);
var inst_77928 = inst_77927;
var state_77981__$1 = state_77981;
if(cljs.core.truth_(inst_77928)){
var statearr_78020_78060 = state_77981__$1;
(statearr_78020_78060[(1)] = (10));

} else {
var statearr_78021_78061 = state_77981__$1;
(statearr_78021_78061[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___78033,mults,ensure_mult,p))
;
return ((function (switch__38343__auto__,c__38457__auto___78033,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_78025 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78025[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_78025[(1)] = (1));

return statearr_78025;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_77981){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_77981);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e78026){if((e78026 instanceof Object)){
var ex__38347__auto__ = e78026;
var statearr_78027_78062 = state_77981;
(statearr_78027_78062[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_77981);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78026;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78063 = state_77981;
state_77981 = G__78063;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_77981){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_77981);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___78033,mults,ensure_mult,p))
})();
var state__38459__auto__ = (function (){var statearr_78028 = f__38458__auto__.call(null);
(statearr_78028[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___78033);

return statearr_78028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___78033,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args78064 = [];
var len__10640__auto___78067 = arguments.length;
var i__10641__auto___78068 = (0);
while(true){
if((i__10641__auto___78068 < len__10640__auto___78067)){
args78064.push((arguments[i__10641__auto___78068]));

var G__78069 = (i__10641__auto___78068 + (1));
i__10641__auto___78068 = G__78069;
continue;
} else {
}
break;
}

var G__78066 = args78064.length;
switch (G__78066) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78064.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args78071 = [];
var len__10640__auto___78074 = arguments.length;
var i__10641__auto___78075 = (0);
while(true){
if((i__10641__auto___78075 < len__10640__auto___78074)){
args78071.push((arguments[i__10641__auto___78075]));

var G__78076 = (i__10641__auto___78075 + (1));
i__10641__auto___78075 = G__78076;
continue;
} else {
}
break;
}

var G__78073 = args78071.length;
switch (G__78073) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78071.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args78078 = [];
var len__10640__auto___78149 = arguments.length;
var i__10641__auto___78150 = (0);
while(true){
if((i__10641__auto___78150 < len__10640__auto___78149)){
args78078.push((arguments[i__10641__auto___78150]));

var G__78151 = (i__10641__auto___78150 + (1));
i__10641__auto___78150 = G__78151;
continue;
} else {
}
break;
}

var G__78080 = args78078.length;
switch (G__78080) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78078.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__38457__auto___78153 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___78153,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___78153,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_78119){
var state_val_78120 = (state_78119[(1)]);
if((state_val_78120 === (7))){
var state_78119__$1 = state_78119;
var statearr_78121_78154 = state_78119__$1;
(statearr_78121_78154[(2)] = null);

(statearr_78121_78154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (1))){
var state_78119__$1 = state_78119;
var statearr_78122_78155 = state_78119__$1;
(statearr_78122_78155[(2)] = null);

(statearr_78122_78155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (4))){
var inst_78083 = (state_78119[(7)]);
var inst_78085 = (inst_78083 < cnt);
var state_78119__$1 = state_78119;
if(cljs.core.truth_(inst_78085)){
var statearr_78123_78156 = state_78119__$1;
(statearr_78123_78156[(1)] = (6));

} else {
var statearr_78124_78157 = state_78119__$1;
(statearr_78124_78157[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (15))){
var inst_78115 = (state_78119[(2)]);
var state_78119__$1 = state_78119;
var statearr_78125_78158 = state_78119__$1;
(statearr_78125_78158[(2)] = inst_78115);

(statearr_78125_78158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (13))){
var inst_78108 = cljs.core.async.close_BANG_.call(null,out);
var state_78119__$1 = state_78119;
var statearr_78126_78159 = state_78119__$1;
(statearr_78126_78159[(2)] = inst_78108);

(statearr_78126_78159[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (6))){
var state_78119__$1 = state_78119;
var statearr_78127_78160 = state_78119__$1;
(statearr_78127_78160[(2)] = null);

(statearr_78127_78160[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (3))){
var inst_78117 = (state_78119[(2)]);
var state_78119__$1 = state_78119;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78119__$1,inst_78117);
} else {
if((state_val_78120 === (12))){
var inst_78105 = (state_78119[(8)]);
var inst_78105__$1 = (state_78119[(2)]);
var inst_78106 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_78105__$1);
var state_78119__$1 = (function (){var statearr_78128 = state_78119;
(statearr_78128[(8)] = inst_78105__$1);

return statearr_78128;
})();
if(cljs.core.truth_(inst_78106)){
var statearr_78129_78161 = state_78119__$1;
(statearr_78129_78161[(1)] = (13));

} else {
var statearr_78130_78162 = state_78119__$1;
(statearr_78130_78162[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (2))){
var inst_78082 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_78083 = (0);
var state_78119__$1 = (function (){var statearr_78131 = state_78119;
(statearr_78131[(9)] = inst_78082);

(statearr_78131[(7)] = inst_78083);

return statearr_78131;
})();
var statearr_78132_78163 = state_78119__$1;
(statearr_78132_78163[(2)] = null);

(statearr_78132_78163[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (11))){
var inst_78083 = (state_78119[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_78119,(10),Object,null,(9));
var inst_78092 = chs__$1.call(null,inst_78083);
var inst_78093 = done.call(null,inst_78083);
var inst_78094 = cljs.core.async.take_BANG_.call(null,inst_78092,inst_78093);
var state_78119__$1 = state_78119;
var statearr_78133_78164 = state_78119__$1;
(statearr_78133_78164[(2)] = inst_78094);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78119__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (9))){
var inst_78083 = (state_78119[(7)]);
var inst_78096 = (state_78119[(2)]);
var inst_78097 = (inst_78083 + (1));
var inst_78083__$1 = inst_78097;
var state_78119__$1 = (function (){var statearr_78134 = state_78119;
(statearr_78134[(10)] = inst_78096);

(statearr_78134[(7)] = inst_78083__$1);

return statearr_78134;
})();
var statearr_78135_78165 = state_78119__$1;
(statearr_78135_78165[(2)] = null);

(statearr_78135_78165[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (5))){
var inst_78103 = (state_78119[(2)]);
var state_78119__$1 = (function (){var statearr_78136 = state_78119;
(statearr_78136[(11)] = inst_78103);

return statearr_78136;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78119__$1,(12),dchan);
} else {
if((state_val_78120 === (14))){
var inst_78105 = (state_78119[(8)]);
var inst_78110 = cljs.core.apply.call(null,f,inst_78105);
var state_78119__$1 = state_78119;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78119__$1,(16),out,inst_78110);
} else {
if((state_val_78120 === (16))){
var inst_78112 = (state_78119[(2)]);
var state_78119__$1 = (function (){var statearr_78137 = state_78119;
(statearr_78137[(12)] = inst_78112);

return statearr_78137;
})();
var statearr_78138_78166 = state_78119__$1;
(statearr_78138_78166[(2)] = null);

(statearr_78138_78166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (10))){
var inst_78087 = (state_78119[(2)]);
var inst_78088 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_78119__$1 = (function (){var statearr_78139 = state_78119;
(statearr_78139[(13)] = inst_78087);

return statearr_78139;
})();
var statearr_78140_78167 = state_78119__$1;
(statearr_78140_78167[(2)] = inst_78088);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78119__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78120 === (8))){
var inst_78101 = (state_78119[(2)]);
var state_78119__$1 = state_78119;
var statearr_78141_78168 = state_78119__$1;
(statearr_78141_78168[(2)] = inst_78101);

(statearr_78141_78168[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___78153,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__38343__auto__,c__38457__auto___78153,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_78145 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78145[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_78145[(1)] = (1));

return statearr_78145;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_78119){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_78119);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e78146){if((e78146 instanceof Object)){
var ex__38347__auto__ = e78146;
var statearr_78147_78169 = state_78119;
(statearr_78147_78169[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78119);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78146;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78170 = state_78119;
state_78119 = G__78170;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_78119){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_78119);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___78153,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__38459__auto__ = (function (){var statearr_78148 = f__38458__auto__.call(null);
(statearr_78148[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___78153);

return statearr_78148;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___78153,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args78172 = [];
var len__10640__auto___78230 = arguments.length;
var i__10641__auto___78231 = (0);
while(true){
if((i__10641__auto___78231 < len__10640__auto___78230)){
args78172.push((arguments[i__10641__auto___78231]));

var G__78232 = (i__10641__auto___78231 + (1));
i__10641__auto___78231 = G__78232;
continue;
} else {
}
break;
}

var G__78174 = args78172.length;
switch (G__78174) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78172.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___78234 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___78234,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___78234,out){
return (function (state_78206){
var state_val_78207 = (state_78206[(1)]);
if((state_val_78207 === (7))){
var inst_78186 = (state_78206[(7)]);
var inst_78185 = (state_78206[(8)]);
var inst_78185__$1 = (state_78206[(2)]);
var inst_78186__$1 = cljs.core.nth.call(null,inst_78185__$1,(0),null);
var inst_78187 = cljs.core.nth.call(null,inst_78185__$1,(1),null);
var inst_78188 = (inst_78186__$1 == null);
var state_78206__$1 = (function (){var statearr_78208 = state_78206;
(statearr_78208[(9)] = inst_78187);

(statearr_78208[(7)] = inst_78186__$1);

(statearr_78208[(8)] = inst_78185__$1);

return statearr_78208;
})();
if(cljs.core.truth_(inst_78188)){
var statearr_78209_78235 = state_78206__$1;
(statearr_78209_78235[(1)] = (8));

} else {
var statearr_78210_78236 = state_78206__$1;
(statearr_78210_78236[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78207 === (1))){
var inst_78175 = cljs.core.vec.call(null,chs);
var inst_78176 = inst_78175;
var state_78206__$1 = (function (){var statearr_78211 = state_78206;
(statearr_78211[(10)] = inst_78176);

return statearr_78211;
})();
var statearr_78212_78237 = state_78206__$1;
(statearr_78212_78237[(2)] = null);

(statearr_78212_78237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78207 === (4))){
var inst_78176 = (state_78206[(10)]);
var state_78206__$1 = state_78206;
return cljs.core.async.ioc_alts_BANG_.call(null,state_78206__$1,(7),inst_78176);
} else {
if((state_val_78207 === (6))){
var inst_78202 = (state_78206[(2)]);
var state_78206__$1 = state_78206;
var statearr_78213_78238 = state_78206__$1;
(statearr_78213_78238[(2)] = inst_78202);

(statearr_78213_78238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78207 === (3))){
var inst_78204 = (state_78206[(2)]);
var state_78206__$1 = state_78206;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78206__$1,inst_78204);
} else {
if((state_val_78207 === (2))){
var inst_78176 = (state_78206[(10)]);
var inst_78178 = cljs.core.count.call(null,inst_78176);
var inst_78179 = (inst_78178 > (0));
var state_78206__$1 = state_78206;
if(cljs.core.truth_(inst_78179)){
var statearr_78215_78239 = state_78206__$1;
(statearr_78215_78239[(1)] = (4));

} else {
var statearr_78216_78240 = state_78206__$1;
(statearr_78216_78240[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78207 === (11))){
var inst_78176 = (state_78206[(10)]);
var inst_78195 = (state_78206[(2)]);
var tmp78214 = inst_78176;
var inst_78176__$1 = tmp78214;
var state_78206__$1 = (function (){var statearr_78217 = state_78206;
(statearr_78217[(10)] = inst_78176__$1);

(statearr_78217[(11)] = inst_78195);

return statearr_78217;
})();
var statearr_78218_78241 = state_78206__$1;
(statearr_78218_78241[(2)] = null);

(statearr_78218_78241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78207 === (9))){
var inst_78186 = (state_78206[(7)]);
var state_78206__$1 = state_78206;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78206__$1,(11),out,inst_78186);
} else {
if((state_val_78207 === (5))){
var inst_78200 = cljs.core.async.close_BANG_.call(null,out);
var state_78206__$1 = state_78206;
var statearr_78219_78242 = state_78206__$1;
(statearr_78219_78242[(2)] = inst_78200);

(statearr_78219_78242[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78207 === (10))){
var inst_78198 = (state_78206[(2)]);
var state_78206__$1 = state_78206;
var statearr_78220_78243 = state_78206__$1;
(statearr_78220_78243[(2)] = inst_78198);

(statearr_78220_78243[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78207 === (8))){
var inst_78187 = (state_78206[(9)]);
var inst_78176 = (state_78206[(10)]);
var inst_78186 = (state_78206[(7)]);
var inst_78185 = (state_78206[(8)]);
var inst_78190 = (function (){var cs = inst_78176;
var vec__78181 = inst_78185;
var v = inst_78186;
var c = inst_78187;
return ((function (cs,vec__78181,v,c,inst_78187,inst_78176,inst_78186,inst_78185,state_val_78207,c__38457__auto___78234,out){
return (function (p1__78171_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__78171_SHARP_);
});
;})(cs,vec__78181,v,c,inst_78187,inst_78176,inst_78186,inst_78185,state_val_78207,c__38457__auto___78234,out))
})();
var inst_78191 = cljs.core.filterv.call(null,inst_78190,inst_78176);
var inst_78176__$1 = inst_78191;
var state_78206__$1 = (function (){var statearr_78221 = state_78206;
(statearr_78221[(10)] = inst_78176__$1);

return statearr_78221;
})();
var statearr_78222_78244 = state_78206__$1;
(statearr_78222_78244[(2)] = null);

(statearr_78222_78244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___78234,out))
;
return ((function (switch__38343__auto__,c__38457__auto___78234,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_78226 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78226[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_78226[(1)] = (1));

return statearr_78226;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_78206){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_78206);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e78227){if((e78227 instanceof Object)){
var ex__38347__auto__ = e78227;
var statearr_78228_78245 = state_78206;
(statearr_78228_78245[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78206);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78227;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78246 = state_78206;
state_78206 = G__78246;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_78206){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_78206);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___78234,out))
})();
var state__38459__auto__ = (function (){var statearr_78229 = f__38458__auto__.call(null);
(statearr_78229[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___78234);

return statearr_78229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___78234,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args78247 = [];
var len__10640__auto___78296 = arguments.length;
var i__10641__auto___78297 = (0);
while(true){
if((i__10641__auto___78297 < len__10640__auto___78296)){
args78247.push((arguments[i__10641__auto___78297]));

var G__78298 = (i__10641__auto___78297 + (1));
i__10641__auto___78297 = G__78298;
continue;
} else {
}
break;
}

var G__78249 = args78247.length;
switch (G__78249) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78247.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___78300 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___78300,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___78300,out){
return (function (state_78273){
var state_val_78274 = (state_78273[(1)]);
if((state_val_78274 === (7))){
var inst_78255 = (state_78273[(7)]);
var inst_78255__$1 = (state_78273[(2)]);
var inst_78256 = (inst_78255__$1 == null);
var inst_78257 = cljs.core.not.call(null,inst_78256);
var state_78273__$1 = (function (){var statearr_78275 = state_78273;
(statearr_78275[(7)] = inst_78255__$1);

return statearr_78275;
})();
if(inst_78257){
var statearr_78276_78301 = state_78273__$1;
(statearr_78276_78301[(1)] = (8));

} else {
var statearr_78277_78302 = state_78273__$1;
(statearr_78277_78302[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78274 === (1))){
var inst_78250 = (0);
var state_78273__$1 = (function (){var statearr_78278 = state_78273;
(statearr_78278[(8)] = inst_78250);

return statearr_78278;
})();
var statearr_78279_78303 = state_78273__$1;
(statearr_78279_78303[(2)] = null);

(statearr_78279_78303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78274 === (4))){
var state_78273__$1 = state_78273;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78273__$1,(7),ch);
} else {
if((state_val_78274 === (6))){
var inst_78268 = (state_78273[(2)]);
var state_78273__$1 = state_78273;
var statearr_78280_78304 = state_78273__$1;
(statearr_78280_78304[(2)] = inst_78268);

(statearr_78280_78304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78274 === (3))){
var inst_78270 = (state_78273[(2)]);
var inst_78271 = cljs.core.async.close_BANG_.call(null,out);
var state_78273__$1 = (function (){var statearr_78281 = state_78273;
(statearr_78281[(9)] = inst_78270);

return statearr_78281;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78273__$1,inst_78271);
} else {
if((state_val_78274 === (2))){
var inst_78250 = (state_78273[(8)]);
var inst_78252 = (inst_78250 < n);
var state_78273__$1 = state_78273;
if(cljs.core.truth_(inst_78252)){
var statearr_78282_78305 = state_78273__$1;
(statearr_78282_78305[(1)] = (4));

} else {
var statearr_78283_78306 = state_78273__$1;
(statearr_78283_78306[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78274 === (11))){
var inst_78250 = (state_78273[(8)]);
var inst_78260 = (state_78273[(2)]);
var inst_78261 = (inst_78250 + (1));
var inst_78250__$1 = inst_78261;
var state_78273__$1 = (function (){var statearr_78284 = state_78273;
(statearr_78284[(10)] = inst_78260);

(statearr_78284[(8)] = inst_78250__$1);

return statearr_78284;
})();
var statearr_78285_78307 = state_78273__$1;
(statearr_78285_78307[(2)] = null);

(statearr_78285_78307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78274 === (9))){
var state_78273__$1 = state_78273;
var statearr_78286_78308 = state_78273__$1;
(statearr_78286_78308[(2)] = null);

(statearr_78286_78308[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78274 === (5))){
var state_78273__$1 = state_78273;
var statearr_78287_78309 = state_78273__$1;
(statearr_78287_78309[(2)] = null);

(statearr_78287_78309[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78274 === (10))){
var inst_78265 = (state_78273[(2)]);
var state_78273__$1 = state_78273;
var statearr_78288_78310 = state_78273__$1;
(statearr_78288_78310[(2)] = inst_78265);

(statearr_78288_78310[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78274 === (8))){
var inst_78255 = (state_78273[(7)]);
var state_78273__$1 = state_78273;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78273__$1,(11),out,inst_78255);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___78300,out))
;
return ((function (switch__38343__auto__,c__38457__auto___78300,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_78292 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_78292[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_78292[(1)] = (1));

return statearr_78292;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_78273){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_78273);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e78293){if((e78293 instanceof Object)){
var ex__38347__auto__ = e78293;
var statearr_78294_78311 = state_78273;
(statearr_78294_78311[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78273);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78293;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78312 = state_78273;
state_78273 = G__78312;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_78273){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_78273);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___78300,out))
})();
var state__38459__auto__ = (function (){var statearr_78295 = f__38458__auto__.call(null);
(statearr_78295[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___78300);

return statearr_78295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___78300,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async78320 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async78320 = (function (f,ch,meta78321){
this.f = f;
this.ch = ch;
this.meta78321 = meta78321;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async78320.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_78322,meta78321__$1){
var self__ = this;
var _78322__$1 = this;
return (new cljs.core.async.t_cljs$core$async78320(self__.f,self__.ch,meta78321__$1));
});

cljs.core.async.t_cljs$core$async78320.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_78322){
var self__ = this;
var _78322__$1 = this;
return self__.meta78321;
});

cljs.core.async.t_cljs$core$async78320.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78320.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async78320.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async78320.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78320.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async78323 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async78323 = (function (f,ch,meta78321,_,fn1,meta78324){
this.f = f;
this.ch = ch;
this.meta78321 = meta78321;
this._ = _;
this.fn1 = fn1;
this.meta78324 = meta78324;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async78323.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_78325,meta78324__$1){
var self__ = this;
var _78325__$1 = this;
return (new cljs.core.async.t_cljs$core$async78323(self__.f,self__.ch,self__.meta78321,self__._,self__.fn1,meta78324__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async78323.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_78325){
var self__ = this;
var _78325__$1 = this;
return self__.meta78324;
});})(___$1))
;

cljs.core.async.t_cljs$core$async78323.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78323.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async78323.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async78323.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__78313_SHARP_){
return f1.call(null,(((p1__78313_SHARP_ == null))?null:self__.f.call(null,p1__78313_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async78323.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta78321","meta78321",-30471224,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async78320","cljs.core.async/t_cljs$core$async78320",61936625,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta78324","meta78324",-898544425,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async78323.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async78323.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async78323";

cljs.core.async.t_cljs$core$async78323.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async78323");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async78323 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async78323(f__$1,ch__$1,meta78321__$1,___$2,fn1__$1,meta78324){
return (new cljs.core.async.t_cljs$core$async78323(f__$1,ch__$1,meta78321__$1,___$2,fn1__$1,meta78324));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async78323(self__.f,self__.ch,self__.meta78321,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__9407__auto__ = ret;
if(cljs.core.truth_(and__9407__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__9407__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async78320.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78320.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async78320.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta78321","meta78321",-30471224,null)], null);
});

cljs.core.async.t_cljs$core$async78320.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async78320.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async78320";

cljs.core.async.t_cljs$core$async78320.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async78320");
});

cljs.core.async.__GT_t_cljs$core$async78320 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async78320(f__$1,ch__$1,meta78321){
return (new cljs.core.async.t_cljs$core$async78320(f__$1,ch__$1,meta78321));
});

}

return (new cljs.core.async.t_cljs$core$async78320(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async78329 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async78329 = (function (f,ch,meta78330){
this.f = f;
this.ch = ch;
this.meta78330 = meta78330;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async78329.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_78331,meta78330__$1){
var self__ = this;
var _78331__$1 = this;
return (new cljs.core.async.t_cljs$core$async78329(self__.f,self__.ch,meta78330__$1));
});

cljs.core.async.t_cljs$core$async78329.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_78331){
var self__ = this;
var _78331__$1 = this;
return self__.meta78330;
});

cljs.core.async.t_cljs$core$async78329.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78329.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async78329.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78329.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async78329.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78329.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async78329.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta78330","meta78330",-1145380367,null)], null);
});

cljs.core.async.t_cljs$core$async78329.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async78329.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async78329";

cljs.core.async.t_cljs$core$async78329.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async78329");
});

cljs.core.async.__GT_t_cljs$core$async78329 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async78329(f__$1,ch__$1,meta78330){
return (new cljs.core.async.t_cljs$core$async78329(f__$1,ch__$1,meta78330));
});

}

return (new cljs.core.async.t_cljs$core$async78329(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async78335 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async78335 = (function (p,ch,meta78336){
this.p = p;
this.ch = ch;
this.meta78336 = meta78336;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async78335.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_78337,meta78336__$1){
var self__ = this;
var _78337__$1 = this;
return (new cljs.core.async.t_cljs$core$async78335(self__.p,self__.ch,meta78336__$1));
});

cljs.core.async.t_cljs$core$async78335.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_78337){
var self__ = this;
var _78337__$1 = this;
return self__.meta78336;
});

cljs.core.async.t_cljs$core$async78335.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78335.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async78335.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async78335.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78335.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async78335.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async78335.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async78335.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta78336","meta78336",1171121542,null)], null);
});

cljs.core.async.t_cljs$core$async78335.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async78335.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async78335";

cljs.core.async.t_cljs$core$async78335.cljs$lang$ctorPrWriter = (function (this__10076__auto__,writer__10077__auto__,opt__10078__auto__){
return cljs.core._write.call(null,writer__10077__auto__,"cljs.core.async/t_cljs$core$async78335");
});

cljs.core.async.__GT_t_cljs$core$async78335 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async78335(p__$1,ch__$1,meta78336){
return (new cljs.core.async.t_cljs$core$async78335(p__$1,ch__$1,meta78336));
});

}

return (new cljs.core.async.t_cljs$core$async78335(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args78338 = [];
var len__10640__auto___78382 = arguments.length;
var i__10641__auto___78383 = (0);
while(true){
if((i__10641__auto___78383 < len__10640__auto___78382)){
args78338.push((arguments[i__10641__auto___78383]));

var G__78384 = (i__10641__auto___78383 + (1));
i__10641__auto___78383 = G__78384;
continue;
} else {
}
break;
}

var G__78340 = args78338.length;
switch (G__78340) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78338.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___78386 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___78386,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___78386,out){
return (function (state_78361){
var state_val_78362 = (state_78361[(1)]);
if((state_val_78362 === (7))){
var inst_78357 = (state_78361[(2)]);
var state_78361__$1 = state_78361;
var statearr_78363_78387 = state_78361__$1;
(statearr_78363_78387[(2)] = inst_78357);

(statearr_78363_78387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78362 === (1))){
var state_78361__$1 = state_78361;
var statearr_78364_78388 = state_78361__$1;
(statearr_78364_78388[(2)] = null);

(statearr_78364_78388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78362 === (4))){
var inst_78343 = (state_78361[(7)]);
var inst_78343__$1 = (state_78361[(2)]);
var inst_78344 = (inst_78343__$1 == null);
var state_78361__$1 = (function (){var statearr_78365 = state_78361;
(statearr_78365[(7)] = inst_78343__$1);

return statearr_78365;
})();
if(cljs.core.truth_(inst_78344)){
var statearr_78366_78389 = state_78361__$1;
(statearr_78366_78389[(1)] = (5));

} else {
var statearr_78367_78390 = state_78361__$1;
(statearr_78367_78390[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78362 === (6))){
var inst_78343 = (state_78361[(7)]);
var inst_78348 = p.call(null,inst_78343);
var state_78361__$1 = state_78361;
if(cljs.core.truth_(inst_78348)){
var statearr_78368_78391 = state_78361__$1;
(statearr_78368_78391[(1)] = (8));

} else {
var statearr_78369_78392 = state_78361__$1;
(statearr_78369_78392[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78362 === (3))){
var inst_78359 = (state_78361[(2)]);
var state_78361__$1 = state_78361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78361__$1,inst_78359);
} else {
if((state_val_78362 === (2))){
var state_78361__$1 = state_78361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78361__$1,(4),ch);
} else {
if((state_val_78362 === (11))){
var inst_78351 = (state_78361[(2)]);
var state_78361__$1 = state_78361;
var statearr_78370_78393 = state_78361__$1;
(statearr_78370_78393[(2)] = inst_78351);

(statearr_78370_78393[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78362 === (9))){
var state_78361__$1 = state_78361;
var statearr_78371_78394 = state_78361__$1;
(statearr_78371_78394[(2)] = null);

(statearr_78371_78394[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78362 === (5))){
var inst_78346 = cljs.core.async.close_BANG_.call(null,out);
var state_78361__$1 = state_78361;
var statearr_78372_78395 = state_78361__$1;
(statearr_78372_78395[(2)] = inst_78346);

(statearr_78372_78395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78362 === (10))){
var inst_78354 = (state_78361[(2)]);
var state_78361__$1 = (function (){var statearr_78373 = state_78361;
(statearr_78373[(8)] = inst_78354);

return statearr_78373;
})();
var statearr_78374_78396 = state_78361__$1;
(statearr_78374_78396[(2)] = null);

(statearr_78374_78396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78362 === (8))){
var inst_78343 = (state_78361[(7)]);
var state_78361__$1 = state_78361;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78361__$1,(11),out,inst_78343);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___78386,out))
;
return ((function (switch__38343__auto__,c__38457__auto___78386,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_78378 = [null,null,null,null,null,null,null,null,null];
(statearr_78378[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_78378[(1)] = (1));

return statearr_78378;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_78361){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_78361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e78379){if((e78379 instanceof Object)){
var ex__38347__auto__ = e78379;
var statearr_78380_78397 = state_78361;
(statearr_78380_78397[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78361);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78379;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78398 = state_78361;
state_78361 = G__78398;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_78361){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_78361);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___78386,out))
})();
var state__38459__auto__ = (function (){var statearr_78381 = f__38458__auto__.call(null);
(statearr_78381[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___78386);

return statearr_78381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___78386,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args78399 = [];
var len__10640__auto___78402 = arguments.length;
var i__10641__auto___78403 = (0);
while(true){
if((i__10641__auto___78403 < len__10640__auto___78402)){
args78399.push((arguments[i__10641__auto___78403]));

var G__78404 = (i__10641__auto___78403 + (1));
i__10641__auto___78403 = G__78404;
continue;
} else {
}
break;
}

var G__78401 = args78399.length;
switch (G__78401) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78399.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__38457__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto__){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto__){
return (function (state_78571){
var state_val_78572 = (state_78571[(1)]);
if((state_val_78572 === (7))){
var inst_78567 = (state_78571[(2)]);
var state_78571__$1 = state_78571;
var statearr_78573_78614 = state_78571__$1;
(statearr_78573_78614[(2)] = inst_78567);

(statearr_78573_78614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (20))){
var inst_78537 = (state_78571[(7)]);
var inst_78548 = (state_78571[(2)]);
var inst_78549 = cljs.core.next.call(null,inst_78537);
var inst_78523 = inst_78549;
var inst_78524 = null;
var inst_78525 = (0);
var inst_78526 = (0);
var state_78571__$1 = (function (){var statearr_78574 = state_78571;
(statearr_78574[(8)] = inst_78524);

(statearr_78574[(9)] = inst_78526);

(statearr_78574[(10)] = inst_78523);

(statearr_78574[(11)] = inst_78548);

(statearr_78574[(12)] = inst_78525);

return statearr_78574;
})();
var statearr_78575_78615 = state_78571__$1;
(statearr_78575_78615[(2)] = null);

(statearr_78575_78615[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (1))){
var state_78571__$1 = state_78571;
var statearr_78576_78616 = state_78571__$1;
(statearr_78576_78616[(2)] = null);

(statearr_78576_78616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (4))){
var inst_78512 = (state_78571[(13)]);
var inst_78512__$1 = (state_78571[(2)]);
var inst_78513 = (inst_78512__$1 == null);
var state_78571__$1 = (function (){var statearr_78577 = state_78571;
(statearr_78577[(13)] = inst_78512__$1);

return statearr_78577;
})();
if(cljs.core.truth_(inst_78513)){
var statearr_78578_78617 = state_78571__$1;
(statearr_78578_78617[(1)] = (5));

} else {
var statearr_78579_78618 = state_78571__$1;
(statearr_78579_78618[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (15))){
var state_78571__$1 = state_78571;
var statearr_78583_78619 = state_78571__$1;
(statearr_78583_78619[(2)] = null);

(statearr_78583_78619[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (21))){
var state_78571__$1 = state_78571;
var statearr_78584_78620 = state_78571__$1;
(statearr_78584_78620[(2)] = null);

(statearr_78584_78620[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (13))){
var inst_78524 = (state_78571[(8)]);
var inst_78526 = (state_78571[(9)]);
var inst_78523 = (state_78571[(10)]);
var inst_78525 = (state_78571[(12)]);
var inst_78533 = (state_78571[(2)]);
var inst_78534 = (inst_78526 + (1));
var tmp78580 = inst_78524;
var tmp78581 = inst_78523;
var tmp78582 = inst_78525;
var inst_78523__$1 = tmp78581;
var inst_78524__$1 = tmp78580;
var inst_78525__$1 = tmp78582;
var inst_78526__$1 = inst_78534;
var state_78571__$1 = (function (){var statearr_78585 = state_78571;
(statearr_78585[(8)] = inst_78524__$1);

(statearr_78585[(9)] = inst_78526__$1);

(statearr_78585[(14)] = inst_78533);

(statearr_78585[(10)] = inst_78523__$1);

(statearr_78585[(12)] = inst_78525__$1);

return statearr_78585;
})();
var statearr_78586_78621 = state_78571__$1;
(statearr_78586_78621[(2)] = null);

(statearr_78586_78621[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (22))){
var state_78571__$1 = state_78571;
var statearr_78587_78622 = state_78571__$1;
(statearr_78587_78622[(2)] = null);

(statearr_78587_78622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (6))){
var inst_78512 = (state_78571[(13)]);
var inst_78521 = f.call(null,inst_78512);
var inst_78522 = cljs.core.seq.call(null,inst_78521);
var inst_78523 = inst_78522;
var inst_78524 = null;
var inst_78525 = (0);
var inst_78526 = (0);
var state_78571__$1 = (function (){var statearr_78588 = state_78571;
(statearr_78588[(8)] = inst_78524);

(statearr_78588[(9)] = inst_78526);

(statearr_78588[(10)] = inst_78523);

(statearr_78588[(12)] = inst_78525);

return statearr_78588;
})();
var statearr_78589_78623 = state_78571__$1;
(statearr_78589_78623[(2)] = null);

(statearr_78589_78623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (17))){
var inst_78537 = (state_78571[(7)]);
var inst_78541 = cljs.core.chunk_first.call(null,inst_78537);
var inst_78542 = cljs.core.chunk_rest.call(null,inst_78537);
var inst_78543 = cljs.core.count.call(null,inst_78541);
var inst_78523 = inst_78542;
var inst_78524 = inst_78541;
var inst_78525 = inst_78543;
var inst_78526 = (0);
var state_78571__$1 = (function (){var statearr_78590 = state_78571;
(statearr_78590[(8)] = inst_78524);

(statearr_78590[(9)] = inst_78526);

(statearr_78590[(10)] = inst_78523);

(statearr_78590[(12)] = inst_78525);

return statearr_78590;
})();
var statearr_78591_78624 = state_78571__$1;
(statearr_78591_78624[(2)] = null);

(statearr_78591_78624[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (3))){
var inst_78569 = (state_78571[(2)]);
var state_78571__$1 = state_78571;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78571__$1,inst_78569);
} else {
if((state_val_78572 === (12))){
var inst_78557 = (state_78571[(2)]);
var state_78571__$1 = state_78571;
var statearr_78592_78625 = state_78571__$1;
(statearr_78592_78625[(2)] = inst_78557);

(statearr_78592_78625[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (2))){
var state_78571__$1 = state_78571;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78571__$1,(4),in$);
} else {
if((state_val_78572 === (23))){
var inst_78565 = (state_78571[(2)]);
var state_78571__$1 = state_78571;
var statearr_78593_78626 = state_78571__$1;
(statearr_78593_78626[(2)] = inst_78565);

(statearr_78593_78626[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (19))){
var inst_78552 = (state_78571[(2)]);
var state_78571__$1 = state_78571;
var statearr_78594_78627 = state_78571__$1;
(statearr_78594_78627[(2)] = inst_78552);

(statearr_78594_78627[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (11))){
var inst_78537 = (state_78571[(7)]);
var inst_78523 = (state_78571[(10)]);
var inst_78537__$1 = cljs.core.seq.call(null,inst_78523);
var state_78571__$1 = (function (){var statearr_78595 = state_78571;
(statearr_78595[(7)] = inst_78537__$1);

return statearr_78595;
})();
if(inst_78537__$1){
var statearr_78596_78628 = state_78571__$1;
(statearr_78596_78628[(1)] = (14));

} else {
var statearr_78597_78629 = state_78571__$1;
(statearr_78597_78629[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (9))){
var inst_78559 = (state_78571[(2)]);
var inst_78560 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_78571__$1 = (function (){var statearr_78598 = state_78571;
(statearr_78598[(15)] = inst_78559);

return statearr_78598;
})();
if(cljs.core.truth_(inst_78560)){
var statearr_78599_78630 = state_78571__$1;
(statearr_78599_78630[(1)] = (21));

} else {
var statearr_78600_78631 = state_78571__$1;
(statearr_78600_78631[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (5))){
var inst_78515 = cljs.core.async.close_BANG_.call(null,out);
var state_78571__$1 = state_78571;
var statearr_78601_78632 = state_78571__$1;
(statearr_78601_78632[(2)] = inst_78515);

(statearr_78601_78632[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (14))){
var inst_78537 = (state_78571[(7)]);
var inst_78539 = cljs.core.chunked_seq_QMARK_.call(null,inst_78537);
var state_78571__$1 = state_78571;
if(inst_78539){
var statearr_78602_78633 = state_78571__$1;
(statearr_78602_78633[(1)] = (17));

} else {
var statearr_78603_78634 = state_78571__$1;
(statearr_78603_78634[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (16))){
var inst_78555 = (state_78571[(2)]);
var state_78571__$1 = state_78571;
var statearr_78604_78635 = state_78571__$1;
(statearr_78604_78635[(2)] = inst_78555);

(statearr_78604_78635[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78572 === (10))){
var inst_78524 = (state_78571[(8)]);
var inst_78526 = (state_78571[(9)]);
var inst_78531 = cljs.core._nth.call(null,inst_78524,inst_78526);
var state_78571__$1 = state_78571;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78571__$1,(13),out,inst_78531);
} else {
if((state_val_78572 === (18))){
var inst_78537 = (state_78571[(7)]);
var inst_78546 = cljs.core.first.call(null,inst_78537);
var state_78571__$1 = state_78571;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78571__$1,(20),out,inst_78546);
} else {
if((state_val_78572 === (8))){
var inst_78526 = (state_78571[(9)]);
var inst_78525 = (state_78571[(12)]);
var inst_78528 = (inst_78526 < inst_78525);
var inst_78529 = inst_78528;
var state_78571__$1 = state_78571;
if(cljs.core.truth_(inst_78529)){
var statearr_78605_78636 = state_78571__$1;
(statearr_78605_78636[(1)] = (10));

} else {
var statearr_78606_78637 = state_78571__$1;
(statearr_78606_78637[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto__))
;
return ((function (switch__38343__auto__,c__38457__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____0 = (function (){
var statearr_78610 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78610[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__);

(statearr_78610[(1)] = (1));

return statearr_78610;
});
var cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____1 = (function (state_78571){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_78571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e78611){if((e78611 instanceof Object)){
var ex__38347__auto__ = e78611;
var statearr_78612_78638 = state_78571;
(statearr_78612_78638[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78571);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78611;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78639 = state_78571;
state_78571 = G__78639;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__ = function(state_78571){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____1.call(this,state_78571);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__38344__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto__))
})();
var state__38459__auto__ = (function (){var statearr_78613 = f__38458__auto__.call(null);
(statearr_78613[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto__);

return statearr_78613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto__))
);

return c__38457__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args78640 = [];
var len__10640__auto___78643 = arguments.length;
var i__10641__auto___78644 = (0);
while(true){
if((i__10641__auto___78644 < len__10640__auto___78643)){
args78640.push((arguments[i__10641__auto___78644]));

var G__78645 = (i__10641__auto___78644 + (1));
i__10641__auto___78644 = G__78645;
continue;
} else {
}
break;
}

var G__78642 = args78640.length;
switch (G__78642) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78640.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args78647 = [];
var len__10640__auto___78650 = arguments.length;
var i__10641__auto___78651 = (0);
while(true){
if((i__10641__auto___78651 < len__10640__auto___78650)){
args78647.push((arguments[i__10641__auto___78651]));

var G__78652 = (i__10641__auto___78651 + (1));
i__10641__auto___78651 = G__78652;
continue;
} else {
}
break;
}

var G__78649 = args78647.length;
switch (G__78649) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78647.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args78654 = [];
var len__10640__auto___78705 = arguments.length;
var i__10641__auto___78706 = (0);
while(true){
if((i__10641__auto___78706 < len__10640__auto___78705)){
args78654.push((arguments[i__10641__auto___78706]));

var G__78707 = (i__10641__auto___78706 + (1));
i__10641__auto___78706 = G__78707;
continue;
} else {
}
break;
}

var G__78656 = args78654.length;
switch (G__78656) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78654.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___78709 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___78709,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___78709,out){
return (function (state_78680){
var state_val_78681 = (state_78680[(1)]);
if((state_val_78681 === (7))){
var inst_78675 = (state_78680[(2)]);
var state_78680__$1 = state_78680;
var statearr_78682_78710 = state_78680__$1;
(statearr_78682_78710[(2)] = inst_78675);

(statearr_78682_78710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78681 === (1))){
var inst_78657 = null;
var state_78680__$1 = (function (){var statearr_78683 = state_78680;
(statearr_78683[(7)] = inst_78657);

return statearr_78683;
})();
var statearr_78684_78711 = state_78680__$1;
(statearr_78684_78711[(2)] = null);

(statearr_78684_78711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78681 === (4))){
var inst_78660 = (state_78680[(8)]);
var inst_78660__$1 = (state_78680[(2)]);
var inst_78661 = (inst_78660__$1 == null);
var inst_78662 = cljs.core.not.call(null,inst_78661);
var state_78680__$1 = (function (){var statearr_78685 = state_78680;
(statearr_78685[(8)] = inst_78660__$1);

return statearr_78685;
})();
if(inst_78662){
var statearr_78686_78712 = state_78680__$1;
(statearr_78686_78712[(1)] = (5));

} else {
var statearr_78687_78713 = state_78680__$1;
(statearr_78687_78713[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78681 === (6))){
var state_78680__$1 = state_78680;
var statearr_78688_78714 = state_78680__$1;
(statearr_78688_78714[(2)] = null);

(statearr_78688_78714[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78681 === (3))){
var inst_78677 = (state_78680[(2)]);
var inst_78678 = cljs.core.async.close_BANG_.call(null,out);
var state_78680__$1 = (function (){var statearr_78689 = state_78680;
(statearr_78689[(9)] = inst_78677);

return statearr_78689;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78680__$1,inst_78678);
} else {
if((state_val_78681 === (2))){
var state_78680__$1 = state_78680;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78680__$1,(4),ch);
} else {
if((state_val_78681 === (11))){
var inst_78660 = (state_78680[(8)]);
var inst_78669 = (state_78680[(2)]);
var inst_78657 = inst_78660;
var state_78680__$1 = (function (){var statearr_78690 = state_78680;
(statearr_78690[(10)] = inst_78669);

(statearr_78690[(7)] = inst_78657);

return statearr_78690;
})();
var statearr_78691_78715 = state_78680__$1;
(statearr_78691_78715[(2)] = null);

(statearr_78691_78715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78681 === (9))){
var inst_78660 = (state_78680[(8)]);
var state_78680__$1 = state_78680;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78680__$1,(11),out,inst_78660);
} else {
if((state_val_78681 === (5))){
var inst_78660 = (state_78680[(8)]);
var inst_78657 = (state_78680[(7)]);
var inst_78664 = cljs.core._EQ_.call(null,inst_78660,inst_78657);
var state_78680__$1 = state_78680;
if(inst_78664){
var statearr_78693_78716 = state_78680__$1;
(statearr_78693_78716[(1)] = (8));

} else {
var statearr_78694_78717 = state_78680__$1;
(statearr_78694_78717[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78681 === (10))){
var inst_78672 = (state_78680[(2)]);
var state_78680__$1 = state_78680;
var statearr_78695_78718 = state_78680__$1;
(statearr_78695_78718[(2)] = inst_78672);

(statearr_78695_78718[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78681 === (8))){
var inst_78657 = (state_78680[(7)]);
var tmp78692 = inst_78657;
var inst_78657__$1 = tmp78692;
var state_78680__$1 = (function (){var statearr_78696 = state_78680;
(statearr_78696[(7)] = inst_78657__$1);

return statearr_78696;
})();
var statearr_78697_78719 = state_78680__$1;
(statearr_78697_78719[(2)] = null);

(statearr_78697_78719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___78709,out))
;
return ((function (switch__38343__auto__,c__38457__auto___78709,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_78701 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_78701[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_78701[(1)] = (1));

return statearr_78701;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_78680){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_78680);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e78702){if((e78702 instanceof Object)){
var ex__38347__auto__ = e78702;
var statearr_78703_78720 = state_78680;
(statearr_78703_78720[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78680);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78702;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78721 = state_78680;
state_78680 = G__78721;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_78680){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_78680);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___78709,out))
})();
var state__38459__auto__ = (function (){var statearr_78704 = f__38458__auto__.call(null);
(statearr_78704[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___78709);

return statearr_78704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___78709,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args78722 = [];
var len__10640__auto___78792 = arguments.length;
var i__10641__auto___78793 = (0);
while(true){
if((i__10641__auto___78793 < len__10640__auto___78792)){
args78722.push((arguments[i__10641__auto___78793]));

var G__78794 = (i__10641__auto___78793 + (1));
i__10641__auto___78793 = G__78794;
continue;
} else {
}
break;
}

var G__78724 = args78722.length;
switch (G__78724) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78722.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___78796 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___78796,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___78796,out){
return (function (state_78762){
var state_val_78763 = (state_78762[(1)]);
if((state_val_78763 === (7))){
var inst_78758 = (state_78762[(2)]);
var state_78762__$1 = state_78762;
var statearr_78764_78797 = state_78762__$1;
(statearr_78764_78797[(2)] = inst_78758);

(statearr_78764_78797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78763 === (1))){
var inst_78725 = (new Array(n));
var inst_78726 = inst_78725;
var inst_78727 = (0);
var state_78762__$1 = (function (){var statearr_78765 = state_78762;
(statearr_78765[(7)] = inst_78727);

(statearr_78765[(8)] = inst_78726);

return statearr_78765;
})();
var statearr_78766_78798 = state_78762__$1;
(statearr_78766_78798[(2)] = null);

(statearr_78766_78798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78763 === (4))){
var inst_78730 = (state_78762[(9)]);
var inst_78730__$1 = (state_78762[(2)]);
var inst_78731 = (inst_78730__$1 == null);
var inst_78732 = cljs.core.not.call(null,inst_78731);
var state_78762__$1 = (function (){var statearr_78767 = state_78762;
(statearr_78767[(9)] = inst_78730__$1);

return statearr_78767;
})();
if(inst_78732){
var statearr_78768_78799 = state_78762__$1;
(statearr_78768_78799[(1)] = (5));

} else {
var statearr_78769_78800 = state_78762__$1;
(statearr_78769_78800[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78763 === (15))){
var inst_78752 = (state_78762[(2)]);
var state_78762__$1 = state_78762;
var statearr_78770_78801 = state_78762__$1;
(statearr_78770_78801[(2)] = inst_78752);

(statearr_78770_78801[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78763 === (13))){
var state_78762__$1 = state_78762;
var statearr_78771_78802 = state_78762__$1;
(statearr_78771_78802[(2)] = null);

(statearr_78771_78802[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78763 === (6))){
var inst_78727 = (state_78762[(7)]);
var inst_78748 = (inst_78727 > (0));
var state_78762__$1 = state_78762;
if(cljs.core.truth_(inst_78748)){
var statearr_78772_78803 = state_78762__$1;
(statearr_78772_78803[(1)] = (12));

} else {
var statearr_78773_78804 = state_78762__$1;
(statearr_78773_78804[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78763 === (3))){
var inst_78760 = (state_78762[(2)]);
var state_78762__$1 = state_78762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78762__$1,inst_78760);
} else {
if((state_val_78763 === (12))){
var inst_78726 = (state_78762[(8)]);
var inst_78750 = cljs.core.vec.call(null,inst_78726);
var state_78762__$1 = state_78762;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78762__$1,(15),out,inst_78750);
} else {
if((state_val_78763 === (2))){
var state_78762__$1 = state_78762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78762__$1,(4),ch);
} else {
if((state_val_78763 === (11))){
var inst_78742 = (state_78762[(2)]);
var inst_78743 = (new Array(n));
var inst_78726 = inst_78743;
var inst_78727 = (0);
var state_78762__$1 = (function (){var statearr_78774 = state_78762;
(statearr_78774[(7)] = inst_78727);

(statearr_78774[(8)] = inst_78726);

(statearr_78774[(10)] = inst_78742);

return statearr_78774;
})();
var statearr_78775_78805 = state_78762__$1;
(statearr_78775_78805[(2)] = null);

(statearr_78775_78805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78763 === (9))){
var inst_78726 = (state_78762[(8)]);
var inst_78740 = cljs.core.vec.call(null,inst_78726);
var state_78762__$1 = state_78762;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78762__$1,(11),out,inst_78740);
} else {
if((state_val_78763 === (5))){
var inst_78727 = (state_78762[(7)]);
var inst_78735 = (state_78762[(11)]);
var inst_78730 = (state_78762[(9)]);
var inst_78726 = (state_78762[(8)]);
var inst_78734 = (inst_78726[inst_78727] = inst_78730);
var inst_78735__$1 = (inst_78727 + (1));
var inst_78736 = (inst_78735__$1 < n);
var state_78762__$1 = (function (){var statearr_78776 = state_78762;
(statearr_78776[(12)] = inst_78734);

(statearr_78776[(11)] = inst_78735__$1);

return statearr_78776;
})();
if(cljs.core.truth_(inst_78736)){
var statearr_78777_78806 = state_78762__$1;
(statearr_78777_78806[(1)] = (8));

} else {
var statearr_78778_78807 = state_78762__$1;
(statearr_78778_78807[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78763 === (14))){
var inst_78755 = (state_78762[(2)]);
var inst_78756 = cljs.core.async.close_BANG_.call(null,out);
var state_78762__$1 = (function (){var statearr_78780 = state_78762;
(statearr_78780[(13)] = inst_78755);

return statearr_78780;
})();
var statearr_78781_78808 = state_78762__$1;
(statearr_78781_78808[(2)] = inst_78756);

(statearr_78781_78808[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78763 === (10))){
var inst_78746 = (state_78762[(2)]);
var state_78762__$1 = state_78762;
var statearr_78782_78809 = state_78762__$1;
(statearr_78782_78809[(2)] = inst_78746);

(statearr_78782_78809[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78763 === (8))){
var inst_78735 = (state_78762[(11)]);
var inst_78726 = (state_78762[(8)]);
var tmp78779 = inst_78726;
var inst_78726__$1 = tmp78779;
var inst_78727 = inst_78735;
var state_78762__$1 = (function (){var statearr_78783 = state_78762;
(statearr_78783[(7)] = inst_78727);

(statearr_78783[(8)] = inst_78726__$1);

return statearr_78783;
})();
var statearr_78784_78810 = state_78762__$1;
(statearr_78784_78810[(2)] = null);

(statearr_78784_78810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___78796,out))
;
return ((function (switch__38343__auto__,c__38457__auto___78796,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_78788 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78788[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_78788[(1)] = (1));

return statearr_78788;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_78762){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_78762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e78789){if((e78789 instanceof Object)){
var ex__38347__auto__ = e78789;
var statearr_78790_78811 = state_78762;
(statearr_78790_78811[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78762);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78789;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78812 = state_78762;
state_78762 = G__78812;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_78762){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_78762);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___78796,out))
})();
var state__38459__auto__ = (function (){var statearr_78791 = f__38458__auto__.call(null);
(statearr_78791[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___78796);

return statearr_78791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___78796,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args78813 = [];
var len__10640__auto___78887 = arguments.length;
var i__10641__auto___78888 = (0);
while(true){
if((i__10641__auto___78888 < len__10640__auto___78887)){
args78813.push((arguments[i__10641__auto___78888]));

var G__78889 = (i__10641__auto___78888 + (1));
i__10641__auto___78888 = G__78889;
continue;
} else {
}
break;
}

var G__78815 = args78813.length;
switch (G__78815) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args78813.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__38457__auto___78891 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__38457__auto___78891,out){
return (function (){
var f__38458__auto__ = (function (){var switch__38343__auto__ = ((function (c__38457__auto___78891,out){
return (function (state_78857){
var state_val_78858 = (state_78857[(1)]);
if((state_val_78858 === (7))){
var inst_78853 = (state_78857[(2)]);
var state_78857__$1 = state_78857;
var statearr_78859_78892 = state_78857__$1;
(statearr_78859_78892[(2)] = inst_78853);

(statearr_78859_78892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78858 === (1))){
var inst_78816 = [];
var inst_78817 = inst_78816;
var inst_78818 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_78857__$1 = (function (){var statearr_78860 = state_78857;
(statearr_78860[(7)] = inst_78817);

(statearr_78860[(8)] = inst_78818);

return statearr_78860;
})();
var statearr_78861_78893 = state_78857__$1;
(statearr_78861_78893[(2)] = null);

(statearr_78861_78893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78858 === (4))){
var inst_78821 = (state_78857[(9)]);
var inst_78821__$1 = (state_78857[(2)]);
var inst_78822 = (inst_78821__$1 == null);
var inst_78823 = cljs.core.not.call(null,inst_78822);
var state_78857__$1 = (function (){var statearr_78862 = state_78857;
(statearr_78862[(9)] = inst_78821__$1);

return statearr_78862;
})();
if(inst_78823){
var statearr_78863_78894 = state_78857__$1;
(statearr_78863_78894[(1)] = (5));

} else {
var statearr_78864_78895 = state_78857__$1;
(statearr_78864_78895[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78858 === (15))){
var inst_78847 = (state_78857[(2)]);
var state_78857__$1 = state_78857;
var statearr_78865_78896 = state_78857__$1;
(statearr_78865_78896[(2)] = inst_78847);

(statearr_78865_78896[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78858 === (13))){
var state_78857__$1 = state_78857;
var statearr_78866_78897 = state_78857__$1;
(statearr_78866_78897[(2)] = null);

(statearr_78866_78897[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78858 === (6))){
var inst_78817 = (state_78857[(7)]);
var inst_78842 = inst_78817.length;
var inst_78843 = (inst_78842 > (0));
var state_78857__$1 = state_78857;
if(cljs.core.truth_(inst_78843)){
var statearr_78867_78898 = state_78857__$1;
(statearr_78867_78898[(1)] = (12));

} else {
var statearr_78868_78899 = state_78857__$1;
(statearr_78868_78899[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78858 === (3))){
var inst_78855 = (state_78857[(2)]);
var state_78857__$1 = state_78857;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78857__$1,inst_78855);
} else {
if((state_val_78858 === (12))){
var inst_78817 = (state_78857[(7)]);
var inst_78845 = cljs.core.vec.call(null,inst_78817);
var state_78857__$1 = state_78857;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78857__$1,(15),out,inst_78845);
} else {
if((state_val_78858 === (2))){
var state_78857__$1 = state_78857;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78857__$1,(4),ch);
} else {
if((state_val_78858 === (11))){
var inst_78825 = (state_78857[(10)]);
var inst_78821 = (state_78857[(9)]);
var inst_78835 = (state_78857[(2)]);
var inst_78836 = [];
var inst_78837 = inst_78836.push(inst_78821);
var inst_78817 = inst_78836;
var inst_78818 = inst_78825;
var state_78857__$1 = (function (){var statearr_78869 = state_78857;
(statearr_78869[(11)] = inst_78837);

(statearr_78869[(7)] = inst_78817);

(statearr_78869[(12)] = inst_78835);

(statearr_78869[(8)] = inst_78818);

return statearr_78869;
})();
var statearr_78870_78900 = state_78857__$1;
(statearr_78870_78900[(2)] = null);

(statearr_78870_78900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78858 === (9))){
var inst_78817 = (state_78857[(7)]);
var inst_78833 = cljs.core.vec.call(null,inst_78817);
var state_78857__$1 = state_78857;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_78857__$1,(11),out,inst_78833);
} else {
if((state_val_78858 === (5))){
var inst_78825 = (state_78857[(10)]);
var inst_78821 = (state_78857[(9)]);
var inst_78818 = (state_78857[(8)]);
var inst_78825__$1 = f.call(null,inst_78821);
var inst_78826 = cljs.core._EQ_.call(null,inst_78825__$1,inst_78818);
var inst_78827 = cljs.core.keyword_identical_QMARK_.call(null,inst_78818,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_78828 = (inst_78826) || (inst_78827);
var state_78857__$1 = (function (){var statearr_78871 = state_78857;
(statearr_78871[(10)] = inst_78825__$1);

return statearr_78871;
})();
if(cljs.core.truth_(inst_78828)){
var statearr_78872_78901 = state_78857__$1;
(statearr_78872_78901[(1)] = (8));

} else {
var statearr_78873_78902 = state_78857__$1;
(statearr_78873_78902[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78858 === (14))){
var inst_78850 = (state_78857[(2)]);
var inst_78851 = cljs.core.async.close_BANG_.call(null,out);
var state_78857__$1 = (function (){var statearr_78875 = state_78857;
(statearr_78875[(13)] = inst_78850);

return statearr_78875;
})();
var statearr_78876_78903 = state_78857__$1;
(statearr_78876_78903[(2)] = inst_78851);

(statearr_78876_78903[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78858 === (10))){
var inst_78840 = (state_78857[(2)]);
var state_78857__$1 = state_78857;
var statearr_78877_78904 = state_78857__$1;
(statearr_78877_78904[(2)] = inst_78840);

(statearr_78877_78904[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78858 === (8))){
var inst_78825 = (state_78857[(10)]);
var inst_78821 = (state_78857[(9)]);
var inst_78817 = (state_78857[(7)]);
var inst_78830 = inst_78817.push(inst_78821);
var tmp78874 = inst_78817;
var inst_78817__$1 = tmp78874;
var inst_78818 = inst_78825;
var state_78857__$1 = (function (){var statearr_78878 = state_78857;
(statearr_78878[(14)] = inst_78830);

(statearr_78878[(7)] = inst_78817__$1);

(statearr_78878[(8)] = inst_78818);

return statearr_78878;
})();
var statearr_78879_78905 = state_78857__$1;
(statearr_78879_78905[(2)] = null);

(statearr_78879_78905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38457__auto___78891,out))
;
return ((function (switch__38343__auto__,c__38457__auto___78891,out){
return (function() {
var cljs$core$async$state_machine__38344__auto__ = null;
var cljs$core$async$state_machine__38344__auto____0 = (function (){
var statearr_78883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78883[(0)] = cljs$core$async$state_machine__38344__auto__);

(statearr_78883[(1)] = (1));

return statearr_78883;
});
var cljs$core$async$state_machine__38344__auto____1 = (function (state_78857){
while(true){
var ret_value__38345__auto__ = (function (){try{while(true){
var result__38346__auto__ = switch__38343__auto__.call(null,state_78857);
if(cljs.core.keyword_identical_QMARK_.call(null,result__38346__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__38346__auto__;
}
break;
}
}catch (e78884){if((e78884 instanceof Object)){
var ex__38347__auto__ = e78884;
var statearr_78885_78906 = state_78857;
(statearr_78885_78906[(5)] = ex__38347__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_78857);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e78884;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__38345__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78907 = state_78857;
state_78857 = G__78907;
continue;
} else {
return ret_value__38345__auto__;
}
break;
}
});
cljs$core$async$state_machine__38344__auto__ = function(state_78857){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__38344__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__38344__auto____1.call(this,state_78857);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__38344__auto____0;
cljs$core$async$state_machine__38344__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__38344__auto____1;
return cljs$core$async$state_machine__38344__auto__;
})()
;})(switch__38343__auto__,c__38457__auto___78891,out))
})();
var state__38459__auto__ = (function (){var statearr_78886 = f__38458__auto__.call(null);
(statearr_78886[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38457__auto___78891);

return statearr_78886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__38459__auto__);
});})(c__38457__auto___78891,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map